import { defineComponent as re, useCssVars as ae, computed as m, ref as ue, resolveComponent as de, openBlock as u, createElementBlock as U, normalizeClass as h, unref as n, createVNode as y, withCtx as c, createBlock as g, withModifiers as q, createElementVNode as a, toDisplayString as E, createCommentVNode as p, createTextVNode as W, renderSlot as fe, Fragment as me, renderList as pe } from "vue";
import { ScalarButton as D, ScalarIcon as x, ScalarSidebarGroupToggle as ce, ScalarTooltip as ge } from "@scalar/components";
import { Draggable as ve } from "@scalar/draggable";
import { shouldIgnoreEntity as F } from "@scalar/oas-utils/helpers";
import { useRouter as be, RouterLink as he } from "vue-router";
import { useActiveEntities as ye } from "../../store/active-entities.js";
import { PathId as xe } from "../../routes.js";
import ke from "../../components/HttpMethod/HttpMethod.vue.js";
import { useSidebar as we } from "../../hooks/useSidebar.js";
import { getModifiers as Ue } from "../../libs/hot-keys.js";
import { useWorkspace as qe } from "../../store/store.js";
import { useLayout as De } from "../../hooks/useLayout.js";
const Te = { class: "line-clamp-1 w-full break-all pl-2 font-medium" }, Ce = { class: "flex flex-row items-center gap-1" }, Ie = { class: "relative" }, Re = { class: "flex items-start" }, Me = ["aria-expanded"], Se = { class: "flex h-5 max-w-[14px] items-center justify-center" }, Ee = { class: "flex flex-1 flex-row justify-between" }, $e = { class: "line-clamp-1 w-full break-all text-left font-medium" }, ze = { class: "relative flex h-fit justify-end" }, Ne = { class: "w-content bg-b-1 z-100 text-xxs text-c-1 pointer-events-none z-10 grid max-w-10 gap-1.5 rounded p-2 leading-5 shadow-lg" }, Be = { class: "text-c-2 flex items-center" }, Oe = { class: "text-pretty break-all" }, Pe = { key: 2 }, Y = "hover:bg-sidebar-active-b indent-padding-left", Xe = /* @__PURE__ */ re({
  __name: "RequestSidebarItem",
  props: {
    isDraggable: { type: Boolean, default: !1 },
    isDroppable: { type: [Boolean, Function], default: !1 },
    parentUids: {},
    uid: {},
    menuItem: {}
  },
  emits: ["onDragEnd", "newTab", "openMenu"],
  setup(l, { emit: H }) {
    ae((e) => ({
      "0ff55690": Z.value,
      ecb155a4: _.value
    }));
    const L = H, { activeCollection: G, activeRequest: $, activeRouterParams: J, activeWorkspace: k } = ye(), {
      collections: T,
      tags: z,
      requests: C,
      requestExamples: I,
      collectionMutators: R,
      tagMutators: N,
      requestMutators: B,
      requestExampleMutators: O,
      events: K
    } = qe(), Q = be(), { collapsedSidebarFolders: M, toggleSidebarFolder: X } = we(), { layout: f } = De(), i = m(() => {
      var o, d, v, w;
      const e = T[l.uid], t = z[l.uid], s = C[l.uid], r = I[l.uid];
      return e ? {
        title: ((o = e.info) == null ? void 0 : o.title) ?? "Unknown title",
        entity: e,
        resourceTitle: "Collection",
        children: e.children,
        icon: e["x-scalar-icon"],
        documentUrl: e.documentUrl,
        watchMode: e.watchMode,
        warning: "This cannot be undone. You’re about to delete the collection and all folders and requests inside it.",
        edit: (b, V) => {
          R.edit(e.uid, "info.title", b), V && R.edit(e.uid, "x-scalar-icon", V);
        },
        delete: () => {
          k.value && R.delete(e, k.value);
        }
      } : t ? {
        title: t.name,
        entity: t,
        resourceTitle: "Tag",
        children: t.children,
        warning: "This cannot be undone. You’re about to delete the tag and all requests inside it",
        edit: (b) => N.edit(t.uid, "name", b),
        delete: () => l.parentUids[0] && N.delete(t, l.parentUids[0])
      } : s ? {
        title: s.summary ?? s.path,
        link: {
          name: "request",
          params: {
            workspace: (d = k.value) == null ? void 0 : d.uid,
            request: s.uid
          }
        },
        method: s.method,
        entity: s,
        resourceTitle: "Request",
        warning: "This cannot be undone. You’re about to delete the request.",
        children: s.examples.slice(1),
        edit: (b) => B.edit(s.uid, "summary", b),
        delete: () => l.parentUids[0] && B.delete(s, l.parentUids[0])
      } : r != null && r.requestUid ? {
        title: r.name,
        link: {
          name: "request.examples",
          params: {
            workspace: (v = k.value) == null ? void 0 : v.uid,
            request: r.requestUid,
            examples: r.uid
          }
        },
        method: (w = C[r.requestUid]) == null ? void 0 : w.method,
        entity: r,
        resourceTitle: "Example",
        warning: "This cannot be undone. You’re about to delete the example from the request.",
        children: [],
        edit: (b) => O.edit(r.uid, "name", b),
        delete: () => O.delete(r)
      } : {
        title: "Unknown",
        entity: {
          uid: "",
          type: "unknown"
        },
        resourceTitle: "Unknown",
        children: [],
        edit: () => null,
        delete: () => null
      };
    }), P = m(
      () => i.value.entity.type === "collection" && i.value.title === "Drafts"
    ), Z = m(() => l.parentUids.length ? f === "modal" ? `${(l.parentUids.length - 1) * 12}px` : `${l.parentUids.length * 12}px` : "12px"), _ = m(() => l.parentUids.length ? f === "modal" ? `${(l.parentUids.length - 1) * 12}px` : `${l.parentUids.length * 12}px` : "0px"), ee = m(
      () => {
        var e;
        return M[l.uid] || ((e = $.value) == null ? void 0 : e.uid) === l.uid && i.value.entity.examples.length > 1;
      }
    ), te = m(
      () => {
        var e;
        return J.value[xe.Request] === "default" && ((e = $.value) == null ? void 0 : e.uid) === l.uid;
      }
    ), S = ue(null), j = m(() => {
      let e = 0.5, t = 0.5;
      if (!S.value) return { ceiling: e, floor: t };
      const { draggingItem: s } = S.value;
      return !T[s == null ? void 0 : s.id] && i.value.entity.type === "collection" ? (e = 1, t = 0) : i.value.entity.type === "tag" && (e = 0.8, t = 0.2), { ceiling: e, floor: t };
    }), ie = (e, t) => !(f === "modal" || I[t.id] || T[e.id]), ne = (e, t) => {
      e && (Ue(["default"]).some((o) => e[o]) ? L("newTab", t.title || "", t.entity.uid) : t.link && Q.push(t.link));
    };
    function A() {
      K.commandPalette.emit({
        commandName: "Create Request",
        metaData: {
          itemUid: l.uid,
          parentUid: l.parentUids[0]
        }
      });
    }
    const le = m(() => {
      const { uid: e, watchModeStatus: t } = G.value || {};
      return e !== i.value.entity.uid ? "text-c-3" : t === "WATCHING" ? "text-c-1" : t === "ERROR" ? "text-red" : "text-c-3";
    }), oe = m(() => i.value.title == "Drafts" && f !== "modal" && i.value.children.length > 0), se = m(() => {
      const e = C[l.uid];
      if (e) return !F(e);
      const t = z[l.uid];
      return t ? !F(t) : !0;
    });
    return (e, t) => {
      const s = de("RequestSidebarItem", !0);
      return se.value ? (u(), U("li", {
        key: 0,
        class: h(["relative flex flex-row", [
          n(f) === "modal" && e.parentUids.length > 1 || n(f) !== "modal" && e.parentUids.length ? "before:bg-border before:z-1 indent-border-line-offset mb-[.5px] before:pointer-events-none before:absolute before:left-[calc(.75rem_+_.5px)] before:top-0 before:h-[calc(100%_+_.5px)] before:w-[.5px] last:mb-0 last:before:h-full" : ""
        ]])
      }, [
        y(n(ve), {
          id: i.value.entity.uid,
          ref_key: "draggableRef",
          ref: S,
          ceiling: j.value.ceiling,
          class: "gap-1/2 flex flex-1 flex-col text-sm",
          floor: j.value.floor,
          isDraggable: e.isDraggable,
          isDroppable: e.isDroppable,
          parentIds: e.parentUids,
          onOnDragEnd: t[9] || (t[9] = (...r) => e.$emit("onDragEnd", ...r))
        }, {
          default: c(() => {
            var r;
            return [
              i.value.link ? (u(), g(n(he), {
                key: 0,
                class: "group no-underline",
                to: i.value.link,
                onClick: t[1] || (t[1] = q(
                  (o) => ne(o, i.value),
                  ["prevent"]
                ))
              }, {
                default: c(({ isExactActive: o }) => {
                  var d, v;
                  return [
                    a("div", {
                      class: h(["relative flex min-h-8 w-full cursor-pointer flex-row items-start justify-between gap-0.5 rounded py-1.5 pr-2", [
                        Y,
                        o || te.value ? "bg-sidebar-active-b text-sidebar-active-c transition-none" : "text-sidebar-c-2"
                      ]])
                    }, [
                      a("span", Te, E(i.value.title), 1),
                      a("div", Ce, [
                        a("div", Ie, [
                          n(f) !== "modal" ? (u(), g(n(D), {
                            key: 0,
                            class: h(["hover:bg-b-3 hidden aspect-square h-fit px-0.5 py-0 opacity-0 group-hover:flex group-hover:opacity-100 group-focus-visible:opacity-100 group-has-[:focus-visible]:opacity-100", {
                              flex: ((v = (d = e.menuItem) == null ? void 0 : d.item) == null ? void 0 : v.entity.uid) === i.value.entity.uid && e.menuItem.open
                            }]),
                            size: "sm",
                            type: "button",
                            variant: "ghost",
                            onClick: t[0] || (t[0] = q(
                              (w) => e.$emit("openMenu", {
                                item: i.value,
                                parentUids: e.parentUids,
                                targetRef: w.currentTarget,
                                open: !e.menuItem.open
                              }),
                              ["stop", "prevent"]
                            ))
                          }, {
                            default: c(() => [
                              y(n(x), {
                                icon: "Ellipses",
                                size: "md"
                              })
                            ]),
                            _: 1
                          }, 8, ["class"])) : p("", !0)
                        ]),
                        a("span", Re, [
                          t[10] || (t[10] = W("   ")),
                          t[11] || (t[11] = a("span", { class: "sr-only" }, "HTTP Method:", -1)),
                          i.value.method ? (u(), g(n(ke), {
                            key: 0,
                            class: "font-bold",
                            method: i.value.method
                          }, null, 8, ["method"])) : p("", !0)
                        ])
                      ])
                    ], 2)
                  ];
                }),
                _: 1
              }, 8, ["to"])) : n(f) !== "modal" || e.parentUids.length ? (u(), U("button", {
                key: 1,
                "aria-expanded": !!n(M)[i.value.entity.uid],
                class: h(["hover:bg-b-2 group relative flex w-full flex-row justify-start gap-1.5 rounded p-1.5 focus-visible:z-10", [Y]]),
                type: "button",
                onClick: t[4] || (t[4] = (o) => n(X)(i.value.entity.uid))
              }, [
                a("span", Se, [
                  fe(e.$slots, "leftIcon", {}, () => [
                    y(n(ce), {
                      class: "text-c-3 hover:text-c-1 shrink-0",
                      open: !!n(M)[i.value.entity.uid]
                    }, null, 8, ["open"])
                  ], !0),
                  t[12] || (t[12] = W("   "))
                ]),
                a("div", Ee, [
                  a("span", $e, E(i.value.title), 1),
                  a("div", ze, [
                    a("div", {
                      class: h(["items-center gap-px opacity-0 group-hover:flex group-hover:opacity-100 group-focus-visible:opacity-100 group-has-[:focus-visible]:opacity-100", {
                        flex: e.menuItem.open,
                        hidden: !e.menuItem.open || ((r = e.menuItem.item) == null ? void 0 : r.entity.uid) !== i.value.entity.uid
                      }])
                    }, [
                      n(f) !== "modal" && !P.value || P.value && oe.value ? (u(), g(n(D), {
                        key: 0,
                        class: "hover:bg-b-3 hover:text-c-1 aspect-square h-fit px-0.5 py-0 group-focus-visible:opacity-100 group-has-[:focus-visible]:opacity-100",
                        size: "sm",
                        variant: "ghost",
                        onClick: t[2] || (t[2] = q(
                          (o) => e.$emit("openMenu", {
                            item: i.value,
                            parentUids: e.parentUids,
                            targetRef: o.currentTarget.parentNode,
                            open: !0
                          }),
                          ["stop", "prevent"]
                        ))
                      }, {
                        default: c(() => [
                          y(n(x), {
                            icon: "Ellipses",
                            size: "md"
                          })
                        ]),
                        _: 1
                      })) : p("", !0),
                      n(f) !== "modal" ? (u(), g(n(D), {
                        key: 1,
                        class: "hover:bg-b-3 hover:text-c-1 aspect-square h-fit px-0.5 py-0 group-focus-visible:opacity-100 group-has-[:focus-visible]:opacity-100",
                        size: "sm",
                        variant: "ghost",
                        onClick: t[3] || (t[3] = q((o) => A(), ["stop", "prevent"]))
                      }, {
                        default: c(() => [
                          y(n(x), {
                            icon: "Add",
                            size: "md",
                            thickness: "2"
                          })
                        ]),
                        _: 1
                      })) : p("", !0)
                    ], 2),
                    i.value.watchMode ? (u(), g(n(ge), {
                      key: 0,
                      side: "right",
                      sideOffset: 12
                    }, {
                      trigger: c(() => [
                        y(n(x), {
                          class: h(["ml-0.5 text-sm", le.value]),
                          icon: "Watch",
                          size: "md",
                          thickness: "2"
                        }, null, 8, ["class"])
                      ]),
                      content: c(() => [
                        a("div", Ne, [
                          a("div", Be, [
                            a("p", Oe, " Watching: " + E(i.value.documentUrl), 1)
                          ])
                        ])
                      ]),
                      _: 1
                    })) : p("", !0),
                    t[13] || (t[13] = a("span", null, " ", -1))
                  ])
                ])
              ], 10, Me)) : p("", !0),
              ee.value ? (u(), U("ul", Pe, [
                (u(!0), U(me, null, pe(i.value.children, (o) => (u(), g(s, {
                  key: o,
                  isDraggable: !n(I)[o],
                  isDroppable: ie,
                  menuItem: e.menuItem,
                  parentUids: [...e.parentUids, e.uid],
                  uid: o,
                  onNewTab: t[5] || (t[5] = (d, v) => e.$emit("newTab", d, v)),
                  onOnDragEnd: t[6] || (t[6] = (...d) => e.$emit("onDragEnd", ...d)),
                  onOpenMenu: t[7] || (t[7] = (d) => e.$emit("openMenu", d))
                }, null, 8, ["isDraggable", "menuItem", "parentUids", "uid"]))), 128)),
                i.value.children.length === 0 ? (u(), g(n(D), {
                  key: 0,
                  class: h(["text-c-1 hover:bg-b-2 flex h-8 w-full justify-start gap-1.5 py-0 text-xs", e.parentUids.length ? "pl-9" : ""]),
                  variant: "ghost",
                  onClick: t[8] || (t[8] = (o) => A())
                }, {
                  default: c(() => [
                    y(n(x), {
                      icon: "Add",
                      size: "sm"
                    }),
                    t[14] || (t[14] = a("span", null, "Add Request", -1))
                  ]),
                  _: 1
                }, 8, ["class"])) : p("", !0)
              ])) : p("", !0)
            ];
          }),
          _: 3
        }, 8, ["id", "ceiling", "floor", "isDraggable", "isDroppable", "parentIds"])
      ], 2)) : p("", !0);
    };
  }
});
export {
  Xe as default
};
