import type { RequestExampleParameter } from '@scalar/oas-utils/entities/spec';
/**
 * Check if a RequestExampleParameter has any of the following properties:
 * - description
 * - type
 * - default
 * - format
 * - minimum
 * - maximum
 */
export declare const hasItemProperties: (item: RequestExampleParameter) => boolean;
/**
 * Checks if the value of a RequestExampleParameter is the expected type or format
 * Returns an alert message if the value is not in the correct type or format, otherwise false
 */
export declare const parameterIsInvalid: (item: RequestExampleParameter) => import("vue").ComputedRef<string | false>;
//# sourceMappingURL=request.d.ts.map