import { defineComponent as Q, useAttrs as G, ref as u, computed as m, toRef as r, watch as X, createElementBlock as s, openBlock as n, Fragment as Y, createBlock as g, createCommentVNode as d, normalizeClass as Z, unref as p, createElementVNode as c, toDisplayString as _, mergeProps as ee, withKeys as v, withModifiers as N, createVNode as oe, createTextVNode as k, renderSlot as R } from "vue";
import { ScalarIcon as le } from "@scalar/components";
import { prettyPrintJson as te } from "@scalar/oas-utils/helpers";
import { useCodeMirror as ne, useDropdown as ae, colorPicker as re } from "@scalar/use-codemirror";
import { useClipboard as se } from "@scalar/use-hooks/useClipboard";
import { nanoid as ie } from "nanoid";
import ue from "../../views/Environment/EnvironmentVariableDropdown.vue.js";
import B from "../DataTable/DataTableInputSelect.vue.js";
import { pillPlugin as de, backspaceCommand as pe } from "./codeVariableWidget.js";
import { useLayout as fe } from "../../hooks/useLayout.js";
const me = { class: "whitespace-nowrap" }, ce = ["id"], be = {
  key: 0,
  class: "scalar-code-copy z-context"
}, ye = {
  key: 1,
  class: "z-context text-c-2 absolute right-1.5 bottom-1 hidden font-sans group-has-[:focus-visible]/input:block",
  role: "alert"
}, ge = {
  key: 5,
  class: "centered-y text-orange absolute right-7 text-xs"
}, ve = {
  key: 6,
  class: "centered-y absolute right-0 flex h-full items-center p-1.5 group-has-[.cm-focused]:z-1"
}, he = {
  key: 7,
  class: "required centered-y text-xxs text-c-3 group-[.error]:text-red bg-b-1 pointer-events-none absolute right-0 mr-0.5 pt-px pr-2 opacity-100 shadow-[-8px_0_4px_var(--scalar-background-1)] transition-opacity duration-150 group-[.alert]:bg-transparent group-[.alert]:shadow-none group-[.error]:bg-transparent group-[.error]:shadow-none peer-has-[.cm-focused]:opacity-0"
}, we = {
  inheritAttrs: !1
}, Fe = /* @__PURE__ */ Q({
  ...we,
  __name: "CodeInput",
  props: {
    colorPicker: { type: Boolean, default: !1 },
    disabled: { type: Boolean, default: !1 },
    modelValue: {},
    error: { type: Boolean },
    emitOnBlur: { type: Boolean, default: !0 },
    extensions: { default: () => [] },
    lineNumbers: { type: Boolean },
    lint: { type: Boolean },
    disableTabIndent: { type: Boolean, default: !1 },
    language: {},
    handleFieldSubmit: {},
    handleFieldChange: {},
    placeholder: {},
    required: { type: Boolean },
    disableEnter: { type: Boolean, default: !1 },
    disableCloseBrackets: { type: Boolean, default: !1 },
    enum: {},
    examples: {},
    type: {},
    nullable: { type: Boolean, default: !1 },
    withVariables: { type: Boolean, default: !0 },
    importCurl: { type: Boolean },
    isCopyable: { type: Boolean, default: !1 },
    default: {},
    environment: {},
    envVariables: {},
    workspace: {},
    lineWrapping: { type: Boolean, default: !1 }
  },
  emits: ["submit", "update:modelValue", "curl", "blur"],
  setup(z, { expose: A, emit: M }) {
    var q;
    const o = z, i = M, C = G(), O = C.id || `id-${ie()}`, x = u(!1), h = u(!1), P = u(""), S = u({ left: 0, top: 0 }), b = u(null), { layout: w } = fe(), { copyToClipboard: K } = se();
    function D(e) {
      var l;
      return e === o.modelValue ? null : o.importCurl && e.trim().toLowerCase().startsWith("curl") ? (i("curl", e), (l = a.value) == null || l.dispatch({
        changes: {
          from: 0,
          to: a.value.state.doc.length,
          insert: String(o.modelValue)
        }
      }), null) : o.handleFieldChange ? o.handleFieldChange(e) : i("update:modelValue", e);
    }
    function V(e) {
      return o.handleFieldSubmit ? o.handleFieldSubmit(e) : i("submit", e);
    }
    function T(e) {
      x.value = !1, o.emitOnBlur && o.modelValue && V(e), i("blur", e);
    }
    const E = [...o.extensions];
    o.colorPicker && E.push(re);
    const L = m(
      () => de({
        environment: o.environment,
        envVariables: o.envVariables,
        workspace: o.workspace,
        isReadOnly: w === "modal"
      })
    ), U = m(() => [
      ...E,
      L.value,
      pe
    ]), F = u(null), { codeMirror: a } = ne({
      content: r(
        () => o.modelValue !== void 0 ? String(o.modelValue) : ""
      ),
      onChange: (e) => {
        D(e), j();
      },
      onFocus: () => x.value = !0,
      onBlur: (e) => T(e),
      codeMirrorRef: F,
      disableTabIndent: r(() => o.disableTabIndent),
      disableEnter: r(() => o.disableEnter),
      disableCloseBrackets: r(() => o.disableCloseBrackets),
      lineNumbers: r(() => o.lineNumbers),
      language: r(() => o.language),
      lint: r(() => o.lint),
      extensions: U,
      placeholder: r(() => o.placeholder)
    });
    (q = a.value) == null || q.focus(), X(a, () => {
      a.value && Object.prototype.hasOwnProperty.call(C, "autofocus") && a.value.focus();
    });
    const { handleDropdownSelect: W, updateDropdownVisibility: j } = ae({
      codeMirror: a,
      query: P,
      showDropdown: h,
      dropdownPosition: S
    }), $ = m(
      () => o.nullable ? ["true", "false", "null"] : ["true", "false"]
    ), y = (e, l) => {
      var f, t, I;
      h.value ? e === "down" ? (l.preventDefault(), (f = b.value) == null || f.handleArrowKey("down")) : e === "up" ? (l.preventDefault(), (t = b.value) == null || t.handleArrowKey("up")) : e === "enter" && (l.preventDefault(), (I = b.value) == null || I.handleSelect()) : e === "escape" ? o.disableTabIndent || l.stopPropagation() : e === "enter" && l.target instanceof HTMLDivElement && V(l.target.textContent ?? "");
    }, H = m(() => Array.isArray(o.type) ? (
      // Find the first type, that’s not 'null'
      o.type.find((e) => e !== "null") ?? "string"
    ) : (
      // If it’s not an array, just return the type
      o.type
    )), J = m(
      () => h.value && o.withVariables && w !== "modal" && o.environment
    );
    return A({
      /** Expose focus method */
      focus: () => {
        var e;
        (e = a.value) == null || e.focus();
      },
      // Expose these methods for testing
      handleChange: D,
      handleSubmit: V,
      handleBlur: T,
      booleanOptions: $,
      codeMirror: a,
      modelValue: o.modelValue
    }), (e, l) => {
      var f;
      return n(), s(Y, null, [
        e.disabled ? (n(), s("div", {
          key: 0,
          class: Z(["text-c-2 flex cursor-default items-center justify-center", p(w) === "modal" ? "font-code pr-2 pl-1 text-sm" : "px-2"]),
          "data-testid": "code-input-disabled"
        }, [
          c("span", me, _(e.modelValue), 1)
        ], 2)) : o.enum && o.enum.length ? (n(), g(B, {
          key: 1,
          default: o.default,
          modelValue: e.modelValue,
          type: H.value,
          value: o.enum,
          "onUpdate:modelValue": l[0] || (l[0] = (t) => i("update:modelValue", t))
        }, null, 8, ["default", "modelValue", "type", "value"])) : e.type === "boolean" || (f = e.type) != null && f.includes("boolean") ? (n(), g(B, {
          key: 2,
          default: o.default,
          modelValue: e.modelValue,
          value: $.value,
          "onUpdate:modelValue": l[1] || (l[1] = (t) => i("update:modelValue", t))
        }, null, 8, ["default", "modelValue", "value"])) : o.examples && o.examples.length ? (n(), g(B, {
          key: 3,
          default: o.default,
          modelValue: o.modelValue,
          value: o.examples,
          "onUpdate:modelValue": l[2] || (l[2] = (t) => i("update:modelValue", t))
        }, null, 8, ["default", "modelValue", "value"])) : (n(), s("div", ee({
          key: 4,
          id: p(O)
        }, e.$attrs, {
          ref_key: "codeMirrorRef",
          ref: F,
          class: ["group/input group-[.alert]:outline-orange group-[.error]:outline-red font-code peer relative w-full overflow-hidden text-xs leading-[1.44] whitespace-nowrap -outline-offset-1 has-[:focus-visible]:rounded-[4px] has-[:focus-visible]:outline", {
            "line-wrapping has-[:focus-visible]:bg-b-1 has-[:focus-visible]:absolute has-[:focus-visible]:z-1": e.lineWrapping,
            "flow-code-input--error": e.error
          }],
          onKeydown: [
            l[4] || (l[4] = v(N((t) => y("down", t), ["stop"]), ["down"])),
            l[5] || (l[5] = v((t) => y("enter", t), ["enter"])),
            l[6] || (l[6] = v((t) => y("escape", t), ["escape"])),
            l[7] || (l[7] = v(N((t) => y("up", t), ["stop"]), ["up"]))
          ]
        }), [
          e.isCopyable ? (n(), s("div", be, [
            c("button", {
              class: "copy-button",
              type: "button",
              onClick: l[3] || (l[3] = (t) => p(K)(p(te)(e.modelValue)))
            }, [
              l[8] || (l[8] = c("span", { class: "sr-only" }, "Copy content", -1)),
              oe(p(le), {
                icon: "Clipboard",
                size: "md"
              })
            ])
          ])) : d("", !0),
          e.disableTabIndent ? d("", !0) : (n(), s("div", ye, l[9] || (l[9] = [
            k(" Press "),
            c("kbd", { class: "-mx-0.25 rounded border px-0.5 font-mono" }, "Esc", -1),
            k(" then "),
            c("kbd", { class: "-mx-0.25 rounded border px-0.5 font-mono" }, "Tab", -1),
            k(" to exit ")
          ])))
        ], 16, ce)),
        e.$slots.warning ? (n(), s("div", ge, [
          R(e.$slots, "warning", {}, void 0, !0)
        ])) : d("", !0),
        e.$slots.icon ? (n(), s("div", ve, [
          R(e.$slots, "icon", {}, void 0, !0)
        ])) : d("", !0),
        e.required ? (n(), s("div", he, " Required ")) : d("", !0),
        J.value ? (n(), g(ue, {
          key: 8,
          ref_key: "dropdownRef",
          ref: b,
          dropdownPosition: S.value,
          envVariables: e.envVariables,
          environment: e.environment,
          query: P.value,
          onSelect: p(W)
        }, null, 8, ["dropdownPosition", "envVariables", "environment", "query", "onSelect"])) : d("", !0)
      ], 64);
    };
  }
});
export {
  Fe as default
};
