import { defineComponent as N, ref as p, computed as h, createBlock as u, openBlock as c, withCtx as l, createVNode as m, createTextVNode as B, unref as s, createElementVNode as f, normalizeClass as M, toDisplayString as T } from "vue";
import { ScalarListbox as j, ScalarButton as b, ScalarIcon as z } from "@scalar/components";
import { useToasts as E } from "@scalar/use-toasts";
import { useRouter as I } from "vue-router";
import { useActiveEntities as L } from "../../store/active-entities.js";
import R from "./CommandActionForm.vue.js";
import W from "./CommandActionInput.vue.js";
import { PathId as C } from "../../routes.js";
import { useWorkspace as $ } from "../../store/store.js";
const X = /* @__PURE__ */ N({
  __name: "CommandPaletteServer",
  props: {
    metaData: {}
  },
  emits: ["close", "back"],
  setup(x, { emit: S }) {
    const n = x, d = S, k = I(), { toast: v } = E(), { activeCollection: V, activeWorkspaceCollections: g } = L(), {
      collectionMutators: D,
      serverMutators: U,
      events: w,
      collections: y
    } = $(), r = p(""), i = h(
      () => g.value.flatMap(
        (t) => {
          var e, o;
          return ((e = t.info) == null ? void 0 : e.title) === "Drafts" ? [] : {
            id: t.uid,
            label: ((o = t.info) == null ? void 0 : o.title) ?? "Unititled Collection"
          };
        }
      )
    ), a = p(
      n.metaData ? i.value.find(
        (t) => {
          var e, o;
          return t.id === ((e = n.metaData) == null ? void 0 : e.itemUid) || t.id === ((o = n.metaData) == null ? void 0 : o.parentUid);
        }
      ) : i.value.find(
        (t) => {
          var e;
          return t.id === ((e = V.value) == null ? void 0 : e.uid);
        }
      )
    ), P = () => {
      var o;
      if (!r.value.trim()) {
        v("Please enter a valid url before creating a server.", "error");
        return;
      }
      const t = y[((o = a.value) == null ? void 0 : o.id) ?? ""];
      if (!t) {
        v("Please select a collection before creating a server.", "error");
        return;
      }
      const e = U.add({ url: r.value }, t.uid);
      D.edit(t.uid, "selectedServerUid", e.uid), k.push({
        name: "collection.servers.edit",
        params: {
          [C.Collection]: t.uid,
          [C.Servers]: e.uid
        }
      }), d("close");
    }, _ = () => {
      w.commandPalette.emit({ commandName: "Create Collection" });
    };
    return (t, e) => (c(), u(R, {
      disabled: !r.value.trim() || !a.value,
      onSubmit: P
    }, {
      options: l(() => [
        m(s(j), {
          modelValue: a.value,
          "onUpdate:modelValue": e[2] || (e[2] = (o) => a.value = o),
          options: i.value
        }, {
          default: l(() => [
            i.value.length > 0 ? (c(), u(s(b), {
              key: 0,
              class: "hover:bg-b-2 max-h-8 w-fit justify-between gap-1 p-2 text-xs",
              variant: "outlined"
            }, {
              default: l(() => [
                f("span", {
                  class: M(a.value ? "text-c-1" : "text-c-3")
                }, T(a.value ? a.value.label : "Select Collection"), 3),
                m(s(z), {
                  class: "text-c-3",
                  icon: "ChevronDown",
                  size: "md"
                })
              ]),
              _: 1
            })) : (c(), u(s(b), {
              key: 1,
              class: "hover:bg-b-2 max-h-8 w-fit justify-between gap-1 p-2 text-xs",
              variant: "outlined",
              onClick: _
            }, {
              default: l(() => e[3] || (e[3] = [
                f("span", { class: "text-c-1" }, "Create Collection", -1)
              ])),
              _: 1
            }))
          ]),
          _: 1
        }, 8, ["modelValue", "options"])
      ]),
      submit: l(() => e[4] || (e[4] = [
        B(" Create Server ")
      ])),
      default: l(() => [
        m(W, {
          modelValue: r.value,
          "onUpdate:modelValue": e[0] || (e[0] = (o) => r.value = o),
          label: "Server URL",
          placeholder: "https://void.scalar.com",
          onOnDelete: e[1] || (e[1] = (o) => d("back", o))
        }, null, 8, ["modelValue"])
      ]),
      _: 1
    }, 8, ["disabled"]));
  }
});
export {
  X as default
};
