import { defineComponent as c, createBlock as n, openBlock as i, withCtx as d, createElementVNode as a, normalizeClass as t, unref as l, createVNode as u } from "vue";
import { cva as p, ScalarIcon as m } from "@scalar/components";
import b from "./DataTableCell.vue.js";
const f = ["checked", "disabled"], y = /* @__PURE__ */ c({
  __name: "DataTableCheckbox",
  props: {
    modelValue: { type: Boolean },
    disabled: { type: Boolean },
    align: { default: "center" }
  },
  emits: ["update:modelValue"],
  setup(h) {
    const s = p({
      base: "w-8 h-8 flex items-center justify-center text-border peer-checked:text-c-1 pointer-events-none absolute",
      variants: {
        align: {
          left: "left-0",
          center: "centered"
        }
      }
    });
    return (e, o) => (i(), n(b, { class: "group/cell relative flex min-w-8" }, {
      default: d(() => [
        a("input", {
          checked: e.modelValue,
          class: "peer absolute inset-0 cursor-pointer opacity-0 disabled:cursor-default",
          disabled: !!e.disabled,
          type: "checkbox",
          onChange: o[0] || (o[0] = (r) => e.$emit("update:modelValue", r.target.checked))
        }, null, 40, f),
        a("div", {
          class: t(l(s)({ align: e.align }))
        }, [
          a("div", {
            class: t([
              "absolute m-auto size-3/4 rounded border-[1px] opacity-0",
              !e.disabled && "group-has-[:focus-visible]/cell:border-c-accent group-hover/cell:opacity-100 group-has-[:focus-visible]/cell:opacity-100"
            ])
          }, null, 2),
          u(l(m), {
            icon: "Checkmark",
            size: "xs",
            thickness: "2.5"
          })
        ], 2)
      ]),
      _: 1
    }));
  }
});
export {
  y as default
};
