import type { Environment } from '@scalar/oas-utils/entities/environment';
import type { Workspace } from '@scalar/oas-utils/entities/workspace';
import type { EnvVariable } from '../../store/active-entities';
import type { VueClassProp } from '../../types/vue';
type __VLS_Props = {
    id?: string;
    type?: string | undefined;
    /** Class for the wrapping cell because attrs is bound to the input */
    containerClass?: VueClassProp | undefined;
    required?: boolean;
    modelValue: string | number;
    /** Allows adding a custom value to the enum dropdown, defaults to true */
    canAddCustomEnumValue?: boolean;
    readOnly?: boolean;
    enum?: string[];
    min?: number;
    max?: number;
    environment: Environment;
    envVariables: EnvVariable[];
    workspace: Workspace;
    description?: string | undefined;
    lineWrapping?: boolean;
};
declare function __VLS_template(): {
    attrs: Partial<{}>;
    slots: {
        default?(_: {}): any;
        warning?(_: {}): any;
        icon?(_: {}): any;
    };
    refs: {
        codeInput: ({
            $: import("vue").ComponentInternalInstance;
            $data: {};
            $props: {
                readonly colorPicker?: boolean;
                readonly disabled?: boolean;
                readonly modelValue: string | number;
                readonly error?: boolean;
                readonly emitOnBlur?: boolean;
                readonly extensions?: import("@codemirror/state").Extension[];
                readonly lineNumbers?: boolean;
                readonly lint?: boolean;
                readonly disableTabIndent?: boolean;
                readonly language?: import("@scalar/use-codemirror").CodeMirrorLanguage;
                readonly handleFieldSubmit?: (e: string) => void;
                readonly handleFieldChange?: (e: string) => void;
                readonly placeholder?: string;
                readonly required?: boolean;
                readonly disableEnter?: boolean;
                readonly disableCloseBrackets?: boolean;
                readonly enum?: string[];
                readonly examples?: string[];
                readonly type?: string | string[] | undefined;
                readonly nullable?: boolean;
                readonly withVariables?: boolean;
                readonly importCurl?: boolean;
                readonly isCopyable?: boolean;
                readonly default?: string | number;
                readonly environment: Environment;
                readonly envVariables: EnvVariable[];
                readonly workspace: Workspace;
                readonly lineWrapping?: boolean;
                readonly onSubmit?: (v: string) => any;
                readonly "onUpdate:modelValue"?: (v: string) => any;
                readonly onBlur?: (v: string) => any;
                readonly onCurl?: (v: string) => any;
            } & import("vue").VNodeProps & import("vue").AllowedComponentProps & import("vue").ComponentCustomProps;
            $attrs: {
                [x: string]: unknown;
            };
            $refs: {
                [x: string]: unknown;
            };
            $slots: Readonly<{
                [name: string]: import("vue").Slot<any> | undefined;
            }>;
            $root: import("vue").ComponentPublicInstance | null;
            $parent: import("vue").ComponentPublicInstance | null;
            $host: Element | null;
            $emit: ((event: "submit", v: string) => void) & ((event: "update:modelValue", v: string) => void) & ((event: "blur", v: string) => void) & ((event: "curl", v: string) => void);
            $el: any;
            $options: import("vue").ComponentOptionsBase<Readonly<{
                colorPicker?: boolean;
                disabled?: boolean;
                modelValue: string | number;
                error?: boolean;
                emitOnBlur?: boolean;
                extensions?: import("@codemirror/state").Extension[];
                lineNumbers?: boolean;
                lint?: boolean;
                disableTabIndent?: boolean;
                language?: import("@scalar/use-codemirror").CodeMirrorLanguage;
                handleFieldSubmit?: (e: string) => void;
                handleFieldChange?: (e: string) => void;
                placeholder?: string;
                required?: boolean;
                disableEnter?: boolean;
                disableCloseBrackets?: boolean;
                enum?: string[];
                examples?: string[];
                type?: string | string[] | undefined;
                nullable?: boolean;
                withVariables?: boolean;
                importCurl?: boolean;
                isCopyable?: boolean;
                default?: string | number;
                environment: Environment;
                envVariables: EnvVariable[];
                workspace: Workspace;
                lineWrapping?: boolean;
            }> & Readonly<{
                onSubmit?: (v: string) => any;
                "onUpdate:modelValue"?: (v: string) => any;
                onBlur?: (v: string) => any;
                onCurl?: (v: string) => any;
            }>, {
                focus: () => void;
                handleChange: (value: string) => void | null;
                handleSubmit: (value: string) => void;
                handleBlur: (value: string) => void;
                booleanOptions: import("vue").ComputedRef<string[]>;
                codeMirror: import("vue").Ref<import("@codemirror/view").EditorView | null, import("@codemirror/view").EditorView | null>;
                modelValue: string | number;
            }, {}, {}, {}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, {} & {
                submit: (v: string) => any;
                "update:modelValue": (v: string) => any;
                blur: (v: string) => any;
                curl: (v: string) => any;
            }, string, {
                nullable: boolean;
                disabled: boolean;
                colorPicker: boolean;
                emitOnBlur: boolean;
                extensions: import("@codemirror/state").Extension[];
                disableTabIndent: boolean;
                disableEnter: boolean;
                disableCloseBrackets: boolean;
                withVariables: boolean;
                isCopyable: boolean;
                lineWrapping: boolean;
            }, {}, string, {}, import("vue").GlobalComponents, import("vue").GlobalDirectives, string, import("vue").ComponentProvideOptions> & {
                beforeCreate?: (() => void) | (() => void)[];
                created?: (() => void) | (() => void)[];
                beforeMount?: (() => void) | (() => void)[];
                mounted?: (() => void) | (() => void)[];
                beforeUpdate?: (() => void) | (() => void)[];
                updated?: (() => void) | (() => void)[];
                activated?: (() => void) | (() => void)[];
                deactivated?: (() => void) | (() => void)[];
                beforeDestroy?: (() => void) | (() => void)[];
                beforeUnmount?: (() => void) | (() => void)[];
                destroyed?: (() => void) | (() => void)[];
                unmounted?: (() => void) | (() => void)[];
                renderTracked?: ((e: import("vue").DebuggerEvent) => void) | ((e: import("vue").DebuggerEvent) => void)[];
                renderTriggered?: ((e: import("vue").DebuggerEvent) => void) | ((e: import("vue").DebuggerEvent) => void)[];
                errorCaptured?: ((err: unknown, instance: import("vue").ComponentPublicInstance | null, info: string) => boolean | void) | ((err: unknown, instance: import("vue").ComponentPublicInstance | null, info: string) => boolean | void)[];
            };
            $forceUpdate: () => void;
            $nextTick: typeof import("vue").nextTick;
            $watch<T extends string | ((...args: any) => any)>(source: T, cb: T extends (...args: any) => infer R ? (...args: [R, R, import("@vue/reactivity").OnCleanup]) => any : (...args: [any, any, import("@vue/reactivity").OnCleanup]) => any, options?: import("vue").WatchOptions): import("vue").WatchStopHandle;
        } & Readonly<{
            nullable: boolean;
            disabled: boolean;
            colorPicker: boolean;
            emitOnBlur: boolean;
            extensions: import("@codemirror/state").Extension[];
            disableTabIndent: boolean;
            disableEnter: boolean;
            disableCloseBrackets: boolean;
            withVariables: boolean;
            isCopyable: boolean;
            lineWrapping: boolean;
        }> & Omit<Readonly<{
            colorPicker?: boolean;
            disabled?: boolean;
            modelValue: string | number;
            error?: boolean;
            emitOnBlur?: boolean;
            extensions?: import("@codemirror/state").Extension[];
            lineNumbers?: boolean;
            lint?: boolean;
            disableTabIndent?: boolean;
            language?: import("@scalar/use-codemirror").CodeMirrorLanguage;
            handleFieldSubmit?: (e: string) => void;
            handleFieldChange?: (e: string) => void;
            placeholder?: string;
            required?: boolean;
            disableEnter?: boolean;
            disableCloseBrackets?: boolean;
            enum?: string[];
            examples?: string[];
            type?: string | string[] | undefined;
            nullable?: boolean;
            withVariables?: boolean;
            importCurl?: boolean;
            isCopyable?: boolean;
            default?: string | number;
            environment: Environment;
            envVariables: EnvVariable[];
            workspace: Workspace;
            lineWrapping?: boolean;
        }> & Readonly<{
            onSubmit?: (v: string) => any;
            "onUpdate:modelValue"?: (v: string) => any;
            onBlur?: (v: string) => any;
            onCurl?: (v: string) => any;
        }>, "modelValue" | "handleBlur" | "focus" | "codeMirror" | "handleChange" | "handleSubmit" | "booleanOptions" | ("nullable" | "disabled" | "colorPicker" | "emitOnBlur" | "extensions" | "disableTabIndent" | "disableEnter" | "disableCloseBrackets" | "withVariables" | "isCopyable" | "lineWrapping")> & import("vue").ShallowUnwrapRef<{
            focus: () => void;
            handleChange: (value: string) => void | null;
            handleSubmit: (value: string) => void;
            handleBlur: (value: string) => void;
            booleanOptions: import("vue").ComputedRef<string[]>;
            codeMirror: import("vue").Ref<import("@codemirror/view").EditorView | null, import("@codemirror/view").EditorView | null>;
            modelValue: string | number;
        }> & {} & import("vue").ComponentCustomProperties & {} & {
            $slots: {
                warning?(_: {}): any;
                icon?(_: {}): any;
            };
        }) | null;
    };
    rootEl: any;
};
type __VLS_TemplateResult = ReturnType<typeof __VLS_template>;
declare const __VLS_component: import("vue").DefineComponent<__VLS_Props, {}, {}, {}, {}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, {} & {
    selectVariable: (value: string) => any;
    "update:modelValue": (v: string) => any;
    inputFocus: () => any;
    inputBlur: () => any;
}, string, import("vue").PublicProps, Readonly<__VLS_Props> & Readonly<{
    onSelectVariable?: (value: string) => any;
    "onUpdate:modelValue"?: (v: string) => any;
    onInputFocus?: () => any;
    onInputBlur?: () => any;
}>, {
    required: boolean;
    readOnly: boolean;
    lineWrapping: boolean;
    canAddCustomEnumValue: boolean;
}, {}, {}, {}, string, import("vue").ComponentProvideOptions, false, {}, any>;
declare const _default: __VLS_WithTemplateSlots<typeof __VLS_component, __VLS_TemplateResult["slots"]>;
export default _default;
type __VLS_WithTemplateSlots<T, S> = T & {
    new (): {
        $slots: S;
    };
};
//# sourceMappingURL=DataTableInput.vue.d.ts.map