import { defineComponent as y, createElementBlock as C, createCommentVNode as h, openBlock as o, Fragment as v, createBlock as u, unref as a, withCtx as m, createTextVNode as p } from "vue";
import { ScalarButton as c } from "@scalar/components";
import { useToasts as b } from "@scalar/use-toasts";
import { useRouter as g } from "vue-router";
import { useActiveEntities as x } from "../../store/active-entities.js";
import { importCollection as B } from "./utils/import-collection.js";
import { useWorkspace as I } from "../../store/store.js";
const R = /* @__PURE__ */ y({
  __name: "ImportNowButton",
  props: {
    source: {},
    variant: {},
    watchMode: { type: Boolean, default: !0 }
  },
  emits: ["importFinished"],
  setup(r, { emit: f }) {
    const d = f, l = g(), k = I(), { activeWorkspace: s } = x(), { toast: n } = b();
    async function i() {
      B({
        store: k,
        workspace: s.value,
        source: r.source,
        watchMode: r.watchMode,
        onSuccess(t) {
          t && (w(t), n("Import successful", "info"), d("importFinished"));
        },
        onError(t) {
          console.error("[importCollection]", t);
          const e = (t == null ? void 0 : t.message) || "Unknown error";
          n(`Import failed: ${e}`, "error");
        }
      });
    }
    function w(t) {
      var e;
      t && l.push({
        name: "request",
        params: {
          workspace: (e = s.value) == null ? void 0 : e.uid,
          request: t == null ? void 0 : t.requests[0]
        }
      });
    }
    return (t, e) => t.source ? (o(), C(v, { key: 0 }, [
      t.variant === "button" ? (o(), u(a(c), {
        key: 0,
        class: "mt-3 h-fit w-full rounded-lg px-6 py-2.5 font-bold",
        size: "md",
        type: "button",
        onClick: i
      }, {
        default: m(() => e[0] || (e[0] = [
          p(" Import Collection ")
        ])),
        _: 1
      })) : (o(), u(a(c), {
        key: 1,
        class: "h-fit rounded-lg px-6 py-2.5 text-[21px] font-bold",
        size: "md",
        type: "button",
        variant: "ghost",
        onClick: i
      }, {
        default: m(() => e[1] || (e[1] = [
          p(" Try it in the browser ")
        ])),
        _: 1
      }))
    ], 64)) : h("", !0);
  }
});
export {
  R as default
};
