import { defineComponent as u, computed as a, createElementBlock as p, openBlock as y, normalizeProps as h, guardReactiveProps as k, unref as b, createElementVNode as i, toDisplayString as s } from "vue";
import { useBindCx as x } from "@scalar/components";
import { isMacOS as r } from "@scalar/use-tooltip";
const C = { "aria-hidden": "true" }, w = { class: "sr-only" }, A = /* @__PURE__ */ u({
  __name: "ScalarHotkey",
  props: {
    hotkey: {},
    modifier: { default: () => ["Meta"] }
  },
  setup(e) {
    const d = {
      "⌘": "Command",
      "^": "Control",
      "⌥": "Option",
      "⇧": "Shift",
      "⇪": "Caps Lock",
      "↵": "Enter",
      "←": "Left Arrow",
      "→": "Right Arrow",
      "↑": "Up Arrow",
      "↓": "Down Arrow"
    }, c = {
      Meta: r() ? "⌘" : "^",
      default: r() ? "⌘" : "^",
      Shift: "⇧",
      Alt: "⌥",
      Control: "^"
    }, { cx: l } = x(), m = a(() => `${e.modifier.map((o) => c[o]).join("+")} ${e.hotkey}`), f = a(() => {
      const t = e.modifier.map((n) => n === "Meta" ? r() ? "Command" : "Control" : n).join("+"), o = d[e.hotkey] ?? e.hotkey;
      return `${t} ${o}`;
    });
    return (t, o) => (y(), p("div", h(k(
      b(l)(
        "border-(--scalar-background-3) inline-block overflow-hidden rounded border text-xxs rounded-b px-1 font-medium uppercase"
      )
    )), [
      i("span", C, s(m.value), 1),
      i("span", w, s(f.value), 1)
    ], 16));
  }
});
export {
  A as default
};
