import { defineComponent as V, computed as u, watch as z, createBlock as m, openBlock as n, unref as s, withCtx as v, createVNode as c, createElementBlock as a, Fragment as d, createElementVNode as i, createTextVNode as L, toDisplayString as W, createCommentVNode as h, renderList as k } from "vue";
import { ScalarPopover as q, ScalarButton as E, ScalarIcon as x, ScalarFloatingBackdrop as F, ScalarDropdownDivider as I } from "@scalar/components";
import { useLayout as M } from "../../hooks/useLayout.js";
import { useWorkspace as P } from "../../store/store.js";
import y from "./ServerDropdownItem.vue.js";
const T = ["onClick"], j = { class: "flex h-4 w-4 items-center justify-center" }, Q = /* @__PURE__ */ V({
  __name: "ServerDropdown",
  props: {
    collection: {},
    operation: {},
    server: {},
    target: {}
  },
  setup(l) {
    const { layout: U } = M(), { servers: p, collectionMutators: w, events: A, serverMutators: C } = P(), f = u(
      () => {
        var e, r;
        return (r = (e = l.operation) == null ? void 0 : e.servers) == null ? void 0 : r.map((t) => {
          var o;
          return {
            id: t,
            label: ((o = p[t]) == null ? void 0 : o.url) ?? "Unknown server"
          };
        });
      }
    ), S = u(
      () => {
        var e, r;
        return (
          // Filters out servers already present in the request
          (r = (e = l.collection) == null ? void 0 : e.servers) == null ? void 0 : r.filter((t) => {
            var o, g;
            return !((g = (o = l.operation) == null ? void 0 : o.servers) != null && g.includes(t));
          }).map((t) => {
            var o;
            return {
              id: t,
              label: ((o = p[t]) == null ? void 0 : o.url) ?? "Unknown server"
            };
          })
        );
      }
    ), D = u(
      () => {
        var e, r;
        return ((e = f.value) == null ? void 0 : e.length) && ((r = S.value) == null ? void 0 : r.length);
      }
    );
    z([() => l.collection, () => l.operation], ([e, r]) => {
      var o;
      if (!e || e.selectedServerUid || r != null && r.selectedServerUid)
        return;
      const t = (o = l.collection.servers) == null ? void 0 : o[0];
      t && w.edit(l.collection.uid, "selectedServerUid", t);
    });
    const B = () => A.commandPalette.emit({
      commandName: "Add Server"
    }), N = u(() => {
      var e, r, t;
      return (r = (e = l.server) == null ? void 0 : e.url) != null && r.endsWith("/") ? l.server.url.slice(0, -1) : ((t = l.server) == null ? void 0 : t.url) || "";
    }), b = (e, r) => {
      if (!l.server)
        return;
      const t = l.server.variables || {};
      t[e] = { ...t[e], default: r }, C.edit(l.server.uid, "variables", t);
    };
    return (e, r) => (n(), m(s(q), {
      class: "max-h-[inherit] p-0 text-sm",
      focus: "",
      offset: 0,
      placement: "bottom-start",
      resize: "",
      target: e.target,
      teleport: `#${e.target}`
    }, {
      popover: v(({ close: t }) => [
        i("div", {
          class: "custom-scroll flex max-h-[inherit] flex-col gap-1 border-t p-1",
          onClick: t
        }, [
          (n(!0), a(d, null, k(f.value, (o) => (n(), m(y, {
            key: o.id,
            collection: e.collection,
            operation: e.operation,
            server: e.server,
            serverOption: o,
            type: "request",
            "onUpdate:variable": b
          }, null, 8, ["collection", "operation", "server", "serverOption"]))), 128)),
          D.value ? (n(), a(d, { key: 0 }, [
            c(s(I)),
            r[2] || (r[2] = i("div", { class: "text-xxs text-c-2 px-2.5 py-1" }, "Collection", -1))
          ], 64)) : h("", !0),
          (n(!0), a(d, null, k(S.value, (o) => (n(), m(y, {
            key: o.id,
            collection: e.collection,
            operation: e.operation,
            server: e.server,
            serverOption: o,
            type: "collection",
            "onUpdate:variable": b
          }, null, 8, ["collection", "operation", "server", "serverOption"]))), 128)),
          s(U) !== "modal" ? (n(), a("button", {
            key: 1,
            class: "text-xxs hover:bg-b-2 flex cursor-pointer items-center gap-1.5 rounded p-1.75",
            type: "button",
            onClick: B
          }, [
            i("div", j, [
              c(s(x), {
                icon: "Add",
                size: "sm"
              })
            ]),
            r[3] || (r[3] = i("span", null, "Add Server", -1))
          ])) : h("", !0)
        ], 8, T)
      ]),
      backdrop: v(() => [
        c(s(F), { class: "-top-(--scalar-address-bar-height) rounded-lg" })
      ]),
      default: v(() => [
        c(s(E), {
          class: "z-context-plus hover:bg-b-2 font-code text-c-2 ml-0.75 h-auto gap-0.75 rounded border px-1.5 text-xs whitespace-nowrap lg:text-sm",
          variant: "ghost"
        }, {
          default: v(() => {
            var t;
            return [
              (t = e.operation) != null && t.selectedServerUid || e.collection.selectedServerUid ? (n(), a(d, { key: 0 }, [
                r[0] || (r[0] = i("span", { class: "sr-only" }, "Server:", -1)),
                L(" " + W(N.value), 1)
              ], 64)) : (n(), a(d, { key: 1 }, [
                r[1] || (r[1] = i("span", { class: "sr-only" }, "Add Server", -1)),
                c(s(x), {
                  icon: "Add",
                  size: "xs"
                })
              ], 64))
            ];
          }),
          _: 1
        })
      ]),
      _: 1
    }, 8, ["target", "teleport"]));
  }
});
export {
  Q as default
};
