import { defineComponent as d, createBlock as c, openBlock as p, unref as t, withCtx as n, createVNode as o, createTextVNode as a, createElementVNode as r, normalizeClass as k, toDisplayString as u } from "vue";
import { ScalarContextMenu as b, ScalarFloating as v, ScalarDropdownMenu as C, ScalarDropdownButton as m, ScalarIcon as l, ScalarDropdownDivider as g, ScalarTooltip as y } from "@scalar/components";
import { LibraryIcon as $ } from "@scalar/icons/library";
import { isMacOS as T } from "@scalar/use-tooltip";
import f from "../ScalarHotkey.vue.js";
const w = { class: "nav-item-icon-copy flex flex-1 items-center justify-center gap-1.5" }, S = { class: "custom-scroll nav-item-copy text-xs" }, L = /* @__PURE__ */ d({
  __name: "TopNavItem",
  props: {
    hotkey: {},
    active: { type: Boolean },
    label: {},
    icon: {},
    isCollection: { type: Boolean }
  },
  emits: ["click", "close", "newTab", "copyUrl", "closeOtherTabs"],
  setup(z) {
    return (s, e) => (p(), c(t(b), { triggerClass: "overflow-hidden w-full" }, {
      trigger: n(() => [
        o(t(y), {
          content: `${t(T)() ? "⌘" : "^"} ${s.hotkey}`,
          placement: "bottom"
        }, {
          default: n(() => [
            r("div", {
              class: k(["nav-item app-no-drag-region", { "nav-item__active": s.active }]),
              onClick: e[1] || (e[1] = (i) => s.$emit("click"))
            }, [
              r("div", w, [
                s.isCollection ? (p(), c(t($), {
                  key: 0,
                  class: "size-3.5 min-w-3.5 stroke-2",
                  src: s.icon
                }, null, 8, ["src"])) : (p(), c(t(l), {
                  key: 1,
                  icon: s.icon,
                  size: "xs",
                  thickness: "2.5"
                }, null, 8, ["icon"])),
                r("span", S, u(s.label), 1)
              ]),
              r("button", {
                class: "nav-item-close",
                type: "button",
                onClick: e[0] || (e[0] = (i) => s.$emit("close"))
              }, [
                o(t(l), {
                  icon: "Close",
                  thickness: "1.75"
                })
              ])
            ], 2)
          ]),
          _: 1
        }, 8, ["content"])
      ]),
      content: n(() => [
        o(t(v), { placement: "right-start" }, {
          floating: n(() => [
            o(t(C), { class: "scalar-app scalar-client" }, {
              default: n(() => [
                o(t(m), {
                  class: "flex items-center gap-1.5",
                  onClick: e[2] || (e[2] = (i) => s.$emit("newTab"))
                }, {
                  default: n(() => [
                    o(t(l), {
                      icon: "AddTab",
                      size: "sm",
                      thickness: "1.5"
                    }),
                    e[6] || (e[6] = a(" New Tab ")),
                    o(f, {
                      class: "bg-b-2 ml-auto",
                      hotkey: "T"
                    })
                  ]),
                  _: 1
                }),
                o(t(m), {
                  class: "flex items-center gap-1.5",
                  onClick: e[3] || (e[3] = (i) => s.$emit("copyUrl"))
                }, {
                  default: n(() => [
                    o(t(l), {
                      icon: "Link",
                      size: "sm",
                      thickness: "1.5"
                    }),
                    e[7] || (e[7] = a(" Copy URL "))
                  ]),
                  _: 1
                }),
                o(t(g)),
                o(t(m), {
                  class: "flex items-center gap-1.5",
                  onClick: e[4] || (e[4] = (i) => s.$emit("close"))
                }, {
                  default: n(() => [
                    o(t(l), {
                      icon: "CloseTab",
                      size: "sm",
                      thickness: "1.5"
                    }),
                    e[8] || (e[8] = a(" Close Tab ")),
                    o(f, {
                      class: "bg-b-2 ml-auto",
                      hotkey: "W"
                    })
                  ]),
                  _: 1
                }),
                o(t(m), {
                  class: "flex items-center gap-1.5",
                  onClick: e[5] || (e[5] = (i) => s.$emit("closeOtherTabs"))
                }, {
                  default: n(() => [
                    o(t(l), {
                      icon: "CloseTabs",
                      size: "sm",
                      thickness: "1.5"
                    }),
                    e[9] || (e[9] = a(" Close Other Tabs "))
                  ]),
                  _: 1
                })
              ]),
              _: 1
            })
          ]),
          _: 1
        })
      ]),
      _: 1
    }));
  }
});
export {
  L as default
};
