export type UseFileDialogOptions = {
    multiple?: boolean;
    /** @default '*' */
    accept?: string;
    onChange?: (files: FileList | null) => void | Promise<void>;
    onError?: () => void | Promise<void>;
};
/**
 * Simplified interface for opening a file picker dialog
 * Derived from vueuse @see https://vueuse.org/useFileDialog
 */
export declare function useFileDialog({ multiple, accept, onChange, onError }?: UseFileDialogOptions): {
    files: Readonly<import("vue").Ref<{
        readonly [x: number]: {
            readonly lastModified: number;
            readonly name: string;
            readonly webkitRelativePath: string;
            readonly size: number;
            readonly type: string;
            readonly arrayBuffer: () => Promise<ArrayBuffer>;
            readonly slice: (start?: number, end?: number, contentType?: string) => Blob;
            readonly stream: () => ReadableStream<Uint8Array>;
            readonly text: () => Promise<string>;
        };
        readonly length: number;
        readonly item: (index: number) => File | null;
        readonly [Symbol.iterator]: () => ArrayIterator<File>;
    } | null, {
        readonly [x: number]: {
            readonly lastModified: number;
            readonly name: string;
            readonly webkitRelativePath: string;
            readonly size: number;
            readonly type: string;
            readonly arrayBuffer: () => Promise<ArrayBuffer>;
            readonly slice: (start?: number, end?: number, contentType?: string) => Blob;
            readonly stream: () => ReadableStream<Uint8Array>;
            readonly text: () => Promise<string>;
        };
        readonly length: number;
        readonly item: (index: number) => File | null;
        readonly [Symbol.iterator]: () => ArrayIterator<File>;
    } | null>>;
    open: () => void | Promise<void>;
};
//# sourceMappingURL=useFileDialog.d.ts.map