import type { ClientLayout } from '../hooks/useLayout';
import { type InjectionKey } from 'vue';
type CollapsedSidebarFolders = Record<string, boolean>;
/** Creates the sidebar state so that it can be unique across instances of the client */
export declare const createSidebarState: ({ layout }: {
    layout: ClientLayout;
}) => {
    collapsedSidebarFolders: CollapsedSidebarFolders;
    isSidebarOpen: import("vue").Ref<boolean, boolean>;
};
export declare const SIDEBAR_SYMBOL: InjectionKey<ReturnType<typeof createSidebarState>>;
/** Handles any logic related to sidebar */
export declare const useSidebar: () => {
    /** State */
    collapsedSidebarFolders: {
        readonly [x: string]: boolean;
    };
    isSidebarOpen: Readonly<import("vue").Ref<boolean, boolean>>;
    /** Actions */
    setCollapsedSidebarFolder: (uid: string, value: boolean) => boolean;
    toggleSidebarFolder: (key: string) => boolean;
    setSidebarOpen: (value: boolean) => boolean;
    toggleSidebarOpen: () => boolean;
};
export {};
//# sourceMappingURL=useSidebar.d.ts.map