import { CLIENT_CONFIGURATION_SYMBOL as K } from "../hooks/useClientConfig.js";
import { LAYOUT_SYMBOL as D } from "../hooks/useLayout.js";
import { createSidebarState as G, SIDEBAR_SYMBOL as V } from "../hooks/useSidebar.js";
import { getRequestUidByPathMethod as z } from "./get-request-uid-by-path-method.js";
import { loadAllResources as H } from "./local-storage.js";
import { createActiveEntitiesStore as J, ACTIVE_ENTITIES_SYMBOL as Q } from "../store/active-entities.js";
import { createWorkspaceStore as X, WORKSPACE_SYMBOL as Z } from "../store/store.js";
import { workspaceSchema as $ } from "@scalar/oas-utils/entities/workspace";
import { LS_KEYS as ee, prettyPrintJson as te } from "@scalar/oas-utils/helpers";
import { DATA_VERSION_LS_LEY as re, DATA_VERSION as oe } from "@scalar/oas-utils/migrations";
import { apiClientConfigurationSchema as x } from "@scalar/types/api-reference";
import { ref as ae, createApp as se, watch as ie } from "vue";
import { createPluginManager as ce } from "../plugins/plugin-manager.js";
import { PLUGIN_MANAGER_SYMBOL as le } from "../plugins/hooks/usePluginManager.js";
const Oe = ({
  el: C,
  appComponent: L,
  configuration: b = {},
  isReadOnly: n = !1,
  store: y,
  persistData: E = !0,
  mountOnInitialize: k = !0,
  layout: m = "desktop",
  router: u
}) => {
  const s = ae(x.parse(b)), a = y || X({
    proxyUrl: s.value.proxyUrl,
    theme: s.value.theme,
    showSidebar: s.value.showSidebar ?? !0,
    hideClientButton: s.value.hideClientButton ?? !1,
    _integration: s.value._integration,
    useLocalStorage: E
  }), f = J({ ...a, router: u }), I = G({ layout: m }), q = ce({
    plugins: s.value.plugins ?? []
  }), v = () => {
    try {
      return typeof window < "u" && window.localStorage !== void 0;
    } catch {
      return !1;
    }
  };
  if (v() && localStorage.getItem(ee.WORKSPACE) && !n)
    try {
      const t = {};
      let e = 0, r = 0, o = "";
      for (o in localStorage)
        Object.prototype.hasOwnProperty.call(localStorage, o) && (r = (localStorage[o].length + o.length) * 2, e += r, t[o] = (r / 1024).toFixed(2) + " KB");
      t.Total = (e / 1024).toFixed(2) + " KB", console.table(t), H(a);
    } catch (t) {
      console.warn("Failed to load from localStorage:", t);
    }
  else if (!n && !s.value.url && !s.value.content) {
    if (a.workspaceMutators.add({
      uid: "default",
      name: "Workspace",
      proxyUrl: s.value.proxyUrl
    }), v())
      try {
        localStorage.setItem(re, oe);
      } catch (t) {
        console.warn("Failed to set localStorage version:", t);
      }
  } else {
    const t = $.parse({
      uid: "default",
      name: "Workspace",
      proxyUrl: s.value.proxyUrl
    });
    a.workspaceMutators.rawAdd(t);
  }
  const i = se(L);
  i.use(u), i.provide(Z, a), i.provide(D, m), i.provide(Q, f), i.provide(V, I), i.provide(K, s), i.provide(le, q), i.config.idPrefix = "scalar-client";
  const {
    collectionMutators: B,
    importSpecFile: P,
    importSpecFromUrl: T,
    modalState: S,
    requests: h,
    securitySchemes: R,
    securitySchemeMutators: Y,
    servers: g,
    workspaceMutators: N,
    requestExampleMutators: F
  } = a, { activeCollection: p, activeWorkspace: d } = f, w = (t = C) => {
    if (!t) {
      console.error(
        "[@scalar/api-client-modal] Could not create the API client.",
        "Invalid HTML element provided.",
        "Read more: https://github.com/scalar/scalar/tree/main/packages/api-client"
      );
      return;
    }
    i.mount(t);
  };
  k && w();
  const M = (t) => {
    const e = z(h, t);
    e ? u.push({
      name: "request",
      query: t != null && t._source ? { source: t._source } : {},
      params: {
        workspace: "default",
        request: e
      }
    }) : console.warn("[@scalar/api-client] Could not find request for path and method", t);
  };
  return {
    /** The vue app instance for the modal, be careful with this */
    app: i,
    /**
     * Update the API client config
     *
     * Deletes the current store before importing again for now, in the future will Diff and only update what is needed
     */
    updateConfig: async (t) => {
      var r, o, c;
      const e = x.parse(t);
      if (e.url || e.content || e.servers || e.authentication || e.slug || e.title || e.baseServerURL || e.proxyUrl || e.showSidebar) {
        a.collectionMutators.reset(), a.requestMutators.reset(), a.requestExampleMutators.reset(), a.securitySchemeMutators.reset(), a.serverMutators.reset(), a.tagMutators.reset(), N.edit((r = d.value) == null ? void 0 : r.uid, "collections", []);
        const l = {
          ...e,
          useCollectionSecurity: n
        };
        s.value = l, e.url ? await T(e.url, ((o = d.value) == null ? void 0 : o.uid) ?? "default", l) : e.content ? await P(e.content, ((c = d.value) == null ? void 0 : c.uid) ?? "default", l) : console.error(
          "[@scalar/api-client-modal] Could not create the API client.",
          'Please provide an OpenAPI document: { url: "…" }',
          "Read more: https://github.com/scalar/scalar/tree/main/packages/api-client"
        );
      }
    },
    /** Update the currently selected server via URL */
    updateServer: (t) => {
      var r;
      const e = Object.values(g).find((o) => o.url === t);
      e && p.value && B.edit((r = p.value) == null ? void 0 : r.uid, "selectedServerUid", e.uid);
    },
    /** Update the currently selected server via URL */
    onUpdateServer: (t) => {
      ie(
        () => {
          var e;
          return (e = p.value) == null ? void 0 : e.selectedServerUid;
        },
        (e) => {
          const r = Object.values(g).find((o) => o.uid === e);
          r != null && r.url && t(r.url);
        }
      );
    },
    /**
     * Update the auth values, we currently don't change the auth selection
     */
    updateAuth: ({
      nameKey: t,
      propertyKey: e,
      value: r
    }) => {
      const c = Object.values(R).find((l) => l.nameKey === t);
      c && Y.edit(c.uid, e, r);
    },
    /** Route to a method + path */
    route: M,
    /** Open the API client modal and optionally route to a request */
    open: (t) => {
      const { method: e, path: r, requestUid: o } = t ?? {};
      (e && r || o) && M(t), S.open = !0;
    },
    /** Mount the references to a given element */
    mount: w,
    /** State for controlling the modal */
    modalState: S,
    /* The workspace store */
    store: a,
    /** Update the currently selected example */
    updateExample: (t, e) => {
      var l, A, _, O, U;
      if (!t || !e)
        return;
      const r = Object.values(h).find(
        ({ operationId: j, path: W }) => j === e || W === e
      );
      if (!r)
        return;
      const o = Object.keys(((l = r.requestBody) == null ? void 0 : l.content) || {})[0] || "", c = (U = (O = (_ = (A = r.requestBody) == null ? void 0 : A.content) == null ? void 0 : _[o]) == null ? void 0 : O.examples) == null ? void 0 : U[t];
      c && F.edit(r.examples[0], "body.raw.value", te(c.value));
    }
  };
};
export {
  Oe as createApiClient
};
