import type { Request } from '@scalar/oas-utils/entities/spec';
/** Convert path string like '/planets/{planetId}' to regex pattern /\/planets/([^/]+)/ */
export declare const pathToRegex: (path: string) => RegExp;
/**
 * Takes a path and method and returns the request that matches the path and method while taking
 * path params into account by converting to a regex. Will also return the path params if they exist
 *
 * @example path can be /planets/{planetId} OR /planets/1
 */
export declare const findRequestByPathMethod: (path: string, method: string, requests: Request[]) => {
    request: {
        uid: string & import("zod").BRAND<"operation">;
        path: string;
        type: "request";
        selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
        selectedServerUid: (string & import("zod").BRAND<"server">) | null;
        servers: (string & import("zod").BRAND<"server">)[];
        examples: (string & import("zod").BRAND<"example">)[];
        method: "options" | "connect" | "delete" | "get" | "head" | "patch" | "post" | "put" | "trace";
        description?: string | undefined;
        summary?: string | undefined;
        externalDocs?: {
            url: string;
            description?: string | undefined;
        } | undefined;
        'x-internal'?: boolean | undefined;
        'x-scalar-ignore'?: boolean | undefined;
        security?: Record<string, string[]>[] | undefined;
        tags?: string[] | undefined;
        deprecated?: boolean | undefined;
        operationId?: string | undefined;
        parameters?: {
            name: string;
            required: boolean;
            deprecated: boolean;
            in: "cookie" | "path" | "query" | "header";
            description?: string | undefined;
            example?: unknown;
            examples?: unknown[] | Record<string, {
                value?: unknown;
                summary?: string | undefined;
                externalValue?: string | undefined;
            }> | undefined;
            schema?: unknown;
            content?: unknown;
            style?: "matrix" | "simple" | "form" | "label" | "spaceDelimited" | "pipeDelimited" | "deepObject" | undefined;
            explode?: boolean | undefined;
        }[] | undefined;
        requestBody?: any;
        responses?: Record<string, any> | undefined;
        callbacks?: Record<string, Record<string, Record<string, any>>> | undefined;
        'x-scalar-stability'?: import("@scalar/types").XScalarStability | undefined;
        'x-post-response'?: string | undefined;
        'x-codeSamples'?: {
            source: string;
            label?: string | undefined;
            lang?: string | undefined;
        }[] | undefined;
        'x-code-samples'?: {
            source: string;
            label?: string | undefined;
            lang?: string | undefined;
        }[] | undefined;
        'x-custom-examples'?: {
            source: string;
            label?: string | undefined;
            lang?: string | undefined;
        }[] | undefined;
    } | undefined;
    pathParams: {
        key: string;
        value: string;
    }[];
};
//# sourceMappingURL=find-request.d.ts.map