import type { ApiClientPlugin } from '@scalar/types/api-client';
import type { InjectionKey } from 'vue';
export type { ApiClientPlugin };
type CreatePluginManagerParams = {
    plugins?: ApiClientPlugin[];
};
/**
 * Create the plugin manager store
 *
 * This store manages all plugins registered with the API client
 */
export declare const createPluginManager: ({ plugins }: CreatePluginManagerParams) => {
    /**
     * Get all components for a specific view
     */
    getViewComponents: (view: keyof ReturnType<ApiClientPlugin>["views"]) => {
        title?: string | undefined;
        component?: unknown;
        props?: Record<string, any> | undefined;
    }[];
    /**
     * Execute a hook for a specific event
     */
    executeHook: <E extends keyof ReturnType<ApiClientPlugin>["hooks"]>(event: E, ...args: Parameters<ReturnType<ApiClientPlugin>["hooks"][E]>) => Promise<void[]>;
};
export type PluginManager = ReturnType<typeof createPluginManager>;
export declare const PLUGIN_MANAGER_SYMBOL: InjectionKey<PluginManager>;
//# sourceMappingURL=plugin-manager.d.ts.map