import { type Environment } from '@scalar/oas-utils/entities/environment';
import type { Collection, Request, RequestExample, Server } from '@scalar/oas-utils/entities/spec';
import type { Workspace } from '@scalar/oas-utils/entities/workspace';
import { type InjectionKey } from 'vue';
import type { Router } from 'vue-router';
import type { Cookie } from '@scalar/oas-utils/entities/cookie';
type CreateActiveEntitiesStoreParams = {
    collections: Record<string, Collection>;
    environments: Record<string, Environment>;
    requestExamples: Record<string, RequestExample>;
    requests: Record<string, Request>;
    servers: Record<string, Server>;
    workspaces: Record<string, Workspace>;
    router?: Router;
};
export type EnvVariable = {
    key: string;
    value: any;
    source: 'global' | 'collection';
};
/**
 * Create the active entities store
 *
 * We need the factory function to pass the router instance
 */
export declare const createActiveEntitiesStore: ({ collections, requestExamples, requests, router, servers, workspaces, }: CreateActiveEntitiesStoreParams) => {
    activeCollection: import("vue").ComputedRef<{
        uid: string & import("zod").BRAND<"collection">;
        type: "collection";
        children: ((string & import("zod").BRAND<"tag">) | (string & import("zod").BRAND<"operation">))[];
        openapi: string;
        info: {
            title: string;
            version: string;
            description?: string | undefined;
            summary?: string | undefined;
            termsOfService?: string | undefined;
            contact?: {
                name?: string | undefined;
                url?: string | undefined;
                email?: string | undefined;
            } | undefined;
            license?: {
                name?: string | null | undefined;
                identifier?: string | undefined;
                url?: string | undefined;
            } | undefined;
            "x-scalar-sdk-installation"?: {
                lang: string;
                description?: string | undefined;
                source?: string | undefined;
            }[] | undefined;
        };
        security: Record<string, string[]>[];
        'x-scalar-icon': string;
        securitySchemes: string[];
        selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
        servers: (string & import("zod").BRAND<"server">)[];
        requests: (string & import("zod").BRAND<"operation">)[];
        tags: (string & import("zod").BRAND<"tag">)[];
        watchMode: boolean;
        useCollectionSecurity: boolean;
        watchModeStatus: "IDLE" | "WATCHING" | "ERROR";
        externalDocs?: {
            url: string;
            description?: string | undefined;
        } | undefined;
        jsonSchemaDialect?: string | undefined;
        components?: Record<string, unknown> | undefined;
        webhooks?: Record<string, unknown> | undefined;
        'x-scalar-active-environment'?: string | undefined;
        'x-scalar-environments'?: Record<string, {
            variables: Record<string, string | {
                default: string;
                description?: string | undefined;
            }>;
            color?: string | undefined;
            description?: string | undefined;
        }> | undefined;
        'x-scalar-secrets'?: Record<string, {
            description?: string | undefined;
            example?: string | undefined;
        }> | undefined;
        selectedServerUid?: (string & import("zod").BRAND<"server">) | undefined;
        documentUrl?: string | undefined;
        integration?: string | null | undefined;
    } | undefined>;
    activeCookieId: import("vue").ComputedRef<string & import("zod").BRAND<"cookie">>;
    activeExample: import("vue").ComputedRef<{
        uid: string & import("zod").BRAND<"example">;
        name: string;
        type: "requestExample";
        body: {
            activeBody: "binary" | "formData" | "raw";
            binary?: Blob | undefined;
            formData?: {
                value: {
                    value: string;
                    key: string;
                    enabled: boolean;
                    minimum?: number | undefined;
                    type?: string | string[] | undefined;
                    maximum?: number | undefined;
                    description?: string | undefined;
                    default?: any;
                    required?: boolean | undefined;
                    enum?: string[] | undefined;
                    format?: string | undefined;
                    examples?: any[] | undefined;
                    file?: any;
                    nullable?: boolean | undefined;
                }[];
                encoding: "form-data" | "urlencoded";
            } | undefined;
            raw?: {
                value: string;
                encoding: "xml" | "json" | "text" | "html" | "javascript" | "yaml" | "edn";
                mimeType?: string | undefined;
            } | undefined;
        };
        parameters: {
            path: {
                value: string;
                key: string;
                enabled: boolean;
                minimum?: number | undefined;
                type?: string | string[] | undefined;
                maximum?: number | undefined;
                description?: string | undefined;
                default?: any;
                required?: boolean | undefined;
                enum?: string[] | undefined;
                format?: string | undefined;
                examples?: any[] | undefined;
                file?: any;
                nullable?: boolean | undefined;
            }[];
            query: {
                value: string;
                key: string;
                enabled: boolean;
                minimum?: number | undefined;
                type?: string | string[] | undefined;
                maximum?: number | undefined;
                description?: string | undefined;
                default?: any;
                required?: boolean | undefined;
                enum?: string[] | undefined;
                format?: string | undefined;
                examples?: any[] | undefined;
                file?: any;
                nullable?: boolean | undefined;
            }[];
            headers: {
                value: string;
                key: string;
                enabled: boolean;
                minimum?: number | undefined;
                type?: string | string[] | undefined;
                maximum?: number | undefined;
                description?: string | undefined;
                default?: any;
                required?: boolean | undefined;
                enum?: string[] | undefined;
                format?: string | undefined;
                examples?: any[] | undefined;
                file?: any;
                nullable?: boolean | undefined;
            }[];
            cookies: {
                value: string;
                key: string;
                enabled: boolean;
                minimum?: number | undefined;
                type?: string | string[] | undefined;
                maximum?: number | undefined;
                description?: string | undefined;
                default?: any;
                required?: boolean | undefined;
                enum?: string[] | undefined;
                format?: string | undefined;
                examples?: any[] | undefined;
                file?: any;
                nullable?: boolean | undefined;
            }[];
        };
        requestUid?: (string & import("zod").BRAND<"operation">) | undefined;
        serverVariables?: Record<string, string[]> | undefined;
    } | undefined>;
    activeRequest: import("vue").ComputedRef<{
        uid: string & import("zod").BRAND<"operation">;
        path: string;
        type: "request";
        selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
        selectedServerUid: (string & import("zod").BRAND<"server">) | null;
        servers: (string & import("zod").BRAND<"server">)[];
        examples: (string & import("zod").BRAND<"example">)[];
        method: "options" | "connect" | "delete" | "get" | "head" | "patch" | "post" | "put" | "trace";
        description?: string | undefined;
        summary?: string | undefined;
        externalDocs?: {
            url: string;
            description?: string | undefined;
        } | undefined;
        'x-internal'?: boolean | undefined;
        'x-scalar-ignore'?: boolean | undefined;
        security?: Record<string, string[]>[] | undefined;
        tags?: string[] | undefined;
        deprecated?: boolean | undefined;
        operationId?: string | undefined;
        parameters?: {
            name: string;
            required: boolean;
            deprecated: boolean;
            in: "cookie" | "path" | "query" | "header";
            description?: string | undefined;
            example?: unknown;
            examples?: unknown[] | Record<string, {
                value?: unknown;
                summary?: string | undefined;
                externalValue?: string | undefined;
            }> | undefined;
            schema?: unknown;
            content?: unknown;
            style?: "matrix" | "simple" | "form" | "label" | "spaceDelimited" | "pipeDelimited" | "deepObject" | undefined;
            explode?: boolean | undefined;
        }[] | undefined;
        requestBody?: any;
        responses?: Record<string, any> | undefined;
        callbacks?: Record<string, Record<string, Record<string, any>>> | undefined;
        'x-scalar-stability'?: import("@scalar/types").XScalarStability | undefined;
        'x-post-response'?: string | undefined;
        'x-codeSamples'?: {
            source: string;
            label?: string | undefined;
            lang?: string | undefined;
        }[] | undefined;
        'x-code-samples'?: {
            source: string;
            label?: string | undefined;
            lang?: string | undefined;
        }[] | undefined;
        'x-custom-examples'?: {
            source: string;
            label?: string | undefined;
            lang?: string | undefined;
        }[] | undefined;
    } | undefined>;
    activeRouterParams: import("vue").ComputedRef<{
        readonly collection: Collection["uid"];
        readonly environment: Environment["uid"];
        readonly request: Request["uid"];
        readonly examples: RequestExample["uid"];
        readonly schema: string;
        readonly cookies: Cookie["uid"];
        readonly servers: Server["uid"];
        readonly workspace: Workspace["uid"];
        readonly settings: string;
    }>;
    activeEnvironment: import("vue").ComputedRef<{
        uid: string & import("zod").BRAND<"environment">;
        name: string;
        value: string;
        color: string;
        isDefault?: boolean | undefined;
    }>;
    activeServer: import("vue").ComputedRef<{
        uid: string & import("zod").BRAND<"server">;
        url: string;
        description?: string | undefined;
        variables?: Record<string, {
            value?: string | undefined;
            description?: string | undefined;
            default?: string | undefined;
            enum?: string[] | undefined;
        }> | undefined;
    } | undefined>;
    activeWorkspace: import("vue").ComputedRef<{
        uid: string & import("zod").BRAND<"workspace">;
        name: string;
        description: string;
        cookies: (string & import("zod").BRAND<"cookie">)[];
        collections: (string & import("zod").BRAND<"collection">)[];
        environments: Record<string, string>;
        activeEnvironmentId: string;
        themeId: "default" | "alternate" | "moon" | "purple" | "solarized" | "bluePlanet" | "deepSpace" | "saturn" | "kepler" | "elysiajs" | "fastify" | "mars" | "laserwave" | "none";
        selectedHttpClient: {
            targetKey: string;
            clientKey: string;
        };
        hotKeyConfig?: {
            modifiers: ("default" | "Meta" | "Control" | "Shift" | "Alt")[];
            hotKeys?: Partial<Record<"" | "0" | "Space" | "Backspace" | "Tab" | "Enter" | "Escape" | "ArrowDown" | "ArrowLeft" | "ArrowRight" | "ArrowUp" | "End" | "Home" | "PageDown" | "PageUp" | "Delete" | "1" | "2" | "3" | "4" | "5" | "6" | "7" | "8" | "9" | "a" | "b" | "c" | "d" | "e" | "f" | "g" | "h" | "i" | "j" | "k" | "l" | "m" | "n" | "o" | "p" | "q" | "r" | "s" | "t" | "u" | "v" | "w" | "x" | "y" | "z" | "*" | "+" | "-" | "." | "/" | "F1" | "F2" | "F3" | "F4" | "F5" | "F6" | "F7" | "F8" | "F9" | "F10" | "F11" | "F12" | ";" | "=" | "," | "`" | "[" | "\\" | "]", {
                event: "addTopNav" | "closeModal" | "closeTopNav" | "createNew" | "executeRequest" | "focusAddressBar" | "focusRequestSearch" | "jumpToLastTab" | "jumpToTab" | "navigateSearchResultsDown" | "navigateSearchResultsUp" | "navigateTopNavLeft" | "navigateTopNavRight" | "openCommandPalette" | "selectSearchResult" | "toggleSidebar";
                modifiers?: ("default" | "Meta" | "Control" | "Shift" | "Alt")[] | undefined;
            }>> | undefined;
        } | undefined;
        proxyUrl?: string | undefined;
    } | undefined>;
    activeWorkspaceCollections: import("vue").ComputedRef<{
        uid: string & import("zod").BRAND<"collection">;
        type: "collection";
        children: ((string & import("zod").BRAND<"tag">) | (string & import("zod").BRAND<"operation">))[];
        openapi: string;
        info: {
            title: string;
            version: string;
            description?: string | undefined;
            summary?: string | undefined;
            termsOfService?: string | undefined;
            contact?: {
                name?: string | undefined;
                url?: string | undefined;
                email?: string | undefined;
            } | undefined;
            license?: {
                name?: string | null | undefined;
                identifier?: string | undefined;
                url?: string | undefined;
            } | undefined;
            "x-scalar-sdk-installation"?: {
                lang: string;
                description?: string | undefined;
                source?: string | undefined;
            }[] | undefined;
        };
        security: Record<string, string[]>[];
        'x-scalar-icon': string;
        securitySchemes: string[];
        selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
        servers: (string & import("zod").BRAND<"server">)[];
        requests: (string & import("zod").BRAND<"operation">)[];
        tags: (string & import("zod").BRAND<"tag">)[];
        watchMode: boolean;
        useCollectionSecurity: boolean;
        watchModeStatus: "IDLE" | "WATCHING" | "ERROR";
        externalDocs?: {
            url: string;
            description?: string | undefined;
        } | undefined;
        jsonSchemaDialect?: string | undefined;
        components?: Record<string, unknown> | undefined;
        webhooks?: Record<string, unknown> | undefined;
        'x-scalar-active-environment'?: string | undefined;
        'x-scalar-environments'?: Record<string, {
            variables: Record<string, string | {
                default: string;
                description?: string | undefined;
            }>;
            color?: string | undefined;
            description?: string | undefined;
        }> | undefined;
        'x-scalar-secrets'?: Record<string, {
            description?: string | undefined;
            example?: string | undefined;
        }> | undefined;
        selectedServerUid?: (string & import("zod").BRAND<"server">) | undefined;
        documentUrl?: string | undefined;
        integration?: string | null | undefined;
    }[]>;
    activeWorkspaceServers: import("vue").ComputedRef<({
        uid: string & import("zod").BRAND<"server">;
        url: string;
        description?: string | undefined;
        variables?: Record<string, {
            value?: string | undefined;
            description?: string | undefined;
            default?: string | undefined;
            enum?: string[] | undefined;
        }> | undefined;
    } | undefined)[]>;
    activeEnvVariables: import("vue").ComputedRef<EnvVariable[]>;
    activeWorkspaceRequests: import("vue").ComputedRef<(string & import("zod").BRAND<"operation">)[]>;
};
export type ActiveEntitiesStore = ReturnType<typeof createActiveEntitiesStore>;
export declare const ACTIVE_ENTITIES_SYMBOL: InjectionKey<ActiveEntitiesStore>;
/**
 * The active entities store
 *
 * This store returns anything related to the currently active entities
 * The only reason this is a store and not a simple hook is due to storing the current router here
 *
 * @deprecated due to components being used outside of the client now, we should prop drill instead of this hook/store
 */
export declare const useActiveEntities: () => ActiveEntitiesStore;
export {};
//# sourceMappingURL=active-entities.d.ts.map