import type { StoreContext } from '../store/store-context';
import { type Collection, type CollectionPayload, type XScalarEnvironment } from '@scalar/oas-utils/entities/spec';
import type { Workspace } from '@scalar/oas-utils/entities/workspace';
/** Initiate the workspace collections */
export declare function createStoreCollections(useLocalStorage: boolean): {
    collections: Record<string, {
        uid: string & import("zod").BRAND<"collection">;
        type: "collection";
        children: ((string & import("zod").BRAND<"tag">) | (string & import("zod").BRAND<"operation">))[];
        openapi: string;
        info: {
            title: string;
            version: string;
            description?: string | undefined;
            summary?: string | undefined;
            termsOfService?: string | undefined;
            contact?: {
                name?: string | undefined;
                url?: string | undefined;
                email?: string | undefined;
            } | undefined;
            license?: {
                name?: string | null | undefined;
                identifier?: string | undefined;
                url?: string | undefined;
            } | undefined;
            "x-scalar-sdk-installation"?: {
                lang: string;
                description?: string | undefined;
                source?: string | undefined;
            }[] | undefined;
        };
        security: Record<string, string[]>[];
        'x-scalar-icon': string;
        securitySchemes: string[];
        selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
        servers: (string & import("zod").BRAND<"server">)[];
        requests: (string & import("zod").BRAND<"operation">)[];
        tags: (string & import("zod").BRAND<"tag">)[];
        watchMode: boolean;
        useCollectionSecurity: boolean;
        watchModeStatus: "IDLE" | "WATCHING" | "ERROR";
        externalDocs?: {
            url: string;
            description?: string | undefined;
        } | undefined;
        jsonSchemaDialect?: string | undefined;
        components?: Record<string, unknown> | undefined;
        webhooks?: Record<string, unknown> | undefined;
        'x-scalar-active-environment'?: string | undefined;
        'x-scalar-environments'?: Record<string, {
            variables: Record<string, string | {
                default: string;
                description?: string | undefined;
            }>;
            color?: string | undefined;
            description?: string | undefined;
        }> | undefined;
        'x-scalar-secrets'?: Record<string, {
            description?: string | undefined;
            example?: string | undefined;
        }> | undefined;
        selectedServerUid?: (string & import("zod").BRAND<"server">) | undefined;
        documentUrl?: string | undefined;
        integration?: string | null | undefined;
    }>;
    collectionMutators: {
        add: (item: {
            uid: string & import("zod").BRAND<"collection">;
            type: "collection";
            children: ((string & import("zod").BRAND<"tag">) | (string & import("zod").BRAND<"operation">))[];
            openapi: string;
            info: {
                title: string;
                version: string;
                description?: string | undefined;
                summary?: string | undefined;
                termsOfService?: string | undefined;
                contact?: {
                    name?: string | undefined;
                    url?: string | undefined;
                    email?: string | undefined;
                } | undefined;
                license?: {
                    name?: string | null | undefined;
                    identifier?: string | undefined;
                    url?: string | undefined;
                } | undefined;
                "x-scalar-sdk-installation"?: {
                    lang: string;
                    description?: string | undefined;
                    source?: string | undefined;
                }[] | undefined;
            };
            security: Record<string, string[]>[];
            'x-scalar-icon': string;
            securitySchemes: string[];
            selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
            servers: (string & import("zod").BRAND<"server">)[];
            requests: (string & import("zod").BRAND<"operation">)[];
            tags: (string & import("zod").BRAND<"tag">)[];
            watchMode: boolean;
            useCollectionSecurity: boolean;
            watchModeStatus: "IDLE" | "WATCHING" | "ERROR";
            externalDocs?: {
                url: string;
                description?: string | undefined;
            } | undefined;
            jsonSchemaDialect?: string | undefined;
            components?: Record<string, unknown> | undefined;
            webhooks?: Record<string, unknown> | undefined;
            'x-scalar-active-environment'?: string | undefined;
            'x-scalar-environments'?: Record<string, {
                variables: Record<string, string | {
                    default: string;
                    description?: string | undefined;
                }>;
                color?: string | undefined;
                description?: string | undefined;
            }> | undefined;
            'x-scalar-secrets'?: Record<string, {
                description?: string | undefined;
                example?: string | undefined;
            }> | undefined;
            selectedServerUid?: (string & import("zod").BRAND<"server">) | undefined;
            documentUrl?: string | undefined;
            integration?: string | null | undefined;
        }) => void;
        delete: (uid: (string & import("zod").BRAND<"collection">) | null | undefined) => void;
        set: (item: {
            uid: string & import("zod").BRAND<"collection">;
            type: "collection";
            children: ((string & import("zod").BRAND<"tag">) | (string & import("zod").BRAND<"operation">))[];
            openapi: string;
            info: {
                title: string;
                version: string;
                description?: string | undefined;
                summary?: string | undefined;
                termsOfService?: string | undefined;
                contact?: {
                    name?: string | undefined;
                    url?: string | undefined;
                    email?: string | undefined;
                } | undefined;
                license?: {
                    name?: string | null | undefined;
                    identifier?: string | undefined;
                    url?: string | undefined;
                } | undefined;
                "x-scalar-sdk-installation"?: {
                    lang: string;
                    description?: string | undefined;
                    source?: string | undefined;
                }[] | undefined;
            };
            security: Record<string, string[]>[];
            'x-scalar-icon': string;
            securitySchemes: string[];
            selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
            servers: (string & import("zod").BRAND<"server">)[];
            requests: (string & import("zod").BRAND<"operation">)[];
            tags: (string & import("zod").BRAND<"tag">)[];
            watchMode: boolean;
            useCollectionSecurity: boolean;
            watchModeStatus: "IDLE" | "WATCHING" | "ERROR";
            externalDocs?: {
                url: string;
                description?: string | undefined;
            } | undefined;
            jsonSchemaDialect?: string | undefined;
            components?: Record<string, unknown> | undefined;
            webhooks?: Record<string, unknown> | undefined;
            'x-scalar-active-environment'?: string | undefined;
            'x-scalar-environments'?: Record<string, {
                variables: Record<string, string | {
                    default: string;
                    description?: string | undefined;
                }>;
                color?: string | undefined;
                description?: string | undefined;
            }> | undefined;
            'x-scalar-secrets'?: Record<string, {
                description?: string | undefined;
                example?: string | undefined;
            }> | undefined;
            selectedServerUid?: (string & import("zod").BRAND<"server">) | undefined;
            documentUrl?: string | undefined;
            integration?: string | null | undefined;
        }) => void;
        edit: <P extends "servers" | "tags" | "security" | "externalDocs" | "type" | "uid" | "selectedServerUid" | "selectedSecuritySchemeUids" | "requests" | "x-scalar-environments" | "children" | "openapi" | "info" | "x-scalar-icon" | "securitySchemes" | "watchMode" | "useCollectionSecurity" | "watchModeStatus" | "jsonSchemaDialect" | "components" | "webhooks" | "x-scalar-active-environment" | "x-scalar-secrets" | "documentUrl" | "integration" | `servers.${number}` | `tags.${number}` | `security.${number}` | `security.${number}.${string}` | "externalDocs.url" | "externalDocs.description" | `selectedSecuritySchemeUids.${number}` | `selectedSecuritySchemeUids.${number}.${number}` | `requests.${number}` | `x-scalar-environments.${string}` | `children.${number}` | "info.title" | "info.summary" | "info.description" | "info.version" | "info.termsOfService" | "info.contact" | "info.license" | "info.x-scalar-sdk-installation" | "info.contact.url" | "info.contact.name" | "info.contact.email" | "info.license.url" | "info.license.name" | "info.license.identifier" | `info.x-scalar-sdk-installation.${number}` | `info.x-scalar-sdk-installation.${number}.description` | `info.x-scalar-sdk-installation.${number}.lang` | `info.x-scalar-sdk-installation.${number}.source` | `securitySchemes.${number}` | `components.${string}` | `webhooks.${string}` | `x-scalar-secrets.${string}`>(uid: (string & import("zod").BRAND<"collection">) | null | undefined, path: P, value: P extends "servers" | "tags" | "security" | "externalDocs" | "type" | "uid" | "selectedServerUid" | "selectedSecuritySchemeUids" | "requests" | "x-scalar-environments" | "children" | "openapi" | "info" | "x-scalar-icon" | "securitySchemes" | "watchMode" | "useCollectionSecurity" | "watchModeStatus" | "jsonSchemaDialect" | "components" | "webhooks" | "x-scalar-active-environment" | "x-scalar-secrets" | "documentUrl" | "integration" ? {
            uid: string & import("zod").BRAND<"collection">;
            type: "collection";
            children: ((string & import("zod").BRAND<"tag">) | (string & import("zod").BRAND<"operation">))[];
            openapi: string;
            info: {
                title: string;
                version: string;
                description?: string | undefined;
                summary?: string | undefined;
                termsOfService?: string | undefined;
                contact?: {
                    name?: string | undefined;
                    url?: string | undefined;
                    email?: string | undefined;
                } | undefined;
                license?: {
                    name?: string | null | undefined;
                    identifier?: string | undefined;
                    url?: string | undefined;
                } | undefined;
                "x-scalar-sdk-installation"?: {
                    lang: string;
                    description?: string | undefined;
                    source?: string | undefined;
                }[] | undefined;
            };
            security: Record<string, string[]>[];
            'x-scalar-icon': string;
            securitySchemes: string[];
            selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
            servers: (string & import("zod").BRAND<"server">)[];
            requests: (string & import("zod").BRAND<"operation">)[];
            tags: (string & import("zod").BRAND<"tag">)[];
            watchMode: boolean;
            useCollectionSecurity: boolean;
            watchModeStatus: "IDLE" | "WATCHING" | "ERROR";
            externalDocs?: {
                url: string;
                description?: string | undefined;
            } | undefined;
            jsonSchemaDialect?: string | undefined;
            components?: Record<string, unknown> | undefined;
            webhooks?: Record<string, unknown> | undefined;
            'x-scalar-active-environment'?: string | undefined;
            'x-scalar-environments'?: Record<string, {
                variables: Record<string, string | {
                    default: string;
                    description?: string | undefined;
                }>;
                color?: string | undefined;
                description?: string | undefined;
            }> | undefined;
            'x-scalar-secrets'?: Record<string, {
                description?: string | undefined;
                example?: string | undefined;
            }> | undefined;
            selectedServerUid?: (string & import("zod").BRAND<"server">) | undefined;
            documentUrl?: string | undefined;
            integration?: string | null | undefined;
        }[P] : P extends `${infer K}.${infer R}` ? K extends "servers" | "tags" | "security" | "externalDocs" | "type" | "uid" | "selectedServerUid" | "selectedSecuritySchemeUids" | "requests" | "x-scalar-environments" | "children" | "openapi" | "info" | "x-scalar-icon" | "securitySchemes" | "watchMode" | "useCollectionSecurity" | "watchModeStatus" | "jsonSchemaDialect" | "components" | "webhooks" | "x-scalar-active-environment" | "x-scalar-secrets" | "documentUrl" | "integration" ? R extends import("@scalar/object-utils/nested").Path<{
            uid: string & import("zod").BRAND<"collection">;
            type: "collection";
            children: ((string & import("zod").BRAND<"tag">) | (string & import("zod").BRAND<"operation">))[];
            openapi: string;
            info: {
                title: string;
                version: string;
                description?: string | undefined;
                summary?: string | undefined;
                termsOfService?: string | undefined;
                contact?: {
                    name?: string | undefined;
                    url?: string | undefined;
                    email?: string | undefined;
                } | undefined;
                license?: {
                    name?: string | null | undefined;
                    identifier?: string | undefined;
                    url?: string | undefined;
                } | undefined;
                "x-scalar-sdk-installation"?: {
                    lang: string;
                    description?: string | undefined;
                    source?: string | undefined;
                }[] | undefined;
            };
            security: Record<string, string[]>[];
            'x-scalar-icon': string;
            securitySchemes: string[];
            selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
            servers: (string & import("zod").BRAND<"server">)[];
            requests: (string & import("zod").BRAND<"operation">)[];
            tags: (string & import("zod").BRAND<"tag">)[];
            watchMode: boolean;
            useCollectionSecurity: boolean;
            watchModeStatus: "IDLE" | "WATCHING" | "ERROR";
            externalDocs?: {
                url: string;
                description?: string | undefined;
            } | undefined;
            jsonSchemaDialect?: string | undefined;
            components?: Record<string, unknown> | undefined;
            webhooks?: Record<string, unknown> | undefined;
            'x-scalar-active-environment'?: string | undefined;
            'x-scalar-environments'?: Record<string, {
                variables: Record<string, string | {
                    default: string;
                    description?: string | undefined;
                }>;
                color?: string | undefined;
                description?: string | undefined;
            }> | undefined;
            'x-scalar-secrets'?: Record<string, {
                description?: string | undefined;
                example?: string | undefined;
            }> | undefined;
            selectedServerUid?: (string & import("zod").BRAND<"server">) | undefined;
            documentUrl?: string | undefined;
            integration?: string | null | undefined;
        }[K]> ? import("@scalar/object-utils/nested").PathValue<{
            uid: string & import("zod").BRAND<"collection">;
            type: "collection";
            children: ((string & import("zod").BRAND<"tag">) | (string & import("zod").BRAND<"operation">))[];
            openapi: string;
            info: {
                title: string;
                version: string;
                description?: string | undefined;
                summary?: string | undefined;
                termsOfService?: string | undefined;
                contact?: {
                    name?: string | undefined;
                    url?: string | undefined;
                    email?: string | undefined;
                } | undefined;
                license?: {
                    name?: string | null | undefined;
                    identifier?: string | undefined;
                    url?: string | undefined;
                } | undefined;
                "x-scalar-sdk-installation"?: {
                    lang: string;
                    description?: string | undefined;
                    source?: string | undefined;
                }[] | undefined;
            };
            security: Record<string, string[]>[];
            'x-scalar-icon': string;
            securitySchemes: string[];
            selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
            servers: (string & import("zod").BRAND<"server">)[];
            requests: (string & import("zod").BRAND<"operation">)[];
            tags: (string & import("zod").BRAND<"tag">)[];
            watchMode: boolean;
            useCollectionSecurity: boolean;
            watchModeStatus: "IDLE" | "WATCHING" | "ERROR";
            externalDocs?: {
                url: string;
                description?: string | undefined;
            } | undefined;
            jsonSchemaDialect?: string | undefined;
            components?: Record<string, unknown> | undefined;
            webhooks?: Record<string, unknown> | undefined;
            'x-scalar-active-environment'?: string | undefined;
            'x-scalar-environments'?: Record<string, {
                variables: Record<string, string | {
                    default: string;
                    description?: string | undefined;
                }>;
                color?: string | undefined;
                description?: string | undefined;
            }> | undefined;
            'x-scalar-secrets'?: Record<string, {
                description?: string | undefined;
                example?: string | undefined;
            }> | undefined;
            selectedServerUid?: (string & import("zod").BRAND<"server">) | undefined;
            documentUrl?: string | undefined;
            integration?: string | null | undefined;
        }[K], R> : never : K extends `${number}` ? never : never : P extends `${number}` ? never : never) => void;
        untrackedEdit: <P extends "servers" | "tags" | "security" | "externalDocs" | "type" | "uid" | "selectedServerUid" | "selectedSecuritySchemeUids" | "requests" | "x-scalar-environments" | "children" | "openapi" | "info" | "x-scalar-icon" | "securitySchemes" | "watchMode" | "useCollectionSecurity" | "watchModeStatus" | "jsonSchemaDialect" | "components" | "webhooks" | "x-scalar-active-environment" | "x-scalar-secrets" | "documentUrl" | "integration" | `servers.${number}` | `tags.${number}` | `security.${number}` | `security.${number}.${string}` | "externalDocs.url" | "externalDocs.description" | `selectedSecuritySchemeUids.${number}` | `selectedSecuritySchemeUids.${number}.${number}` | `requests.${number}` | `x-scalar-environments.${string}` | `children.${number}` | "info.title" | "info.summary" | "info.description" | "info.version" | "info.termsOfService" | "info.contact" | "info.license" | "info.x-scalar-sdk-installation" | "info.contact.url" | "info.contact.name" | "info.contact.email" | "info.license.url" | "info.license.name" | "info.license.identifier" | `info.x-scalar-sdk-installation.${number}` | `info.x-scalar-sdk-installation.${number}.description` | `info.x-scalar-sdk-installation.${number}.lang` | `info.x-scalar-sdk-installation.${number}.source` | `securitySchemes.${number}` | `components.${string}` | `webhooks.${string}` | `x-scalar-secrets.${string}`>(uid: string & import("zod").BRAND<"collection">, path: P, value: P extends "servers" | "tags" | "security" | "externalDocs" | "type" | "uid" | "selectedServerUid" | "selectedSecuritySchemeUids" | "requests" | "x-scalar-environments" | "children" | "openapi" | "info" | "x-scalar-icon" | "securitySchemes" | "watchMode" | "useCollectionSecurity" | "watchModeStatus" | "jsonSchemaDialect" | "components" | "webhooks" | "x-scalar-active-environment" | "x-scalar-secrets" | "documentUrl" | "integration" ? {
            uid: string & import("zod").BRAND<"collection">;
            type: "collection";
            children: ((string & import("zod").BRAND<"tag">) | (string & import("zod").BRAND<"operation">))[];
            openapi: string;
            info: {
                title: string;
                version: string;
                description?: string | undefined;
                summary?: string | undefined;
                termsOfService?: string | undefined;
                contact?: {
                    name?: string | undefined;
                    url?: string | undefined;
                    email?: string | undefined;
                } | undefined;
                license?: {
                    name?: string | null | undefined;
                    identifier?: string | undefined;
                    url?: string | undefined;
                } | undefined;
                "x-scalar-sdk-installation"?: {
                    lang: string;
                    description?: string | undefined;
                    source?: string | undefined;
                }[] | undefined;
            };
            security: Record<string, string[]>[];
            'x-scalar-icon': string;
            securitySchemes: string[];
            selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
            servers: (string & import("zod").BRAND<"server">)[];
            requests: (string & import("zod").BRAND<"operation">)[];
            tags: (string & import("zod").BRAND<"tag">)[];
            watchMode: boolean;
            useCollectionSecurity: boolean;
            watchModeStatus: "IDLE" | "WATCHING" | "ERROR";
            externalDocs?: {
                url: string;
                description?: string | undefined;
            } | undefined;
            jsonSchemaDialect?: string | undefined;
            components?: Record<string, unknown> | undefined;
            webhooks?: Record<string, unknown> | undefined;
            'x-scalar-active-environment'?: string | undefined;
            'x-scalar-environments'?: Record<string, {
                variables: Record<string, string | {
                    default: string;
                    description?: string | undefined;
                }>;
                color?: string | undefined;
                description?: string | undefined;
            }> | undefined;
            'x-scalar-secrets'?: Record<string, {
                description?: string | undefined;
                example?: string | undefined;
            }> | undefined;
            selectedServerUid?: (string & import("zod").BRAND<"server">) | undefined;
            documentUrl?: string | undefined;
            integration?: string | null | undefined;
        }[P] : P extends `${infer K}.${infer R}` ? K extends "servers" | "tags" | "security" | "externalDocs" | "type" | "uid" | "selectedServerUid" | "selectedSecuritySchemeUids" | "requests" | "x-scalar-environments" | "children" | "openapi" | "info" | "x-scalar-icon" | "securitySchemes" | "watchMode" | "useCollectionSecurity" | "watchModeStatus" | "jsonSchemaDialect" | "components" | "webhooks" | "x-scalar-active-environment" | "x-scalar-secrets" | "documentUrl" | "integration" ? R extends import("@scalar/object-utils/nested").Path<{
            uid: string & import("zod").BRAND<"collection">;
            type: "collection";
            children: ((string & import("zod").BRAND<"tag">) | (string & import("zod").BRAND<"operation">))[];
            openapi: string;
            info: {
                title: string;
                version: string;
                description?: string | undefined;
                summary?: string | undefined;
                termsOfService?: string | undefined;
                contact?: {
                    name?: string | undefined;
                    url?: string | undefined;
                    email?: string | undefined;
                } | undefined;
                license?: {
                    name?: string | null | undefined;
                    identifier?: string | undefined;
                    url?: string | undefined;
                } | undefined;
                "x-scalar-sdk-installation"?: {
                    lang: string;
                    description?: string | undefined;
                    source?: string | undefined;
                }[] | undefined;
            };
            security: Record<string, string[]>[];
            'x-scalar-icon': string;
            securitySchemes: string[];
            selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
            servers: (string & import("zod").BRAND<"server">)[];
            requests: (string & import("zod").BRAND<"operation">)[];
            tags: (string & import("zod").BRAND<"tag">)[];
            watchMode: boolean;
            useCollectionSecurity: boolean;
            watchModeStatus: "IDLE" | "WATCHING" | "ERROR";
            externalDocs?: {
                url: string;
                description?: string | undefined;
            } | undefined;
            jsonSchemaDialect?: string | undefined;
            components?: Record<string, unknown> | undefined;
            webhooks?: Record<string, unknown> | undefined;
            'x-scalar-active-environment'?: string | undefined;
            'x-scalar-environments'?: Record<string, {
                variables: Record<string, string | {
                    default: string;
                    description?: string | undefined;
                }>;
                color?: string | undefined;
                description?: string | undefined;
            }> | undefined;
            'x-scalar-secrets'?: Record<string, {
                description?: string | undefined;
                example?: string | undefined;
            }> | undefined;
            selectedServerUid?: (string & import("zod").BRAND<"server">) | undefined;
            documentUrl?: string | undefined;
            integration?: string | null | undefined;
        }[K]> ? import("@scalar/object-utils/nested").PathValue<{
            uid: string & import("zod").BRAND<"collection">;
            type: "collection";
            children: ((string & import("zod").BRAND<"tag">) | (string & import("zod").BRAND<"operation">))[];
            openapi: string;
            info: {
                title: string;
                version: string;
                description?: string | undefined;
                summary?: string | undefined;
                termsOfService?: string | undefined;
                contact?: {
                    name?: string | undefined;
                    url?: string | undefined;
                    email?: string | undefined;
                } | undefined;
                license?: {
                    name?: string | null | undefined;
                    identifier?: string | undefined;
                    url?: string | undefined;
                } | undefined;
                "x-scalar-sdk-installation"?: {
                    lang: string;
                    description?: string | undefined;
                    source?: string | undefined;
                }[] | undefined;
            };
            security: Record<string, string[]>[];
            'x-scalar-icon': string;
            securitySchemes: string[];
            selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
            servers: (string & import("zod").BRAND<"server">)[];
            requests: (string & import("zod").BRAND<"operation">)[];
            tags: (string & import("zod").BRAND<"tag">)[];
            watchMode: boolean;
            useCollectionSecurity: boolean;
            watchModeStatus: "IDLE" | "WATCHING" | "ERROR";
            externalDocs?: {
                url: string;
                description?: string | undefined;
            } | undefined;
            jsonSchemaDialect?: string | undefined;
            components?: Record<string, unknown> | undefined;
            webhooks?: Record<string, unknown> | undefined;
            'x-scalar-active-environment'?: string | undefined;
            'x-scalar-environments'?: Record<string, {
                variables: Record<string, string | {
                    default: string;
                    description?: string | undefined;
                }>;
                color?: string | undefined;
                description?: string | undefined;
            }> | undefined;
            'x-scalar-secrets'?: Record<string, {
                description?: string | undefined;
                example?: string | undefined;
            }> | undefined;
            selectedServerUid?: (string & import("zod").BRAND<"server">) | undefined;
            documentUrl?: string | undefined;
            integration?: string | null | undefined;
        }[K], R> : never : K extends `${number}` ? never : never : P extends `${number}` ? never : never) => void;
        undo: (uid: string & import("zod").BRAND<"collection">) => void;
        redo: (uid: string & import("zod").BRAND<"collection">) => void;
        reset: () => void;
    };
};
/** Extended mutators and data for collections that required workspace access */
export declare function extendedCollectionDataFactory({ requests, requestMutators, requestExamples, requestExampleMutators, workspaces, workspaceMutators, collections, collectionMutators, tagMutators, serverMutators, }: StoreContext): {
    addCollection: (payload: CollectionPayload, workspaceUid: Workspace["uid"]) => {
        uid: string & import("zod").BRAND<"collection">;
        type: "collection";
        children: ((string & import("zod").BRAND<"tag">) | (string & import("zod").BRAND<"operation">))[];
        openapi: string;
        info: {
            title: string;
            version: string;
            description?: string | undefined;
            summary?: string | undefined;
            termsOfService?: string | undefined;
            contact?: {
                name?: string | undefined;
                url?: string | undefined;
                email?: string | undefined;
            } | undefined;
            license?: {
                name?: string | null | undefined;
                identifier?: string | undefined;
                url?: string | undefined;
            } | undefined;
            "x-scalar-sdk-installation"?: {
                lang: string;
                description?: string | undefined;
                source?: string | undefined;
            }[] | undefined;
        };
        security: Record<string, string[]>[];
        'x-scalar-icon': string;
        securitySchemes: string[];
        selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
        servers: (string & import("zod").BRAND<"server">)[];
        requests: (string & import("zod").BRAND<"operation">)[];
        tags: (string & import("zod").BRAND<"tag">)[];
        watchMode: boolean;
        useCollectionSecurity: boolean;
        watchModeStatus: "IDLE" | "WATCHING" | "ERROR";
        externalDocs?: {
            url: string;
            description?: string | undefined;
        } | undefined;
        jsonSchemaDialect?: string | undefined;
        components?: Record<string, unknown> | undefined;
        webhooks?: Record<string, unknown> | undefined;
        'x-scalar-active-environment'?: string | undefined;
        'x-scalar-environments'?: Record<string, {
            variables: Record<string, string | {
                default: string;
                description?: string | undefined;
            }>;
            color?: string | undefined;
            description?: string | undefined;
        }> | undefined;
        'x-scalar-secrets'?: Record<string, {
            description?: string | undefined;
            example?: string | undefined;
        }> | undefined;
        selectedServerUid?: (string & import("zod").BRAND<"server">) | undefined;
        documentUrl?: string | undefined;
        integration?: string | null | undefined;
    };
    deleteCollection: (collection: Collection, workspace: Workspace) => void;
    addCollectionEnvironment: (environmentName: string, environment: XScalarEnvironment, collectionUid: Collection["uid"]) => void;
    removeCollectionEnvironment: (environmentName: string, collectionUid: Collection["uid"]) => void;
};
//# sourceMappingURL=collections.d.ts.map