/** Create cookie mutators for the workspace */
export declare function createStoreCookies(useLocalStorage: boolean): {
    cookies: Record<string, {
        uid: string & import("zod").BRAND<"cookie">;
        name: string;
        value: string;
        domain?: string | undefined;
        path?: string | undefined;
    }>;
    cookieMutators: {
        add: (item: {
            uid: string & import("zod").BRAND<"cookie">;
            name: string;
            value: string;
            domain?: string | undefined;
            path?: string | undefined;
        }) => void;
        delete: (uid: (string & import("zod").BRAND<"cookie">) | null | undefined) => void;
        set: (item: {
            uid: string & import("zod").BRAND<"cookie">;
            name: string;
            value: string;
            domain?: string | undefined;
            path?: string | undefined;
        }) => void;
        edit: <P extends "value" | "uid" | "path" | "name" | "domain">(uid: (string & import("zod").BRAND<"cookie">) | null | undefined, path: P, value: P extends "value" | "uid" | "path" | "name" | "domain" ? {
            uid: string & import("zod").BRAND<"cookie">;
            name: string;
            value: string;
            domain?: string | undefined;
            path?: string | undefined;
        }[P] : P extends `${infer K}.${infer R}` ? K extends "value" | "uid" | "path" | "name" | "domain" ? R extends import("@scalar/object-utils/nested").Path<{
            uid: string & import("zod").BRAND<"cookie">;
            name: string;
            value: string;
            domain?: string | undefined;
            path?: string | undefined;
        }[K]> ? import("@scalar/object-utils/nested").PathValue<{
            uid: string & import("zod").BRAND<"cookie">;
            name: string;
            value: string;
            domain?: string | undefined;
            path?: string | undefined;
        }[K], R> : never : K extends `${number}` ? never : never : P extends `${number}` ? never : never) => void;
        untrackedEdit: <P extends "value" | "uid" | "path" | "name" | "domain">(uid: string & import("zod").BRAND<"cookie">, path: P, value: P extends "value" | "uid" | "path" | "name" | "domain" ? {
            uid: string & import("zod").BRAND<"cookie">;
            name: string;
            value: string;
            domain?: string | undefined;
            path?: string | undefined;
        }[P] : P extends `${infer K}.${infer R}` ? K extends "value" | "uid" | "path" | "name" | "domain" ? R extends import("@scalar/object-utils/nested").Path<{
            uid: string & import("zod").BRAND<"cookie">;
            name: string;
            value: string;
            domain?: string | undefined;
            path?: string | undefined;
        }[K]> ? import("@scalar/object-utils/nested").PathValue<{
            uid: string & import("zod").BRAND<"cookie">;
            name: string;
            value: string;
            domain?: string | undefined;
            path?: string | undefined;
        }[K], R> : never : K extends `${number}` ? never : never : P extends `${number}` ? never : never) => void;
        undo: (uid: string & import("zod").BRAND<"cookie">) => void;
        redo: (uid: string & import("zod").BRAND<"cookie">) => void;
        reset: () => void;
    };
};
//# sourceMappingURL=cookies.d.ts.map