import type { extendedTagDataFactory } from '../store/tags';
import { type Collection, type Request, type RequestPayload, type Tag } from '@scalar/oas-utils/entities/spec';
import type { StoreContext } from './store-context';
/** Create top level request handlers for a workspace */
export declare function createStoreRequests(useLocalStorage: boolean): {
    requests: Record<string, {
        uid: string & import("zod").BRAND<"operation">;
        path: string;
        type: "request";
        selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
        selectedServerUid: (string & import("zod").BRAND<"server">) | null;
        servers: (string & import("zod").BRAND<"server">)[];
        examples: (string & import("zod").BRAND<"example">)[];
        method: "options" | "connect" | "delete" | "get" | "head" | "patch" | "post" | "put" | "trace";
        description?: string | undefined;
        summary?: string | undefined;
        externalDocs?: {
            url: string;
            description?: string | undefined;
        } | undefined;
        'x-internal'?: boolean | undefined;
        'x-scalar-ignore'?: boolean | undefined;
        security?: Record<string, string[]>[] | undefined;
        tags?: string[] | undefined;
        deprecated?: boolean | undefined;
        operationId?: string | undefined;
        parameters?: {
            name: string;
            required: boolean;
            deprecated: boolean;
            in: "cookie" | "path" | "query" | "header";
            description?: string | undefined;
            example?: unknown;
            examples?: unknown[] | Record<string, {
                value?: unknown;
                summary?: string | undefined;
                externalValue?: string | undefined;
            }> | undefined;
            schema?: unknown;
            content?: unknown;
            style?: "matrix" | "simple" | "form" | "label" | "spaceDelimited" | "pipeDelimited" | "deepObject" | undefined;
            explode?: boolean | undefined;
        }[] | undefined;
        requestBody?: any;
        responses?: Record<string, any> | undefined;
        callbacks?: Record<string, Record<string, Record<string, any>>> | undefined;
        'x-scalar-stability'?: import("@scalar/types").XScalarStability | undefined;
        'x-post-response'?: string | undefined;
        'x-codeSamples'?: {
            source: string;
            label?: string | undefined;
            lang?: string | undefined;
        }[] | undefined;
        'x-code-samples'?: {
            source: string;
            label?: string | undefined;
            lang?: string | undefined;
        }[] | undefined;
        'x-custom-examples'?: {
            source: string;
            label?: string | undefined;
            lang?: string | undefined;
        }[] | undefined;
    }>;
    requestMutators: {
        add: (item: {
            uid: string & import("zod").BRAND<"operation">;
            path: string;
            type: "request";
            selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
            selectedServerUid: (string & import("zod").BRAND<"server">) | null;
            servers: (string & import("zod").BRAND<"server">)[];
            examples: (string & import("zod").BRAND<"example">)[];
            method: "options" | "connect" | "delete" | "get" | "head" | "patch" | "post" | "put" | "trace";
            description?: string | undefined;
            summary?: string | undefined;
            externalDocs?: {
                url: string;
                description?: string | undefined;
            } | undefined;
            'x-internal'?: boolean | undefined;
            'x-scalar-ignore'?: boolean | undefined;
            security?: Record<string, string[]>[] | undefined;
            tags?: string[] | undefined;
            deprecated?: boolean | undefined;
            operationId?: string | undefined;
            parameters?: {
                name: string;
                required: boolean;
                deprecated: boolean;
                in: "cookie" | "path" | "query" | "header";
                description?: string | undefined;
                example?: unknown;
                examples?: unknown[] | Record<string, {
                    value?: unknown;
                    summary?: string | undefined;
                    externalValue?: string | undefined;
                }> | undefined;
                schema?: unknown;
                content?: unknown;
                style?: "matrix" | "simple" | "form" | "label" | "spaceDelimited" | "pipeDelimited" | "deepObject" | undefined;
                explode?: boolean | undefined;
            }[] | undefined;
            requestBody?: any;
            responses?: Record<string, any> | undefined;
            callbacks?: Record<string, Record<string, Record<string, any>>> | undefined;
            'x-scalar-stability'?: import("@scalar/types").XScalarStability | undefined;
            'x-post-response'?: string | undefined;
            'x-codeSamples'?: {
                source: string;
                label?: string | undefined;
                lang?: string | undefined;
            }[] | undefined;
            'x-code-samples'?: {
                source: string;
                label?: string | undefined;
                lang?: string | undefined;
            }[] | undefined;
            'x-custom-examples'?: {
                source: string;
                label?: string | undefined;
                lang?: string | undefined;
            }[] | undefined;
        }) => void;
        delete: (uid: (string & import("zod").BRAND<"operation">) | null | undefined) => void;
        set: (item: {
            uid: string & import("zod").BRAND<"operation">;
            path: string;
            type: "request";
            selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
            selectedServerUid: (string & import("zod").BRAND<"server">) | null;
            servers: (string & import("zod").BRAND<"server">)[];
            examples: (string & import("zod").BRAND<"example">)[];
            method: "options" | "connect" | "delete" | "get" | "head" | "patch" | "post" | "put" | "trace";
            description?: string | undefined;
            summary?: string | undefined;
            externalDocs?: {
                url: string;
                description?: string | undefined;
            } | undefined;
            'x-internal'?: boolean | undefined;
            'x-scalar-ignore'?: boolean | undefined;
            security?: Record<string, string[]>[] | undefined;
            tags?: string[] | undefined;
            deprecated?: boolean | undefined;
            operationId?: string | undefined;
            parameters?: {
                name: string;
                required: boolean;
                deprecated: boolean;
                in: "cookie" | "path" | "query" | "header";
                description?: string | undefined;
                example?: unknown;
                examples?: unknown[] | Record<string, {
                    value?: unknown;
                    summary?: string | undefined;
                    externalValue?: string | undefined;
                }> | undefined;
                schema?: unknown;
                content?: unknown;
                style?: "matrix" | "simple" | "form" | "label" | "spaceDelimited" | "pipeDelimited" | "deepObject" | undefined;
                explode?: boolean | undefined;
            }[] | undefined;
            requestBody?: any;
            responses?: Record<string, any> | undefined;
            callbacks?: Record<string, Record<string, Record<string, any>>> | undefined;
            'x-scalar-stability'?: import("@scalar/types").XScalarStability | undefined;
            'x-post-response'?: string | undefined;
            'x-codeSamples'?: {
                source: string;
                label?: string | undefined;
                lang?: string | undefined;
            }[] | undefined;
            'x-code-samples'?: {
                source: string;
                label?: string | undefined;
                lang?: string | undefined;
            }[] | undefined;
            'x-custom-examples'?: {
                source: string;
                label?: string | undefined;
                lang?: string | undefined;
            }[] | undefined;
        }) => void;
        edit: <P extends "servers" | "tags" | "summary" | "description" | "operationId" | "security" | "requestBody" | "parameters" | "externalDocs" | "deprecated" | "responses" | "callbacks" | "x-internal" | "x-scalar-ignore" | "x-codeSamples" | "x-code-samples" | "x-custom-examples" | "x-scalar-stability" | "type" | "uid" | "path" | "method" | "selectedServerUid" | "examples" | "selectedSecuritySchemeUids" | `servers.${number}` | `tags.${number}` | `security.${number}` | `security.${number}.${string}` | "externalDocs.url" | "externalDocs.description" | `selectedSecuritySchemeUids.${number}` | `selectedSecuritySchemeUids.${number}.${number}` | "x-post-response" | `requestBody.${string}` | `examples.${number}` | `parameters.${number}` | `parameters.${number}.description` | `parameters.${number}.content` | `parameters.${number}.deprecated` | `parameters.${number}.examples` | `parameters.${number}.example` | `parameters.${number}.name` | `parameters.${number}.in` | `parameters.${number}.style` | `parameters.${number}.required` | `parameters.${number}.explode` | `parameters.${number}.schema` | `parameters.${number}.examples.${number}` | `parameters.${number}.examples.${string}` | `responses.${string}` | `callbacks.${string}` | `x-codeSamples.${number}` | `x-codeSamples.${number}.lang` | `x-codeSamples.${number}.source` | `x-codeSamples.${number}.label` | `x-code-samples.${number}` | `x-code-samples.${number}.lang` | `x-code-samples.${number}.source` | `x-code-samples.${number}.label` | `x-custom-examples.${number}` | `x-custom-examples.${number}.lang` | `x-custom-examples.${number}.source` | `x-custom-examples.${number}.label`>(uid: (string & import("zod").BRAND<"operation">) | null | undefined, path: P, value: P extends "servers" | "tags" | "summary" | "description" | "operationId" | "security" | "requestBody" | "parameters" | "externalDocs" | "deprecated" | "responses" | "callbacks" | "x-internal" | "x-scalar-ignore" | "x-codeSamples" | "x-code-samples" | "x-custom-examples" | "x-scalar-stability" | "type" | "uid" | "path" | "method" | "selectedServerUid" | "examples" | "selectedSecuritySchemeUids" | "x-post-response" ? {
            uid: string & import("zod").BRAND<"operation">;
            path: string;
            type: "request";
            selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
            selectedServerUid: (string & import("zod").BRAND<"server">) | null;
            servers: (string & import("zod").BRAND<"server">)[];
            examples: (string & import("zod").BRAND<"example">)[];
            method: "options" | "connect" | "delete" | "get" | "head" | "patch" | "post" | "put" | "trace";
            description?: string | undefined;
            summary?: string | undefined;
            externalDocs?: {
                url: string;
                description?: string | undefined;
            } | undefined;
            'x-internal'?: boolean | undefined;
            'x-scalar-ignore'?: boolean | undefined;
            security?: Record<string, string[]>[] | undefined;
            tags?: string[] | undefined;
            deprecated?: boolean | undefined;
            operationId?: string | undefined;
            parameters?: {
                name: string;
                required: boolean;
                deprecated: boolean;
                in: "cookie" | "path" | "query" | "header";
                description?: string | undefined;
                example?: unknown;
                examples?: unknown[] | Record<string, {
                    value?: unknown;
                    summary?: string | undefined;
                    externalValue?: string | undefined;
                }> | undefined;
                schema?: unknown;
                content?: unknown;
                style?: "matrix" | "simple" | "form" | "label" | "spaceDelimited" | "pipeDelimited" | "deepObject" | undefined;
                explode?: boolean | undefined;
            }[] | undefined;
            requestBody?: any;
            responses?: Record<string, any> | undefined;
            callbacks?: Record<string, Record<string, Record<string, any>>> | undefined;
            'x-scalar-stability'?: import("@scalar/types").XScalarStability | undefined;
            'x-post-response'?: string | undefined;
            'x-codeSamples'?: {
                source: string;
                label?: string | undefined;
                lang?: string | undefined;
            }[] | undefined;
            'x-code-samples'?: {
                source: string;
                label?: string | undefined;
                lang?: string | undefined;
            }[] | undefined;
            'x-custom-examples'?: {
                source: string;
                label?: string | undefined;
                lang?: string | undefined;
            }[] | undefined;
        }[P] : P extends `${infer K}.${infer R}` ? K extends "servers" | "tags" | "summary" | "description" | "operationId" | "security" | "requestBody" | "parameters" | "externalDocs" | "deprecated" | "responses" | "callbacks" | "x-internal" | "x-scalar-ignore" | "x-codeSamples" | "x-code-samples" | "x-custom-examples" | "x-scalar-stability" | "type" | "uid" | "path" | "method" | "selectedServerUid" | "examples" | "selectedSecuritySchemeUids" | "x-post-response" ? R extends import("@scalar/object-utils/nested").Path<{
            uid: string & import("zod").BRAND<"operation">;
            path: string;
            type: "request";
            selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
            selectedServerUid: (string & import("zod").BRAND<"server">) | null;
            servers: (string & import("zod").BRAND<"server">)[];
            examples: (string & import("zod").BRAND<"example">)[];
            method: "options" | "connect" | "delete" | "get" | "head" | "patch" | "post" | "put" | "trace";
            description?: string | undefined;
            summary?: string | undefined;
            externalDocs?: {
                url: string;
                description?: string | undefined;
            } | undefined;
            'x-internal'?: boolean | undefined;
            'x-scalar-ignore'?: boolean | undefined;
            security?: Record<string, string[]>[] | undefined;
            tags?: string[] | undefined;
            deprecated?: boolean | undefined;
            operationId?: string | undefined;
            parameters?: {
                name: string;
                required: boolean;
                deprecated: boolean;
                in: "cookie" | "path" | "query" | "header";
                description?: string | undefined;
                example?: unknown;
                examples?: unknown[] | Record<string, {
                    value?: unknown;
                    summary?: string | undefined;
                    externalValue?: string | undefined;
                }> | undefined;
                schema?: unknown;
                content?: unknown;
                style?: "matrix" | "simple" | "form" | "label" | "spaceDelimited" | "pipeDelimited" | "deepObject" | undefined;
                explode?: boolean | undefined;
            }[] | undefined;
            requestBody?: any;
            responses?: Record<string, any> | undefined;
            callbacks?: Record<string, Record<string, Record<string, any>>> | undefined;
            'x-scalar-stability'?: import("@scalar/types").XScalarStability | undefined;
            'x-post-response'?: string | undefined;
            'x-codeSamples'?: {
                source: string;
                label?: string | undefined;
                lang?: string | undefined;
            }[] | undefined;
            'x-code-samples'?: {
                source: string;
                label?: string | undefined;
                lang?: string | undefined;
            }[] | undefined;
            'x-custom-examples'?: {
                source: string;
                label?: string | undefined;
                lang?: string | undefined;
            }[] | undefined;
        }[K]> ? import("@scalar/object-utils/nested").PathValue<{
            uid: string & import("zod").BRAND<"operation">;
            path: string;
            type: "request";
            selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
            selectedServerUid: (string & import("zod").BRAND<"server">) | null;
            servers: (string & import("zod").BRAND<"server">)[];
            examples: (string & import("zod").BRAND<"example">)[];
            method: "options" | "connect" | "delete" | "get" | "head" | "patch" | "post" | "put" | "trace";
            description?: string | undefined;
            summary?: string | undefined;
            externalDocs?: {
                url: string;
                description?: string | undefined;
            } | undefined;
            'x-internal'?: boolean | undefined;
            'x-scalar-ignore'?: boolean | undefined;
            security?: Record<string, string[]>[] | undefined;
            tags?: string[] | undefined;
            deprecated?: boolean | undefined;
            operationId?: string | undefined;
            parameters?: {
                name: string;
                required: boolean;
                deprecated: boolean;
                in: "cookie" | "path" | "query" | "header";
                description?: string | undefined;
                example?: unknown;
                examples?: unknown[] | Record<string, {
                    value?: unknown;
                    summary?: string | undefined;
                    externalValue?: string | undefined;
                }> | undefined;
                schema?: unknown;
                content?: unknown;
                style?: "matrix" | "simple" | "form" | "label" | "spaceDelimited" | "pipeDelimited" | "deepObject" | undefined;
                explode?: boolean | undefined;
            }[] | undefined;
            requestBody?: any;
            responses?: Record<string, any> | undefined;
            callbacks?: Record<string, Record<string, Record<string, any>>> | undefined;
            'x-scalar-stability'?: import("@scalar/types").XScalarStability | undefined;
            'x-post-response'?: string | undefined;
            'x-codeSamples'?: {
                source: string;
                label?: string | undefined;
                lang?: string | undefined;
            }[] | undefined;
            'x-code-samples'?: {
                source: string;
                label?: string | undefined;
                lang?: string | undefined;
            }[] | undefined;
            'x-custom-examples'?: {
                source: string;
                label?: string | undefined;
                lang?: string | undefined;
            }[] | undefined;
        }[K], R> : never : K extends `${number}` ? never : never : P extends `${number}` ? never : never) => void;
        untrackedEdit: <P extends "servers" | "tags" | "summary" | "description" | "operationId" | "security" | "requestBody" | "parameters" | "externalDocs" | "deprecated" | "responses" | "callbacks" | "x-internal" | "x-scalar-ignore" | "x-codeSamples" | "x-code-samples" | "x-custom-examples" | "x-scalar-stability" | "type" | "uid" | "path" | "method" | "selectedServerUid" | "examples" | "selectedSecuritySchemeUids" | `servers.${number}` | `tags.${number}` | `security.${number}` | `security.${number}.${string}` | "externalDocs.url" | "externalDocs.description" | `selectedSecuritySchemeUids.${number}` | `selectedSecuritySchemeUids.${number}.${number}` | "x-post-response" | `requestBody.${string}` | `examples.${number}` | `parameters.${number}` | `parameters.${number}.description` | `parameters.${number}.content` | `parameters.${number}.deprecated` | `parameters.${number}.examples` | `parameters.${number}.example` | `parameters.${number}.name` | `parameters.${number}.in` | `parameters.${number}.style` | `parameters.${number}.required` | `parameters.${number}.explode` | `parameters.${number}.schema` | `parameters.${number}.examples.${number}` | `parameters.${number}.examples.${string}` | `responses.${string}` | `callbacks.${string}` | `x-codeSamples.${number}` | `x-codeSamples.${number}.lang` | `x-codeSamples.${number}.source` | `x-codeSamples.${number}.label` | `x-code-samples.${number}` | `x-code-samples.${number}.lang` | `x-code-samples.${number}.source` | `x-code-samples.${number}.label` | `x-custom-examples.${number}` | `x-custom-examples.${number}.lang` | `x-custom-examples.${number}.source` | `x-custom-examples.${number}.label`>(uid: string & import("zod").BRAND<"operation">, path: P, value: P extends "servers" | "tags" | "summary" | "description" | "operationId" | "security" | "requestBody" | "parameters" | "externalDocs" | "deprecated" | "responses" | "callbacks" | "x-internal" | "x-scalar-ignore" | "x-codeSamples" | "x-code-samples" | "x-custom-examples" | "x-scalar-stability" | "type" | "uid" | "path" | "method" | "selectedServerUid" | "examples" | "selectedSecuritySchemeUids" | "x-post-response" ? {
            uid: string & import("zod").BRAND<"operation">;
            path: string;
            type: "request";
            selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
            selectedServerUid: (string & import("zod").BRAND<"server">) | null;
            servers: (string & import("zod").BRAND<"server">)[];
            examples: (string & import("zod").BRAND<"example">)[];
            method: "options" | "connect" | "delete" | "get" | "head" | "patch" | "post" | "put" | "trace";
            description?: string | undefined;
            summary?: string | undefined;
            externalDocs?: {
                url: string;
                description?: string | undefined;
            } | undefined;
            'x-internal'?: boolean | undefined;
            'x-scalar-ignore'?: boolean | undefined;
            security?: Record<string, string[]>[] | undefined;
            tags?: string[] | undefined;
            deprecated?: boolean | undefined;
            operationId?: string | undefined;
            parameters?: {
                name: string;
                required: boolean;
                deprecated: boolean;
                in: "cookie" | "path" | "query" | "header";
                description?: string | undefined;
                example?: unknown;
                examples?: unknown[] | Record<string, {
                    value?: unknown;
                    summary?: string | undefined;
                    externalValue?: string | undefined;
                }> | undefined;
                schema?: unknown;
                content?: unknown;
                style?: "matrix" | "simple" | "form" | "label" | "spaceDelimited" | "pipeDelimited" | "deepObject" | undefined;
                explode?: boolean | undefined;
            }[] | undefined;
            requestBody?: any;
            responses?: Record<string, any> | undefined;
            callbacks?: Record<string, Record<string, Record<string, any>>> | undefined;
            'x-scalar-stability'?: import("@scalar/types").XScalarStability | undefined;
            'x-post-response'?: string | undefined;
            'x-codeSamples'?: {
                source: string;
                label?: string | undefined;
                lang?: string | undefined;
            }[] | undefined;
            'x-code-samples'?: {
                source: string;
                label?: string | undefined;
                lang?: string | undefined;
            }[] | undefined;
            'x-custom-examples'?: {
                source: string;
                label?: string | undefined;
                lang?: string | undefined;
            }[] | undefined;
        }[P] : P extends `${infer K}.${infer R}` ? K extends "servers" | "tags" | "summary" | "description" | "operationId" | "security" | "requestBody" | "parameters" | "externalDocs" | "deprecated" | "responses" | "callbacks" | "x-internal" | "x-scalar-ignore" | "x-codeSamples" | "x-code-samples" | "x-custom-examples" | "x-scalar-stability" | "type" | "uid" | "path" | "method" | "selectedServerUid" | "examples" | "selectedSecuritySchemeUids" | "x-post-response" ? R extends import("@scalar/object-utils/nested").Path<{
            uid: string & import("zod").BRAND<"operation">;
            path: string;
            type: "request";
            selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
            selectedServerUid: (string & import("zod").BRAND<"server">) | null;
            servers: (string & import("zod").BRAND<"server">)[];
            examples: (string & import("zod").BRAND<"example">)[];
            method: "options" | "connect" | "delete" | "get" | "head" | "patch" | "post" | "put" | "trace";
            description?: string | undefined;
            summary?: string | undefined;
            externalDocs?: {
                url: string;
                description?: string | undefined;
            } | undefined;
            'x-internal'?: boolean | undefined;
            'x-scalar-ignore'?: boolean | undefined;
            security?: Record<string, string[]>[] | undefined;
            tags?: string[] | undefined;
            deprecated?: boolean | undefined;
            operationId?: string | undefined;
            parameters?: {
                name: string;
                required: boolean;
                deprecated: boolean;
                in: "cookie" | "path" | "query" | "header";
                description?: string | undefined;
                example?: unknown;
                examples?: unknown[] | Record<string, {
                    value?: unknown;
                    summary?: string | undefined;
                    externalValue?: string | undefined;
                }> | undefined;
                schema?: unknown;
                content?: unknown;
                style?: "matrix" | "simple" | "form" | "label" | "spaceDelimited" | "pipeDelimited" | "deepObject" | undefined;
                explode?: boolean | undefined;
            }[] | undefined;
            requestBody?: any;
            responses?: Record<string, any> | undefined;
            callbacks?: Record<string, Record<string, Record<string, any>>> | undefined;
            'x-scalar-stability'?: import("@scalar/types").XScalarStability | undefined;
            'x-post-response'?: string | undefined;
            'x-codeSamples'?: {
                source: string;
                label?: string | undefined;
                lang?: string | undefined;
            }[] | undefined;
            'x-code-samples'?: {
                source: string;
                label?: string | undefined;
                lang?: string | undefined;
            }[] | undefined;
            'x-custom-examples'?: {
                source: string;
                label?: string | undefined;
                lang?: string | undefined;
            }[] | undefined;
        }[K]> ? import("@scalar/object-utils/nested").PathValue<{
            uid: string & import("zod").BRAND<"operation">;
            path: string;
            type: "request";
            selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
            selectedServerUid: (string & import("zod").BRAND<"server">) | null;
            servers: (string & import("zod").BRAND<"server">)[];
            examples: (string & import("zod").BRAND<"example">)[];
            method: "options" | "connect" | "delete" | "get" | "head" | "patch" | "post" | "put" | "trace";
            description?: string | undefined;
            summary?: string | undefined;
            externalDocs?: {
                url: string;
                description?: string | undefined;
            } | undefined;
            'x-internal'?: boolean | undefined;
            'x-scalar-ignore'?: boolean | undefined;
            security?: Record<string, string[]>[] | undefined;
            tags?: string[] | undefined;
            deprecated?: boolean | undefined;
            operationId?: string | undefined;
            parameters?: {
                name: string;
                required: boolean;
                deprecated: boolean;
                in: "cookie" | "path" | "query" | "header";
                description?: string | undefined;
                example?: unknown;
                examples?: unknown[] | Record<string, {
                    value?: unknown;
                    summary?: string | undefined;
                    externalValue?: string | undefined;
                }> | undefined;
                schema?: unknown;
                content?: unknown;
                style?: "matrix" | "simple" | "form" | "label" | "spaceDelimited" | "pipeDelimited" | "deepObject" | undefined;
                explode?: boolean | undefined;
            }[] | undefined;
            requestBody?: any;
            responses?: Record<string, any> | undefined;
            callbacks?: Record<string, Record<string, Record<string, any>>> | undefined;
            'x-scalar-stability'?: import("@scalar/types").XScalarStability | undefined;
            'x-post-response'?: string | undefined;
            'x-codeSamples'?: {
                source: string;
                label?: string | undefined;
                lang?: string | undefined;
            }[] | undefined;
            'x-code-samples'?: {
                source: string;
                label?: string | undefined;
                lang?: string | undefined;
            }[] | undefined;
            'x-custom-examples'?: {
                source: string;
                label?: string | undefined;
                lang?: string | undefined;
            }[] | undefined;
        }[K], R> : never : K extends `${number}` ? never : never : P extends `${number}` ? never : never) => void;
        undo: (uid: string & import("zod").BRAND<"operation">) => void;
        redo: (uid: string & import("zod").BRAND<"operation">) => void;
        reset: () => void;
    };
};
type AddTag = ReturnType<typeof extendedTagDataFactory>['addTag'];
/**
 * Create the extended mutators for request where access to the workspace is required
 */
export declare function extendedRequestDataFactory({ requestExamples, requestExampleMutators, requestMutators, collectionMutators, collections, tags, tagMutators, }: StoreContext, addTag: AddTag): {
    addRequest: (payload: RequestPayload, collectionUid: Collection["uid"]) => void | {
        uid: string & import("zod").BRAND<"operation">;
        path: string;
        type: "request";
        selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
        selectedServerUid: (string & import("zod").BRAND<"server">) | null;
        servers: (string & import("zod").BRAND<"server">)[];
        examples: (string & import("zod").BRAND<"example">)[];
        method: "options" | "connect" | "delete" | "get" | "head" | "patch" | "post" | "put" | "trace";
        description?: string | undefined;
        summary?: string | undefined;
        externalDocs?: {
            url: string;
            description?: string | undefined;
        } | undefined;
        'x-internal'?: boolean | undefined;
        'x-scalar-ignore'?: boolean | undefined;
        security?: Record<string, string[]>[] | undefined;
        tags?: string[] | undefined;
        deprecated?: boolean | undefined;
        operationId?: string | undefined;
        parameters?: {
            name: string;
            required: boolean;
            deprecated: boolean;
            in: "cookie" | "path" | "query" | "header";
            description?: string | undefined;
            example?: unknown;
            examples?: unknown[] | Record<string, {
                value?: unknown;
                summary?: string | undefined;
                externalValue?: string | undefined;
            }> | undefined;
            schema?: unknown;
            content?: unknown;
            style?: "matrix" | "simple" | "form" | "label" | "spaceDelimited" | "pipeDelimited" | "deepObject" | undefined;
            explode?: boolean | undefined;
        }[] | undefined;
        requestBody?: any;
        responses?: Record<string, any> | undefined;
        callbacks?: Record<string, Record<string, Record<string, any>>> | undefined;
        'x-scalar-stability'?: import("@scalar/types").XScalarStability | undefined;
        'x-post-response'?: string | undefined;
        'x-codeSamples'?: {
            source: string;
            label?: string | undefined;
            lang?: string | undefined;
        }[] | undefined;
        'x-code-samples'?: {
            source: string;
            label?: string | undefined;
            lang?: string | undefined;
        }[] | undefined;
        'x-custom-examples'?: {
            source: string;
            label?: string | undefined;
            lang?: string | undefined;
        }[] | undefined;
    };
    deleteRequest: (request: Request, collectionUid: Collection["uid"]) => void;
    findRequestParents: (r: Request) => string[];
};
/** Factory function to allow testing of the function */
export declare function findRequestParentsFactory({ collections, tags, }: {
    collections: Record<string, Collection>;
    tags: Record<string, Tag>;
}): (r: Request) => string[];
/** First draft request" */
export declare function createInitialRequest(): {
    request: {
        uid: string & import("zod").BRAND<"operation">;
        path: string;
        type: "request";
        selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
        selectedServerUid: (string & import("zod").BRAND<"server">) | null;
        servers: (string & import("zod").BRAND<"server">)[];
        examples: (string & import("zod").BRAND<"example">)[];
        method: "options" | "connect" | "delete" | "get" | "head" | "patch" | "post" | "put" | "trace";
        description?: string | undefined;
        summary?: string | undefined;
        externalDocs?: {
            url: string;
            description?: string | undefined;
        } | undefined;
        'x-internal'?: boolean | undefined;
        'x-scalar-ignore'?: boolean | undefined;
        security?: Record<string, string[]>[] | undefined;
        tags?: string[] | undefined;
        deprecated?: boolean | undefined;
        operationId?: string | undefined;
        parameters?: {
            name: string;
            required: boolean;
            deprecated: boolean;
            in: "cookie" | "path" | "query" | "header";
            description?: string | undefined;
            example?: unknown;
            examples?: unknown[] | Record<string, {
                value?: unknown;
                summary?: string | undefined;
                externalValue?: string | undefined;
            }> | undefined;
            schema?: unknown;
            content?: unknown;
            style?: "matrix" | "simple" | "form" | "label" | "spaceDelimited" | "pipeDelimited" | "deepObject" | undefined;
            explode?: boolean | undefined;
        }[] | undefined;
        requestBody?: any;
        responses?: Record<string, any> | undefined;
        callbacks?: Record<string, Record<string, Record<string, any>>> | undefined;
        'x-scalar-stability'?: import("@scalar/types").XScalarStability | undefined;
        'x-post-response'?: string | undefined;
        'x-codeSamples'?: {
            source: string;
            label?: string | undefined;
            lang?: string | undefined;
        }[] | undefined;
        'x-code-samples'?: {
            source: string;
            label?: string | undefined;
            lang?: string | undefined;
        }[] | undefined;
        'x-custom-examples'?: {
            source: string;
            label?: string | undefined;
            lang?: string | undefined;
        }[] | undefined;
    };
};
export {};
//# sourceMappingURL=requests.d.ts.map