import type { StoreContext } from '../store/store-context';
import { type Collection, type Server, type ServerPayload } from '@scalar/oas-utils/entities/spec';
/** Create storage objects for servers */
export declare function createStoreServers(useLocalStorage: boolean): {
    servers: Record<string, {
        uid: string & import("zod").BRAND<"server">;
        url: string;
        description?: string | undefined;
        variables?: Record<string, {
            value?: string | undefined;
            description?: string | undefined;
            default?: string | undefined;
            enum?: string[] | undefined;
        }> | undefined;
    }>;
    serverMutators: {
        add: (item: {
            uid: string & import("zod").BRAND<"server">;
            url: string;
            description?: string | undefined;
            variables?: Record<string, {
                value?: string | undefined;
                description?: string | undefined;
                default?: string | undefined;
                enum?: string[] | undefined;
            }> | undefined;
        }) => void;
        delete: (uid: (string & import("zod").BRAND<"server">) | null | undefined) => void;
        set: (item: {
            uid: string & import("zod").BRAND<"server">;
            url: string;
            description?: string | undefined;
            variables?: Record<string, {
                value?: string | undefined;
                description?: string | undefined;
                default?: string | undefined;
                enum?: string[] | undefined;
            }> | undefined;
        }) => void;
        edit: <P extends "url" | "description" | "uid" | "variables" | `variables.${string}`>(uid: (string & import("zod").BRAND<"server">) | null | undefined, path: P, value: P extends "url" | "description" | "uid" | "variables" ? {
            uid: string & import("zod").BRAND<"server">;
            url: string;
            description?: string | undefined;
            variables?: Record<string, {
                value?: string | undefined;
                description?: string | undefined;
                default?: string | undefined;
                enum?: string[] | undefined;
            }> | undefined;
        }[P] : P extends `${infer K}.${infer R}` ? K extends "url" | "description" | "uid" | "variables" ? R extends import("@scalar/object-utils/nested").Path<{
            uid: string & import("zod").BRAND<"server">;
            url: string;
            description?: string | undefined;
            variables?: Record<string, {
                value?: string | undefined;
                description?: string | undefined;
                default?: string | undefined;
                enum?: string[] | undefined;
            }> | undefined;
        }[K]> ? import("@scalar/object-utils/nested").PathValue<{
            uid: string & import("zod").BRAND<"server">;
            url: string;
            description?: string | undefined;
            variables?: Record<string, {
                value?: string | undefined;
                description?: string | undefined;
                default?: string | undefined;
                enum?: string[] | undefined;
            }> | undefined;
        }[K], R> : never : K extends `${number}` ? never : never : P extends `${number}` ? never : never) => void;
        untrackedEdit: <P extends "url" | "description" | "uid" | "variables" | `variables.${string}`>(uid: string & import("zod").BRAND<"server">, path: P, value: P extends "url" | "description" | "uid" | "variables" ? {
            uid: string & import("zod").BRAND<"server">;
            url: string;
            description?: string | undefined;
            variables?: Record<string, {
                value?: string | undefined;
                description?: string | undefined;
                default?: string | undefined;
                enum?: string[] | undefined;
            }> | undefined;
        }[P] : P extends `${infer K}.${infer R}` ? K extends "url" | "description" | "uid" | "variables" ? R extends import("@scalar/object-utils/nested").Path<{
            uid: string & import("zod").BRAND<"server">;
            url: string;
            description?: string | undefined;
            variables?: Record<string, {
                value?: string | undefined;
                description?: string | undefined;
                default?: string | undefined;
                enum?: string[] | undefined;
            }> | undefined;
        }[K]> ? import("@scalar/object-utils/nested").PathValue<{
            uid: string & import("zod").BRAND<"server">;
            url: string;
            description?: string | undefined;
            variables?: Record<string, {
                value?: string | undefined;
                description?: string | undefined;
                default?: string | undefined;
                enum?: string[] | undefined;
            }> | undefined;
        }[K], R> : never : K extends `${number}` ? never : never : P extends `${number}` ? never : never) => void;
        undo: (uid: string & import("zod").BRAND<"server">) => void;
        redo: (uid: string & import("zod").BRAND<"server">) => void;
        reset: () => void;
    };
};
/** Extended mutators and data for servers */
export declare function extendedServerDataFactory({ serverMutators, collections, collectionMutators, requests, requestMutators, }: StoreContext): {
    addServer: (payload: ServerPayload, parentUid: string) => {
        uid: string & import("zod").BRAND<"server">;
        url: string;
        description?: string | undefined;
        variables?: Record<string, {
            value?: string | undefined;
            description?: string | undefined;
            default?: string | undefined;
            enum?: string[] | undefined;
        }> | undefined;
    };
    deleteServer: (serverUid: Server["uid"], collectionUid: Collection["uid"]) => void;
};
//# sourceMappingURL=servers.d.ts.map