import type { ErrorResponse } from '../../../../libs/errors';
import type { Operation, RequestExample, SecurityScheme, Server } from '@scalar/oas-utils/entities/spec';
import { type ClientId, type TargetId } from '@scalar/snippetz';
import type { EnvVariables } from '../../../../libs/env-helpers';
/**
 * Returns a code example for given operation
 */
export declare const getSnippet: <T extends TargetId>(target: T | "javascript", client: ClientId<T>, { operation, example, server, securitySchemes, environment, }: {
    operation?: Operation | undefined;
    example?: RequestExample | undefined;
    server?: Server | undefined;
    securitySchemes?: SecurityScheme[];
    environment?: EnvVariables | undefined;
}) => ErrorResponse<string>;
//# sourceMappingURL=get-snippet.d.ts.map