import { defineComponent as z, createElementBlock as V, openBlock as d, Fragment as U, createBlock as k, createCommentVNode as w, createVNode as a, unref as r, withCtx as o, mergeProps as m, createTextVNode as u, createElementVNode as $ } from "vue";
import { useLoadingState as T, ScalarButton as b } from "@scalar/components";
import { pkceOptions as P } from "@scalar/oas-utils/entities/spec";
import { useToasts as A } from "@scalar/use-toasts";
import { useWorkspace as B } from "../../../../store/store.js";
import { updateScheme as L } from "../helpers/update-scheme.js";
import R from "./OAuthScopesInput.vue.js";
import p from "./RequestAuthDataTableInput.vue.js";
import f from "../../../../components/DataTable/DataTableRow.vue.js";
import { authorizeOauth2 as F } from "../../libs/oauth2.js";
const I = { class: "flex h-8 items-center justify-end gap-2 border-t" }, N = { class: "flex h-8 w-full items-center justify-end border-t" }, Y = /* @__PURE__ */ z({
  __name: "OAuth2",
  props: {
    collection: {},
    environment: {},
    envVariables: {},
    flow: {},
    persistAuth: { type: Boolean, default: !1 },
    scheme: {},
    server: {},
    workspace: {}
  },
  setup(s) {
    const y = T(), { toast: g } = A(), C = B(), n = (l, e) => L(s.scheme.uid, l, e, C, s.persistAuth), S = async () => {
      var t, v;
      if (y.isLoading || !((t = s.collection) != null && t.uid))
        return;
      if (!s.server) {
        g("No server selected", "error");
        return;
      }
      y.startLoading();
      const [l, e] = await F(
        s.flow,
        s.server,
        (v = s.workspace) == null ? void 0 : v.proxyUrl
      ).finally(() => y.stopLoading());
      e ? n(`flows.${s.flow.type}.token`, e) : (console.error(l), g((l == null ? void 0 : l.message) ?? "Failed to authorize", "error"));
    }, i = {
      environment: s.environment,
      envVariables: s.envVariables,
      workspace: s.workspace
    };
    return (l, e) => (d(), V(U, null, [
      l.flow.token ? (d(), V(U, { key: 0 }, [
        a(r(f), null, {
          default: o(() => [
            a(p, m(i, {
              class: "border-r-transparent",
              modelValue: l.flow.token,
              placeholder: "QUxMIFlPVVIgQkFTRSBBUkUgQkVMT05HIFRPIFVT",
              type: "password",
              "onUpdate:modelValue": e[0] || (e[0] = (t) => n(`flows.${l.flow.type}.token`, t))
            }), {
              default: o(() => e[10] || (e[10] = [
                u(" Access Token ")
              ])),
              _: 1
            }, 16, ["modelValue"])
          ]),
          _: 1
        }),
        a(r(f), { class: "min-w-full" }, {
          default: o(() => [
            $("div", I, [
              a(r(b), {
                class: "mr-1 p-0 px-2 py-0.5",
                loading: r(y),
                size: "sm",
                variant: "outlined",
                onClick: e[1] || (e[1] = (t) => n(`flows.${l.flow.type}.token`, ""))
              }, {
                default: o(() => e[11] || (e[11] = [
                  u(" Clear ")
                ])),
                _: 1
              }, 8, ["loading"])
            ])
          ]),
          _: 1
        })
      ], 64)) : (d(), V(U, { key: 1 }, [
        a(r(f), null, {
          default: o(() => [
            "authorizationUrl" in l.flow ? (d(), k(p, m({ key: 0 }, i, {
              containerClass: "border-r-0",
              modelValue: l.flow.authorizationUrl,
              placeholder: "https://galaxy.scalar.com/authorize",
              "onUpdate:modelValue": e[2] || (e[2] = (t) => n(`flows.${l.flow.type}.authorizationUrl`, t))
            }), {
              default: o(() => e[12] || (e[12] = [
                u(" Auth URL ")
              ])),
              _: 1
            }, 16, ["modelValue"])) : w("", !0),
            "tokenUrl" in l.flow ? (d(), k(p, m({ key: 1 }, i, {
              modelValue: l.flow.tokenUrl,
              placeholder: "https://galaxy.scalar.com/token",
              "onUpdate:modelValue": e[3] || (e[3] = (t) => n(`flows.${l.flow.type}.tokenUrl`, t))
            }), {
              default: o(() => e[13] || (e[13] = [
                u(" Token URL ")
              ])),
              _: 1
            }, 16, ["modelValue"])) : w("", !0)
          ]),
          _: 1
        }),
        "x-scalar-redirect-uri" in l.flow ? (d(), k(r(f), { key: 0 }, {
          default: o(() => [
            a(p, m(i, {
              modelValue: l.flow["x-scalar-redirect-uri"],
              placeholder: "https://galaxy.scalar.com/callback",
              "onUpdate:modelValue": e[4] || (e[4] = (t) => n(`flows.${l.flow.type}.x-scalar-redirect-uri`, t))
            }), {
              default: o(() => e[14] || (e[14] = [
                u(" Redirect URL ")
              ])),
              _: 1
            }, 16, ["modelValue"])
          ]),
          _: 1
        })) : w("", !0),
        l.flow.type === "password" ? (d(), V(U, { key: 1 }, [
          a(r(f), null, {
            default: o(() => [
              a(p, m(i, {
                class: "text-c-2",
                modelValue: l.flow.username,
                placeholder: "janedoe",
                "onUpdate:modelValue": e[5] || (e[5] = (t) => n(`flows.${l.flow.type}.username`, t))
              }), {
                default: o(() => e[15] || (e[15] = [
                  u(" Username ")
                ])),
                _: 1
              }, 16, ["modelValue"])
            ]),
            _: 1
          }),
          a(r(f), null, {
            default: o(() => [
              a(p, m(i, {
                modelValue: l.flow.password,
                placeholder: "********",
                type: "password",
                "onUpdate:modelValue": e[6] || (e[6] = (t) => n(`flows.${l.flow.type}.password`, t))
              }), {
                default: o(() => e[16] || (e[16] = [
                  u(" Password ")
                ])),
                _: 1
              }, 16, ["modelValue"])
            ]),
            _: 1
          })
        ], 64)) : w("", !0),
        a(r(f), null, {
          default: o(() => [
            a(p, m(i, {
              modelValue: l.flow["x-scalar-client-id"],
              placeholder: "12345",
              "onUpdate:modelValue": e[7] || (e[7] = (t) => n(`flows.${l.flow.type}.x-scalar-client-id`, t))
            }), {
              default: o(() => e[17] || (e[17] = [
                u(" Client ID ")
              ])),
              _: 1
            }, 16, ["modelValue"])
          ]),
          _: 1
        }),
        "clientSecret" in l.flow ? (d(), k(r(f), { key: 2 }, {
          default: o(() => [
            a(p, m(i, {
              modelValue: l.flow.clientSecret,
              placeholder: "XYZ123",
              type: "password",
              "onUpdate:modelValue": e[8] || (e[8] = (t) => n(`flows.${l.flow.type}.clientSecret`, t))
            }), {
              default: o(() => e[18] || (e[18] = [
                u(" Client Secret ")
              ])),
              _: 1
            }, 16, ["modelValue"])
          ]),
          _: 1
        })) : w("", !0),
        "x-usePkce" in l.flow ? (d(), k(r(f), { key: 3 }, {
          default: o(() => [
            a(p, m(i, {
              enum: r(P),
              modelValue: l.flow["x-usePkce"],
              readOnly: "",
              "onUpdate:modelValue": e[9] || (e[9] = (t) => n(
                `flows.${l.flow.type}.x-usePkce`,
                t
              ))
            }), {
              default: o(() => e[19] || (e[19] = [
                u(" Use PKCE ")
              ])),
              _: 1
            }, 16, ["enum", "modelValue"])
          ]),
          _: 1
        })) : w("", !0),
        Object.keys(l.flow.scopes ?? {}).length ? (d(), k(r(f), { key: 4 }, {
          default: o(() => [
            a(R, {
              flow: l.flow,
              updateScheme: n
            }, null, 8, ["flow"])
          ]),
          _: 1
        })) : w("", !0)
      ], 64)),
      l.flow.token ? w("", !0) : (d(), k(r(f), {
        key: 2,
        class: "min-w-full"
      }, {
        default: o(() => [
          $("div", N, [
            a(r(b), {
              class: "mr-0.75 p-0 px-2 py-0.5",
              loading: r(y),
              size: "sm",
              variant: "outlined",
              onClick: S
            }, {
              default: o(() => e[20] || (e[20] = [
                u(" Authorize ")
              ])),
              _: 1
            }, 8, ["loading"])
          ])
        ]),
        _: 1
      }))
    ], 64));
  }
});
export {
  Y as default
};
