import { defineComponent as L, computed as F, ref as P, onMounted as R, createElementBlock as i, openBlock as l, Fragment as s, renderList as C, createBlock as S, createCommentVNode as v, unref as d, normalizeClass as g, withCtx as n, createVNode as u, createTextVNode as m, toDisplayString as _, mergeProps as V, createElementVNode as A, capitalize as U } from "vue";
import { ScalarMarkdown as q } from "@scalar/components";
import { isDefined as I } from "@scalar/oas-utils/helpers";
import { CLIENT_LS_KEYS as N } from "../../../../libs/local-storage.js";
import { useWorkspace as z } from "../../../../store/store.js";
import { updateScheme as D } from "../helpers/update-scheme.js";
import H from "./OAuth2.vue.js";
import w from "./RequestAuthDataTableInput.vue.js";
import f from "../../../../components/DataTable/DataTableRow.vue.js";
import j from "../../../../components/DataTable/DataTableCell.vue.js";
const Q = {
  key: 0,
  class: "flex min-h-8 border-t text-sm"
}, J = { class: "flex h-8 max-w-full gap-2.5 overflow-x-auto px-3" }, Y = ["onClick"], W = { class: "relative z-10" }, ne = /* @__PURE__ */ L({
  __name: "RequestAuthTab",
  props: {
    collection: {},
    environment: {},
    envVariables: {},
    layout: {},
    persistAuth: { type: Boolean, default: !1 },
    securitySchemeUids: {},
    server: {},
    workspace: {}
  },
  setup(c) {
    const T = z(), { collectionMutators: B, securitySchemes: x, securitySchemeMutators: M } = T, $ = F(
      () => c.securitySchemeUids.map((t) => ({
        scheme: x[t]
      }))
    ), p = P(""), O = (t) => {
      const r = t.description ? `: ${t.description}` : "", e = `${U(t.nameKey)}${r || `: ${t.type}`}`;
      if (t.type === "apiKey")
        return `${U(t.nameKey)}${r || `: ${t.in}`}`;
      if (t.type === "oauth2") {
        const o = Object.values(t.flows ?? {})[0];
        return `${U(t.nameKey)}: ${p.value ? p.value : (o == null ? void 0 : o.type) ?? ""}${r}`;
      }
      return t.type === "http" ? `${U(t.nameKey)}: ${t.scheme}${r}` : `${e}${r}`;
    }, k = (t, r, e) => {
      D(t, r, e, T, c.persistAuth);
    };
    R(() => {
      if (!c.persistAuth)
        return;
      const t = JSON.parse(
        localStorage.getItem(N.AUTH) ?? "{}"
      ), r = Object.keys(x).reduce(
        (e, o) => {
          const a = x[o];
          return a && (e[a.nameKey] = a.uid), e;
        },
        {}
      );
      Object.entries(t).forEach(([e, o]) => {
        const a = r[e];
        a && Object.entries(o).forEach(([E, K]) => {
          M.edit(a, E, K);
        });
      });
      try {
        const o = JSON.parse(
          localStorage.getItem(N.SELECTED_SECURITY_SCHEMES) ?? ""
        ).map((a) => Array.isArray(a) ? a.map((y) => r[y]).filter(I) : r[a]).filter(I);
        B.edit(c.collection.uid, "selectedSecuritySchemeUids", o);
      } catch {
      }
    });
    const b = {
      environment: c.environment,
      envVariables: c.envVariables,
      workspace: c.workspace
    };
    return (t, r) => (l(!0), i(s, null, C($.value, ({ scheme: e }) => (l(), i(s, {
      key: e == null ? void 0 : e.uid
    }, [
      $.value.length > 1 ? (l(), S(d(f), {
        key: 0,
        class: g({
          "request-example-references-header": t.layout === "reference"
        })
      }, {
        default: n(() => [
          u(d(j), {
            class: g(["text-c-2 flex items-center pl-3", t.layout === "reference" && "border-b"])
          }, {
            default: n(() => [
              m(_(O(e)), 1)
            ]),
            _: 2
          }, 1032, ["class"])
        ]),
        _: 2
      }, 1032, ["class"])) : v("", !0),
      e != null && e.description && $.value.length <= 1 ? (l(), S(d(f), { key: 1 }, {
        default: n(() => [
          u(d(j), {
            "aria-label": e.description,
            class: "text-c-2 auth-description-container group/auth -mb-0.25 flex items-center whitespace-nowrap outline-none hover:whitespace-normal"
          }, {
            default: n(() => [
              u(d(q), {
                class: "auth-description bg-b-1 text-c-2 outline-b-3 top-0 z-1 line-clamp-1 h-full w-full px-3 py-1.5 group-hover/auth:line-clamp-none",
                value: e.description
              }, null, 8, ["value"])
            ]),
            _: 2
          }, 1032, ["aria-label"])
        ]),
        _: 2
      }, 1024)) : v("", !0),
      (e == null ? void 0 : e.type) === "http" ? (l(), i(s, { key: 2 }, [
        e.scheme === "bearer" ? (l(), S(d(f), { key: 0 }, {
          default: n(() => [
            u(w, V({ ref_for: !0 }, b, {
              containerClass: t.layout === "reference" && "border-t",
              modelValue: e.token,
              placeholder: "Token",
              type: "password",
              "onUpdate:modelValue": (o) => k(e.uid, "token", o)
            }), {
              default: n(() => r[0] || (r[0] = [
                m(" Bearer Token ")
              ])),
              _: 2
            }, 1040, ["containerClass", "modelValue", "onUpdate:modelValue"])
          ]),
          _: 2
        }, 1024)) : (e == null ? void 0 : e.scheme) === "basic" ? (l(), i(s, { key: 1 }, [
          u(d(f), null, {
            default: n(() => [
              u(w, V({ ref_for: !0 }, b, {
                class: "text-c-2",
                containerClass: t.layout === "reference" && "auth-blend-required border-t",
                modelValue: e.username,
                placeholder: "janedoe",
                required: "",
                "onUpdate:modelValue": (o) => k(e.uid, "username", o)
              }), {
                default: n(() => r[1] || (r[1] = [
                  m(" Username ")
                ])),
                _: 2
              }, 1040, ["containerClass", "modelValue", "onUpdate:modelValue"])
            ]),
            _: 2
          }, 1024),
          u(d(f), null, {
            default: n(() => [
              u(w, V({ ref_for: !0 }, b, {
                modelValue: e.password,
                placeholder: "********",
                type: "password",
                "onUpdate:modelValue": (o) => k(e.uid, "password", o)
              }), {
                default: n(() => r[2] || (r[2] = [
                  m(" Password ")
                ])),
                _: 2
              }, 1040, ["modelValue", "onUpdate:modelValue"])
            ]),
            _: 2
          }, 1024)
        ], 64)) : v("", !0)
      ], 64)) : (e == null ? void 0 : e.type) === "apiKey" ? (l(), i(s, { key: 3 }, [
        u(d(f), null, {
          default: n(() => [
            u(w, V({ ref_for: !0 }, b, {
              containerClass: t.layout === "reference" && "border-t",
              modelValue: e.name,
              placeholder: "api-key",
              "onUpdate:modelValue": (o) => k(e.uid, "name", o)
            }), {
              default: n(() => r[3] || (r[3] = [
                m(" Name ")
              ])),
              _: 2
            }, 1040, ["containerClass", "modelValue", "onUpdate:modelValue"])
          ]),
          _: 2
        }, 1024),
        u(d(f), null, {
          default: n(() => [
            u(w, V({ ref_for: !0 }, b, {
              modelValue: e.value,
              placeholder: "QUxMIFlPVVIgQkFTRSBBUkUgQkVMT05HIFRPIFVT",
              type: "password",
              "onUpdate:modelValue": (o) => k(e.uid, "value", o)
            }), {
              default: n(() => r[4] || (r[4] = [
                m(" Value ")
              ])),
              _: 2
            }, 1040, ["modelValue", "onUpdate:modelValue"])
          ]),
          _: 2
        }, 1024)
      ], 64)) : (e == null ? void 0 : e.type) === "oauth2" ? (l(), i(s, { key: 4 }, [
        u(d(f), null, {
          default: n(() => [
            Object.keys(e.flows).length > 1 ? (l(), i("div", Q, [
              A("div", J, [
                (l(!0), i(s, null, C(e == null ? void 0 : e.flows, (o, a, y) => (l(), i("button", {
                  key: a,
                  class: g(["floating-bg text-c-3 relative cursor-pointer border-b-[1px] border-transparent py-1 text-sm font-medium", {
                    "!text-c-1 !rounded-none border-b-[1px] !border-current": t.layout !== "reference" && (p.value === a || y === 0 && !p.value),
                    "!text-c-1 !rounded-none border-b-[1px] !border-current opacity-100": t.layout === "reference" && (p.value === a || y === 0 && !p.value)
                  }]),
                  type: "button",
                  onClick: (E) => p.value = a
                }, [
                  A("span", W, _(a), 1)
                ], 10, Y))), 128))
              ])
            ])) : v("", !0)
          ]),
          _: 2
        }, 1024),
        (l(!0), i(s, null, C(e == null ? void 0 : e.flows, (o, a, y) => (l(), i(s, { key: a }, [
          p.value === a || y === 0 && !p.value ? (l(), S(H, V({
            key: 0,
            ref_for: !0
          }, b, {
            collection: t.collection,
            flow: o,
            persistAuth: t.persistAuth,
            scheme: e,
            server: t.server,
            workspace: t.workspace
          }), null, 16, ["collection", "flow", "persistAuth", "scheme", "server", "workspace"])) : v("", !0)
        ], 64))), 128))
      ], 64)) : (e == null ? void 0 : e.type) === "openIdConnect" ? (l(), i("div", {
        key: 5,
        class: g(["text-c-3 bg-b-1 flex min-h-[calc(4rem+1px)] items-center justify-center border-t border-b-0 px-4 text-sm", { "rounded-b-lg": t.layout === "reference" }])
      }, " Coming soon ", 2)) : v("", !0)
    ], 64))), 128));
  }
});
export {
  ne as default
};
