import type { SecurityScheme } from '@scalar/oas-utils/entities/spec';
import type { Path, PathValue } from '@scalar/object-utils/nested';
import type { WorkspaceStore } from '../../../../store/store';
/** Shape of the local storage auth object */
export type Auth<P extends Path<SecurityScheme>> = Record<string, Record<P, NonNullable<PathValue<SecurityScheme, P>>>>;
/** Update the security scheme with side effects */
export declare const updateScheme: <U extends SecurityScheme["uid"], P extends Path<SecurityScheme>>(uid: U, path: P, value: NonNullable<PathValue<SecurityScheme, P>>, { securitySchemeMutators, securitySchemes }: WorkspaceStore, persistAuth?: boolean) => void;
//# sourceMappingURL=update-scheme.d.ts.map