import { defineComponent as G, ref as O, computed as I, watch as V, createBlock as P, openBlock as i, unref as s, withCtx as v, createElementBlock as f, Fragment as g, createElementVNode as S, createCommentVNode as H, createVNode as C, createTextVNode as p, toDisplayString as T } from "vue";
import { useLoadingState as K, ScalarButton as _, ScalarCodeBlock as Q, ScalarIcon as X, ScalarTooltip as Z } from "@scalar/components";
import { useToasts as ee } from "@scalar/use-toasts";
import { useRouter as te } from "vue-router";
import { importCurlCommand as oe } from "../../libs/importers/curl.js";
import { useActiveEntities as ae } from "../../store/active-entities.js";
import le from "./CommandActionForm.vue.js";
import ne from "./CommandActionInput.vue.js";
import re from "./WatchModeToggle.vue.js";
import { isPostmanCollection as L, getPostmanDocumentDetails as ie, convertPostmanToOpenApi as F } from "../../libs/postman.js";
import { getOpenApiDocumentDetails as se } from "../../libs/getOpenApiDocumentDetails.js";
import { isUrl as U } from "../../libs/isUrl.js";
import { useFileDialog as ue } from "../../hooks/useFileDialog.js";
import { PathId as W } from "../../routes.js";
import { useWorkspace as ce } from "../../store/store.js";
const me = { class: "flex justify-between" }, de = { class: "flex w-full flex-row items-center justify-between gap-3" }, Ae = /* @__PURE__ */ G({
  __name: "CommandPaletteImport",
  emits: ["close", "back"],
  setup(pe, { emit: N }) {
    const k = N, $ = te(), { activeWorkspace: c, activeCollection: B } = ae(), { importSpecFile: w, importSpecFromUrl: M, events: j } = ce(), { toast: m } = ee(), d = K(), a = O(""), y = O(!0), r = I(() => L(a.value) ? ie(a.value) : se(a.value)), A = I(
      () => r.value ? r.value.type : "json"
    );
    function x(t) {
      var e;
      t && $.push({
        name: "collection",
        params: {
          [W.Workspace]: (e = c.value) == null ? void 0 : e.uid,
          [W.Collection]: t.uid
        }
      });
    }
    const h = I(() => U(a.value)), E = I(() => !!r.value), { open: z } = ue({
      onChange: async (t) => {
        const e = t == null ? void 0 : t[0];
        if (e) {
          const n = new FileReader();
          n.onload = async (b) => {
            var u, R, D;
            const o = (u = b.target) == null ? void 0 : u.result;
            try {
              if (L(o)) {
                const l = await w(
                  await F(o),
                  ((R = c.value) == null ? void 0 : R.uid) ?? ""
                );
                x(l == null ? void 0 : l.collection);
              } else {
                const l = await w(
                  o,
                  ((D = c.value) == null ? void 0 : D.uid) ?? ""
                );
                x(l == null ? void 0 : l.collection);
              }
              m("Import successful", "info"), k("close");
            } catch (l) {
              console.error(l);
              const q = (l == null ? void 0 : l.message) || "Unknown error";
              m(`Import failed: ${q}`, "error");
            }
          }, n.readAsText(e);
        }
      },
      multiple: !1,
      accept: ".json,.yaml,.yml"
    });
    V(h, (t) => {
      t || (y.value = !1);
    }), V(a, (t) => {
      U(t) || (y.value = !1);
    });
    async function J() {
      var t, e, n, b;
      if (!(!a.value || d.isLoading)) {
        d.startLoading();
        try {
          if (h.value) {
            const [o, u] = await M(
              a.value,
              ((t = c.value) == null ? void 0 : t.uid) ?? "",
              {
                proxyUrl: (e = c.value) == null ? void 0 : e.proxyUrl,
                watchMode: y.value
              }
            );
            if (x(u == null ? void 0 : u.collection), o) {
              m(
                "There was a possible CORS error while importing your spec, please make sure this server is allowed in the CORS policy of your OpenAPI document.",
                "error",
                { timeout: 5e3 }
              ), d.invalidate(2e3, !0);
              return;
            }
          } else if (E.value)
            if (L(a.value)) {
              const o = await w(
                await F(a.value),
                ((n = c.value) == null ? void 0 : n.uid) ?? ""
              );
              x(o == null ? void 0 : o.collection), m("Successfully converted Postman collection", "info");
            } else {
              const o = await w(
                a.value,
                ((b = c.value) == null ? void 0 : b.uid) ?? ""
              );
              x(o == null ? void 0 : o.collection);
            }
          else {
            m("Import failed: Invalid URL or OpenAPI document", "error"), d.invalidate(2e3, !0);
            return;
          }
          d.clear(), k("close"), m("Import successful", "info");
        } catch (o) {
          console.error("[importCollection]", o);
          const u = (o == null ? void 0 : o.message) || "Unknown error";
          d.invalidate(2e3, !0), m(`Import failed: ${u}`, "error");
        }
      }
    }
    const Y = (t) => {
      var e;
      if (t.trim().toLowerCase().startsWith("curl")) {
        j.commandPalette.emit({
          commandName: "Import from cURL",
          metaData: {
            parsedCurl: oe(t),
            collectionUid: (e = B.value) == null ? void 0 : e.uid
          }
        });
        return;
      }
      a.value = t;
    };
    return (t, e) => (i(), P(le, {
      disabled: !a.value.trim(),
      loading: s(d),
      onSubmit: J
    }, {
      options: v(() => [
        S("div", de, [
          C(s(_), {
            class: "hover:bg-b-2 relative max-h-8 gap-1.5 p-2 text-xs",
            variant: "outlined",
            onClick: s(z)
          }, {
            default: v(() => [
              e[5] || (e[5] = p(" JSON, or YAML File ")),
              C(s(X), {
                class: "text-c-3",
                icon: "Upload",
                size: "md"
              })
            ]),
            _: 1
          }, 8, ["onClick"]),
          C(s(Z), {
            content: h.value ? "Watch mode automatically updates the API client when the OpenAPI URL content changes, ensuring your client remains up-to-date." : "Watch mode is only available for URL imports. When enabled it automatically updates the API client when the OpenAPI URL content changes.",
            placement: "bottom"
          }, {
            default: v(() => [
              C(re, {
                modelValue: y.value,
                "onUpdate:modelValue": e[2] || (e[2] = (n) => y.value = n),
                disabled: !h.value
              }, null, 8, ["modelValue", "disabled"])
            ]),
            _: 1
          }, 8, ["content"])
        ])
      ]),
      submit: v(() => [
        e[6] || (e[6] = p(" Import ")),
        h.value ? (i(), f(g, { key: 0 }, [
          p(" from URL ")
        ], 64)) : r.value && A.value ? (i(), f(g, { key: 1 }, [
          r.value.title ? (i(), f(g, { key: 0 }, [
            p(' "' + T(r.value.title) + '" ', 1)
          ], 64)) : (i(), f(g, { key: 1 }, [
            p(T(r.value.version), 1)
          ], 64))
        ], 64)) : (i(), f(g, { key: 2 }, [
          p(" Collection ")
        ], 64))
      ]),
      default: v(() => [
        !r.value || s(U)(a.value) ? (i(), P(ne, {
          key: 0,
          modelValue: a.value,
          placeholder: "OpenAPI/Swagger/Postman URL or cURL",
          onOnDelete: e[0] || (e[0] = (n) => k("back", n)),
          "onUpdate:modelValue": Y
        }, null, 8, ["modelValue"])) : (i(), f(g, { key: 1 }, [
          S("div", me, [
            e[4] || (e[4] = S("div", { class: "text-c-2 min-h-8 w-full py-2 pl-12 text-center text-xs" }, " Preview ", -1)),
            C(s(_), {
              class: "hover:bg-b-2 relative ml-auto max-h-8 gap-1.5 p-2 text-xs",
              variant: "ghost",
              onClick: e[1] || (e[1] = (n) => a.value = "")
            }, {
              default: v(() => e[3] || (e[3] = [
                p(" Clear ")
              ])),
              _: 1
            })
          ]),
          r.value && !s(U)(a.value) ? (i(), P(s(Q), {
            key: 0,
            class: "bg-b-2 mt-1 max-h-[40dvh] rounded border px-2 py-1 text-sm",
            content: a.value,
            copy: !1,
            lang: A.value
          }, null, 8, ["content", "lang"])) : H("", !0)
        ], 64))
      ]),
      _: 1
    }, 8, ["disabled", "loading"]));
  }
});
export {
  Ae as default
};
