/**
 * The Command Palette
 *
 * This component is a singleton so should only exist in our app once we will use the event bus to trigger it
 */
declare const _default: import("vue").DefineComponent<{}, {}, {}, {}, {}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, {}, string, import("vue").PublicProps, Readonly<{}> & Readonly<{}>, {}, {}, {}, {}, string, import("vue").ComponentProvideOptions, true, {}, any>;
export default _default;
export declare const PaletteComponents: {
    readonly 'Import from OpenAPI/Swagger/Postman/cURL': import("vue").DefineComponent<{}, {}, {}, {}, {}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, {} & {
        close: () => any;
        back: (e: KeyboardEvent) => any;
    }, string, import("vue").PublicProps, Readonly<{}> & Readonly<{
        onClose?: () => any;
        onBack?: (e: KeyboardEvent) => any;
    }>, {}, {}, {}, {}, string, import("vue").ComponentProvideOptions, true, {}, HTMLFormElement>;
    readonly 'Create Request': "";
    readonly 'Create Workspace': import("vue").DefineComponent<{}, {}, {}, {}, {}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, {} & {
        close: () => any;
        back: (e: KeyboardEvent) => any;
    }, string, import("vue").PublicProps, Readonly<{}> & Readonly<{
        onClose?: () => any;
        onBack?: (e: KeyboardEvent) => any;
    }>, {}, {}, {}, {}, string, import("vue").ComponentProvideOptions, true, {}, HTMLFormElement>;
    readonly 'Add Tag': import("vue").DefineComponent<{}, {}, {}, {}, {}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, {} & {
        close: () => any;
        back: (e: KeyboardEvent) => any;
    }, string, import("vue").PublicProps, Readonly<{}> & Readonly<{
        onClose?: () => any;
        onBack?: (e: KeyboardEvent) => any;
    }>, {}, {}, {}, {}, string, import("vue").ComponentProvideOptions, true, {}, HTMLFormElement>;
    readonly 'Add Server': import("vue").DefineComponent<{
        metaData?: {
            itemUid?: string;
            parentUid?: string;
        };
    }, {}, {}, {}, {}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, {} & {
        close: () => any;
        back: (e: KeyboardEvent) => any;
    }, string, import("vue").PublicProps, Readonly<{
        metaData?: {
            itemUid?: string;
            parentUid?: string;
        };
    }> & Readonly<{
        onClose?: () => any;
        onBack?: (e: KeyboardEvent) => any;
    }>, {}, {}, {}, {}, string, import("vue").ComponentProvideOptions, false, {}, HTMLFormElement>;
    readonly 'Create Collection': import("vue").DefineComponent<{}, {}, {}, {}, {}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, {} & {
        close: () => any;
        back: (e: KeyboardEvent) => any;
    }, string, import("vue").PublicProps, Readonly<{}> & Readonly<{
        onClose?: () => any;
        onBack?: (e: KeyboardEvent) => any;
    }>, {}, {}, {}, {}, string, import("vue").ComponentProvideOptions, true, {}, HTMLFormElement>;
    readonly 'Add Example': import("vue").DefineComponent<{
        metaData?: {
            itemUid: string;
        };
    }, {}, {}, {}, {}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, {} & {
        close: () => any;
        back: (e: KeyboardEvent) => any;
    }, string, import("vue").PublicProps, Readonly<{
        metaData?: {
            itemUid: string;
        };
    }> & Readonly<{
        onClose?: () => any;
        onBack?: (e: KeyboardEvent) => any;
    }>, {}, {}, {}, {}, string, import("vue").ComponentProvideOptions, false, {}, any>;
    readonly 'Import from cURL': import("vue").DefineComponent<{
        metaData: {
            parsedCurl: {
                uid?: string | undefined;
                path?: string | undefined;
                type?: "request" | undefined;
                description?: string | undefined;
                summary?: string | undefined;
                externalDocs?: {
                    url: string;
                    description?: unknown;
                } | undefined;
                'x-internal'?: boolean | undefined;
                'x-scalar-ignore'?: boolean | undefined;
                security?: Record<string, string[] | undefined>[] | undefined;
                selectedSecuritySchemeUids?: (string | string[])[] | undefined;
                selectedServerUid?: string | null | undefined;
                servers?: string[] | undefined;
                tags?: string[] | undefined;
                deprecated?: boolean | undefined;
                examples?: string[] | undefined;
                operationId?: string | undefined;
                parameters?: {
                    name: string;
                    in: "cookie" | "path" | "query" | "header";
                    description?: string | undefined;
                    required?: boolean | undefined;
                    example?: unknown;
                    deprecated?: boolean | undefined;
                    examples?: unknown[] | Record<string, {
                        value?: unknown;
                        summary?: string | undefined;
                        externalValue?: string | undefined;
                    }> | undefined;
                    schema?: unknown;
                    content?: unknown;
                    style?: "matrix" | "simple" | "form" | "label" | "spaceDelimited" | "pipeDelimited" | "deepObject" | undefined;
                    explode?: boolean | undefined;
                }[] | undefined;
                requestBody?: any;
                responses?: Record<string, any> | undefined;
                callbacks?: Record<string, Record<string, Record<string, any>>> | undefined;
                'x-scalar-stability'?: unknown;
                method?: "options" | "connect" | "delete" | "get" | "head" | "patch" | "post" | "put" | "trace" | undefined;
                'x-post-response'?: string | undefined;
                'x-codeSamples'?: unknown;
                'x-code-samples'?: unknown;
                'x-custom-examples'?: unknown;
            } & {
                url?: string;
            };
            collectionUid: string;
        };
    }, {}, {}, {}, {}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, {} & {
        close: () => any;
        back: (e: KeyboardEvent) => any;
    }, string, import("vue").PublicProps, Readonly<{
        metaData: {
            parsedCurl: {
                uid?: string | undefined;
                path?: string | undefined;
                type?: "request" | undefined;
                description?: string | undefined;
                summary?: string | undefined;
                externalDocs?: {
                    url: string;
                    description?: unknown;
                } | undefined;
                'x-internal'?: boolean | undefined;
                'x-scalar-ignore'?: boolean | undefined;
                security?: Record<string, string[] | undefined>[] | undefined;
                selectedSecuritySchemeUids?: (string | string[])[] | undefined;
                selectedServerUid?: string | null | undefined;
                servers?: string[] | undefined;
                tags?: string[] | undefined;
                deprecated?: boolean | undefined;
                examples?: string[] | undefined;
                operationId?: string | undefined;
                parameters?: {
                    name: string;
                    in: "cookie" | "path" | "query" | "header";
                    description?: string | undefined;
                    required?: boolean | undefined;
                    example?: unknown;
                    deprecated?: boolean | undefined;
                    examples?: unknown[] | Record<string, {
                        value?: unknown;
                        summary?: string | undefined;
                        externalValue?: string | undefined;
                    }> | undefined;
                    schema?: unknown;
                    content?: unknown;
                    style?: "matrix" | "simple" | "form" | "label" | "spaceDelimited" | "pipeDelimited" | "deepObject" | undefined;
                    explode?: boolean | undefined;
                }[] | undefined;
                requestBody?: any;
                responses?: Record<string, any> | undefined;
                callbacks?: Record<string, Record<string, Record<string, any>>> | undefined;
                'x-scalar-stability'?: unknown;
                method?: "options" | "connect" | "delete" | "get" | "head" | "patch" | "post" | "put" | "trace" | undefined;
                'x-post-response'?: string | undefined;
                'x-codeSamples'?: unknown;
                'x-code-samples'?: unknown;
                'x-custom-examples'?: unknown;
            } & {
                url?: string;
            };
            collectionUid: string;
        };
    }> & Readonly<{
        onClose?: () => any;
        onBack?: (e: KeyboardEvent) => any;
    }>, {}, {}, {}, {}, string, import("vue").ComponentProvideOptions, false, {}, any>;
};
/** Infer the types from the commands  */
export type CommandNames = keyof typeof PaletteComponents;
export type CommandPaletteEvent = {
    /** The command name which matches with the command palette */
    commandName?: CommandNames;
    /** Any extra metadata we want to pass to the command palettes */
    metaData?: Record<string, any>;
};
//# sourceMappingURL=TheCommandPalette.vue.d.ts.map