import { defineComponent as oe, ref as f, computed as U, watch as te, onMounted as ne, onBeforeUnmount as ae, createBlock as W, openBlock as l, unref as c, withCtx as A, createElementVNode as v, createVNode as k, createElementBlock as u, createTextVNode as V, createCommentVNode as le, withKeys as S, withModifiers as T, Fragment as D, renderList as O, withDirectives as se, toDisplayString as F, vShow as re, normalizeClass as me, resolveDynamicComponent as ie, mergeProps as ce, nextTick as b } from "vue";
import { Dialog as ue, DialogPanel as de, DialogTitle as pe } from "@headlessui/vue";
import { useModal as fe, ScalarIcon as L } from "@scalar/components";
import { useRouter as ve } from "vue-router";
import { ROUTES as Ce } from "../../constants.js";
import { importCurlCommand as he } from "../../libs/importers/curl.js";
import { PathId as xe } from "../../routes.js";
import { useActiveEntities as ke } from "../../store/active-entities.js";
import ye from "./CommandPaletteCollection.vue.js";
import ge from "./CommandPaletteExample.vue.js";
import _e from "./CommandPaletteImport.vue.js";
import be from "./CommandPaletteImportCurl.vue.js";
import we from "./CommandPaletteServer.vue.js";
import Pe from "./CommandPaletteTag.vue.js";
import Ie from "./CommandPaletteWorkspace.vue.js";
import { useWorkspace as Re } from "../../store/store.js";
const Ae = {
  key: 0,
  class: "custom-scroll max-h-[50dvh] min-h-0 flex-1 rounded-lg p-1.5"
}, Se = { class: "bg-b-2 focus-within:bg-b-1 sticky top-0 flex items-center rounded-md border border-transparent pl-2 shadow-[0_-8px_0_8px_var(--scalar-background-1),0_0_8px_8px_var(--scalar-background-1)] focus-within:border-(--scalar-background-3)" }, Te = { for: "commandmenu" }, De = ["value", "onKeydown"], Le = ["onClick"], Ee = {
  key: 0,
  class: "text-c-3 p-2 pt-3 text-center text-sm"
}, Be = {
  key: 1,
  class: "flex-1 p-1.5"
}, He = {
  name: "TheCommandPalette"
}, Ke = {
  "Import from OpenAPI/Swagger/Postman/cURL": _e,
  "Create Request": "",
  "Create Workspace": Ie,
  "Add Tag": Pe,
  "Add Server": we,
  "Create Collection": ye,
  "Add Example": ge,
  "Import from cURL": be
}, eo = /* @__PURE__ */ oe({
  ...He,
  setup($e) {
    const C = fe(), w = ve(), { activeWorkspace: y, activeWorkspaceCollections: G, activeCollection: Q } = ke(), { events: d, requestMutators: j } = Re(), E = [
      {
        label: "",
        commands: [
          {
            name: "Import from OpenAPI/Swagger/Postman/cURL",
            icon: "Import"
          },
          {
            name: "Create Request",
            icon: "ExternalLink"
          },
          {
            name: "Create Collection",
            icon: "Collection"
          },
          {
            name: "Add Tag",
            icon: "Folder"
          },
          {
            name: "Add Example",
            icon: "Example"
          },
          {
            name: "Add Server",
            icon: "Server"
          }
        ]
      },
      {
        label: "More Actions",
        commands: [
          {
            name: "Create Workspace",
            icon: "Workspace"
          },
          {
            name: "Add Environment",
            icon: "Brackets",
            path: "environment.default"
          },
          {
            name: "Add Cookie",
            icon: "Cookie",
            path: "cookies.default"
          }
        ]
      },
      {
        label: "Pages",
        commands: Ce.map((o) => {
          var e;
          return {
            name: o.displayName,
            icon: o.icon,
            path: w.resolve({
              ...o.to,
              params: {
                [xe.Workspace]: ((e = y == null ? void 0 : y.value) == null ? void 0 : e.uid) ?? "default"
              }
            }).href
          };
        })
      }
    ], P = f(), s = f(""), r = f(null), m = f(-1), B = f([]), h = U(
      () => E.reduce((o, e) => {
        const t = e.commands.filter(
          (n) => n.name.toLowerCase().includes(s.value.toLowerCase())
        );
        return [...o, ...t];
      }, [])
    ), p = () => {
      C.hide(), s.value = "", r.value = null, m.value = -1;
    }, J = (o) => {
      s.value !== "" && (o == null || o.preventDefault()), r.value = null, b(() => {
        var e;
        return (e = g.value) == null ? void 0 : e.focus();
      });
    }, H = (o) => {
      var e;
      if ("path" in o)
        w.push(o.path), p();
      else if (o.name === "Create Request") {
        const t = G.value.find(
          (n) => {
            var a;
            return ((a = n.info) == null ? void 0 : a.title) === "Drafts";
          }
        );
        if (t) {
          const n = j.add({}, t.uid);
          n && (w.push({
            name: "request",
            params: {
              workspace: (e = y.value) == null ? void 0 : e.uid,
              request: n.uid
            }
          }), p(), b(() => {
            d.hotKeys.emit({
              focusAddressBar: new KeyboardEvent("keydown", { key: "l" })
            });
          }));
        } else
          p();
      } else
        r.value = o.name;
    }, g = f(), K = ({
      commandName: o,
      metaData: e
    } = {}) => {
      r.value = o ?? null, P.value = e, C.show(), b(() => {
        var t;
        return (t = g.value) == null ? void 0 : t.focus();
      });
    };
    te(s, (o) => {
      o && h.value.length > 0 && (m.value = 0);
    });
    const $ = (o, e) => {
      if (!C.open) return;
      e.preventDefault();
      const t = o === "up" ? -1 : 1, n = h.value.length;
      m.value = (m.value + t + n) % n, b(() => {
        var z, N;
        const a = (z = g.value) == null ? void 0 : z.closest(".custom-scroll");
        if (!a) return;
        if (m.value === 0) {
          a.scrollTop = 0;
          return;
        }
        const i = B.value[m.value];
        if (!i) return;
        const x = (((N = a.querySelector(".sticky")) == null ? void 0 : N.clientHeight) || 0) + 16, _ = 6, R = i.offsetTop, M = R + i.clientHeight, Z = a.scrollTop + x, ee = a.scrollTop + a.clientHeight - _;
        R < Z ? a.scrollTop = R - x : M > ee && (a.scrollTop = M - a.clientHeight + _);
      });
    }, I = U(
      () => h.value[m.value]
    ), X = (o) => {
      !I.value || r.value || (o.preventDefault(), o.stopPropagation(), H(I.value));
    }, q = (o) => {
      C.open && o != null && o.closeModal && p();
    }, Y = (o) => {
      var e;
      if (o.trim().toLowerCase().startsWith("curl")) {
        d.commandPalette.emit({
          commandName: "Import from cURL",
          metaData: {
            parsedCurl: he(o),
            collectionUid: (e = Q.value) == null ? void 0 : e.uid
          }
        });
        return;
      }
      s.value = o;
    };
    return ne(() => {
      d.commandPalette.on(K), d.hotKeys.on(q);
    }), ae(() => {
      d.commandPalette.off(K), d.hotKeys.off(q);
    }), (o, e) => (l(), W(c(ue), {
      open: c(C).open,
      onClose: e[5] || (e[5] = (t) => p())
    }, {
      default: A(() => [
        e[7] || (e[7] = v("div", { class: "commandmenu-overlay z-overlay" }, null, -1)),
        k(c(de), { class: "commandmenu z-overlay flex flex-col" }, {
          default: A(() => [
            k(c(pe), { class: "sr-only" }, {
              default: A(() => e[6] || (e[6] = [
                V("API Client Command Menu")
              ])),
              _: 1
            }),
            r.value ? (l(), u("div", Be, [
              v("button", {
                class: "hover:bg-b-3 text-c-3 active:text-c-1 absolute z-1 my-1.25 mr-1.5 rounded p-0.75",
                type: "button",
                onClick: e[3] || (e[3] = (t) => r.value = null)
              }, [
                k(c(L), {
                  icon: "ChevronLeft",
                  size: "md",
                  thickness: "1.5"
                })
              ]),
              (l(), W(ie(Ke[r.value]), ce(P.value ? { metaData: P.value } : {}, {
                onBack: e[4] || (e[4] = (t) => J(t)),
                onClose: p
              }), null, 16))
            ])) : (l(), u("div", Ae, [
              v("div", Se, [
                v("label", Te, [
                  k(c(L), {
                    class: "text-c-2 mr-2.5",
                    icon: "Search",
                    size: "md",
                    thickness: "1.5"
                  })
                ]),
                v("input", {
                  id: "commandmenu",
                  ref_key: "commandInputRef",
                  ref: g,
                  autocomplete: "off",
                  autofocus: "",
                  class: "w-full rounded border-none bg-none py-1.5 text-sm focus:outline-none",
                  placeholder: "Search commands...",
                  type: "text",
                  value: s.value,
                  onInput: e[0] || (e[0] = (t) => Y(t.target.value)),
                  onKeydown: [
                    e[1] || (e[1] = S(T((t) => $("down", t), ["stop"]), ["down"])),
                    S(T(X, ["stop"]), ["enter"]),
                    e[2] || (e[2] = S(T((t) => $("up", t), ["stop"]), ["up"]))
                  ]
                }, null, 40, De)
              ]),
              (l(), u(D, null, O(E, (t) => (l(), u(D, {
                key: t.label
              }, [
                se(v("div", { class: "text-c-3 mt-2 mb-1 px-2 text-xs font-medium" }, F(t.label), 513), [
                  [
                    re,
                    t.commands.filter(
                      (n) => n.name.toLowerCase().includes(s.value.toLowerCase())
                    ).length > 0
                  ]
                ]),
                (l(!0), u(D, null, O(t.commands.filter(
                  (n) => n.name.toLowerCase().includes(s.value.toLowerCase())
                ), (n) => {
                  var a;
                  return l(), u("div", {
                    key: n.name,
                    ref_for: !0,
                    ref: (i) => {
                      if (i) {
                        const x = h.value.findIndex(
                          (_) => _.name === n.name
                        );
                        x !== -1 && (B.value[x] = i);
                      }
                    },
                    class: me(["commandmenu-item hover:bg-b-2 flex cursor-pointer items-center rounded px-2 py-1.5 text-sm", {
                      "bg-b-2": n.name === ((a = I.value) == null ? void 0 : a.name)
                    }]),
                    onClick: (i) => H(n)
                  }, [
                    k(c(L), {
                      class: "text-c-2 mr-2.5",
                      icon: n.icon,
                      size: "md",
                      thickness: "1.5"
                    }, null, 8, ["icon"]),
                    V(" " + F(n.name), 1)
                  ], 10, Le);
                }), 128))
              ], 64))), 64)),
              h.value.length ? le("", !0) : (l(), u("div", Ee, " No commands found "))
            ]))
          ]),
          _: 1
        })
      ]),
      _: 1
    }, 8, ["open"]));
  }
});
export {
  Ke as PaletteComponents,
  eo as default
};
