import { type ApiClientConfiguration } from '@scalar/types/api-reference';
import { type InjectionKey, type Ref } from 'vue';
export declare const CLIENT_CONFIGURATION_SYMBOL: InjectionKey<Ref<ApiClientConfiguration>>;
/** Hook for easy access to the reference configuration */
export declare const useClientConfig: () => Ref<{
    hideClientButton: boolean;
    showSidebar: boolean;
    theme: "alternate" | "default" | "moon" | "purple" | "solarized" | "bluePlanet" | "deepSpace" | "saturn" | "kepler" | "elysiajs" | "fastify" | "mars" | "laserwave" | "none";
    persistAuth: boolean;
    title?: string | undefined;
    url?: string | undefined;
    content?: string | Record<string, any> | ((...args: unknown[]) => Record<string, any>) | null | undefined;
    slug?: string | undefined;
    spec?: {
        title?: string | undefined;
        url?: string | undefined;
        content?: string | Record<string, any> | ((...args: unknown[]) => Record<string, any>) | null | undefined;
        slug?: string | undefined;
    } | undefined;
    authentication?: any;
    baseServerURL?: string | undefined;
    proxyUrl?: string | undefined;
    searchHotKey?: "c" | "r" | "a" | "b" | "d" | "e" | "f" | "g" | "h" | "i" | "j" | "k" | "l" | "m" | "n" | "o" | "p" | "q" | "s" | "t" | "u" | "v" | "w" | "x" | "y" | "z" | undefined;
    servers?: any[] | undefined;
    _integration?: "go" | "elysiajs" | "fastify" | "adonisjs" | "docusaurus" | "dotnet" | "express" | "fastapi" | "hono" | "html" | "laravel" | "litestar" | "nestjs" | "nextjs" | "nitro" | "nuxt" | "platformatic" | "react" | "rust" | "svelte" | "vue" | null | undefined;
    onRequestSent?: ((args_0: string, ...args: unknown[]) => void) | undefined;
    plugins?: ((...args: unknown[]) => {
        name: string;
        views: {
            "request.section": {
                title?: string | undefined;
                component?: unknown;
                props?: Record<string, any> | undefined;
            }[];
            "response.section": {
                title?: string | undefined;
                component?: unknown;
                props?: Record<string, any> | undefined;
            }[];
        };
        hooks: {
            onBeforeRequest: (...args: unknown[]) => void | Promise<void>;
            onResponseReceived: (args_0: {
                response: Response;
                operation: Record<string, any>;
            }, ...args: unknown[]) => void | Promise<void>;
        };
    })[] | undefined;
}, {
    hideClientButton: boolean;
    showSidebar: boolean;
    theme: "alternate" | "default" | "moon" | "purple" | "solarized" | "bluePlanet" | "deepSpace" | "saturn" | "kepler" | "elysiajs" | "fastify" | "mars" | "laserwave" | "none";
    persistAuth: boolean;
    title?: string | undefined;
    url?: string | undefined;
    content?: string | Record<string, any> | ((...args: unknown[]) => Record<string, any>) | null | undefined;
    slug?: string | undefined;
    spec?: {
        title?: string | undefined;
        url?: string | undefined;
        content?: string | Record<string, any> | ((...args: unknown[]) => Record<string, any>) | null | undefined;
        slug?: string | undefined;
    } | undefined;
    authentication?: any;
    baseServerURL?: string | undefined;
    proxyUrl?: string | undefined;
    searchHotKey?: "c" | "r" | "a" | "b" | "d" | "e" | "f" | "g" | "h" | "i" | "j" | "k" | "l" | "m" | "n" | "o" | "p" | "q" | "s" | "t" | "u" | "v" | "w" | "x" | "y" | "z" | undefined;
    servers?: any[] | undefined;
    _integration?: "go" | "elysiajs" | "fastify" | "adonisjs" | "docusaurus" | "dotnet" | "express" | "fastapi" | "hono" | "html" | "laravel" | "litestar" | "nestjs" | "nextjs" | "nitro" | "nuxt" | "platformatic" | "react" | "rust" | "svelte" | "vue" | null | undefined;
    onRequestSent?: ((args_0: string, ...args: unknown[]) => void) | undefined;
    plugins?: ((...args: unknown[]) => {
        name: string;
        views: {
            "request.section": {
                title?: string | undefined;
                component?: unknown;
                props?: Record<string, any> | undefined;
            }[];
            "response.section": {
                title?: string | undefined;
                component?: unknown;
                props?: Record<string, any> | undefined;
            }[];
        };
        hooks: {
            onBeforeRequest: (...args: unknown[]) => void | Promise<void>;
            onResponseReceived: (args_0: {
                response: Response;
                operation: Record<string, any>;
            }, ...args: unknown[]) => void | Promise<void>;
        };
    })[] | undefined;
} | {
    hideClientButton: boolean;
    showSidebar: boolean;
    theme: "alternate" | "default" | "moon" | "purple" | "solarized" | "bluePlanet" | "deepSpace" | "saturn" | "kepler" | "elysiajs" | "fastify" | "mars" | "laserwave" | "none";
    persistAuth: boolean;
    title?: string | undefined;
    url?: string | undefined;
    content?: string | Record<string, any> | ((...args: unknown[]) => Record<string, any>) | null | undefined;
    slug?: string | undefined;
    spec?: {
        title?: string | undefined;
        url?: string | undefined;
        content?: string | Record<string, any> | ((...args: unknown[]) => Record<string, any>) | null | undefined;
        slug?: string | undefined;
    } | undefined;
    authentication?: any;
    baseServerURL?: string | undefined;
    proxyUrl?: string | undefined;
    searchHotKey?: "c" | "r" | "a" | "b" | "d" | "e" | "f" | "g" | "h" | "i" | "j" | "k" | "l" | "m" | "n" | "o" | "p" | "q" | "s" | "t" | "u" | "v" | "w" | "x" | "y" | "z" | undefined;
    servers?: any[] | undefined;
    _integration?: "go" | "elysiajs" | "fastify" | "adonisjs" | "docusaurus" | "dotnet" | "express" | "fastapi" | "hono" | "html" | "laravel" | "litestar" | "nestjs" | "nextjs" | "nitro" | "nuxt" | "platformatic" | "react" | "rust" | "svelte" | "vue" | null | undefined;
    onRequestSent?: ((args_0: string, ...args: unknown[]) => void) | undefined;
    plugins?: ((...args: unknown[]) => {
        name: string;
        views: {
            "request.section": {
                title?: string | undefined;
                component?: unknown;
                props?: Record<string, any> | undefined;
            }[];
            "response.section": {
                title?: string | undefined;
                component?: unknown;
                props?: Record<string, any> | undefined;
            }[];
        };
        hooks: {
            onBeforeRequest: (...args: unknown[]) => void | Promise<void>;
            onResponseReceived: (args_0: {
                response: Response;
                operation: Record<string, any>;
            }, ...args: unknown[]) => void | Promise<void>;
        };
    })[] | undefined;
}>;
//# sourceMappingURL=useClientConfig.d.ts.map