import MimeType from 'whatwg-mimetype';
import type { Ref } from 'vue';
/**
 * Processes the response body of an HTTP request.
 * Extracts MIME type, attachment filename, and generates a data URL.
 */
export declare function useResponseBody(props: {
    data: Ref<unknown>;
    headers: Ref<{
        name: string;
        value: string;
        required: boolean;
    }[]>;
}): {
    mimeType: import("vue").ComputedRef<MimeType>;
    attachmentFilename: import("vue").ComputedRef<string>;
    dataUrl: import("vue").ComputedRef<string>;
};
//# sourceMappingURL=useResponseBody.d.ts.map