import { ERRORS as P, normalizeError as U } from "../errors.js";
import { normalizeHeaders as J } from "../normalize-headers.js";
import { createFetchBody as N } from "./create-fetch-body.js";
import { createFetchHeaders as Z } from "./create-fetch-headers.js";
import { createFetchQueryParams as $ } from "./create-fetch-query-params.js";
import { decodeBuffer as M } from "./decode-buffer.js";
import { setRequestCookies as ee, getCookieHeader as oe } from "./set-request-cookies.js";
import { replaceTemplateVariables as m } from "../string-template.js";
import { isElectron as q } from "../electron.js";
import { isDefined as te, mergeUrls as re, shouldUseProxy as D, redirectToProxy as se, httpStatusCodes as ne } from "@scalar/oas-utils/helpers";
import { buildRequestSecurity as ae } from "./build-request-security.js";
const Re = ({
  environment: E,
  example: a,
  globalCookies: L,
  proxyUrl: u,
  request: i,
  securitySchemes: z,
  selectedSecuritySchemeUids: B = [],
  server: d,
  status: o,
  pluginManager: f
}) => {
  try {
    const t = E ?? {}, k = new AbortController(), w = a.parameters.path.reduce((e, s) => (s.enabled && (e[s.key] = m(s.value, t)), e), {}), F = m((d == null ? void 0 : d.url) ?? "", t), p = m(m(i.path, t), w);
    let n = F || p;
    if (!n)
      throw P.URL_EMPTY;
    Object.entries((d == null ? void 0 : d.variables) ?? {}).forEach(([e, s]) => {
      n = m(n, {
        [e]: w[e] || s.default
      });
    });
    const _ = $(a, t, i), O = Z(a, t), { body: W } = N(i.method, a, t), { cookieParams: x } = ee({
      example: a,
      env: t,
      globalCookies: L,
      serverUrl: n,
      proxyUrl: u
    }), A = B.flat().map((e) => z[e]).filter(te), S = ae(A, t), c = { ...Object.entries(S.headers).reduce(
      (e, [s, y]) => (e[s.toLowerCase()] = y, e),
      {}
    ), ...O }, X = [...x, ...S.cookies], j = new URLSearchParams([..._, ...S.urlParams]);
    q() && c["user-agent"] && (c["X-Scalar-User-Agent"] = c["user-agent"]), n = re(n, p, j);
    const b = m(oe(X, c.Cookie), t);
    b && (q() || D(u, n) ? (console.warn(
      "We’re using a `X-Scalar-Cookie` custom header to the request. The proxy will forward this as a `Cookie` header. We do this to avoid the browser omitting the `Cookie` header for cross-origin requests for security reasons."
    ), c["X-Scalar-Cookie"] = b) : (console.warn(
      `We’re trying to add a Cookie header, but browsers often omit them for cross-origin requests for various security reasons. If it’s not working, that’s probably why. Here are the requirements for it to work:

          - The browser URL must be on the same domain as the server URL.
          - The connection must be made over HTTPS.
          `
    ), c.Cookie = b));
    const I = se(u, n), R = new Request(I, {
      method: i.method.toUpperCase(),
      body: W ?? null,
      headers: c
    });
    return [
      null,
      {
        request: R,
        sendRequest: async () => {
          var s, y, C;
          o == null || o.emit("start"), f && f.executeHook("onBeforeRequest");
          const e = Date.now();
          try {
            const r = await fetch(R, {
              signal: k.signal
            }), Q = (s = r.headers.get("content-type")) == null ? void 0 : s.startsWith("text/event-stream");
            o == null || o.emit("stop");
            const V = Date.now() - e, v = r.clone(), g = J(r.headers, D(u, n)), K = r.headers.get("content-type") ?? "text/plain;charset=UTF-8", T = await v.arrayBuffer(), Y = M(T, K), h = r.clone(), G = h.statusText || ((y = ne[h.status]) == null ? void 0 : y.name) || "", l = new Response(h.body, {
              status: h.status,
              statusText: G,
              headers: h.headers
            });
            f && f.executeHook("onResponseReceived", { response: l, operation: i });
            const H = "getSetCookie" in l.headers && typeof l.headers.getSetCookie == "function" ? l.headers.getSetCookie() : [];
            return Q && r.body ? [
              null,
              {
                timestamp: Date.now(),
                request: a,
                response: {
                  ...l,
                  headers: g,
                  cookieHeaderKeys: H,
                  reader: (C = r.body) == null ? void 0 : C.getReader(),
                  duration: V,
                  method: i.method,
                  path: p
                }
              }
            ] : [
              null,
              {
                timestamp: Date.now(),
                request: a,
                response: {
                  ...r,
                  headers: g,
                  cookieHeaderKeys: H,
                  data: Y,
                  size: T.byteLength,
                  duration: Date.now() - e,
                  method: i.method,
                  status: r.status,
                  path: p
                }
              }
            ];
          } catch (r) {
            return o == null || o.emit("abort"), [U(r, P.REQUEST_FAILED), null];
          }
        },
        controller: k
      }
    ];
  } catch (t) {
    return console.error(t), o == null || o.emit("abort"), [U(t), null];
  }
};
export {
  Re as createRequestOperation
};
