import { type RequestPayload, type ServerPayload, requestExampleSchema } from '@scalar/oas-utils/entities/spec';
import type { z } from 'zod';
export declare const VOID_URL = "http://127.0.0.1:5052";
type RequestExamplePayload = z.input<typeof requestExampleSchema>;
type MetaRequestPayload = {
    serverPayload?: ServerPayload;
    requestPayload?: RequestPayload;
    requestExamplePayload?: RequestExamplePayload;
    proxyUrl?: string;
};
/** Creates the payload for createRequestOperation */
export declare const createRequestPayload: (metaRequestPayload?: MetaRequestPayload) => {
    auth: {};
    request: {
        uid: string & z.BRAND<"operation">;
        path: string;
        type: "request";
        selectedSecuritySchemeUids: ((string & z.BRAND<"securityScheme">) | (string & z.BRAND<"securityScheme">)[])[];
        selectedServerUid: (string & z.BRAND<"server">) | null;
        servers: (string & z.BRAND<"server">)[];
        examples: (string & z.BRAND<"example">)[];
        method: "options" | "connect" | "delete" | "get" | "head" | "patch" | "post" | "put" | "trace";
        description?: string | undefined;
        summary?: string | undefined;
        externalDocs?: {
            url: string;
            description?: string | undefined;
        } | undefined;
        'x-internal'?: boolean | undefined;
        'x-scalar-ignore'?: boolean | undefined;
        security?: Record<string, string[]>[] | undefined;
        tags?: string[] | undefined;
        deprecated?: boolean | undefined;
        operationId?: string | undefined;
        parameters?: {
            name: string;
            required: boolean;
            deprecated: boolean;
            in: "cookie" | "path" | "query" | "header";
            description?: string | undefined;
            example?: unknown;
            examples?: unknown[] | Record<string, {
                value?: unknown;
                summary?: string | undefined;
                externalValue?: string | undefined;
            }> | undefined;
            schema?: unknown;
            content?: unknown;
            style?: "matrix" | "simple" | "form" | "label" | "spaceDelimited" | "pipeDelimited" | "deepObject" | undefined;
            explode?: boolean | undefined;
        }[] | undefined;
        requestBody?: any;
        responses?: Record<string, any> | undefined;
        callbacks?: Record<string, Record<string, Record<string, any>>> | undefined;
        'x-scalar-stability'?: import("@scalar/types").XScalarStability | undefined;
        'x-post-response'?: string | undefined;
        'x-codeSamples'?: {
            source: string;
            label?: string | undefined;
            lang?: string | undefined;
        }[] | undefined;
        'x-code-samples'?: {
            source: string;
            label?: string | undefined;
            lang?: string | undefined;
        }[] | undefined;
        'x-custom-examples'?: {
            source: string;
            label?: string | undefined;
            lang?: string | undefined;
        }[] | undefined;
    };
    environment: {};
    globalCookies: never[];
    example: {
        uid: string & z.BRAND<"example">;
        name: string;
        type: "requestExample";
        body: {
            activeBody: "binary" | "formData" | "raw";
            binary?: Blob | undefined;
            formData?: {
                value: {
                    value: string;
                    key: string;
                    enabled: boolean;
                    minimum?: number | undefined;
                    type?: string | string[] | undefined;
                    maximum?: number | undefined;
                    description?: string | undefined;
                    default?: any;
                    required?: boolean | undefined;
                    enum?: string[] | undefined;
                    format?: string | undefined;
                    examples?: any[] | undefined;
                    file?: any;
                    nullable?: boolean | undefined;
                }[];
                encoding: "form-data" | "urlencoded";
            } | undefined;
            raw?: {
                value: string;
                encoding: "xml" | "json" | "text" | "html" | "javascript" | "yaml" | "edn";
                mimeType?: string | undefined;
            } | undefined;
        };
        parameters: {
            path: {
                value: string;
                key: string;
                enabled: boolean;
                minimum?: number | undefined;
                type?: string | string[] | undefined;
                maximum?: number | undefined;
                description?: string | undefined;
                default?: any;
                required?: boolean | undefined;
                enum?: string[] | undefined;
                format?: string | undefined;
                examples?: any[] | undefined;
                file?: any;
                nullable?: boolean | undefined;
            }[];
            query: {
                value: string;
                key: string;
                enabled: boolean;
                minimum?: number | undefined;
                type?: string | string[] | undefined;
                maximum?: number | undefined;
                description?: string | undefined;
                default?: any;
                required?: boolean | undefined;
                enum?: string[] | undefined;
                format?: string | undefined;
                examples?: any[] | undefined;
                file?: any;
                nullable?: boolean | undefined;
            }[];
            headers: {
                value: string;
                key: string;
                enabled: boolean;
                minimum?: number | undefined;
                type?: string | string[] | undefined;
                maximum?: number | undefined;
                description?: string | undefined;
                default?: any;
                required?: boolean | undefined;
                enum?: string[] | undefined;
                format?: string | undefined;
                examples?: any[] | undefined;
                file?: any;
                nullable?: boolean | undefined;
            }[];
            cookies: {
                value: string;
                key: string;
                enabled: boolean;
                minimum?: number | undefined;
                type?: string | string[] | undefined;
                maximum?: number | undefined;
                description?: string | undefined;
                default?: any;
                required?: boolean | undefined;
                enum?: string[] | undefined;
                format?: string | undefined;
                examples?: any[] | undefined;
                file?: any;
                nullable?: boolean | undefined;
            }[];
        };
        requestUid?: (string & z.BRAND<"operation">) | undefined;
        serverVariables?: Record<string, string[]> | undefined;
    };
    server: {
        uid: string & z.BRAND<"server">;
        url: string;
        description?: string | undefined;
        variables?: Record<string, {
            value?: string | undefined;
            description?: string | undefined;
            default?: string | undefined;
            enum?: string[] | undefined;
        }> | undefined;
    } | undefined;
    proxyUrl: string | undefined;
    securitySchemes: {};
};
export {};
//# sourceMappingURL=create-request-operation.test.d.ts.map