import type { StoreContext } from '../store/store-context';
import { type Environment } from '@scalar/oas-utils/entities/environment';
/** Generate reactive environments for the workspace */
export declare function createStoreEnvironments(useLocalStorage: boolean): {
    environments: Record<string, {
        uid: string & import("zod").BRAND<"environment">;
        name: string;
        value: string;
        color: string;
        isDefault?: boolean | undefined;
    }>;
    environmentMutators: {
        add: (item: {
            uid: string & import("zod").BRAND<"environment">;
            name: string;
            value: string;
            color: string;
            isDefault?: boolean | undefined;
        }) => void;
        delete: (uid: (string & import("zod").BRAND<"environment">) | null | undefined) => void;
        set: (item: {
            uid: string & import("zod").BRAND<"environment">;
            name: string;
            value: string;
            color: string;
            isDefault?: boolean | undefined;
        }) => void;
        edit: <P extends "value" | "uid" | "name" | "color" | "isDefault">(uid: (string & import("zod").BRAND<"environment">) | null | undefined, path: P, value: P extends "value" | "uid" | "name" | "color" | "isDefault" ? {
            uid: string & import("zod").BRAND<"environment">;
            name: string;
            value: string;
            color: string;
            isDefault?: boolean | undefined;
        }[P] : P extends `${infer K}.${infer R}` ? K extends "value" | "uid" | "name" | "color" | "isDefault" ? R extends import("@scalar/object-utils/nested").Path<{
            uid: string & import("zod").BRAND<"environment">;
            name: string;
            value: string;
            color: string;
            isDefault?: boolean | undefined;
        }[K]> ? import("@scalar/object-utils/nested").PathValue<{
            uid: string & import("zod").BRAND<"environment">;
            name: string;
            value: string;
            color: string;
            isDefault?: boolean | undefined;
        }[K], R> : never : K extends `${number}` ? never : never : P extends `${number}` ? never : never) => void;
        untrackedEdit: <P extends "value" | "uid" | "name" | "color" | "isDefault">(uid: string & import("zod").BRAND<"environment">, path: P, value: P extends "value" | "uid" | "name" | "color" | "isDefault" ? {
            uid: string & import("zod").BRAND<"environment">;
            name: string;
            value: string;
            color: string;
            isDefault?: boolean | undefined;
        }[P] : P extends `${infer K}.${infer R}` ? K extends "value" | "uid" | "name" | "color" | "isDefault" ? R extends import("@scalar/object-utils/nested").Path<{
            uid: string & import("zod").BRAND<"environment">;
            name: string;
            value: string;
            color: string;
            isDefault?: boolean | undefined;
        }[K]> ? import("@scalar/object-utils/nested").PathValue<{
            uid: string & import("zod").BRAND<"environment">;
            name: string;
            value: string;
            color: string;
            isDefault?: boolean | undefined;
        }[K], R> : never : K extends `${number}` ? never : never : P extends `${number}` ? never : never) => void;
        undo: (uid: string & import("zod").BRAND<"environment">) => void;
        redo: (uid: string & import("zod").BRAND<"environment">) => void;
        reset: () => void;
    };
};
/** Extended environment data factory where workspace access is needed */
export declare function extendedEnvironmentDataFactory({ environmentMutators }: StoreContext): {
    deleteEnvironment: (uid: Environment["uid"]) => void;
};
//# sourceMappingURL=environment.d.ts.map