import type { CommandPaletteEvent } from '../components/CommandPalette/TheCommandPalette.vue';
import type { RequestStatus } from '../libs/send-request';
/** Create the store for the api client events */
export declare function createStoreEvents(): {
    /**
     * Event bus to execute requests, usually triggered by the send button in the address bar
     * OR the keyboard shortcut
     */
    executeRequest: import("../libs/event-bus").EventBus<{
        requestUid?: string;
    }>;
    /**
     * Event bus to focus the address bar or send button
     */
    focusAddressBar: import("../libs/event-bus").EventBus<any>;
    /**
     * Event bus to cancel requests, usually triggered by response loading overlay
     */
    cancelRequest: import("../libs/event-bus").EventBus<any>;
    /**
     * Event bus to keep track of when a request is started, stopped, or aborted
     */
    requestStatus: import("../libs/event-bus").EventBus<RequestStatus>;
    /**
     * Event bus for controlling the Command Palette
     *
     * @param commandName - the command name you wish to execute, leave empty for the full palette
     */
    commandPalette: import("../libs/event-bus").EventBus<CommandPaletteEvent>;
    /**
     * Event bus for handling hot keys
     */
    hotKeys: import("../libs/event-bus").EventBus<Partial<Record<"addTopNav" | "closeModal" | "closeTopNav" | "createNew" | "executeRequest" | "focusAddressBar" | "focusRequestSearch" | "jumpToLastTab" | "jumpToTab" | "navigateSearchResultsDown" | "navigateSearchResultsUp" | "navigateTopNavLeft" | "navigateTopNavRight" | "openCommandPalette" | "selectSearchResult" | "toggleSidebar", KeyboardEvent>>>;
};
//# sourceMappingURL=events.d.ts.map