import type { ActiveEntitiesStore } from '../../store/active-entities';
import type { DraggingItem, HoveredItem } from '@scalar/draggable';
import type { Collection } from '@scalar/oas-utils/entities/spec';
type CollectionMutator = {
    edit: (uid: Collection['uid'], path: 'x-scalar-environments', value: Collection['x-scalar-environments']) => void;
};
/** Create environment DnD handlers */
export declare function environmentDragHandlerFactory(activeWorkspaceCollections: ActiveEntitiesStore['activeWorkspaceCollections'], collectionMutator: CollectionMutator): {
    handleDragEnd: (draggingItem: DraggingItem, hoveredItem: HoveredItem) => void;
    isDroppable: (draggingItem: DraggingItem, hoveredItem: HoveredItem) => boolean;
};
export {};
//# sourceMappingURL=handle-drag.d.ts.map