import type { CodeMirrorLanguage } from '@scalar/use-codemirror';
export type MediaPreview = 'object' | 'image' | 'video' | 'audio';
export type MediaConfig = {
    preview?: MediaPreview;
    alpha?: boolean;
    raw?: boolean;
    language?: CodeMirrorLanguage;
    extension: string;
};
/** Media Type (MIME Type) Definitions */
export declare const mediaTypes: {
    [type: string]: MediaConfig | undefined;
};
/** Media Types (MIME Types) that can be displayed as raw text */
export declare const textMediaTypes: string[];
/** Get the config for a media type */
export declare function getMediaTypeConfig(type: string): MediaConfig | undefined;
/** Check if a media type that can be displayed as raw text */
export declare function isTextMediaType(type: string): boolean;
//# sourceMappingURL=mediaTypes.d.ts.map