# @scalar/api-reference

## 1.28.23

### Patch Changes

- 363276e: feat(icons): add Phosphor icons to @scalar/icons
- 28f9909: fix: overflow scrolling on any of discriminator
- abad2e9: feat: use `"string"` as the fallback for string examples (not `"…"`)
- Updated dependencies [363276e]
- Updated dependencies [85163e7]
- Updated dependencies [301cf13]
- Updated dependencies [85163e7]
- Updated dependencies [a9f232a]
  - @scalar/icons@0.2.0
  - @scalar/api-client@2.3.23
  - @scalar/components@0.13.50
  - @scalar/use-hooks@0.1.42

## 1.28.22

### Patch Changes

- 42ca70e: fix: some jumpiness when switching specs or any config changing
- Updated dependencies [e489824]
- Updated dependencies [cdaafe4]
  - @scalar/api-client@2.3.22
  - @scalar/oas-utils@0.2.133
  - @scalar/components@0.13.49

## 1.28.21

### Patch Changes

- c5047ee: fix: hotfix to revert the external reference commit
- Updated dependencies [c5047ee]
  - @scalar/openapi-parser@0.10.16
  - @scalar/api-client@2.3.21
  - @scalar/oas-utils@0.2.132

## 1.28.20

### Patch Changes

- 03198df: fix: updates example handling in example request for any content type
- d678f21: fix(api-reference): align document selector chevron
- a5e286a: fix(api-reference): collapse response if it has headers
- 0cb87a7: fix(api-reference): show sidebar if not set
- d246d70: chore: delete unsed spinner component
- 4abe4f8: feat: external $ref’s (absolute and relative URLs)
- Updated dependencies [4abe4f8]
- Updated dependencies [e3ed7a2]
- Updated dependencies [71d06d8]
- Updated dependencies [e30339c]
- Updated dependencies [feaa314]
- Updated dependencies [feaa314]
- Updated dependencies [03198df]
- Updated dependencies [ba8e37e]
- Updated dependencies [f4e1402]
- Updated dependencies [e30339c]
- Updated dependencies [4abe4f8]
  - @scalar/openapi-parser@0.10.15
  - @scalar/api-client@2.3.20
  - @scalar/themes@0.10.0
  - @scalar/types@0.1.8
  - @scalar/oas-utils@0.2.131
  - @scalar/code-highlight@0.0.27
  - @scalar/components@0.13.48
  - @scalar/use-hooks@0.1.41
  - @scalar/snippetz@0.2.19

## 1.28.19

### Patch Changes

- Updated dependencies [44413b1]
  - @scalar/api-client@2.3.19

## 1.28.18

### Patch Changes

- 3745d77: feat: custom specification extensions
- 3745d77: feat: new plugin system
- Updated dependencies [5b19c90]
- Updated dependencies [9def02e]
- Updated dependencies [f705230]
- Updated dependencies [3745d77]
  - @scalar/api-client@2.3.18
  - @scalar/components@0.13.47
  - @scalar/types@0.1.7
  - @scalar/oas-utils@0.2.130
  - @scalar/openapi-parser@0.10.14
  - @scalar/snippetz@0.2.19
  - @scalar/themes@0.9.86
  - @scalar/code-highlight@0.0.27
  - @scalar/use-hooks@0.1.40

## 1.28.17

### Patch Changes

- Updated dependencies [8720ae7]
  - @scalar/themes@0.9.85
  - @scalar/api-client@2.3.17
  - @scalar/code-highlight@0.0.27
  - @scalar/components@0.13.46
  - @scalar/oas-utils@0.2.129
  - @scalar/use-hooks@0.1.39

## 1.28.16

### Patch Changes

- 2707c69: feat: show schema title in heading when available
- Updated dependencies [27f1c16]
- Updated dependencies [27f1c16]
- Updated dependencies [d970ff5]
  - @scalar/api-client@2.3.16

## 1.28.15

### Patch Changes

- 07a5d79: feat: directly show responses in the list
- de78601: feat: add Introduction heading to the sidebar
- 91cc99c: fix: schema doesn’t show deeply nested allOf schemas
- Updated dependencies [ce91adc]
- Updated dependencies [61e094b]
- Updated dependencies [e7fb3eb]
  - @scalar/api-client@2.3.15

## 1.28.14

### Patch Changes

- 799845f: feat(components): allow ScalarCodeblock to support different font sizes
- 66a5ad5: fix: only lazyload once
- 73f5553: fix(api-reference): references search a11y improvements
- Updated dependencies [18b1be9]
- Updated dependencies [abff210]
- Updated dependencies [799845f]
- Updated dependencies [73f5553]
  - @scalar/oas-utils@0.2.128
  - @scalar/api-client@2.3.14
  - @scalar/code-highlight@0.0.27
  - @scalar/components@0.13.45

## 1.28.13

### Patch Changes

- bf961b1: feat: show custom code examples in the API client
- c8169e9: fix: disable intersection observer on config update
- af650e3: fix(api-reference): style anyof + padding fix
- a176b7e: fix: returns operation server at the operation level
- Updated dependencies [bf961b1]
- Updated dependencies [0e888bc]
- Updated dependencies [a176b7e]
- Updated dependencies [a176b7e]
  - @scalar/api-client@2.3.13
  - @scalar/oas-utils@0.2.127
  - @scalar/code-highlight@0.0.26
  - @scalar/components@0.13.44

## 1.28.12

### Patch Changes

- 8c1d3fa: fix: jumpin on initial load
- a571d36: fix: can’t fetch OpenAPI documents from local URLs with a port
- a571d36: refactor: use central helper fetchDocument to fetch OpenAPI documents
- a571d36: feat: use proxy when it’s relative (even for local domains)
- 97c1293: fix: enable sidebar scroll listener
- 97c1293: fix: references client selector not working with custom client selected
- 5844bd0: fix(api-reference): spacing and typography issues in schema property
- Updated dependencies [73be3c0]
- Updated dependencies [75667fe]
- Updated dependencies [a571d36]
- Updated dependencies [a097ea1]
- Updated dependencies [cf5bf65]
- Updated dependencies [3783345]
  - @scalar/api-client@2.3.12
  - @scalar/oas-utils@0.2.126
  - @scalar/openapi-parser@0.10.14
  - @scalar/types@0.1.6
  - @scalar/snippetz@0.2.19
  - @scalar/themes@0.9.84
  - @scalar/code-highlight@0.0.25
  - @scalar/components@0.13.43
  - @scalar/use-hooks@0.1.38

## 1.28.11

### Patch Changes

- b812e9f: fix: open in api client button
- 6bb9f38: fix: empty search on references
- d581ac0: fix: ensure pathRouting works on first load
- e09dab3: feat: multiple configurations with multiple sources
- Updated dependencies [183cbba]
- Updated dependencies [e62e677]
- Updated dependencies [d5a687f]
- Updated dependencies [adc6ee4]
- Updated dependencies [e09dab3]
- Updated dependencies [b0a5481]
- Updated dependencies [e62e677]
- Updated dependencies [82f16a5]
- Updated dependencies [04e27a1]
- Updated dependencies [4df5387]
- Updated dependencies [846d015]
  - @scalar/snippetz@0.2.19
  - @scalar/openapi-types@0.2.0
  - @scalar/openapi-parser@0.10.13
  - @scalar/api-client@2.3.11
  - @scalar/types@0.1.5
  - @scalar/oas-utils@0.2.125
  - @scalar/themes@0.9.83
  - @scalar/code-highlight@0.0.25
  - @scalar/components@0.13.42
  - @scalar/use-hooks@0.1.37

## 1.28.10

### Patch Changes

- e0517be: fix: missing body in references responses
- 560be28: feat(api-reference): add copy button to examples and redesign them
- Updated dependencies [0de80ae]
  - @scalar/api-client@2.3.10
  - @scalar/oas-utils@0.2.124

## 1.28.9

### Patch Changes

- 8efedf3: fix: reduce section opening jank and ensure spec is changed correctly
- 8efedf3: fix: allow async functions in onDocumentSelect
- 7e5d385: fix: integration links on getting started component
- 57feba6: feat: added new auth config (v2)
- Updated dependencies [8efedf3]
- Updated dependencies [ab6b166]
- Updated dependencies [82a4ba8]
- Updated dependencies [52f6f4c]
- Updated dependencies [57feba6]
  - @scalar/types@0.1.4
  - @scalar/api-client@2.3.9
  - @scalar/oas-utils@0.2.123
  - @scalar/openapi-parser@0.10.12
  - @scalar/snippetz@0.2.18
  - @scalar/themes@0.9.82
  - @scalar/code-highlight@0.0.25
  - @scalar/components@0.13.41
  - @scalar/use-hooks@0.1.36

## 1.28.8

### Patch Changes

- f57e9c9: feat: freeze element in window when switching clients
- 543a16c: feat: allow to explicitly set the default source
- 57e96a0: feat: add onDocumentSelect callback when switching multi configs
- c0f6384: fix: remove bad timeout code and replace with mutation observer
- Updated dependencies [543a16c]
- Updated dependencies [002a50e]
- Updated dependencies [6095530]
- Updated dependencies [57e96a0]
  - @scalar/types@0.1.3
  - @scalar/api-client@2.3.8
  - @scalar/snippetz@0.2.18
  - @scalar/oas-utils@0.2.122
  - @scalar/openapi-parser@0.10.12
  - @scalar/themes@0.9.81
  - @scalar/code-highlight@0.0.25
  - @scalar/components@0.13.40
  - @scalar/use-hooks@0.1.35

## 1.28.7

### Patch Changes

- d9ab0f0: fix: move useNavState state to ApiReference and provide/inject
- Updated dependencies [427c325]
- Updated dependencies [9a2d008]
- Updated dependencies [46b40ca]
- Updated dependencies [4a42197]
- Updated dependencies [cbc1d08]
  - @scalar/components@0.13.39
  - @scalar/api-client@2.3.7
  - @scalar/snippetz@0.2.17
  - @scalar/openapi-parser@0.10.12
  - @scalar/oas-utils@0.2.121

## 1.28.6

### Patch Changes

- 7a8965c: chore: remove spec prefix
- 0f13162: chore: enable more Biome flags, apply linter fixes
- 8ca4584: feat: updates schema discriminator display
- 49dffff: feat: expose the isLoading prop to control loading of references
- Updated dependencies [7a8965c]
- Updated dependencies [0f13162]
- Updated dependencies [cc1ec74]
- Updated dependencies [49dffff]
- Updated dependencies [2716898]
- Updated dependencies [49dffff]
- Updated dependencies [0212daa]
  - @scalar/types@0.1.2
  - @scalar/openapi-parser@0.10.11
  - @scalar/api-client@2.3.6
  - @scalar/components@0.13.38
  - @scalar/oas-utils@0.2.121
  - @scalar/snippetz@0.2.16
  - @scalar/themes@0.9.80
  - @scalar/code-highlight@0.0.25
  - @scalar/use-hooks@0.1.34

## 1.28.5

### Patch Changes

- Updated dependencies [0fb83f2]
  - @scalar/api-client@2.3.5

## 1.28.4

### Patch Changes

- ebc29d5: fix: missing requestBody description
- 3af0c08: fix(api-references): change search button outline from shadow to border
- Updated dependencies [ed2b1fb]
- Updated dependencies [ebc29d5]
- Updated dependencies [58acdc6]
  - @scalar/api-client@2.3.4

## 1.28.3

### Patch Changes

- cd75eeb: fix: update collection in multi doc
- 39c0f47: chore: export multi doc types
- b4a8f65: feat: adds badges + show more button fixtures
- Updated dependencies [cd75eeb]
- Updated dependencies [39c0f47]
- Updated dependencies [4093692]
  - @scalar/api-client@2.3.3
  - @scalar/oas-utils@0.2.120
  - @scalar/types@0.1.1
  - @scalar/openapi-parser@0.10.10
  - @scalar/snippetz@0.2.16
  - @scalar/themes@0.9.79
  - @scalar/code-highlight@0.0.25
  - @scalar/components@0.13.37
  - @scalar/use-hooks@0.1.33

## 1.28.2

### Patch Changes

- 22c7445: fix: updates collapsible section trigger style
- 3a956c0: fix: hides sidebar arrow on default open all tags configuration
- cf58fba: fix(api-reference): focus and screenreader improvements for client libraries, endpoints list and API client
- da6bbc5: feat: show if a parameter is deprecated
- Updated dependencies [e0ee082]
- Updated dependencies [1437882]
- Updated dependencies [060ada9]
- Updated dependencies [cf58fba]
- Updated dependencies [e00fa7e]
- Updated dependencies [632978d]
  - @scalar/components@0.13.36
  - @scalar/api-client@2.3.2
  - @scalar/themes@0.9.78
  - @scalar/code-highlight@0.0.25
  - @scalar/oas-utils@0.2.119
  - @scalar/use-hooks@0.1.32

## 1.28.1

### Patch Changes

- Updated dependencies [7bc87ef]
  - @scalar/api-client@2.3.1

## 1.28.0

### Minor Changes

- 5f9a8a2: feat!: remove the spec prefix, make content and url top-level attributes

### Patch Changes

- Updated dependencies [5be9418]
- Updated dependencies [5f9a8a2]
  - @scalar/api-client@2.3.0
  - @scalar/types@0.1.0
  - @scalar/oas-utils@0.2.118
  - @scalar/openapi-parser@0.10.10
  - @scalar/snippetz@0.2.16
  - @scalar/themes@0.9.77
  - @scalar/code-highlight@0.0.24
  - @scalar/components@0.13.35
  - @scalar/use-hooks@0.1.31

## 1.27.0

### Minor Changes

- e373a21: feat: new JS-based API window.Scalar.createApiReference

### Patch Changes

- eb70f8b: fix: one more attempt at fixing ci
- 8b343f6: feat: favors scalar dropdown as content type selector
- Updated dependencies [00a429f]
- Updated dependencies [fc6a45e]
- Updated dependencies [a0da28e]
  - @scalar/api-client@2.2.63
  - @scalar/types@0.0.41
  - @scalar/oas-utils@0.2.117
  - @scalar/openapi-parser@0.10.10
  - @scalar/snippetz@0.2.16
  - @scalar/themes@0.9.76
  - @scalar/code-highlight@0.0.24
  - @scalar/components@0.13.34
  - @scalar/use-hooks@0.1.30

## 1.26.2

### Patch Changes

- Updated dependencies [ab98841]
- Updated dependencies [db9ebbc]
  - @scalar/oas-utils@0.2.116
  - @scalar/api-client@2.2.62

## 1.26.1

### Patch Changes

- 4d03e0f: feat: multiple documents
- Updated dependencies [0d8a24f]
- Updated dependencies [4d03e0f]
- Updated dependencies [2bbbf01]
  - @scalar/openapi-parser@0.10.10
  - @scalar/api-client@2.2.61
  - @scalar/components@0.13.33
  - @scalar/types@0.0.40
  - @scalar/oas-utils@0.2.115
  - @scalar/snippetz@0.2.16
  - @scalar/themes@0.9.75
  - @scalar/code-highlight@0.0.24
  - @scalar/use-hooks@0.1.29

## 1.26.0

### Patch Changes

- 0601989: fix: make useConfig reactive
- Updated dependencies [df4dee8]
- Updated dependencies [8c5b0c6]
- Updated dependencies [9319c0c]
- Updated dependencies [9319c0c]
- Updated dependencies [23bac9d]
- Updated dependencies [fb22645]
  - @scalar/api-client@2.2.60
  - @scalar/components@0.13.32
  - @scalar/code-highlight@0.0.24
  - @scalar/oas-utils@0.2.114

## 1.25.130

### Patch Changes

- 2c621d4: refactor: move snippetz types to @scalar/types
- 46ea036: chore: added standalone reference version log to the console
- a31973c: refactor: use store for operation title and stability level
- bab7990: feat: use new @scalar/core to keep the dependency list short
- Updated dependencies [3f99afc]
- Updated dependencies [bab7990]
- Updated dependencies [2c621d4]
- Updated dependencies [168e609]
- Updated dependencies [a31973c]
  - @scalar/components@0.13.31
  - @scalar/types@0.0.39
  - @scalar/snippetz@0.2.16
  - @scalar/api-client@2.2.59
  - @scalar/oas-utils@0.2.113
  - @scalar/openapi-parser@0.10.9
  - @scalar/themes@0.9.74
  - @scalar/code-highlight@0.0.23
  - @scalar/use-hooks@0.1.28

## 1.25.129

### Patch Changes

- Updated dependencies [4682a6f]
- Updated dependencies [7f1a40e]
  - @scalar/api-client@2.2.58
  - @scalar/types@0.0.38
  - @scalar/oas-utils@0.2.112
  - @scalar/openapi-parser@0.10.9
  - @scalar/themes@0.9.73
  - @scalar/code-highlight@0.0.23
  - @scalar/components@0.13.30
  - @scalar/use-hooks@0.1.27

## 1.25.128

### Patch Changes

- 89d8b75: feat: new ApiReferenceConfiguration type
- 479a2ef: fix(api-reference): improve references focus management
- b93b22f: fix(api-client): improve api client sidebar and address bar a11y
- 89d8b75: feat: configuration passes Zod
- Updated dependencies [89d8b75]
- Updated dependencies [8c0e147]
- Updated dependencies [8a04b8d]
- Updated dependencies [1459ce7]
- Updated dependencies [479a2ef]
- Updated dependencies [b93b22f]
- Updated dependencies [73513d3]
- Updated dependencies [51b7c5c]
- Updated dependencies [8a04b8d]
  - @scalar/api-client@2.2.57
  - @scalar/oas-utils@0.2.111
  - @scalar/themes@0.9.72
  - @scalar/types@0.0.37
  - @scalar/components@0.13.29
  - @scalar/code-highlight@0.0.23
  - @scalar/use-hooks@0.1.26
  - @scalar/openapi-parser@0.10.9
  - @scalar/openapi-types@0.1.9
  - @scalar/snippetz@0.2.15
  - @scalar/use-toasts@0.7.9

## 1.25.127

### Patch Changes

- Updated dependencies [a5dc41f]
  - @scalar/api-client@2.2.56

## 1.25.126

### Patch Changes

- Updated dependencies [d078633]
- Updated dependencies [0d4520f]
- Updated dependencies [98323b8]
- Updated dependencies [eb3bb7f]
- Updated dependencies [ea19156]
  - @scalar/api-client@2.2.55
  - @scalar/components@0.13.28
  - @scalar/use-hooks@0.1.25
  - @scalar/themes@0.9.71
  - @scalar/code-highlight@0.0.23
  - @scalar/oas-utils@0.2.110

## 1.25.125

### Patch Changes

- Updated dependencies [fdd50b2]
  - @scalar/api-client@2.2.54

## 1.25.124

### Patch Changes

- 4db5161: feat: allow multiple tokens for bearer auth
- Updated dependencies [4db5161]
  - @scalar/oas-utils@0.2.109
  - @scalar/types@0.0.36
  - @scalar/api-client@2.2.53
  - @scalar/openapi-parser@0.10.9
  - @scalar/themes@0.9.70
  - @scalar/code-highlight@0.0.23
  - @scalar/components@0.13.27
  - @scalar/use-hooks@0.1.24

## 1.25.123

### Patch Changes

- 50388ea: fix: resets reference editor z index
- 43031e7: feat: new lib/html-rendering in @scalar/api-reference
- 946a5df: feat: add front-end redirect
- b22f554: refactor: move HTML data-attribute API to lib
- c10bbf5: chore: code style
- 0ba190a: fix(api-reference): don't constrain zoomed in cards
- 4f7b767: fix: updates content type select component
- 78f0cdf: fix(api-reference): fix headings and add / organize regions
- bd70ab6: fix(api-reference): improve search button and modal a11y
- 577602f: fix: sidebar doesn’t clear state properly
- 875ee2c: fix(api-reference): use listbox for server selector
- cf14cbb: fix: show _/_ mimetype in example response
- e55bfd2: fix(components): improve ScalarModal zoom handling
- Updated dependencies [7833331]
- Updated dependencies [f61e986]
- Updated dependencies [c9a8fd8]
- Updated dependencies [8173889]
- Updated dependencies [8d9a2c0]
- Updated dependencies [8d9a2c0]
- Updated dependencies [8d9a2c0]
- Updated dependencies [9fc97da]
- Updated dependencies [3feee27]
- Updated dependencies [2be8986]
- Updated dependencies [946a5df]
- Updated dependencies [7017639]
- Updated dependencies [143d2a9]
- Updated dependencies [e52ecd2]
- Updated dependencies [12088f1]
- Updated dependencies [c10bbf5]
- Updated dependencies [eed78eb]
- Updated dependencies [0d58572]
- Updated dependencies [bd70ab6]
- Updated dependencies [875ee2c]
- Updated dependencies [4a0e6b7]
- Updated dependencies [cf14cbb]
- Updated dependencies [9251b22]
- Updated dependencies [e55bfd2]
- Updated dependencies [5a46f1c]
- Updated dependencies [a89510b]
- Updated dependencies [48f24c9]
- Updated dependencies [8d9a2c0]
  - @scalar/api-client@2.2.52
  - @scalar/components@0.13.26
  - @scalar/themes@0.9.69
  - @scalar/oas-utils@0.2.108
  - @scalar/code-highlight@0.0.23
  - @scalar/types@0.0.35
  - @scalar/openapi-parser@0.10.9
  - @scalar/openapi-types@0.1.9
  - @scalar/snippetz@0.2.15
  - @scalar/use-hooks@0.1.23
  - @scalar/use-toasts@0.7.9

## 1.25.122

### Patch Changes

- Updated dependencies [58a8efd]
  - @scalar/api-client@2.2.51

## 1.25.121

### Patch Changes

- e350f23: chore: code style
- 738d21c: chore: add brand to uids
- 459ad57: chore: remove active entities for prop drilling
- Updated dependencies [e350f23]
- Updated dependencies [e47a698]
- Updated dependencies [e47a698]
- Updated dependencies [debcb82]
- Updated dependencies [debcb82]
- Updated dependencies [738d21c]
- Updated dependencies [459ad57]
- Updated dependencies [e47a698]
  - @scalar/code-highlight@0.0.22
  - @scalar/openapi-parser@0.10.8
  - @scalar/openapi-types@0.1.8
  - @scalar/api-client@2.2.50
  - @scalar/components@0.13.25
  - @scalar/oas-utils@0.2.107
  - @scalar/snippetz@0.2.14
  - @scalar/themes@0.9.68
  - @scalar/types@0.0.34
  - @scalar/use-hooks@0.1.22
  - @scalar/use-toasts@0.7.9

## 1.25.120

### Patch Changes

- 25209ee: feat: markdown for the response description
- d2b7ca8: fix: renders arrays with discriminators four times instead of once
- Updated dependencies [c62884d]
- Updated dependencies [ed92564]
  - @scalar/api-client@2.2.49
  - @scalar/oas-utils@0.2.106

## 1.25.119

### Patch Changes

- Updated dependencies [453ed40]
- Updated dependencies [54fdfcb]
- Updated dependencies [825bc40]
- Updated dependencies [fa6afe8]
- Updated dependencies [8671902]
- Updated dependencies [1223c1f]
- Updated dependencies [7ce8d4c]
- Updated dependencies [4dedb68]
  - @scalar/api-client@2.2.48
  - @scalar/oas-utils@0.2.105
  - @scalar/types@0.0.33
  - @scalar/components@0.13.24
  - @scalar/code-highlight@0.0.21
  - @scalar/use-toasts@0.7.9
  - @scalar/use-hooks@0.1.21
  - @scalar/snippetz@0.2.13
  - @scalar/themes@0.9.67
  - @scalar/openapi-parser@0.10.7
  - @scalar/openapi-types@0.1.7

## 1.25.118

### Patch Changes

- 600ce16: fix: updates example request footer display logic
- 6e077ba: fix: enums in discriminators aren’t shown
- 305d084: refactor: use store to render example responses
- 4de3124: fix: can’t import type array e.g. `['string', 'null']`
- f2b082a: feat: add onLoaded event
- Updated dependencies [d028579]
- Updated dependencies [c5e9597]
- Updated dependencies [4de3124]
- Updated dependencies [bdddb12]
- Updated dependencies [69da9e0]
- Updated dependencies [f500435]
- Updated dependencies [da5cf08]
- Updated dependencies [b5727ef]
- Updated dependencies [c5e9597]
- Updated dependencies [4de3124]
- Updated dependencies [f9a75af]
- Updated dependencies [a515167]
- Updated dependencies [82c8f39]
- Updated dependencies [f9eee3f]
- Updated dependencies [b2a19ba]
- Updated dependencies [fa59538]
- Updated dependencies [34e6f52]
- Updated dependencies [bdddb12]
- Updated dependencies [d2165a8]
- Updated dependencies [4de3124]
- Updated dependencies [f2b082a]
  - @scalar/api-client@2.2.47
  - @scalar/openapi-parser@0.10.6
  - @scalar/components@0.13.23
  - @scalar/oas-utils@0.2.104
  - @scalar/types@0.0.32
  - @scalar/snippetz@0.2.12
  - @scalar/themes@0.9.66
  - @scalar/code-highlight@0.0.20
  - @scalar/use-hooks@0.1.20

## 1.25.117

### Patch Changes

- Updated dependencies [abc40ce]
- Updated dependencies [0b18abe]
- Updated dependencies [abc40ce]
- Updated dependencies [e4f11d8]
- Updated dependencies [2969dd0]
  - @scalar/api-client@2.2.46
  - @scalar/components@0.13.22

## 1.25.116

### Patch Changes

- 28f23d9: feat(components): create sidebar item components
- Updated dependencies [0f5df68]
- Updated dependencies [a30e7cc]
- Updated dependencies [ebde2b6]
- Updated dependencies [9f2ec32]
- Updated dependencies [937f791]
- Updated dependencies [227e8e3]
- Updated dependencies [9f2ec32]
- Updated dependencies [0babd51]
- Updated dependencies [28f23d9]
- Updated dependencies [4df540f]
  - @scalar/api-client@2.2.45
  - @scalar/oas-utils@0.2.103
  - @scalar/openapi-parser@0.10.5
  - @scalar/types@0.0.31
  - @scalar/components@0.13.21
  - @scalar/themes@0.9.65
  - @scalar/code-highlight@0.0.20
  - @scalar/use-hooks@0.1.19

## 1.25.115

### Patch Changes

- Updated dependencies [0d8b4ea]
  - @scalar/components@0.13.20
  - @scalar/api-client@2.2.44

## 1.25.114

### Patch Changes

- 2497761: fix: updates format example helper
- d1325d0: fix: hide auth in references when there's no schemes in the spec
- db3cf68: fix: include has prefix in heading ids
- f9bf5f1: feat(api-reference): implement rendering of `patternProperties`
- Updated dependencies [a34f834]
- Updated dependencies [26abf12]
- Updated dependencies [ef98b9c]
- Updated dependencies [a34f834]
- Updated dependencies [9c43ed7]
- Updated dependencies [26abf12]
- Updated dependencies [ebdf762]
- Updated dependencies [f9bf5f1]
  - @scalar/api-client@2.2.43
  - @scalar/oas-utils@0.2.102
  - @scalar/snippetz@0.2.11
  - @scalar/openapi-types@0.1.7
  - @scalar/types@0.0.30
  - @scalar/openapi-parser@0.10.4
  - @scalar/themes@0.9.64
  - @scalar/code-highlight@0.0.20
  - @scalar/components@0.13.19
  - @scalar/use-hooks@0.1.18

## 1.25.113

### Patch Changes

- Updated dependencies [aa6ff86]
  - @scalar/api-client@2.2.42

## 1.25.112

### Patch Changes

- be34e7d: feat: adds client server state usage in reference
- 2edbab2: fix: ensure add server button does not show on the references client server dropdown
- Updated dependencies [be34e7d]
- Updated dependencies [be34e7d]
- Updated dependencies [4e6f0eb]
- Updated dependencies [51f3177]
- Updated dependencies [42d08d7]
- Updated dependencies [42d08d7]
- Updated dependencies [2edbab2]
  - @scalar/oas-utils@0.2.101
  - @scalar/types@0.0.29
  - @scalar/api-client@2.2.41
  - @scalar/themes@0.9.63
  - @scalar/components@0.13.18
  - @scalar/openapi-parser@0.10.4
  - @scalar/code-highlight@0.0.20
  - @scalar/use-hooks@0.1.17

## 1.25.111

### Patch Changes

- Updated dependencies [6636051]
  - @scalar/api-client@2.2.40

## 1.25.110

### Patch Changes

- Updated dependencies [8d4ab54]
  - @scalar/api-client@2.2.39

## 1.25.109

### Patch Changes

- 09dee7e: fix: jumping on initial load for big specs
- 702c386: feat: add support for stability
- a4ec7fa: refactor: use request entity for TestRequestButton
- Updated dependencies [7a18a2d]
- Updated dependencies [12e7232]
- Updated dependencies [8b5d905]
- Updated dependencies [b0d5511]
- Updated dependencies [974234f]
- Updated dependencies [776a4e2]
- Updated dependencies [2ed681b]
- Updated dependencies [6400bfc]
- Updated dependencies [8665004]
- Updated dependencies [4f12fe4]
- Updated dependencies [702c386]
- Updated dependencies [901970f]
- Updated dependencies [6400bfc]
- Updated dependencies [a4ec7fa]
- Updated dependencies [5ab0663]
- Updated dependencies [f1f39b0]
- Updated dependencies [5ab0663]
- Updated dependencies [917214a]
- Updated dependencies [f1f39b0]
- Updated dependencies [776a4e2]
- Updated dependencies [42b58bf]
- Updated dependencies [2ed681b]
  - @scalar/api-client@2.2.38
  - @scalar/oas-utils@0.2.100
  - @scalar/components@0.13.17
  - @scalar/themes@0.9.62
  - @scalar/types@0.0.28
  - @scalar/code-highlight@0.0.20
  - @scalar/use-hooks@0.1.16
  - @scalar/openapi-parser@0.10.4

## 1.25.108

### Patch Changes

- Updated dependencies [9276103]
- Updated dependencies [de6cd98]
  - @scalar/api-client@2.2.37

## 1.25.107

### Patch Changes

- a871c83: fix(api-reference): add .introduction-section class to Introduction
- Updated dependencies [ca381b6]
- Updated dependencies [c803e2d]
- Updated dependencies [aac6c86]
- Updated dependencies [ca381b6]
  - @scalar/api-client@2.2.36
  - @scalar/oas-utils@0.2.99
  - @scalar/components@0.13.16

## 1.25.106

### Patch Changes

- 5501ee3: feat: render operation parameters from the store
- 6062a69: fix: only first entry in hidden tag is hidden from the reference
- 1bee104: fix: SSG/SSR builds break
- b552db5: feat: add url customization functions for references
- Updated dependencies [97d8981]
- Updated dependencies [1bee104]
- Updated dependencies [f9668c5]
- Updated dependencies [109e320]
- Updated dependencies [b552db5]
- Updated dependencies [f9668c5]
- Updated dependencies [b968e0f]
- Updated dependencies [b968e0f]
- Updated dependencies [406eb48]
- Updated dependencies [f1f8de9]
  - @scalar/components@0.13.15
  - @scalar/api-client@2.2.35
  - @scalar/code-highlight@0.0.20
  - @scalar/types@0.0.27
  - @scalar/oas-utils@0.2.98
  - @scalar/openapi-parser@0.10.4
  - @scalar/themes@0.9.61
  - @scalar/use-hooks@0.1.15

## 1.25.105

### Patch Changes

- Updated dependencies [ac86150]
  - @scalar/api-client@2.2.34

## 1.25.104

### Patch Changes

- ace02fe: fix: favors configuration integration in open client modal button
- 60cd6f1: feat: render the operation description from the new store
- 39df543: feat: flatten discriminators containing null
- e866487: feat(components): create dark light toggle components
- d2b1525: feat: version prefix
- Updated dependencies [2ad0407]
- Updated dependencies [ace02fe]
- Updated dependencies [60cd6f1]
- Updated dependencies [60cd6f1]
- Updated dependencies [e866487]
- Updated dependencies [6d03777]
- Updated dependencies [6d03777]
- Updated dependencies [7df4472]
- Updated dependencies [13333e6]
- Updated dependencies [64df4fc]
- Updated dependencies [08ac264]
- Updated dependencies [aff72f7]
- Updated dependencies [cb09e76]
- Updated dependencies [2ad0407]
  - @scalar/api-client@2.2.33
  - @scalar/components@0.13.14
  - @scalar/types@0.0.26
  - @scalar/use-hooks@0.1.14
  - @scalar/themes@0.9.60
  - @scalar/oas-utils@0.2.97
  - @scalar/openapi-types@0.1.6
  - @scalar/openapi-parser@0.10.4
  - @scalar/code-highlight@0.0.19

## 1.25.103

### Patch Changes

- f9f5bdb: feat: remove examples from responses
- Updated dependencies [d3199be]
  - @scalar/api-client@2.2.32

## 1.25.102

### Patch Changes

- 9e2e8be: fix: cookie parameters don’t show up
- 273e927: fix: removes schema example duplication
- 0642732: fix: adds collabsibility to one endpoint non default tag
- 58d5f6c: fix: shows enum value when there is only one
- Updated dependencies [731b037]
- Updated dependencies [5b26c75]
- Updated dependencies [eb50f99]
- Updated dependencies [b92b160]
- Updated dependencies [e77e959]
- Updated dependencies [30ae0df]
- Updated dependencies [e17ac68]
- Updated dependencies [ff3bdca]
- Updated dependencies [cf0e7b1]
- Updated dependencies [fdd1de7]
- Updated dependencies [8dce84f]
- Updated dependencies [197b7e1]
- Updated dependencies [ee22e40]
- Updated dependencies [7b4ab2c]
  - @scalar/api-client@2.2.31
  - @scalar/components@0.13.13
  - @scalar/oas-utils@0.2.96
  - @scalar/snippetz@0.2.10
  - @scalar/openapi-parser@0.10.3
  - @scalar/themes@0.9.59
  - @scalar/types@0.0.25
  - @scalar/code-highlight@0.0.19
  - @scalar/use-hooks@0.1.13

## 1.25.101

### Patch Changes

- Updated dependencies [1785304]
  - @scalar/api-client@2.2.30

## 1.25.100

### Patch Changes

- b291406: fix(api-client): redesign auth
- b291406: style: adds data table and server auth component fixtures
- c37fb70: style: displays property example in schemadisplays property example in schema
- Updated dependencies [4a2b0a4]
- Updated dependencies [b291406]
- Updated dependencies [66bc910]
- Updated dependencies [b291406]
- Updated dependencies [46dce72]
- Updated dependencies [58a2049]
  - @scalar/api-client@2.2.29
  - @scalar/use-toasts@0.7.8
  - @scalar/components@0.13.12
  - @scalar/use-hooks@0.1.12

## 1.25.99

### Patch Changes

- Updated dependencies [4f6ebab]
- Updated dependencies [794ae62]
  - @scalar/api-client@2.2.28
  - @scalar/components@0.13.11

## 1.25.98

### Patch Changes

- Updated dependencies [3156ecd]
  - @scalar/api-client@2.2.27
  - @scalar/oas-utils@0.2.95

## 1.25.97

### Patch Changes

- Updated dependencies [a36fada]
  - @scalar/oas-utils@0.2.94
  - @scalar/api-client@2.2.26

## 1.25.96

### Patch Changes

- Updated dependencies [00feb3e]
  - @scalar/api-client@2.2.25

## 1.25.95

### Patch Changes

- 6890d7e: fix: fix(api-reference): sets request server in request example hook
- bc8f883: fix: ensure spec exists before trying to create store
- Updated dependencies [6890d7e]
- Updated dependencies [ca2d98b]
- Updated dependencies [ca2d98b]
- Updated dependencies [6890d7e]
  - @scalar/api-client@2.2.24
  - @scalar/oas-utils@0.2.93

## 1.25.94

### Patch Changes

- 02b4201: fix(api-client): strict TS config (enable noUncheckedIndexedAccess)
- 9cf76af: fix: add immediete to load the workspace store
- Updated dependencies [02b4201]
  - @scalar/api-client@2.2.23
  - @scalar/oas-utils@0.2.92

## 1.25.93

### Patch Changes

- Updated dependencies [4619a8c]
  - @scalar/api-client@2.2.22

## 1.25.92

### Patch Changes

- fd80d43: fix(api-reference): correct `hash.value` encoding to ensure scrolling
- 47d1d82: feat: add debounce to client config update to improve perf
- Updated dependencies [9b3a053]
- Updated dependencies [46ebb44]
- Updated dependencies [d4b17f5]
  - @scalar/api-client@2.2.21
  - @scalar/components@0.13.10

## 1.25.91

### Patch Changes

- @scalar/api-client@2.2.20

## 1.25.90

### Patch Changes

- Updated dependencies [53d99b7]
  - @scalar/api-client@2.2.19

## 1.25.89

### Patch Changes

- 3c7d7dd: fix: reverts sets server variables values in client
- Updated dependencies [3c7d7dd]
- Updated dependencies [33c8393]
- Updated dependencies [3791738]
- Updated dependencies [33c8393]
- Updated dependencies [66905d2]
  - @scalar/api-client@2.2.18
  - @scalar/components@0.13.9
  - @scalar/openapi-parser@0.10.2
  - @scalar/oas-utils@0.2.91

## 1.25.88

### Patch Changes

- 6407b2b: feat(api-reference): extend font weights for links and sidebar items
- c65f3fc: fix: workspace store uses deprecated proxy attribute
- c65f3fc: feat: make it work in SSG environments
- c65f3fc: chore: remove RenderedReference export
- Updated dependencies [6407b2b]
- Updated dependencies [c65f3fc]
- Updated dependencies [c65f3fc]
  - @scalar/code-highlight@0.0.19
  - @scalar/themes@0.9.58
  - @scalar/api-client@2.2.17
  - @scalar/use-hooks@0.1.11
  - @scalar/components@0.13.8
  - @scalar/oas-utils@0.2.91

## 1.25.87

### Patch Changes

- Updated dependencies [875a04a]
  - @scalar/api-client@2.2.16

## 1.25.86

### Patch Changes

- c263aaf: feat: better deal with empty OpenAPI documents
- Updated dependencies [c263aaf]
- Updated dependencies [573d113]
- Updated dependencies [c263aaf]
  - @scalar/types@0.0.25
  - @scalar/oas-utils@0.2.90
  - @scalar/openapi-parser@0.10.1
  - @scalar/api-client@2.2.15
  - @scalar/themes@0.9.57
  - @scalar/code-highlight@0.0.18
  - @scalar/components@0.13.7
  - @scalar/use-hooks@0.1.10

## 1.25.85

### Patch Changes

- Updated dependencies [984e394]
- Updated dependencies [40ec239]
  - @scalar/api-client@2.2.14

## 1.25.84

### Patch Changes

- Updated dependencies [23daedd]
  - @scalar/api-client@2.2.13
  - @scalar/components@0.13.6
  - @scalar/themes@0.9.56
  - @scalar/code-highlight@0.0.18
  - @scalar/oas-utils@0.2.89
  - @scalar/use-hooks@0.1.9

## 1.25.83

### Patch Changes

- 7a2b32d: fix: hides dark mode toggle only if configured
- c78beda: fix: missing open in api client button

## 1.25.82

### Patch Changes

- bd84466: Removes hardcoded test prefix

## 1.25.81

### Patch Changes

- fbef0c3: feat: increases visible enum value item number
- fbef0c3: Adds support for hash prefixing. Requires manual control of useNavState.
- fbef0c3: fix(api-reference): correct anchor id encoding to ensure correct page scrolling #4173
- fbef0c3: fix: sets server variables values in client
- fbef0c3: chore: remove httpsnippet-lite
- Updated dependencies [fbef0c3]
- Updated dependencies [fbef0c3]
- Updated dependencies [fbef0c3]
- Updated dependencies [fbef0c3]
- Updated dependencies [fbef0c3]
  - @scalar/openapi-parser@0.10.0
  - @scalar/api-client@2.2.12
  - @scalar/snippetz@0.2.9
  - @scalar/types@0.0.24
  - @scalar/oas-utils@0.2.88
  - @scalar/themes@0.9.55
  - @scalar/code-highlight@0.0.18
  - @scalar/components@0.13.5
  - @scalar/use-hooks@0.1.8

## 1.25.80

### Patch Changes

- a109244: fix: operation server null check

## 1.25.79

### Patch Changes

- cbc70ae: fix: circular dependency
- eea1822: fix: adds server with variables to request example
- Updated dependencies [371a105]
- Updated dependencies [f2ec4f2]
- Updated dependencies [035d9af]
- Updated dependencies [8687842]
- Updated dependencies [8017ff9]
- Updated dependencies [e05c29f]
  - @scalar/api-client@2.2.11
  - @scalar/oas-utils@0.2.87

## 1.25.78

### Patch Changes

- Updated dependencies [749ebf1]
- Updated dependencies [6fef2f3]
- Updated dependencies [749ebf1]
- Updated dependencies [c761730]
- Updated dependencies [02e6a57]
  - @scalar/components@0.13.4
  - @scalar/openapi-parser@0.9.0
  - @scalar/api-client@2.2.10
  - @scalar/snippetz@0.2.8
  - @scalar/oas-utils@0.2.86

## 1.25.77

### Patch Changes

- 3eb0d11: feat: moved api-client auth into references
- Updated dependencies [3eb0d11]
- Updated dependencies [b66a85c]
- Updated dependencies [3eb0d11]
- Updated dependencies [62e80cd]
- Updated dependencies [bccfa3a]
- Updated dependencies [66c1573]
- Updated dependencies [b66a85c]
- Updated dependencies [b66a85c]
- Updated dependencies [b66a85c]
  - @scalar/api-client@2.2.9
  - @scalar/oas-utils@0.2.86
  - @scalar/components@0.13.3

## 1.25.76

### Patch Changes

- Updated dependencies [f2ec59d]
  - @scalar/api-client@2.2.8

## 1.25.75

### Patch Changes

- f955985: fix: favors use event listener for meta k command
- c2be791: fix: watches text input to fuse search
- Updated dependencies [a90d827]
- Updated dependencies [57b5e5d]
- Updated dependencies [d0adebf]
- Updated dependencies [c2be791]
- Updated dependencies [3b4a788]
- Updated dependencies [3b4a788]
- Updated dependencies [f4440f5]
- Updated dependencies [4c5be96]
- Updated dependencies [4c5be96]
  - @scalar/api-client@2.2.7
  - @scalar/components@0.13.2
  - @scalar/snippetz@0.2.7
  - @scalar/oas-utils@0.2.85

## 1.25.74

### Patch Changes

- 13432e7: feat: fall back to the API reference URL for the import
- Updated dependencies [b744324]
- Updated dependencies [0804d6b]
- Updated dependencies [0076308]
- Updated dependencies [9b4f85d]
- Updated dependencies [13432e7]
  - @scalar/api-client@2.2.6
  - @scalar/oas-utils@0.2.84

## 1.25.73

### Patch Changes

- e199e9b: feat: updates chevron down icon
- e199e9b: feat: updates add icon
- ab5f0a0: style: enhances section header long content
- c2f5f08: feat: adds hideClientButton option configuration
- ab5f0a0: fix: classic layout responsiveness
- Updated dependencies [e199e9b]
- Updated dependencies [4a72149]
- Updated dependencies [e199e9b]
- Updated dependencies [f524411]
- Updated dependencies [e199e9b]
- Updated dependencies [10c01b2]
- Updated dependencies [10c9016]
- Updated dependencies [e199e9b]
- Updated dependencies [31cb86b]
- Updated dependencies [c2f5f08]
- Updated dependencies [1f730c6]
- Updated dependencies [b11294c]
- Updated dependencies [f30ce11]
- Updated dependencies [8958af0]
  - @scalar/components@0.13.1
  - @scalar/snippetz@0.2.6
  - @scalar/code-highlight@0.0.18
  - @scalar/api-client@2.2.5
  - @scalar/oas-utils@0.2.83
  - @scalar/types@0.0.23
  - @scalar/themes@0.9.54
  - @scalar/use-hooks@0.1.7

## 1.25.72

### Patch Changes

- 7605d6f: feat: add error boundary component
- c9b6873: feat: moved hidden client config to apiReferenceLayout
- baaad1c: refactor: deprecated the `proxy` configuration attribute, and use `proxyUrl` everywhere
- c984ac8: feat(api-reference): displays path server in request example
- Updated dependencies [ae0555b]
- Updated dependencies [2dd6aa3]
- Updated dependencies [6389557]
- Updated dependencies [7605d6f]
- Updated dependencies [d08a7ae]
- Updated dependencies [baaad1c]
- Updated dependencies [80ee5e0]
- Updated dependencies [642d112]
- Updated dependencies [c984ac8]
- Updated dependencies [7278742]
- Updated dependencies [bae9997]
- Updated dependencies [3ca88dc]
- Updated dependencies [f6cd5ed]
  - @scalar/snippetz@0.2.5
  - @scalar/components@0.13.0
  - @scalar/oas-utils@0.2.82
  - @scalar/api-client@2.2.4
  - @scalar/types@0.0.22
  - @scalar/themes@0.9.53
  - @scalar/code-highlight@0.0.17
  - @scalar/use-hooks@0.1.6

## 1.25.71

### Patch Changes

- Updated dependencies [1fa0d20]
  - @scalar/themes@0.9.52
  - @scalar/api-client@2.2.3
  - @scalar/code-highlight@0.0.17
  - @scalar/components@0.12.76
  - @scalar/oas-utils@0.2.81
  - @scalar/use-hooks@0.1.5

## 1.25.70

### Patch Changes

- 8004539: fix: response have been doubled
- 9d23f95: refactor: make the Operations component a feature
- 9002259: style: font size fixtures
- Updated dependencies [794a50d]
- Updated dependencies [85a9aea]
- Updated dependencies [9d23f95]
- Updated dependencies [91123e8]
- Updated dependencies [6140275]
- Updated dependencies [9002259]
  - @scalar/api-client@2.2.2
  - @scalar/types@0.0.21
  - @scalar/themes@0.9.51
  - @scalar/components@0.12.75
  - @scalar/code-highlight@0.0.17
  - @scalar/oas-utils@0.2.80
  - @scalar/use-hooks@0.1.4

## 1.25.69

### Patch Changes

- 1b06f64: fix(api-reference): conflicting styles with bulma, galaxy bug on docs
- fda0e5c: fix(api-reference): missing section borders and card-form border
- Updated dependencies [5da67b2]
- Updated dependencies [6b0d817]
- Updated dependencies [6b0d817]
- Updated dependencies [6c843e6]
- Updated dependencies [324834d]
- Updated dependencies [1b06f64]
- Updated dependencies [8066c8c]
- Updated dependencies [6dd7eda]
  - @scalar/api-client@2.2.1
  - @scalar/components@0.12.74
  - @scalar/code-highlight@0.0.16
  - @scalar/themes@0.9.50
  - @scalar/oas-utils@0.2.79
  - @scalar/use-hooks@0.1.3

## 1.25.68

### Patch Changes

- daa2663: feat: split out the router based computed values from the store into its own store
- f67c3bc: feat: add framework themes
- Updated dependencies [d379b81]
- Updated dependencies [daa2663]
- Updated dependencies [f67c3bc]
- Updated dependencies [28a6b05]
- Updated dependencies [37abd4f]
- Updated dependencies [37abd4f]
  - @scalar/themes@0.9.49
  - @scalar/api-client@2.2.0
  - @scalar/oas-utils@0.2.78
  - @scalar/types@0.0.20
  - @scalar/components@0.12.73
  - @scalar/code-highlight@0.0.15
  - @scalar/use-hooks@0.1.2

## 1.25.67

### Patch Changes

- 594a96c: fix: wrap property heading and detail
- 0adbfd5: feat(use-hooks): add useBreakpoint hook
- 9b4def7: feat: adds use example store
- 2a6117e: feat(use-hooks): add computed dark light mode
- Updated dependencies [cb3e89f]
- Updated dependencies [0adbfd5]
- Updated dependencies [98e9cb2]
- Updated dependencies [9b4def7]
- Updated dependencies [44a7100]
- Updated dependencies [12fed75]
- Updated dependencies [1e3214c]
- Updated dependencies [2a6117e]
  - @scalar/api-client@2.1.52
  - @scalar/use-hooks@0.1.1
  - @scalar/openapi-parser@0.8.10
  - @scalar/oas-utils@0.2.77
  - @scalar/components@0.12.72

## 1.25.66

### Patch Changes

- Updated dependencies [7abe0f9]
  - @scalar/components@0.12.71
  - @scalar/api-client@2.1.51

## 1.25.65

### Patch Changes

- bfad6dc: feat(use-hooks): create @scalar/use-hooks with useColorMode and useClipboard
- c8fae11: fix(components): cleanup ScalarMenu and ScalarListbox
- 6894b7d: feat: omits empty and optional properties from example request
- Updated dependencies [bfad6dc]
- Updated dependencies [c8fae11]
- Updated dependencies [6894b7d]
- Updated dependencies [c87353e]
- Updated dependencies [c3d9f3c]
  - @scalar/api-client@2.1.50
  - @scalar/components@0.12.70
  - @scalar/use-hooks@0.1.0
  - @scalar/oas-utils@0.2.76

## 1.25.64

### Patch Changes

- 49ccdee: refactor: updates regexHelpers
- 49ccdee: fix: base url server variables
- Updated dependencies [49ccdee]
- Updated dependencies [45342e3]
- Updated dependencies [0a34402]
- Updated dependencies [d0c93f5]
- Updated dependencies [8b54fac]
  - @scalar/api-client@2.1.49
  - @scalar/oas-utils@0.2.75
  - @scalar/components@0.12.69

## 1.25.63

### Patch Changes

- ac55d0f: chore: remove time logging for the search index
- Updated dependencies [b5c1982]
- Updated dependencies [ac55d0f]
- Updated dependencies [0c07766]
- Updated dependencies [bdb48b0]
- Updated dependencies [7f1bd17]
  - @scalar/api-client@2.1.48
  - @scalar/components@0.12.68
  - @scalar/oas-utils@0.2.74
  - @scalar/themes@0.9.48
  - @scalar/code-highlight@0.0.15

## 1.25.62

### Patch Changes

- ca05270: style: updates introduction card server description
- Updated dependencies [b717102]
- Updated dependencies [82f7c35]
- Updated dependencies [b717102]
- Updated dependencies [8610c74]
- Updated dependencies [af47a3e]
- Updated dependencies [3421489]
- Updated dependencies [766a1fd]
  - @scalar/api-client@2.1.47
  - @scalar/oas-utils@0.2.73
  - @scalar/components@0.12.67

## 1.25.61

### Patch Changes

- Updated dependencies [4bcaa75]
- Updated dependencies [ecdf18d]
- Updated dependencies [caa45c9]
- Updated dependencies [9eb6650]
- Updated dependencies [4a3c873]
- Updated dependencies [c98a99c]
- Updated dependencies [15a47e6]
- Updated dependencies [576e94a]
- Updated dependencies [09a6fba]
- Updated dependencies [be50225]
- Updated dependencies [0a0ca71]
  - @scalar/oas-utils@0.2.72
  - @scalar/api-client@2.1.46
  - @scalar/components@0.12.66

## 1.25.60

### Patch Changes

- a40999d: chore: added type safety rule noUncheckedIndexedAccess
- b89da58: fix: ingest base server URL and use it in the api client
- Updated dependencies [a40999d]
- Updated dependencies [b89da58]
- Updated dependencies [3300d5b]
  - @scalar/code-highlight@0.0.15
  - @scalar/oas-utils@0.2.71
  - @scalar/themes@0.9.47
  - @scalar/api-client@2.1.45
  - @scalar/components@0.12.65
  - @scalar/openapi-parser@0.8.9
  - @scalar/openapi-types@0.1.5
  - @scalar/snippetz@0.2.4
  - @scalar/types@0.0.19
  - @scalar/use-toasts@0.7.7

## 1.25.59

### Patch Changes

- f9808d3: chore: remove unused dependencies
- Updated dependencies [c3e76d9]
- Updated dependencies [757fade]
- Updated dependencies [a607115]
- Updated dependencies [79d33da]
  - @scalar/api-client@2.1.44
  - @scalar/oas-utils@0.2.70
  - @scalar/openapi-parser@0.8.9
  - @scalar/openapi-types@0.1.5
  - @scalar/types@0.0.19
  - @scalar/themes@0.9.46
  - @scalar/code-highlight@0.0.14
  - @scalar/components@0.12.64

## 1.25.58

### Patch Changes

- 132997b: chore: remove unnecessary svg attribute
- Updated dependencies [a0421dd]
- Updated dependencies [8c5d767]
- Updated dependencies [359ee2d]
- Updated dependencies [6a2ec39]
  - @scalar/api-client@2.1.43
  - @scalar/oas-utils@0.2.69

## 1.25.57

### Patch Changes

- Updated dependencies [dab543e]
  - @scalar/oas-utils@0.2.68
  - @scalar/api-client@2.1.42

## 1.25.56

### Patch Changes

- Updated dependencies [823c14d]
- Updated dependencies [997cd35]
  - @scalar/api-client@2.1.41
  - @scalar/oas-utils@0.2.67

## 1.25.55

### Patch Changes

- 5d8c90b: fix: api references jumping in next.js
- f764640: fix(api-reference): reflect hidden http clients and custom examples
- Updated dependencies [db4a4b7]
- Updated dependencies [c63ab07]
- Updated dependencies [c929284]
- Updated dependencies [2275977]
- Updated dependencies [e044d78]
- Updated dependencies [3a0c367]
- Updated dependencies [89a2cc7]
- Updated dependencies [e461e5b]
  - @scalar/api-client@2.1.40
  - @scalar/oas-utils@0.2.66

## 1.25.54

### Patch Changes

- Updated dependencies [bd8e253]
- Updated dependencies [b9b42f6]
  - @scalar/api-client@2.1.39

## 1.25.53

### Patch Changes

- fb798c8: chore: make OpenAPI document URLs the default, deprecated `content`
- cf4e9c4: fix(components): resize and scroll scalar listbox and dropdown
- 6108625: feat: adds disclosure button on enum values
- cfe9b85: fix: added safe parsing for oauth examples
- 6599473: fix: arrays with allOf items render invalid examples
- bb3dc9d: fix(api-reference): improve endpoint and tag accessibility
- 0e19781: feat: fix reactivitiy of references + client
- ac0f8f1: fix: fixtures schema properties margin
- Updated dependencies [fb798c8]
- Updated dependencies [cf4e9c4]
- Updated dependencies [3bec045]
- Updated dependencies [743474e]
- Updated dependencies [743474e]
- Updated dependencies [cfe9b85]
- Updated dependencies [0fb3a41]
- Updated dependencies [417e0c7]
- Updated dependencies [4d45f7b]
- Updated dependencies [6599473]
- Updated dependencies [bb3dc9d]
- Updated dependencies [0e19781]
  - @scalar/types@0.0.18
  - @scalar/api-client@2.1.38
  - @scalar/components@0.12.63
  - @scalar/oas-utils@0.2.65
  - @scalar/themes@0.9.45
  - @scalar/object-utils@1.1.11
  - @scalar/code-highlight@0.0.14

## 1.25.52

### Patch Changes

- Updated dependencies [931106f]
  - @scalar/oas-utils@0.2.64
  - @scalar/api-client@2.1.37

## 1.25.51

### Patch Changes

- 369c2c2: style(api-reference): auth font size and color
- ada8545: feat: add the sidebar button
- 56a48d1: style(api-reference): fix font sizes of read only and property detail values
- ada8545: feat: add the sidebar button
- Updated dependencies [84bd664]
- Updated dependencies [ad12c56]
- Updated dependencies [ada8545]
- Updated dependencies [86104fd]
  - @scalar/api-client@2.1.36
  - @scalar/components@0.12.62
  - @scalar/themes@0.9.44
  - @scalar/oas-utils@0.2.63
  - @scalar/code-highlight@0.0.14

## 1.25.50

### Patch Changes

- 77256f4: fix: add optional chaining to target replacement in httpSnippetLiteTargetKey
- Updated dependencies [9f9c5b7]
- Updated dependencies [15b6082]
- Updated dependencies [097ab40]
- Updated dependencies [9affbe3]
- Updated dependencies [277f95c]
- Updated dependencies [197e3ae]
  - @scalar/api-client@2.1.35
  - @scalar/oas-utils@0.2.62
  - @scalar/components@0.12.61
  - @scalar/themes@0.9.43
  - @scalar/code-highlight@0.0.14

## 1.25.49

### Patch Changes

- 5995f57: feat: prepare references for the client auth
- a265153: fix(api-reference): sidebar a11y improvements
- 69bda25: feat: synced up client auth with references
- Updated dependencies [5995f57]
- Updated dependencies [7323370]
- Updated dependencies [4c1536d]
- Updated dependencies [d7a6c55]
- Updated dependencies [d7a6c55]
- Updated dependencies [d7a6c55]
- Updated dependencies [2456afa]
- Updated dependencies [69bda25]
  - @scalar/api-client@2.1.34
  - @scalar/openapi-parser@0.8.8
  - @scalar/oas-utils@0.2.61
  - @scalar/themes@0.9.42
  - @scalar/code-highlight@0.0.14
  - @scalar/components@0.12.60

## 1.25.48

### Patch Changes

- Updated dependencies [7700c50]
  - @scalar/components@0.12.59
  - @scalar/api-client@2.1.33

## 1.25.47

### Patch Changes

- 70846c1: style(api-reference): required stringe orange color
- 3e2b1e1: style: updates authentication form radiuses
- Updated dependencies [4ccbb6b]
- Updated dependencies [85a1815]
- Updated dependencies [a12857f]
- Updated dependencies [b500de2]
- Updated dependencies [294fde8]
- Updated dependencies [0706bc4]
- Updated dependencies [86a3a82]
- Updated dependencies [48afb7c]
  - @scalar/api-client@2.1.32

## 1.25.46

### Patch Changes

- b4a93ab: fix: tag typography and intro type
- Updated dependencies [b4a93ab]
  - @scalar/code-highlight@0.0.14
  - @scalar/components@0.12.58
  - @scalar/api-client@2.1.31

## 1.25.45

### Patch Changes

- Updated dependencies [2b540b9]
- Updated dependencies [6ecb7cc]
- Updated dependencies [32ad241]
  - @scalar/openapi-types@0.1.4
  - @scalar/api-client@2.1.30
  - @scalar/components@0.12.57
  - @scalar/oas-utils@0.2.60
  - @scalar/openapi-parser@0.8.7
  - @scalar/types@0.0.17
  - @scalar/themes@0.9.41
  - @scalar/code-highlight@0.0.13

## 1.25.44

### Patch Changes

- Updated dependencies [c658a7a]
- Updated dependencies [d51d303]
  - @scalar/api-client@2.1.29

## 1.25.43

### Patch Changes

- Updated dependencies [dea4f88]
  - @scalar/api-client@2.1.28

## 1.25.42

### Patch Changes

- 6bbb815: fix(api-reference): search modal a11y improvements
- Updated dependencies [4e50d65]
- Updated dependencies [4e50d65]
- Updated dependencies [4e50d65]
- Updated dependencies [4e50d65]
- Updated dependencies [4e50d65]
- Updated dependencies [6bbb815]
- Updated dependencies [4e50d65]
  - @scalar/components@0.12.56
  - @scalar/api-client@2.1.27
  - @scalar/oas-utils@0.2.59
  - @scalar/themes@0.9.40
  - @scalar/code-highlight@0.0.13

## 1.25.41

### Patch Changes

- a80a931: fix: command palette modal overflow
- Updated dependencies [8223e31]
- Updated dependencies [f8b81ee]
- Updated dependencies [9e769df]
- Updated dependencies [a80a931]
  - @scalar/api-client@2.1.26

## 1.25.40

### Patch Changes

- Updated dependencies [4722da1]
  - @scalar/themes@0.9.39
  - @scalar/api-client@2.1.25
  - @scalar/code-highlight@0.0.13
  - @scalar/components@0.12.55
  - @scalar/oas-utils@0.2.58

## 1.25.39

### Patch Changes

- Updated dependencies [8f4b4a2]
  - @scalar/api-client@2.1.24

## 1.25.38

### Patch Changes

- dbbe38f: feat: add framework identifier for debugging purposes
- 59d3931: chore: remove unused dependencies
- Updated dependencies [5cb5cdf]
- Updated dependencies [971c04c]
- Updated dependencies [75f84f8]
- Updated dependencies [3800b54]
- Updated dependencies [6394a5d]
- Updated dependencies [dbbe38f]
- Updated dependencies [59d3931]
- Updated dependencies [2173073]
- Updated dependencies [c379e5a]
- Updated dependencies [aebac4e]
- Updated dependencies [4b8b611]
- Updated dependencies [4738228]
  - @scalar/api-client@2.1.23
  - @scalar/components@0.12.55
  - @scalar/openapi-parser@0.8.7
  - @scalar/types@0.0.16
  - @scalar/themes@0.9.38
  - @scalar/oas-utils@0.2.57
  - @scalar/code-highlight@0.0.13

## 1.25.37

### Patch Changes

- 0c34a18: chore: updated vue package to 3.5
- Updated dependencies [b8f9a95]
- Updated dependencies [8759e7f]
- Updated dependencies [0c34a18]
  - @scalar/api-client@2.1.22
  - @scalar/oas-utils@0.2.56
  - @scalar/openapi-types@0.1.3
  - @scalar/code-highlight@0.0.13
  - @scalar/use-tooltip@1.0.3
  - @scalar/components@0.12.54
  - @scalar/use-toasts@0.7.7
  - @scalar/openapi-parser@0.8.6
  - @scalar/types@0.0.15
  - @scalar/themes@0.9.37

## 1.25.36

## 1.25.35

### Patch Changes

- Updated dependencies [f935fad]
  - @scalar/components@0.12.53
  - @scalar/api-client@2.1.21

## 1.25.34

### Patch Changes

- e57b9a9: fix(api-reference): render tags in tag group order if set
- Updated dependencies [0ddd4f3]
- Updated dependencies [deb13b9]
- Updated dependencies [b99799e]
  - @scalar/api-client@2.1.20
  - @scalar/components@0.12.52
  - @scalar/oas-utils@0.2.55

## 1.25.33

### Patch Changes

- 0da6063: chore: add tailwind
- 1d815d4: fix: download is triggered twice
- 3db9355: feat: upgrade Swagger 2.0 securityDefinitions
- 8e31ccd: fix: lazyLoading content jump
- 2ff5905: chore: cache results of getExampleFromSchema
- Updated dependencies [e5ee02f]
- Updated dependencies [d064a78]
- Updated dependencies [3db9355]
- Updated dependencies [8da2152]
- Updated dependencies [2a77f7b]
- Updated dependencies [2ff5905]
- Updated dependencies [9a2d5ca]
- Updated dependencies [d02d70c]
- Updated dependencies [e911047]
- Updated dependencies [d02d70c]
- Updated dependencies [9a2d5ca]
  - @scalar/api-client@2.1.19
  - @scalar/openapi-parser@0.8.6
  - @scalar/oas-utils@0.2.54
  - @scalar/code-highlight@0.0.12
  - @scalar/openapi-types@0.1.2
  - @scalar/snippetz@0.2.4
  - @scalar/types@0.0.14
  - @scalar/themes@0.9.36
  - @scalar/components@0.12.51
  - @scalar/use-toasts@0.7.6
  - @scalar/use-tooltip@1.0.2

## 1.25.32

### Patch Changes

- 46a55ae: feat(api-client): improve client import ux
- 90e4baf: fix(api-reference): show path and test request when hiddenClients is true
- b26144c: fix(themes): remove variables from theme layer and move selection to default (base) theme
- Updated dependencies [7c2e291]
- Updated dependencies [46a55ae]
- Updated dependencies [5d996a8]
- Updated dependencies [b26144c]
  - @scalar/api-client@2.1.18
  - @scalar/oas-utils@0.2.53
  - @scalar/themes@0.9.35
  - @scalar/code-highlight@0.0.11
  - @scalar/components@0.12.50

## 1.25.31

### Patch Changes

- Updated dependencies [8396e92]
- Updated dependencies [6279c59]
- Updated dependencies [5581a28]
  - @scalar/api-client@2.1.17

## 1.25.30

### Patch Changes

- Updated dependencies [c9a0d57]
  - @scalar/api-client@2.1.16

## 1.25.29

### Patch Changes

- 9dc2ab7: feat: new `operationsSorter` option
- Updated dependencies [9dc2ab7]
  - @scalar/types@0.0.13
  - @scalar/api-client@2.1.15
  - @scalar/oas-utils@0.2.52
  - @scalar/themes@0.9.34
  - @scalar/code-highlight@0.0.11
  - @scalar/components@0.12.50

## 1.25.28

### Patch Changes

- Updated dependencies [dea7b57]
- Updated dependencies [008eca4]
- Updated dependencies [9ba2c9f]
  - @scalar/api-client@2.1.14

## 1.25.27

### Patch Changes

- Updated dependencies [cebca7a]
- Updated dependencies [3b12248]
- Updated dependencies [a78b0a6]
  - @scalar/api-client@2.1.13

## 1.25.26

### Patch Changes

- 3ded00b: fix(api-references): sync selected server state with api client modal
- 040ca78: fix: show oauth code authorization
- 94b8ffd: fix(api-reference): check if default value is undefined instead of falsy
- Updated dependencies [513e0ad]
- Updated dependencies [8f12149]
- Updated dependencies [5127a37]
- Updated dependencies [3ded00b]
- Updated dependencies [1026d81]
- Updated dependencies [983a5e4]
- Updated dependencies [aee166c]
- Updated dependencies [aa39741]
- Updated dependencies [07b5439]
- Updated dependencies [513e0ad]
- Updated dependencies [ef49617]
- Updated dependencies [4a78aae]
  - @scalar/components@0.12.50
  - @scalar/types@0.0.12
  - @scalar/api-client@2.1.12
  - @scalar/themes@0.9.33
  - @scalar/openapi-parser@0.8.5
  - @scalar/oas-utils@0.2.51
  - @scalar/code-highlight@0.0.11

## 1.25.25

### Patch Changes

- Updated dependencies [9b010e6]
- Updated dependencies [d8baf4e]
- Updated dependencies [8554e60]
- Updated dependencies [d8baf4e]
- Updated dependencies [b4d1e1b]
- Updated dependencies [9057781]
- Updated dependencies [d9ff13e]
  - @scalar/api-client@2.1.11
  - @scalar/components@0.12.49
  - @scalar/oas-utils@0.2.50

## 1.25.24

### Patch Changes

- Updated dependencies [3647181]
- Updated dependencies [e22c6ce]
  - @scalar/api-client@2.1.10

## 1.25.23

### Patch Changes

- e4b326e: feat: support for multiple examples in schemas
- 963b9cd: fix: removed global listeners to prevent random jumping bug
- cd8ba1c: feat: added setting of initial security schemes in the client
- e4b326e: fix(api-reference): show examples in models section
- Updated dependencies [963b9cd]
- Updated dependencies [cd8ba1c]
- Updated dependencies [8b6633d]
- Updated dependencies [fb0d9a3]
  - @scalar/api-client@2.1.9
  - @scalar/oas-utils@0.2.49

## 1.25.22

### Patch Changes

- Updated dependencies [f961940]
- Updated dependencies [f961940]
- Updated dependencies [dc20180]
- Updated dependencies [70857ed]
  - @scalar/types@0.0.11
  - @scalar/themes@0.9.32
  - @scalar/api-client@2.1.8
  - @scalar/components@0.12.48
  - @scalar/oas-utils@0.2.48
  - @scalar/code-highlight@0.0.11

## 1.25.21

### Patch Changes

- ba40c63: fix: css missing comma

## 1.25.20

## 1.25.19

### Patch Changes

- Updated dependencies [96c921c]
  - @scalar/openapi-parser@0.8.4
  - @scalar/api-client@2.1.7
  - @scalar/oas-utils@0.2.47

## 1.25.18

### Patch Changes

- fdecdb4: fix: search results scroll to wrong position
- Updated dependencies [ca00556]
- Updated dependencies [2b8ce6c]
- Updated dependencies [3c098f9]
- Updated dependencies [9aa4562]
- Updated dependencies [7beeef3]
- Updated dependencies [d22523e]
- Updated dependencies [40850bb]
- Updated dependencies [c92cfa0]
- Updated dependencies [cdb8f55]
  - @scalar/api-client@2.1.6
  - @scalar/oas-utils@0.2.47
  - @scalar/components@0.12.47
  - @scalar/themes@0.9.31
  - @scalar/code-highlight@0.0.11
  - @scalar/types@0.0.10

## 1.25.17

### Patch Changes

- Updated dependencies [2b75354]
- Updated dependencies [437d54d]
  - @scalar/oas-utils@0.2.46
  - @scalar/api-client@2.1.5

## 1.25.16

### Patch Changes

- Updated dependencies [b856652]
- Updated dependencies [2bab01a]
  - @scalar/api-client@2.1.4
  - @scalar/components@0.12.46

## 1.25.15

### Patch Changes

- c1d39c5: fix: remove trailing slash in examples and in client for server
- Updated dependencies [ddeaada]
- Updated dependencies [c1d39c5]
- Updated dependencies [71278e1]
  - @scalar/api-client@2.1.3
  - @scalar/oas-utils@0.2.45

## 1.25.14

### Patch Changes

- Updated dependencies [feb6960]
  - @scalar/api-client@2.1.2

## 1.25.13

### Patch Changes

- 9486091: fix: respect the proxy url config
- Updated dependencies [9351a90]
- Updated dependencies [9486091]
  - @scalar/api-client@2.1.1

## 1.25.12

### Patch Changes

- 099233d: fix: request example code works for some examples only
- 9d88423: feat: added one way auth sync from references to client
- e15b021: feat: render deeply nested schemas, but not circular references
- Updated dependencies [b8fdc19]
- Updated dependencies [18c58af]
- Updated dependencies [dd06d00]
- Updated dependencies [7e5dfbb]
- Updated dependencies [641c1ec]
- Updated dependencies [b8fdc19]
- Updated dependencies [9d88423]
- Updated dependencies [88a4ec3]
- Updated dependencies [674922f]
- Updated dependencies [86e1f46]
- Updated dependencies [44f3300]
- Updated dependencies [7df5770]
- Updated dependencies [a08aa37]
- Updated dependencies [e15b021]
- Updated dependencies [9269f5a]
- Updated dependencies [73f728e]
- Updated dependencies [ee22a82]
- Updated dependencies [b8fdc19]
- Updated dependencies [a002783]
- Updated dependencies [9cd23e3]
- Updated dependencies [c030024]
- Updated dependencies [6fd83dc]
- Updated dependencies [121bc7e]
  - @scalar/api-client@2.1.0
  - @scalar/oas-utils@0.2.44
  - @scalar/openapi-parser@0.8.3
  - @scalar/components@0.12.45
  - @scalar/themes@0.9.30
  - @scalar/code-highlight@0.0.11
  - @scalar/types@0.0.9

## 1.25.11

### Patch Changes

- e6cc267: fix: server description color style
- 0fc3460: fix(api-reference): only clamp endpoint descriptions
- dc9aff2: refactor: move `ExampleResponses` component to the features folder
- Updated dependencies [0fc3460]
- Updated dependencies [c577cde]
- Updated dependencies [e9253af]
- Updated dependencies [dc9aff2]
- Updated dependencies [5c16ded]
- Updated dependencies [6bb85a5]
- Updated dependencies [dc9aff2]
  - @scalar/components@0.12.44
  - @scalar/themes@0.9.29
  - @scalar/api-client@2.0.64
  - @scalar/openapi-types@0.1.1
  - @scalar/snippetz@0.2.3
  - @scalar/openapi-parser@0.8.2
  - @scalar/types@0.0.8
  - @scalar/code-highlight@0.0.11
  - @scalar/oas-utils@0.2.43

## 1.25.10

### Patch Changes

- f8920be: fix: hide test icon in operation accordion
- a07cfc8: feat: allow to hide the Test Request button
- 1e41dfe: fix: adds endpoints description collapse state
- 7d988b6: fix: anchor models and webhooks offset
- 023ca15: feat: adds favicon configuration
- 85872b6: feat: allow to hide search sidebar
- ad89ca3: fix: autprefixer warnings
- Updated dependencies [a07cfc8]
- Updated dependencies [5483fc3]
- Updated dependencies [1e41dfe]
- Updated dependencies [023ca15]
- Updated dependencies [85872b6]
- Updated dependencies [ad89ca3]
  - @scalar/types@0.0.7
  - @scalar/oas-utils@0.2.42
  - @scalar/components@0.12.43
  - @scalar/use-toasts@0.7.6
  - @scalar/api-client@2.0.63

## 1.25.9

### Patch Changes

- f931ac7: fix: displays variable in curly braces when empty
- ae421ea: feat: add ExampleRequest embed
- 8ac7d00: style: no italic for the path variable
- Updated dependencies [5bd8337]
- Updated dependencies [f931ac7]
- Updated dependencies [48d7ad5]
  - @scalar/openapi-parser@0.8.1
  - @scalar/oas-utils@0.2.41
  - @scalar/snippetz@0.2.2
  - @scalar/api-client@2.0.62

## 1.25.8

### Patch Changes

- 7595fc5: chore: migrate @scalar/snippetz to scalar/scalar
- 18744d4: feat(api-reference): lazy loading collapsible webhooks
- e67f5a8: chore(api-client): removed axios dependency
- 725dfa0: feat: download from OpenAPI document URL (if available)
- fdd6d16: fix: authentication form submits on enter
- Updated dependencies [b4f9f97]
- Updated dependencies [7595fc5]
- Updated dependencies [0afb293]
- Updated dependencies [4b52f29]
- Updated dependencies [294ba08]
- Updated dependencies [b4f9f97]
- Updated dependencies [18744d4]
- Updated dependencies [e67f5a8]
- Updated dependencies [b4f9f97]
- Updated dependencies [044fd7d]
- Updated dependencies [b4f9f97]
- Updated dependencies [b63be39]
- Updated dependencies [b231e7d]
- Updated dependencies [152c016]
- Updated dependencies [b4f9f97]
  - @scalar/openapi-parser@0.8.0
  - @scalar/snippetz@0.2.1
  - @scalar/oas-utils@0.2.40
  - @scalar/api-client@2.0.61
  - @scalar/code-highlight@0.0.11
  - @scalar/openapi-types@0.1.0
  - @scalar/components@0.12.42
  - @scalar/types@0.0.6

## 1.25.7

### Patch Changes

- f8f8787: style(api-reference): search modal deprecated endpoint
- Updated dependencies [9e8d40d]
- Updated dependencies [80a3c46]
- Updated dependencies [c02202c]
- Updated dependencies [c02202c]
  - @scalar/components@0.12.41
  - @scalar/themes@0.9.28
  - @scalar/api-client@2.0.60
  - @scalar/code-highlight@0.0.10
  - @scalar/oas-utils@0.2.39
  - @scalar/types@0.0.5

## 1.25.6

### Patch Changes

- 5138b03: feat(api-reference): collapse models by default
- Updated dependencies [bbe5b49]
- Updated dependencies [bbe5b49]
  - @scalar/api-client@2.0.59
  - @scalar/components@0.12.40

## 1.25.5

### Patch Changes

- Updated dependencies [1c3de0e]
- Updated dependencies [857380d]
- Updated dependencies [ab8c4d7]
- Updated dependencies [9bc0ae7]
- Updated dependencies [a792002]
- Updated dependencies [8d615dc]
- Updated dependencies [bb13304]
- Updated dependencies [9bc0ae7]
- Updated dependencies [8f24069]
  - @scalar/api-client@2.0.58
  - @scalar/components@0.12.39
  - @scalar/themes@0.9.27
  - @scalar/code-highlight@0.0.10
  - @scalar/oas-utils@0.2.38
  - @scalar/types@0.0.4

## 1.25.4

### Patch Changes

- abb8ddd: fix(themes): always show obtrusive scrollbars
- Updated dependencies [6babe66]
- Updated dependencies [abb8ddd]
  - @scalar/api-client@2.0.57
  - @scalar/components@0.12.38
  - @scalar/themes@0.9.26
  - @scalar/code-highlight@0.0.10
  - @scalar/oas-utils@0.2.37
  - @scalar/types@0.0.3

## 1.25.3

### Patch Changes

- Updated dependencies [af75550]
- Updated dependencies [f9c88a9]
- Updated dependencies [5de17ce]
- Updated dependencies [f3b9adf]
- Updated dependencies [af75550]
  - @scalar/api-client@2.0.56
  - @scalar/oas-utils@0.2.36
  - @scalar/components@0.12.37

## 1.25.2

### Patch Changes

- Updated dependencies [8bde837]
- Updated dependencies [910b1c2]
  - @scalar/components@0.12.36
  - @scalar/types@0.0.2
  - @scalar/api-client@2.0.55
  - @scalar/oas-utils@0.2.35

## 1.25.1

### Patch Changes

- Updated dependencies [7aa26fb]
- Updated dependencies [2db9eb8]
  - @scalar/components@0.12.35
  - @scalar/api-client@2.0.54

## 1.25.0

### Minor Changes

- 78db8f5: feat: move some of the types to the new @scalar/types package

### Patch Changes

- Updated dependencies [78db8f5]
- Updated dependencies [7f11bc6]
  - @scalar/api-client@2.0.53
  - @scalar/components@0.12.34
  - @scalar/oas-utils@0.2.34
  - @scalar/themes@0.9.25
  - @scalar/types@0.0.1
  - @scalar/code-highlight@0.0.10

## 1.24.77

### Patch Changes

- Updated dependencies [298f7c4]
- Updated dependencies [cff5b1f]
- Updated dependencies [7bfee42]
  - @scalar/themes@0.9.24
  - @scalar/api-client@2.0.52
  - @scalar/components@0.12.33
  - @scalar/code-highlight@0.0.10
  - @scalar/oas-utils@0.2.33

## 1.24.76

### Patch Changes

- 48693d7: fix(components): rebuild code block x-y scroll box
- a9f3005: fix(api-reference): scrolling to markdown links
- Updated dependencies [f2b4b3f]
- Updated dependencies [c386d64]
- Updated dependencies [48693d7]
- Updated dependencies [5c877b8]
- Updated dependencies [1c81549]
  - @scalar/api-client@2.0.51
  - @scalar/components@0.12.32
  - @scalar/oas-utils@0.2.32

## 1.24.75

### Patch Changes

- c220358: feat: add response schemas
- ee0c360: fix: add more contrasting background to unopened tags
- Updated dependencies [c220358]
- Updated dependencies [7ec175b]
  - @scalar/oas-utils@0.2.31
  - @scalar/api-client@2.0.50

## 1.24.74

### Patch Changes

- 476f3e7: fix: initial dark mode state bug and add configuration for darkmode
- c450bb3: fix: scalar api ref use scalar-border-width
- 8411bb1: style(api-reference): deprecated http endpoint section list
- Updated dependencies [56be4fe]
- Updated dependencies [c450bb3]
- Updated dependencies [75a5a64]
  - @scalar/api-client@2.0.49
  - @scalar/code-highlight@0.0.10
  - @scalar/themes@0.9.23
  - @scalar/components@0.12.31
  - @scalar/oas-utils@0.2.30

## 1.24.73

### Patch Changes

- 58e5912: fix: markdown fixes and intro card polish
- Updated dependencies [db96313]
- Updated dependencies [de9747c]
- Updated dependencies [8672a78]
- Updated dependencies [58e5912]
- Updated dependencies [6f7ab8d]
- Updated dependencies [db96313]
- Updated dependencies [89ee9da]
- Updated dependencies [078ca72]
- Updated dependencies [6f107e1]
- Updated dependencies [520caff]
- Updated dependencies [03e9bbb]
- Updated dependencies [db96313]
  - @scalar/api-client@2.0.48
  - @scalar/oas-utils@0.2.29
  - @scalar/code-highlight@0.0.9
  - @scalar/components@0.12.30

## 1.24.72

### Patch Changes

- 55a3265: style(api-references): cleanup operation font sizes and alignment
- Updated dependencies [b00e50e]
- Updated dependencies [df7372f]
- Updated dependencies [60e63d3]
- Updated dependencies [6f0632e]
- Updated dependencies [db92a85]
- Updated dependencies [3023afe]
- Updated dependencies [711ad03]
- Updated dependencies [b910fc1]
- Updated dependencies [14ed31f]
- Updated dependencies [dba83e4]
  - @scalar/api-client@2.0.47
  - @scalar/themes@0.9.22
  - @scalar/use-toasts@0.7.5
  - @scalar/code-highlight@0.0.8
  - @scalar/oas-utils@0.2.28
  - @scalar/components@0.12.29

## 1.24.71

### Patch Changes

- 2f6180a: fix: improve address bar styles
- 17e06de: fix: additionalProperties are not rendered correctly
- Updated dependencies [2f6180a]
- Updated dependencies [17e06de]
  - @scalar/api-client@2.0.46
  - @scalar/oas-utils@0.2.27

## 1.24.70

### Patch Changes

- 9df93c1: fix: webhooks anchor
- Updated dependencies [ee80ee5]
- Updated dependencies [f3fec79]
- Updated dependencies [2301345]
- Updated dependencies [57f5691]
- Updated dependencies [faf3ed9]
- Updated dependencies [a1c73a0]
  - @scalar/api-client@2.0.45
  - @scalar/themes@0.9.21
  - @scalar/components@0.12.28
  - @scalar/oas-utils@0.2.26

## 1.24.69

### Patch Changes

- 9cc6311: fix: add overload to servers as prop for create client app
- Updated dependencies [d65dbcb]
- Updated dependencies [9cc6311]
  - @scalar/api-client@2.0.44
  - @scalar/oas-utils@0.2.25

## 1.24.68

### Patch Changes

- Updated dependencies [425dc83]
- Updated dependencies [9afa9c5]
- Updated dependencies [13b2f6d]
- Updated dependencies [cd028bd]
- Updated dependencies [554df83]
  - @scalar/api-client@2.0.43
  - @scalar/themes@0.9.20
  - @scalar/components@0.12.28
  - @scalar/oas-utils@0.2.24

## 1.24.67

### Patch Changes

- Updated dependencies [8eec1b7]
- Updated dependencies [1062ceb]
  - @scalar/oas-utils@0.2.23
  - @scalar/api-client@2.0.42

## 1.24.66

### Patch Changes

- Updated dependencies [09d07d1]
  - @scalar/api-client@2.0.41
  - @scalar/components@0.12.27

## 1.24.65

### Patch Changes

- Updated dependencies [3a6effa]
- Updated dependencies [dfa7434]
  - @scalar/api-client@2.0.40
  - @scalar/components@0.12.26
  - @scalar/themes@0.9.19
  - @scalar/oas-utils@0.2.22

## 1.24.64

### Patch Changes

- Updated dependencies [016ff7d]
- Updated dependencies [e8cf2f5]
- Updated dependencies [c1ada84]
- Updated dependencies [3031929]
- Updated dependencies [c1ada84]
- Updated dependencies [e18029f]
- Updated dependencies [808eafb]
- Updated dependencies [7853b8d]
  - @scalar/api-client@2.0.39
  - @scalar/components@0.12.25
  - @scalar/themes@0.9.18
  - @scalar/oas-utils@0.2.21

## 1.24.63

### Patch Changes

- Updated dependencies [de25d01]
  - @scalar/api-client@2.0.38
  - @scalar/components@0.12.24
  - @scalar/themes@0.9.17
  - @scalar/oas-utils@0.2.20

## 1.24.62

### Patch Changes

- Updated dependencies [b21b419]
- Updated dependencies [7b58f10]
- Updated dependencies [3d9e948]
  - @scalar/api-client@2.0.37
  - @scalar/components@0.12.23

## 1.24.61

### Patch Changes

- Updated dependencies [276e506]
  - @scalar/api-client@2.0.36

## 1.24.60

### Patch Changes

- Updated dependencies [bf2895e]
- Updated dependencies [5d2825a]
  - @scalar/api-client@2.0.35
  - @scalar/components@0.12.22
  - @scalar/oas-utils@0.2.19

## 1.24.59

### Patch Changes

- Updated dependencies [c0cf4ac]
- Updated dependencies [225e32a]
- Updated dependencies [bb5909f]
- Updated dependencies [9815191]
- Updated dependencies [e8fa353]
- Updated dependencies [a7ea3e3]
- Updated dependencies [869d255]
- Updated dependencies [9243580]
- Updated dependencies [12bd5b8]
  - @scalar/api-client@2.0.34
  - @scalar/oas-utils@0.2.18
  - @scalar/components@0.12.21

## 1.24.58

### Patch Changes

- 81b330e: feat: limit search results to 25, improve search modal performance
- 201b661: feat: log some performance metrics
- 0bea5b6: fix: window.matchMedia is not a function
- Updated dependencies [ce3f630]
- Updated dependencies [b2a662a]
- Updated dependencies [86014b5]
- Updated dependencies [d88c403]
- Updated dependencies [a60c916]
- Updated dependencies [0bea5b6]
- Updated dependencies [2c61c21]
- Updated dependencies [19a50de]
  - @scalar/api-client@2.0.33
  - @scalar/components@0.12.20

## 1.24.57

### Patch Changes

- Updated dependencies [6123165]
  - @scalar/api-client@2.0.32

## 1.24.56

### Patch Changes

- 240a618: feat: allow multiple api-clients on single page
- Updated dependencies [240a618]
  - @scalar/api-client@2.0.31

## 1.24.55

### Patch Changes

- 05c1360: fix(api-reference): allow scrolling to collapsed sections via hash
- Updated dependencies [a5f3a84]
- Updated dependencies [b4199e9]
- Updated dependencies [9a08f46]
  - @scalar/components@0.12.19
  - @scalar/themes@0.9.16
  - @scalar/api-client@2.0.30
  - @scalar/oas-utils@0.2.17

## 1.24.54

### Patch Changes

- Updated dependencies [d5408e8]
  - @scalar/api-client@2.0.29

## 1.24.53

### Patch Changes

- Updated dependencies [23d498b]
- Updated dependencies [624696e]
- Updated dependencies [41341e9]
- Updated dependencies [5402338]
- Updated dependencies [33f5a09]
- Updated dependencies [9f4db12]
- Updated dependencies [aee3783]
- Updated dependencies [9ca5d7d]
- Updated dependencies [d97bffd]
  - @scalar/api-client@2.0.28

## 1.24.52

### Patch Changes

- 5ebcee3: chore(api-references): use thickness instead of css overrides
- Updated dependencies [19d8b6a]
- Updated dependencies [c112f24]
- Updated dependencies [83fc241]
- Updated dependencies [2e1ef12]
  - @scalar/api-client@2.0.27
  - @scalar/components@0.12.18

## 1.24.51

### Patch Changes

- 401446c: fix: docusaurus missing variables + icon uniformity
- Updated dependencies [54f7654]
- Updated dependencies [67aefbf]
- Updated dependencies [b0b3290]
- Updated dependencies [7e01b12]
- Updated dependencies [7761630]
- Updated dependencies [b7211fb]
  - @scalar/api-client@2.0.26
  - @scalar/components@0.12.17
  - @scalar/oas-utils@0.2.16

## 1.24.50

### Patch Changes

- Updated dependencies [591fe24]
- Updated dependencies [7f17fe4]
- Updated dependencies [1dab515]
- Updated dependencies [4d76ff5]
- Updated dependencies [e8cd161]
- Updated dependencies [a431eb0]
- Updated dependencies [5e060b1]
- Updated dependencies [ff59399]
- Updated dependencies [ec47287]
- Updated dependencies [747e80e]
- Updated dependencies [9d561b7]
  - @scalar/api-client@2.0.25
  - @scalar/oas-utils@0.2.15
  - @scalar/themes@0.9.15
  - @scalar/components@0.12.16
  - @scalar/use-toasts@0.7.4
  - @scalar/use-tooltip@1.0.2

## 1.24.49

### Patch Changes

- d894fb7: feat: configure the `defaultHttpClient`
- cf92fab: fix: set background color on body

## 1.24.48

### Patch Changes

- 7076725: feat(components): add outline icons
- Updated dependencies [7076725]
- Updated dependencies [1e72b03]
- Updated dependencies [dd2a42e]
- Updated dependencies [cbe984b]
  - @scalar/api-client@2.0.24
  - @scalar/components@0.12.15

## 1.24.47

### Patch Changes

- c144aea: feat: hide schemas with `x-internal: true`
- 5271732: feat: new `tagsSorter` option
- af5b342: chore: rename Webhook to Webhooks
- Updated dependencies [3928ac3]
- Updated dependencies [96e7106]
  - @scalar/api-client@2.0.23
  - @scalar/themes@0.9.14
  - @scalar/components@0.12.14
  - @scalar/oas-utils@0.2.14

## 1.24.46

### Patch Changes

- Updated dependencies [45b956f]
  - @scalar/api-client@2.0.22

## 1.24.45

### Patch Changes

- Updated dependencies [d48e4ac]
  - @scalar/api-client@2.0.21

## 1.24.44

### Patch Changes

- Updated dependencies [e1aa4fc]
  - @scalar/components@0.12.14
  - @scalar/api-client@2.0.20

## 1.24.43

### Patch Changes

- 3f579d8: feat: add defaultOpenAllTags configuration option
- Updated dependencies [a0bb23a]
  - @scalar/api-client@2.0.19

## 1.24.42

### Patch Changes

- 274af41: fix: make default tag check computed for reactivity bugs
- Updated dependencies [8654323]
  - @scalar/api-client@2.0.18

## 1.24.41

### Patch Changes

- Updated dependencies [91b97fa]
- Updated dependencies [05bc858]
- Updated dependencies [05bc858]
  - @scalar/api-client@2.0.17

## 1.24.40

### Patch Changes

- e285a6b: fix: scalar code block copy
- 4023d52: fix: response example duplication
- 2f10a39: fix: dark mode icon
- c2ac68a: fix: long base url
- fc096b6: refactor!: rename `createScalarApiClient` to `createApiClientModal`
- 1961751: fix: update classic theme section accordian icons
- Updated dependencies [a5b295c]
- Updated dependencies [e285a6b]
- Updated dependencies [bff602a]
- Updated dependencies [6f4d20d]
- Updated dependencies [1ba4267]
- Updated dependencies [2f10a39]
- Updated dependencies [58da2c6]
- Updated dependencies [2f10a39]
- Updated dependencies [9e3348a]
- Updated dependencies [fe16789]
- Updated dependencies [fc096b6]
- Updated dependencies [ebdc9cf]
  - @scalar/api-client@2.0.16
  - @scalar/components@0.12.13

## 1.24.39

### Patch Changes

- 0ac627d: fix: no rendering of fonts
- 9840fdd: fix: vertical align server url

## 1.24.38

### Patch Changes

- Updated dependencies [f86a242]
- Updated dependencies [f86a242]
  - @scalar/api-client@2.0.15
  - @scalar/components@0.12.12

## 1.24.37

### Patch Changes

- e649da6: feat: set copy clipboard in scalar codeblock
- Updated dependencies [e649da6]
- Updated dependencies [6b32eee]
- Updated dependencies [1a675be]
- Updated dependencies [a1d59de]
- Updated dependencies [a1d59de]
  - @scalar/components@0.12.11
  - @scalar/api-client@2.0.14
  - @scalar/oas-utils@0.2.13

## 1.24.36

### Patch Changes

- Updated dependencies [618285e]
  - @scalar/api-client@2.0.13
  - @scalar/oas-utils@0.2.12
  - @scalar/themes@0.9.13
  - @scalar/components@0.12.10

## 1.24.35

### Patch Changes

- 0a33194: fix: flatten default array value
- Updated dependencies [0a33194]
  - @scalar/api-client@2.0.12

## 1.24.34

### Patch Changes

- Updated dependencies [e8a7f82]
- Updated dependencies [c16413d]
- Updated dependencies [b9a7a4e]
  - @scalar/api-client@2.0.11
  - @scalar/components@0.12.10
  - @scalar/oas-utils@0.2.11
  - @scalar/themes@0.9.12
  - @scalar/use-toasts@0.7.4
  - @scalar/use-tooltip@1.0.2

## 1.24.33

### Patch Changes

- Updated dependencies [b65d1fa]
- Updated dependencies [b655c7a]
  - @scalar/api-client@2.0.10

## 1.24.32

### Patch Changes

- Updated dependencies [ad7fd7e]
- Updated dependencies [1bb94c7]
- Updated dependencies [f1b5390]
- Updated dependencies [ad7fd7e]
  - @scalar/oas-utils@0.2.11
  - @scalar/api-client@2.0.9
  - @scalar/components@0.12.10
  - @scalar/themes@0.9.12

## 1.24.31

### Patch Changes

- 7662097: fix: create payload for non-Nuxt SSG
- f8982ed: feat: show custom examples along the generated examples
- Updated dependencies [ba3f5cb]
- Updated dependencies [d58841b]
- Updated dependencies [0b6e3aa]
- Updated dependencies [d58841b]
- Updated dependencies [d58841b]
  - @scalar/api-client@2.0.8
  - @scalar/oas-utils@0.2.10
  - @scalar/components@0.12.9

## 1.24.30

### Patch Changes

- b4d6d4a: fix: accessing window durring SSG when generating links
- Updated dependencies [f2e3b0e]
- Updated dependencies [4250fe2]
  - @scalar/api-client@2.0.7
  - @scalar/themes@0.9.11
  - @scalar/components@0.12.8

## 1.24.29

### Patch Changes

- ebf1ee9: fix: removed api-reference forced reliance on Style tag injection to fix nuxt/SSR
- 613def2: fix(#2352): move css imports into style tag
- Updated dependencies [d6a2a4d]
- Updated dependencies [4385ae2]
- Updated dependencies [632d6f7]
- Updated dependencies [a5aedf5]
- Updated dependencies [a5aedf5]
- Updated dependencies [d6a2a4d]
- Updated dependencies [cd5d1a4]
  - @scalar/oas-utils@0.2.9
  - @scalar/api-client@2.0.6
  - @scalar/components@0.12.8

## 1.24.28

### Patch Changes

- Updated dependencies [6709507]
- Updated dependencies [8f06fcd]
- Updated dependencies [8f06fcd]
- Updated dependencies [cdfb8c5]
  - @scalar/api-client@2.0.5
  - @scalar/themes@0.9.10
  - @scalar/components@0.12.7

## 1.24.27

### Patch Changes

- Updated dependencies [a01df62]
  - @scalar/oas-utils@0.2.8
  - @scalar/api-client@2.0.4

## 1.24.26

### Patch Changes

- Updated dependencies [9f208d5]
  - @scalar/api-client@2.0.3

## 1.24.25

### Patch Changes

- 429e928: feat: watch spec and update
- Updated dependencies [209a7e1]
- Updated dependencies [429e928]
- Updated dependencies [3ba80b9]
  - @scalar/api-client@2.0.2

## 1.24.24

### Patch Changes

- bbbabe6: fix: server description padding
- Updated dependencies [ec52346]
- Updated dependencies [ded1303]
- Updated dependencies [6aae9fe]
- Updated dependencies [14e71cd]
  - @scalar/api-client@2.0.1
  - @scalar/components@0.12.7
  - @scalar/oas-utils@0.2.7
  - @scalar/themes@0.9.9
  - @scalar/use-toasts@0.7.4
  - @scalar/use-tooltip@1.0.2

## 1.24.23

### Patch Changes

- b87617c: fix: configured servers list is ignored
- 975e555: fix: api reference sidebar method font weight
- 646dab2: chore: don’t expose useApiClientStore anymore
- 7f4d22e: refactor: new redirectToProxy helper
- a32f137: refactor: add HttpMethod component
- Updated dependencies [bd67d8f]
- Updated dependencies [7f4d22e]
  - @scalar/api-client@2.0.0
  - @scalar/oas-utils@0.2.7

## 1.24.22

### Patch Changes

- Updated dependencies [c533665]
- Updated dependencies [3b83b82]
  - @scalar/components@0.12.6
  - @scalar/client-app@0.1.16
  - @scalar/themes@0.9.9
  - @scalar/api-client@1.3.21

## 1.24.21

### Patch Changes

- cefe804: refactor: server feature
- 4861362: chore: merge modal package into client-app
- cefe804: style: use @scalar/components dropdown for the base url
- 4126c40: style: no dropdown for a single server
- Updated dependencies [e1af8ed]
- Updated dependencies [fec6f8e]
- Updated dependencies [cefe804]
- Updated dependencies [4861362]
- Updated dependencies [cefe804]
- Updated dependencies [fec6f8e]
- Updated dependencies [de13666]
- Updated dependencies [d0aec62]
- Updated dependencies [2c0bd57]
  - @scalar/use-tooltip@1.0.2
  - @scalar/client-app@0.1.15
  - @scalar/api-client@1.3.20
  - @scalar/components@0.12.5
  - @scalar/oas-utils@0.2.6

## 1.24.20

### Patch Changes

- 94e68ab: chore: upgrade typescript to 5.5
- Updated dependencies [a298195]
- Updated dependencies [326bd3d]
- Updated dependencies [94e68ab]
  - @scalar/oas-utils@0.2.5
  - @scalar/api-client@1.3.19
  - @scalar/components@0.12.4
  - @scalar/api-client-modal@0.0.16
  - @scalar/themes@0.9.8
  - @scalar/use-toasts@0.7.4
  - @scalar/use-tooltip@1.0.1

## 1.24.19

### Patch Changes

- b981770: chore: introduce the new @scalar/api-reference-editor
- 89afbcf: fix: extract server variable inputs into components
- 06471ed: fix: display enum select in api reference
- 06471ed: fix: api reference server variables style
- Updated dependencies [132acd4]
- Updated dependencies [3b53db5]
- Updated dependencies [b981770]
- Updated dependencies [06471ed]
- Updated dependencies [fd18932]
- Updated dependencies [06471ed]
  - @scalar/components@0.12.3
  - @scalar/themes@0.9.7
  - @scalar/use-toasts@0.7.3
  - @scalar/api-client@1.3.18
  - @scalar/api-client-modal@0.0.15

## 1.24.18

### Patch Changes

- Updated dependencies [e88a2c2]
- Updated dependencies [65f7bf5]
  - @scalar/themes@0.9.6
  - @scalar/components@0.12.2
  - @scalar/api-client@1.3.17
  - @scalar/api-client-modal@0.0.14

## 1.24.17

### Patch Changes

- Updated dependencies [c20c7d0]
- Updated dependencies [c20c7d0]
  - @scalar/components@0.12.1
  - @scalar/oas-utils@0.2.4
  - @scalar/api-client@1.3.16
  - @scalar/api-client-modal@0.0.13

## 1.24.16

### Patch Changes

- 716811f: fix: HTML API does not work with YAML content inside script tag
- 5812c2f: feat: allow custom headers
- ee5fdee: fix: api reference allof items merge objects
- Updated dependencies [e4419ce]
- Updated dependencies [e5ac3e1]
- Updated dependencies [f2c1019]
- Updated dependencies [fd0c93d]
- Updated dependencies [7b87b8c]
- Updated dependencies [512c815]
  - @scalar/components@0.12.0
  - @scalar/use-tooltip@1.0.0
  - @scalar/api-client@1.3.15
  - @scalar/api-client-modal@0.0.12

## 1.24.15

### Patch Changes

- d7a011a: fix: configuration metaData isn’t used
- 40d7c3d: fix: remove layers in docusaurus and fix precedence issue

## 1.24.14

### Patch Changes

- fb9baa5: fix: doesn’t show webhooks when x-tagGroups is used
- Updated dependencies [b1fd179]
  - @scalar/api-client@1.3.14

## 1.24.13

### Patch Changes

- 5e92eab: feat(#doc-1996): themes css exports
- Updated dependencies [88ae0a5]
- Updated dependencies [5e92eab]
  - @scalar/api-client@1.3.13
  - @scalar/components@0.11.6
  - @scalar/themes@0.9.5
  - @scalar/api-client-modal@0.0.11

## 1.24.12

### Patch Changes

- bcbcfc5: fix: standalone always defaults to light mode

## 1.24.11

### Patch Changes

- f03b626: fix: disable new api client modal
- Updated dependencies [362d47a]
- Updated dependencies [2ca1af2]
- Updated dependencies [627e0e5]
  - @scalar/api-client@1.3.12
  - @scalar/oas-utils@0.2.3
  - @scalar/themes@0.9.4
  - @scalar/components@0.11.5
  - @scalar/api-client-modal@0.0.10

## 1.24.10

### Patch Changes

- d982f18: chore: enable minification
- Updated dependencies [3d6ca80]
- Updated dependencies [0fae180]
  - @scalar/components@0.11.4
  - @scalar/themes@0.9.3
  - @scalar/api-client@1.3.11
  - @scalar/api-client-modal@0.0.9

## 1.24.9

### Patch Changes

- Updated dependencies [db89d01]
  - @scalar/api-client@1.3.10

## 1.24.8

### Patch Changes

- Updated dependencies [7dbb241]
  - @scalar/components@0.11.3
  - @scalar/api-client@1.3.9
  - @scalar/api-client-modal@0.0.8

## 1.24.7

### Patch Changes

- 43f0d4b: fix: Remove terser for now standalone

## 1.24.6

### Patch Changes

- a2cb3c3: Migrate away from unintended peer dependencies
- Updated dependencies [a2cb3c3]
  - @scalar/api-client-modal@0.0.7
  - @scalar/use-tooltip@0.7.3
  - @scalar/api-client@1.3.8
  - @scalar/components@0.11.2
  - @scalar/use-toasts@0.7.2
  - @scalar/oas-utils@0.2.2
  - @scalar/themes@0.9.2

## 1.24.5

### Patch Changes

- ee584b9: feat: add base server override

## 1.24.4

### Patch Changes

- Updated dependencies [c65697c]
  - @scalar/use-tooltip@0.7.2
  - @scalar/api-client@1.3.7
  - @scalar/api-client-modal@0.0.6

## 1.24.3

### Patch Changes

- e0fc110: chore: patch bump all package
- f0acc89: chore: upgrade to new @scalar/openapi-parser version
- Updated dependencies [a9b2395]
- Updated dependencies [e0fc110]
- Updated dependencies [f0acc89]
  - @scalar/api-client-modal@0.0.5
  - @scalar/api-client@1.3.6
  - @scalar/components@0.11.1
  - @scalar/oas-utils@0.2.1
  - @scalar/themes@0.9.1
  - @scalar/use-toasts@0.7.1
  - @scalar/use-tooltip@0.7.1

## 1.24.0

### Minor Changes

- 7f8ef74: chore: remove aliasing

### Patch Changes

- 689677a: fix: auto importing css backup
- 326dcfb: chore: remove @scalar/use-modal package
- b4db5da: fix: different response examples for different status codes
- d54eb42: fix: pathRouting when only using a slash in references and nux
- 68eede9: fix: ensure there's no padding on the response tabs
- 96347a1: feat: use example values for path variables
- 8494349: Migrate to highlightjs based syntax highlighting
- b38c7ed: Update build configs to a standardized format
- 6fbb57e: feat: release all the packages
- 6d11a8a: fix: default example response is moved to the first position
- Updated dependencies [1de697b]
- Updated dependencies [190bcb6]
- Updated dependencies [7f8ef74]
- Updated dependencies [689677a]
- Updated dependencies [f82a767]
- Updated dependencies [326dcfb]
- Updated dependencies [96347a1]
- Updated dependencies [8494349]
- Updated dependencies [b38c7ed]
- Updated dependencies [6fbb57e]
- Updated dependencies [e63b12d]
- Updated dependencies [94084bf]
- Updated dependencies [c5760b9]
  - @scalar/api-client@2.0.0
  - @scalar/components@0.11.0
  - @scalar/use-tooltip@0.7.0
  - @scalar/use-toasts@0.7.0
  - @scalar/oas-utils@0.2.0
  - @scalar/themes@0.9.0
  - @scalar/api-client-modal@0.0.2

## 1.23.5

### Patch Changes

- Updated dependencies [55e01dd]
  - @scalar/themes@0.8.2
  - @scalar/api-client@1.3.4
  - @scalar/components@0.10.1

## 1.23.4

### Patch Changes

- Updated dependencies [db7864a]
  - @scalar/themes@0.8.1
  - @scalar/api-client@1.3.3
  - @scalar/components@0.10.1

## 1.23.3

### Patch Changes

- c951512: feat: omit empty and not required properties from the generated request body
- Updated dependencies [c951512]
- Updated dependencies [961690d]
  - @scalar/oas-utils@0.1.17
  - @scalar/components@0.10.1
  - @scalar/api-client@1.3.2

## 1.23.2

### Patch Changes

- 3619881: fix: remove console log in use nav state

## 1.23.1

### Patch Changes

- 7d21723: fix: sidebar webhooks state
- Updated dependencies [83bfad8]
- Updated dependencies [34eba38]
- Updated dependencies [843218d]
- Updated dependencies [195ca18]
  - @scalar/components@0.10.0
  - @scalar/api-client@1.3.1

## 1.23.0

### Minor Changes

- 7d3bc16: feat: css files must be explicitly imported, check the docs
- 7d3bc16: BREAKING CHANGE: css must now be explicitly imported, see docs for more details

### Patch Changes

- Updated dependencies [7d3bc16]
- Updated dependencies [7d3bc16]
- Updated dependencies [a839889]
  - @scalar/api-client@1.3.0
  - @scalar/components@0.9.0
  - @scalar/themes@0.8.0

## 1.22.56

### Patch Changes

- 6c870da: fix: style x-enums

## 1.22.55

### Patch Changes

- Updated dependencies [18ecd33]
- Updated dependencies [26e2392]
  - @scalar/components@0.8.0
  - @scalar/api-client@1.2.39

## 1.22.54

### Patch Changes

- cc5402c: feat: OpenAuth 2.0 password grant
- b3a46c7: fix: http client library default value ignores `hiddenClients` configuration
- Updated dependencies [cc5402c]
- Updated dependencies [cc5402c]
  - @scalar/use-toasts@0.6.7
  - @scalar/api-client@1.2.38
  - @scalar/oas-utils@0.1.16
  - @scalar/components@0.7.15

## 1.22.53

### Patch Changes

- 5a9c298: feat: move references css config to css layer
- cad7eef: fix: small images destroy the layout
- Updated dependencies [d60cc10]
  - @scalar/api-client@1.2.37

## 1.22.52

### Patch Changes

- 4bc33db: feat: support for constants in schemas
- 30953fa: Add scalar galaxy yaml export and improve React reference reactivity
- Updated dependencies [da7cdb6]
  - @scalar/api-client@1.2.36

## 1.22.51

### Patch Changes

- 6ccdd5c: feat: support abbr html tag
- 4d01a2a: feat: copy server URL with replaced variables
- Updated dependencies [f472998]
  - @scalar/oas-utils@0.1.15
  - @scalar/api-client@1.2.35
  - @scalar/components@0.7.14

## 1.22.50

### Patch Changes

- Updated dependencies [be75488]
  - @scalar/api-client@1.2.34
  - @scalar/components@0.7.13

## 1.22.49

### Patch Changes

- Updated dependencies [cfba428]
  - @scalar/api-client@1.2.33

## 1.22.48

### Patch Changes

- 37471ee: fix: indentation bug on groups

## 1.22.47

### Patch Changes

- 4b78b40: fix: text transform folder as option + remove transforms from top level items
- 8865d12: fix: webhook operation parsing
- Updated dependencies [7205137]
- Updated dependencies [d369ac4]
- Updated dependencies [50480c7]
  - @scalar/oas-utils@0.1.14
  - @scalar/components@0.7.12
  - @scalar/api-client@1.2.32

## 1.22.46

### Patch Changes

- 594ac4e: fix: useReactiveSpec does not rewrite old proxy url

## 1.22.45

### Patch Changes

- 5aa656f: feat: [BREAKING CHANGE] use new HTTP proxy (https://github.com/scalar/scalar/pull/1703)
- Updated dependencies [5aa656f]
  - @scalar/api-client@1.2.31
  - @scalar/oas-utils@0.1.13
  - @scalar/components@0.7.11

## 1.22.44

### Patch Changes

- 496bca4: fix: api client selector responsive
- f677ff5: feat: favor uppercase css style for sidebar heading
- 28c8dc5: fix: server url with variable is overwritten with current url
- Updated dependencies [dfe51b1]
- Updated dependencies [504ff7a]
- Updated dependencies [61b8ddc]
- Updated dependencies [165b901]
- Updated dependencies [925572f]
  - @scalar/components@0.7.10
  - @scalar/api-client@1.2.30
  - @scalar/oas-utils@0.1.12

## 1.22.43

### Patch Changes

- Updated dependencies [69a617c]
  - @scalar/themes@0.7.11
  - @scalar/api-client@1.2.29
  - @scalar/components@0.7.9

## 1.22.42

### Patch Changes

- a1cbb21: fix: client selector style

## 1.22.41

### Patch Changes

- 1ce9661: feat: intro cards redesign
- Updated dependencies [1ce9661]
  - @scalar/api-client@1.2.28
  - @scalar/themes@0.7.10
  - @scalar/components@0.7.9

## 1.22.40

### Patch Changes

- Updated dependencies [7ba851f]
  - @scalar/api-client@1.2.27

## 1.22.39

### Patch Changes

- 1305f28: fix: client blur popup
- 4ba9fed: fix: blurry api client popup
- bf35da5: fix: x-displayName is not used in the tag component
- ab5d017: refactor: use lowlight instead of prism in the markdown component (rollback 64024a5)
- 484bd33: feat: show text/plain example responses, too
- bf35da5: fix: x-displayName is not used in the search modal

## 1.22.38

### Patch Changes

- 64cc35f: fix: x-displayName & x-tagGroups cancel eachother out

## 1.22.37

### Patch Changes

- e3a72bb: style: updated icon button size
- Updated dependencies [e3a72bb]
  - @scalar/components@0.7.9
  - @scalar/api-client@1.2.26

## 1.22.36

### Patch Changes

- 79e3caa: chore: replace petstore example with galaxy example
- 5d0e06c: fix: api client blur, modal size, client contrast with clickout area
- c6ee654: feat: hide operations with x-internal: true
- Updated dependencies [79e3caa]
- Updated dependencies [e022ee6]
  - @scalar/api-client@1.2.25
  - @scalar/components@0.7.8

## 1.22.35

### Patch Changes

- Updated dependencies [624604e]
- Updated dependencies [624604e]
  - @scalar/api-client@1.2.24
  - @scalar/oas-utils@0.1.11
  - @scalar/components@0.7.7

## 1.22.34

### Patch Changes

- 15625a2: feat: support <sub> tag in markdown

## 1.22.33

### Patch Changes

- Updated dependencies [3a4ff3c]
  - @scalar/api-client@1.2.23

## 1.22.32

### Patch Changes

- Updated dependencies [a13f853]
  - @scalar/api-client@1.2.22

## 1.22.31

### Patch Changes

- 3748dc5: feat: api client toggle sidebar hotkey
- Updated dependencies [f871c28]
- Updated dependencies [3748dc5]
  - @scalar/api-client@1.2.21

## 1.22.30

### Patch Changes

- 36819a2: chore: lazy load api client
- Updated dependencies [0640c52]
- Updated dependencies [6e67167]
- Updated dependencies [84399ab]
- Updated dependencies [a80345a]
  - @scalar/api-client@1.2.20
  - @scalar/components@0.7.6

## 1.22.29

### Patch Changes

- Updated dependencies [fa2cc5b]
- Updated dependencies [836869b]
  - @scalar/api-client@1.2.19
  - @scalar/components@0.7.5

## 1.22.28

### Patch Changes

- 192f348: feat: ship test button

## 1.22.27

### Patch Changes

- ce44360: fix: support markdown <sup> tag
- 7622134: fix: uppercase required property

## 1.22.26

### Patch Changes

- 26d9146: feat: improved api client modal
- Updated dependencies [26d9146]
- Updated dependencies [670156e]
  - @scalar/api-client@1.2.18
  - @scalar/components@0.7.4
  - @scalar/use-toasts@0.6.6

## 1.22.25

### Patch Changes

- 5b24896: fix: sidebar doesn’t react to changes
- 64024a5: refactor: use prismjs instead of highlightjs in the markdown component
- 36e1e66: feat: include spec title in downloaded spec filename
- 2e7b074: feat: clean up toast styles and colors
- 298735f: fix: hide default caret on <summary> on Safari
- Updated dependencies [d649691]
- Updated dependencies [2e7b074]
  - @scalar/api-client@1.2.17
  - @scalar/use-toasts@0.6.5

## 1.22.24

### Patch Changes

- 9ba838b: chore: fetch scalar galaxy example from jsdelivr
- 45dc04b: fix: can’t release packages
- Updated dependencies [45dc04b]
  - @scalar/use-tooltip@0.6.2
  - @scalar/api-client@1.2.16
  - @scalar/components@0.7.3
  - @scalar/use-toasts@0.6.4
  - @scalar/oas-utils@0.1.10
  - @scalar/use-modal@0.3.3
  - @scalar/themes@0.7.9

## 1.22.23

### Patch Changes

- 05e2e27: chore: add provenance statement
- Updated dependencies [05e2e27]
  - @scalar/api-client@1.2.15
  - @scalar/components@0.7.2
  - @scalar/galaxy@0.1.1
  - @scalar/oas-utils@0.1.9
  - @scalar/themes@0.7.8
  - @scalar/use-modal@0.3.2
  - @scalar/use-toasts@0.6.3
  - @scalar/use-tooltip@0.6.1

## 1.22.22

### Patch Changes

- f1bf5bc: fix: sidebar headings don’t reset
- 085a0c2: fix: mimetypes with charsets and variants are ignored
- Updated dependencies [085a0c2]
- Updated dependencies [fa10d45]
  - @scalar/oas-utils@0.1.8
  - @scalar/api-client@1.2.14
  - @scalar/components@0.7.1

## 1.22.21

### Patch Changes

- 07211ad: chore: added new lint rule for type importing for better perf
- 801ad65: feat: use schema property title if available
- d4fa19b: feat: allow multiple configs for nuxt
- b234d1d: feat: added two events to standalone references build with tests
- Updated dependencies [c68939c]
- Updated dependencies [07211ad]
- Updated dependencies [d4fa19b]
- Updated dependencies [1c18f77]
- Updated dependencies [830b3c8]
- Updated dependencies [b234d1d]
  - @scalar/api-client@1.2.13
  - @scalar/components@0.7.0
  - @scalar/oas-utils@0.1.7
  - @scalar/use-modal@0.3.1
  - @scalar/themes@0.7.7
  - @scalar/use-toasts@0.6.2

## 1.22.20

### Patch Changes

- a8c3045: build: re-introduce @scalar/use-toasts package
- 1324378: feat: show two levels of headings in the sidebar
- 9201802: chore: update example page title
- Updated dependencies [c6e4385]
- Updated dependencies [a8c3045]
  - @scalar/api-client@1.2.12
  - @scalar/use-toasts@0.6.1

## 1.22.19

### Patch Changes

- Updated dependencies [2706d57]
  - @scalar/components@0.6.1
  - @scalar/api-client@1.2.11

## 1.22.18

### Patch Changes

- 45dccb0: fix: avoid prepending path when running standalone from an html file without a server
- abff1f4: fix: swagger 2.0 definitions don’t show up in list of models

## 1.22.17

### Patch Changes

- b42479c: fix: unused empty tags break the sidebar
- 4c38ac1: fix: add label value in changeTheme event
- Updated dependencies [53ba90d]
  - @scalar/galaxy@0.1.0

## 1.22.16

### Patch Changes

- 7e1d318: fix: addtional properties duplicate description

## 1.22.15

### Patch Changes

- fc2c90f: feat: cleanup component library icons
- Updated dependencies [fc2c90f]
  - @scalar/components@0.6.0
  - @scalar/api-client@1.2.10

## 1.22.14

### Patch Changes

- b8e3f09: feat: add chevron for markdown summary
- Updated dependencies [0a77380]
  - @scalar/themes@0.7.6
  - @scalar/api-client@1.2.9
  - @scalar/components@0.5.5

## 1.22.13

### Patch Changes

- c05c90e: feat: add image support to tag, operation and webhook descriptions
- 2700c5c: feat: separate google fonts from theme, add withDefaultFonts setting
- Updated dependencies [2700c5c]
  - @scalar/components@0.5.5
  - @scalar/themes@0.7.5
  - @scalar/api-client@1.2.8

## 1.22.12

### Patch Changes

- 55398db: fix: summary markdown, add default browser styling
- Updated dependencies [79485ff]
- Updated dependencies [92b5b2a]
  - @scalar/components@0.5.4
  - @scalar/api-client@1.2.7

## 1.22.11

### Patch Changes

- b24b455: chore: beautiful license banner in the CDN version
- 43e1217: feat: new scalar galaxy example specification
- Updated dependencies [86d1363]
- Updated dependencies [bc3f3af]
  - @scalar/themes@0.7.4
  - @scalar/components@0.5.3
  - @scalar/api-client@1.2.6

## 1.22.10

### Patch Changes

- Updated dependencies [e8ef57e]
- Updated dependencies [1353154]
  - @scalar/components@0.5.2
  - @scalar/api-client@1.2.5

## 1.22.9

### Patch Changes

- 6f68b40: fix: allow nullable additional properties
- 4d31b19: refactor: move theme labels to @scalar/themes
- Updated dependencies [4d31b19]
  - @scalar/themes@0.7.3
  - @scalar/api-client@1.2.4
  - @scalar/components@0.5.1

## 1.22.8

### Patch Changes

- 24662c3: feat: rebuild search modal
- Updated dependencies [24662c3]
  - @scalar/components@0.5.1
  - @scalar/api-client@1.2.3

## 1.22.7

### Patch Changes

- c408cf5: style: getting started integrations + themes

## 1.22.6

### Patch Changes

- cf12a95: fix: sidebar models collapse
- 7b37c63: fix: start section theme name

## 1.22.5

### Patch Changes

- d03ab0f: feat: add better support for additional properties

## 1.22.4

### Patch Changes

- adc0693: feat: use http as default scheme for Swagger 2.0 specifications

## 1.22.3

### Patch Changes

- Updated dependencies [85a0074]
  - @scalar/themes@0.7.2
  - @scalar/api-client@1.2.2
  - @scalar/components@0.5.0

## 1.22.2

### Patch Changes

- Updated dependencies [d77acdd]
  - @scalar/api-client@1.2.1
  - @scalar/themes@0.7.1
  - @scalar/components@0.5.0

## 1.22.1

### Patch Changes

- 8dc1640: feat: moved toast component to client only

## 1.22.0

### Minor Changes

- 0e64a36: refactor: rename all --theme-_ variables to --scalar-_

### Patch Changes

- 22f2858: chore: ran syncpack to update packages
- ced76e5: fix: search key modifier incorrect on non macos machines
- 3afec45: feat: render images in tag descriptions
- Updated dependencies [22f2858]
- Updated dependencies [0e64a36]
  - @scalar/use-tooltip@0.6.0
  - @scalar/api-client@1.2.0
  - @scalar/components@0.5.0
  - @scalar/oas-utils@0.1.6
  - @scalar/use-modal@0.3.0
  - @scalar/themes@0.7.0

## 1.21.2

### Patch Changes

- 851017a: fix: give explicit URL to href in search modal

## 1.21.1

### Patch Changes

- b4abb34: fix: object description markdown

## 1.20.32

### Patch Changes

- 51d4997: fix: sidebar heading type remove hover color

## 1.20.31

### Patch Changes

- b903a2f: fix: intersection observer detection

## 1.20.30

### Patch Changes

- deabe4c: feat: made changes to support server side rendering
- 3ba9774: feat: add path routing option to references
- a14fc32: fix: hide mobile header when showSidebar: false
- 3d4d83e: fix: show example picker if the list only has one example
- Updated dependencies [e6d1b81]
- Updated dependencies [3ba9774]
- Updated dependencies [3ba9774]
  - @scalar/use-modal@0.2.10
  - @scalar/oas-utils@0.1.5
  - @scalar/components@0.4.11
  - @scalar/api-client@1.1.16

## 1.20.29

### Patch Changes

- Updated dependencies [24b3c2a]
  - @scalar/oas-utils@0.1.4
  - @scalar/api-client@1.1.15

## 1.20.28

### Patch Changes

- 622f31b: fix: endpoint navigation
- f2c2ce8: fix: decode uri component when setting hash values from url

## 1.20.27

### Patch Changes

- 605f522: feat: support tags with no operations

## 1.20.26

### Patch Changes

- 050410a: feat: add config to hide download button

## 1.20.25

### Patch Changes

- 1504d3b: feat: add config to hide models

## 1.20.24

### Patch Changes

- ab58747: fix: decrease border radius on code language background element

## 1.20.23

### Patch Changes

- Updated dependencies [95bac72]
  - @scalar/components@0.4.10
  - @scalar/api-client@1.1.14

## 1.20.22

### Patch Changes

- 4089634: feat: support x-displayName tag extension

## 1.20.21

### Patch Changes

- Updated dependencies [b0b757d]
  - @scalar/api-client@1.1.13

## 1.20.20

### Patch Changes

- Updated dependencies [c14568f]
  - @scalar/api-client@1.1.12
  - @scalar/components@0.4.9
  - @scalar/oas-utils@0.1.3

## 1.20.18

### Patch Changes

- c99f6ff: fix: create url for sidebar links using constructor

## 1.20.17

### Patch Changes

- 5b4c8a5: fix: left align read only

## 1.20.16

### Patch Changes

- 5232eab: fix: use function for displaying description in schema property component

## 1.20.15

### Patch Changes

- 8f03345: fix: update only the hash on scroll

## 1.20.14

### Patch Changes

- 78f2ab3: fix: set global security on sidebar navigation

## 1.20.13

### Patch Changes

- 8b0691b: feat: added future support for SSR server state hydration
- Updated dependencies [8b0691b]
  - @scalar/api-client@1.1.11
  - @scalar/oas-utils@0.1.2

## 1.20.12

### Patch Changes

- 999dfc9: chore: moved sidemenu control to css
- fd5c714: feat: add authentication UI to the API client
- 5c1b385: fix: improper variables name + remove importants
- 5f5395f: fix: toast notification doesn't show up
- Updated dependencies [999dfc9]
  - @scalar/api-client@1.1.10

## 1.20.11

### Patch Changes

- d70bda7: fix: text decoration targetting in themes + unused css in themes
- Updated dependencies [d70bda7]
  - @scalar/themes@0.6.7
  - @scalar/api-client@1.1.9
  - @scalar/components@0.4.8

## 1.20.10

### Patch Changes

- ae193a8: feat: sidebar border indents + theme polish
- bec8e52: fix: add models to tag groups
- Updated dependencies [5b83e30]
- Updated dependencies [43421a6]
- Updated dependencies [ae193a8]
  - @scalar/themes@0.6.6
  - @scalar/api-client@1.1.8
  - @scalar/components@0.4.8

## 1.20.9

### Patch Changes

- 5260d07: feat: description for any
- f861efa: chore: changed svg rendering strategy
- Updated dependencies [f861efa]
  - @scalar/components@0.4.7
  - @scalar/api-client@1.1.7

## 1.20.8

### Patch Changes

- Updated dependencies [7d0092e]
  - @scalar/components@0.4.6
  - @scalar/api-client@1.1.6

## 1.20.7

### Patch Changes

- 1e658b0: fix: rebuild schema property details to truncate long strings
- 06c57ca: fix: buffer not available in browser environments
- Updated dependencies [06c57ca]
  - @scalar/api-client@1.1.5

## 1.20.6

### Patch Changes

- Updated dependencies [42b385b]
  - @scalar/components@0.4.5
  - @scalar/api-client@1.1.4

## 1.20.5

### Patch Changes

- 0c5e22c: fix: section flare if position fixed
- Updated dependencies [0c5e22c]
  - @scalar/themes@0.6.5
  - @scalar/api-client@1.1.3
  - @scalar/components@0.4.4

## 1.20.4

### Patch Changes

- Updated dependencies [c7241e8]
  - @scalar/api-client@1.1.2

## 1.20.3

### Patch Changes

- 61a97e2: feat: make api client url editable
- Updated dependencies [61a97e2]
  - @scalar/api-client@1.1.1

## 1.20.2

### Patch Changes

- 9fe930c: fix: allow examples to be multiline

## 1.20.1

### Patch Changes

- 4b5a136: fix: move theme flare behind all content
- 1fb2eac: fix: use scroll margin instead of padding to align scroll headers
- 01476a9: feat: improve nullable types in schemas
- 083e0a1: style: improve text in markdown tables

## 1.20.0

### Minor Changes

- 31aae5e: chore: moved shared types and methods into oas-utils

### Patch Changes

- 6dc67c1: fix: example requestBody isn’t shown in the api client
- c4500f6: chore: remove @scalar/swagger-editor as a dependency
- 41f0d86: fix: example for object with anyOf, allOf, oneOf schemas doesn’t have a value
- Updated dependencies [31aae5e]
  - @scalar/api-client@1.1.0
  - @scalar/oas-utils@0.1.1

## 1.19.7

### Patch Changes

- 63deb4f: fix: enum under items is not being displayed

## 1.19.6

### Patch Changes

- e2491c1: chore: update axios
- Updated dependencies [e2491c1]
  - @scalar/api-client@1.0.3

## 1.19.5

### Patch Changes

- 00abdc5: chore: remove body margin reset everywhere, it’s not needed anymore
- e520363: feat: added oauth2 implicit login flow

## 1.19.4

### Patch Changes

- c987a90: fix: add min height to classic layout

## 1.19.3

### Patch Changes

- fc3f821: fix: example for array with anyOf, allOf, oneOf schemas doesn’t have a value
- 21195b7: fix: add back sidebar item hover color
- 68cda2b: feat: add x-tagGroups in sidebar
- Updated dependencies [68cda2b]
  - @scalar/themes@0.6.4
  - @scalar/api-client@1.0.2
  - @scalar/components@0.4.4
  - @scalar/swagger-editor@1.0.2

## 1.19.2

### Patch Changes

- Updated dependencies [bbbba1f]
- Updated dependencies [897990b]
  - @scalar/components@0.4.4
  - @scalar/themes@0.6.3
  - @scalar/api-client@1.0.1
  - @scalar/swagger-editor@1.0.1

## 1.19.1

### Patch Changes

- 148966b: fix: move errors into warning from new parser

## 1.19.0

### Minor Changes

- 7fb8273: Migrate to @scalar/openapi-parser

### Patch Changes

- 7b31aa3: fix: only remove margin from 1st paragraph
- 6036d25: fix: allow application/vnd.api+json return type
- 53eaa1e: Export getting started
- Updated dependencies [6036d25]
- Updated dependencies [7fb8273]
  - @scalar/api-client@1.0.0
  - @scalar/swagger-editor@1.0.0
  - @scalar/oas-utils@0.1.0

## 1.18.7

### Patch Changes

- cecf074: Migrate to oas utils for basic spec operations
- Updated dependencies [cecf074]
  - @scalar/swagger-parser@0.5.23
  - @scalar/api-client@0.12.18
  - @scalar/oas-utils@0.0.4

## 1.18.6

### Patch Changes

- c1410e7: fix: render missing schema properties (minimum, maximum and default values)

## 1.18.5

### Patch Changes

- 5cf4afa: style: replace resize observer with css container queries

## 1.18.4

### Patch Changes

- b0bd55d: fix: proxy error and side menu bug
- Updated dependencies [b0bd55d]
  - @scalar/swagger-parser@0.5.22

## 1.18.3

### Patch Changes

- 5ffe3b6: fix: duplicate border top
- bc9f965: fix: add deprecated path to classic layout

## 1.18.2

### Patch Changes

- ddc9b17: fix: re-added moving the components css into js so importing the css file is no longer needed
- 775646a: fix: removed extra copy of vue from themes and some dependencies
- ef3a015: chore: update to typescript 5.4
- Updated dependencies [ddc9b17]
- Updated dependencies [775646a]
- Updated dependencies [ef3a015]
  - @scalar/api-client@0.12.17
  - @scalar/components@0.4.3
  - @scalar/themes@0.6.2
  - @scalar/swagger-parser@0.5.21
  - @scalar/use-modal@0.2.9
  - @scalar/use-tooltip@0.5.12

## 1.18.1

### Patch Changes

- Updated dependencies [4ef178f]
  - @scalar/themes@0.6.1
  - @scalar/api-client@0.12.16
  - @scalar/components@0.4.2
  - @scalar/swagger-editor@0.11.1

## 1.18.0

### Minor Changes

- ad2b95a: fix: scope scrollbar styles
- ad2b95a: refactor: move reset component to themes package

### Patch Changes

- Updated dependencies [ad2b95a]
- Updated dependencies [ad2b95a]
  - @scalar/swagger-editor@0.11.0
  - @scalar/themes@0.6.0
  - @scalar/api-client@0.12.15
  - @scalar/components@0.4.2

## 1.17.16

### Patch Changes

- f39516c: chore: remove preparsed content
- 8b2558a: fix: custom operation security scheme is ignored
- ad80db9: fix: content not reactive
- 2e9218f: fix: deprecated operations are not striked through in the sidebar

## 1.17.15

### Patch Changes

- 3b672cc: fix: revert css changes to components lib
- 0f76d3d: style: fix padding and border for references
- Updated dependencies [3b672cc]
  - @scalar/swagger-editor@0.10.15
  - @scalar/swagger-parser@0.5.20
  - @scalar/api-client@0.12.14
  - @scalar/components@0.4.2

## 1.17.14

### Patch Changes

- fd0af3c: fix: mobile header button

## 1.17.13

### Patch Changes

- 5bf377e: fix: visual regressions
- c5e8b13: feat: hide secret credentials
- Updated dependencies [c5e8b13]
  - @scalar/api-client@0.12.13
  - @scalar/components@0.4.1
  - @scalar/swagger-editor@0.10.14

## 1.17.12

### Patch Changes

- e0eacb2: feat: show badge for deprecated schema attributes
- db7762c: fix: stop rendering infinite child attributes
- 5bc2ebf: Add syntax highlighting back to codemirror
- Updated dependencies [407a3af]
- Updated dependencies [5bc2ebf]
  - @scalar/components@0.4.0
  - @scalar/swagger-editor@0.10.13
  - @scalar/swagger-parser@0.5.19
  - @scalar/api-client@0.12.12

## 1.17.11

### Patch Changes

- Updated dependencies [d16d07f]
  - @scalar/api-client@0.12.11

## 1.17.10

### Patch Changes

- d8d8341: fix: example response with encoding in content type is not shown
  - @scalar/api-client@0.12.10
  - @scalar/swagger-editor@0.10.12

## 1.17.9

### Patch Changes

- 6857b8d: fix: api client syntax highlighting
- Updated dependencies [6857b8d]
  - @scalar/components@0.3.0
  - @scalar/api-client@0.12.9
  - @scalar/swagger-editor@0.10.11

## 1.17.8

### Patch Changes

- Updated dependencies [51acf2c]
  - @scalar/themes@0.5.10
  - @scalar/api-client@0.12.8
  - @scalar/components@0.2.6
  - @scalar/swagger-editor@0.10.10

## 1.17.7

### Patch Changes

- 55b9633: fix: request type polish
- c103201: fix: polish sidebar
- 31d12a7: fix: show key-value pair examples for objects
- 36630da: chore: remove coinmarketcap example
- Updated dependencies [c103201]
- Updated dependencies [d2728c8]
  - @scalar/components@0.2.6
  - @scalar/themes@0.5.9
  - @scalar/api-client@0.12.7
  - @scalar/swagger-editor@0.10.9

## 1.17.4

### Patch Changes

- b9523b7: fix: allow application/problem+json return type
- Updated dependencies [b9523b7]
  - @scalar/api-client@0.12.6

## 1.17.3

### Patch Changes

- 1669b27: chore: update dependencies
- d96253a: fix: http basic auth empty credentials should not be encoded
- 1669b27: refactor: migrate from use-toasts to vue-sonner
- 9d43b0a: fix: urls with dynamic protocol are prefixed with the window location origin
- a64c389: fix: onSpecUpdate is not called
- 7ea052b: chore: remove some languages from CodeMirror
- Updated dependencies [1669b27]
- Updated dependencies [7ea052b]
  - @scalar/swagger-editor@0.10.8
  - @scalar/swagger-parser@0.5.18
  - @scalar/use-tooltip@0.5.11
  - @scalar/api-client@0.12.5
  - @scalar/components@0.2.5
  - @scalar/use-modal@0.2.8
  - @scalar/themes@0.5.8

## 1.17.2

### Patch Changes

- 0133f86: fix: prismJS is commonjs and breaks in ESM envs
- c6b95ca: chore: upgrade from Vite 4 to Vite 5
- Updated dependencies [c6b95ca]
  - @scalar/swagger-editor@0.10.7
  - @scalar/swagger-parser@0.5.17
  - @scalar/use-tooltip@0.5.10
  - @scalar/api-client@0.12.4
  - @scalar/components@0.2.4
  - @scalar/use-toasts@0.5.15
  - @scalar/use-modal@0.2.7
  - @scalar/themes@0.5.7

## 1.17.1

### Patch Changes

- Updated dependencies [3ade0d1]
  - @scalar/use-modal@0.2.6
  - @scalar/api-client@0.12.3

## 1.17.0

### Minor Changes

- cd3068a: feat: switch syntax highlighting dependency from codemirror to prismjs

## 1.16.3

### Patch Changes

- 9f5fdf5: fix: tab overflow hidden
- 5b3f7d9: fix: updated scroll region padding to for chrome update
- Updated dependencies [c23b2cb]
- Updated dependencies [5b3f7d9]
  - @scalar/api-client@0.12.2
  - @scalar/use-modal@0.2.5
  - @scalar/themes@0.5.6
  - @scalar/components@0.2.3
  - @scalar/swagger-editor@0.10.6

## 1.16.2

### Patch Changes

- 4fb6af9: chore: remove use-keyboard-event package
- dc7b97c: fix: resize classic intro cards for difference screen sizes
- Updated dependencies [4fb6af9]
  - @scalar/api-client@0.12.1

## 1.16.1

### Patch Changes

- 997568b: fix: wrapping of url on request snippet url

## 1.16.0

### Minor Changes

- e0faebb: feat: add show more button to request variables and path params

### Patch Changes

- 92a8b9f: chore: update dependencies
- 230f9fb: feat: prefill the authentication data
- 77c62d3: fix: path isn’t prefixed (<https://github.com/scalar/scalar/issues/937>)
- Updated dependencies [e0faebb]
- Updated dependencies [92a8b9f]
- Updated dependencies [abfb086]
- Updated dependencies [76f4041]
  - @scalar/api-client@0.12.0
  - @scalar/use-keyboard-event@0.5.9
  - @scalar/swagger-editor@0.10.5
  - @scalar/swagger-parser@0.5.16
  - @scalar/use-codemirror@0.8.4
  - @scalar/use-tooltip@0.5.9
  - @scalar/components@0.2.3
  - @scalar/use-toasts@0.5.14
  - @scalar/use-modal@0.2.4
  - @scalar/themes@0.5.5

## 1.15.6

### Patch Changes

- 27a9e708: fix: remove type="text" from the search button placeholder span

## 1.15.5

### Patch Changes

- Updated dependencies [cb8139e7]
  - @scalar/swagger-editor@0.10.4
  - @scalar/api-client@0.11.5

## 1.15.4

### Patch Changes

- 15738a16: fix: set custom scroll on container for endpoints overview
- Updated dependencies [037029cc]
  - @scalar/api-client@0.11.4

## 1.15.3

### Patch Changes

- Updated dependencies [d4fff0de]
  - @scalar/use-codemirror@0.8.3
  - @scalar/api-client@0.11.3
  - @scalar/swagger-editor@0.10.3

## 1.15.2

### Patch Changes

- Updated dependencies [f8650e4f]
  - @scalar/use-codemirror@0.8.2
  - @scalar/api-client@0.11.2
  - @scalar/swagger-editor@0.10.2

## 1.15.1

### Patch Changes

- Updated dependencies [dd6dd283]
- Updated dependencies [b1f3cb49]
  - @scalar/swagger-editor@0.10.1
  - @scalar/use-codemirror@0.8.1
  - @scalar/api-client@0.11.1

## 1.15.0

### Minor Changes

- 612431b4: Migrate model logic from codemirror component to hook
- 26340b12: feat: update components to support all basic http request methods

### Patch Changes

- Updated dependencies [612431b4]
- Updated dependencies [26340b12]
  - @scalar/swagger-editor@0.10.0
  - @scalar/use-codemirror@0.8.0
  - @scalar/api-client@0.11.0

## 1.14.10

### Patch Changes

- a963f10e: fix: shrink label and not actions on mobile
- 4db085f4: feat: use provided examples for the request and the response
- d1c085a0: fix: only open models sidebar section on scroll

## 1.14.9

### Patch Changes

- 2f7ce4d8: feat: improve model look and feel

## 1.14.8

### Patch Changes

- d7dbba87: fix: css reset on markdown details summary

## 1.14.7

### Patch Changes

- ba5b70ce: feat: collapse all subschemas by default

## 1.14.6

### Patch Changes

- 04c0bd9b: feat: details/summary tags in markdown
- 569c104f: fix: swagger 2.0 response body isn’t shown
- Updated dependencies [04c0bd9b]
  - @scalar/swagger-editor@0.9.12

## 1.14.5

### Patch Changes

- 6da73708: feat: handle application/zip responses in the API client
- Updated dependencies [6da73708]
  - @scalar/swagger-editor@0.9.11
  - @scalar/use-codemirror@0.7.22
  - @scalar/api-client@0.10.2

## 1.14.4

### Patch Changes

- Updated dependencies [cd7afa70]
  - @scalar/use-codemirror@0.7.21
  - @scalar/api-client@0.10.1
  - @scalar/swagger-editor@0.9.10

## 1.14.3

### Patch Changes

- e9eefff4: feat: improve custom example block with try request button, path and improved select
- Updated dependencies [dccb83ab]
  - @scalar/api-client@0.10.0

## 1.14.2

### Patch Changes

- 6caef07c: fix: response examples with a single value don’t render

## 1.14.1

### Patch Changes

- eb4faf8c: fix: search input has autocomplete enabled

## 1.14.0

### Minor Changes

- a244b049: Fix markdown table alignment

## 1.13.19

### Patch Changes

- 3d712d74: chore: remove light/dark mode features from useCodeMirror
- Updated dependencies [3d712d74]
  - @scalar/use-codemirror@0.7.20
  - @scalar/api-client@0.9.4
  - @scalar/swagger-editor@0.9.9

## 1.13.18

### Patch Changes

- b4f66f0b: fix: example spec not loading on mobile

## 1.13.17

### Patch Changes

- 8ffea2ae: feat: better schema support for params
- e073b015: fix: allow response to scroll horizontally

## 1.13.16

### Patch Changes

- fcb2b75b: fix: text in method badges wraps for PATCH operations
- 8e7fcfa0: chore: improve types

## 1.13.15

### Patch Changes

- 706b29f2: feat: render images in the description
- d8fc0544: feat: add support for `x-custom-examples` (custom request examples)
- 55e74b08: feat: show nullable properties
- 8573da8d: feat: use schema examples

## 1.13.14

### Patch Changes

- 455deefe: feat: export SidebarElement and SidebarGroup
- 75e1cdf8: fix: only activate hotkey if component is active
- Updated dependencies [75e1cdf8]
  - @scalar/use-keyboard-event@0.5.8
  - @scalar/api-client@0.9.3

## 1.13.13

### Patch Changes

- 7e0ca478: fix: Restoring missing forward slash between URL and API routes
- 9ca25eda: fix: additionalProperties: false is ignored
- e5354121: fix: better deal with incomplete schemas

## 1.13.12

### Patch Changes

- 2c7e0b5c: feat: show webhooks
- c3186f9e: feat: show security schema key and description
- Updated dependencies [2c7e0b5c]
  - @scalar/swagger-parser@0.5.15

## 1.13.11

### Patch Changes

- 57f899f2: fix: search keyboard navigation doesn’t work when the mouse hovers the results
- cb4093f2: feat: show additionalProperties in example requests/responses and in Models

## 1.13.10

### Patch Changes

- c9abbbc0: fix: classic scrollbar
- 81543f42: chore: add support for Node 18
- cca668a2: fix: styles on classic layout client libraries
- Updated dependencies [81543f42]
  - @scalar/use-keyboard-event@0.5.7
  - @scalar/swagger-editor@0.9.8
  - @scalar/swagger-parser@0.5.14
  - @scalar/use-codemirror@0.7.19
  - @scalar/use-clipboard@0.5.13
  - @scalar/use-tooltip@0.5.8
  - @scalar/api-client@0.9.2
  - @scalar/components@0.2.2
  - @scalar/use-toasts@0.5.13
  - @scalar/use-modal@0.2.3
  - @scalar/themes@0.5.4

## 1.13.9

### Patch Changes

- cb45bb13: feat: scroll search selected item into view with keyboard nav
- e87a2474: fix: enter key navigating search item

## 1.13.7

### Patch Changes

- Updated dependencies [479a7e3e]
  - @scalar/swagger-editor@0.9.7
  - @scalar/use-codemirror@0.7.18
  - @scalar/api-client@0.9.1

## 1.13.6

### Patch Changes

- b53b28c1: fix: toggle icon does not toggle
- 460e25c0: feat: show/hide readOnly and writeOnly attributes in requests/responses

## 1.13.5

### Patch Changes

- 09a27371: feat: add headings from the description to the search
- 629ebd81: fix: basePath (Swagger 2.0) is ignored
- 5ca138ee: - Removed activeBreadCrumb from api-client as its available in the slot
  - Centralized navigation logic
  - use proper anchor navigation instead of scrollIntoView, it will also be saved to history
  - scrolling down will open the next section
- 5ca138ee: fix: open section on search result click
- b8ce7fd5: feat: show body and formData parameters (Swagger 2.0)
- Updated dependencies [5ca138ee]
- Updated dependencies [b8ce7fd5]
  - @scalar/api-client@0.9.0
  - @scalar/swagger-editor@0.9.6
  - @scalar/use-toasts@0.5.12
  - @scalar/use-modal@0.2.2
  - @scalar/themes@0.5.3
  - @scalar/use-clipboard@0.5.12
  - @scalar/components@0.2.1

## 1.13.4

### Patch Changes

- dae1010a: chore: update axios to 1.6.5
- Updated dependencies [dae1010a]
  - @scalar/api-client@0.8.10

## 1.13.3

### Patch Changes

- 87032eed: feat: show raw response schema
- Updated dependencies [6cc43ab7]
  - @scalar/swagger-editor@0.9.5

## 1.13.2

### Patch Changes

- 6d777194: feat: release themes
- Updated dependencies [6d777194]
  - @scalar/swagger-editor@0.9.4
  - @scalar/api-client@0.8.9
  - @scalar/components@0.2.1
  - @scalar/themes@0.5.2

## 1.13.1

### Patch Changes

- 20790661: feat: add space themes

## 1.13.0

### Minor Changes

- 97cd84e9: feat: client ignore list

### Patch Changes

- 5dac9c51: fix: open section on search result click
- 0e0f34b3: fix: cleanup safari bugs
- 7582e82a: fix: classic layout stylings
- Updated dependencies [0e0f34b3]
  - @scalar/api-client@0.8.8

## 1.12.9

### Patch Changes

- d5d55407: feat: expose dark mode light mode property in config
- 7d502131: fix: add markdown rendering for body schema
- 3e7c4cf7: feat: add fetch examples
- Updated dependencies [c171c9d9]
  - @scalar/use-codemirror@0.7.17
  - @scalar/api-client@0.8.7
  - @scalar/swagger-editor@0.9.3

## 1.12.8

### Patch Changes

- 859977f8: feat: Add dynamic content type selection for request body

## 1.12.7

### Patch Changes

- 0b66933d: fix: declare theme font for buttons and fix regressed font weight
- Updated dependencies [0b66933d]
  - @scalar/swagger-editor@0.9.2

## 1.12.6

### Patch Changes

- 87ed7f01: fix: markdown second level margin issue

## 1.12.5

### Patch Changes

- 4513c725: feat: add intro flare for gradients

## 1.12.4

### Patch Changes

- 06f800cc: fix: regression ui bugs
- Updated dependencies [06f800cc]
  - @scalar/api-client@0.8.6

## 1.12.3

### Patch Changes

- bf29f8df: fix: add text/plain support
- Updated dependencies [bf29f8df]
  - @scalar/api-client@0.8.5

## 1.12.2

### Patch Changes

- 0f9791b7: fix: add null check to cookies and proper withCredentials set on cookie addition
- Updated dependencies [0f9791b7]
  - @scalar/api-client@0.8.4

## 1.12.1

### Patch Changes

- 54be5027: fix: make fuse data reactive
- 6c4d608f: refactor: scope all sidebar styles

## 1.12.0

### Minor Changes

- 1c4f4c88: feat: classic layout polish

### Patch Changes

- 432d16fe: feat: add an OpenAuth2 interface
- Updated dependencies [1c4f4c88]
- Updated dependencies [2d7e3e6e]
  - @scalar/components@0.2.0
  - @scalar/swagger-editor@0.9.1

## 1.11.1

### Patch Changes

- 855a6713: fix: remove caching of configuration when updating spec as prop
- 5f270ca4: chore: export stores and helpers
- 6cbb5a65: refactor: use Schema component to render parameters and response body

## 1.11.0

### Minor Changes

- 1972947f: chore: removed yjs and hocus pocus from swagger editor

### Patch Changes

- e99eb215: fix: align mobile navigation to header
- cf30daa2: fix: add JSON.stringify to undici body
- 4b28e96c: style: add position sticky to endpoints overview
- Updated dependencies [1972947f]
  - @scalar/swagger-editor@0.9.0

## 1.10.2

### Patch Changes

- 70f33ea2: fix: references mobile menu position relative bug

## 1.10.1

### Patch Changes

- 01afd152: fix: sidebar on mobile doesnt close once changing active item

## 1.10.0

### Minor Changes

- f2a7a214: feat: remove border from introduction card headings

### Patch Changes

- 5efb80bb: feat: add undici example requests
- 8436e115: feat: classic introduction layout
- 5d6b539b: feat: toggle parameters to include/exclude them in/from the request
- c24583ba: feat: show schema description in parameter item
- a1319e8b: Switched internal component library to use ScalarComponents instead
- d1caa4ee: fix: self contain app and toast containers + size changing fix
- Updated dependencies [5d6b539b]
- Updated dependencies [a1319e8b]
- Updated dependencies [d1caa4ee]
  - @scalar/api-client@0.8.3
  - @scalar/components@0.1.0
  - @scalar/swagger-editor@0.8.4
  - @scalar/swagger-parser@0.5.13
  - @scalar/use-codemirror@0.7.16
  - @scalar/use-modal@0.2.1
  - @scalar/themes@0.5.1
  - @scalar/use-toasts@0.5.11
  - @scalar/use-clipboard@0.5.11

## 1.9.2

### Patch Changes

- 648e5a98: chore: don’t add optional parameters to the client

## 1.9.1

### Patch Changes

- edb02e76: fix: windows select menu not updating on prefers color scheme
- Updated dependencies [edb02e76]
  - @scalar/api-client@0.8.2

## 1.9.0

### Minor Changes

- c45ae5e8: feat: add accordion layout for schema models

### Patch Changes

- d7da3147: fix: remove duplicate slash in example and client

## 1.8.0

### Minor Changes

- f9bfa97: feat: add buttons to header for classic layout

### Patch Changes

- d45f5a5: fix: handle root path in request generation
- Updated dependencies [f9bfa97]
  - @scalar/swagger-editor@0.8.3
  - @scalar/use-toasts@0.5.10
  - @scalar/use-clipboard@0.5.10

## 1.7.1

### Patch Changes

- 4423876: chore: make Axios the default client for Node.js
- 4423876: chore: remove unirest and node-fetch from the client lists

## 1.7.0

### Minor Changes

- 4f2fcc3: feat: classic layout content

### Patch Changes

- Updated dependencies [4f2fcc3]
  - @scalar/swagger-editor@0.8.2

## 1.6.1

### Patch Changes

- f87910d: feat: prefill path, header, cookie, query parameters from the spec
- Updated dependencies [f87910d]
  - @scalar/api-client@0.8.1

## 1.6.0

### Minor Changes

- c04c2ea: feat: show references sidebar slot content in api client sidebar

### Patch Changes

- 90ffeb5: refactor: extract layout type into component
- 98e01a2: fix: prevent css leakage from references reset
- 654333a: fix: oneOf rules for arrays are ignored
- 84c0c77: chore: change Download OpenAPI Spec button text
- 4e5d00e: style: visualize deprecated operations
- Updated dependencies [98e01a2]
- Updated dependencies [c04c2ea]
  - @scalar/swagger-editor@0.8.1

## 1.5.0

### Minor Changes

- f38bb61: chore: remove swagger editor tabs

### Patch Changes

- 349589a: feat: expose spec content updates
- Updated dependencies [349589a]
- Updated dependencies [f38bb61]
  - @scalar/api-client@0.8.0
  - @scalar/swagger-editor@0.8.0
  - @scalar/use-modal@0.2.0
  - @scalar/themes@0.5.0

## 1.4.0

### Minor Changes

- b974eeb: feat: swagger UI style layout

### Patch Changes

- b65840b: refactor: keep track of the collapsed sidebar items in @scalar/api-reference
- 95fbc01: fix: hono middleware fails to read configuration.spec.content
- b65840b: fix: URL doesn’t match the active sidebar item
- Updated dependencies [b65840b]
  - @scalar/api-client@0.7.37

## 1.3.0

### Minor Changes

- 37b974c: feat: expose footer slot on standalone component

### Patch Changes

- b77d087: feat: add a customCss property to the configuration object

## 1.2.7

### Patch Changes

- Updated dependencies [bc23e62]
  - @scalar/api-client@0.7.36

## 1.2.6

### Patch Changes

- ed7cc0d: fix: remove leaky header css
- Updated dependencies [2251ea5]
- Updated dependencies [fdaabfe]
- Updated dependencies [fdaabfe]
  - @scalar/swagger-editor@0.7.11
  - @scalar/api-client@0.7.35

## 1.2.5

### Patch Changes

- 35dffe4: chore: include @scalar dependencies in the bundle
- 5c66be8: chore: replace imports pointing to src with relative paths
- Updated dependencies [35dffe4]
- Updated dependencies [5c66be8]
  - @scalar/use-keyboard-event@0.5.6
  - @scalar/swagger-editor@0.7.10
  - @scalar/swagger-parser@0.5.12
  - @scalar/use-codemirror@0.7.15
  - @scalar/use-clipboard@0.5.9
  - @scalar/use-tooltip@0.5.7
  - @scalar/api-client@0.7.34
  - @scalar/use-toasts@0.5.9
  - @scalar/use-modal@0.1.9

## 1.2.4

### Patch Changes

- c3b215f: chore: no pinned peer dependency versions
- Updated dependencies [c3b215f]
  - @scalar/use-keyboard-event@0.5.5
  - @scalar/swagger-editor@0.7.9
  - @scalar/use-codemirror@0.7.14
  - @scalar/use-tooltip@0.5.6
  - @scalar/api-client@0.7.33
  - @scalar/use-toasts@0.5.8
  - @scalar/use-modal@0.1.8
  - @scalar/themes@0.4.2
  - @scalar/use-clipboard@0.5.8

## 1.2.3

### Patch Changes

- 55246e5: chore: rewrite all package.jsons (including their prod, dev and peer dependency requirements)
- f2941f5: feat: add `metaData` to the configuration to pass meta tags (title, opengraph data …)
- Updated dependencies [55246e5]
  - @scalar/use-keyboard-event@0.5.4
  - @scalar/swagger-editor@0.7.8
  - @scalar/swagger-parser@0.5.11
  - @scalar/use-codemirror@0.7.13
  - @scalar/use-clipboard@0.5.7
  - @scalar/use-tooltip@0.5.5
  - @scalar/api-client@0.7.32
  - @scalar/use-toasts@0.5.7
  - @scalar/use-modal@0.1.7
  - @scalar/themes@0.4.1

## 1.2.2

### Patch Changes

- 81490fb: feat: pass global parameters and parameters to the api client
- 18bb6a4: fix: offset sections by header height for scrolling

## 1.2.1

### Patch Changes

- fa34e17: fix: set search modal variant
- 9e6cc67: fix: don't handle search shortcut if component is deactivated

## 1.2.0

### Minor Changes

- edb09a0: refactor: expose slot props for reference base component

### Patch Changes

- 678e383: fix: no authentication shouldn’t render an empty form
- c51124f: feat: add anchors to headings

## 1.1.7

### Patch Changes

- Updated dependencies [1a2afb6]
  - @scalar/swagger-editor@0.7.7

## 1.1.6

### Patch Changes

- 36761e4: feat: make the available tabs configurable
- Updated dependencies [8e65ba9]
- Updated dependencies [36761e4]
  - @scalar/swagger-editor@0.7.6

## 1.1.5

### Patch Changes

- b8dc5a5: fix: show path parameters in the parameter tables
- Updated dependencies [b6552df]
- Updated dependencies [b8dc5a5]
- Updated dependencies [04875a6]
  - @scalar/swagger-editor@0.7.5
  - @scalar/swagger-parser@0.5.10

## 1.1.4

### Patch Changes

- 752dcf3: feat: add support for models with top level anyOf, allOf, oneOf …
- Updated dependencies [a1575f2]
  - @scalar/swagger-parser@0.5.9

## 1.1.3

### Patch Changes

- 75df2d2: feat: use bearer auth as the fallback for http auth
- c97e8e6: chore: add form tag to auth credentials
- 52c20e5: style: no text transform for model names
- b1fe23c: feat: add support for oneOf in response schemas
  feat: add support for allOf in response schemas
- 1208a7f: feat: add support for Swagger 2.0 host and schemes configuration
- Updated dependencies [3d6027c]
  - @scalar/swagger-parser@0.5.8

## 1.1.2

### Patch Changes

- d062fd9: fix: deep linking in api references

## 1.1.1

### Patch Changes

- 5eb5dcf: refactor: bring back footer slot

## 1.1.0

### Minor Changes

- 77dce14: refactor(references)!: remove deprecated component props
  refactor(references): extract references code into base component
  feat(references): expose new props for references base component

### Patch Changes

- d3205e5: feat: support request bodies with other mime types than JSON
- aa2a575: fix: cards overlapping header
- Updated dependencies [801f1b5]
  - @scalar/swagger-editor@0.7.4

## 1.0.6

### Patch Changes

- 366b142: fix: ignore proxy when swagger spec is a path
- e1dc955: fix: add fallback to name for models if no xml attribute passed
- Updated dependencies [ceb7952]
  - @scalar/api-client@0.7.31

## 1.0.5

### Patch Changes

- ff81f70: refactor: move getting started example to GettingStarted component
- 5da1fc6: security: update axios from 1.5.0 to 1.6.1
- ff81f70: fix: don’t overwrite the CodeMirror content when collaborative editing is enabled
- Updated dependencies [ff81f70]
- Updated dependencies [5da1fc6]
- Updated dependencies [ff81f70]
  - @scalar/swagger-editor@0.7.3
  - @scalar/api-client@0.7.30

## 1.0.4

### Patch Changes

- 7fb2302: feat: detect variables in URLs
- 54098d7: chore: better fallbacks for the operation.name
- dd06807: fix: optional chain for request bodies
- 551aa7d: fix: mobile sidebar always open by default
- 7fb2302: fix: show server variables for single URLs too
- 3eff44f: fix: show description component only when a description is specified
- f0dca6c: fix: add fallback if no summary or key is provided for examples
- Updated dependencies [54098d7]
- Updated dependencies [7fb2302]
  - @scalar/swagger-parser@0.5.7
  - @scalar/api-client@0.7.29

## 1.0.3

### Patch Changes

- c92a3a3: fix: active state for the headings taken from the description
- 57cea1a: fix: don’t show a version badge if no version is defined
- dce99ae: fix: removed deleted icons from type definition
- 009a720: fix: add missing http logo
- 48118ba: feat: add updateContent event to the ApiReference component
- dab853a: chore: remove unused dependencies
- Updated dependencies [f4681d5]
- Updated dependencies [c92a3a3]
- Updated dependencies [48118ba]
- Updated dependencies [dab853a]
  - @scalar/swagger-editor@0.7.2
  - @scalar/use-codemirror@0.7.12
  - @scalar/swagger-parser@0.5.6
  - @scalar/api-client@0.7.28
  - @scalar/use-modal@0.1.6

## 1.0.2

### Patch Changes

- a7e6c25: fix: externalize remark/rehype dependencies to fix SSG builds
- 4253b4a: fix: move footer below sidebar and editor when toggled
- Updated dependencies [a7e6c25]
  - @scalar/swagger-editor@0.7.1

## 1.0.1

### Patch Changes

- 68edf8c: feat: add oas version and spec version to title
- e482ce0: fix: don’t overwrite the content if there is nothing configured
- 6af9829: refactor: add a ApiReferenceLayout component to offer slots for everything
- 6bdc65b: Exported ApiReferenceLayout as separate component

## 1.0.0

### Minor Changes

- 440815a: Add getting started to empty render area

### Patch Changes

- 94d2fe4: fix: don’t show a security scheme select when there is only one
- b0835a2: users not using themed css fallbacks
- c470db5: make --theme priority over --default-theme in misc places
- 5243ae4: make search modal hotkey configurable
- 509db1e: refactor: move all api reference refs and watchers to hooks
- Updated dependencies [b0835a2]
- Updated dependencies [440815a]
- Updated dependencies [c470db5]
- Updated dependencies [da431d9]
- Updated dependencies [3c6f54f]
- Updated dependencies [509db1e]
- Updated dependencies [a4f1b08]
  - @scalar/use-modal@0.1.5
  - @scalar/swagger-editor@0.7.0
  - @scalar/api-client@0.7.27
  - @scalar/use-codemirror@0.7.11

## 0.8.10

### Patch Changes

- 8c15df74: remove extra borders + fix spacing when only 1 server child

## 0.8.9

### Patch Changes

- 9c7a5722: feat: make the server selectable
  feat: add inputs for server variables
  feat: pass configured server environment to example requests
  feat: pass configured server environment to the api client
  refactor: new helpers to generate the request data for the example request and the client
- a5df4a5b: fix: don’t show generated example responses if there’s an example
- Updated dependencies [9c7a5722]
  - @scalar/api-client@0.7.26

## 0.8.8

### Patch Changes

- 8e2e4e5a: fix markdown collisions + prefix the card name
- Updated dependencies [8e2e4e5a]
  - @scalar/swagger-editor@0.6.30
  - @scalar/api-client@0.7.25

## 0.8.7

### Patch Changes

- db24e103: hotfix: import spec from url
- Updated dependencies [db24e103]
  - @scalar/swagger-editor@0.6.29

## 0.8.6

### Patch Changes

- c75b13b1: hotfix: load the swagger editor even if it’s not used

## 0.8.5

### Patch Changes

- 2f0b2f01: fix: add deprecated footerBelowSidebar again (use configuration object instead)
- 2f0b2f01: feat: add download spec button
- 2f0b2f01: refactor: improve the data flow between the reference and the swagger editor
- 2f0b2f01: refactor: move json helpers to separate files
- Updated dependencies [2f0b2f01]
- Updated dependencies [2f0b2f01]
  - @scalar/swagger-editor@0.6.28
  - @scalar/api-client@0.7.24

## 0.8.4

### Patch Changes

- Updated dependencies [a73ee9d8]
  - @scalar/swagger-editor@0.6.27

## 0.8.3

### Patch Changes

- d5fccba9: add ai writer to swagger editor
- Updated dependencies [d5fccba9]
  - @scalar/swagger-editor@0.6.26

## 0.8.2

### Patch Changes

- 3b042270: fix: active state for operations with multiple tags
- 4685f391: feat: introducing the new universal configuration object
- 8ac1ad69: chore: use different heading levels
- 28191084: feat: add security schemes to the reference
- e01134d4: style: use horizontal ellipsis to indicate strings in example responses
- Updated dependencies [64f8a018]
- Updated dependencies [ce04794a]
- Updated dependencies [7c3091c6]
  - @scalar/use-codemirror@0.7.10
  - @scalar/api-client@0.7.23
  - @scalar/swagger-editor@0.6.25

## 0.8.1

### Patch Changes

- 7ed5c61a: fix: add target blank to markdown links

## 0.8.0

### Minor Changes

- 2eba4010: Refactor and simplify API references layout

### Patch Changes

- 9d352b13: fix: make the sidebar work with tags without operations
- b71c4db7: feat: example objects in arrays for example responses
- 01109c6f: feat: use min value as the default for generated example responses
- Updated dependencies [df74d017]
- Updated dependencies [75d12f56]
- Updated dependencies [2eba4010]
  - @scalar/api-client@0.7.22
  - @scalar/use-toasts@0.5.6
  - @scalar/use-clipboard@0.5.6

## 0.7.11

### Patch Changes

- 1f064818: added scrolling to the sidebar on highlight
- 1bd5fb80: feat: add syntax highlighting to the markdown renderer

## 0.7.10

### Patch Changes

- c1cb507d: fix: search modal not scrolling to proper endpoints
- d1fcd043: ensure endpoint parent tag is open before trying to scroll

## 0.7.9

### Patch Changes

- 45ac0aaa: fix missing property description

## 0.7.8

### Patch Changes

- ab348cb5: Mobile improvements and layout fixes + consitency improvements
- 211ed1c7: polish up the models
- ca2689b6: feat: add example request body to example request generator
- ae247253: refactor: move generateRequest helpers to @scalar/api-reference
- 5896b08d: fix: add missing null check to jsonRequest requestBody
- Updated dependencies [ab348cb5]
- Updated dependencies [aa24dbe6]
- Updated dependencies [ae247253]
  - @scalar/api-client@0.7.21
  - @scalar/use-codemirror@0.7.9
  - @scalar/swagger-editor@0.6.24

## 0.7.7

### Patch Changes

- 0495c0f9: feat: show models ("schemas") in the reference
- 528df9d1: feat: add support for oneOf, anyOf, allOf, not schema rules
- 8915c5cf: fix: add null check to tag operations in sidebar
- d755d34e: fix: default show endpoint when tags have one endpoint
- a161c962: fix: better deal with empty descriptions
- 7e7ea175: feat: use default value in schemas for example responses

## 0.7.6

### Patch Changes

- d87566fd: refactor: new section components, new sidebar
- 43628366: Fix overflow and scrolling issues for API client
- 6131fa72: chore: update README
- dd8df965: feat: add requestbody to api client if json schema available
- 52534317: Fix references not respecting height on mobile Safari
- Updated dependencies [db7f5f57]
- Updated dependencies [d87566fd]
- Updated dependencies [8be53df2]
- Updated dependencies [4eaee866]
- Updated dependencies [43628366]
- Updated dependencies [06b46553]
- Updated dependencies [dd8df965]
  - @scalar/swagger-parser@0.5.5
  - @scalar/swagger-editor@0.6.23
  - @scalar/api-client@0.7.20

## 0.7.5

### Patch Changes

- fd875bc7: feat: show headings with a higher depth in the sidebar
- 28cce042: fix: externalize markdown plugins to not break SSG
- Updated dependencies [28cce042]
  - @scalar/api-client@0.7.19

## 0.7.4

### Patch Changes

- 51029c1d: add interactive params, headers and variables
- Updated dependencies [51029c1d]
  - @scalar/api-client@0.7.18

## 0.7.3

### Patch Changes

- 99936ab8: feat: add markdown headings to the sidebar
- 08e8f637: style: improve markdown code blocks

## 0.7.2

### Patch Changes

- fd6cf1bb: fix: too much recursion
- 357a174d: feat: fix import URL, use proxy to fetch files
- Updated dependencies [fd6cf1bb]
- Updated dependencies [357a174d]
- Updated dependencies [357a174d]
  - @scalar/swagger-parser@0.5.4
  - @scalar/swagger-editor@0.6.22

## 0.7.1

### Patch Changes

- 3c2bc6a9: style: update the search modal style

## 0.7.0

### Minor Changes

- fd38deb0: Add mobile menu and breadcrumbs

### Patch Changes

- Updated dependencies [fd38deb0]
  - @scalar/themes@0.4.0
  - @scalar/api-client@0.7.17
  - @scalar/swagger-editor@0.6.21

## 0.6.23

### Patch Changes

- af4ec8d3: update discord links
- e643b56e: Fix incorrectly named css variables
- c6ac9ff4: fix search modal reactivity
- 749f2f3f: fix: initial swagger editor content is parsed
- 91b09499: Fix breadcrums throwing error for specs without operations in tags
- Updated dependencies [af4ec8d3]
- Updated dependencies [749f2f3f]
  - @scalar/use-keyboard-event@0.5.3
  - @scalar/swagger-editor@0.6.20
  - @scalar/swagger-parser@0.5.3
  - @scalar/use-codemirror@0.7.8
  - @scalar/use-clipboard@0.5.5
  - @scalar/use-tooltip@0.5.4
  - @scalar/api-client@0.7.16
  - @scalar/use-toasts@0.5.5
  - @scalar/themes@0.3.11

## 0.6.22

### Patch Changes

- d4789991: fix: populate search fuse data immediately

## 0.6.21

### Patch Changes

- ea110ca0: feat: export SearchModal component
- 1cbcabd7: lots of amazing fixes from when we missed last patch
- 9d22b4ca: fix: make the base urls reactive
- 437c4b01: amazing sprint fixes
- Updated dependencies [33604a1b]
- Updated dependencies [1cbcabd7]
- Updated dependencies [d7b12610]
  - @scalar/swagger-parser@0.5.2
  - @scalar/api-client@0.7.15
  - @scalar/use-keyboard-event@0.5.2
  - @scalar/swagger-editor@0.6.19
  - @scalar/use-codemirror@0.7.7
  - @scalar/use-clipboard@0.5.4
  - @scalar/use-tooltip@0.5.3
  - @scalar/use-toasts@0.5.4
  - @scalar/use-modal@0.1.4
  - @scalar/themes@0.3.10

## 0.6.20

### Patch Changes

- 37353dd1: feat: add `data-proxy-url` to the HTML API
- Updated dependencies [a7f776ba]
  - @scalar/swagger-editor@0.6.18

## 0.6.19

### Patch Changes

- eb0c3201: Lot's of small things + bigger temp fix for the multi content cards
- Updated dependencies [eb0c3201]
  - @scalar/swagger-editor@0.6.17
  - @scalar/api-client@0.7.14
  - @scalar/themes@0.3.9

## 0.6.18

### Patch Changes

- Updated dependencies [3805e649]
  - @scalar/swagger-editor@0.6.16

## 0.6.17

### Patch Changes

- Updated dependencies [be239745]
  - @scalar/use-codemirror@0.7.6
  - @scalar/api-client@0.7.13
  - @scalar/swagger-editor@0.6.15

## 0.6.16

### Patch Changes

- 0f87c35d: feat: add dark mode toggle 👀
- 3dd2574d: sidebar toggle not flex aligned + fix folder colors
- Updated dependencies [30aee7d1]
- Updated dependencies [99744358]
- Updated dependencies [24deb723]
- Updated dependencies [3dd2574d]
  - @scalar/api-client@0.7.12
  - @scalar/swagger-editor@0.6.14

## 0.6.15

### Patch Changes

- 7b6c21e5: request history ui and some other small type changes
- Updated dependencies [7b6c21e5]
  - @scalar/api-client@0.7.11
  - @scalar/use-modal@0.1.3
  - @scalar/swagger-editor@0.6.13

## 0.6.14

### Patch Changes

- 46142c0a: reference theme fixes
- Updated dependencies [46142c0a]
  - @scalar/swagger-editor@0.6.12
  - @scalar/api-client@0.7.10
  - @scalar/themes@0.3.8

## 0.6.13

### Patch Changes

- 727d7f47: make swagger editor tab state controllable via prop
- Updated dependencies [727d7f47]
- Updated dependencies [727d7f47]
  - @scalar/swagger-editor@0.6.11

## 0.6.12

### Patch Changes

- Updated dependencies [4b4bc4d7]
- Updated dependencies [30d54d16]
- Updated dependencies [48df28ef]
- Updated dependencies [1d02c811]
  - @scalar/api-client@0.7.9
  - @scalar/themes@0.3.7
  - @scalar/swagger-editor@0.6.10

## 0.6.11

### Patch Changes

- b76f4d1e: Reference search + some app hover states
- Updated dependencies [b76f4d1e]
  - @scalar/swagger-editor@0.6.9
  - @scalar/use-codemirror@0.7.5
  - @scalar/api-client@0.7.8
  - @scalar/use-modal@0.1.2
  - @scalar/themes@0.3.6

## 0.6.10

### Patch Changes

- 07b99141: api client in refs touch ups
- Updated dependencies [07b99141]
  - @scalar/api-client@0.7.7

## 0.6.9

### Patch Changes

- 4985562c: polish codemirror theme colors
- Updated dependencies [4985562c]
  - @scalar/use-codemirror@0.7.4
  - @scalar/themes@0.3.5
  - @scalar/api-client@0.7.6
  - @scalar/swagger-editor@0.6.8

## 0.6.8

### Patch Changes

- Updated dependencies [58af0623]
  - @scalar/use-codemirror@0.7.3
  - @scalar/api-client@0.7.5
  - @scalar/swagger-editor@0.6.7

## 0.6.7

### Patch Changes

- cd5f2685: codemirror colors + font fixes throughout app
- Updated dependencies [cd5f2685]
  - @scalar/swagger-editor@0.6.6
  - @scalar/api-client@0.7.4
  - @scalar/use-toasts@0.5.3
  - @scalar/themes@0.3.4
  - @scalar/use-clipboard@0.5.3

## 0.6.6

### Patch Changes

- 8823d7a1: cleanup ui
- Updated dependencies [8823d7a1]
  - @scalar/use-codemirror@0.7.2
  - @scalar/api-client@0.7.3
  - @scalar/swagger-editor@0.6.5

## 0.6.5

### Patch Changes

- Updated dependencies [5363374d]
  - @scalar/swagger-editor@0.6.4

## 0.6.4

### Patch Changes

- 449305f4: marketing content section
- 3e912c75: getting started page design
- 048555c6: feat: add CHANGELOG.md to the package
- df62875a: fix: don’t render tags without endpoints, use path as fallback for the endpoint heading
- Updated dependencies [449305f4]
- Updated dependencies [3e912c75]
- Updated dependencies [048555c6]
  - @scalar/swagger-editor@0.6.3
  - @scalar/api-client@0.7.2
  - @scalar/use-modal@0.1.1
  - @scalar/use-keyboard-event@0.5.1
  - @scalar/swagger-parser@0.5.1
  - @scalar/use-codemirror@0.7.1
  - @scalar/use-clipboard@0.5.2
  - @scalar/use-tooltip@0.5.2
  - @scalar/use-toasts@0.5.2
  - @scalar/themes@0.3.3

## 0.6.3

### Patch Changes

- 75a69ba7: feat: add `theme` prop and improve theme support
- effc1f31: feat: add new HTML API based on script tags
  chore: deprecate old div based HTML API
- 75a69ba7: refactor: rename @scalar/default-theme to @scalar/themes, add more themes
- b03a09c7: chore: remove Vite env proxy variable
- 11270915: fix: use higher z-index values
- Updated dependencies [75a69ba7]
- Updated dependencies [d6a10e1f]
- Updated dependencies [75a69ba7]
  - @scalar/swagger-editor@0.6.2
  - @scalar/api-client@0.7.1
  - @scalar/themes@0.3.2

## 0.6.2

### Patch Changes

- b184bdf2: codemirror themeing and other theme fixes
- e9861139: feat: pass an already parsed OpenAPI spec to the ApiReference component
- 8751c874: Fix background color not being applied below rendered references
- addd9fa2: feat: use `default` prefix for all CSS variables
- Updated dependencies [b184bdf2]
- Updated dependencies [6caceb45]
- Updated dependencies [8751c874]
- Updated dependencies [3b1fec80]
- Updated dependencies [addd9fa2]
- Updated dependencies [2006aa43]
  - @scalar/swagger-editor@0.6.1
  - @scalar/use-codemirror@0.7.0
  - @scalar/default-theme@0.3.1
  - @scalar/api-client@0.7.0
  - @scalar/use-tooltip@0.5.1
  - @scalar/use-toasts@0.5.1
  - @scalar/use-clipboard@0.5.1

## 0.6.1

### Patch Changes

- 5a5e760f: fix: use .js as file extension for the browser build

## 0.6.0

### Minor Changes

- 87fda5af: chore: update dependencies

### Patch Changes

- ef080a26: chore: format package.json
- 9d925e1c: feat: add browser build to the package
- 2cfc8786: feat: add a ton more clients to render example requests
- Updated dependencies [ef080a26]
- Updated dependencies [87fda5af]
- Updated dependencies [45645710]
  - @scalar/use-keyboard-event@0.5.0
  - @scalar/swagger-editor@0.6.0
  - @scalar/swagger-parser@0.5.0
  - @scalar/use-codemirror@0.6.0
  - @scalar/themes@0.3.0
  - @scalar/use-clipboard@0.5.0
  - @scalar/use-tooltip@0.5.0
  - @scalar/api-client@0.6.0
  - @scalar/use-toasts@0.5.0

## 0.5.6

### Patch Changes

- 81336114: add yjs support
- Updated dependencies [81336114]
  - @scalar/swagger-editor@0.5.6
  - @scalar/use-codemirror@0.5.4
  - @scalar/api-client@0.5.5

## 0.5.5

### Patch Changes

- Updated dependencies [068669b6]
  - @scalar/use-codemirror@0.5.3
  - @scalar/api-client@0.5.4
  - @scalar/swagger-editor@0.5.5

## 0.5.4

### Patch Changes

- Updated dependencies [ac492d94]
  - @scalar/use-codemirror@0.5.2
  - @scalar/api-client@0.5.3
  - @scalar/swagger-editor@0.5.4

## 0.5.3

### Patch Changes

- Updated dependencies [a0a1590f]
  - @scalar/swagger-editor@0.5.3

## 0.5.2

### Patch Changes

- d51aebe5: chore: remove source files from packages
- Updated dependencies [d51aebe5]
  - @scalar/use-keyboard-event@0.4.2
  - @scalar/swagger-editor@0.5.2
  - @scalar/swagger-parser@0.4.3
  - @scalar/use-codemirror@0.5.1
  - @scalar/use-clipboard@0.4.2
  - @scalar/use-tooltip@0.4.2
  - @scalar/api-client@0.5.2

## 0.5.1

### Patch Changes

- 4165b251: feat: improve rendering of complex swagger files
- Updated dependencies [e49cdc3a]
- Updated dependencies [4165b251]
  - @scalar/api-client@0.5.1
  - @scalar/swagger-parser@0.4.2
  - @scalar/swagger-editor@0.5.1

## 0.5.0

### Minor Changes

- 0902d82c: \* refactor: add the CodeMirror component to @scalar/use-codemirror, use it everywhere
  - feat: allow to pass forceDarkMode to the CodeMirror component

### Patch Changes

- 10498d9d: chore: add README
- 494083a0: add more information to the package.json
- Updated dependencies [0902d82c]
- Updated dependencies [0902d82c]
- Updated dependencies [10498d9d]
- Updated dependencies [494083a0]
  - @scalar/swagger-editor@0.5.0
  - @scalar/use-codemirror@0.5.0
  - @scalar/api-client@0.5.0
  - @scalar/use-keyboard-event@0.4.1
  - @scalar/swagger-parser@0.4.1
  - @scalar/themes@0.2.1
  - @scalar/use-clipboard@0.4.1
  - @scalar/use-tooltip@0.4.1
  - @scalar/use-toasts@0.4.1

## 0.4.0

### Minor Changes

- 5057e213: make npm packages public :-)

### Patch Changes

- Updated dependencies [5057e213]
  - @scalar/api-client@0.4.0
  - @scalar/themes@0.2.0
  - @scalar/swagger-editor@0.4.0
  - @scalar/swagger-parser@0.4.0
  - @scalar/use-clipboard@0.4.0
  - @scalar/use-keyboard-event@0.4.0
  - @scalar/use-toasts@0.4.0
  - @scalar/use-tooltip@0.4.0

## 0.3.4

### Patch Changes

- Updated dependencies [027012c8]
  - @scalar/api-client@0.3.4

## 0.3.3

### Patch Changes

- 6420305b: fix: only require nunjucks where it’s needed
- Updated dependencies [6420305b]
  - @scalar/api-client@0.3.3

## 0.3.2

### Patch Changes

- de4ff38: feat: add a new @scalar/themes package to import the variables and custom scrollbar CSS
- Updated dependencies [de4ff38]
  - @scalar/themes@0.1.1
  - @scalar/api-client@0.3.2

## 0.3.1

### Patch Changes

- 0f345e4: fix: import CSS file from component, makes sure the CSS is included in the build
- Updated dependencies [0f345e4]
  - @scalar/api-client@0.3.1

## 0.3.0

### Minor Changes

- b0f5221: manually releasing all packages to make sure the lastest version is on npm

### Patch Changes

- Updated dependencies [b0f5221]
  - @scalar/api-client@0.3.0
  - @scalar/swagger-editor@0.3.0
  - @scalar/swagger-parser@0.3.0
  - @scalar/use-clipboard@0.3.0
  - @scalar/use-keyboard-event@0.3.0
  - @scalar/use-toasts@0.3.0
  - @scalar/use-tooltip@0.3.0

## 0.2.1

### Patch Changes

- 41b06cb: fix: scope search modal keyboard events
- Updated dependencies [41b06cb]
  - @scalar/use-keyboard-event@0.2.1
  - @scalar/api-client@0.2.1

## 0.2.0

### Minor Changes

- a ton of fixes, new fastify plugin

### Patch Changes

- Updated dependencies
  - @scalar/api-client@0.2.0
  - @scalar/swagger-editor@0.2.0
  - @scalar/swagger-parser@0.2.0
  - @scalar/use-clipboard@0.2.0
  - @scalar/use-keyboard-event@0.2.0
  - @scalar/use-tooltip@0.2.0

## 0.1.31

### Patch Changes

- fix: Node polyfill issues (process undefined)
- Updated dependencies
  - @scalar/api-client@0.1.21
  - @scalar/swagger-editor@0.1.16
  - @scalar/swagger-parser@0.1.14

## 0.1.30

### Patch Changes

- add offline search and ui improvements
- add offline search, improve ui
- Updated dependencies
- Updated dependencies
  - @scalar/api-client@0.1.20
  - @scalar/swagger-editor@0.1.15
  - @scalar/swagger-parser@0.1.13

## 0.1.29

### Patch Changes

- feat: add a standalone version
- Updated dependencies
  - @scalar/api-client@0.1.19
  - @scalar/swagger-editor@0.1.14
  - @scalar/swagger-parser@0.1.12

## 0.1.28

### Patch Changes

- add: language selector supersede classes

## 0.1.27

### Patch Changes

- fix sidebar height issue
- Updated dependencies
  - @scalar/api-client@0.1.18
  - @scalar/swagger-editor@0.1.13

## 0.1.26

### Patch Changes

- fix: add server null check

## 0.1.25

### Patch Changes

- fix empty servers edge case

## 0.1.24

### Patch Changes

- add slots to modal

## 0.1.23

### Patch Changes

- @scalar/swagger-editor@0.1.12

## 0.1.22

### Patch Changes

- @scalar/swagger-editor@0.1.11

## 0.1.21

### Patch Changes

- @scalar/swagger-editor@0.1.10

## 0.1.20

### Patch Changes

- fix incorrect font sizes
- Updated dependencies
  - @scalar/api-client@0.1.17
  - @scalar/swagger-editor@0.1.9

## 0.1.19

### Patch Changes

- add missing hocuspocus url prop

## 0.1.18

### Patch Changes

- css variable fixes and hocuspocusurl prop
- Updated dependencies
  - @scalar/api-client@0.1.16
  - @scalar/swagger-editor@0.1.8

## 0.1.17

### Patch Changes

- fix: mismatched variables
- Updated dependencies
  - @scalar/api-client@0.1.15
  - @scalar/swagger-editor@0.1.7

## 0.1.16

### Patch Changes

- update font weights
- Updated dependencies
  - @scalar/api-client@0.1.14

## 0.1.15

### Patch Changes

- fix: use scalar fonts
- Updated dependencies
  - @scalar/api-client@0.1.13

## 0.1.14

### Patch Changes

- add useClientStore export
- Updated dependencies
  - @scalar/api-client@0.1.12

## 0.1.13

### Patch Changes

- add store export
- Updated dependencies
  - @scalar/api-client@0.1.11

## 0.1.12

### Patch Changes

- add force show to client
- Updated dependencies
  - @scalar/api-client@0.1.10

## 0.1.11

### Patch Changes

- Updated dependencies
  - @scalar/api-client@0.1.9

## 0.1.10

### Patch Changes

- Updated dependencies
  - @scalar/api-client@0.1.8

## 0.1.9

### Patch Changes

- fix variables and missing styles
- Updated dependencies
  - @scalar/api-client@0.1.7

## 0.1.8

### Patch Changes

- 0d8f0f0: fix layout changes

## 0.1.7

### Patch Changes

- fix: issues with empty responses, minor styling issues
- Updated dependencies
  - @scalar/api-client@0.1.6
  - @scalar/swagger-editor@0.1.6

## 0.1.6

### Patch Changes

- style: improve default style
- Updated dependencies
  - @scalar/api-client@0.1.5
  - @scalar/swagger-editor@0.1.5

## 0.1.5

### Patch Changes

- fix: externalize dependencies
- Updated dependencies
  - @scalar/api-client@0.1.4
  - @scalar/swagger-editor@0.1.4
  - @scalar/use-clipboard@0.1.4
  - @scalar/use-tooltip@0.1.4

## 0.1.4

### Patch Changes

- fix: add CSS file to swagger editor
- Updated dependencies
  - @scalar/api-client@0.1.3
  - @scalar/swagger-editor@0.1.3
  - @scalar/use-clipboard@0.1.3
  - @scalar/use-codemirror@0.1.3
  - @scalar/use-tooltip@0.1.3

## 0.1.3

### Patch Changes

- e6f4941: fix: basic default styles

## 0.1.2

### Patch Changes

- 7cd41bc: fix: point main entry to dist folder
- Updated dependencies [7cd41bc]
  - @scalar/api-client@0.1.2
  - @scalar/swagger-editor@0.1.2
  - @scalar/use-clipboard@0.1.2
  - @scalar/use-codemirror@0.1.2
  - @scalar/use-tooltip@0.1.2

## 0.1.1

### Patch Changes

- f46e320: Initial release 👀
- Updated dependencies [f46e320]
  - @scalar/api-client@0.1.1
  - @scalar/swagger-editor@0.1.1
  - @scalar/use-clipboard@0.1.1
  - @scalar/use-codemirror@0.1.1
  - @scalar/use-tooltip@0.1.1
