import { type HttpClientState } from '../../../stores';
import type { ClientId, Target } from '@scalar/snippetz';
export type FeaturedClient = {
    targetKey: Target['key'];
    clientKey: ClientId<Target['key']>;
};
/**
 * Provides a list of featured http clients
 */
export declare function useFeaturedHttpClients(): {
    /** The featured http clients */
    featuredClients: FeaturedClient[];
    /** Whether a client is featured */
    isFeatured: (client: HttpClientState) => boolean;
};
//# sourceMappingURL=useFeaturedHttpClients.d.ts.map