import { defineComponent as $, computed as y, openBlock as l, createBlock as h, resolveDynamicComponent as M, normalizeClass as I, withCtx as m, createSlots as G, createTextVNode as D, toDisplayString as c, createCommentVNode as r, createElementBlock as a, createVNode as i, unref as s, Fragment as d, renderList as k, createElementVNode as f } from "vue";
import { Disclosure as J, DisclosurePanel as K, DisclosureButton as Q } from "@headlessui/vue";
import { ScalarMarkdown as S, ScalarIcon as W } from "@scalar/components";
import { optimizeValueForDisplay as X, discriminators as Y } from "./helpers/optimizeValueForDisplay.js";
import L from "./Schema.vue.js";
import O from "./SchemaDiscriminator.vue.js";
import x from "./SchemaPropertyHeading.vue.js";
import ee from "../../SpecificationExtension/SpecificationExtension.vue.js";
const ne = {
  key: 1,
  class: "property-description"
}, te = {
  key: 2,
  class: "property-description"
}, le = {
  key: 3,
  class: "property-enum"
}, oe = {
  key: 0,
  class: "property-list"
}, ae = { class: "property-heading" }, ie = { class: "property-name" }, se = { class: "property-description" }, re = {
  key: 1,
  class: "property-enum-values"
}, pe = { class: "property-enum-value-label" }, me = { class: "property-enum-value-label" }, ce = {
  key: 4,
  class: "children"
}, de = {
  key: 0,
  class: "children"
}, Be = /* @__PURE__ */ $({
  __name: "SchemaProperty",
  props: {
    is: {},
    value: {},
    noncollapsible: { type: Boolean },
    level: { default: 0 },
    name: {},
    required: { type: Boolean, default: !1 },
    compact: { type: Boolean, default: !1 },
    description: {},
    additional: { type: Boolean },
    pattern: { type: Boolean },
    withExamples: { type: Boolean, default: !0 },
    schemas: {},
    hideHeading: { type: Boolean }
  },
  setup(_) {
    const R = _, H = {
      integer: {
        _default: "Integer numbers.",
        int32: "Signed 32-bit integers (commonly used integer type).",
        int64: "Signed 64-bit integers (long type)."
      },
      string: {
        date: "full-date notation as defined by RFC 3339, section 5.6, for example, 2017-07-21",
        "date-time": "the date-time notation as defined by RFC 3339, section 5.6, for example, 2017-07-21T17:32:28Z",
        password: "a hint to UIs to mask the input",
        byte: "base64-encoded characters, for example, U3dhZ2dlciByb2Nrcw==",
        binary: "binary data, used to describe files"
      }
    }, B = (e, t) => t != null && t.properties || t != null && t.additionalProperties || t != null && t.patternProperties || t != null && t.allOf ? null : e || (t == null ? void 0 : t.description) || null, E = (e) => !e || !H[e.type] ? null : H[e.type][e.format || "_default"], p = (e) => {
      var t;
      return (e == null ? void 0 : e.enum) || ((t = e == null ? void 0 : e.items) == null ? void 0 : t.enum) || [];
    }, C = y(
      () => p(n.value).length > 9
    ), P = y(() => C.value ? 5 : 9), T = y(
      () => p(n.value).slice(0, P.value)
    ), U = y(
      () => p(n.value).slice(P.value)
    ), n = y(() => X(R.value)), Z = (e, t, g, b, v) => t || g || b || (e == null ? void 0 : e.deprecated) || (e == null ? void 0 : e.const) || (e == null ? void 0 : e.enum) && e.enum.length === 1 || (e == null ? void 0 : e.type) || (e == null ? void 0 : e.nullable) === !0 || (e == null ? void 0 : e.writeOnly) || (e == null ? void 0 : e.readOnly) || v;
    return (e, t) => {
      var g;
      return l(), h(M(e.is ?? "li"), {
        class: I(["property", [
          (B(e.description, n.value), ""),
          `property--level-${e.level}`,
          {
            "property--compact": e.compact,
            "property--deprecated": (g = n.value) == null ? void 0 : g.deprecated
          }
        ]])
      }, {
        default: m(() => {
          var b, v, w, q, A, F, N, V, j;
          return [
            Z(
              n.value,
              e.name,
              e.additional,
              e.pattern,
              e.required
            ) ? (l(), h(x, {
              key: 0,
              additional: e.additional,
              enum: p(n.value).length > 0,
              pattern: e.pattern,
              required: e.required,
              value: n.value
            }, G({ _: 2 }, [
              e.name ? {
                name: "name",
                fn: m(() => [
                  D(c(e.name), 1)
                ]),
                key: "0"
              } : void 0,
              (b = n.value) != null && b.example ? {
                name: "example",
                fn: m(() => [
                  D(" Example: " + c(n.value.example), 1)
                ]),
                key: "1"
              } : void 0
            ]), 1032, ["additional", "enum", "pattern", "required", "value"])) : r("", !0),
            B(e.description, n.value) ? (l(), a("div", ne, [
              i(s(S), {
                value: B(e.description, n.value)
              }, null, 8, ["value"])
            ])) : E(n.value) ? (l(), a("div", te, [
              i(s(S), {
                value: E(n.value) || ""
              }, null, 8, ["value"])
            ])) : r("", !0),
            ((v = p(n.value)) == null ? void 0 : v.length) > 0 ? (l(), a("div", le, [
              Array.isArray((w = n.value) == null ? void 0 : w["x-enumDescriptions"]) ? (l(), a("div", oe, [
                (l(!0), a(d, null, k(p(n.value), (o) => (l(), a("div", {
                  key: o,
                  class: "property"
                }, [
                  f("div", ae, [
                    f("div", ie, c(o), 1)
                  ]),
                  f("div", se, [
                    i(s(S), {
                      value: n.value["x-enumDescriptions"][o]
                    }, null, 8, ["value"])
                  ])
                ]))), 128))
              ])) : (l(), a("ul", re, [
                (l(!0), a(d, null, k(T.value, (o) => (l(), a("li", {
                  key: o,
                  class: "property-enum-value"
                }, [
                  f("span", pe, c(o), 1)
                ]))), 128)),
                C.value ? (l(), h(s(J), { key: 0 }, {
                  default: m(({ open: o }) => [
                    i(s(K), null, {
                      default: m(() => [
                        (l(!0), a(d, null, k(U.value, (u) => (l(), a("li", {
                          key: u,
                          class: "property-enum-value"
                        }, [
                          f("span", me, c(u), 1)
                        ]))), 128))
                      ]),
                      _: 1
                    }),
                    i(s(Q), { class: "enum-toggle-button" }, {
                      default: m(() => [
                        i(s(W), {
                          class: I(["enum-toggle-button-icon", { "enum-toggle-button-icon--open": o }]),
                          icon: "Add",
                          size: "sm"
                        }, null, 8, ["class"]),
                        D(" " + c(o ? "Hide values" : "Show all values"), 1)
                      ]),
                      _: 2
                    }, 1024)
                  ]),
                  _: 1
                })) : r("", !0)
              ]))
            ])) : r("", !0),
            ((q = n.value) == null ? void 0 : q.type) === "object" && ((A = n.value) != null && A.properties || (F = n.value) != null && F.additionalProperties) ? (l(), a("div", ce, [
              i(L, {
                compact: e.compact,
                level: e.level + 1,
                name: e.name,
                noncollapsible: e.noncollapsible,
                value: n.value
              }, null, 8, ["compact", "level", "name", "noncollapsible", "value"])
            ])) : r("", !0),
            (N = n.value) != null && N.items && typeof n.value.items == "object" && "type" in n.value.items && typeof n.value.items.type == "string" ? (l(), a(d, { key: 5 }, [
              ["object"].includes((j = (V = n.value) == null ? void 0 : V.items) == null ? void 0 : j.type) ? (l(), a("div", de, [
                i(L, {
                  compact: e.compact,
                  level: e.level + 1,
                  name: e.name,
                  noncollapsible: e.noncollapsible,
                  value: n.value.items
                }, null, 8, ["compact", "level", "name", "noncollapsible", "value"])
              ])) : r("", !0)
            ], 64)) : r("", !0),
            (l(!0), a(d, null, k(s(Y), (o) => {
              var u, z;
              return l(), a(d, { key: o }, [
                (u = n.value) != null && u[o] ? (l(), h(O, {
                  key: 0,
                  compact: e.compact,
                  discriminator: o,
                  hideHeading: e.hideHeading,
                  level: e.level,
                  name: e.name,
                  noncollapsible: e.noncollapsible,
                  schemas: e.schemas,
                  value: n.value
                }, null, 8, ["compact", "discriminator", "hideHeading", "level", "name", "noncollapsible", "schemas", "value"])) : (z = n.value) != null && z.items && typeof o == "string" && typeof n.value.items == "object" && o in n.value.items && Array.isArray(n.value.items[o]) && e.level < 3 ? (l(), h(O, {
                  key: 1,
                  compact: e.compact,
                  discriminator: o,
                  hideHeading: e.hideHeading,
                  level: e.level,
                  name: e.name,
                  noncollapsible: e.noncollapsible,
                  schemas: e.schemas,
                  value: n.value.items
                }, null, 8, ["compact", "discriminator", "hideHeading", "level", "name", "noncollapsible", "schemas", "value"])) : r("", !0)
              ], 64);
            }), 128)),
            i(s(ee), { value: n.value }, null, 8, ["value"])
          ];
        }),
        _: 1
      }, 8, ["class"]);
    };
  }
});
export {
  Be as default
};
