import type { ApiClient, CreateApiClientParams } from '@scalar/api-client/libs';
type Props = Pick<CreateApiClientParams, 'el' | 'configuration' | 'store'>;
/** API Client instance */
declare const client: import("vue").Ref<{
    onUpdateServer: (callback: (url: string) => void) => void;
    updateServer: (serverUrl: string) => void;
    open: (payload?: import("@scalar/api-client/libs").OpenClientPayload) => void;
    updateConfig: (_newConfig: Partial<import("@scalar/types/api-reference").ApiClientConfiguration>) => Promise<void>;
    updateAuth: <P extends import("@scalar/object-utils/nested").Path<import("@scalar/types/entities").SecurityScheme>>({ nameKey, propertyKey, value, }: {
        nameKey: string;
        propertyKey: P;
        value: NonNullable<import("@scalar/object-utils/nested").PathValue<import("@scalar/types/entities").SecurityScheme, P>>;
    }) => void;
    route: (payload?: import("@scalar/api-client/libs").OpenClientPayload) => void;
    mount: (mountingEl?: HTMLElement | null) => void;
    modalState: {
        open: boolean;
        show: () => void;
        hide: () => void;
    };
    updateExample: (exampleKey: string, operationId: string) => void;
    app: {
        unmount: () => void;
    };
    store: {
        hideClientButton: boolean;
        showSidebar: boolean;
        servers: Record<string, {
            uid: string & import("zod").BRAND<"server">;
            url: string;
            description?: string | undefined;
            variables?: Record<string, {
                value?: string | undefined;
                description?: string | undefined;
                default?: string | undefined;
                enum?: string[] | undefined;
            }> | undefined;
        }>;
        tags: Record<string, {
            uid: string & import("zod").BRAND<"tag">;
            name: string;
            type: "tag";
            children: ((string & import("zod").BRAND<"tag">) | (string & import("zod").BRAND<"operation">))[];
            description?: string | undefined;
            externalDocs?: {
                url: string;
                description?: string | undefined;
            } | undefined;
            "x-scalar-children"?: {
                tagName: string;
            }[] | undefined;
            "x-internal"?: boolean | undefined;
            "x-scalar-ignore"?: boolean | undefined;
        }>;
        securitySchemes: Record<string, {
            name: string;
            type: "apiKey";
            value: string;
            uid: string & import("zod").BRAND<"securityScheme">;
            nameKey: string;
            in: "cookie" | "query" | "header";
            description?: string | undefined;
        } | {
            type: "http";
            uid: string & import("zod").BRAND<"securityScheme">;
            nameKey: string;
            scheme: "basic" | "bearer";
            bearerFormat: string;
            username: string;
            password: string;
            token: string;
            description?: string | undefined;
        } | {
            type: "openIdConnect";
            uid: string & import("zod").BRAND<"securityScheme">;
            nameKey: string;
            openIdConnectUrl: string;
            description?: string | undefined;
        } | {
            type: "oauth2";
            uid: string & import("zod").BRAND<"securityScheme">;
            nameKey: string;
            flows: {
                password?: {
                    type: "password";
                    username: string;
                    password: string;
                    token: string;
                    refreshUrl: string;
                    scopes: Record<string, string>;
                    selectedScopes: string[];
                    "x-scalar-client-id": string;
                    tokenUrl: string;
                    clientSecret: string;
                } | undefined;
                implicit?: {
                    type: "implicit";
                    token: string;
                    refreshUrl: string;
                    scopes: Record<string, string>;
                    selectedScopes: string[];
                    "x-scalar-client-id": string;
                    authorizationUrl: string;
                    "x-scalar-redirect-uri": string;
                } | undefined;
                clientCredentials?: {
                    type: "clientCredentials";
                    token: string;
                    refreshUrl: string;
                    scopes: Record<string, string>;
                    selectedScopes: string[];
                    "x-scalar-client-id": string;
                    tokenUrl: string;
                    clientSecret: string;
                } | undefined;
                authorizationCode?: {
                    type: "authorizationCode";
                    token: string;
                    refreshUrl: string;
                    scopes: Record<string, string>;
                    selectedScopes: string[];
                    "x-scalar-client-id": string;
                    authorizationUrl: string;
                    "x-scalar-redirect-uri": string;
                    tokenUrl: string;
                    clientSecret: string;
                    "x-usePkce": "SHA-256" | "plain" | "no";
                } | undefined;
            };
            description?: string | undefined;
            "x-default-scopes"?: string | string[] | undefined;
        }>;
        cookies: Record<string, {
            uid: string & import("zod").BRAND<"cookie">;
            name: string;
            value: string;
            domain?: string | undefined;
            path?: string | undefined;
        }>;
        serverMutators: {
            rawAdd: (item: {
                uid: string & import("zod").BRAND<"server">;
                url: string;
                description?: string | undefined;
                variables?: Record<string, {
                    value?: string | undefined;
                    description?: string | undefined;
                    default?: string | undefined;
                    enum?: string[] | undefined;
                }> | undefined;
            }) => void;
            add: (payload: import("@scalar/oas-utils/entities/spec").ServerPayload, parentUid: string) => {
                uid: string & import("zod").BRAND<"server">;
                url: string;
                description?: string | undefined;
                variables?: Record<string, {
                    value?: string | undefined;
                    description?: string | undefined;
                    default?: string | undefined;
                    enum?: string[] | undefined;
                }> | undefined;
            };
            delete: (serverUid: import("@scalar/oas-utils/entities/spec").Server["uid"], collectionUid: import("@scalar/oas-utils/entities/spec").Collection["uid"]) => void;
            set: (item: {
                uid: string & import("zod").BRAND<"server">;
                url: string;
                description?: string | undefined;
                variables?: Record<string, {
                    value?: string | undefined;
                    description?: string | undefined;
                    default?: string | undefined;
                    enum?: string[] | undefined;
                }> | undefined;
            }) => void;
            edit: <P extends "url" | "description" | "uid" | "variables" | `variables.${string}`>(uid: (string & import("zod").BRAND<"server">) | null | undefined, path: P, value: P extends "url" | "description" | "uid" | "variables" ? {
                uid: string & import("zod").BRAND<"server">;
                url: string;
                description?: string | undefined;
                variables?: Record<string, {
                    value?: string | undefined;
                    description?: string | undefined;
                    default?: string | undefined;
                    enum?: string[] | undefined;
                }> | undefined;
            }[P] : P extends `${infer K}.${infer R}` ? K extends "url" | "description" | "uid" | "variables" ? R extends import("@scalar/object-utils/nested").Path<{
                uid: string & import("zod").BRAND<"server">;
                url: string;
                description?: string | undefined;
                variables?: Record<string, {
                    value?: string | undefined;
                    description?: string | undefined;
                    default?: string | undefined;
                    enum?: string[] | undefined;
                }> | undefined;
            }[K]> ? import("@scalar/object-utils/nested").PathValue<{
                uid: string & import("zod").BRAND<"server">;
                url: string;
                description?: string | undefined;
                variables?: Record<string, {
                    value?: string | undefined;
                    description?: string | undefined;
                    default?: string | undefined;
                    enum?: string[] | undefined;
                }> | undefined;
            }[K], R> : never : K extends `${number}` ? never : never : P extends `${number}` ? never : never) => void;
            untrackedEdit: <P extends "url" | "description" | "uid" | "variables" | `variables.${string}`>(uid: string & import("zod").BRAND<"server">, path: P, value: P extends "url" | "description" | "uid" | "variables" ? {
                uid: string & import("zod").BRAND<"server">;
                url: string;
                description?: string | undefined;
                variables?: Record<string, {
                    value?: string | undefined;
                    description?: string | undefined;
                    default?: string | undefined;
                    enum?: string[] | undefined;
                }> | undefined;
            }[P] : P extends `${infer K}.${infer R}` ? K extends "url" | "description" | "uid" | "variables" ? R extends import("@scalar/object-utils/nested").Path<{
                uid: string & import("zod").BRAND<"server">;
                url: string;
                description?: string | undefined;
                variables?: Record<string, {
                    value?: string | undefined;
                    description?: string | undefined;
                    default?: string | undefined;
                    enum?: string[] | undefined;
                }> | undefined;
            }[K]> ? import("@scalar/object-utils/nested").PathValue<{
                uid: string & import("zod").BRAND<"server">;
                url: string;
                description?: string | undefined;
                variables?: Record<string, {
                    value?: string | undefined;
                    description?: string | undefined;
                    default?: string | undefined;
                    enum?: string[] | undefined;
                }> | undefined;
            }[K], R> : never : K extends `${number}` ? never : never : P extends `${number}` ? never : never) => void;
            undo: (uid: string & import("zod").BRAND<"server">) => void;
            redo: (uid: string & import("zod").BRAND<"server">) => void;
            reset: () => void;
        };
        requests: Record<string, {
            uid: string & import("zod").BRAND<"operation">;
            path: string;
            type: "request";
            selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
            selectedServerUid: (string & import("zod").BRAND<"server">) | null;
            servers: (string & import("zod").BRAND<"server">)[];
            examples: (string & import("zod").BRAND<"example">)[];
            method: "options" | "connect" | "delete" | "get" | "head" | "patch" | "post" | "put" | "trace";
            description?: string | undefined;
            summary?: string | undefined;
            externalDocs?: {
                url: string;
                description?: string | undefined;
            } | undefined;
            "x-internal"?: boolean | undefined;
            "x-scalar-ignore"?: boolean | undefined;
            security?: Record<string, string[]>[] | undefined;
            tags?: string[] | undefined;
            deprecated?: boolean | undefined;
            operationId?: string | undefined;
            parameters?: {
                name: string;
                required: boolean;
                in: "cookie" | "path" | "query" | "header";
                deprecated: boolean;
                description?: string | undefined;
                example?: unknown;
                schema?: unknown;
                content?: unknown;
                style?: "matrix" | "simple" | "form" | "label" | "spaceDelimited" | "pipeDelimited" | "deepObject" | undefined;
                examples?: unknown[] | Record<string, {
                    value?: unknown;
                    summary?: string | undefined;
                }> | undefined;
            }[] | undefined;
            requestBody?: any;
            responses?: Record<string, any> | undefined;
            "x-codeSamples"?: {
                source: string;
                label?: string | undefined;
                lang?: string | undefined;
            }[] | undefined;
            "x-code-samples"?: {
                source: string;
                label?: string | undefined;
                lang?: string | undefined;
            }[] | undefined;
            "x-custom-examples"?: {
                source: string;
                label?: string | undefined;
                lang?: string | undefined;
            }[] | undefined;
            "x-scalar-stability"?: import("@scalar/types").XScalarStability | undefined;
        }>;
        collections: Record<string, {
            uid: string & import("zod").BRAND<"collection">;
            type: "collection";
            children: ((string & import("zod").BRAND<"tag">) | (string & import("zod").BRAND<"operation">))[];
            openapi: string;
            info: {
                title: string;
                version: string;
                description?: string | undefined;
                summary?: string | undefined;
                termsOfService?: string | undefined;
                contact?: {
                    name?: string | undefined;
                    url?: string | undefined;
                    email?: string | undefined;
                } | undefined;
                license?: {
                    name?: string | null | undefined;
                    identifier?: string | undefined;
                    url?: string | undefined;
                } | undefined;
            };
            security: Record<string, string[]>[];
            "x-scalar-icon": string;
            securitySchemes: string[];
            selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
            servers: (string & import("zod").BRAND<"server">)[];
            requests: (string & import("zod").BRAND<"operation">)[];
            tags: (string & import("zod").BRAND<"tag">)[];
            watchMode: boolean;
            useCollectionSecurity: boolean;
            watchModeStatus: "IDLE" | "WATCHING" | "ERROR";
            externalDocs?: {
                url: string;
                description?: string | undefined;
            } | undefined;
            jsonSchemaDialect?: string | undefined;
            components?: Record<string, unknown> | undefined;
            webhooks?: Record<string, unknown> | undefined;
            "x-scalar-active-environment"?: string | undefined;
            "x-scalar-environments"?: Record<string, {
                variables: Record<string, string | {
                    default: string;
                    description?: string | undefined;
                }>;
                color?: string | undefined;
                description?: string | undefined;
            }> | undefined;
            "x-scalar-secrets"?: Record<string, {
                description?: string | undefined;
                example?: string | undefined;
            }> | undefined;
            selectedServerUid?: (string & import("zod").BRAND<"server">) | undefined;
            documentUrl?: string | undefined;
            integration?: string | null | undefined;
        }>;
        requestExamples: Record<string, {
            uid: string & import("zod").BRAND<"example">;
            name: string;
            type: "requestExample";
            body: {
                activeBody: "formData" | "binary" | "raw";
                formData?: {
                    value: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        description?: string | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        enum?: string[] | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                    encoding: "form-data" | "urlencoded";
                } | undefined;
                binary?: Blob | undefined;
                raw?: {
                    value: string;
                    encoding: "xml" | "json" | "text" | "html" | "javascript" | "yaml" | "edn";
                    mimeType?: string | undefined;
                } | undefined;
            };
            parameters: {
                path: {
                    value: string;
                    key: string;
                    enabled: boolean;
                    minimum?: number | undefined;
                    type?: string | string[] | undefined;
                    maximum?: number | undefined;
                    description?: string | undefined;
                    default?: any;
                    required?: boolean | undefined;
                    examples?: string[] | undefined;
                    format?: string | undefined;
                    enum?: string[] | undefined;
                    file?: any;
                    nullable?: boolean | undefined;
                }[];
                query: {
                    value: string;
                    key: string;
                    enabled: boolean;
                    minimum?: number | undefined;
                    type?: string | string[] | undefined;
                    maximum?: number | undefined;
                    description?: string | undefined;
                    default?: any;
                    required?: boolean | undefined;
                    examples?: string[] | undefined;
                    format?: string | undefined;
                    enum?: string[] | undefined;
                    file?: any;
                    nullable?: boolean | undefined;
                }[];
                headers: {
                    value: string;
                    key: string;
                    enabled: boolean;
                    minimum?: number | undefined;
                    type?: string | string[] | undefined;
                    maximum?: number | undefined;
                    description?: string | undefined;
                    default?: any;
                    required?: boolean | undefined;
                    examples?: string[] | undefined;
                    format?: string | undefined;
                    enum?: string[] | undefined;
                    file?: any;
                    nullable?: boolean | undefined;
                }[];
                cookies: {
                    value: string;
                    key: string;
                    enabled: boolean;
                    minimum?: number | undefined;
                    type?: string | string[] | undefined;
                    maximum?: number | undefined;
                    description?: string | undefined;
                    default?: any;
                    required?: boolean | undefined;
                    examples?: string[] | undefined;
                    format?: string | undefined;
                    enum?: string[] | undefined;
                    file?: any;
                    nullable?: boolean | undefined;
                }[];
            };
            requestUid?: (string & import("zod").BRAND<"operation">) | undefined;
            serverVariables?: Record<string, string[]> | undefined;
        }>;
        requestExampleMutators: {
            rawAdd: (item: {
                uid: string & import("zod").BRAND<"example">;
                name: string;
                type: "requestExample";
                body: {
                    activeBody: "formData" | "binary" | "raw";
                    formData?: {
                        value: {
                            value: string;
                            key: string;
                            enabled: boolean;
                            minimum?: number | undefined;
                            type?: string | string[] | undefined;
                            maximum?: number | undefined;
                            description?: string | undefined;
                            default?: any;
                            required?: boolean | undefined;
                            examples?: string[] | undefined;
                            format?: string | undefined;
                            enum?: string[] | undefined;
                            file?: any;
                            nullable?: boolean | undefined;
                        }[];
                        encoding: "form-data" | "urlencoded";
                    } | undefined;
                    binary?: Blob | undefined;
                    raw?: {
                        value: string;
                        encoding: "xml" | "json" | "text" | "html" | "javascript" | "yaml" | "edn";
                        mimeType?: string | undefined;
                    } | undefined;
                };
                parameters: {
                    path: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        description?: string | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        enum?: string[] | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                    query: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        description?: string | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        enum?: string[] | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                    headers: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        description?: string | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        enum?: string[] | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                    cookies: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        description?: string | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        enum?: string[] | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                };
                requestUid?: (string & import("zod").BRAND<"operation">) | undefined;
                serverVariables?: Record<string, string[]> | undefined;
            }) => void;
            add: (request: import("@scalar/oas-utils/entities/spec").Request, _name?: string) => {
                uid: string & import("zod").BRAND<"example">;
                name: string;
                type: "requestExample";
                body: {
                    activeBody: "formData" | "binary" | "raw";
                    formData?: {
                        value: {
                            value: string;
                            key: string;
                            enabled: boolean;
                            minimum?: number | undefined;
                            type?: string | string[] | undefined;
                            maximum?: number | undefined;
                            description?: string | undefined;
                            default?: any;
                            required?: boolean | undefined;
                            examples?: string[] | undefined;
                            format?: string | undefined;
                            enum?: string[] | undefined;
                            file?: any;
                            nullable?: boolean | undefined;
                        }[];
                        encoding: "form-data" | "urlencoded";
                    } | undefined;
                    binary?: Blob | undefined;
                    raw?: {
                        value: string;
                        encoding: "xml" | "json" | "text" | "html" | "javascript" | "yaml" | "edn";
                        mimeType?: string | undefined;
                    } | undefined;
                };
                parameters: {
                    path: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        description?: string | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        enum?: string[] | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                    query: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        description?: string | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        enum?: string[] | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                    headers: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        description?: string | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        enum?: string[] | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                    cookies: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        description?: string | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        enum?: string[] | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                };
                requestUid?: (string & import("zod").BRAND<"operation">) | undefined;
                serverVariables?: Record<string, string[]> | undefined;
            };
            delete: (requestExample: import("@scalar/oas-utils/entities/spec").RequestExample) => void;
            set: (item: {
                uid: string & import("zod").BRAND<"example">;
                name: string;
                type: "requestExample";
                body: {
                    activeBody: "formData" | "binary" | "raw";
                    formData?: {
                        value: {
                            value: string;
                            key: string;
                            enabled: boolean;
                            minimum?: number | undefined;
                            type?: string | string[] | undefined;
                            maximum?: number | undefined;
                            description?: string | undefined;
                            default?: any;
                            required?: boolean | undefined;
                            examples?: string[] | undefined;
                            format?: string | undefined;
                            enum?: string[] | undefined;
                            file?: any;
                            nullable?: boolean | undefined;
                        }[];
                        encoding: "form-data" | "urlencoded";
                    } | undefined;
                    binary?: Blob | undefined;
                    raw?: {
                        value: string;
                        encoding: "xml" | "json" | "text" | "html" | "javascript" | "yaml" | "edn";
                        mimeType?: string | undefined;
                    } | undefined;
                };
                parameters: {
                    path: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        description?: string | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        enum?: string[] | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                    query: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        description?: string | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        enum?: string[] | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                    headers: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        description?: string | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        enum?: string[] | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                    cookies: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        description?: string | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        enum?: string[] | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                };
                requestUid?: (string & import("zod").BRAND<"operation">) | undefined;
                serverVariables?: Record<string, string[]> | undefined;
            }) => void;
            edit: <P extends "parameters" | "requestUid" | "type" | "name" | "uid" | "body" | "serverVariables" | "parameters.path" | "parameters.query" | "parameters.cookies" | `parameters.cookies.${number}` | "parameters.headers" | `parameters.path.${number}` | `parameters.path.${number}.description` | `parameters.path.${number}.examples` | `parameters.path.${number}.required` | `parameters.path.${number}.examples.${number}` | `parameters.path.${number}.default` | `parameters.path.${number}.value` | `parameters.path.${number}.type` | `parameters.path.${number}.key` | `parameters.path.${number}.file` | `parameters.path.${number}.enum` | `parameters.path.${number}.nullable` | `parameters.path.${number}.format` | `parameters.path.${number}.maximum` | `parameters.path.${number}.minimum` | `parameters.path.${number}.enum.${number}` | `parameters.path.${number}.enabled` | `parameters.path.${number}.default.${string}` | `parameters.path.${number}.type.${number}` | `parameters.path.${number}.file.${string}` | `parameters.query.${number}` | `parameters.query.${number}.description` | `parameters.query.${number}.examples` | `parameters.query.${number}.required` | `parameters.query.${number}.examples.${number}` | `parameters.query.${number}.default` | `parameters.query.${number}.value` | `parameters.query.${number}.type` | `parameters.query.${number}.key` | `parameters.query.${number}.file` | `parameters.query.${number}.enum` | `parameters.query.${number}.nullable` | `parameters.query.${number}.format` | `parameters.query.${number}.maximum` | `parameters.query.${number}.minimum` | `parameters.query.${number}.enum.${number}` | `parameters.query.${number}.enabled` | `parameters.query.${number}.default.${string}` | `parameters.query.${number}.type.${number}` | `parameters.query.${number}.file.${string}` | `parameters.cookies.${number}.description` | `parameters.cookies.${number}.examples` | `parameters.cookies.${number}.required` | `parameters.cookies.${number}.examples.${number}` | `parameters.cookies.${number}.default` | `parameters.cookies.${number}.value` | `parameters.cookies.${number}.type` | `parameters.cookies.${number}.key` | `parameters.cookies.${number}.file` | `parameters.cookies.${number}.enum` | `parameters.cookies.${number}.nullable` | `parameters.cookies.${number}.format` | `parameters.cookies.${number}.maximum` | `parameters.cookies.${number}.minimum` | `parameters.cookies.${number}.enum.${number}` | `parameters.cookies.${number}.enabled` | `parameters.cookies.${number}.default.${string}` | `parameters.cookies.${number}.type.${number}` | `parameters.cookies.${number}.file.${string}` | `parameters.headers.${number}` | `parameters.headers.${number}.description` | `parameters.headers.${number}.examples` | `parameters.headers.${number}.required` | `parameters.headers.${number}.examples.${number}` | `parameters.headers.${number}.default` | `parameters.headers.${number}.value` | `parameters.headers.${number}.type` | `parameters.headers.${number}.key` | `parameters.headers.${number}.file` | `parameters.headers.${number}.enum` | `parameters.headers.${number}.nullable` | `parameters.headers.${number}.format` | `parameters.headers.${number}.maximum` | `parameters.headers.${number}.minimum` | `parameters.headers.${number}.enum.${number}` | `parameters.headers.${number}.enabled` | `parameters.headers.${number}.default.${string}` | `parameters.headers.${number}.type.${number}` | `parameters.headers.${number}.file.${string}` | "body.formData" | "body.binary" | "body.raw" | "body.activeBody" | "body.formData.value" | "body.formData.encoding" | `body.formData.value.${number}` | `body.formData.value.${number}.description` | `body.formData.value.${number}.examples` | `body.formData.value.${number}.required` | `body.formData.value.${number}.examples.${number}` | `body.formData.value.${number}.default` | `body.formData.value.${number}.value` | `body.formData.value.${number}.type` | `body.formData.value.${number}.key` | `body.formData.value.${number}.file` | `body.formData.value.${number}.enum` | `body.formData.value.${number}.nullable` | `body.formData.value.${number}.format` | `body.formData.value.${number}.maximum` | `body.formData.value.${number}.minimum` | `body.formData.value.${number}.enum.${number}` | `body.formData.value.${number}.enabled` | `body.formData.value.${number}.default.${string}` | `body.formData.value.${number}.type.${number}` | `body.formData.value.${number}.file.${string}` | "body.binary.size" | "body.binary.slice" | "body.binary.type" | "body.binary.text" | "body.binary.arrayBuffer" | "body.binary.stream" | "body.raw.value" | "body.raw.encoding" | "body.raw.mimeType" | `serverVariables.${string}`>(uid: (string & import("zod").BRAND<"example">) | null | undefined, path: P, value: P extends "parameters" | "requestUid" | "type" | "name" | "uid" | "body" | "serverVariables" ? {
                uid: string & import("zod").BRAND<"example">;
                name: string;
                type: "requestExample";
                body: {
                    activeBody: "formData" | "binary" | "raw";
                    formData?: {
                        value: {
                            value: string;
                            key: string;
                            enabled: boolean;
                            minimum?: number | undefined;
                            type?: string | string[] | undefined;
                            maximum?: number | undefined;
                            description?: string | undefined;
                            default?: any;
                            required?: boolean | undefined;
                            examples?: string[] | undefined;
                            format?: string | undefined;
                            enum?: string[] | undefined;
                            file?: any;
                            nullable?: boolean | undefined;
                        }[];
                        encoding: "form-data" | "urlencoded";
                    } | undefined;
                    binary?: Blob | undefined;
                    raw?: {
                        value: string;
                        encoding: "xml" | "json" | "text" | "html" | "javascript" | "yaml" | "edn";
                        mimeType?: string | undefined;
                    } | undefined;
                };
                parameters: {
                    path: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        description?: string | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        enum?: string[] | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                    query: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        description?: string | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        enum?: string[] | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                    headers: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        description?: string | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        enum?: string[] | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                    cookies: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        description?: string | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        enum?: string[] | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                };
                requestUid?: (string & import("zod").BRAND<"operation">) | undefined;
                serverVariables?: Record<string, string[]> | undefined;
            }[P] : P extends `${infer K}.${infer R}` ? K extends "parameters" | "requestUid" | "type" | "name" | "uid" | "body" | "serverVariables" ? R extends import("@scalar/object-utils/nested").Path<{
                uid: string & import("zod").BRAND<"example">;
                name: string;
                type: "requestExample";
                body: {
                    activeBody: "formData" | "binary" | "raw";
                    formData?: {
                        value: {
                            value: string;
                            key: string;
                            enabled: boolean;
                            minimum?: number | undefined;
                            type?: string | string[] | undefined;
                            maximum?: number | undefined;
                            description?: string | undefined;
                            default?: any;
                            required?: boolean | undefined;
                            examples?: string[] | undefined;
                            format?: string | undefined;
                            enum?: string[] | undefined;
                            file?: any;
                            nullable?: boolean | undefined;
                        }[];
                        encoding: "form-data" | "urlencoded";
                    } | undefined;
                    binary?: Blob | undefined;
                    raw?: {
                        value: string;
                        encoding: "xml" | "json" | "text" | "html" | "javascript" | "yaml" | "edn";
                        mimeType?: string | undefined;
                    } | undefined;
                };
                parameters: {
                    path: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        description?: string | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        enum?: string[] | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                    query: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        description?: string | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        enum?: string[] | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                    headers: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        description?: string | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        enum?: string[] | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                    cookies: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        description?: string | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        enum?: string[] | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                };
                requestUid?: (string & import("zod").BRAND<"operation">) | undefined;
                serverVariables?: Record<string, string[]> | undefined;
            }[K]> ? import("@scalar/object-utils/nested").PathValue<{
                uid: string & import("zod").BRAND<"example">;
                name: string;
                type: "requestExample";
                body: {
                    activeBody: "formData" | "binary" | "raw";
                    formData?: {
                        value: {
                            value: string;
                            key: string;
                            enabled: boolean;
                            minimum?: number | undefined;
                            type?: string | string[] | undefined;
                            maximum?: number | undefined;
                            description?: string | undefined;
                            default?: any;
                            required?: boolean | undefined;
                            examples?: string[] | undefined;
                            format?: string | undefined;
                            enum?: string[] | undefined;
                            file?: any;
                            nullable?: boolean | undefined;
                        }[];
                        encoding: "form-data" | "urlencoded";
                    } | undefined;
                    binary?: Blob | undefined;
                    raw?: {
                        value: string;
                        encoding: "xml" | "json" | "text" | "html" | "javascript" | "yaml" | "edn";
                        mimeType?: string | undefined;
                    } | undefined;
                };
                parameters: {
                    path: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        description?: string | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        enum?: string[] | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                    query: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        description?: string | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        enum?: string[] | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                    headers: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        description?: string | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        enum?: string[] | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                    cookies: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        description?: string | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        enum?: string[] | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                };
                requestUid?: (string & import("zod").BRAND<"operation">) | undefined;
                serverVariables?: Record<string, string[]> | undefined;
            }[K], R> : never : K extends `${number}` ? never : never : P extends `${number}` ? never : never) => void;
            untrackedEdit: <P extends "parameters" | "requestUid" | "type" | "name" | "uid" | "body" | "serverVariables" | "parameters.path" | "parameters.query" | "parameters.cookies" | `parameters.cookies.${number}` | "parameters.headers" | `parameters.path.${number}` | `parameters.path.${number}.description` | `parameters.path.${number}.examples` | `parameters.path.${number}.required` | `parameters.path.${number}.examples.${number}` | `parameters.path.${number}.default` | `parameters.path.${number}.value` | `parameters.path.${number}.type` | `parameters.path.${number}.key` | `parameters.path.${number}.file` | `parameters.path.${number}.enum` | `parameters.path.${number}.nullable` | `parameters.path.${number}.format` | `parameters.path.${number}.maximum` | `parameters.path.${number}.minimum` | `parameters.path.${number}.enum.${number}` | `parameters.path.${number}.enabled` | `parameters.path.${number}.default.${string}` | `parameters.path.${number}.type.${number}` | `parameters.path.${number}.file.${string}` | `parameters.query.${number}` | `parameters.query.${number}.description` | `parameters.query.${number}.examples` | `parameters.query.${number}.required` | `parameters.query.${number}.examples.${number}` | `parameters.query.${number}.default` | `parameters.query.${number}.value` | `parameters.query.${number}.type` | `parameters.query.${number}.key` | `parameters.query.${number}.file` | `parameters.query.${number}.enum` | `parameters.query.${number}.nullable` | `parameters.query.${number}.format` | `parameters.query.${number}.maximum` | `parameters.query.${number}.minimum` | `parameters.query.${number}.enum.${number}` | `parameters.query.${number}.enabled` | `parameters.query.${number}.default.${string}` | `parameters.query.${number}.type.${number}` | `parameters.query.${number}.file.${string}` | `parameters.cookies.${number}.description` | `parameters.cookies.${number}.examples` | `parameters.cookies.${number}.required` | `parameters.cookies.${number}.examples.${number}` | `parameters.cookies.${number}.default` | `parameters.cookies.${number}.value` | `parameters.cookies.${number}.type` | `parameters.cookies.${number}.key` | `parameters.cookies.${number}.file` | `parameters.cookies.${number}.enum` | `parameters.cookies.${number}.nullable` | `parameters.cookies.${number}.format` | `parameters.cookies.${number}.maximum` | `parameters.cookies.${number}.minimum` | `parameters.cookies.${number}.enum.${number}` | `parameters.cookies.${number}.enabled` | `parameters.cookies.${number}.default.${string}` | `parameters.cookies.${number}.type.${number}` | `parameters.cookies.${number}.file.${string}` | `parameters.headers.${number}` | `parameters.headers.${number}.description` | `parameters.headers.${number}.examples` | `parameters.headers.${number}.required` | `parameters.headers.${number}.examples.${number}` | `parameters.headers.${number}.default` | `parameters.headers.${number}.value` | `parameters.headers.${number}.type` | `parameters.headers.${number}.key` | `parameters.headers.${number}.file` | `parameters.headers.${number}.enum` | `parameters.headers.${number}.nullable` | `parameters.headers.${number}.format` | `parameters.headers.${number}.maximum` | `parameters.headers.${number}.minimum` | `parameters.headers.${number}.enum.${number}` | `parameters.headers.${number}.enabled` | `parameters.headers.${number}.default.${string}` | `parameters.headers.${number}.type.${number}` | `parameters.headers.${number}.file.${string}` | "body.formData" | "body.binary" | "body.raw" | "body.activeBody" | "body.formData.value" | "body.formData.encoding" | `body.formData.value.${number}` | `body.formData.value.${number}.description` | `body.formData.value.${number}.examples` | `body.formData.value.${number}.required` | `body.formData.value.${number}.examples.${number}` | `body.formData.value.${number}.default` | `body.formData.value.${number}.value` | `body.formData.value.${number}.type` | `body.formData.value.${number}.key` | `body.formData.value.${number}.file` | `body.formData.value.${number}.enum` | `body.formData.value.${number}.nullable` | `body.formData.value.${number}.format` | `body.formData.value.${number}.maximum` | `body.formData.value.${number}.minimum` | `body.formData.value.${number}.enum.${number}` | `body.formData.value.${number}.enabled` | `body.formData.value.${number}.default.${string}` | `body.formData.value.${number}.type.${number}` | `body.formData.value.${number}.file.${string}` | "body.binary.size" | "body.binary.slice" | "body.binary.type" | "body.binary.text" | "body.binary.arrayBuffer" | "body.binary.stream" | "body.raw.value" | "body.raw.encoding" | "body.raw.mimeType" | `serverVariables.${string}`>(uid: string & import("zod").BRAND<"example">, path: P, value: P extends "parameters" | "requestUid" | "type" | "name" | "uid" | "body" | "serverVariables" ? {
                uid: string & import("zod").BRAND<"example">;
                name: string;
                type: "requestExample";
                body: {
                    activeBody: "formData" | "binary" | "raw";
                    formData?: {
                        value: {
                            value: string;
                            key: string;
                            enabled: boolean;
                            minimum?: number | undefined;
                            type?: string | string[] | undefined;
                            maximum?: number | undefined;
                            description?: string | undefined;
                            default?: any;
                            required?: boolean | undefined;
                            examples?: string[] | undefined;
                            format?: string | undefined;
                            enum?: string[] | undefined;
                            file?: any;
                            nullable?: boolean | undefined;
                        }[];
                        encoding: "form-data" | "urlencoded";
                    } | undefined;
                    binary?: Blob | undefined;
                    raw?: {
                        value: string;
                        encoding: "xml" | "json" | "text" | "html" | "javascript" | "yaml" | "edn";
                        mimeType?: string | undefined;
                    } | undefined;
                };
                parameters: {
                    path: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        description?: string | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        enum?: string[] | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                    query: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        description?: string | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        enum?: string[] | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                    headers: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        description?: string | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        enum?: string[] | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                    cookies: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        description?: string | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        enum?: string[] | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                };
                requestUid?: (string & import("zod").BRAND<"operation">) | undefined;
                serverVariables?: Record<string, string[]> | undefined;
            }[P] : P extends `${infer K}.${infer R}` ? K extends "parameters" | "requestUid" | "type" | "name" | "uid" | "body" | "serverVariables" ? R extends import("@scalar/object-utils/nested").Path<{
                uid: string & import("zod").BRAND<"example">;
                name: string;
                type: "requestExample";
                body: {
                    activeBody: "formData" | "binary" | "raw";
                    formData?: {
                        value: {
                            value: string;
                            key: string;
                            enabled: boolean;
                            minimum?: number | undefined;
                            type?: string | string[] | undefined;
                            maximum?: number | undefined;
                            description?: string | undefined;
                            default?: any;
                            required?: boolean | undefined;
                            examples?: string[] | undefined;
                            format?: string | undefined;
                            enum?: string[] | undefined;
                            file?: any;
                            nullable?: boolean | undefined;
                        }[];
                        encoding: "form-data" | "urlencoded";
                    } | undefined;
                    binary?: Blob | undefined;
                    raw?: {
                        value: string;
                        encoding: "xml" | "json" | "text" | "html" | "javascript" | "yaml" | "edn";
                        mimeType?: string | undefined;
                    } | undefined;
                };
                parameters: {
                    path: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        description?: string | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        enum?: string[] | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                    query: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        description?: string | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        enum?: string[] | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                    headers: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        description?: string | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        enum?: string[] | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                    cookies: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        description?: string | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        enum?: string[] | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                };
                requestUid?: (string & import("zod").BRAND<"operation">) | undefined;
                serverVariables?: Record<string, string[]> | undefined;
            }[K]> ? import("@scalar/object-utils/nested").PathValue<{
                uid: string & import("zod").BRAND<"example">;
                name: string;
                type: "requestExample";
                body: {
                    activeBody: "formData" | "binary" | "raw";
                    formData?: {
                        value: {
                            value: string;
                            key: string;
                            enabled: boolean;
                            minimum?: number | undefined;
                            type?: string | string[] | undefined;
                            maximum?: number | undefined;
                            description?: string | undefined;
                            default?: any;
                            required?: boolean | undefined;
                            examples?: string[] | undefined;
                            format?: string | undefined;
                            enum?: string[] | undefined;
                            file?: any;
                            nullable?: boolean | undefined;
                        }[];
                        encoding: "form-data" | "urlencoded";
                    } | undefined;
                    binary?: Blob | undefined;
                    raw?: {
                        value: string;
                        encoding: "xml" | "json" | "text" | "html" | "javascript" | "yaml" | "edn";
                        mimeType?: string | undefined;
                    } | undefined;
                };
                parameters: {
                    path: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        description?: string | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        enum?: string[] | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                    query: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        description?: string | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        enum?: string[] | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                    headers: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        description?: string | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        enum?: string[] | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                    cookies: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        description?: string | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        enum?: string[] | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                };
                requestUid?: (string & import("zod").BRAND<"operation">) | undefined;
                serverVariables?: Record<string, string[]> | undefined;
            }[K], R> : never : K extends `${number}` ? never : never : P extends `${number}` ? never : never) => void;
            undo: (uid: string & import("zod").BRAND<"example">) => void;
            redo: (uid: string & import("zod").BRAND<"example">) => void;
            reset: () => void;
        };
        modalState: {
            open: boolean;
            show: () => void;
            hide: () => void;
        };
        workspaces: Record<string, {
            uid: string & import("zod").BRAND<"workspace">;
            name: string;
            description: string;
            cookies: (string & import("zod").BRAND<"cookie">)[];
            collections: (string & import("zod").BRAND<"collection">)[];
            environments: Record<string, string>;
            activeEnvironmentId: string;
            themeId: "default" | "alternate" | "moon" | "purple" | "solarized" | "bluePlanet" | "deepSpace" | "saturn" | "kepler" | "elysiajs" | "fastify" | "mars" | "laserwave" | "none";
            selectedHttpClient: {
                targetKey: string;
                clientKey: string;
            };
            hotKeyConfig?: {
                modifiers: ("default" | "Meta" | "Control" | "Shift" | "Alt")[];
                hotKeys?: Partial<Record<"" | "0" | "Space" | "Backspace" | "Tab" | "Enter" | "Escape" | "ArrowDown" | "ArrowLeft" | "ArrowRight" | "ArrowUp" | "End" | "Home" | "PageDown" | "PageUp" | "Delete" | "1" | "2" | "3" | "4" | "5" | "6" | "7" | "8" | "9" | "a" | "b" | "c" | "d" | "e" | "f" | "g" | "h" | "i" | "j" | "k" | "l" | "m" | "n" | "o" | "p" | "q" | "r" | "s" | "t" | "u" | "v" | "w" | "x" | "y" | "z" | "*" | "+" | "-" | "." | "/" | "F1" | "F2" | "F3" | "F4" | "F5" | "F6" | "F7" | "F8" | "F9" | "F10" | "F11" | "F12" | ";" | "=" | "," | "`" | "[" | "\\" | "]", {
                    event: "addTopNav" | "closeModal" | "closeTopNav" | "createNew" | "executeRequest" | "focusAddressBar" | "focusRequestSearch" | "jumpToLastTab" | "jumpToTab" | "navigateSearchResultsDown" | "navigateSearchResultsUp" | "navigateTopNavLeft" | "navigateTopNavRight" | "openCommandPalette" | "selectSearchResult" | "toggleSidebar";
                    modifiers?: ("default" | "Meta" | "Control" | "Shift" | "Alt")[] | undefined;
                }>> | undefined;
            } | undefined;
            proxyUrl?: string | undefined;
        }>;
        environments: Record<string, {
            uid: string & import("zod").BRAND<"environment">;
            name: string;
            value: string;
            color: string;
            isDefault?: boolean | undefined;
        }>;
        setSidebarWidth: (width: string) => void;
        integration: "elysiajs" | "fastify" | "go" | "adonisjs" | "docusaurus" | "dotnet" | "express" | "fastapi" | "hono" | "html" | "laravel" | "litestar" | "nestjs" | "nextjs" | "nitro" | "nuxt" | "platformatic" | "react" | "rust" | "vue" | null | undefined;
        importSpecFile: (_spec: string | Record<string, any>, workspaceUid: string, options?: Pick<{
            uid?: string | undefined;
            type?: "collection" | undefined;
            externalDocs?: {
                url: string;
                description?: unknown;
            } | undefined;
            children?: string[] | undefined;
            openapi?: string | undefined;
            jsonSchemaDialect?: string | undefined;
            info?: unknown;
            security?: Record<string, string[] | undefined>[] | undefined;
            components?: Record<string, unknown> | undefined;
            webhooks?: Record<string, unknown> | undefined;
            "x-scalar-icon"?: string | undefined;
            "x-scalar-active-environment"?: string | undefined;
            "x-scalar-environments"?: Record<string, {
                variables: Record<string, string | {
                    description?: string | undefined;
                    default?: string | undefined;
                }>;
                color?: string | undefined;
                description?: string | undefined;
            }> | undefined;
            "x-scalar-secrets"?: Record<string, {
                description?: string | undefined;
                example?: string | undefined;
            }> | undefined;
            securitySchemes?: string[] | undefined;
            selectedSecuritySchemeUids?: (string | string[])[] | undefined;
            selectedServerUid?: string | undefined;
            servers?: string[] | undefined;
            requests?: string[] | undefined;
            tags?: string[] | undefined;
            documentUrl?: string | undefined;
            watchMode?: boolean | undefined;
            integration?: string | null | undefined;
            useCollectionSecurity?: boolean | undefined;
            watchModeStatus?: "IDLE" | "WATCHING" | "ERROR" | undefined;
        }, "watchMode" | "documentUrl"> & Pick<import("@scalar/types/api-reference").ApiReferenceConfiguration, "slug" | "authentication" | "baseServerURL" | "servers"> & {
            useCollectionSecurity?: boolean;
            shouldLoad?: boolean;
        } & Pick<import("@scalar/types/api-reference").ApiReferenceConfiguration, "servers">) => Promise<{
            error: false;
            collection: import("@scalar/oas-utils/entities/spec").Collection;
            requests: import("@scalar/oas-utils/entities/spec").Request[];
            schema: import("@scalar/openapi-types").OpenAPIV3_1.Document;
            examples: import("@scalar/oas-utils/entities/spec").RequestExample[];
            servers: import("@scalar/oas-utils/entities/spec").Server[];
            tags: import("@scalar/oas-utils/entities/spec").Tag[];
            securitySchemes: import("@scalar/types/entities").SecurityScheme[];
        } | undefined>;
        importSpecFromUrl: (url: string, workspaceUid: string, { proxyUrl, ...options }?: Omit<Pick<{
            uid?: string | undefined;
            type?: "collection" | undefined;
            externalDocs?: {
                url: string;
                description?: unknown;
            } | undefined;
            children?: string[] | undefined;
            openapi?: string | undefined;
            jsonSchemaDialect?: string | undefined;
            info?: unknown;
            security?: Record<string, string[] | undefined>[] | undefined;
            components?: Record<string, unknown> | undefined;
            webhooks?: Record<string, unknown> | undefined;
            "x-scalar-icon"?: string | undefined;
            "x-scalar-active-environment"?: string | undefined;
            "x-scalar-environments"?: Record<string, {
                variables: Record<string, string | {
                    description?: string | undefined;
                    default?: string | undefined;
                }>;
                color?: string | undefined;
                description?: string | undefined;
            }> | undefined;
            "x-scalar-secrets"?: Record<string, {
                description?: string | undefined;
                example?: string | undefined;
            }> | undefined;
            securitySchemes?: string[] | undefined;
            selectedSecuritySchemeUids?: (string | string[])[] | undefined;
            selectedServerUid?: string | undefined;
            servers?: string[] | undefined;
            requests?: string[] | undefined;
            tags?: string[] | undefined;
            documentUrl?: string | undefined;
            watchMode?: boolean | undefined;
            integration?: string | null | undefined;
            useCollectionSecurity?: boolean | undefined;
            watchModeStatus?: "IDLE" | "WATCHING" | "ERROR" | undefined;
        }, "watchMode" | "documentUrl"> & Pick<import("@scalar/types/api-reference").ApiReferenceConfiguration, "slug" | "authentication" | "baseServerURL" | "servers"> & {
            useCollectionSecurity?: boolean;
            shouldLoad?: boolean;
        } & Pick<import("@scalar/types/api-reference").ApiReferenceConfiguration, "servers">, "documentUrl"> & Pick<import("@scalar/types/api-reference").ApiReferenceConfiguration, "proxyUrl">) => Promise<import("@scalar/api-client/libs").ErrorResponse<Awaited<ReturnType<(_spec: string | Record<string, any>, workspaceUid: string, options?: Pick<{
            uid?: string | undefined;
            type?: "collection" | undefined;
            externalDocs?: {
                url: string;
                description?: unknown;
            } | undefined;
            children?: string[] | undefined;
            openapi?: string | undefined;
            jsonSchemaDialect?: string | undefined;
            info?: unknown;
            security?: Record<string, string[] | undefined>[] | undefined;
            components?: Record<string, unknown> | undefined;
            webhooks?: Record<string, unknown> | undefined;
            "x-scalar-icon"?: string | undefined;
            "x-scalar-active-environment"?: string | undefined;
            "x-scalar-environments"?: Record<string, {
                variables: Record<string, string | {
                    description?: string | undefined;
                    default?: string | undefined;
                }>;
                color?: string | undefined;
                description?: string | undefined;
            }> | undefined;
            "x-scalar-secrets"?: Record<string, {
                description?: string | undefined;
                example?: string | undefined;
            }> | undefined;
            securitySchemes?: string[] | undefined;
            selectedSecuritySchemeUids?: (string | string[])[] | undefined;
            selectedServerUid?: string | undefined;
            servers?: string[] | undefined;
            requests?: string[] | undefined;
            tags?: string[] | undefined;
            documentUrl?: string | undefined;
            watchMode?: boolean | undefined;
            integration?: string | null | undefined;
            useCollectionSecurity?: boolean | undefined;
            watchModeStatus?: "IDLE" | "WATCHING" | "ERROR" | undefined;
        }, "watchMode" | "documentUrl"> & Pick<import("@scalar/types/api-reference").ApiReferenceConfiguration, "slug" | "authentication" | "baseServerURL" | "servers"> & {
            useCollectionSecurity?: boolean;
            shouldLoad?: boolean;
        } & Pick<import("@scalar/types/api-reference").ApiReferenceConfiguration, "servers">) => Promise<{
            error: false;
            collection: import("@scalar/oas-utils/entities/spec").Collection;
            requests: import("@scalar/oas-utils/entities/spec").Request[];
            schema: import("@scalar/openapi-types").OpenAPIV3_1.Document;
            examples: import("@scalar/oas-utils/entities/spec").RequestExample[];
            servers: import("@scalar/oas-utils/entities/spec").Server[];
            tags: import("@scalar/oas-utils/entities/spec").Tag[];
            securitySchemes: import("@scalar/types/entities").SecurityScheme[];
        } | undefined>>>>>;
        cookieMutators: {
            add: (item: {
                uid: string & import("zod").BRAND<"cookie">;
                name: string;
                value: string;
                domain?: string | undefined;
                path?: string | undefined;
            }) => void;
            delete: (uid: (string & import("zod").BRAND<"cookie">) | null | undefined) => void;
            set: (item: {
                uid: string & import("zod").BRAND<"cookie">;
                name: string;
                value: string;
                domain?: string | undefined;
                path?: string | undefined;
            }) => void;
            edit: <P extends "value" | "path" | "name" | "uid" | "domain">(uid: (string & import("zod").BRAND<"cookie">) | null | undefined, path: P, value: P extends "value" | "path" | "name" | "uid" | "domain" ? {
                uid: string & import("zod").BRAND<"cookie">;
                name: string;
                value: string;
                domain?: string | undefined;
                path?: string | undefined;
            }[P] : P extends `${infer K}.${infer R}` ? K extends "value" | "path" | "name" | "uid" | "domain" ? R extends import("@scalar/object-utils/nested").Path<{
                uid: string & import("zod").BRAND<"cookie">;
                name: string;
                value: string;
                domain?: string | undefined;
                path?: string | undefined;
            }[K]> ? import("@scalar/object-utils/nested").PathValue<{
                uid: string & import("zod").BRAND<"cookie">;
                name: string;
                value: string;
                domain?: string | undefined;
                path?: string | undefined;
            }[K], R> : never : K extends `${number}` ? never : never : P extends `${number}` ? never : never) => void;
            untrackedEdit: <P extends "value" | "path" | "name" | "uid" | "domain">(uid: string & import("zod").BRAND<"cookie">, path: P, value: P extends "value" | "path" | "name" | "uid" | "domain" ? {
                uid: string & import("zod").BRAND<"cookie">;
                name: string;
                value: string;
                domain?: string | undefined;
                path?: string | undefined;
            }[P] : P extends `${infer K}.${infer R}` ? K extends "value" | "path" | "name" | "uid" | "domain" ? R extends import("@scalar/object-utils/nested").Path<{
                uid: string & import("zod").BRAND<"cookie">;
                name: string;
                value: string;
                domain?: string | undefined;
                path?: string | undefined;
            }[K]> ? import("@scalar/object-utils/nested").PathValue<{
                uid: string & import("zod").BRAND<"cookie">;
                name: string;
                value: string;
                domain?: string | undefined;
                path?: string | undefined;
            }[K], R> : never : K extends `${number}` ? never : never : P extends `${number}` ? never : never) => void;
            undo: (uid: string & import("zod").BRAND<"cookie">) => void;
            redo: (uid: string & import("zod").BRAND<"cookie">) => void;
            reset: () => void;
        };
        collectionMutators: {
            rawAdd: (item: {
                uid: string & import("zod").BRAND<"collection">;
                type: "collection";
                children: ((string & import("zod").BRAND<"tag">) | (string & import("zod").BRAND<"operation">))[];
                openapi: string;
                info: {
                    title: string;
                    version: string;
                    description?: string | undefined;
                    summary?: string | undefined;
                    termsOfService?: string | undefined;
                    contact?: {
                        name?: string | undefined;
                        url?: string | undefined;
                        email?: string | undefined;
                    } | undefined;
                    license?: {
                        name?: string | null | undefined;
                        identifier?: string | undefined;
                        url?: string | undefined;
                    } | undefined;
                };
                security: Record<string, string[]>[];
                "x-scalar-icon": string;
                securitySchemes: string[];
                selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
                servers: (string & import("zod").BRAND<"server">)[];
                requests: (string & import("zod").BRAND<"operation">)[];
                tags: (string & import("zod").BRAND<"tag">)[];
                watchMode: boolean;
                useCollectionSecurity: boolean;
                watchModeStatus: "IDLE" | "WATCHING" | "ERROR";
                externalDocs?: {
                    url: string;
                    description?: string | undefined;
                } | undefined;
                jsonSchemaDialect?: string | undefined;
                components?: Record<string, unknown> | undefined;
                webhooks?: Record<string, unknown> | undefined;
                "x-scalar-active-environment"?: string | undefined;
                "x-scalar-environments"?: Record<string, {
                    variables: Record<string, string | {
                        default: string;
                        description?: string | undefined;
                    }>;
                    color?: string | undefined;
                    description?: string | undefined;
                }> | undefined;
                "x-scalar-secrets"?: Record<string, {
                    description?: string | undefined;
                    example?: string | undefined;
                }> | undefined;
                selectedServerUid?: (string & import("zod").BRAND<"server">) | undefined;
                documentUrl?: string | undefined;
                integration?: string | null | undefined;
            }) => void;
            add: (payload: import("@scalar/oas-utils/entities/spec").CollectionPayload, workspaceUid: import("@scalar/oas-utils/entities/workspace").Workspace["uid"]) => {
                uid: string & import("zod").BRAND<"collection">;
                type: "collection";
                children: ((string & import("zod").BRAND<"tag">) | (string & import("zod").BRAND<"operation">))[];
                openapi: string;
                info: {
                    title: string;
                    version: string;
                    description?: string | undefined;
                    summary?: string | undefined;
                    termsOfService?: string | undefined;
                    contact?: {
                        name?: string | undefined;
                        url?: string | undefined;
                        email?: string | undefined;
                    } | undefined;
                    license?: {
                        name?: string | null | undefined;
                        identifier?: string | undefined;
                        url?: string | undefined;
                    } | undefined;
                };
                security: Record<string, string[]>[];
                "x-scalar-icon": string;
                securitySchemes: string[];
                selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
                servers: (string & import("zod").BRAND<"server">)[];
                requests: (string & import("zod").BRAND<"operation">)[];
                tags: (string & import("zod").BRAND<"tag">)[];
                watchMode: boolean;
                useCollectionSecurity: boolean;
                watchModeStatus: "IDLE" | "WATCHING" | "ERROR";
                externalDocs?: {
                    url: string;
                    description?: string | undefined;
                } | undefined;
                jsonSchemaDialect?: string | undefined;
                components?: Record<string, unknown> | undefined;
                webhooks?: Record<string, unknown> | undefined;
                "x-scalar-active-environment"?: string | undefined;
                "x-scalar-environments"?: Record<string, {
                    variables: Record<string, string | {
                        default: string;
                        description?: string | undefined;
                    }>;
                    color?: string | undefined;
                    description?: string | undefined;
                }> | undefined;
                "x-scalar-secrets"?: Record<string, {
                    description?: string | undefined;
                    example?: string | undefined;
                }> | undefined;
                selectedServerUid?: (string & import("zod").BRAND<"server">) | undefined;
                documentUrl?: string | undefined;
                integration?: string | null | undefined;
            };
            delete: (collection: import("@scalar/oas-utils/entities/spec").Collection, workspace: import("@scalar/oas-utils/entities/workspace").Workspace) => void;
            addEnvironment: (environmentName: string, environment: import("@scalar/oas-utils/entities/spec").XScalarEnvironment, collectionUid: import("@scalar/oas-utils/entities/spec").Collection["uid"]) => void;
            removeEnvironment: (environmentName: string, collectionUid: import("@scalar/oas-utils/entities/spec").Collection["uid"]) => void;
            set: (item: {
                uid: string & import("zod").BRAND<"collection">;
                type: "collection";
                children: ((string & import("zod").BRAND<"tag">) | (string & import("zod").BRAND<"operation">))[];
                openapi: string;
                info: {
                    title: string;
                    version: string;
                    description?: string | undefined;
                    summary?: string | undefined;
                    termsOfService?: string | undefined;
                    contact?: {
                        name?: string | undefined;
                        url?: string | undefined;
                        email?: string | undefined;
                    } | undefined;
                    license?: {
                        name?: string | null | undefined;
                        identifier?: string | undefined;
                        url?: string | undefined;
                    } | undefined;
                };
                security: Record<string, string[]>[];
                "x-scalar-icon": string;
                securitySchemes: string[];
                selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
                servers: (string & import("zod").BRAND<"server">)[];
                requests: (string & import("zod").BRAND<"operation">)[];
                tags: (string & import("zod").BRAND<"tag">)[];
                watchMode: boolean;
                useCollectionSecurity: boolean;
                watchModeStatus: "IDLE" | "WATCHING" | "ERROR";
                externalDocs?: {
                    url: string;
                    description?: string | undefined;
                } | undefined;
                jsonSchemaDialect?: string | undefined;
                components?: Record<string, unknown> | undefined;
                webhooks?: Record<string, unknown> | undefined;
                "x-scalar-active-environment"?: string | undefined;
                "x-scalar-environments"?: Record<string, {
                    variables: Record<string, string | {
                        default: string;
                        description?: string | undefined;
                    }>;
                    color?: string | undefined;
                    description?: string | undefined;
                }> | undefined;
                "x-scalar-secrets"?: Record<string, {
                    description?: string | undefined;
                    example?: string | undefined;
                }> | undefined;
                selectedServerUid?: (string & import("zod").BRAND<"server">) | undefined;
                documentUrl?: string | undefined;
                integration?: string | null | undefined;
            }) => void;
            edit: <P extends "servers" | "tags" | "security" | "externalDocs" | "type" | "uid" | "requests" | "x-scalar-environments" | "children" | "openapi" | "info" | "x-scalar-icon" | "securitySchemes" | "selectedSecuritySchemeUids" | "watchMode" | "useCollectionSecurity" | "watchModeStatus" | "jsonSchemaDialect" | "components" | "webhooks" | "x-scalar-active-environment" | "x-scalar-secrets" | "selectedServerUid" | "documentUrl" | "integration" | `servers.${number}` | `tags.${number}` | `security.${number}` | `security.${number}.${string}` | "externalDocs.url" | "externalDocs.description" | `requests.${number}` | `x-scalar-environments.${string}` | `children.${number}` | "info.title" | "info.summary" | "info.description" | "info.version" | "info.termsOfService" | "info.contact" | "info.license" | "info.contact.url" | "info.contact.name" | "info.contact.email" | "info.license.url" | "info.license.name" | "info.license.identifier" | `securitySchemes.${number}` | `selectedSecuritySchemeUids.${number}` | `selectedSecuritySchemeUids.${number}.${number}` | `components.${string}` | `webhooks.${string}` | `x-scalar-secrets.${string}`>(uid: (string & import("zod").BRAND<"collection">) | null | undefined, path: P, value: P extends "servers" | "tags" | "security" | "externalDocs" | "type" | "uid" | "requests" | "x-scalar-environments" | "children" | "openapi" | "info" | "x-scalar-icon" | "securitySchemes" | "selectedSecuritySchemeUids" | "watchMode" | "useCollectionSecurity" | "watchModeStatus" | "jsonSchemaDialect" | "components" | "webhooks" | "x-scalar-active-environment" | "x-scalar-secrets" | "selectedServerUid" | "documentUrl" | "integration" ? {
                uid: string & import("zod").BRAND<"collection">;
                type: "collection";
                children: ((string & import("zod").BRAND<"tag">) | (string & import("zod").BRAND<"operation">))[];
                openapi: string;
                info: {
                    title: string;
                    version: string;
                    description?: string | undefined;
                    summary?: string | undefined;
                    termsOfService?: string | undefined;
                    contact?: {
                        name?: string | undefined;
                        url?: string | undefined;
                        email?: string | undefined;
                    } | undefined;
                    license?: {
                        name?: string | null | undefined;
                        identifier?: string | undefined;
                        url?: string | undefined;
                    } | undefined;
                };
                security: Record<string, string[]>[];
                "x-scalar-icon": string;
                securitySchemes: string[];
                selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
                servers: (string & import("zod").BRAND<"server">)[];
                requests: (string & import("zod").BRAND<"operation">)[];
                tags: (string & import("zod").BRAND<"tag">)[];
                watchMode: boolean;
                useCollectionSecurity: boolean;
                watchModeStatus: "IDLE" | "WATCHING" | "ERROR";
                externalDocs?: {
                    url: string;
                    description?: string | undefined;
                } | undefined;
                jsonSchemaDialect?: string | undefined;
                components?: Record<string, unknown> | undefined;
                webhooks?: Record<string, unknown> | undefined;
                "x-scalar-active-environment"?: string | undefined;
                "x-scalar-environments"?: Record<string, {
                    variables: Record<string, string | {
                        default: string;
                        description?: string | undefined;
                    }>;
                    color?: string | undefined;
                    description?: string | undefined;
                }> | undefined;
                "x-scalar-secrets"?: Record<string, {
                    description?: string | undefined;
                    example?: string | undefined;
                }> | undefined;
                selectedServerUid?: (string & import("zod").BRAND<"server">) | undefined;
                documentUrl?: string | undefined;
                integration?: string | null | undefined;
            }[P] : P extends `${infer K}.${infer R}` ? K extends "servers" | "tags" | "security" | "externalDocs" | "type" | "uid" | "requests" | "x-scalar-environments" | "children" | "openapi" | "info" | "x-scalar-icon" | "securitySchemes" | "selectedSecuritySchemeUids" | "watchMode" | "useCollectionSecurity" | "watchModeStatus" | "jsonSchemaDialect" | "components" | "webhooks" | "x-scalar-active-environment" | "x-scalar-secrets" | "selectedServerUid" | "documentUrl" | "integration" ? R extends import("@scalar/object-utils/nested").Path<{
                uid: string & import("zod").BRAND<"collection">;
                type: "collection";
                children: ((string & import("zod").BRAND<"tag">) | (string & import("zod").BRAND<"operation">))[];
                openapi: string;
                info: {
                    title: string;
                    version: string;
                    description?: string | undefined;
                    summary?: string | undefined;
                    termsOfService?: string | undefined;
                    contact?: {
                        name?: string | undefined;
                        url?: string | undefined;
                        email?: string | undefined;
                    } | undefined;
                    license?: {
                        name?: string | null | undefined;
                        identifier?: string | undefined;
                        url?: string | undefined;
                    } | undefined;
                };
                security: Record<string, string[]>[];
                "x-scalar-icon": string;
                securitySchemes: string[];
                selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
                servers: (string & import("zod").BRAND<"server">)[];
                requests: (string & import("zod").BRAND<"operation">)[];
                tags: (string & import("zod").BRAND<"tag">)[];
                watchMode: boolean;
                useCollectionSecurity: boolean;
                watchModeStatus: "IDLE" | "WATCHING" | "ERROR";
                externalDocs?: {
                    url: string;
                    description?: string | undefined;
                } | undefined;
                jsonSchemaDialect?: string | undefined;
                components?: Record<string, unknown> | undefined;
                webhooks?: Record<string, unknown> | undefined;
                "x-scalar-active-environment"?: string | undefined;
                "x-scalar-environments"?: Record<string, {
                    variables: Record<string, string | {
                        default: string;
                        description?: string | undefined;
                    }>;
                    color?: string | undefined;
                    description?: string | undefined;
                }> | undefined;
                "x-scalar-secrets"?: Record<string, {
                    description?: string | undefined;
                    example?: string | undefined;
                }> | undefined;
                selectedServerUid?: (string & import("zod").BRAND<"server">) | undefined;
                documentUrl?: string | undefined;
                integration?: string | null | undefined;
            }[K]> ? import("@scalar/object-utils/nested").PathValue<{
                uid: string & import("zod").BRAND<"collection">;
                type: "collection";
                children: ((string & import("zod").BRAND<"tag">) | (string & import("zod").BRAND<"operation">))[];
                openapi: string;
                info: {
                    title: string;
                    version: string;
                    description?: string | undefined;
                    summary?: string | undefined;
                    termsOfService?: string | undefined;
                    contact?: {
                        name?: string | undefined;
                        url?: string | undefined;
                        email?: string | undefined;
                    } | undefined;
                    license?: {
                        name?: string | null | undefined;
                        identifier?: string | undefined;
                        url?: string | undefined;
                    } | undefined;
                };
                security: Record<string, string[]>[];
                "x-scalar-icon": string;
                securitySchemes: string[];
                selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
                servers: (string & import("zod").BRAND<"server">)[];
                requests: (string & import("zod").BRAND<"operation">)[];
                tags: (string & import("zod").BRAND<"tag">)[];
                watchMode: boolean;
                useCollectionSecurity: boolean;
                watchModeStatus: "IDLE" | "WATCHING" | "ERROR";
                externalDocs?: {
                    url: string;
                    description?: string | undefined;
                } | undefined;
                jsonSchemaDialect?: string | undefined;
                components?: Record<string, unknown> | undefined;
                webhooks?: Record<string, unknown> | undefined;
                "x-scalar-active-environment"?: string | undefined;
                "x-scalar-environments"?: Record<string, {
                    variables: Record<string, string | {
                        default: string;
                        description?: string | undefined;
                    }>;
                    color?: string | undefined;
                    description?: string | undefined;
                }> | undefined;
                "x-scalar-secrets"?: Record<string, {
                    description?: string | undefined;
                    example?: string | undefined;
                }> | undefined;
                selectedServerUid?: (string & import("zod").BRAND<"server">) | undefined;
                documentUrl?: string | undefined;
                integration?: string | null | undefined;
            }[K], R> : never : K extends `${number}` ? never : never : P extends `${number}` ? never : never) => void;
            untrackedEdit: <P extends "servers" | "tags" | "security" | "externalDocs" | "type" | "uid" | "requests" | "x-scalar-environments" | "children" | "openapi" | "info" | "x-scalar-icon" | "securitySchemes" | "selectedSecuritySchemeUids" | "watchMode" | "useCollectionSecurity" | "watchModeStatus" | "jsonSchemaDialect" | "components" | "webhooks" | "x-scalar-active-environment" | "x-scalar-secrets" | "selectedServerUid" | "documentUrl" | "integration" | `servers.${number}` | `tags.${number}` | `security.${number}` | `security.${number}.${string}` | "externalDocs.url" | "externalDocs.description" | `requests.${number}` | `x-scalar-environments.${string}` | `children.${number}` | "info.title" | "info.summary" | "info.description" | "info.version" | "info.termsOfService" | "info.contact" | "info.license" | "info.contact.url" | "info.contact.name" | "info.contact.email" | "info.license.url" | "info.license.name" | "info.license.identifier" | `securitySchemes.${number}` | `selectedSecuritySchemeUids.${number}` | `selectedSecuritySchemeUids.${number}.${number}` | `components.${string}` | `webhooks.${string}` | `x-scalar-secrets.${string}`>(uid: string & import("zod").BRAND<"collection">, path: P, value: P extends "servers" | "tags" | "security" | "externalDocs" | "type" | "uid" | "requests" | "x-scalar-environments" | "children" | "openapi" | "info" | "x-scalar-icon" | "securitySchemes" | "selectedSecuritySchemeUids" | "watchMode" | "useCollectionSecurity" | "watchModeStatus" | "jsonSchemaDialect" | "components" | "webhooks" | "x-scalar-active-environment" | "x-scalar-secrets" | "selectedServerUid" | "documentUrl" | "integration" ? {
                uid: string & import("zod").BRAND<"collection">;
                type: "collection";
                children: ((string & import("zod").BRAND<"tag">) | (string & import("zod").BRAND<"operation">))[];
                openapi: string;
                info: {
                    title: string;
                    version: string;
                    description?: string | undefined;
                    summary?: string | undefined;
                    termsOfService?: string | undefined;
                    contact?: {
                        name?: string | undefined;
                        url?: string | undefined;
                        email?: string | undefined;
                    } | undefined;
                    license?: {
                        name?: string | null | undefined;
                        identifier?: string | undefined;
                        url?: string | undefined;
                    } | undefined;
                };
                security: Record<string, string[]>[];
                "x-scalar-icon": string;
                securitySchemes: string[];
                selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
                servers: (string & import("zod").BRAND<"server">)[];
                requests: (string & import("zod").BRAND<"operation">)[];
                tags: (string & import("zod").BRAND<"tag">)[];
                watchMode: boolean;
                useCollectionSecurity: boolean;
                watchModeStatus: "IDLE" | "WATCHING" | "ERROR";
                externalDocs?: {
                    url: string;
                    description?: string | undefined;
                } | undefined;
                jsonSchemaDialect?: string | undefined;
                components?: Record<string, unknown> | undefined;
                webhooks?: Record<string, unknown> | undefined;
                "x-scalar-active-environment"?: string | undefined;
                "x-scalar-environments"?: Record<string, {
                    variables: Record<string, string | {
                        default: string;
                        description?: string | undefined;
                    }>;
                    color?: string | undefined;
                    description?: string | undefined;
                }> | undefined;
                "x-scalar-secrets"?: Record<string, {
                    description?: string | undefined;
                    example?: string | undefined;
                }> | undefined;
                selectedServerUid?: (string & import("zod").BRAND<"server">) | undefined;
                documentUrl?: string | undefined;
                integration?: string | null | undefined;
            }[P] : P extends `${infer K}.${infer R}` ? K extends "servers" | "tags" | "security" | "externalDocs" | "type" | "uid" | "requests" | "x-scalar-environments" | "children" | "openapi" | "info" | "x-scalar-icon" | "securitySchemes" | "selectedSecuritySchemeUids" | "watchMode" | "useCollectionSecurity" | "watchModeStatus" | "jsonSchemaDialect" | "components" | "webhooks" | "x-scalar-active-environment" | "x-scalar-secrets" | "selectedServerUid" | "documentUrl" | "integration" ? R extends import("@scalar/object-utils/nested").Path<{
                uid: string & import("zod").BRAND<"collection">;
                type: "collection";
                children: ((string & import("zod").BRAND<"tag">) | (string & import("zod").BRAND<"operation">))[];
                openapi: string;
                info: {
                    title: string;
                    version: string;
                    description?: string | undefined;
                    summary?: string | undefined;
                    termsOfService?: string | undefined;
                    contact?: {
                        name?: string | undefined;
                        url?: string | undefined;
                        email?: string | undefined;
                    } | undefined;
                    license?: {
                        name?: string | null | undefined;
                        identifier?: string | undefined;
                        url?: string | undefined;
                    } | undefined;
                };
                security: Record<string, string[]>[];
                "x-scalar-icon": string;
                securitySchemes: string[];
                selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
                servers: (string & import("zod").BRAND<"server">)[];
                requests: (string & import("zod").BRAND<"operation">)[];
                tags: (string & import("zod").BRAND<"tag">)[];
                watchMode: boolean;
                useCollectionSecurity: boolean;
                watchModeStatus: "IDLE" | "WATCHING" | "ERROR";
                externalDocs?: {
                    url: string;
                    description?: string | undefined;
                } | undefined;
                jsonSchemaDialect?: string | undefined;
                components?: Record<string, unknown> | undefined;
                webhooks?: Record<string, unknown> | undefined;
                "x-scalar-active-environment"?: string | undefined;
                "x-scalar-environments"?: Record<string, {
                    variables: Record<string, string | {
                        default: string;
                        description?: string | undefined;
                    }>;
                    color?: string | undefined;
                    description?: string | undefined;
                }> | undefined;
                "x-scalar-secrets"?: Record<string, {
                    description?: string | undefined;
                    example?: string | undefined;
                }> | undefined;
                selectedServerUid?: (string & import("zod").BRAND<"server">) | undefined;
                documentUrl?: string | undefined;
                integration?: string | null | undefined;
            }[K]> ? import("@scalar/object-utils/nested").PathValue<{
                uid: string & import("zod").BRAND<"collection">;
                type: "collection";
                children: ((string & import("zod").BRAND<"tag">) | (string & import("zod").BRAND<"operation">))[];
                openapi: string;
                info: {
                    title: string;
                    version: string;
                    description?: string | undefined;
                    summary?: string | undefined;
                    termsOfService?: string | undefined;
                    contact?: {
                        name?: string | undefined;
                        url?: string | undefined;
                        email?: string | undefined;
                    } | undefined;
                    license?: {
                        name?: string | null | undefined;
                        identifier?: string | undefined;
                        url?: string | undefined;
                    } | undefined;
                };
                security: Record<string, string[]>[];
                "x-scalar-icon": string;
                securitySchemes: string[];
                selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
                servers: (string & import("zod").BRAND<"server">)[];
                requests: (string & import("zod").BRAND<"operation">)[];
                tags: (string & import("zod").BRAND<"tag">)[];
                watchMode: boolean;
                useCollectionSecurity: boolean;
                watchModeStatus: "IDLE" | "WATCHING" | "ERROR";
                externalDocs?: {
                    url: string;
                    description?: string | undefined;
                } | undefined;
                jsonSchemaDialect?: string | undefined;
                components?: Record<string, unknown> | undefined;
                webhooks?: Record<string, unknown> | undefined;
                "x-scalar-active-environment"?: string | undefined;
                "x-scalar-environments"?: Record<string, {
                    variables: Record<string, string | {
                        default: string;
                        description?: string | undefined;
                    }>;
                    color?: string | undefined;
                    description?: string | undefined;
                }> | undefined;
                "x-scalar-secrets"?: Record<string, {
                    description?: string | undefined;
                    example?: string | undefined;
                }> | undefined;
                selectedServerUid?: (string & import("zod").BRAND<"server">) | undefined;
                documentUrl?: string | undefined;
                integration?: string | null | undefined;
            }[K], R> : never : K extends `${number}` ? never : never : P extends `${number}` ? never : never) => void;
            undo: (uid: string & import("zod").BRAND<"collection">) => void;
            redo: (uid: string & import("zod").BRAND<"collection">) => void;
            reset: () => void;
        };
        environmentMutators: {
            delete: (uid: import("@scalar/oas-utils/entities/environment").Environment["uid"]) => void;
            add: (item: {
                uid: string & import("zod").BRAND<"environment">;
                name: string;
                value: string;
                color: string;
                isDefault?: boolean | undefined;
            }) => void;
            set: (item: {
                uid: string & import("zod").BRAND<"environment">;
                name: string;
                value: string;
                color: string;
                isDefault?: boolean | undefined;
            }) => void;
            edit: <P extends "value" | "name" | "uid" | "color" | "isDefault">(uid: (string & import("zod").BRAND<"environment">) | null | undefined, path: P, value: P extends "value" | "name" | "uid" | "color" | "isDefault" ? {
                uid: string & import("zod").BRAND<"environment">;
                name: string;
                value: string;
                color: string;
                isDefault?: boolean | undefined;
            }[P] : P extends `${infer K}.${infer R}` ? K extends "value" | "name" | "uid" | "color" | "isDefault" ? R extends import("@scalar/object-utils/nested").Path<{
                uid: string & import("zod").BRAND<"environment">;
                name: string;
                value: string;
                color: string;
                isDefault?: boolean | undefined;
            }[K]> ? import("@scalar/object-utils/nested").PathValue<{
                uid: string & import("zod").BRAND<"environment">;
                name: string;
                value: string;
                color: string;
                isDefault?: boolean | undefined;
            }[K], R> : never : K extends `${number}` ? never : never : P extends `${number}` ? never : never) => void;
            untrackedEdit: <P extends "value" | "name" | "uid" | "color" | "isDefault">(uid: string & import("zod").BRAND<"environment">, path: P, value: P extends "value" | "name" | "uid" | "color" | "isDefault" ? {
                uid: string & import("zod").BRAND<"environment">;
                name: string;
                value: string;
                color: string;
                isDefault?: boolean | undefined;
            }[P] : P extends `${infer K}.${infer R}` ? K extends "value" | "name" | "uid" | "color" | "isDefault" ? R extends import("@scalar/object-utils/nested").Path<{
                uid: string & import("zod").BRAND<"environment">;
                name: string;
                value: string;
                color: string;
                isDefault?: boolean | undefined;
            }[K]> ? import("@scalar/object-utils/nested").PathValue<{
                uid: string & import("zod").BRAND<"environment">;
                name: string;
                value: string;
                color: string;
                isDefault?: boolean | undefined;
            }[K], R> : never : K extends `${number}` ? never : never : P extends `${number}` ? never : never) => void;
            undo: (uid: string & import("zod").BRAND<"environment">) => void;
            redo: (uid: string & import("zod").BRAND<"environment">) => void;
            reset: () => void;
        };
        requestMutators: {
            rawAdd: (item: {
                uid: string & import("zod").BRAND<"operation">;
                path: string;
                type: "request";
                selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
                selectedServerUid: (string & import("zod").BRAND<"server">) | null;
                servers: (string & import("zod").BRAND<"server">)[];
                examples: (string & import("zod").BRAND<"example">)[];
                method: "options" | "connect" | "delete" | "get" | "head" | "patch" | "post" | "put" | "trace";
                description?: string | undefined;
                summary?: string | undefined;
                externalDocs?: {
                    url: string;
                    description?: string | undefined;
                } | undefined;
                "x-internal"?: boolean | undefined;
                "x-scalar-ignore"?: boolean | undefined;
                security?: Record<string, string[]>[] | undefined;
                tags?: string[] | undefined;
                deprecated?: boolean | undefined;
                operationId?: string | undefined;
                parameters?: {
                    name: string;
                    required: boolean;
                    in: "cookie" | "path" | "query" | "header";
                    deprecated: boolean;
                    description?: string | undefined;
                    example?: unknown;
                    schema?: unknown;
                    content?: unknown;
                    style?: "matrix" | "simple" | "form" | "label" | "spaceDelimited" | "pipeDelimited" | "deepObject" | undefined;
                    examples?: unknown[] | Record<string, {
                        value?: unknown;
                        summary?: string | undefined;
                    }> | undefined;
                }[] | undefined;
                requestBody?: any;
                responses?: Record<string, any> | undefined;
                "x-codeSamples"?: {
                    source: string;
                    label?: string | undefined;
                    lang?: string | undefined;
                }[] | undefined;
                "x-code-samples"?: {
                    source: string;
                    label?: string | undefined;
                    lang?: string | undefined;
                }[] | undefined;
                "x-custom-examples"?: {
                    source: string;
                    label?: string | undefined;
                    lang?: string | undefined;
                }[] | undefined;
                "x-scalar-stability"?: import("@scalar/types").XScalarStability | undefined;
            }) => void;
            add: (payload: import("@scalar/oas-utils/entities/spec").RequestPayload, collectionUid: import("@scalar/oas-utils/entities/spec").Collection["uid"]) => void | {
                uid: string & import("zod").BRAND<"operation">;
                path: string;
                type: "request";
                selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
                selectedServerUid: (string & import("zod").BRAND<"server">) | null;
                servers: (string & import("zod").BRAND<"server">)[];
                examples: (string & import("zod").BRAND<"example">)[];
                method: "options" | "connect" | "delete" | "get" | "head" | "patch" | "post" | "put" | "trace";
                description?: string | undefined;
                summary?: string | undefined;
                externalDocs?: {
                    url: string;
                    description?: string | undefined;
                } | undefined;
                "x-internal"?: boolean | undefined;
                "x-scalar-ignore"?: boolean | undefined;
                security?: Record<string, string[]>[] | undefined;
                tags?: string[] | undefined;
                deprecated?: boolean | undefined;
                operationId?: string | undefined;
                parameters?: {
                    name: string;
                    required: boolean;
                    in: "cookie" | "path" | "query" | "header";
                    deprecated: boolean;
                    description?: string | undefined;
                    example?: unknown;
                    schema?: unknown;
                    content?: unknown;
                    style?: "matrix" | "simple" | "form" | "label" | "spaceDelimited" | "pipeDelimited" | "deepObject" | undefined;
                    examples?: unknown[] | Record<string, {
                        value?: unknown;
                        summary?: string | undefined;
                    }> | undefined;
                }[] | undefined;
                requestBody?: any;
                responses?: Record<string, any> | undefined;
                "x-codeSamples"?: {
                    source: string;
                    label?: string | undefined;
                    lang?: string | undefined;
                }[] | undefined;
                "x-code-samples"?: {
                    source: string;
                    label?: string | undefined;
                    lang?: string | undefined;
                }[] | undefined;
                "x-custom-examples"?: {
                    source: string;
                    label?: string | undefined;
                    lang?: string | undefined;
                }[] | undefined;
                "x-scalar-stability"?: import("@scalar/types").XScalarStability | undefined;
            };
            delete: (request: import("@scalar/oas-utils/entities/spec").Request, collectionUid: import("@scalar/oas-utils/entities/spec").Collection["uid"]) => void;
            set: (item: {
                uid: string & import("zod").BRAND<"operation">;
                path: string;
                type: "request";
                selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
                selectedServerUid: (string & import("zod").BRAND<"server">) | null;
                servers: (string & import("zod").BRAND<"server">)[];
                examples: (string & import("zod").BRAND<"example">)[];
                method: "options" | "connect" | "delete" | "get" | "head" | "patch" | "post" | "put" | "trace";
                description?: string | undefined;
                summary?: string | undefined;
                externalDocs?: {
                    url: string;
                    description?: string | undefined;
                } | undefined;
                "x-internal"?: boolean | undefined;
                "x-scalar-ignore"?: boolean | undefined;
                security?: Record<string, string[]>[] | undefined;
                tags?: string[] | undefined;
                deprecated?: boolean | undefined;
                operationId?: string | undefined;
                parameters?: {
                    name: string;
                    required: boolean;
                    in: "cookie" | "path" | "query" | "header";
                    deprecated: boolean;
                    description?: string | undefined;
                    example?: unknown;
                    schema?: unknown;
                    content?: unknown;
                    style?: "matrix" | "simple" | "form" | "label" | "spaceDelimited" | "pipeDelimited" | "deepObject" | undefined;
                    examples?: unknown[] | Record<string, {
                        value?: unknown;
                        summary?: string | undefined;
                    }> | undefined;
                }[] | undefined;
                requestBody?: any;
                responses?: Record<string, any> | undefined;
                "x-codeSamples"?: {
                    source: string;
                    label?: string | undefined;
                    lang?: string | undefined;
                }[] | undefined;
                "x-code-samples"?: {
                    source: string;
                    label?: string | undefined;
                    lang?: string | undefined;
                }[] | undefined;
                "x-custom-examples"?: {
                    source: string;
                    label?: string | undefined;
                    lang?: string | undefined;
                }[] | undefined;
                "x-scalar-stability"?: import("@scalar/types").XScalarStability | undefined;
            }) => void;
            edit: <P extends "servers" | "tags" | "summary" | "description" | "operationId" | "security" | "requestBody" | "parameters" | "externalDocs" | "deprecated" | "responses" | "x-internal" | "x-scalar-ignore" | "x-codeSamples" | "x-code-samples" | "x-custom-examples" | "x-scalar-stability" | "path" | "method" | "type" | "uid" | "selectedSecuritySchemeUids" | "selectedServerUid" | `servers.${number}` | `tags.${number}` | `security.${number}` | `security.${number}.${string}` | "externalDocs.url" | "externalDocs.description" | `selectedSecuritySchemeUids.${number}` | `selectedSecuritySchemeUids.${number}.${number}` | "examples" | `requestBody.${string}` | `examples.${number}` | `parameters.${number}` | `parameters.${number}.content` | `parameters.${number}.description` | `parameters.${number}.deprecated` | `parameters.${number}.example` | `parameters.${number}.name` | `parameters.${number}.in` | `parameters.${number}.style` | `parameters.${number}.examples` | `parameters.${number}.required` | `parameters.${number}.schema` | `parameters.${number}.examples.${number}` | `parameters.${number}.examples.${string}` | `responses.${string}` | `x-codeSamples.${number}` | `x-codeSamples.${number}.label` | `x-codeSamples.${number}.source` | `x-codeSamples.${number}.lang` | `x-code-samples.${number}` | `x-code-samples.${number}.label` | `x-code-samples.${number}.source` | `x-code-samples.${number}.lang` | `x-custom-examples.${number}` | `x-custom-examples.${number}.label` | `x-custom-examples.${number}.source` | `x-custom-examples.${number}.lang`>(uid: (string & import("zod").BRAND<"operation">) | null | undefined, path: P, value: P extends "servers" | "tags" | "summary" | "description" | "operationId" | "security" | "requestBody" | "parameters" | "externalDocs" | "deprecated" | "responses" | "x-internal" | "x-scalar-ignore" | "x-codeSamples" | "x-code-samples" | "x-custom-examples" | "x-scalar-stability" | "path" | "method" | "type" | "uid" | "selectedSecuritySchemeUids" | "selectedServerUid" | "examples" ? {
                uid: string & import("zod").BRAND<"operation">;
                path: string;
                type: "request";
                selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
                selectedServerUid: (string & import("zod").BRAND<"server">) | null;
                servers: (string & import("zod").BRAND<"server">)[];
                examples: (string & import("zod").BRAND<"example">)[];
                method: "options" | "connect" | "delete" | "get" | "head" | "patch" | "post" | "put" | "trace";
                description?: string | undefined;
                summary?: string | undefined;
                externalDocs?: {
                    url: string;
                    description?: string | undefined;
                } | undefined;
                "x-internal"?: boolean | undefined;
                "x-scalar-ignore"?: boolean | undefined;
                security?: Record<string, string[]>[] | undefined;
                tags?: string[] | undefined;
                deprecated?: boolean | undefined;
                operationId?: string | undefined;
                parameters?: {
                    name: string;
                    required: boolean;
                    in: "cookie" | "path" | "query" | "header";
                    deprecated: boolean;
                    description?: string | undefined;
                    example?: unknown;
                    schema?: unknown;
                    content?: unknown;
                    style?: "matrix" | "simple" | "form" | "label" | "spaceDelimited" | "pipeDelimited" | "deepObject" | undefined;
                    examples?: unknown[] | Record<string, {
                        value?: unknown;
                        summary?: string | undefined;
                    }> | undefined;
                }[] | undefined;
                requestBody?: any;
                responses?: Record<string, any> | undefined;
                "x-codeSamples"?: {
                    source: string;
                    label?: string | undefined;
                    lang?: string | undefined;
                }[] | undefined;
                "x-code-samples"?: {
                    source: string;
                    label?: string | undefined;
                    lang?: string | undefined;
                }[] | undefined;
                "x-custom-examples"?: {
                    source: string;
                    label?: string | undefined;
                    lang?: string | undefined;
                }[] | undefined;
                "x-scalar-stability"?: import("@scalar/types").XScalarStability | undefined;
            }[P] : P extends `${infer K}.${infer R}` ? K extends "servers" | "tags" | "summary" | "description" | "operationId" | "security" | "requestBody" | "parameters" | "externalDocs" | "deprecated" | "responses" | "x-internal" | "x-scalar-ignore" | "x-codeSamples" | "x-code-samples" | "x-custom-examples" | "x-scalar-stability" | "path" | "method" | "type" | "uid" | "selectedSecuritySchemeUids" | "selectedServerUid" | "examples" ? R extends import("@scalar/object-utils/nested").Path<{
                uid: string & import("zod").BRAND<"operation">;
                path: string;
                type: "request";
                selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
                selectedServerUid: (string & import("zod").BRAND<"server">) | null;
                servers: (string & import("zod").BRAND<"server">)[];
                examples: (string & import("zod").BRAND<"example">)[];
                method: "options" | "connect" | "delete" | "get" | "head" | "patch" | "post" | "put" | "trace";
                description?: string | undefined;
                summary?: string | undefined;
                externalDocs?: {
                    url: string;
                    description?: string | undefined;
                } | undefined;
                "x-internal"?: boolean | undefined;
                "x-scalar-ignore"?: boolean | undefined;
                security?: Record<string, string[]>[] | undefined;
                tags?: string[] | undefined;
                deprecated?: boolean | undefined;
                operationId?: string | undefined;
                parameters?: {
                    name: string;
                    required: boolean;
                    in: "cookie" | "path" | "query" | "header";
                    deprecated: boolean;
                    description?: string | undefined;
                    example?: unknown;
                    schema?: unknown;
                    content?: unknown;
                    style?: "matrix" | "simple" | "form" | "label" | "spaceDelimited" | "pipeDelimited" | "deepObject" | undefined;
                    examples?: unknown[] | Record<string, {
                        value?: unknown;
                        summary?: string | undefined;
                    }> | undefined;
                }[] | undefined;
                requestBody?: any;
                responses?: Record<string, any> | undefined;
                "x-codeSamples"?: {
                    source: string;
                    label?: string | undefined;
                    lang?: string | undefined;
                }[] | undefined;
                "x-code-samples"?: {
                    source: string;
                    label?: string | undefined;
                    lang?: string | undefined;
                }[] | undefined;
                "x-custom-examples"?: {
                    source: string;
                    label?: string | undefined;
                    lang?: string | undefined;
                }[] | undefined;
                "x-scalar-stability"?: import("@scalar/types").XScalarStability | undefined;
            }[K]> ? import("@scalar/object-utils/nested").PathValue<{
                uid: string & import("zod").BRAND<"operation">;
                path: string;
                type: "request";
                selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
                selectedServerUid: (string & import("zod").BRAND<"server">) | null;
                servers: (string & import("zod").BRAND<"server">)[];
                examples: (string & import("zod").BRAND<"example">)[];
                method: "options" | "connect" | "delete" | "get" | "head" | "patch" | "post" | "put" | "trace";
                description?: string | undefined;
                summary?: string | undefined;
                externalDocs?: {
                    url: string;
                    description?: string | undefined;
                } | undefined;
                "x-internal"?: boolean | undefined;
                "x-scalar-ignore"?: boolean | undefined;
                security?: Record<string, string[]>[] | undefined;
                tags?: string[] | undefined;
                deprecated?: boolean | undefined;
                operationId?: string | undefined;
                parameters?: {
                    name: string;
                    required: boolean;
                    in: "cookie" | "path" | "query" | "header";
                    deprecated: boolean;
                    description?: string | undefined;
                    example?: unknown;
                    schema?: unknown;
                    content?: unknown;
                    style?: "matrix" | "simple" | "form" | "label" | "spaceDelimited" | "pipeDelimited" | "deepObject" | undefined;
                    examples?: unknown[] | Record<string, {
                        value?: unknown;
                        summary?: string | undefined;
                    }> | undefined;
                }[] | undefined;
                requestBody?: any;
                responses?: Record<string, any> | undefined;
                "x-codeSamples"?: {
                    source: string;
                    label?: string | undefined;
                    lang?: string | undefined;
                }[] | undefined;
                "x-code-samples"?: {
                    source: string;
                    label?: string | undefined;
                    lang?: string | undefined;
                }[] | undefined;
                "x-custom-examples"?: {
                    source: string;
                    label?: string | undefined;
                    lang?: string | undefined;
                }[] | undefined;
                "x-scalar-stability"?: import("@scalar/types").XScalarStability | undefined;
            }[K], R> : never : K extends `${number}` ? never : never : P extends `${number}` ? never : never) => void;
            untrackedEdit: <P extends "servers" | "tags" | "summary" | "description" | "operationId" | "security" | "requestBody" | "parameters" | "externalDocs" | "deprecated" | "responses" | "x-internal" | "x-scalar-ignore" | "x-codeSamples" | "x-code-samples" | "x-custom-examples" | "x-scalar-stability" | "path" | "method" | "type" | "uid" | "selectedSecuritySchemeUids" | "selectedServerUid" | `servers.${number}` | `tags.${number}` | `security.${number}` | `security.${number}.${string}` | "externalDocs.url" | "externalDocs.description" | `selectedSecuritySchemeUids.${number}` | `selectedSecuritySchemeUids.${number}.${number}` | "examples" | `requestBody.${string}` | `examples.${number}` | `parameters.${number}` | `parameters.${number}.content` | `parameters.${number}.description` | `parameters.${number}.deprecated` | `parameters.${number}.example` | `parameters.${number}.name` | `parameters.${number}.in` | `parameters.${number}.style` | `parameters.${number}.examples` | `parameters.${number}.required` | `parameters.${number}.schema` | `parameters.${number}.examples.${number}` | `parameters.${number}.examples.${string}` | `responses.${string}` | `x-codeSamples.${number}` | `x-codeSamples.${number}.label` | `x-codeSamples.${number}.source` | `x-codeSamples.${number}.lang` | `x-code-samples.${number}` | `x-code-samples.${number}.label` | `x-code-samples.${number}.source` | `x-code-samples.${number}.lang` | `x-custom-examples.${number}` | `x-custom-examples.${number}.label` | `x-custom-examples.${number}.source` | `x-custom-examples.${number}.lang`>(uid: string & import("zod").BRAND<"operation">, path: P, value: P extends "servers" | "tags" | "summary" | "description" | "operationId" | "security" | "requestBody" | "parameters" | "externalDocs" | "deprecated" | "responses" | "x-internal" | "x-scalar-ignore" | "x-codeSamples" | "x-code-samples" | "x-custom-examples" | "x-scalar-stability" | "path" | "method" | "type" | "uid" | "selectedSecuritySchemeUids" | "selectedServerUid" | "examples" ? {
                uid: string & import("zod").BRAND<"operation">;
                path: string;
                type: "request";
                selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
                selectedServerUid: (string & import("zod").BRAND<"server">) | null;
                servers: (string & import("zod").BRAND<"server">)[];
                examples: (string & import("zod").BRAND<"example">)[];
                method: "options" | "connect" | "delete" | "get" | "head" | "patch" | "post" | "put" | "trace";
                description?: string | undefined;
                summary?: string | undefined;
                externalDocs?: {
                    url: string;
                    description?: string | undefined;
                } | undefined;
                "x-internal"?: boolean | undefined;
                "x-scalar-ignore"?: boolean | undefined;
                security?: Record<string, string[]>[] | undefined;
                tags?: string[] | undefined;
                deprecated?: boolean | undefined;
                operationId?: string | undefined;
                parameters?: {
                    name: string;
                    required: boolean;
                    in: "cookie" | "path" | "query" | "header";
                    deprecated: boolean;
                    description?: string | undefined;
                    example?: unknown;
                    schema?: unknown;
                    content?: unknown;
                    style?: "matrix" | "simple" | "form" | "label" | "spaceDelimited" | "pipeDelimited" | "deepObject" | undefined;
                    examples?: unknown[] | Record<string, {
                        value?: unknown;
                        summary?: string | undefined;
                    }> | undefined;
                }[] | undefined;
                requestBody?: any;
                responses?: Record<string, any> | undefined;
                "x-codeSamples"?: {
                    source: string;
                    label?: string | undefined;
                    lang?: string | undefined;
                }[] | undefined;
                "x-code-samples"?: {
                    source: string;
                    label?: string | undefined;
                    lang?: string | undefined;
                }[] | undefined;
                "x-custom-examples"?: {
                    source: string;
                    label?: string | undefined;
                    lang?: string | undefined;
                }[] | undefined;
                "x-scalar-stability"?: import("@scalar/types").XScalarStability | undefined;
            }[P] : P extends `${infer K}.${infer R}` ? K extends "servers" | "tags" | "summary" | "description" | "operationId" | "security" | "requestBody" | "parameters" | "externalDocs" | "deprecated" | "responses" | "x-internal" | "x-scalar-ignore" | "x-codeSamples" | "x-code-samples" | "x-custom-examples" | "x-scalar-stability" | "path" | "method" | "type" | "uid" | "selectedSecuritySchemeUids" | "selectedServerUid" | "examples" ? R extends import("@scalar/object-utils/nested").Path<{
                uid: string & import("zod").BRAND<"operation">;
                path: string;
                type: "request";
                selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
                selectedServerUid: (string & import("zod").BRAND<"server">) | null;
                servers: (string & import("zod").BRAND<"server">)[];
                examples: (string & import("zod").BRAND<"example">)[];
                method: "options" | "connect" | "delete" | "get" | "head" | "patch" | "post" | "put" | "trace";
                description?: string | undefined;
                summary?: string | undefined;
                externalDocs?: {
                    url: string;
                    description?: string | undefined;
                } | undefined;
                "x-internal"?: boolean | undefined;
                "x-scalar-ignore"?: boolean | undefined;
                security?: Record<string, string[]>[] | undefined;
                tags?: string[] | undefined;
                deprecated?: boolean | undefined;
                operationId?: string | undefined;
                parameters?: {
                    name: string;
                    required: boolean;
                    in: "cookie" | "path" | "query" | "header";
                    deprecated: boolean;
                    description?: string | undefined;
                    example?: unknown;
                    schema?: unknown;
                    content?: unknown;
                    style?: "matrix" | "simple" | "form" | "label" | "spaceDelimited" | "pipeDelimited" | "deepObject" | undefined;
                    examples?: unknown[] | Record<string, {
                        value?: unknown;
                        summary?: string | undefined;
                    }> | undefined;
                }[] | undefined;
                requestBody?: any;
                responses?: Record<string, any> | undefined;
                "x-codeSamples"?: {
                    source: string;
                    label?: string | undefined;
                    lang?: string | undefined;
                }[] | undefined;
                "x-code-samples"?: {
                    source: string;
                    label?: string | undefined;
                    lang?: string | undefined;
                }[] | undefined;
                "x-custom-examples"?: {
                    source: string;
                    label?: string | undefined;
                    lang?: string | undefined;
                }[] | undefined;
                "x-scalar-stability"?: import("@scalar/types").XScalarStability | undefined;
            }[K]> ? import("@scalar/object-utils/nested").PathValue<{
                uid: string & import("zod").BRAND<"operation">;
                path: string;
                type: "request";
                selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
                selectedServerUid: (string & import("zod").BRAND<"server">) | null;
                servers: (string & import("zod").BRAND<"server">)[];
                examples: (string & import("zod").BRAND<"example">)[];
                method: "options" | "connect" | "delete" | "get" | "head" | "patch" | "post" | "put" | "trace";
                description?: string | undefined;
                summary?: string | undefined;
                externalDocs?: {
                    url: string;
                    description?: string | undefined;
                } | undefined;
                "x-internal"?: boolean | undefined;
                "x-scalar-ignore"?: boolean | undefined;
                security?: Record<string, string[]>[] | undefined;
                tags?: string[] | undefined;
                deprecated?: boolean | undefined;
                operationId?: string | undefined;
                parameters?: {
                    name: string;
                    required: boolean;
                    in: "cookie" | "path" | "query" | "header";
                    deprecated: boolean;
                    description?: string | undefined;
                    example?: unknown;
                    schema?: unknown;
                    content?: unknown;
                    style?: "matrix" | "simple" | "form" | "label" | "spaceDelimited" | "pipeDelimited" | "deepObject" | undefined;
                    examples?: unknown[] | Record<string, {
                        value?: unknown;
                        summary?: string | undefined;
                    }> | undefined;
                }[] | undefined;
                requestBody?: any;
                responses?: Record<string, any> | undefined;
                "x-codeSamples"?: {
                    source: string;
                    label?: string | undefined;
                    lang?: string | undefined;
                }[] | undefined;
                "x-code-samples"?: {
                    source: string;
                    label?: string | undefined;
                    lang?: string | undefined;
                }[] | undefined;
                "x-custom-examples"?: {
                    source: string;
                    label?: string | undefined;
                    lang?: string | undefined;
                }[] | undefined;
                "x-scalar-stability"?: import("@scalar/types").XScalarStability | undefined;
            }[K], R> : never : K extends `${number}` ? never : never : P extends `${number}` ? never : never) => void;
            undo: (uid: string & import("zod").BRAND<"operation">) => void;
            redo: (uid: string & import("zod").BRAND<"operation">) => void;
            reset: () => void;
        };
        findRequestParents: (r: import("@scalar/oas-utils/entities/spec").Request) => string[];
        securitySchemeMutators: {
            rawAdd: (item: {
                name: string;
                type: "apiKey";
                value: string;
                uid: string & import("zod").BRAND<"securityScheme">;
                nameKey: string;
                in: "cookie" | "query" | "header";
                description?: string | undefined;
            } | {
                type: "http";
                uid: string & import("zod").BRAND<"securityScheme">;
                nameKey: string;
                scheme: "basic" | "bearer";
                bearerFormat: string;
                username: string;
                password: string;
                token: string;
                description?: string | undefined;
            } | {
                type: "openIdConnect";
                uid: string & import("zod").BRAND<"securityScheme">;
                nameKey: string;
                openIdConnectUrl: string;
                description?: string | undefined;
            } | {
                type: "oauth2";
                uid: string & import("zod").BRAND<"securityScheme">;
                nameKey: string;
                flows: {
                    password?: {
                        type: "password";
                        username: string;
                        password: string;
                        token: string;
                        refreshUrl: string;
                        scopes: Record<string, string>;
                        selectedScopes: string[];
                        "x-scalar-client-id": string;
                        tokenUrl: string;
                        clientSecret: string;
                    } | undefined;
                    implicit?: {
                        type: "implicit";
                        token: string;
                        refreshUrl: string;
                        scopes: Record<string, string>;
                        selectedScopes: string[];
                        "x-scalar-client-id": string;
                        authorizationUrl: string;
                        "x-scalar-redirect-uri": string;
                    } | undefined;
                    clientCredentials?: {
                        type: "clientCredentials";
                        token: string;
                        refreshUrl: string;
                        scopes: Record<string, string>;
                        selectedScopes: string[];
                        "x-scalar-client-id": string;
                        tokenUrl: string;
                        clientSecret: string;
                    } | undefined;
                    authorizationCode?: {
                        type: "authorizationCode";
                        token: string;
                        refreshUrl: string;
                        scopes: Record<string, string>;
                        selectedScopes: string[];
                        "x-scalar-client-id": string;
                        authorizationUrl: string;
                        "x-scalar-redirect-uri": string;
                        tokenUrl: string;
                        clientSecret: string;
                        "x-usePkce": "SHA-256" | "plain" | "no";
                    } | undefined;
                };
                description?: string | undefined;
                "x-default-scopes"?: string | string[] | undefined;
            }) => void;
            add: (payload: import("@scalar/types/entities").SecuritySchemePayload, collectionUid: import("@scalar/oas-utils/entities/spec").Collection["uid"]) => {
                name: string;
                type: "apiKey";
                value: string;
                uid: string & import("zod").BRAND<"securityScheme">;
                nameKey: string;
                in: "cookie" | "query" | "header";
                description?: string | undefined;
            } | {
                type: "http";
                uid: string & import("zod").BRAND<"securityScheme">;
                nameKey: string;
                scheme: "basic" | "bearer";
                bearerFormat: string;
                username: string;
                password: string;
                token: string;
                description?: string | undefined;
            } | {
                type: "openIdConnect";
                uid: string & import("zod").BRAND<"securityScheme">;
                nameKey: string;
                openIdConnectUrl: string;
                description?: string | undefined;
            } | {
                type: "oauth2";
                uid: string & import("zod").BRAND<"securityScheme">;
                nameKey: string;
                flows: {
                    password?: {
                        type: "password";
                        username: string;
                        password: string;
                        token: string;
                        refreshUrl: string;
                        scopes: Record<string, string>;
                        selectedScopes: string[];
                        "x-scalar-client-id": string;
                        tokenUrl: string;
                        clientSecret: string;
                    } | undefined;
                    implicit?: {
                        type: "implicit";
                        token: string;
                        refreshUrl: string;
                        scopes: Record<string, string>;
                        selectedScopes: string[];
                        "x-scalar-client-id": string;
                        authorizationUrl: string;
                        "x-scalar-redirect-uri": string;
                    } | undefined;
                    clientCredentials?: {
                        type: "clientCredentials";
                        token: string;
                        refreshUrl: string;
                        scopes: Record<string, string>;
                        selectedScopes: string[];
                        "x-scalar-client-id": string;
                        tokenUrl: string;
                        clientSecret: string;
                    } | undefined;
                    authorizationCode?: {
                        type: "authorizationCode";
                        token: string;
                        refreshUrl: string;
                        scopes: Record<string, string>;
                        selectedScopes: string[];
                        "x-scalar-client-id": string;
                        authorizationUrl: string;
                        "x-scalar-redirect-uri": string;
                        tokenUrl: string;
                        clientSecret: string;
                        "x-usePkce": "SHA-256" | "plain" | "no";
                    } | undefined;
                };
                description?: string | undefined;
                "x-default-scopes"?: string | string[] | undefined;
            };
            delete: (schemeUid: import("@scalar/types/entities").SecurityScheme["uid"]) => void;
            set: (item: {
                name: string;
                type: "apiKey";
                value: string;
                uid: string & import("zod").BRAND<"securityScheme">;
                nameKey: string;
                in: "cookie" | "query" | "header";
                description?: string | undefined;
            } | {
                type: "http";
                uid: string & import("zod").BRAND<"securityScheme">;
                nameKey: string;
                scheme: "basic" | "bearer";
                bearerFormat: string;
                username: string;
                password: string;
                token: string;
                description?: string | undefined;
            } | {
                type: "openIdConnect";
                uid: string & import("zod").BRAND<"securityScheme">;
                nameKey: string;
                openIdConnectUrl: string;
                description?: string | undefined;
            } | {
                type: "oauth2";
                uid: string & import("zod").BRAND<"securityScheme">;
                nameKey: string;
                flows: {
                    password?: {
                        type: "password";
                        username: string;
                        password: string;
                        token: string;
                        refreshUrl: string;
                        scopes: Record<string, string>;
                        selectedScopes: string[];
                        "x-scalar-client-id": string;
                        tokenUrl: string;
                        clientSecret: string;
                    } | undefined;
                    implicit?: {
                        type: "implicit";
                        token: string;
                        refreshUrl: string;
                        scopes: Record<string, string>;
                        selectedScopes: string[];
                        "x-scalar-client-id": string;
                        authorizationUrl: string;
                        "x-scalar-redirect-uri": string;
                    } | undefined;
                    clientCredentials?: {
                        type: "clientCredentials";
                        token: string;
                        refreshUrl: string;
                        scopes: Record<string, string>;
                        selectedScopes: string[];
                        "x-scalar-client-id": string;
                        tokenUrl: string;
                        clientSecret: string;
                    } | undefined;
                    authorizationCode?: {
                        type: "authorizationCode";
                        token: string;
                        refreshUrl: string;
                        scopes: Record<string, string>;
                        selectedScopes: string[];
                        "x-scalar-client-id": string;
                        authorizationUrl: string;
                        "x-scalar-redirect-uri": string;
                        tokenUrl: string;
                        clientSecret: string;
                        "x-usePkce": "SHA-256" | "plain" | "no";
                    } | undefined;
                };
                description?: string | undefined;
                "x-default-scopes"?: string | string[] | undefined;
            }) => void;
            edit: <P extends "value" | "description" | "type" | "name" | "in" | "uid" | "nameKey" | "scheme" | "bearerFormat" | "openIdConnectUrl" | "x-default-scopes" | "flows" | "password" | "username" | "token" | `x-default-scopes.${number}` | "flows.password" | "flows.implicit" | "flows.clientCredentials" | "flows.authorizationCode" | "flows.password.type" | "flows.password.password" | "flows.password.username" | "flows.password.token" | "flows.password.refreshUrl" | "flows.password.scopes" | "flows.password.selectedScopes" | "flows.password.x-scalar-client-id" | "flows.password.tokenUrl" | "flows.password.clientSecret" | `flows.password.scopes.${string}` | `flows.password.selectedScopes.${number}` | "flows.implicit.type" | "flows.implicit.token" | "flows.implicit.refreshUrl" | "flows.implicit.scopes" | "flows.implicit.selectedScopes" | "flows.implicit.x-scalar-client-id" | `flows.implicit.scopes.${string}` | `flows.implicit.selectedScopes.${number}` | "flows.implicit.authorizationUrl" | "flows.implicit.x-scalar-redirect-uri" | "flows.clientCredentials.type" | "flows.clientCredentials.token" | "flows.clientCredentials.refreshUrl" | "flows.clientCredentials.scopes" | "flows.clientCredentials.selectedScopes" | "flows.clientCredentials.x-scalar-client-id" | "flows.clientCredentials.tokenUrl" | "flows.clientCredentials.clientSecret" | `flows.clientCredentials.scopes.${string}` | `flows.clientCredentials.selectedScopes.${number}` | "flows.authorizationCode.type" | "flows.authorizationCode.token" | "flows.authorizationCode.refreshUrl" | "flows.authorizationCode.scopes" | "flows.authorizationCode.selectedScopes" | "flows.authorizationCode.x-scalar-client-id" | "flows.authorizationCode.tokenUrl" | "flows.authorizationCode.clientSecret" | `flows.authorizationCode.scopes.${string}` | `flows.authorizationCode.selectedScopes.${number}` | "flows.authorizationCode.authorizationUrl" | "flows.authorizationCode.x-scalar-redirect-uri" | "flows.authorizationCode.x-usePkce">(uid: (string & import("zod").BRAND<"securityScheme">) | null | undefined, path: P, value: (P extends "value" | "description" | "type" | "name" | "in" | "uid" | "nameKey" ? {
                name: string;
                type: "apiKey";
                value: string;
                uid: string & import("zod").BRAND<"securityScheme">;
                nameKey: string;
                in: "cookie" | "query" | "header";
                description?: string | undefined;
            }[P] : P extends `${infer K}.${infer R}` ? K extends "value" | "description" | "type" | "name" | "in" | "uid" | "nameKey" ? R extends import("@scalar/object-utils/nested").Path<{
                name: string;
                type: "apiKey";
                value: string;
                uid: string & import("zod").BRAND<"securityScheme">;
                nameKey: string;
                in: "cookie" | "query" | "header";
                description?: string | undefined;
            }[K]> ? import("@scalar/object-utils/nested").PathValue<{
                name: string;
                type: "apiKey";
                value: string;
                uid: string & import("zod").BRAND<"securityScheme">;
                nameKey: string;
                in: "cookie" | "query" | "header";
                description?: string | undefined;
            }[K], R> : never : K extends `${number}` ? never : never : P extends `${number}` ? never : never) | (P extends "description" | "type" | "uid" | "nameKey" | "scheme" | "bearerFormat" | "password" | "username" | "token" ? {
                type: "http";
                uid: string & import("zod").BRAND<"securityScheme">;
                nameKey: string;
                scheme: "basic" | "bearer";
                bearerFormat: string;
                username: string;
                password: string;
                token: string;
                description?: string | undefined;
            }[P] : P extends `${infer K}.${infer R_1}` ? K extends "description" | "type" | "uid" | "nameKey" | "scheme" | "bearerFormat" | "password" | "username" | "token" ? R_1 extends import("@scalar/object-utils/nested").Path<{
                type: "http";
                uid: string & import("zod").BRAND<"securityScheme">;
                nameKey: string;
                scheme: "basic" | "bearer";
                bearerFormat: string;
                username: string;
                password: string;
                token: string;
                description?: string | undefined;
            }[K]> ? import("@scalar/object-utils/nested").PathValue<{
                type: "http";
                uid: string & import("zod").BRAND<"securityScheme">;
                nameKey: string;
                scheme: "basic" | "bearer";
                bearerFormat: string;
                username: string;
                password: string;
                token: string;
                description?: string | undefined;
            }[K], R_1> : never : K extends `${number}` ? never : never : P extends `${number}` ? never : never) | (P extends "description" | "type" | "uid" | "nameKey" | "openIdConnectUrl" ? {
                type: "openIdConnect";
                uid: string & import("zod").BRAND<"securityScheme">;
                nameKey: string;
                openIdConnectUrl: string;
                description?: string | undefined;
            }[P] : P extends `${infer K}.${infer R_2}` ? K extends "description" | "type" | "uid" | "nameKey" | "openIdConnectUrl" ? R_2 extends import("@scalar/object-utils/nested").Path<{
                type: "openIdConnect";
                uid: string & import("zod").BRAND<"securityScheme">;
                nameKey: string;
                openIdConnectUrl: string;
                description?: string | undefined;
            }[K]> ? import("@scalar/object-utils/nested").PathValue<{
                type: "openIdConnect";
                uid: string & import("zod").BRAND<"securityScheme">;
                nameKey: string;
                openIdConnectUrl: string;
                description?: string | undefined;
            }[K], R_2> : never : K extends `${number}` ? never : never : P extends `${number}` ? never : never) | (P extends "description" | "type" | "uid" | "nameKey" | "x-default-scopes" | "flows" ? {
                type: "oauth2";
                uid: string & import("zod").BRAND<"securityScheme">;
                nameKey: string;
                flows: {
                    password?: {
                        type: "password";
                        username: string;
                        password: string;
                        token: string;
                        refreshUrl: string;
                        scopes: Record<string, string>;
                        selectedScopes: string[];
                        "x-scalar-client-id": string;
                        tokenUrl: string;
                        clientSecret: string;
                    } | undefined;
                    implicit?: {
                        type: "implicit";
                        token: string;
                        refreshUrl: string;
                        scopes: Record<string, string>;
                        selectedScopes: string[];
                        "x-scalar-client-id": string;
                        authorizationUrl: string;
                        "x-scalar-redirect-uri": string;
                    } | undefined;
                    clientCredentials?: {
                        type: "clientCredentials";
                        token: string;
                        refreshUrl: string;
                        scopes: Record<string, string>;
                        selectedScopes: string[];
                        "x-scalar-client-id": string;
                        tokenUrl: string;
                        clientSecret: string;
                    } | undefined;
                    authorizationCode?: {
                        type: "authorizationCode";
                        token: string;
                        refreshUrl: string;
                        scopes: Record<string, string>;
                        selectedScopes: string[];
                        "x-scalar-client-id": string;
                        authorizationUrl: string;
                        "x-scalar-redirect-uri": string;
                        tokenUrl: string;
                        clientSecret: string;
                        "x-usePkce": "SHA-256" | "plain" | "no";
                    } | undefined;
                };
                description?: string | undefined;
                "x-default-scopes"?: string | string[] | undefined;
            }[P] : P extends `${infer K}.${infer R_3}` ? K extends "description" | "type" | "uid" | "nameKey" | "x-default-scopes" | "flows" ? R_3 extends import("@scalar/object-utils/nested").Path<{
                type: "oauth2";
                uid: string & import("zod").BRAND<"securityScheme">;
                nameKey: string;
                flows: {
                    password?: {
                        type: "password";
                        username: string;
                        password: string;
                        token: string;
                        refreshUrl: string;
                        scopes: Record<string, string>;
                        selectedScopes: string[];
                        "x-scalar-client-id": string;
                        tokenUrl: string;
                        clientSecret: string;
                    } | undefined;
                    implicit?: {
                        type: "implicit";
                        token: string;
                        refreshUrl: string;
                        scopes: Record<string, string>;
                        selectedScopes: string[];
                        "x-scalar-client-id": string;
                        authorizationUrl: string;
                        "x-scalar-redirect-uri": string;
                    } | undefined;
                    clientCredentials?: {
                        type: "clientCredentials";
                        token: string;
                        refreshUrl: string;
                        scopes: Record<string, string>;
                        selectedScopes: string[];
                        "x-scalar-client-id": string;
                        tokenUrl: string;
                        clientSecret: string;
                    } | undefined;
                    authorizationCode?: {
                        type: "authorizationCode";
                        token: string;
                        refreshUrl: string;
                        scopes: Record<string, string>;
                        selectedScopes: string[];
                        "x-scalar-client-id": string;
                        authorizationUrl: string;
                        "x-scalar-redirect-uri": string;
                        tokenUrl: string;
                        clientSecret: string;
                        "x-usePkce": "SHA-256" | "plain" | "no";
                    } | undefined;
                };
                description?: string | undefined;
                "x-default-scopes"?: string | string[] | undefined;
            }[K]> ? import("@scalar/object-utils/nested").PathValue<{
                type: "oauth2";
                uid: string & import("zod").BRAND<"securityScheme">;
                nameKey: string;
                flows: {
                    password?: {
                        type: "password";
                        username: string;
                        password: string;
                        token: string;
                        refreshUrl: string;
                        scopes: Record<string, string>;
                        selectedScopes: string[];
                        "x-scalar-client-id": string;
                        tokenUrl: string;
                        clientSecret: string;
                    } | undefined;
                    implicit?: {
                        type: "implicit";
                        token: string;
                        refreshUrl: string;
                        scopes: Record<string, string>;
                        selectedScopes: string[];
                        "x-scalar-client-id": string;
                        authorizationUrl: string;
                        "x-scalar-redirect-uri": string;
                    } | undefined;
                    clientCredentials?: {
                        type: "clientCredentials";
                        token: string;
                        refreshUrl: string;
                        scopes: Record<string, string>;
                        selectedScopes: string[];
                        "x-scalar-client-id": string;
                        tokenUrl: string;
                        clientSecret: string;
                    } | undefined;
                    authorizationCode?: {
                        type: "authorizationCode";
                        token: string;
                        refreshUrl: string;
                        scopes: Record<string, string>;
                        selectedScopes: string[];
                        "x-scalar-client-id": string;
                        authorizationUrl: string;
                        "x-scalar-redirect-uri": string;
                        tokenUrl: string;
                        clientSecret: string;
                        "x-usePkce": "SHA-256" | "plain" | "no";
                    } | undefined;
                };
                description?: string | undefined;
                "x-default-scopes"?: string | string[] | undefined;
            }[K], R_3> : never : K extends `${number}` ? never : never : P extends `${number}` ? never : never)) => void;
            untrackedEdit: <P extends "value" | "description" | "type" | "name" | "in" | "uid" | "nameKey" | "scheme" | "bearerFormat" | "openIdConnectUrl" | "x-default-scopes" | "flows" | "password" | "username" | "token" | `x-default-scopes.${number}` | "flows.password" | "flows.implicit" | "flows.clientCredentials" | "flows.authorizationCode" | "flows.password.type" | "flows.password.password" | "flows.password.username" | "flows.password.token" | "flows.password.refreshUrl" | "flows.password.scopes" | "flows.password.selectedScopes" | "flows.password.x-scalar-client-id" | "flows.password.tokenUrl" | "flows.password.clientSecret" | `flows.password.scopes.${string}` | `flows.password.selectedScopes.${number}` | "flows.implicit.type" | "flows.implicit.token" | "flows.implicit.refreshUrl" | "flows.implicit.scopes" | "flows.implicit.selectedScopes" | "flows.implicit.x-scalar-client-id" | `flows.implicit.scopes.${string}` | `flows.implicit.selectedScopes.${number}` | "flows.implicit.authorizationUrl" | "flows.implicit.x-scalar-redirect-uri" | "flows.clientCredentials.type" | "flows.clientCredentials.token" | "flows.clientCredentials.refreshUrl" | "flows.clientCredentials.scopes" | "flows.clientCredentials.selectedScopes" | "flows.clientCredentials.x-scalar-client-id" | "flows.clientCredentials.tokenUrl" | "flows.clientCredentials.clientSecret" | `flows.clientCredentials.scopes.${string}` | `flows.clientCredentials.selectedScopes.${number}` | "flows.authorizationCode.type" | "flows.authorizationCode.token" | "flows.authorizationCode.refreshUrl" | "flows.authorizationCode.scopes" | "flows.authorizationCode.selectedScopes" | "flows.authorizationCode.x-scalar-client-id" | "flows.authorizationCode.tokenUrl" | "flows.authorizationCode.clientSecret" | `flows.authorizationCode.scopes.${string}` | `flows.authorizationCode.selectedScopes.${number}` | "flows.authorizationCode.authorizationUrl" | "flows.authorizationCode.x-scalar-redirect-uri" | "flows.authorizationCode.x-usePkce">(uid: string & import("zod").BRAND<"securityScheme">, path: P, value: (P extends "value" | "description" | "type" | "name" | "in" | "uid" | "nameKey" ? {
                name: string;
                type: "apiKey";
                value: string;
                uid: string & import("zod").BRAND<"securityScheme">;
                nameKey: string;
                in: "cookie" | "query" | "header";
                description?: string | undefined;
            }[P] : P extends `${infer K}.${infer R}` ? K extends "value" | "description" | "type" | "name" | "in" | "uid" | "nameKey" ? R extends import("@scalar/object-utils/nested").Path<{
                name: string;
                type: "apiKey";
                value: string;
                uid: string & import("zod").BRAND<"securityScheme">;
                nameKey: string;
                in: "cookie" | "query" | "header";
                description?: string | undefined;
            }[K]> ? import("@scalar/object-utils/nested").PathValue<{
                name: string;
                type: "apiKey";
                value: string;
                uid: string & import("zod").BRAND<"securityScheme">;
                nameKey: string;
                in: "cookie" | "query" | "header";
                description?: string | undefined;
            }[K], R> : never : K extends `${number}` ? never : never : P extends `${number}` ? never : never) | (P extends "description" | "type" | "uid" | "nameKey" | "scheme" | "bearerFormat" | "password" | "username" | "token" ? {
                type: "http";
                uid: string & import("zod").BRAND<"securityScheme">;
                nameKey: string;
                scheme: "basic" | "bearer";
                bearerFormat: string;
                username: string;
                password: string;
                token: string;
                description?: string | undefined;
            }[P] : P extends `${infer K}.${infer R_1}` ? K extends "description" | "type" | "uid" | "nameKey" | "scheme" | "bearerFormat" | "password" | "username" | "token" ? R_1 extends import("@scalar/object-utils/nested").Path<{
                type: "http";
                uid: string & import("zod").BRAND<"securityScheme">;
                nameKey: string;
                scheme: "basic" | "bearer";
                bearerFormat: string;
                username: string;
                password: string;
                token: string;
                description?: string | undefined;
            }[K]> ? import("@scalar/object-utils/nested").PathValue<{
                type: "http";
                uid: string & import("zod").BRAND<"securityScheme">;
                nameKey: string;
                scheme: "basic" | "bearer";
                bearerFormat: string;
                username: string;
                password: string;
                token: string;
                description?: string | undefined;
            }[K], R_1> : never : K extends `${number}` ? never : never : P extends `${number}` ? never : never) | (P extends "description" | "type" | "uid" | "nameKey" | "openIdConnectUrl" ? {
                type: "openIdConnect";
                uid: string & import("zod").BRAND<"securityScheme">;
                nameKey: string;
                openIdConnectUrl: string;
                description?: string | undefined;
            }[P] : P extends `${infer K}.${infer R_2}` ? K extends "description" | "type" | "uid" | "nameKey" | "openIdConnectUrl" ? R_2 extends import("@scalar/object-utils/nested").Path<{
                type: "openIdConnect";
                uid: string & import("zod").BRAND<"securityScheme">;
                nameKey: string;
                openIdConnectUrl: string;
                description?: string | undefined;
            }[K]> ? import("@scalar/object-utils/nested").PathValue<{
                type: "openIdConnect";
                uid: string & import("zod").BRAND<"securityScheme">;
                nameKey: string;
                openIdConnectUrl: string;
                description?: string | undefined;
            }[K], R_2> : never : K extends `${number}` ? never : never : P extends `${number}` ? never : never) | (P extends "description" | "type" | "uid" | "nameKey" | "x-default-scopes" | "flows" ? {
                type: "oauth2";
                uid: string & import("zod").BRAND<"securityScheme">;
                nameKey: string;
                flows: {
                    password?: {
                        type: "password";
                        username: string;
                        password: string;
                        token: string;
                        refreshUrl: string;
                        scopes: Record<string, string>;
                        selectedScopes: string[];
                        "x-scalar-client-id": string;
                        tokenUrl: string;
                        clientSecret: string;
                    } | undefined;
                    implicit?: {
                        type: "implicit";
                        token: string;
                        refreshUrl: string;
                        scopes: Record<string, string>;
                        selectedScopes: string[];
                        "x-scalar-client-id": string;
                        authorizationUrl: string;
                        "x-scalar-redirect-uri": string;
                    } | undefined;
                    clientCredentials?: {
                        type: "clientCredentials";
                        token: string;
                        refreshUrl: string;
                        scopes: Record<string, string>;
                        selectedScopes: string[];
                        "x-scalar-client-id": string;
                        tokenUrl: string;
                        clientSecret: string;
                    } | undefined;
                    authorizationCode?: {
                        type: "authorizationCode";
                        token: string;
                        refreshUrl: string;
                        scopes: Record<string, string>;
                        selectedScopes: string[];
                        "x-scalar-client-id": string;
                        authorizationUrl: string;
                        "x-scalar-redirect-uri": string;
                        tokenUrl: string;
                        clientSecret: string;
                        "x-usePkce": "SHA-256" | "plain" | "no";
                    } | undefined;
                };
                description?: string | undefined;
                "x-default-scopes"?: string | string[] | undefined;
            }[P] : P extends `${infer K}.${infer R_3}` ? K extends "description" | "type" | "uid" | "nameKey" | "x-default-scopes" | "flows" ? R_3 extends import("@scalar/object-utils/nested").Path<{
                type: "oauth2";
                uid: string & import("zod").BRAND<"securityScheme">;
                nameKey: string;
                flows: {
                    password?: {
                        type: "password";
                        username: string;
                        password: string;
                        token: string;
                        refreshUrl: string;
                        scopes: Record<string, string>;
                        selectedScopes: string[];
                        "x-scalar-client-id": string;
                        tokenUrl: string;
                        clientSecret: string;
                    } | undefined;
                    implicit?: {
                        type: "implicit";
                        token: string;
                        refreshUrl: string;
                        scopes: Record<string, string>;
                        selectedScopes: string[];
                        "x-scalar-client-id": string;
                        authorizationUrl: string;
                        "x-scalar-redirect-uri": string;
                    } | undefined;
                    clientCredentials?: {
                        type: "clientCredentials";
                        token: string;
                        refreshUrl: string;
                        scopes: Record<string, string>;
                        selectedScopes: string[];
                        "x-scalar-client-id": string;
                        tokenUrl: string;
                        clientSecret: string;
                    } | undefined;
                    authorizationCode?: {
                        type: "authorizationCode";
                        token: string;
                        refreshUrl: string;
                        scopes: Record<string, string>;
                        selectedScopes: string[];
                        "x-scalar-client-id": string;
                        authorizationUrl: string;
                        "x-scalar-redirect-uri": string;
                        tokenUrl: string;
                        clientSecret: string;
                        "x-usePkce": "SHA-256" | "plain" | "no";
                    } | undefined;
                };
                description?: string | undefined;
                "x-default-scopes"?: string | string[] | undefined;
            }[K]> ? import("@scalar/object-utils/nested").PathValue<{
                type: "oauth2";
                uid: string & import("zod").BRAND<"securityScheme">;
                nameKey: string;
                flows: {
                    password?: {
                        type: "password";
                        username: string;
                        password: string;
                        token: string;
                        refreshUrl: string;
                        scopes: Record<string, string>;
                        selectedScopes: string[];
                        "x-scalar-client-id": string;
                        tokenUrl: string;
                        clientSecret: string;
                    } | undefined;
                    implicit?: {
                        type: "implicit";
                        token: string;
                        refreshUrl: string;
                        scopes: Record<string, string>;
                        selectedScopes: string[];
                        "x-scalar-client-id": string;
                        authorizationUrl: string;
                        "x-scalar-redirect-uri": string;
                    } | undefined;
                    clientCredentials?: {
                        type: "clientCredentials";
                        token: string;
                        refreshUrl: string;
                        scopes: Record<string, string>;
                        selectedScopes: string[];
                        "x-scalar-client-id": string;
                        tokenUrl: string;
                        clientSecret: string;
                    } | undefined;
                    authorizationCode?: {
                        type: "authorizationCode";
                        token: string;
                        refreshUrl: string;
                        scopes: Record<string, string>;
                        selectedScopes: string[];
                        "x-scalar-client-id": string;
                        authorizationUrl: string;
                        "x-scalar-redirect-uri": string;
                        tokenUrl: string;
                        clientSecret: string;
                        "x-usePkce": "SHA-256" | "plain" | "no";
                    } | undefined;
                };
                description?: string | undefined;
                "x-default-scopes"?: string | string[] | undefined;
            }[K], R_3> : never : K extends `${number}` ? never : never : P extends `${number}` ? never : never)) => void;
            undo: (uid: string & import("zod").BRAND<"securityScheme">) => void;
            redo: (uid: string & import("zod").BRAND<"securityScheme">) => void;
            reset: () => void;
        };
        tagMutators: {
            rawAdd: (item: {
                uid: string & import("zod").BRAND<"tag">;
                name: string;
                type: "tag";
                children: ((string & import("zod").BRAND<"tag">) | (string & import("zod").BRAND<"operation">))[];
                description?: string | undefined;
                externalDocs?: {
                    url: string;
                    description?: string | undefined;
                } | undefined;
                "x-scalar-children"?: {
                    tagName: string;
                }[] | undefined;
                "x-internal"?: boolean | undefined;
                "x-scalar-ignore"?: boolean | undefined;
            }) => void;
            add: (payload: import("@scalar/oas-utils/entities/spec").TagPayload, collectionUid: import("@scalar/oas-utils/entities/spec").Collection["uid"]) => void | {
                uid: string & import("zod").BRAND<"tag">;
                name: string;
                type: "tag";
                children: ((string & import("zod").BRAND<"tag">) | (string & import("zod").BRAND<"operation">))[];
                description?: string | undefined;
                externalDocs?: {
                    url: string;
                    description?: string | undefined;
                } | undefined;
                "x-scalar-children"?: {
                    tagName: string;
                }[] | undefined;
                "x-internal"?: boolean | undefined;
                "x-scalar-ignore"?: boolean | undefined;
            };
            delete: (tag: import("@scalar/oas-utils/entities/spec").Tag, collectionUid: import("@scalar/oas-utils/entities/spec").Collection["uid"]) => void;
            set: (item: {
                uid: string & import("zod").BRAND<"tag">;
                name: string;
                type: "tag";
                children: ((string & import("zod").BRAND<"tag">) | (string & import("zod").BRAND<"operation">))[];
                description?: string | undefined;
                externalDocs?: {
                    url: string;
                    description?: string | undefined;
                } | undefined;
                "x-scalar-children"?: {
                    tagName: string;
                }[] | undefined;
                "x-internal"?: boolean | undefined;
                "x-scalar-ignore"?: boolean | undefined;
            }) => void;
            edit: <P extends "description" | "externalDocs" | "x-internal" | "x-scalar-ignore" | "type" | "name" | "uid" | "children" | "externalDocs.url" | "externalDocs.description" | `children.${number}` | "x-scalar-children" | `x-scalar-children.${number}` | `x-scalar-children.${number}.tagName`>(uid: (string & import("zod").BRAND<"tag">) | null | undefined, path: P, value: P extends "description" | "externalDocs" | "x-internal" | "x-scalar-ignore" | "type" | "name" | "uid" | "children" | "x-scalar-children" ? {
                uid: string & import("zod").BRAND<"tag">;
                name: string;
                type: "tag";
                children: ((string & import("zod").BRAND<"tag">) | (string & import("zod").BRAND<"operation">))[];
                description?: string | undefined;
                externalDocs?: {
                    url: string;
                    description?: string | undefined;
                } | undefined;
                "x-scalar-children"?: {
                    tagName: string;
                }[] | undefined;
                "x-internal"?: boolean | undefined;
                "x-scalar-ignore"?: boolean | undefined;
            }[P] : P extends `${infer K}.${infer R}` ? K extends "description" | "externalDocs" | "x-internal" | "x-scalar-ignore" | "type" | "name" | "uid" | "children" | "x-scalar-children" ? R extends import("@scalar/object-utils/nested").Path<{
                uid: string & import("zod").BRAND<"tag">;
                name: string;
                type: "tag";
                children: ((string & import("zod").BRAND<"tag">) | (string & import("zod").BRAND<"operation">))[];
                description?: string | undefined;
                externalDocs?: {
                    url: string;
                    description?: string | undefined;
                } | undefined;
                "x-scalar-children"?: {
                    tagName: string;
                }[] | undefined;
                "x-internal"?: boolean | undefined;
                "x-scalar-ignore"?: boolean | undefined;
            }[K]> ? import("@scalar/object-utils/nested").PathValue<{
                uid: string & import("zod").BRAND<"tag">;
                name: string;
                type: "tag";
                children: ((string & import("zod").BRAND<"tag">) | (string & import("zod").BRAND<"operation">))[];
                description?: string | undefined;
                externalDocs?: {
                    url: string;
                    description?: string | undefined;
                } | undefined;
                "x-scalar-children"?: {
                    tagName: string;
                }[] | undefined;
                "x-internal"?: boolean | undefined;
                "x-scalar-ignore"?: boolean | undefined;
            }[K], R> : never : K extends `${number}` ? never : never : P extends `${number}` ? never : never) => void;
            untrackedEdit: <P extends "description" | "externalDocs" | "x-internal" | "x-scalar-ignore" | "type" | "name" | "uid" | "children" | "externalDocs.url" | "externalDocs.description" | `children.${number}` | "x-scalar-children" | `x-scalar-children.${number}` | `x-scalar-children.${number}.tagName`>(uid: string & import("zod").BRAND<"tag">, path: P, value: P extends "description" | "externalDocs" | "x-internal" | "x-scalar-ignore" | "type" | "name" | "uid" | "children" | "x-scalar-children" ? {
                uid: string & import("zod").BRAND<"tag">;
                name: string;
                type: "tag";
                children: ((string & import("zod").BRAND<"tag">) | (string & import("zod").BRAND<"operation">))[];
                description?: string | undefined;
                externalDocs?: {
                    url: string;
                    description?: string | undefined;
                } | undefined;
                "x-scalar-children"?: {
                    tagName: string;
                }[] | undefined;
                "x-internal"?: boolean | undefined;
                "x-scalar-ignore"?: boolean | undefined;
            }[P] : P extends `${infer K}.${infer R}` ? K extends "description" | "externalDocs" | "x-internal" | "x-scalar-ignore" | "type" | "name" | "uid" | "children" | "x-scalar-children" ? R extends import("@scalar/object-utils/nested").Path<{
                uid: string & import("zod").BRAND<"tag">;
                name: string;
                type: "tag";
                children: ((string & import("zod").BRAND<"tag">) | (string & import("zod").BRAND<"operation">))[];
                description?: string | undefined;
                externalDocs?: {
                    url: string;
                    description?: string | undefined;
                } | undefined;
                "x-scalar-children"?: {
                    tagName: string;
                }[] | undefined;
                "x-internal"?: boolean | undefined;
                "x-scalar-ignore"?: boolean | undefined;
            }[K]> ? import("@scalar/object-utils/nested").PathValue<{
                uid: string & import("zod").BRAND<"tag">;
                name: string;
                type: "tag";
                children: ((string & import("zod").BRAND<"tag">) | (string & import("zod").BRAND<"operation">))[];
                description?: string | undefined;
                externalDocs?: {
                    url: string;
                    description?: string | undefined;
                } | undefined;
                "x-scalar-children"?: {
                    tagName: string;
                }[] | undefined;
                "x-internal"?: boolean | undefined;
                "x-scalar-ignore"?: boolean | undefined;
            }[K], R> : never : K extends `${number}` ? never : never : P extends `${number}` ? never : never) => void;
            undo: (uid: string & import("zod").BRAND<"tag">) => void;
            redo: (uid: string & import("zod").BRAND<"tag">) => void;
            reset: () => void;
        };
        workspaceMutators: {
            rawAdd: (item: {
                uid: string & import("zod").BRAND<"workspace">;
                name: string;
                description: string;
                cookies: (string & import("zod").BRAND<"cookie">)[];
                collections: (string & import("zod").BRAND<"collection">)[];
                environments: Record<string, string>;
                activeEnvironmentId: string;
                themeId: "default" | "alternate" | "moon" | "purple" | "solarized" | "bluePlanet" | "deepSpace" | "saturn" | "kepler" | "elysiajs" | "fastify" | "mars" | "laserwave" | "none";
                selectedHttpClient: {
                    targetKey: string;
                    clientKey: string;
                };
                hotKeyConfig?: {
                    modifiers: ("default" | "Meta" | "Control" | "Shift" | "Alt")[];
                    hotKeys?: Partial<Record<"" | "0" | "Space" | "Backspace" | "Tab" | "Enter" | "Escape" | "ArrowDown" | "ArrowLeft" | "ArrowRight" | "ArrowUp" | "End" | "Home" | "PageDown" | "PageUp" | "Delete" | "1" | "2" | "3" | "4" | "5" | "6" | "7" | "8" | "9" | "a" | "b" | "c" | "d" | "e" | "f" | "g" | "h" | "i" | "j" | "k" | "l" | "m" | "n" | "o" | "p" | "q" | "r" | "s" | "t" | "u" | "v" | "w" | "x" | "y" | "z" | "*" | "+" | "-" | "." | "/" | "F1" | "F2" | "F3" | "F4" | "F5" | "F6" | "F7" | "F8" | "F9" | "F10" | "F11" | "F12" | ";" | "=" | "," | "`" | "[" | "\\" | "]", {
                        event: "addTopNav" | "closeModal" | "closeTopNav" | "createNew" | "executeRequest" | "focusAddressBar" | "focusRequestSearch" | "jumpToLastTab" | "jumpToTab" | "navigateSearchResultsDown" | "navigateSearchResultsUp" | "navigateTopNavLeft" | "navigateTopNavRight" | "openCommandPalette" | "selectSearchResult" | "toggleSidebar";
                        modifiers?: ("default" | "Meta" | "Control" | "Shift" | "Alt")[] | undefined;
                    }>> | undefined;
                } | undefined;
                proxyUrl?: string | undefined;
            }) => void;
            add: (payload?: Partial<import("@scalar/oas-utils/entities/workspace").Workspace>) => {
                uid: string & import("zod").BRAND<"workspace">;
                name: string;
                description: string;
                cookies: (string & import("zod").BRAND<"cookie">)[];
                collections: (string & import("zod").BRAND<"collection">)[];
                environments: Record<string, string>;
                activeEnvironmentId: string;
                themeId: "default" | "alternate" | "moon" | "purple" | "solarized" | "bluePlanet" | "deepSpace" | "saturn" | "kepler" | "elysiajs" | "fastify" | "mars" | "laserwave" | "none";
                selectedHttpClient: {
                    targetKey: string;
                    clientKey: string;
                };
                hotKeyConfig?: {
                    modifiers: ("default" | "Meta" | "Control" | "Shift" | "Alt")[];
                    hotKeys?: Partial<Record<"" | "0" | "Space" | "Backspace" | "Tab" | "Enter" | "Escape" | "ArrowDown" | "ArrowLeft" | "ArrowRight" | "ArrowUp" | "End" | "Home" | "PageDown" | "PageUp" | "Delete" | "1" | "2" | "3" | "4" | "5" | "6" | "7" | "8" | "9" | "a" | "b" | "c" | "d" | "e" | "f" | "g" | "h" | "i" | "j" | "k" | "l" | "m" | "n" | "o" | "p" | "q" | "r" | "s" | "t" | "u" | "v" | "w" | "x" | "y" | "z" | "*" | "+" | "-" | "." | "/" | "F1" | "F2" | "F3" | "F4" | "F5" | "F6" | "F7" | "F8" | "F9" | "F10" | "F11" | "F12" | ";" | "=" | "," | "`" | "[" | "\\" | "]", {
                        event: "addTopNav" | "closeModal" | "closeTopNav" | "createNew" | "executeRequest" | "focusAddressBar" | "focusRequestSearch" | "jumpToLastTab" | "jumpToTab" | "navigateSearchResultsDown" | "navigateSearchResultsUp" | "navigateTopNavLeft" | "navigateTopNavRight" | "openCommandPalette" | "selectSearchResult" | "toggleSidebar";
                        modifiers?: ("default" | "Meta" | "Control" | "Shift" | "Alt")[] | undefined;
                    }>> | undefined;
                } | undefined;
                proxyUrl?: string | undefined;
            };
            delete: (uid: import("@scalar/oas-utils/entities/workspace").Workspace["uid"]) => void;
            set: (item: {
                uid: string & import("zod").BRAND<"workspace">;
                name: string;
                description: string;
                cookies: (string & import("zod").BRAND<"cookie">)[];
                collections: (string & import("zod").BRAND<"collection">)[];
                environments: Record<string, string>;
                activeEnvironmentId: string;
                themeId: "default" | "alternate" | "moon" | "purple" | "solarized" | "bluePlanet" | "deepSpace" | "saturn" | "kepler" | "elysiajs" | "fastify" | "mars" | "laserwave" | "none";
                selectedHttpClient: {
                    targetKey: string;
                    clientKey: string;
                };
                hotKeyConfig?: {
                    modifiers: ("default" | "Meta" | "Control" | "Shift" | "Alt")[];
                    hotKeys?: Partial<Record<"" | "0" | "Space" | "Backspace" | "Tab" | "Enter" | "Escape" | "ArrowDown" | "ArrowLeft" | "ArrowRight" | "ArrowUp" | "End" | "Home" | "PageDown" | "PageUp" | "Delete" | "1" | "2" | "3" | "4" | "5" | "6" | "7" | "8" | "9" | "a" | "b" | "c" | "d" | "e" | "f" | "g" | "h" | "i" | "j" | "k" | "l" | "m" | "n" | "o" | "p" | "q" | "r" | "s" | "t" | "u" | "v" | "w" | "x" | "y" | "z" | "*" | "+" | "-" | "." | "/" | "F1" | "F2" | "F3" | "F4" | "F5" | "F6" | "F7" | "F8" | "F9" | "F10" | "F11" | "F12" | ";" | "=" | "," | "`" | "[" | "\\" | "]", {
                        event: "addTopNav" | "closeModal" | "closeTopNav" | "createNew" | "executeRequest" | "focusAddressBar" | "focusRequestSearch" | "jumpToLastTab" | "jumpToTab" | "navigateSearchResultsDown" | "navigateSearchResultsUp" | "navigateTopNavLeft" | "navigateTopNavRight" | "openCommandPalette" | "selectSearchResult" | "toggleSidebar";
                        modifiers?: ("default" | "Meta" | "Control" | "Shift" | "Alt")[] | undefined;
                    }>> | undefined;
                } | undefined;
                proxyUrl?: string | undefined;
            }) => void;
            edit: <P extends "proxyUrl" | "description" | "name" | "uid" | "collections" | "cookies" | "environments" | "activeEnvironmentId" | "themeId" | "selectedHttpClient" | "hotKeyConfig" | `collections.${number}` | `cookies.${number}` | `environments.${string}` | "selectedHttpClient.targetKey" | "selectedHttpClient.clientKey" | "hotKeyConfig.modifiers" | "hotKeyConfig.hotKeys" | `hotKeyConfig.modifiers.${number}` | "hotKeyConfig.hotKeys." | "hotKeyConfig.hotKeys.c" | "hotKeyConfig.hotKeys.r" | "hotKeyConfig.hotKeys.o" | "hotKeyConfig.hotKeys.n" | "hotKeyConfig.hotKeys.a" | "hotKeyConfig.hotKeys.b" | "hotKeyConfig.hotKeys.d" | "hotKeyConfig.hotKeys.e" | "hotKeyConfig.hotKeys.f" | "hotKeyConfig.hotKeys.g" | "hotKeyConfig.hotKeys.h" | "hotKeyConfig.hotKeys.i" | "hotKeyConfig.hotKeys.j" | "hotKeyConfig.hotKeys.k" | "hotKeyConfig.hotKeys.l" | "hotKeyConfig.hotKeys.m" | "hotKeyConfig.hotKeys.p" | "hotKeyConfig.hotKeys.q" | "hotKeyConfig.hotKeys.s" | "hotKeyConfig.hotKeys.t" | "hotKeyConfig.hotKeys.u" | "hotKeyConfig.hotKeys.v" | "hotKeyConfig.hotKeys.w" | "hotKeyConfig.hotKeys.x" | "hotKeyConfig.hotKeys.y" | "hotKeyConfig.hotKeys.z" | "hotKeyConfig.hotKeys.0" | "hotKeyConfig.hotKeys.Space" | "hotKeyConfig.hotKeys.Backspace" | "hotKeyConfig.hotKeys.Tab" | "hotKeyConfig.hotKeys.Enter" | "hotKeyConfig.hotKeys.Escape" | "hotKeyConfig.hotKeys.ArrowDown" | "hotKeyConfig.hotKeys.ArrowLeft" | "hotKeyConfig.hotKeys.ArrowRight" | "hotKeyConfig.hotKeys.ArrowUp" | "hotKeyConfig.hotKeys.End" | "hotKeyConfig.hotKeys.Home" | "hotKeyConfig.hotKeys.PageDown" | "hotKeyConfig.hotKeys.PageUp" | "hotKeyConfig.hotKeys.Delete" | "hotKeyConfig.hotKeys.1" | "hotKeyConfig.hotKeys.2" | "hotKeyConfig.hotKeys.3" | "hotKeyConfig.hotKeys.4" | "hotKeyConfig.hotKeys.5" | "hotKeyConfig.hotKeys.6" | "hotKeyConfig.hotKeys.7" | "hotKeyConfig.hotKeys.8" | "hotKeyConfig.hotKeys.9" | "hotKeyConfig.hotKeys.*" | "hotKeyConfig.hotKeys.+" | "hotKeyConfig.hotKeys.-" | "hotKeyConfig.hotKeys.." | "hotKeyConfig.hotKeys./" | "hotKeyConfig.hotKeys.F1" | "hotKeyConfig.hotKeys.F2" | "hotKeyConfig.hotKeys.F3" | "hotKeyConfig.hotKeys.F4" | "hotKeyConfig.hotKeys.F5" | "hotKeyConfig.hotKeys.F6" | "hotKeyConfig.hotKeys.F7" | "hotKeyConfig.hotKeys.F8" | "hotKeyConfig.hotKeys.F9" | "hotKeyConfig.hotKeys.F10" | "hotKeyConfig.hotKeys.F11" | "hotKeyConfig.hotKeys.F12" | "hotKeyConfig.hotKeys.;" | "hotKeyConfig.hotKeys.=" | "hotKeyConfig.hotKeys.," | "hotKeyConfig.hotKeys.`" | "hotKeyConfig.hotKeys.[" | "hotKeyConfig.hotKeys.\\" | "hotKeyConfig.hotKeys.]" | "hotKeyConfig.hotKeys..modifiers" | `hotKeyConfig.hotKeys..modifiers.${number}` | "hotKeyConfig.hotKeys..event" | "hotKeyConfig.hotKeys.c.modifiers" | `hotKeyConfig.hotKeys.c.modifiers.${number}` | "hotKeyConfig.hotKeys.c.event" | "hotKeyConfig.hotKeys.r.modifiers" | `hotKeyConfig.hotKeys.r.modifiers.${number}` | "hotKeyConfig.hotKeys.r.event" | "hotKeyConfig.hotKeys.o.modifiers" | `hotKeyConfig.hotKeys.o.modifiers.${number}` | "hotKeyConfig.hotKeys.o.event" | "hotKeyConfig.hotKeys.n.modifiers" | `hotKeyConfig.hotKeys.n.modifiers.${number}` | "hotKeyConfig.hotKeys.n.event" | "hotKeyConfig.hotKeys.a.modifiers" | `hotKeyConfig.hotKeys.a.modifiers.${number}` | "hotKeyConfig.hotKeys.a.event" | "hotKeyConfig.hotKeys.b.modifiers" | `hotKeyConfig.hotKeys.b.modifiers.${number}` | "hotKeyConfig.hotKeys.b.event" | "hotKeyConfig.hotKeys.d.modifiers" | `hotKeyConfig.hotKeys.d.modifiers.${number}` | "hotKeyConfig.hotKeys.d.event" | "hotKeyConfig.hotKeys.e.modifiers" | `hotKeyConfig.hotKeys.e.modifiers.${number}` | "hotKeyConfig.hotKeys.e.event" | "hotKeyConfig.hotKeys.f.modifiers" | `hotKeyConfig.hotKeys.f.modifiers.${number}` | "hotKeyConfig.hotKeys.f.event" | "hotKeyConfig.hotKeys.g.modifiers" | `hotKeyConfig.hotKeys.g.modifiers.${number}` | "hotKeyConfig.hotKeys.g.event" | "hotKeyConfig.hotKeys.h.modifiers" | `hotKeyConfig.hotKeys.h.modifiers.${number}` | "hotKeyConfig.hotKeys.h.event" | "hotKeyConfig.hotKeys.i.modifiers" | `hotKeyConfig.hotKeys.i.modifiers.${number}` | "hotKeyConfig.hotKeys.i.event" | "hotKeyConfig.hotKeys.j.modifiers" | `hotKeyConfig.hotKeys.j.modifiers.${number}` | "hotKeyConfig.hotKeys.j.event" | "hotKeyConfig.hotKeys.k.modifiers" | `hotKeyConfig.hotKeys.k.modifiers.${number}` | "hotKeyConfig.hotKeys.k.event" | "hotKeyConfig.hotKeys.l.modifiers" | `hotKeyConfig.hotKeys.l.modifiers.${number}` | "hotKeyConfig.hotKeys.l.event" | "hotKeyConfig.hotKeys.m.modifiers" | `hotKeyConfig.hotKeys.m.modifiers.${number}` | "hotKeyConfig.hotKeys.m.event" | "hotKeyConfig.hotKeys.p.modifiers" | `hotKeyConfig.hotKeys.p.modifiers.${number}` | "hotKeyConfig.hotKeys.p.event" | "hotKeyConfig.hotKeys.q.modifiers" | `hotKeyConfig.hotKeys.q.modifiers.${number}` | "hotKeyConfig.hotKeys.q.event" | "hotKeyConfig.hotKeys.s.modifiers" | `hotKeyConfig.hotKeys.s.modifiers.${number}` | "hotKeyConfig.hotKeys.s.event" | "hotKeyConfig.hotKeys.t.modifiers" | `hotKeyConfig.hotKeys.t.modifiers.${number}` | "hotKeyConfig.hotKeys.t.event" | "hotKeyConfig.hotKeys.u.modifiers" | `hotKeyConfig.hotKeys.u.modifiers.${number}` | "hotKeyConfig.hotKeys.u.event" | "hotKeyConfig.hotKeys.v.modifiers" | `hotKeyConfig.hotKeys.v.modifiers.${number}` | "hotKeyConfig.hotKeys.v.event" | "hotKeyConfig.hotKeys.w.modifiers" | `hotKeyConfig.hotKeys.w.modifiers.${number}` | "hotKeyConfig.hotKeys.w.event" | "hotKeyConfig.hotKeys.x.modifiers" | `hotKeyConfig.hotKeys.x.modifiers.${number}` | "hotKeyConfig.hotKeys.x.event" | "hotKeyConfig.hotKeys.y.modifiers" | `hotKeyConfig.hotKeys.y.modifiers.${number}` | "hotKeyConfig.hotKeys.y.event" | "hotKeyConfig.hotKeys.z.modifiers" | `hotKeyConfig.hotKeys.z.modifiers.${number}` | "hotKeyConfig.hotKeys.z.event" | "hotKeyConfig.hotKeys.0.modifiers" | `hotKeyConfig.hotKeys.0.modifiers.${number}` | "hotKeyConfig.hotKeys.0.event" | "hotKeyConfig.hotKeys.Space.modifiers" | `hotKeyConfig.hotKeys.Space.modifiers.${number}` | "hotKeyConfig.hotKeys.Space.event" | "hotKeyConfig.hotKeys.Backspace.modifiers" | `hotKeyConfig.hotKeys.Backspace.modifiers.${number}` | "hotKeyConfig.hotKeys.Backspace.event" | "hotKeyConfig.hotKeys.Tab.modifiers" | `hotKeyConfig.hotKeys.Tab.modifiers.${number}` | "hotKeyConfig.hotKeys.Tab.event" | "hotKeyConfig.hotKeys.Enter.modifiers" | `hotKeyConfig.hotKeys.Enter.modifiers.${number}` | "hotKeyConfig.hotKeys.Enter.event" | "hotKeyConfig.hotKeys.Escape.modifiers" | `hotKeyConfig.hotKeys.Escape.modifiers.${number}` | "hotKeyConfig.hotKeys.Escape.event" | "hotKeyConfig.hotKeys.ArrowDown.modifiers" | `hotKeyConfig.hotKeys.ArrowDown.modifiers.${number}` | "hotKeyConfig.hotKeys.ArrowDown.event" | "hotKeyConfig.hotKeys.ArrowLeft.modifiers" | `hotKeyConfig.hotKeys.ArrowLeft.modifiers.${number}` | "hotKeyConfig.hotKeys.ArrowLeft.event" | "hotKeyConfig.hotKeys.ArrowRight.modifiers" | `hotKeyConfig.hotKeys.ArrowRight.modifiers.${number}` | "hotKeyConfig.hotKeys.ArrowRight.event" | "hotKeyConfig.hotKeys.ArrowUp.modifiers" | `hotKeyConfig.hotKeys.ArrowUp.modifiers.${number}` | "hotKeyConfig.hotKeys.ArrowUp.event" | "hotKeyConfig.hotKeys.End.modifiers" | `hotKeyConfig.hotKeys.End.modifiers.${number}` | "hotKeyConfig.hotKeys.End.event" | "hotKeyConfig.hotKeys.Home.modifiers" | `hotKeyConfig.hotKeys.Home.modifiers.${number}` | "hotKeyConfig.hotKeys.Home.event" | "hotKeyConfig.hotKeys.PageDown.modifiers" | `hotKeyConfig.hotKeys.PageDown.modifiers.${number}` | "hotKeyConfig.hotKeys.PageDown.event" | "hotKeyConfig.hotKeys.PageUp.modifiers" | `hotKeyConfig.hotKeys.PageUp.modifiers.${number}` | "hotKeyConfig.hotKeys.PageUp.event" | "hotKeyConfig.hotKeys.Delete.modifiers" | `hotKeyConfig.hotKeys.Delete.modifiers.${number}` | "hotKeyConfig.hotKeys.Delete.event" | "hotKeyConfig.hotKeys.1.modifiers" | `hotKeyConfig.hotKeys.1.modifiers.${number}` | "hotKeyConfig.hotKeys.1.event" | "hotKeyConfig.hotKeys.2.modifiers" | `hotKeyConfig.hotKeys.2.modifiers.${number}` | "hotKeyConfig.hotKeys.2.event" | "hotKeyConfig.hotKeys.3.modifiers" | `hotKeyConfig.hotKeys.3.modifiers.${number}` | "hotKeyConfig.hotKeys.3.event" | "hotKeyConfig.hotKeys.4.modifiers" | `hotKeyConfig.hotKeys.4.modifiers.${number}` | "hotKeyConfig.hotKeys.4.event" | "hotKeyConfig.hotKeys.5.modifiers" | `hotKeyConfig.hotKeys.5.modifiers.${number}` | "hotKeyConfig.hotKeys.5.event" | "hotKeyConfig.hotKeys.6.modifiers" | `hotKeyConfig.hotKeys.6.modifiers.${number}` | "hotKeyConfig.hotKeys.6.event" | "hotKeyConfig.hotKeys.7.modifiers" | `hotKeyConfig.hotKeys.7.modifiers.${number}` | "hotKeyConfig.hotKeys.7.event" | "hotKeyConfig.hotKeys.8.modifiers" | `hotKeyConfig.hotKeys.8.modifiers.${number}` | "hotKeyConfig.hotKeys.8.event" | "hotKeyConfig.hotKeys.9.modifiers" | `hotKeyConfig.hotKeys.9.modifiers.${number}` | "hotKeyConfig.hotKeys.9.event" | "hotKeyConfig.hotKeys.*.modifiers" | `hotKeyConfig.hotKeys.*.modifiers.${number}` | "hotKeyConfig.hotKeys.*.event" | "hotKeyConfig.hotKeys.+.modifiers" | `hotKeyConfig.hotKeys.+.modifiers.${number}` | "hotKeyConfig.hotKeys.+.event" | "hotKeyConfig.hotKeys.-.modifiers" | `hotKeyConfig.hotKeys.-.modifiers.${number}` | "hotKeyConfig.hotKeys.-.event" | "hotKeyConfig.hotKeys...modifiers" | `hotKeyConfig.hotKeys...modifiers.${number}` | "hotKeyConfig.hotKeys...event" | "hotKeyConfig.hotKeys./.modifiers" | `hotKeyConfig.hotKeys./.modifiers.${number}` | "hotKeyConfig.hotKeys./.event" | "hotKeyConfig.hotKeys.F1.modifiers" | `hotKeyConfig.hotKeys.F1.modifiers.${number}` | "hotKeyConfig.hotKeys.F1.event" | "hotKeyConfig.hotKeys.F2.modifiers" | `hotKeyConfig.hotKeys.F2.modifiers.${number}` | "hotKeyConfig.hotKeys.F2.event" | "hotKeyConfig.hotKeys.F3.modifiers" | `hotKeyConfig.hotKeys.F3.modifiers.${number}` | "hotKeyConfig.hotKeys.F3.event" | "hotKeyConfig.hotKeys.F4.modifiers" | `hotKeyConfig.hotKeys.F4.modifiers.${number}` | "hotKeyConfig.hotKeys.F4.event" | "hotKeyConfig.hotKeys.F5.modifiers" | `hotKeyConfig.hotKeys.F5.modifiers.${number}` | "hotKeyConfig.hotKeys.F5.event" | "hotKeyConfig.hotKeys.F6.modifiers" | `hotKeyConfig.hotKeys.F6.modifiers.${number}` | "hotKeyConfig.hotKeys.F6.event" | "hotKeyConfig.hotKeys.F7.modifiers" | `hotKeyConfig.hotKeys.F7.modifiers.${number}` | "hotKeyConfig.hotKeys.F7.event" | "hotKeyConfig.hotKeys.F8.modifiers" | `hotKeyConfig.hotKeys.F8.modifiers.${number}` | "hotKeyConfig.hotKeys.F8.event" | "hotKeyConfig.hotKeys.F9.modifiers" | `hotKeyConfig.hotKeys.F9.modifiers.${number}` | "hotKeyConfig.hotKeys.F9.event" | "hotKeyConfig.hotKeys.F10.modifiers" | `hotKeyConfig.hotKeys.F10.modifiers.${number}` | "hotKeyConfig.hotKeys.F10.event" | "hotKeyConfig.hotKeys.F11.modifiers" | `hotKeyConfig.hotKeys.F11.modifiers.${number}` | "hotKeyConfig.hotKeys.F11.event" | "hotKeyConfig.hotKeys.F12.modifiers" | `hotKeyConfig.hotKeys.F12.modifiers.${number}` | "hotKeyConfig.hotKeys.F12.event" | "hotKeyConfig.hotKeys.;.modifiers" | `hotKeyConfig.hotKeys.;.modifiers.${number}` | "hotKeyConfig.hotKeys.;.event" | "hotKeyConfig.hotKeys.=.modifiers" | `hotKeyConfig.hotKeys.=.modifiers.${number}` | "hotKeyConfig.hotKeys.=.event" | "hotKeyConfig.hotKeys.,.modifiers" | `hotKeyConfig.hotKeys.,.modifiers.${number}` | "hotKeyConfig.hotKeys.,.event" | "hotKeyConfig.hotKeys.`.modifiers" | `hotKeyConfig.hotKeys.\`.modifiers.${number}` | "hotKeyConfig.hotKeys.`.event" | "hotKeyConfig.hotKeys.[.modifiers" | `hotKeyConfig.hotKeys.[.modifiers.${number}` | "hotKeyConfig.hotKeys.[.event" | "hotKeyConfig.hotKeys.\\.modifiers" | `hotKeyConfig.hotKeys.\\.modifiers.${number}` | "hotKeyConfig.hotKeys.\\.event" | "hotKeyConfig.hotKeys.].modifiers" | `hotKeyConfig.hotKeys.].modifiers.${number}` | "hotKeyConfig.hotKeys.].event">(uid: (string & import("zod").BRAND<"workspace">) | null | undefined, path: P, value: P extends "proxyUrl" | "description" | "name" | "uid" | "collections" | "cookies" | "environments" | "activeEnvironmentId" | "themeId" | "selectedHttpClient" | "hotKeyConfig" ? {
                uid: string & import("zod").BRAND<"workspace">;
                name: string;
                description: string;
                cookies: (string & import("zod").BRAND<"cookie">)[];
                collections: (string & import("zod").BRAND<"collection">)[];
                environments: Record<string, string>;
                activeEnvironmentId: string;
                themeId: "default" | "alternate" | "moon" | "purple" | "solarized" | "bluePlanet" | "deepSpace" | "saturn" | "kepler" | "elysiajs" | "fastify" | "mars" | "laserwave" | "none";
                selectedHttpClient: {
                    targetKey: string;
                    clientKey: string;
                };
                hotKeyConfig?: {
                    modifiers: ("default" | "Meta" | "Control" | "Shift" | "Alt")[];
                    hotKeys?: Partial<Record<"" | "0" | "Space" | "Backspace" | "Tab" | "Enter" | "Escape" | "ArrowDown" | "ArrowLeft" | "ArrowRight" | "ArrowUp" | "End" | "Home" | "PageDown" | "PageUp" | "Delete" | "1" | "2" | "3" | "4" | "5" | "6" | "7" | "8" | "9" | "a" | "b" | "c" | "d" | "e" | "f" | "g" | "h" | "i" | "j" | "k" | "l" | "m" | "n" | "o" | "p" | "q" | "r" | "s" | "t" | "u" | "v" | "w" | "x" | "y" | "z" | "*" | "+" | "-" | "." | "/" | "F1" | "F2" | "F3" | "F4" | "F5" | "F6" | "F7" | "F8" | "F9" | "F10" | "F11" | "F12" | ";" | "=" | "," | "`" | "[" | "\\" | "]", {
                        event: "addTopNav" | "closeModal" | "closeTopNav" | "createNew" | "executeRequest" | "focusAddressBar" | "focusRequestSearch" | "jumpToLastTab" | "jumpToTab" | "navigateSearchResultsDown" | "navigateSearchResultsUp" | "navigateTopNavLeft" | "navigateTopNavRight" | "openCommandPalette" | "selectSearchResult" | "toggleSidebar";
                        modifiers?: ("default" | "Meta" | "Control" | "Shift" | "Alt")[] | undefined;
                    }>> | undefined;
                } | undefined;
                proxyUrl?: string | undefined;
            }[P] : P extends `${infer K}.${infer R}` ? K extends "proxyUrl" | "description" | "name" | "uid" | "collections" | "cookies" | "environments" | "activeEnvironmentId" | "themeId" | "selectedHttpClient" | "hotKeyConfig" ? R extends import("@scalar/object-utils/nested").Path<{
                uid: string & import("zod").BRAND<"workspace">;
                name: string;
                description: string;
                cookies: (string & import("zod").BRAND<"cookie">)[];
                collections: (string & import("zod").BRAND<"collection">)[];
                environments: Record<string, string>;
                activeEnvironmentId: string;
                themeId: "default" | "alternate" | "moon" | "purple" | "solarized" | "bluePlanet" | "deepSpace" | "saturn" | "kepler" | "elysiajs" | "fastify" | "mars" | "laserwave" | "none";
                selectedHttpClient: {
                    targetKey: string;
                    clientKey: string;
                };
                hotKeyConfig?: {
                    modifiers: ("default" | "Meta" | "Control" | "Shift" | "Alt")[];
                    hotKeys?: Partial<Record<"" | "0" | "Space" | "Backspace" | "Tab" | "Enter" | "Escape" | "ArrowDown" | "ArrowLeft" | "ArrowRight" | "ArrowUp" | "End" | "Home" | "PageDown" | "PageUp" | "Delete" | "1" | "2" | "3" | "4" | "5" | "6" | "7" | "8" | "9" | "a" | "b" | "c" | "d" | "e" | "f" | "g" | "h" | "i" | "j" | "k" | "l" | "m" | "n" | "o" | "p" | "q" | "r" | "s" | "t" | "u" | "v" | "w" | "x" | "y" | "z" | "*" | "+" | "-" | "." | "/" | "F1" | "F2" | "F3" | "F4" | "F5" | "F6" | "F7" | "F8" | "F9" | "F10" | "F11" | "F12" | ";" | "=" | "," | "`" | "[" | "\\" | "]", {
                        event: "addTopNav" | "closeModal" | "closeTopNav" | "createNew" | "executeRequest" | "focusAddressBar" | "focusRequestSearch" | "jumpToLastTab" | "jumpToTab" | "navigateSearchResultsDown" | "navigateSearchResultsUp" | "navigateTopNavLeft" | "navigateTopNavRight" | "openCommandPalette" | "selectSearchResult" | "toggleSidebar";
                        modifiers?: ("default" | "Meta" | "Control" | "Shift" | "Alt")[] | undefined;
                    }>> | undefined;
                } | undefined;
                proxyUrl?: string | undefined;
            }[K]> ? import("@scalar/object-utils/nested").PathValue<{
                uid: string & import("zod").BRAND<"workspace">;
                name: string;
                description: string;
                cookies: (string & import("zod").BRAND<"cookie">)[];
                collections: (string & import("zod").BRAND<"collection">)[];
                environments: Record<string, string>;
                activeEnvironmentId: string;
                themeId: "default" | "alternate" | "moon" | "purple" | "solarized" | "bluePlanet" | "deepSpace" | "saturn" | "kepler" | "elysiajs" | "fastify" | "mars" | "laserwave" | "none";
                selectedHttpClient: {
                    targetKey: string;
                    clientKey: string;
                };
                hotKeyConfig?: {
                    modifiers: ("default" | "Meta" | "Control" | "Shift" | "Alt")[];
                    hotKeys?: Partial<Record<"" | "0" | "Space" | "Backspace" | "Tab" | "Enter" | "Escape" | "ArrowDown" | "ArrowLeft" | "ArrowRight" | "ArrowUp" | "End" | "Home" | "PageDown" | "PageUp" | "Delete" | "1" | "2" | "3" | "4" | "5" | "6" | "7" | "8" | "9" | "a" | "b" | "c" | "d" | "e" | "f" | "g" | "h" | "i" | "j" | "k" | "l" | "m" | "n" | "o" | "p" | "q" | "r" | "s" | "t" | "u" | "v" | "w" | "x" | "y" | "z" | "*" | "+" | "-" | "." | "/" | "F1" | "F2" | "F3" | "F4" | "F5" | "F6" | "F7" | "F8" | "F9" | "F10" | "F11" | "F12" | ";" | "=" | "," | "`" | "[" | "\\" | "]", {
                        event: "addTopNav" | "closeModal" | "closeTopNav" | "createNew" | "executeRequest" | "focusAddressBar" | "focusRequestSearch" | "jumpToLastTab" | "jumpToTab" | "navigateSearchResultsDown" | "navigateSearchResultsUp" | "navigateTopNavLeft" | "navigateTopNavRight" | "openCommandPalette" | "selectSearchResult" | "toggleSidebar";
                        modifiers?: ("default" | "Meta" | "Control" | "Shift" | "Alt")[] | undefined;
                    }>> | undefined;
                } | undefined;
                proxyUrl?: string | undefined;
            }[K], R> : never : K extends `${number}` ? never : never : P extends `${number}` ? never : never) => void;
            untrackedEdit: <P extends "proxyUrl" | "description" | "name" | "uid" | "collections" | "cookies" | "environments" | "activeEnvironmentId" | "themeId" | "selectedHttpClient" | "hotKeyConfig" | `collections.${number}` | `cookies.${number}` | `environments.${string}` | "selectedHttpClient.targetKey" | "selectedHttpClient.clientKey" | "hotKeyConfig.modifiers" | "hotKeyConfig.hotKeys" | `hotKeyConfig.modifiers.${number}` | "hotKeyConfig.hotKeys." | "hotKeyConfig.hotKeys.c" | "hotKeyConfig.hotKeys.r" | "hotKeyConfig.hotKeys.o" | "hotKeyConfig.hotKeys.n" | "hotKeyConfig.hotKeys.a" | "hotKeyConfig.hotKeys.b" | "hotKeyConfig.hotKeys.d" | "hotKeyConfig.hotKeys.e" | "hotKeyConfig.hotKeys.f" | "hotKeyConfig.hotKeys.g" | "hotKeyConfig.hotKeys.h" | "hotKeyConfig.hotKeys.i" | "hotKeyConfig.hotKeys.j" | "hotKeyConfig.hotKeys.k" | "hotKeyConfig.hotKeys.l" | "hotKeyConfig.hotKeys.m" | "hotKeyConfig.hotKeys.p" | "hotKeyConfig.hotKeys.q" | "hotKeyConfig.hotKeys.s" | "hotKeyConfig.hotKeys.t" | "hotKeyConfig.hotKeys.u" | "hotKeyConfig.hotKeys.v" | "hotKeyConfig.hotKeys.w" | "hotKeyConfig.hotKeys.x" | "hotKeyConfig.hotKeys.y" | "hotKeyConfig.hotKeys.z" | "hotKeyConfig.hotKeys.0" | "hotKeyConfig.hotKeys.Space" | "hotKeyConfig.hotKeys.Backspace" | "hotKeyConfig.hotKeys.Tab" | "hotKeyConfig.hotKeys.Enter" | "hotKeyConfig.hotKeys.Escape" | "hotKeyConfig.hotKeys.ArrowDown" | "hotKeyConfig.hotKeys.ArrowLeft" | "hotKeyConfig.hotKeys.ArrowRight" | "hotKeyConfig.hotKeys.ArrowUp" | "hotKeyConfig.hotKeys.End" | "hotKeyConfig.hotKeys.Home" | "hotKeyConfig.hotKeys.PageDown" | "hotKeyConfig.hotKeys.PageUp" | "hotKeyConfig.hotKeys.Delete" | "hotKeyConfig.hotKeys.1" | "hotKeyConfig.hotKeys.2" | "hotKeyConfig.hotKeys.3" | "hotKeyConfig.hotKeys.4" | "hotKeyConfig.hotKeys.5" | "hotKeyConfig.hotKeys.6" | "hotKeyConfig.hotKeys.7" | "hotKeyConfig.hotKeys.8" | "hotKeyConfig.hotKeys.9" | "hotKeyConfig.hotKeys.*" | "hotKeyConfig.hotKeys.+" | "hotKeyConfig.hotKeys.-" | "hotKeyConfig.hotKeys.." | "hotKeyConfig.hotKeys./" | "hotKeyConfig.hotKeys.F1" | "hotKeyConfig.hotKeys.F2" | "hotKeyConfig.hotKeys.F3" | "hotKeyConfig.hotKeys.F4" | "hotKeyConfig.hotKeys.F5" | "hotKeyConfig.hotKeys.F6" | "hotKeyConfig.hotKeys.F7" | "hotKeyConfig.hotKeys.F8" | "hotKeyConfig.hotKeys.F9" | "hotKeyConfig.hotKeys.F10" | "hotKeyConfig.hotKeys.F11" | "hotKeyConfig.hotKeys.F12" | "hotKeyConfig.hotKeys.;" | "hotKeyConfig.hotKeys.=" | "hotKeyConfig.hotKeys.," | "hotKeyConfig.hotKeys.`" | "hotKeyConfig.hotKeys.[" | "hotKeyConfig.hotKeys.\\" | "hotKeyConfig.hotKeys.]" | "hotKeyConfig.hotKeys..modifiers" | `hotKeyConfig.hotKeys..modifiers.${number}` | "hotKeyConfig.hotKeys..event" | "hotKeyConfig.hotKeys.c.modifiers" | `hotKeyConfig.hotKeys.c.modifiers.${number}` | "hotKeyConfig.hotKeys.c.event" | "hotKeyConfig.hotKeys.r.modifiers" | `hotKeyConfig.hotKeys.r.modifiers.${number}` | "hotKeyConfig.hotKeys.r.event" | "hotKeyConfig.hotKeys.o.modifiers" | `hotKeyConfig.hotKeys.o.modifiers.${number}` | "hotKeyConfig.hotKeys.o.event" | "hotKeyConfig.hotKeys.n.modifiers" | `hotKeyConfig.hotKeys.n.modifiers.${number}` | "hotKeyConfig.hotKeys.n.event" | "hotKeyConfig.hotKeys.a.modifiers" | `hotKeyConfig.hotKeys.a.modifiers.${number}` | "hotKeyConfig.hotKeys.a.event" | "hotKeyConfig.hotKeys.b.modifiers" | `hotKeyConfig.hotKeys.b.modifiers.${number}` | "hotKeyConfig.hotKeys.b.event" | "hotKeyConfig.hotKeys.d.modifiers" | `hotKeyConfig.hotKeys.d.modifiers.${number}` | "hotKeyConfig.hotKeys.d.event" | "hotKeyConfig.hotKeys.e.modifiers" | `hotKeyConfig.hotKeys.e.modifiers.${number}` | "hotKeyConfig.hotKeys.e.event" | "hotKeyConfig.hotKeys.f.modifiers" | `hotKeyConfig.hotKeys.f.modifiers.${number}` | "hotKeyConfig.hotKeys.f.event" | "hotKeyConfig.hotKeys.g.modifiers" | `hotKeyConfig.hotKeys.g.modifiers.${number}` | "hotKeyConfig.hotKeys.g.event" | "hotKeyConfig.hotKeys.h.modifiers" | `hotKeyConfig.hotKeys.h.modifiers.${number}` | "hotKeyConfig.hotKeys.h.event" | "hotKeyConfig.hotKeys.i.modifiers" | `hotKeyConfig.hotKeys.i.modifiers.${number}` | "hotKeyConfig.hotKeys.i.event" | "hotKeyConfig.hotKeys.j.modifiers" | `hotKeyConfig.hotKeys.j.modifiers.${number}` | "hotKeyConfig.hotKeys.j.event" | "hotKeyConfig.hotKeys.k.modifiers" | `hotKeyConfig.hotKeys.k.modifiers.${number}` | "hotKeyConfig.hotKeys.k.event" | "hotKeyConfig.hotKeys.l.modifiers" | `hotKeyConfig.hotKeys.l.modifiers.${number}` | "hotKeyConfig.hotKeys.l.event" | "hotKeyConfig.hotKeys.m.modifiers" | `hotKeyConfig.hotKeys.m.modifiers.${number}` | "hotKeyConfig.hotKeys.m.event" | "hotKeyConfig.hotKeys.p.modifiers" | `hotKeyConfig.hotKeys.p.modifiers.${number}` | "hotKeyConfig.hotKeys.p.event" | "hotKeyConfig.hotKeys.q.modifiers" | `hotKeyConfig.hotKeys.q.modifiers.${number}` | "hotKeyConfig.hotKeys.q.event" | "hotKeyConfig.hotKeys.s.modifiers" | `hotKeyConfig.hotKeys.s.modifiers.${number}` | "hotKeyConfig.hotKeys.s.event" | "hotKeyConfig.hotKeys.t.modifiers" | `hotKeyConfig.hotKeys.t.modifiers.${number}` | "hotKeyConfig.hotKeys.t.event" | "hotKeyConfig.hotKeys.u.modifiers" | `hotKeyConfig.hotKeys.u.modifiers.${number}` | "hotKeyConfig.hotKeys.u.event" | "hotKeyConfig.hotKeys.v.modifiers" | `hotKeyConfig.hotKeys.v.modifiers.${number}` | "hotKeyConfig.hotKeys.v.event" | "hotKeyConfig.hotKeys.w.modifiers" | `hotKeyConfig.hotKeys.w.modifiers.${number}` | "hotKeyConfig.hotKeys.w.event" | "hotKeyConfig.hotKeys.x.modifiers" | `hotKeyConfig.hotKeys.x.modifiers.${number}` | "hotKeyConfig.hotKeys.x.event" | "hotKeyConfig.hotKeys.y.modifiers" | `hotKeyConfig.hotKeys.y.modifiers.${number}` | "hotKeyConfig.hotKeys.y.event" | "hotKeyConfig.hotKeys.z.modifiers" | `hotKeyConfig.hotKeys.z.modifiers.${number}` | "hotKeyConfig.hotKeys.z.event" | "hotKeyConfig.hotKeys.0.modifiers" | `hotKeyConfig.hotKeys.0.modifiers.${number}` | "hotKeyConfig.hotKeys.0.event" | "hotKeyConfig.hotKeys.Space.modifiers" | `hotKeyConfig.hotKeys.Space.modifiers.${number}` | "hotKeyConfig.hotKeys.Space.event" | "hotKeyConfig.hotKeys.Backspace.modifiers" | `hotKeyConfig.hotKeys.Backspace.modifiers.${number}` | "hotKeyConfig.hotKeys.Backspace.event" | "hotKeyConfig.hotKeys.Tab.modifiers" | `hotKeyConfig.hotKeys.Tab.modifiers.${number}` | "hotKeyConfig.hotKeys.Tab.event" | "hotKeyConfig.hotKeys.Enter.modifiers" | `hotKeyConfig.hotKeys.Enter.modifiers.${number}` | "hotKeyConfig.hotKeys.Enter.event" | "hotKeyConfig.hotKeys.Escape.modifiers" | `hotKeyConfig.hotKeys.Escape.modifiers.${number}` | "hotKeyConfig.hotKeys.Escape.event" | "hotKeyConfig.hotKeys.ArrowDown.modifiers" | `hotKeyConfig.hotKeys.ArrowDown.modifiers.${number}` | "hotKeyConfig.hotKeys.ArrowDown.event" | "hotKeyConfig.hotKeys.ArrowLeft.modifiers" | `hotKeyConfig.hotKeys.ArrowLeft.modifiers.${number}` | "hotKeyConfig.hotKeys.ArrowLeft.event" | "hotKeyConfig.hotKeys.ArrowRight.modifiers" | `hotKeyConfig.hotKeys.ArrowRight.modifiers.${number}` | "hotKeyConfig.hotKeys.ArrowRight.event" | "hotKeyConfig.hotKeys.ArrowUp.modifiers" | `hotKeyConfig.hotKeys.ArrowUp.modifiers.${number}` | "hotKeyConfig.hotKeys.ArrowUp.event" | "hotKeyConfig.hotKeys.End.modifiers" | `hotKeyConfig.hotKeys.End.modifiers.${number}` | "hotKeyConfig.hotKeys.End.event" | "hotKeyConfig.hotKeys.Home.modifiers" | `hotKeyConfig.hotKeys.Home.modifiers.${number}` | "hotKeyConfig.hotKeys.Home.event" | "hotKeyConfig.hotKeys.PageDown.modifiers" | `hotKeyConfig.hotKeys.PageDown.modifiers.${number}` | "hotKeyConfig.hotKeys.PageDown.event" | "hotKeyConfig.hotKeys.PageUp.modifiers" | `hotKeyConfig.hotKeys.PageUp.modifiers.${number}` | "hotKeyConfig.hotKeys.PageUp.event" | "hotKeyConfig.hotKeys.Delete.modifiers" | `hotKeyConfig.hotKeys.Delete.modifiers.${number}` | "hotKeyConfig.hotKeys.Delete.event" | "hotKeyConfig.hotKeys.1.modifiers" | `hotKeyConfig.hotKeys.1.modifiers.${number}` | "hotKeyConfig.hotKeys.1.event" | "hotKeyConfig.hotKeys.2.modifiers" | `hotKeyConfig.hotKeys.2.modifiers.${number}` | "hotKeyConfig.hotKeys.2.event" | "hotKeyConfig.hotKeys.3.modifiers" | `hotKeyConfig.hotKeys.3.modifiers.${number}` | "hotKeyConfig.hotKeys.3.event" | "hotKeyConfig.hotKeys.4.modifiers" | `hotKeyConfig.hotKeys.4.modifiers.${number}` | "hotKeyConfig.hotKeys.4.event" | "hotKeyConfig.hotKeys.5.modifiers" | `hotKeyConfig.hotKeys.5.modifiers.${number}` | "hotKeyConfig.hotKeys.5.event" | "hotKeyConfig.hotKeys.6.modifiers" | `hotKeyConfig.hotKeys.6.modifiers.${number}` | "hotKeyConfig.hotKeys.6.event" | "hotKeyConfig.hotKeys.7.modifiers" | `hotKeyConfig.hotKeys.7.modifiers.${number}` | "hotKeyConfig.hotKeys.7.event" | "hotKeyConfig.hotKeys.8.modifiers" | `hotKeyConfig.hotKeys.8.modifiers.${number}` | "hotKeyConfig.hotKeys.8.event" | "hotKeyConfig.hotKeys.9.modifiers" | `hotKeyConfig.hotKeys.9.modifiers.${number}` | "hotKeyConfig.hotKeys.9.event" | "hotKeyConfig.hotKeys.*.modifiers" | `hotKeyConfig.hotKeys.*.modifiers.${number}` | "hotKeyConfig.hotKeys.*.event" | "hotKeyConfig.hotKeys.+.modifiers" | `hotKeyConfig.hotKeys.+.modifiers.${number}` | "hotKeyConfig.hotKeys.+.event" | "hotKeyConfig.hotKeys.-.modifiers" | `hotKeyConfig.hotKeys.-.modifiers.${number}` | "hotKeyConfig.hotKeys.-.event" | "hotKeyConfig.hotKeys...modifiers" | `hotKeyConfig.hotKeys...modifiers.${number}` | "hotKeyConfig.hotKeys...event" | "hotKeyConfig.hotKeys./.modifiers" | `hotKeyConfig.hotKeys./.modifiers.${number}` | "hotKeyConfig.hotKeys./.event" | "hotKeyConfig.hotKeys.F1.modifiers" | `hotKeyConfig.hotKeys.F1.modifiers.${number}` | "hotKeyConfig.hotKeys.F1.event" | "hotKeyConfig.hotKeys.F2.modifiers" | `hotKeyConfig.hotKeys.F2.modifiers.${number}` | "hotKeyConfig.hotKeys.F2.event" | "hotKeyConfig.hotKeys.F3.modifiers" | `hotKeyConfig.hotKeys.F3.modifiers.${number}` | "hotKeyConfig.hotKeys.F3.event" | "hotKeyConfig.hotKeys.F4.modifiers" | `hotKeyConfig.hotKeys.F4.modifiers.${number}` | "hotKeyConfig.hotKeys.F4.event" | "hotKeyConfig.hotKeys.F5.modifiers" | `hotKeyConfig.hotKeys.F5.modifiers.${number}` | "hotKeyConfig.hotKeys.F5.event" | "hotKeyConfig.hotKeys.F6.modifiers" | `hotKeyConfig.hotKeys.F6.modifiers.${number}` | "hotKeyConfig.hotKeys.F6.event" | "hotKeyConfig.hotKeys.F7.modifiers" | `hotKeyConfig.hotKeys.F7.modifiers.${number}` | "hotKeyConfig.hotKeys.F7.event" | "hotKeyConfig.hotKeys.F8.modifiers" | `hotKeyConfig.hotKeys.F8.modifiers.${number}` | "hotKeyConfig.hotKeys.F8.event" | "hotKeyConfig.hotKeys.F9.modifiers" | `hotKeyConfig.hotKeys.F9.modifiers.${number}` | "hotKeyConfig.hotKeys.F9.event" | "hotKeyConfig.hotKeys.F10.modifiers" | `hotKeyConfig.hotKeys.F10.modifiers.${number}` | "hotKeyConfig.hotKeys.F10.event" | "hotKeyConfig.hotKeys.F11.modifiers" | `hotKeyConfig.hotKeys.F11.modifiers.${number}` | "hotKeyConfig.hotKeys.F11.event" | "hotKeyConfig.hotKeys.F12.modifiers" | `hotKeyConfig.hotKeys.F12.modifiers.${number}` | "hotKeyConfig.hotKeys.F12.event" | "hotKeyConfig.hotKeys.;.modifiers" | `hotKeyConfig.hotKeys.;.modifiers.${number}` | "hotKeyConfig.hotKeys.;.event" | "hotKeyConfig.hotKeys.=.modifiers" | `hotKeyConfig.hotKeys.=.modifiers.${number}` | "hotKeyConfig.hotKeys.=.event" | "hotKeyConfig.hotKeys.,.modifiers" | `hotKeyConfig.hotKeys.,.modifiers.${number}` | "hotKeyConfig.hotKeys.,.event" | "hotKeyConfig.hotKeys.`.modifiers" | `hotKeyConfig.hotKeys.\`.modifiers.${number}` | "hotKeyConfig.hotKeys.`.event" | "hotKeyConfig.hotKeys.[.modifiers" | `hotKeyConfig.hotKeys.[.modifiers.${number}` | "hotKeyConfig.hotKeys.[.event" | "hotKeyConfig.hotKeys.\\.modifiers" | `hotKeyConfig.hotKeys.\\.modifiers.${number}` | "hotKeyConfig.hotKeys.\\.event" | "hotKeyConfig.hotKeys.].modifiers" | `hotKeyConfig.hotKeys.].modifiers.${number}` | "hotKeyConfig.hotKeys.].event">(uid: string & import("zod").BRAND<"workspace">, path: P, value: P extends "proxyUrl" | "description" | "name" | "uid" | "collections" | "cookies" | "environments" | "activeEnvironmentId" | "themeId" | "selectedHttpClient" | "hotKeyConfig" ? {
                uid: string & import("zod").BRAND<"workspace">;
                name: string;
                description: string;
                cookies: (string & import("zod").BRAND<"cookie">)[];
                collections: (string & import("zod").BRAND<"collection">)[];
                environments: Record<string, string>;
                activeEnvironmentId: string;
                themeId: "default" | "alternate" | "moon" | "purple" | "solarized" | "bluePlanet" | "deepSpace" | "saturn" | "kepler" | "elysiajs" | "fastify" | "mars" | "laserwave" | "none";
                selectedHttpClient: {
                    targetKey: string;
                    clientKey: string;
                };
                hotKeyConfig?: {
                    modifiers: ("default" | "Meta" | "Control" | "Shift" | "Alt")[];
                    hotKeys?: Partial<Record<"" | "0" | "Space" | "Backspace" | "Tab" | "Enter" | "Escape" | "ArrowDown" | "ArrowLeft" | "ArrowRight" | "ArrowUp" | "End" | "Home" | "PageDown" | "PageUp" | "Delete" | "1" | "2" | "3" | "4" | "5" | "6" | "7" | "8" | "9" | "a" | "b" | "c" | "d" | "e" | "f" | "g" | "h" | "i" | "j" | "k" | "l" | "m" | "n" | "o" | "p" | "q" | "r" | "s" | "t" | "u" | "v" | "w" | "x" | "y" | "z" | "*" | "+" | "-" | "." | "/" | "F1" | "F2" | "F3" | "F4" | "F5" | "F6" | "F7" | "F8" | "F9" | "F10" | "F11" | "F12" | ";" | "=" | "," | "`" | "[" | "\\" | "]", {
                        event: "addTopNav" | "closeModal" | "closeTopNav" | "createNew" | "executeRequest" | "focusAddressBar" | "focusRequestSearch" | "jumpToLastTab" | "jumpToTab" | "navigateSearchResultsDown" | "navigateSearchResultsUp" | "navigateTopNavLeft" | "navigateTopNavRight" | "openCommandPalette" | "selectSearchResult" | "toggleSidebar";
                        modifiers?: ("default" | "Meta" | "Control" | "Shift" | "Alt")[] | undefined;
                    }>> | undefined;
                } | undefined;
                proxyUrl?: string | undefined;
            }[P] : P extends `${infer K}.${infer R}` ? K extends "proxyUrl" | "description" | "name" | "uid" | "collections" | "cookies" | "environments" | "activeEnvironmentId" | "themeId" | "selectedHttpClient" | "hotKeyConfig" ? R extends import("@scalar/object-utils/nested").Path<{
                uid: string & import("zod").BRAND<"workspace">;
                name: string;
                description: string;
                cookies: (string & import("zod").BRAND<"cookie">)[];
                collections: (string & import("zod").BRAND<"collection">)[];
                environments: Record<string, string>;
                activeEnvironmentId: string;
                themeId: "default" | "alternate" | "moon" | "purple" | "solarized" | "bluePlanet" | "deepSpace" | "saturn" | "kepler" | "elysiajs" | "fastify" | "mars" | "laserwave" | "none";
                selectedHttpClient: {
                    targetKey: string;
                    clientKey: string;
                };
                hotKeyConfig?: {
                    modifiers: ("default" | "Meta" | "Control" | "Shift" | "Alt")[];
                    hotKeys?: Partial<Record<"" | "0" | "Space" | "Backspace" | "Tab" | "Enter" | "Escape" | "ArrowDown" | "ArrowLeft" | "ArrowRight" | "ArrowUp" | "End" | "Home" | "PageDown" | "PageUp" | "Delete" | "1" | "2" | "3" | "4" | "5" | "6" | "7" | "8" | "9" | "a" | "b" | "c" | "d" | "e" | "f" | "g" | "h" | "i" | "j" | "k" | "l" | "m" | "n" | "o" | "p" | "q" | "r" | "s" | "t" | "u" | "v" | "w" | "x" | "y" | "z" | "*" | "+" | "-" | "." | "/" | "F1" | "F2" | "F3" | "F4" | "F5" | "F6" | "F7" | "F8" | "F9" | "F10" | "F11" | "F12" | ";" | "=" | "," | "`" | "[" | "\\" | "]", {
                        event: "addTopNav" | "closeModal" | "closeTopNav" | "createNew" | "executeRequest" | "focusAddressBar" | "focusRequestSearch" | "jumpToLastTab" | "jumpToTab" | "navigateSearchResultsDown" | "navigateSearchResultsUp" | "navigateTopNavLeft" | "navigateTopNavRight" | "openCommandPalette" | "selectSearchResult" | "toggleSidebar";
                        modifiers?: ("default" | "Meta" | "Control" | "Shift" | "Alt")[] | undefined;
                    }>> | undefined;
                } | undefined;
                proxyUrl?: string | undefined;
            }[K]> ? import("@scalar/object-utils/nested").PathValue<{
                uid: string & import("zod").BRAND<"workspace">;
                name: string;
                description: string;
                cookies: (string & import("zod").BRAND<"cookie">)[];
                collections: (string & import("zod").BRAND<"collection">)[];
                environments: Record<string, string>;
                activeEnvironmentId: string;
                themeId: "default" | "alternate" | "moon" | "purple" | "solarized" | "bluePlanet" | "deepSpace" | "saturn" | "kepler" | "elysiajs" | "fastify" | "mars" | "laserwave" | "none";
                selectedHttpClient: {
                    targetKey: string;
                    clientKey: string;
                };
                hotKeyConfig?: {
                    modifiers: ("default" | "Meta" | "Control" | "Shift" | "Alt")[];
                    hotKeys?: Partial<Record<"" | "0" | "Space" | "Backspace" | "Tab" | "Enter" | "Escape" | "ArrowDown" | "ArrowLeft" | "ArrowRight" | "ArrowUp" | "End" | "Home" | "PageDown" | "PageUp" | "Delete" | "1" | "2" | "3" | "4" | "5" | "6" | "7" | "8" | "9" | "a" | "b" | "c" | "d" | "e" | "f" | "g" | "h" | "i" | "j" | "k" | "l" | "m" | "n" | "o" | "p" | "q" | "r" | "s" | "t" | "u" | "v" | "w" | "x" | "y" | "z" | "*" | "+" | "-" | "." | "/" | "F1" | "F2" | "F3" | "F4" | "F5" | "F6" | "F7" | "F8" | "F9" | "F10" | "F11" | "F12" | ";" | "=" | "," | "`" | "[" | "\\" | "]", {
                        event: "addTopNav" | "closeModal" | "closeTopNav" | "createNew" | "executeRequest" | "focusAddressBar" | "focusRequestSearch" | "jumpToLastTab" | "jumpToTab" | "navigateSearchResultsDown" | "navigateSearchResultsUp" | "navigateTopNavLeft" | "navigateTopNavRight" | "openCommandPalette" | "selectSearchResult" | "toggleSidebar";
                        modifiers?: ("default" | "Meta" | "Control" | "Shift" | "Alt")[] | undefined;
                    }>> | undefined;
                } | undefined;
                proxyUrl?: string | undefined;
            }[K], R> : never : K extends `${number}` ? never : never : P extends `${number}` ? never : never) => void;
            undo: (uid: string & import("zod").BRAND<"workspace">) => void;
            redo: (uid: string & import("zod").BRAND<"workspace">) => void;
            reset: () => void;
        };
        addCollectionEnvironment: (environmentName: string, environment: import("@scalar/oas-utils/entities/spec").XScalarEnvironment, collectionUid: import("@scalar/oas-utils/entities/spec").Collection["uid"]) => void;
        removeCollectionEnvironment: (environmentName: string, collectionUid: import("@scalar/oas-utils/entities/spec").Collection["uid"]) => void;
    };
} | null, ApiClient | {
    onUpdateServer: (callback: (url: string) => void) => void;
    updateServer: (serverUrl: string) => void;
    open: (payload?: import("@scalar/api-client/libs").OpenClientPayload) => void;
    updateConfig: (_newConfig: Partial<import("@scalar/types/api-reference").ApiClientConfiguration>) => Promise<void>;
    updateAuth: <P extends import("@scalar/object-utils/nested").Path<import("@scalar/types/entities").SecurityScheme>>({ nameKey, propertyKey, value, }: {
        nameKey: string;
        propertyKey: P;
        value: NonNullable<import("@scalar/object-utils/nested").PathValue<import("@scalar/types/entities").SecurityScheme, P>>;
    }) => void;
    route: (payload?: import("@scalar/api-client/libs").OpenClientPayload) => void;
    mount: (mountingEl?: HTMLElement | null) => void;
    modalState: {
        open: boolean;
        show: () => void;
        hide: () => void;
    };
    updateExample: (exampleKey: string, operationId: string) => void;
    app: {
        unmount: () => void;
    };
    store: {
        hideClientButton: boolean;
        showSidebar: boolean;
        servers: Record<string, {
            uid: string & import("zod").BRAND<"server">;
            url: string;
            description?: string | undefined;
            variables?: Record<string, {
                value?: string | undefined;
                description?: string | undefined;
                default?: string | undefined;
                enum?: string[] | undefined;
            }> | undefined;
        }>;
        tags: Record<string, {
            uid: string & import("zod").BRAND<"tag">;
            name: string;
            type: "tag";
            children: ((string & import("zod").BRAND<"tag">) | (string & import("zod").BRAND<"operation">))[];
            description?: string | undefined;
            externalDocs?: {
                url: string;
                description?: string | undefined;
            } | undefined;
            "x-scalar-children"?: {
                tagName: string;
            }[] | undefined;
            "x-internal"?: boolean | undefined;
            "x-scalar-ignore"?: boolean | undefined;
        }>;
        securitySchemes: Record<string, {
            name: string;
            type: "apiKey";
            value: string;
            uid: string & import("zod").BRAND<"securityScheme">;
            nameKey: string;
            in: "cookie" | "query" | "header";
            description?: string | undefined;
        } | {
            type: "http";
            uid: string & import("zod").BRAND<"securityScheme">;
            nameKey: string;
            scheme: "basic" | "bearer";
            bearerFormat: string;
            username: string;
            password: string;
            token: string;
            description?: string | undefined;
        } | {
            type: "openIdConnect";
            uid: string & import("zod").BRAND<"securityScheme">;
            nameKey: string;
            openIdConnectUrl: string;
            description?: string | undefined;
        } | {
            type: "oauth2";
            uid: string & import("zod").BRAND<"securityScheme">;
            nameKey: string;
            flows: {
                password?: {
                    type: "password";
                    username: string;
                    password: string;
                    token: string;
                    refreshUrl: string;
                    scopes: Record<string, string>;
                    selectedScopes: string[];
                    "x-scalar-client-id": string;
                    tokenUrl: string;
                    clientSecret: string;
                } | undefined;
                implicit?: {
                    type: "implicit";
                    token: string;
                    refreshUrl: string;
                    scopes: Record<string, string>;
                    selectedScopes: string[];
                    "x-scalar-client-id": string;
                    authorizationUrl: string;
                    "x-scalar-redirect-uri": string;
                } | undefined;
                clientCredentials?: {
                    type: "clientCredentials";
                    token: string;
                    refreshUrl: string;
                    scopes: Record<string, string>;
                    selectedScopes: string[];
                    "x-scalar-client-id": string;
                    tokenUrl: string;
                    clientSecret: string;
                } | undefined;
                authorizationCode?: {
                    type: "authorizationCode";
                    token: string;
                    refreshUrl: string;
                    scopes: Record<string, string>;
                    selectedScopes: string[];
                    "x-scalar-client-id": string;
                    authorizationUrl: string;
                    "x-scalar-redirect-uri": string;
                    tokenUrl: string;
                    clientSecret: string;
                    "x-usePkce": "SHA-256" | "plain" | "no";
                } | undefined;
            };
            description?: string | undefined;
            "x-default-scopes"?: string | string[] | undefined;
        }>;
        cookies: Record<string, {
            uid: string & import("zod").BRAND<"cookie">;
            name: string;
            value: string;
            domain?: string | undefined;
            path?: string | undefined;
        }>;
        serverMutators: {
            rawAdd: (item: {
                uid: string & import("zod").BRAND<"server">;
                url: string;
                description?: string | undefined;
                variables?: Record<string, {
                    value?: string | undefined;
                    description?: string | undefined;
                    default?: string | undefined;
                    enum?: string[] | undefined;
                }> | undefined;
            }) => void;
            add: (payload: import("@scalar/oas-utils/entities/spec").ServerPayload, parentUid: string) => {
                uid: string & import("zod").BRAND<"server">;
                url: string;
                description?: string | undefined;
                variables?: Record<string, {
                    value?: string | undefined;
                    description?: string | undefined;
                    default?: string | undefined;
                    enum?: string[] | undefined;
                }> | undefined;
            };
            delete: (serverUid: import("@scalar/oas-utils/entities/spec").Server["uid"], collectionUid: import("@scalar/oas-utils/entities/spec").Collection["uid"]) => void;
            set: (item: {
                uid: string & import("zod").BRAND<"server">;
                url: string;
                description?: string | undefined;
                variables?: Record<string, {
                    value?: string | undefined;
                    description?: string | undefined;
                    default?: string | undefined;
                    enum?: string[] | undefined;
                }> | undefined;
            }) => void;
            edit: <P extends "url" | "description" | "uid" | "variables" | `variables.${string}`>(uid: (string & import("zod").BRAND<"server">) | null | undefined, path: P, value: P extends "url" | "description" | "uid" | "variables" ? {
                uid: string & import("zod").BRAND<"server">;
                url: string;
                description?: string | undefined;
                variables?: Record<string, {
                    value?: string | undefined;
                    description?: string | undefined;
                    default?: string | undefined;
                    enum?: string[] | undefined;
                }> | undefined;
            }[P] : P extends `${infer K}.${infer R}` ? K extends "url" | "description" | "uid" | "variables" ? R extends import("@scalar/object-utils/nested").Path<{
                uid: string & import("zod").BRAND<"server">;
                url: string;
                description?: string | undefined;
                variables?: Record<string, {
                    value?: string | undefined;
                    description?: string | undefined;
                    default?: string | undefined;
                    enum?: string[] | undefined;
                }> | undefined;
            }[K]> ? import("@scalar/object-utils/nested").PathValue<{
                uid: string & import("zod").BRAND<"server">;
                url: string;
                description?: string | undefined;
                variables?: Record<string, {
                    value?: string | undefined;
                    description?: string | undefined;
                    default?: string | undefined;
                    enum?: string[] | undefined;
                }> | undefined;
            }[K], R> : never : K extends `${number}` ? never : never : P extends `${number}` ? never : never) => void;
            untrackedEdit: <P extends "url" | "description" | "uid" | "variables" | `variables.${string}`>(uid: string & import("zod").BRAND<"server">, path: P, value: P extends "url" | "description" | "uid" | "variables" ? {
                uid: string & import("zod").BRAND<"server">;
                url: string;
                description?: string | undefined;
                variables?: Record<string, {
                    value?: string | undefined;
                    description?: string | undefined;
                    default?: string | undefined;
                    enum?: string[] | undefined;
                }> | undefined;
            }[P] : P extends `${infer K}.${infer R}` ? K extends "url" | "description" | "uid" | "variables" ? R extends import("@scalar/object-utils/nested").Path<{
                uid: string & import("zod").BRAND<"server">;
                url: string;
                description?: string | undefined;
                variables?: Record<string, {
                    value?: string | undefined;
                    description?: string | undefined;
                    default?: string | undefined;
                    enum?: string[] | undefined;
                }> | undefined;
            }[K]> ? import("@scalar/object-utils/nested").PathValue<{
                uid: string & import("zod").BRAND<"server">;
                url: string;
                description?: string | undefined;
                variables?: Record<string, {
                    value?: string | undefined;
                    description?: string | undefined;
                    default?: string | undefined;
                    enum?: string[] | undefined;
                }> | undefined;
            }[K], R> : never : K extends `${number}` ? never : never : P extends `${number}` ? never : never) => void;
            undo: (uid: string & import("zod").BRAND<"server">) => void;
            redo: (uid: string & import("zod").BRAND<"server">) => void;
            reset: () => void;
        };
        requests: Record<string, {
            uid: string & import("zod").BRAND<"operation">;
            path: string;
            type: "request";
            selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
            selectedServerUid: (string & import("zod").BRAND<"server">) | null;
            servers: (string & import("zod").BRAND<"server">)[];
            examples: (string & import("zod").BRAND<"example">)[];
            method: "options" | "connect" | "delete" | "get" | "head" | "patch" | "post" | "put" | "trace";
            description?: string | undefined;
            summary?: string | undefined;
            externalDocs?: {
                url: string;
                description?: string | undefined;
            } | undefined;
            "x-internal"?: boolean | undefined;
            "x-scalar-ignore"?: boolean | undefined;
            security?: Record<string, string[]>[] | undefined;
            tags?: string[] | undefined;
            deprecated?: boolean | undefined;
            operationId?: string | undefined;
            parameters?: {
                name: string;
                required: boolean;
                in: "cookie" | "path" | "query" | "header";
                deprecated: boolean;
                description?: string | undefined;
                example?: unknown;
                schema?: unknown;
                content?: unknown;
                style?: "matrix" | "simple" | "form" | "label" | "spaceDelimited" | "pipeDelimited" | "deepObject" | undefined;
                examples?: unknown[] | Record<string, {
                    value?: unknown;
                    summary?: string | undefined;
                }> | undefined;
            }[] | undefined;
            requestBody?: any;
            responses?: Record<string, any> | undefined;
            "x-codeSamples"?: {
                source: string;
                label?: string | undefined;
                lang?: string | undefined;
            }[] | undefined;
            "x-code-samples"?: {
                source: string;
                label?: string | undefined;
                lang?: string | undefined;
            }[] | undefined;
            "x-custom-examples"?: {
                source: string;
                label?: string | undefined;
                lang?: string | undefined;
            }[] | undefined;
            "x-scalar-stability"?: import("@scalar/types").XScalarStability | undefined;
        }>;
        collections: Record<string, {
            uid: string & import("zod").BRAND<"collection">;
            type: "collection";
            children: ((string & import("zod").BRAND<"tag">) | (string & import("zod").BRAND<"operation">))[];
            openapi: string;
            info: {
                title: string;
                version: string;
                description?: string | undefined;
                summary?: string | undefined;
                termsOfService?: string | undefined;
                contact?: {
                    name?: string | undefined;
                    url?: string | undefined;
                    email?: string | undefined;
                } | undefined;
                license?: {
                    name?: string | null | undefined;
                    identifier?: string | undefined;
                    url?: string | undefined;
                } | undefined;
            };
            security: Record<string, string[]>[];
            "x-scalar-icon": string;
            securitySchemes: string[];
            selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
            servers: (string & import("zod").BRAND<"server">)[];
            requests: (string & import("zod").BRAND<"operation">)[];
            tags: (string & import("zod").BRAND<"tag">)[];
            watchMode: boolean;
            useCollectionSecurity: boolean;
            watchModeStatus: "IDLE" | "WATCHING" | "ERROR";
            externalDocs?: {
                url: string;
                description?: string | undefined;
            } | undefined;
            jsonSchemaDialect?: string | undefined;
            components?: Record<string, unknown> | undefined;
            webhooks?: Record<string, unknown> | undefined;
            "x-scalar-active-environment"?: string | undefined;
            "x-scalar-environments"?: Record<string, {
                variables: Record<string, string | {
                    default: string;
                    description?: string | undefined;
                }>;
                color?: string | undefined;
                description?: string | undefined;
            }> | undefined;
            "x-scalar-secrets"?: Record<string, {
                description?: string | undefined;
                example?: string | undefined;
            }> | undefined;
            selectedServerUid?: (string & import("zod").BRAND<"server">) | undefined;
            documentUrl?: string | undefined;
            integration?: string | null | undefined;
        }>;
        requestExamples: Record<string, {
            uid: string & import("zod").BRAND<"example">;
            name: string;
            type: "requestExample";
            body: {
                activeBody: "formData" | "binary" | "raw";
                formData?: {
                    value: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        description?: string | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        enum?: string[] | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                    encoding: "form-data" | "urlencoded";
                } | undefined;
                binary?: Blob | undefined;
                raw?: {
                    value: string;
                    encoding: "xml" | "json" | "text" | "html" | "javascript" | "yaml" | "edn";
                    mimeType?: string | undefined;
                } | undefined;
            };
            parameters: {
                path: {
                    value: string;
                    key: string;
                    enabled: boolean;
                    minimum?: number | undefined;
                    type?: string | string[] | undefined;
                    maximum?: number | undefined;
                    description?: string | undefined;
                    default?: any;
                    required?: boolean | undefined;
                    examples?: string[] | undefined;
                    format?: string | undefined;
                    enum?: string[] | undefined;
                    file?: any;
                    nullable?: boolean | undefined;
                }[];
                query: {
                    value: string;
                    key: string;
                    enabled: boolean;
                    minimum?: number | undefined;
                    type?: string | string[] | undefined;
                    maximum?: number | undefined;
                    description?: string | undefined;
                    default?: any;
                    required?: boolean | undefined;
                    examples?: string[] | undefined;
                    format?: string | undefined;
                    enum?: string[] | undefined;
                    file?: any;
                    nullable?: boolean | undefined;
                }[];
                headers: {
                    value: string;
                    key: string;
                    enabled: boolean;
                    minimum?: number | undefined;
                    type?: string | string[] | undefined;
                    maximum?: number | undefined;
                    description?: string | undefined;
                    default?: any;
                    required?: boolean | undefined;
                    examples?: string[] | undefined;
                    format?: string | undefined;
                    enum?: string[] | undefined;
                    file?: any;
                    nullable?: boolean | undefined;
                }[];
                cookies: {
                    value: string;
                    key: string;
                    enabled: boolean;
                    minimum?: number | undefined;
                    type?: string | string[] | undefined;
                    maximum?: number | undefined;
                    description?: string | undefined;
                    default?: any;
                    required?: boolean | undefined;
                    examples?: string[] | undefined;
                    format?: string | undefined;
                    enum?: string[] | undefined;
                    file?: any;
                    nullable?: boolean | undefined;
                }[];
            };
            requestUid?: (string & import("zod").BRAND<"operation">) | undefined;
            serverVariables?: Record<string, string[]> | undefined;
        }>;
        requestExampleMutators: {
            rawAdd: (item: {
                uid: string & import("zod").BRAND<"example">;
                name: string;
                type: "requestExample";
                body: {
                    activeBody: "formData" | "binary" | "raw";
                    formData?: {
                        value: {
                            value: string;
                            key: string;
                            enabled: boolean;
                            minimum?: number | undefined;
                            type?: string | string[] | undefined;
                            maximum?: number | undefined;
                            description?: string | undefined;
                            default?: any;
                            required?: boolean | undefined;
                            examples?: string[] | undefined;
                            format?: string | undefined;
                            enum?: string[] | undefined;
                            file?: any;
                            nullable?: boolean | undefined;
                        }[];
                        encoding: "form-data" | "urlencoded";
                    } | undefined;
                    binary?: Blob | undefined;
                    raw?: {
                        value: string;
                        encoding: "xml" | "json" | "text" | "html" | "javascript" | "yaml" | "edn";
                        mimeType?: string | undefined;
                    } | undefined;
                };
                parameters: {
                    path: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        description?: string | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        enum?: string[] | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                    query: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        description?: string | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        enum?: string[] | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                    headers: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        description?: string | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        enum?: string[] | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                    cookies: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        description?: string | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        enum?: string[] | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                };
                requestUid?: (string & import("zod").BRAND<"operation">) | undefined;
                serverVariables?: Record<string, string[]> | undefined;
            }) => void;
            add: (request: import("@scalar/oas-utils/entities/spec").Request, _name?: string) => {
                uid: string & import("zod").BRAND<"example">;
                name: string;
                type: "requestExample";
                body: {
                    activeBody: "formData" | "binary" | "raw";
                    formData?: {
                        value: {
                            value: string;
                            key: string;
                            enabled: boolean;
                            minimum?: number | undefined;
                            type?: string | string[] | undefined;
                            maximum?: number | undefined;
                            description?: string | undefined;
                            default?: any;
                            required?: boolean | undefined;
                            examples?: string[] | undefined;
                            format?: string | undefined;
                            enum?: string[] | undefined;
                            file?: any;
                            nullable?: boolean | undefined;
                        }[];
                        encoding: "form-data" | "urlencoded";
                    } | undefined;
                    binary?: Blob | undefined;
                    raw?: {
                        value: string;
                        encoding: "xml" | "json" | "text" | "html" | "javascript" | "yaml" | "edn";
                        mimeType?: string | undefined;
                    } | undefined;
                };
                parameters: {
                    path: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        description?: string | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        enum?: string[] | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                    query: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        description?: string | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        enum?: string[] | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                    headers: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        description?: string | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        enum?: string[] | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                    cookies: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        description?: string | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        enum?: string[] | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                };
                requestUid?: (string & import("zod").BRAND<"operation">) | undefined;
                serverVariables?: Record<string, string[]> | undefined;
            };
            delete: (requestExample: import("@scalar/oas-utils/entities/spec").RequestExample) => void;
            set: (item: {
                uid: string & import("zod").BRAND<"example">;
                name: string;
                type: "requestExample";
                body: {
                    activeBody: "formData" | "binary" | "raw";
                    formData?: {
                        value: {
                            value: string;
                            key: string;
                            enabled: boolean;
                            minimum?: number | undefined;
                            type?: string | string[] | undefined;
                            maximum?: number | undefined;
                            description?: string | undefined;
                            default?: any;
                            required?: boolean | undefined;
                            examples?: string[] | undefined;
                            format?: string | undefined;
                            enum?: string[] | undefined;
                            file?: any;
                            nullable?: boolean | undefined;
                        }[];
                        encoding: "form-data" | "urlencoded";
                    } | undefined;
                    binary?: Blob | undefined;
                    raw?: {
                        value: string;
                        encoding: "xml" | "json" | "text" | "html" | "javascript" | "yaml" | "edn";
                        mimeType?: string | undefined;
                    } | undefined;
                };
                parameters: {
                    path: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        description?: string | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        enum?: string[] | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                    query: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        description?: string | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        enum?: string[] | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                    headers: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        description?: string | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        enum?: string[] | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                    cookies: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        description?: string | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        enum?: string[] | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                };
                requestUid?: (string & import("zod").BRAND<"operation">) | undefined;
                serverVariables?: Record<string, string[]> | undefined;
            }) => void;
            edit: <P extends "parameters" | "requestUid" | "type" | "name" | "uid" | "body" | "serverVariables" | "parameters.path" | "parameters.query" | "parameters.cookies" | `parameters.cookies.${number}` | "parameters.headers" | `parameters.path.${number}` | `parameters.path.${number}.description` | `parameters.path.${number}.examples` | `parameters.path.${number}.required` | `parameters.path.${number}.examples.${number}` | `parameters.path.${number}.default` | `parameters.path.${number}.value` | `parameters.path.${number}.type` | `parameters.path.${number}.key` | `parameters.path.${number}.file` | `parameters.path.${number}.enum` | `parameters.path.${number}.nullable` | `parameters.path.${number}.format` | `parameters.path.${number}.maximum` | `parameters.path.${number}.minimum` | `parameters.path.${number}.enum.${number}` | `parameters.path.${number}.enabled` | `parameters.path.${number}.default.${string}` | `parameters.path.${number}.type.${number}` | `parameters.path.${number}.file.${string}` | `parameters.query.${number}` | `parameters.query.${number}.description` | `parameters.query.${number}.examples` | `parameters.query.${number}.required` | `parameters.query.${number}.examples.${number}` | `parameters.query.${number}.default` | `parameters.query.${number}.value` | `parameters.query.${number}.type` | `parameters.query.${number}.key` | `parameters.query.${number}.file` | `parameters.query.${number}.enum` | `parameters.query.${number}.nullable` | `parameters.query.${number}.format` | `parameters.query.${number}.maximum` | `parameters.query.${number}.minimum` | `parameters.query.${number}.enum.${number}` | `parameters.query.${number}.enabled` | `parameters.query.${number}.default.${string}` | `parameters.query.${number}.type.${number}` | `parameters.query.${number}.file.${string}` | `parameters.cookies.${number}.description` | `parameters.cookies.${number}.examples` | `parameters.cookies.${number}.required` | `parameters.cookies.${number}.examples.${number}` | `parameters.cookies.${number}.default` | `parameters.cookies.${number}.value` | `parameters.cookies.${number}.type` | `parameters.cookies.${number}.key` | `parameters.cookies.${number}.file` | `parameters.cookies.${number}.enum` | `parameters.cookies.${number}.nullable` | `parameters.cookies.${number}.format` | `parameters.cookies.${number}.maximum` | `parameters.cookies.${number}.minimum` | `parameters.cookies.${number}.enum.${number}` | `parameters.cookies.${number}.enabled` | `parameters.cookies.${number}.default.${string}` | `parameters.cookies.${number}.type.${number}` | `parameters.cookies.${number}.file.${string}` | `parameters.headers.${number}` | `parameters.headers.${number}.description` | `parameters.headers.${number}.examples` | `parameters.headers.${number}.required` | `parameters.headers.${number}.examples.${number}` | `parameters.headers.${number}.default` | `parameters.headers.${number}.value` | `parameters.headers.${number}.type` | `parameters.headers.${number}.key` | `parameters.headers.${number}.file` | `parameters.headers.${number}.enum` | `parameters.headers.${number}.nullable` | `parameters.headers.${number}.format` | `parameters.headers.${number}.maximum` | `parameters.headers.${number}.minimum` | `parameters.headers.${number}.enum.${number}` | `parameters.headers.${number}.enabled` | `parameters.headers.${number}.default.${string}` | `parameters.headers.${number}.type.${number}` | `parameters.headers.${number}.file.${string}` | "body.formData" | "body.binary" | "body.raw" | "body.activeBody" | "body.formData.value" | "body.formData.encoding" | `body.formData.value.${number}` | `body.formData.value.${number}.description` | `body.formData.value.${number}.examples` | `body.formData.value.${number}.required` | `body.formData.value.${number}.examples.${number}` | `body.formData.value.${number}.default` | `body.formData.value.${number}.value` | `body.formData.value.${number}.type` | `body.formData.value.${number}.key` | `body.formData.value.${number}.file` | `body.formData.value.${number}.enum` | `body.formData.value.${number}.nullable` | `body.formData.value.${number}.format` | `body.formData.value.${number}.maximum` | `body.formData.value.${number}.minimum` | `body.formData.value.${number}.enum.${number}` | `body.formData.value.${number}.enabled` | `body.formData.value.${number}.default.${string}` | `body.formData.value.${number}.type.${number}` | `body.formData.value.${number}.file.${string}` | "body.binary.size" | "body.binary.slice" | "body.binary.type" | "body.binary.text" | "body.binary.arrayBuffer" | "body.binary.stream" | "body.raw.value" | "body.raw.encoding" | "body.raw.mimeType" | `serverVariables.${string}`>(uid: (string & import("zod").BRAND<"example">) | null | undefined, path: P, value: P extends "parameters" | "requestUid" | "type" | "name" | "uid" | "body" | "serverVariables" ? {
                uid: string & import("zod").BRAND<"example">;
                name: string;
                type: "requestExample";
                body: {
                    activeBody: "formData" | "binary" | "raw";
                    formData?: {
                        value: {
                            value: string;
                            key: string;
                            enabled: boolean;
                            minimum?: number | undefined;
                            type?: string | string[] | undefined;
                            maximum?: number | undefined;
                            description?: string | undefined;
                            default?: any;
                            required?: boolean | undefined;
                            examples?: string[] | undefined;
                            format?: string | undefined;
                            enum?: string[] | undefined;
                            file?: any;
                            nullable?: boolean | undefined;
                        }[];
                        encoding: "form-data" | "urlencoded";
                    } | undefined;
                    binary?: Blob | undefined;
                    raw?: {
                        value: string;
                        encoding: "xml" | "json" | "text" | "html" | "javascript" | "yaml" | "edn";
                        mimeType?: string | undefined;
                    } | undefined;
                };
                parameters: {
                    path: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        description?: string | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        enum?: string[] | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                    query: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        description?: string | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        enum?: string[] | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                    headers: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        description?: string | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        enum?: string[] | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                    cookies: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        description?: string | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        enum?: string[] | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                };
                requestUid?: (string & import("zod").BRAND<"operation">) | undefined;
                serverVariables?: Record<string, string[]> | undefined;
            }[P] : P extends `${infer K}.${infer R}` ? K extends "parameters" | "requestUid" | "type" | "name" | "uid" | "body" | "serverVariables" ? R extends import("@scalar/object-utils/nested").Path<{
                uid: string & import("zod").BRAND<"example">;
                name: string;
                type: "requestExample";
                body: {
                    activeBody: "formData" | "binary" | "raw";
                    formData?: {
                        value: {
                            value: string;
                            key: string;
                            enabled: boolean;
                            minimum?: number | undefined;
                            type?: string | string[] | undefined;
                            maximum?: number | undefined;
                            description?: string | undefined;
                            default?: any;
                            required?: boolean | undefined;
                            examples?: string[] | undefined;
                            format?: string | undefined;
                            enum?: string[] | undefined;
                            file?: any;
                            nullable?: boolean | undefined;
                        }[];
                        encoding: "form-data" | "urlencoded";
                    } | undefined;
                    binary?: Blob | undefined;
                    raw?: {
                        value: string;
                        encoding: "xml" | "json" | "text" | "html" | "javascript" | "yaml" | "edn";
                        mimeType?: string | undefined;
                    } | undefined;
                };
                parameters: {
                    path: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        description?: string | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        enum?: string[] | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                    query: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        description?: string | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        enum?: string[] | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                    headers: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        description?: string | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        enum?: string[] | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                    cookies: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        description?: string | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        enum?: string[] | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                };
                requestUid?: (string & import("zod").BRAND<"operation">) | undefined;
                serverVariables?: Record<string, string[]> | undefined;
            }[K]> ? import("@scalar/object-utils/nested").PathValue<{
                uid: string & import("zod").BRAND<"example">;
                name: string;
                type: "requestExample";
                body: {
                    activeBody: "formData" | "binary" | "raw";
                    formData?: {
                        value: {
                            value: string;
                            key: string;
                            enabled: boolean;
                            minimum?: number | undefined;
                            type?: string | string[] | undefined;
                            maximum?: number | undefined;
                            description?: string | undefined;
                            default?: any;
                            required?: boolean | undefined;
                            examples?: string[] | undefined;
                            format?: string | undefined;
                            enum?: string[] | undefined;
                            file?: any;
                            nullable?: boolean | undefined;
                        }[];
                        encoding: "form-data" | "urlencoded";
                    } | undefined;
                    binary?: Blob | undefined;
                    raw?: {
                        value: string;
                        encoding: "xml" | "json" | "text" | "html" | "javascript" | "yaml" | "edn";
                        mimeType?: string | undefined;
                    } | undefined;
                };
                parameters: {
                    path: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        description?: string | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        enum?: string[] | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                    query: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        description?: string | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        enum?: string[] | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                    headers: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        description?: string | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        enum?: string[] | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                    cookies: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        description?: string | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        enum?: string[] | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                };
                requestUid?: (string & import("zod").BRAND<"operation">) | undefined;
                serverVariables?: Record<string, string[]> | undefined;
            }[K], R> : never : K extends `${number}` ? never : never : P extends `${number}` ? never : never) => void;
            untrackedEdit: <P extends "parameters" | "requestUid" | "type" | "name" | "uid" | "body" | "serverVariables" | "parameters.path" | "parameters.query" | "parameters.cookies" | `parameters.cookies.${number}` | "parameters.headers" | `parameters.path.${number}` | `parameters.path.${number}.description` | `parameters.path.${number}.examples` | `parameters.path.${number}.required` | `parameters.path.${number}.examples.${number}` | `parameters.path.${number}.default` | `parameters.path.${number}.value` | `parameters.path.${number}.type` | `parameters.path.${number}.key` | `parameters.path.${number}.file` | `parameters.path.${number}.enum` | `parameters.path.${number}.nullable` | `parameters.path.${number}.format` | `parameters.path.${number}.maximum` | `parameters.path.${number}.minimum` | `parameters.path.${number}.enum.${number}` | `parameters.path.${number}.enabled` | `parameters.path.${number}.default.${string}` | `parameters.path.${number}.type.${number}` | `parameters.path.${number}.file.${string}` | `parameters.query.${number}` | `parameters.query.${number}.description` | `parameters.query.${number}.examples` | `parameters.query.${number}.required` | `parameters.query.${number}.examples.${number}` | `parameters.query.${number}.default` | `parameters.query.${number}.value` | `parameters.query.${number}.type` | `parameters.query.${number}.key` | `parameters.query.${number}.file` | `parameters.query.${number}.enum` | `parameters.query.${number}.nullable` | `parameters.query.${number}.format` | `parameters.query.${number}.maximum` | `parameters.query.${number}.minimum` | `parameters.query.${number}.enum.${number}` | `parameters.query.${number}.enabled` | `parameters.query.${number}.default.${string}` | `parameters.query.${number}.type.${number}` | `parameters.query.${number}.file.${string}` | `parameters.cookies.${number}.description` | `parameters.cookies.${number}.examples` | `parameters.cookies.${number}.required` | `parameters.cookies.${number}.examples.${number}` | `parameters.cookies.${number}.default` | `parameters.cookies.${number}.value` | `parameters.cookies.${number}.type` | `parameters.cookies.${number}.key` | `parameters.cookies.${number}.file` | `parameters.cookies.${number}.enum` | `parameters.cookies.${number}.nullable` | `parameters.cookies.${number}.format` | `parameters.cookies.${number}.maximum` | `parameters.cookies.${number}.minimum` | `parameters.cookies.${number}.enum.${number}` | `parameters.cookies.${number}.enabled` | `parameters.cookies.${number}.default.${string}` | `parameters.cookies.${number}.type.${number}` | `parameters.cookies.${number}.file.${string}` | `parameters.headers.${number}` | `parameters.headers.${number}.description` | `parameters.headers.${number}.examples` | `parameters.headers.${number}.required` | `parameters.headers.${number}.examples.${number}` | `parameters.headers.${number}.default` | `parameters.headers.${number}.value` | `parameters.headers.${number}.type` | `parameters.headers.${number}.key` | `parameters.headers.${number}.file` | `parameters.headers.${number}.enum` | `parameters.headers.${number}.nullable` | `parameters.headers.${number}.format` | `parameters.headers.${number}.maximum` | `parameters.headers.${number}.minimum` | `parameters.headers.${number}.enum.${number}` | `parameters.headers.${number}.enabled` | `parameters.headers.${number}.default.${string}` | `parameters.headers.${number}.type.${number}` | `parameters.headers.${number}.file.${string}` | "body.formData" | "body.binary" | "body.raw" | "body.activeBody" | "body.formData.value" | "body.formData.encoding" | `body.formData.value.${number}` | `body.formData.value.${number}.description` | `body.formData.value.${number}.examples` | `body.formData.value.${number}.required` | `body.formData.value.${number}.examples.${number}` | `body.formData.value.${number}.default` | `body.formData.value.${number}.value` | `body.formData.value.${number}.type` | `body.formData.value.${number}.key` | `body.formData.value.${number}.file` | `body.formData.value.${number}.enum` | `body.formData.value.${number}.nullable` | `body.formData.value.${number}.format` | `body.formData.value.${number}.maximum` | `body.formData.value.${number}.minimum` | `body.formData.value.${number}.enum.${number}` | `body.formData.value.${number}.enabled` | `body.formData.value.${number}.default.${string}` | `body.formData.value.${number}.type.${number}` | `body.formData.value.${number}.file.${string}` | "body.binary.size" | "body.binary.slice" | "body.binary.type" | "body.binary.text" | "body.binary.arrayBuffer" | "body.binary.stream" | "body.raw.value" | "body.raw.encoding" | "body.raw.mimeType" | `serverVariables.${string}`>(uid: string & import("zod").BRAND<"example">, path: P, value: P extends "parameters" | "requestUid" | "type" | "name" | "uid" | "body" | "serverVariables" ? {
                uid: string & import("zod").BRAND<"example">;
                name: string;
                type: "requestExample";
                body: {
                    activeBody: "formData" | "binary" | "raw";
                    formData?: {
                        value: {
                            value: string;
                            key: string;
                            enabled: boolean;
                            minimum?: number | undefined;
                            type?: string | string[] | undefined;
                            maximum?: number | undefined;
                            description?: string | undefined;
                            default?: any;
                            required?: boolean | undefined;
                            examples?: string[] | undefined;
                            format?: string | undefined;
                            enum?: string[] | undefined;
                            file?: any;
                            nullable?: boolean | undefined;
                        }[];
                        encoding: "form-data" | "urlencoded";
                    } | undefined;
                    binary?: Blob | undefined;
                    raw?: {
                        value: string;
                        encoding: "xml" | "json" | "text" | "html" | "javascript" | "yaml" | "edn";
                        mimeType?: string | undefined;
                    } | undefined;
                };
                parameters: {
                    path: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        description?: string | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        enum?: string[] | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                    query: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        description?: string | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        enum?: string[] | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                    headers: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        description?: string | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        enum?: string[] | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                    cookies: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        description?: string | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        enum?: string[] | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                };
                requestUid?: (string & import("zod").BRAND<"operation">) | undefined;
                serverVariables?: Record<string, string[]> | undefined;
            }[P] : P extends `${infer K}.${infer R}` ? K extends "parameters" | "requestUid" | "type" | "name" | "uid" | "body" | "serverVariables" ? R extends import("@scalar/object-utils/nested").Path<{
                uid: string & import("zod").BRAND<"example">;
                name: string;
                type: "requestExample";
                body: {
                    activeBody: "formData" | "binary" | "raw";
                    formData?: {
                        value: {
                            value: string;
                            key: string;
                            enabled: boolean;
                            minimum?: number | undefined;
                            type?: string | string[] | undefined;
                            maximum?: number | undefined;
                            description?: string | undefined;
                            default?: any;
                            required?: boolean | undefined;
                            examples?: string[] | undefined;
                            format?: string | undefined;
                            enum?: string[] | undefined;
                            file?: any;
                            nullable?: boolean | undefined;
                        }[];
                        encoding: "form-data" | "urlencoded";
                    } | undefined;
                    binary?: Blob | undefined;
                    raw?: {
                        value: string;
                        encoding: "xml" | "json" | "text" | "html" | "javascript" | "yaml" | "edn";
                        mimeType?: string | undefined;
                    } | undefined;
                };
                parameters: {
                    path: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        description?: string | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        enum?: string[] | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                    query: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        description?: string | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        enum?: string[] | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                    headers: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        description?: string | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        enum?: string[] | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                    cookies: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        description?: string | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        enum?: string[] | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                };
                requestUid?: (string & import("zod").BRAND<"operation">) | undefined;
                serverVariables?: Record<string, string[]> | undefined;
            }[K]> ? import("@scalar/object-utils/nested").PathValue<{
                uid: string & import("zod").BRAND<"example">;
                name: string;
                type: "requestExample";
                body: {
                    activeBody: "formData" | "binary" | "raw";
                    formData?: {
                        value: {
                            value: string;
                            key: string;
                            enabled: boolean;
                            minimum?: number | undefined;
                            type?: string | string[] | undefined;
                            maximum?: number | undefined;
                            description?: string | undefined;
                            default?: any;
                            required?: boolean | undefined;
                            examples?: string[] | undefined;
                            format?: string | undefined;
                            enum?: string[] | undefined;
                            file?: any;
                            nullable?: boolean | undefined;
                        }[];
                        encoding: "form-data" | "urlencoded";
                    } | undefined;
                    binary?: Blob | undefined;
                    raw?: {
                        value: string;
                        encoding: "xml" | "json" | "text" | "html" | "javascript" | "yaml" | "edn";
                        mimeType?: string | undefined;
                    } | undefined;
                };
                parameters: {
                    path: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        description?: string | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        enum?: string[] | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                    query: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        description?: string | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        enum?: string[] | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                    headers: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        description?: string | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        enum?: string[] | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                    cookies: {
                        value: string;
                        key: string;
                        enabled: boolean;
                        minimum?: number | undefined;
                        type?: string | string[] | undefined;
                        maximum?: number | undefined;
                        description?: string | undefined;
                        default?: any;
                        required?: boolean | undefined;
                        examples?: string[] | undefined;
                        format?: string | undefined;
                        enum?: string[] | undefined;
                        file?: any;
                        nullable?: boolean | undefined;
                    }[];
                };
                requestUid?: (string & import("zod").BRAND<"operation">) | undefined;
                serverVariables?: Record<string, string[]> | undefined;
            }[K], R> : never : K extends `${number}` ? never : never : P extends `${number}` ? never : never) => void;
            undo: (uid: string & import("zod").BRAND<"example">) => void;
            redo: (uid: string & import("zod").BRAND<"example">) => void;
            reset: () => void;
        };
        modalState: {
            open: boolean;
            show: () => void;
            hide: () => void;
        };
        workspaces: Record<string, {
            uid: string & import("zod").BRAND<"workspace">;
            name: string;
            description: string;
            cookies: (string & import("zod").BRAND<"cookie">)[];
            collections: (string & import("zod").BRAND<"collection">)[];
            environments: Record<string, string>;
            activeEnvironmentId: string;
            themeId: "default" | "alternate" | "moon" | "purple" | "solarized" | "bluePlanet" | "deepSpace" | "saturn" | "kepler" | "elysiajs" | "fastify" | "mars" | "laserwave" | "none";
            selectedHttpClient: {
                targetKey: string;
                clientKey: string;
            };
            hotKeyConfig?: {
                modifiers: ("default" | "Meta" | "Control" | "Shift" | "Alt")[];
                hotKeys?: Partial<Record<"" | "0" | "Space" | "Backspace" | "Tab" | "Enter" | "Escape" | "ArrowDown" | "ArrowLeft" | "ArrowRight" | "ArrowUp" | "End" | "Home" | "PageDown" | "PageUp" | "Delete" | "1" | "2" | "3" | "4" | "5" | "6" | "7" | "8" | "9" | "a" | "b" | "c" | "d" | "e" | "f" | "g" | "h" | "i" | "j" | "k" | "l" | "m" | "n" | "o" | "p" | "q" | "r" | "s" | "t" | "u" | "v" | "w" | "x" | "y" | "z" | "*" | "+" | "-" | "." | "/" | "F1" | "F2" | "F3" | "F4" | "F5" | "F6" | "F7" | "F8" | "F9" | "F10" | "F11" | "F12" | ";" | "=" | "," | "`" | "[" | "\\" | "]", {
                    event: "addTopNav" | "closeModal" | "closeTopNav" | "createNew" | "executeRequest" | "focusAddressBar" | "focusRequestSearch" | "jumpToLastTab" | "jumpToTab" | "navigateSearchResultsDown" | "navigateSearchResultsUp" | "navigateTopNavLeft" | "navigateTopNavRight" | "openCommandPalette" | "selectSearchResult" | "toggleSidebar";
                    modifiers?: ("default" | "Meta" | "Control" | "Shift" | "Alt")[] | undefined;
                }>> | undefined;
            } | undefined;
            proxyUrl?: string | undefined;
        }>;
        environments: Record<string, {
            uid: string & import("zod").BRAND<"environment">;
            name: string;
            value: string;
            color: string;
            isDefault?: boolean | undefined;
        }>;
        setSidebarWidth: (width: string) => void;
        integration: "elysiajs" | "fastify" | "go" | "adonisjs" | "docusaurus" | "dotnet" | "express" | "fastapi" | "hono" | "html" | "laravel" | "litestar" | "nestjs" | "nextjs" | "nitro" | "nuxt" | "platformatic" | "react" | "rust" | "vue" | null | undefined;
        importSpecFile: (_spec: string | Record<string, any>, workspaceUid: string, options?: Pick<{
            uid?: string | undefined;
            type?: "collection" | undefined;
            externalDocs?: {
                url: string;
                description?: unknown;
            } | undefined;
            children?: string[] | undefined;
            openapi?: string | undefined;
            jsonSchemaDialect?: string | undefined;
            info?: unknown;
            security?: Record<string, string[] | undefined>[] | undefined;
            components?: Record<string, unknown> | undefined;
            webhooks?: Record<string, unknown> | undefined;
            "x-scalar-icon"?: string | undefined;
            "x-scalar-active-environment"?: string | undefined;
            "x-scalar-environments"?: Record<string, {
                variables: Record<string, string | {
                    description?: string | undefined;
                    default?: string | undefined;
                }>;
                color?: string | undefined;
                description?: string | undefined;
            }> | undefined;
            "x-scalar-secrets"?: Record<string, {
                description?: string | undefined;
                example?: string | undefined;
            }> | undefined;
            securitySchemes?: string[] | undefined;
            selectedSecuritySchemeUids?: (string | string[])[] | undefined;
            selectedServerUid?: string | undefined;
            servers?: string[] | undefined;
            requests?: string[] | undefined;
            tags?: string[] | undefined;
            documentUrl?: string | undefined;
            watchMode?: boolean | undefined;
            integration?: string | null | undefined;
            useCollectionSecurity?: boolean | undefined;
            watchModeStatus?: "IDLE" | "WATCHING" | "ERROR" | undefined;
        }, "watchMode" | "documentUrl"> & Pick<import("@scalar/types/api-reference").ApiReferenceConfiguration, "slug" | "authentication" | "baseServerURL" | "servers"> & {
            useCollectionSecurity?: boolean;
            shouldLoad?: boolean;
        } & Pick<import("@scalar/types/api-reference").ApiReferenceConfiguration, "servers">) => Promise<{
            error: false;
            collection: import("@scalar/oas-utils/entities/spec").Collection;
            requests: import("@scalar/oas-utils/entities/spec").Request[];
            schema: import("@scalar/openapi-types").OpenAPIV3_1.Document;
            examples: import("@scalar/oas-utils/entities/spec").RequestExample[];
            servers: import("@scalar/oas-utils/entities/spec").Server[];
            tags: import("@scalar/oas-utils/entities/spec").Tag[];
            securitySchemes: import("@scalar/types/entities").SecurityScheme[];
        } | undefined>;
        importSpecFromUrl: (url: string, workspaceUid: string, { proxyUrl, ...options }?: Omit<Pick<{
            uid?: string | undefined;
            type?: "collection" | undefined;
            externalDocs?: {
                url: string;
                description?: unknown;
            } | undefined;
            children?: string[] | undefined;
            openapi?: string | undefined;
            jsonSchemaDialect?: string | undefined;
            info?: unknown;
            security?: Record<string, string[] | undefined>[] | undefined;
            components?: Record<string, unknown> | undefined;
            webhooks?: Record<string, unknown> | undefined;
            "x-scalar-icon"?: string | undefined;
            "x-scalar-active-environment"?: string | undefined;
            "x-scalar-environments"?: Record<string, {
                variables: Record<string, string | {
                    description?: string | undefined;
                    default?: string | undefined;
                }>;
                color?: string | undefined;
                description?: string | undefined;
            }> | undefined;
            "x-scalar-secrets"?: Record<string, {
                description?: string | undefined;
                example?: string | undefined;
            }> | undefined;
            securitySchemes?: string[] | undefined;
            selectedSecuritySchemeUids?: (string | string[])[] | undefined;
            selectedServerUid?: string | undefined;
            servers?: string[] | undefined;
            requests?: string[] | undefined;
            tags?: string[] | undefined;
            documentUrl?: string | undefined;
            watchMode?: boolean | undefined;
            integration?: string | null | undefined;
            useCollectionSecurity?: boolean | undefined;
            watchModeStatus?: "IDLE" | "WATCHING" | "ERROR" | undefined;
        }, "watchMode" | "documentUrl"> & Pick<import("@scalar/types/api-reference").ApiReferenceConfiguration, "slug" | "authentication" | "baseServerURL" | "servers"> & {
            useCollectionSecurity?: boolean;
            shouldLoad?: boolean;
        } & Pick<import("@scalar/types/api-reference").ApiReferenceConfiguration, "servers">, "documentUrl"> & Pick<import("@scalar/types/api-reference").ApiReferenceConfiguration, "proxyUrl">) => Promise<import("@scalar/api-client/libs").ErrorResponse<Awaited<ReturnType<(_spec: string | Record<string, any>, workspaceUid: string, options?: Pick<{
            uid?: string | undefined;
            type?: "collection" | undefined;
            externalDocs?: {
                url: string;
                description?: unknown;
            } | undefined;
            children?: string[] | undefined;
            openapi?: string | undefined;
            jsonSchemaDialect?: string | undefined;
            info?: unknown;
            security?: Record<string, string[] | undefined>[] | undefined;
            components?: Record<string, unknown> | undefined;
            webhooks?: Record<string, unknown> | undefined;
            "x-scalar-icon"?: string | undefined;
            "x-scalar-active-environment"?: string | undefined;
            "x-scalar-environments"?: Record<string, {
                variables: Record<string, string | {
                    description?: string | undefined;
                    default?: string | undefined;
                }>;
                color?: string | undefined;
                description?: string | undefined;
            }> | undefined;
            "x-scalar-secrets"?: Record<string, {
                description?: string | undefined;
                example?: string | undefined;
            }> | undefined;
            securitySchemes?: string[] | undefined;
            selectedSecuritySchemeUids?: (string | string[])[] | undefined;
            selectedServerUid?: string | undefined;
            servers?: string[] | undefined;
            requests?: string[] | undefined;
            tags?: string[] | undefined;
            documentUrl?: string | undefined;
            watchMode?: boolean | undefined;
            integration?: string | null | undefined;
            useCollectionSecurity?: boolean | undefined;
            watchModeStatus?: "IDLE" | "WATCHING" | "ERROR" | undefined;
        }, "watchMode" | "documentUrl"> & Pick<import("@scalar/types/api-reference").ApiReferenceConfiguration, "slug" | "authentication" | "baseServerURL" | "servers"> & {
            useCollectionSecurity?: boolean;
            shouldLoad?: boolean;
        } & Pick<import("@scalar/types/api-reference").ApiReferenceConfiguration, "servers">) => Promise<{
            error: false;
            collection: import("@scalar/oas-utils/entities/spec").Collection;
            requests: import("@scalar/oas-utils/entities/spec").Request[];
            schema: import("@scalar/openapi-types").OpenAPIV3_1.Document;
            examples: import("@scalar/oas-utils/entities/spec").RequestExample[];
            servers: import("@scalar/oas-utils/entities/spec").Server[];
            tags: import("@scalar/oas-utils/entities/spec").Tag[];
            securitySchemes: import("@scalar/types/entities").SecurityScheme[];
        } | undefined>>>>>;
        cookieMutators: {
            add: (item: {
                uid: string & import("zod").BRAND<"cookie">;
                name: string;
                value: string;
                domain?: string | undefined;
                path?: string | undefined;
            }) => void;
            delete: (uid: (string & import("zod").BRAND<"cookie">) | null | undefined) => void;
            set: (item: {
                uid: string & import("zod").BRAND<"cookie">;
                name: string;
                value: string;
                domain?: string | undefined;
                path?: string | undefined;
            }) => void;
            edit: <P extends "value" | "path" | "name" | "uid" | "domain">(uid: (string & import("zod").BRAND<"cookie">) | null | undefined, path: P, value: P extends "value" | "path" | "name" | "uid" | "domain" ? {
                uid: string & import("zod").BRAND<"cookie">;
                name: string;
                value: string;
                domain?: string | undefined;
                path?: string | undefined;
            }[P] : P extends `${infer K}.${infer R}` ? K extends "value" | "path" | "name" | "uid" | "domain" ? R extends import("@scalar/object-utils/nested").Path<{
                uid: string & import("zod").BRAND<"cookie">;
                name: string;
                value: string;
                domain?: string | undefined;
                path?: string | undefined;
            }[K]> ? import("@scalar/object-utils/nested").PathValue<{
                uid: string & import("zod").BRAND<"cookie">;
                name: string;
                value: string;
                domain?: string | undefined;
                path?: string | undefined;
            }[K], R> : never : K extends `${number}` ? never : never : P extends `${number}` ? never : never) => void;
            untrackedEdit: <P extends "value" | "path" | "name" | "uid" | "domain">(uid: string & import("zod").BRAND<"cookie">, path: P, value: P extends "value" | "path" | "name" | "uid" | "domain" ? {
                uid: string & import("zod").BRAND<"cookie">;
                name: string;
                value: string;
                domain?: string | undefined;
                path?: string | undefined;
            }[P] : P extends `${infer K}.${infer R}` ? K extends "value" | "path" | "name" | "uid" | "domain" ? R extends import("@scalar/object-utils/nested").Path<{
                uid: string & import("zod").BRAND<"cookie">;
                name: string;
                value: string;
                domain?: string | undefined;
                path?: string | undefined;
            }[K]> ? import("@scalar/object-utils/nested").PathValue<{
                uid: string & import("zod").BRAND<"cookie">;
                name: string;
                value: string;
                domain?: string | undefined;
                path?: string | undefined;
            }[K], R> : never : K extends `${number}` ? never : never : P extends `${number}` ? never : never) => void;
            undo: (uid: string & import("zod").BRAND<"cookie">) => void;
            redo: (uid: string & import("zod").BRAND<"cookie">) => void;
            reset: () => void;
        };
        collectionMutators: {
            rawAdd: (item: {
                uid: string & import("zod").BRAND<"collection">;
                type: "collection";
                children: ((string & import("zod").BRAND<"tag">) | (string & import("zod").BRAND<"operation">))[];
                openapi: string;
                info: {
                    title: string;
                    version: string;
                    description?: string | undefined;
                    summary?: string | undefined;
                    termsOfService?: string | undefined;
                    contact?: {
                        name?: string | undefined;
                        url?: string | undefined;
                        email?: string | undefined;
                    } | undefined;
                    license?: {
                        name?: string | null | undefined;
                        identifier?: string | undefined;
                        url?: string | undefined;
                    } | undefined;
                };
                security: Record<string, string[]>[];
                "x-scalar-icon": string;
                securitySchemes: string[];
                selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
                servers: (string & import("zod").BRAND<"server">)[];
                requests: (string & import("zod").BRAND<"operation">)[];
                tags: (string & import("zod").BRAND<"tag">)[];
                watchMode: boolean;
                useCollectionSecurity: boolean;
                watchModeStatus: "IDLE" | "WATCHING" | "ERROR";
                externalDocs?: {
                    url: string;
                    description?: string | undefined;
                } | undefined;
                jsonSchemaDialect?: string | undefined;
                components?: Record<string, unknown> | undefined;
                webhooks?: Record<string, unknown> | undefined;
                "x-scalar-active-environment"?: string | undefined;
                "x-scalar-environments"?: Record<string, {
                    variables: Record<string, string | {
                        default: string;
                        description?: string | undefined;
                    }>;
                    color?: string | undefined;
                    description?: string | undefined;
                }> | undefined;
                "x-scalar-secrets"?: Record<string, {
                    description?: string | undefined;
                    example?: string | undefined;
                }> | undefined;
                selectedServerUid?: (string & import("zod").BRAND<"server">) | undefined;
                documentUrl?: string | undefined;
                integration?: string | null | undefined;
            }) => void;
            add: (payload: import("@scalar/oas-utils/entities/spec").CollectionPayload, workspaceUid: import("@scalar/oas-utils/entities/workspace").Workspace["uid"]) => {
                uid: string & import("zod").BRAND<"collection">;
                type: "collection";
                children: ((string & import("zod").BRAND<"tag">) | (string & import("zod").BRAND<"operation">))[];
                openapi: string;
                info: {
                    title: string;
                    version: string;
                    description?: string | undefined;
                    summary?: string | undefined;
                    termsOfService?: string | undefined;
                    contact?: {
                        name?: string | undefined;
                        url?: string | undefined;
                        email?: string | undefined;
                    } | undefined;
                    license?: {
                        name?: string | null | undefined;
                        identifier?: string | undefined;
                        url?: string | undefined;
                    } | undefined;
                };
                security: Record<string, string[]>[];
                "x-scalar-icon": string;
                securitySchemes: string[];
                selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
                servers: (string & import("zod").BRAND<"server">)[];
                requests: (string & import("zod").BRAND<"operation">)[];
                tags: (string & import("zod").BRAND<"tag">)[];
                watchMode: boolean;
                useCollectionSecurity: boolean;
                watchModeStatus: "IDLE" | "WATCHING" | "ERROR";
                externalDocs?: {
                    url: string;
                    description?: string | undefined;
                } | undefined;
                jsonSchemaDialect?: string | undefined;
                components?: Record<string, unknown> | undefined;
                webhooks?: Record<string, unknown> | undefined;
                "x-scalar-active-environment"?: string | undefined;
                "x-scalar-environments"?: Record<string, {
                    variables: Record<string, string | {
                        default: string;
                        description?: string | undefined;
                    }>;
                    color?: string | undefined;
                    description?: string | undefined;
                }> | undefined;
                "x-scalar-secrets"?: Record<string, {
                    description?: string | undefined;
                    example?: string | undefined;
                }> | undefined;
                selectedServerUid?: (string & import("zod").BRAND<"server">) | undefined;
                documentUrl?: string | undefined;
                integration?: string | null | undefined;
            };
            delete: (collection: import("@scalar/oas-utils/entities/spec").Collection, workspace: import("@scalar/oas-utils/entities/workspace").Workspace) => void;
            addEnvironment: (environmentName: string, environment: import("@scalar/oas-utils/entities/spec").XScalarEnvironment, collectionUid: import("@scalar/oas-utils/entities/spec").Collection["uid"]) => void;
            removeEnvironment: (environmentName: string, collectionUid: import("@scalar/oas-utils/entities/spec").Collection["uid"]) => void;
            set: (item: {
                uid: string & import("zod").BRAND<"collection">;
                type: "collection";
                children: ((string & import("zod").BRAND<"tag">) | (string & import("zod").BRAND<"operation">))[];
                openapi: string;
                info: {
                    title: string;
                    version: string;
                    description?: string | undefined;
                    summary?: string | undefined;
                    termsOfService?: string | undefined;
                    contact?: {
                        name?: string | undefined;
                        url?: string | undefined;
                        email?: string | undefined;
                    } | undefined;
                    license?: {
                        name?: string | null | undefined;
                        identifier?: string | undefined;
                        url?: string | undefined;
                    } | undefined;
                };
                security: Record<string, string[]>[];
                "x-scalar-icon": string;
                securitySchemes: string[];
                selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
                servers: (string & import("zod").BRAND<"server">)[];
                requests: (string & import("zod").BRAND<"operation">)[];
                tags: (string & import("zod").BRAND<"tag">)[];
                watchMode: boolean;
                useCollectionSecurity: boolean;
                watchModeStatus: "IDLE" | "WATCHING" | "ERROR";
                externalDocs?: {
                    url: string;
                    description?: string | undefined;
                } | undefined;
                jsonSchemaDialect?: string | undefined;
                components?: Record<string, unknown> | undefined;
                webhooks?: Record<string, unknown> | undefined;
                "x-scalar-active-environment"?: string | undefined;
                "x-scalar-environments"?: Record<string, {
                    variables: Record<string, string | {
                        default: string;
                        description?: string | undefined;
                    }>;
                    color?: string | undefined;
                    description?: string | undefined;
                }> | undefined;
                "x-scalar-secrets"?: Record<string, {
                    description?: string | undefined;
                    example?: string | undefined;
                }> | undefined;
                selectedServerUid?: (string & import("zod").BRAND<"server">) | undefined;
                documentUrl?: string | undefined;
                integration?: string | null | undefined;
            }) => void;
            edit: <P extends "servers" | "tags" | "security" | "externalDocs" | "type" | "uid" | "requests" | "x-scalar-environments" | "children" | "openapi" | "info" | "x-scalar-icon" | "securitySchemes" | "selectedSecuritySchemeUids" | "watchMode" | "useCollectionSecurity" | "watchModeStatus" | "jsonSchemaDialect" | "components" | "webhooks" | "x-scalar-active-environment" | "x-scalar-secrets" | "selectedServerUid" | "documentUrl" | "integration" | `servers.${number}` | `tags.${number}` | `security.${number}` | `security.${number}.${string}` | "externalDocs.url" | "externalDocs.description" | `requests.${number}` | `x-scalar-environments.${string}` | `children.${number}` | "info.title" | "info.summary" | "info.description" | "info.version" | "info.termsOfService" | "info.contact" | "info.license" | "info.contact.url" | "info.contact.name" | "info.contact.email" | "info.license.url" | "info.license.name" | "info.license.identifier" | `securitySchemes.${number}` | `selectedSecuritySchemeUids.${number}` | `selectedSecuritySchemeUids.${number}.${number}` | `components.${string}` | `webhooks.${string}` | `x-scalar-secrets.${string}`>(uid: (string & import("zod").BRAND<"collection">) | null | undefined, path: P, value: P extends "servers" | "tags" | "security" | "externalDocs" | "type" | "uid" | "requests" | "x-scalar-environments" | "children" | "openapi" | "info" | "x-scalar-icon" | "securitySchemes" | "selectedSecuritySchemeUids" | "watchMode" | "useCollectionSecurity" | "watchModeStatus" | "jsonSchemaDialect" | "components" | "webhooks" | "x-scalar-active-environment" | "x-scalar-secrets" | "selectedServerUid" | "documentUrl" | "integration" ? {
                uid: string & import("zod").BRAND<"collection">;
                type: "collection";
                children: ((string & import("zod").BRAND<"tag">) | (string & import("zod").BRAND<"operation">))[];
                openapi: string;
                info: {
                    title: string;
                    version: string;
                    description?: string | undefined;
                    summary?: string | undefined;
                    termsOfService?: string | undefined;
                    contact?: {
                        name?: string | undefined;
                        url?: string | undefined;
                        email?: string | undefined;
                    } | undefined;
                    license?: {
                        name?: string | null | undefined;
                        identifier?: string | undefined;
                        url?: string | undefined;
                    } | undefined;
                };
                security: Record<string, string[]>[];
                "x-scalar-icon": string;
                securitySchemes: string[];
                selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
                servers: (string & import("zod").BRAND<"server">)[];
                requests: (string & import("zod").BRAND<"operation">)[];
                tags: (string & import("zod").BRAND<"tag">)[];
                watchMode: boolean;
                useCollectionSecurity: boolean;
                watchModeStatus: "IDLE" | "WATCHING" | "ERROR";
                externalDocs?: {
                    url: string;
                    description?: string | undefined;
                } | undefined;
                jsonSchemaDialect?: string | undefined;
                components?: Record<string, unknown> | undefined;
                webhooks?: Record<string, unknown> | undefined;
                "x-scalar-active-environment"?: string | undefined;
                "x-scalar-environments"?: Record<string, {
                    variables: Record<string, string | {
                        default: string;
                        description?: string | undefined;
                    }>;
                    color?: string | undefined;
                    description?: string | undefined;
                }> | undefined;
                "x-scalar-secrets"?: Record<string, {
                    description?: string | undefined;
                    example?: string | undefined;
                }> | undefined;
                selectedServerUid?: (string & import("zod").BRAND<"server">) | undefined;
                documentUrl?: string | undefined;
                integration?: string | null | undefined;
            }[P] : P extends `${infer K}.${infer R}` ? K extends "servers" | "tags" | "security" | "externalDocs" | "type" | "uid" | "requests" | "x-scalar-environments" | "children" | "openapi" | "info" | "x-scalar-icon" | "securitySchemes" | "selectedSecuritySchemeUids" | "watchMode" | "useCollectionSecurity" | "watchModeStatus" | "jsonSchemaDialect" | "components" | "webhooks" | "x-scalar-active-environment" | "x-scalar-secrets" | "selectedServerUid" | "documentUrl" | "integration" ? R extends import("@scalar/object-utils/nested").Path<{
                uid: string & import("zod").BRAND<"collection">;
                type: "collection";
                children: ((string & import("zod").BRAND<"tag">) | (string & import("zod").BRAND<"operation">))[];
                openapi: string;
                info: {
                    title: string;
                    version: string;
                    description?: string | undefined;
                    summary?: string | undefined;
                    termsOfService?: string | undefined;
                    contact?: {
                        name?: string | undefined;
                        url?: string | undefined;
                        email?: string | undefined;
                    } | undefined;
                    license?: {
                        name?: string | null | undefined;
                        identifier?: string | undefined;
                        url?: string | undefined;
                    } | undefined;
                };
                security: Record<string, string[]>[];
                "x-scalar-icon": string;
                securitySchemes: string[];
                selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
                servers: (string & import("zod").BRAND<"server">)[];
                requests: (string & import("zod").BRAND<"operation">)[];
                tags: (string & import("zod").BRAND<"tag">)[];
                watchMode: boolean;
                useCollectionSecurity: boolean;
                watchModeStatus: "IDLE" | "WATCHING" | "ERROR";
                externalDocs?: {
                    url: string;
                    description?: string | undefined;
                } | undefined;
                jsonSchemaDialect?: string | undefined;
                components?: Record<string, unknown> | undefined;
                webhooks?: Record<string, unknown> | undefined;
                "x-scalar-active-environment"?: string | undefined;
                "x-scalar-environments"?: Record<string, {
                    variables: Record<string, string | {
                        default: string;
                        description?: string | undefined;
                    }>;
                    color?: string | undefined;
                    description?: string | undefined;
                }> | undefined;
                "x-scalar-secrets"?: Record<string, {
                    description?: string | undefined;
                    example?: string | undefined;
                }> | undefined;
                selectedServerUid?: (string & import("zod").BRAND<"server">) | undefined;
                documentUrl?: string | undefined;
                integration?: string | null | undefined;
            }[K]> ? import("@scalar/object-utils/nested").PathValue<{
                uid: string & import("zod").BRAND<"collection">;
                type: "collection";
                children: ((string & import("zod").BRAND<"tag">) | (string & import("zod").BRAND<"operation">))[];
                openapi: string;
                info: {
                    title: string;
                    version: string;
                    description?: string | undefined;
                    summary?: string | undefined;
                    termsOfService?: string | undefined;
                    contact?: {
                        name?: string | undefined;
                        url?: string | undefined;
                        email?: string | undefined;
                    } | undefined;
                    license?: {
                        name?: string | null | undefined;
                        identifier?: string | undefined;
                        url?: string | undefined;
                    } | undefined;
                };
                security: Record<string, string[]>[];
                "x-scalar-icon": string;
                securitySchemes: string[];
                selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
                servers: (string & import("zod").BRAND<"server">)[];
                requests: (string & import("zod").BRAND<"operation">)[];
                tags: (string & import("zod").BRAND<"tag">)[];
                watchMode: boolean;
                useCollectionSecurity: boolean;
                watchModeStatus: "IDLE" | "WATCHING" | "ERROR";
                externalDocs?: {
                    url: string;
                    description?: string | undefined;
                } | undefined;
                jsonSchemaDialect?: string | undefined;
                components?: Record<string, unknown> | undefined;
                webhooks?: Record<string, unknown> | undefined;
                "x-scalar-active-environment"?: string | undefined;
                "x-scalar-environments"?: Record<string, {
                    variables: Record<string, string | {
                        default: string;
                        description?: string | undefined;
                    }>;
                    color?: string | undefined;
                    description?: string | undefined;
                }> | undefined;
                "x-scalar-secrets"?: Record<string, {
                    description?: string | undefined;
                    example?: string | undefined;
                }> | undefined;
                selectedServerUid?: (string & import("zod").BRAND<"server">) | undefined;
                documentUrl?: string | undefined;
                integration?: string | null | undefined;
            }[K], R> : never : K extends `${number}` ? never : never : P extends `${number}` ? never : never) => void;
            untrackedEdit: <P extends "servers" | "tags" | "security" | "externalDocs" | "type" | "uid" | "requests" | "x-scalar-environments" | "children" | "openapi" | "info" | "x-scalar-icon" | "securitySchemes" | "selectedSecuritySchemeUids" | "watchMode" | "useCollectionSecurity" | "watchModeStatus" | "jsonSchemaDialect" | "components" | "webhooks" | "x-scalar-active-environment" | "x-scalar-secrets" | "selectedServerUid" | "documentUrl" | "integration" | `servers.${number}` | `tags.${number}` | `security.${number}` | `security.${number}.${string}` | "externalDocs.url" | "externalDocs.description" | `requests.${number}` | `x-scalar-environments.${string}` | `children.${number}` | "info.title" | "info.summary" | "info.description" | "info.version" | "info.termsOfService" | "info.contact" | "info.license" | "info.contact.url" | "info.contact.name" | "info.contact.email" | "info.license.url" | "info.license.name" | "info.license.identifier" | `securitySchemes.${number}` | `selectedSecuritySchemeUids.${number}` | `selectedSecuritySchemeUids.${number}.${number}` | `components.${string}` | `webhooks.${string}` | `x-scalar-secrets.${string}`>(uid: string & import("zod").BRAND<"collection">, path: P, value: P extends "servers" | "tags" | "security" | "externalDocs" | "type" | "uid" | "requests" | "x-scalar-environments" | "children" | "openapi" | "info" | "x-scalar-icon" | "securitySchemes" | "selectedSecuritySchemeUids" | "watchMode" | "useCollectionSecurity" | "watchModeStatus" | "jsonSchemaDialect" | "components" | "webhooks" | "x-scalar-active-environment" | "x-scalar-secrets" | "selectedServerUid" | "documentUrl" | "integration" ? {
                uid: string & import("zod").BRAND<"collection">;
                type: "collection";
                children: ((string & import("zod").BRAND<"tag">) | (string & import("zod").BRAND<"operation">))[];
                openapi: string;
                info: {
                    title: string;
                    version: string;
                    description?: string | undefined;
                    summary?: string | undefined;
                    termsOfService?: string | undefined;
                    contact?: {
                        name?: string | undefined;
                        url?: string | undefined;
                        email?: string | undefined;
                    } | undefined;
                    license?: {
                        name?: string | null | undefined;
                        identifier?: string | undefined;
                        url?: string | undefined;
                    } | undefined;
                };
                security: Record<string, string[]>[];
                "x-scalar-icon": string;
                securitySchemes: string[];
                selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
                servers: (string & import("zod").BRAND<"server">)[];
                requests: (string & import("zod").BRAND<"operation">)[];
                tags: (string & import("zod").BRAND<"tag">)[];
                watchMode: boolean;
                useCollectionSecurity: boolean;
                watchModeStatus: "IDLE" | "WATCHING" | "ERROR";
                externalDocs?: {
                    url: string;
                    description?: string | undefined;
                } | undefined;
                jsonSchemaDialect?: string | undefined;
                components?: Record<string, unknown> | undefined;
                webhooks?: Record<string, unknown> | undefined;
                "x-scalar-active-environment"?: string | undefined;
                "x-scalar-environments"?: Record<string, {
                    variables: Record<string, string | {
                        default: string;
                        description?: string | undefined;
                    }>;
                    color?: string | undefined;
                    description?: string | undefined;
                }> | undefined;
                "x-scalar-secrets"?: Record<string, {
                    description?: string | undefined;
                    example?: string | undefined;
                }> | undefined;
                selectedServerUid?: (string & import("zod").BRAND<"server">) | undefined;
                documentUrl?: string | undefined;
                integration?: string | null | undefined;
            }[P] : P extends `${infer K}.${infer R}` ? K extends "servers" | "tags" | "security" | "externalDocs" | "type" | "uid" | "requests" | "x-scalar-environments" | "children" | "openapi" | "info" | "x-scalar-icon" | "securitySchemes" | "selectedSecuritySchemeUids" | "watchMode" | "useCollectionSecurity" | "watchModeStatus" | "jsonSchemaDialect" | "components" | "webhooks" | "x-scalar-active-environment" | "x-scalar-secrets" | "selectedServerUid" | "documentUrl" | "integration" ? R extends import("@scalar/object-utils/nested").Path<{
                uid: string & import("zod").BRAND<"collection">;
                type: "collection";
                children: ((string & import("zod").BRAND<"tag">) | (string & import("zod").BRAND<"operation">))[];
                openapi: string;
                info: {
                    title: string;
                    version: string;
                    description?: string | undefined;
                    summary?: string | undefined;
                    termsOfService?: string | undefined;
                    contact?: {
                        name?: string | undefined;
                        url?: string | undefined;
                        email?: string | undefined;
                    } | undefined;
                    license?: {
                        name?: string | null | undefined;
                        identifier?: string | undefined;
                        url?: string | undefined;
                    } | undefined;
                };
                security: Record<string, string[]>[];
                "x-scalar-icon": string;
                securitySchemes: string[];
                selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
                servers: (string & import("zod").BRAND<"server">)[];
                requests: (string & import("zod").BRAND<"operation">)[];
                tags: (string & import("zod").BRAND<"tag">)[];
                watchMode: boolean;
                useCollectionSecurity: boolean;
                watchModeStatus: "IDLE" | "WATCHING" | "ERROR";
                externalDocs?: {
                    url: string;
                    description?: string | undefined;
                } | undefined;
                jsonSchemaDialect?: string | undefined;
                components?: Record<string, unknown> | undefined;
                webhooks?: Record<string, unknown> | undefined;
                "x-scalar-active-environment"?: string | undefined;
                "x-scalar-environments"?: Record<string, {
                    variables: Record<string, string | {
                        default: string;
                        description?: string | undefined;
                    }>;
                    color?: string | undefined;
                    description?: string | undefined;
                }> | undefined;
                "x-scalar-secrets"?: Record<string, {
                    description?: string | undefined;
                    example?: string | undefined;
                }> | undefined;
                selectedServerUid?: (string & import("zod").BRAND<"server">) | undefined;
                documentUrl?: string | undefined;
                integration?: string | null | undefined;
            }[K]> ? import("@scalar/object-utils/nested").PathValue<{
                uid: string & import("zod").BRAND<"collection">;
                type: "collection";
                children: ((string & import("zod").BRAND<"tag">) | (string & import("zod").BRAND<"operation">))[];
                openapi: string;
                info: {
                    title: string;
                    version: string;
                    description?: string | undefined;
                    summary?: string | undefined;
                    termsOfService?: string | undefined;
                    contact?: {
                        name?: string | undefined;
                        url?: string | undefined;
                        email?: string | undefined;
                    } | undefined;
                    license?: {
                        name?: string | null | undefined;
                        identifier?: string | undefined;
                        url?: string | undefined;
                    } | undefined;
                };
                security: Record<string, string[]>[];
                "x-scalar-icon": string;
                securitySchemes: string[];
                selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
                servers: (string & import("zod").BRAND<"server">)[];
                requests: (string & import("zod").BRAND<"operation">)[];
                tags: (string & import("zod").BRAND<"tag">)[];
                watchMode: boolean;
                useCollectionSecurity: boolean;
                watchModeStatus: "IDLE" | "WATCHING" | "ERROR";
                externalDocs?: {
                    url: string;
                    description?: string | undefined;
                } | undefined;
                jsonSchemaDialect?: string | undefined;
                components?: Record<string, unknown> | undefined;
                webhooks?: Record<string, unknown> | undefined;
                "x-scalar-active-environment"?: string | undefined;
                "x-scalar-environments"?: Record<string, {
                    variables: Record<string, string | {
                        default: string;
                        description?: string | undefined;
                    }>;
                    color?: string | undefined;
                    description?: string | undefined;
                }> | undefined;
                "x-scalar-secrets"?: Record<string, {
                    description?: string | undefined;
                    example?: string | undefined;
                }> | undefined;
                selectedServerUid?: (string & import("zod").BRAND<"server">) | undefined;
                documentUrl?: string | undefined;
                integration?: string | null | undefined;
            }[K], R> : never : K extends `${number}` ? never : never : P extends `${number}` ? never : never) => void;
            undo: (uid: string & import("zod").BRAND<"collection">) => void;
            redo: (uid: string & import("zod").BRAND<"collection">) => void;
            reset: () => void;
        };
        environmentMutators: {
            delete: (uid: import("@scalar/oas-utils/entities/environment").Environment["uid"]) => void;
            add: (item: {
                uid: string & import("zod").BRAND<"environment">;
                name: string;
                value: string;
                color: string;
                isDefault?: boolean | undefined;
            }) => void;
            set: (item: {
                uid: string & import("zod").BRAND<"environment">;
                name: string;
                value: string;
                color: string;
                isDefault?: boolean | undefined;
            }) => void;
            edit: <P extends "value" | "name" | "uid" | "color" | "isDefault">(uid: (string & import("zod").BRAND<"environment">) | null | undefined, path: P, value: P extends "value" | "name" | "uid" | "color" | "isDefault" ? {
                uid: string & import("zod").BRAND<"environment">;
                name: string;
                value: string;
                color: string;
                isDefault?: boolean | undefined;
            }[P] : P extends `${infer K}.${infer R}` ? K extends "value" | "name" | "uid" | "color" | "isDefault" ? R extends import("@scalar/object-utils/nested").Path<{
                uid: string & import("zod").BRAND<"environment">;
                name: string;
                value: string;
                color: string;
                isDefault?: boolean | undefined;
            }[K]> ? import("@scalar/object-utils/nested").PathValue<{
                uid: string & import("zod").BRAND<"environment">;
                name: string;
                value: string;
                color: string;
                isDefault?: boolean | undefined;
            }[K], R> : never : K extends `${number}` ? never : never : P extends `${number}` ? never : never) => void;
            untrackedEdit: <P extends "value" | "name" | "uid" | "color" | "isDefault">(uid: string & import("zod").BRAND<"environment">, path: P, value: P extends "value" | "name" | "uid" | "color" | "isDefault" ? {
                uid: string & import("zod").BRAND<"environment">;
                name: string;
                value: string;
                color: string;
                isDefault?: boolean | undefined;
            }[P] : P extends `${infer K}.${infer R}` ? K extends "value" | "name" | "uid" | "color" | "isDefault" ? R extends import("@scalar/object-utils/nested").Path<{
                uid: string & import("zod").BRAND<"environment">;
                name: string;
                value: string;
                color: string;
                isDefault?: boolean | undefined;
            }[K]> ? import("@scalar/object-utils/nested").PathValue<{
                uid: string & import("zod").BRAND<"environment">;
                name: string;
                value: string;
                color: string;
                isDefault?: boolean | undefined;
            }[K], R> : never : K extends `${number}` ? never : never : P extends `${number}` ? never : never) => void;
            undo: (uid: string & import("zod").BRAND<"environment">) => void;
            redo: (uid: string & import("zod").BRAND<"environment">) => void;
            reset: () => void;
        };
        requestMutators: {
            rawAdd: (item: {
                uid: string & import("zod").BRAND<"operation">;
                path: string;
                type: "request";
                selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
                selectedServerUid: (string & import("zod").BRAND<"server">) | null;
                servers: (string & import("zod").BRAND<"server">)[];
                examples: (string & import("zod").BRAND<"example">)[];
                method: "options" | "connect" | "delete" | "get" | "head" | "patch" | "post" | "put" | "trace";
                description?: string | undefined;
                summary?: string | undefined;
                externalDocs?: {
                    url: string;
                    description?: string | undefined;
                } | undefined;
                "x-internal"?: boolean | undefined;
                "x-scalar-ignore"?: boolean | undefined;
                security?: Record<string, string[]>[] | undefined;
                tags?: string[] | undefined;
                deprecated?: boolean | undefined;
                operationId?: string | undefined;
                parameters?: {
                    name: string;
                    required: boolean;
                    in: "cookie" | "path" | "query" | "header";
                    deprecated: boolean;
                    description?: string | undefined;
                    example?: unknown;
                    schema?: unknown;
                    content?: unknown;
                    style?: "matrix" | "simple" | "form" | "label" | "spaceDelimited" | "pipeDelimited" | "deepObject" | undefined;
                    examples?: unknown[] | Record<string, {
                        value?: unknown;
                        summary?: string | undefined;
                    }> | undefined;
                }[] | undefined;
                requestBody?: any;
                responses?: Record<string, any> | undefined;
                "x-codeSamples"?: {
                    source: string;
                    label?: string | undefined;
                    lang?: string | undefined;
                }[] | undefined;
                "x-code-samples"?: {
                    source: string;
                    label?: string | undefined;
                    lang?: string | undefined;
                }[] | undefined;
                "x-custom-examples"?: {
                    source: string;
                    label?: string | undefined;
                    lang?: string | undefined;
                }[] | undefined;
                "x-scalar-stability"?: import("@scalar/types").XScalarStability | undefined;
            }) => void;
            add: (payload: import("@scalar/oas-utils/entities/spec").RequestPayload, collectionUid: import("@scalar/oas-utils/entities/spec").Collection["uid"]) => void | {
                uid: string & import("zod").BRAND<"operation">;
                path: string;
                type: "request";
                selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
                selectedServerUid: (string & import("zod").BRAND<"server">) | null;
                servers: (string & import("zod").BRAND<"server">)[];
                examples: (string & import("zod").BRAND<"example">)[];
                method: "options" | "connect" | "delete" | "get" | "head" | "patch" | "post" | "put" | "trace";
                description?: string | undefined;
                summary?: string | undefined;
                externalDocs?: {
                    url: string;
                    description?: string | undefined;
                } | undefined;
                "x-internal"?: boolean | undefined;
                "x-scalar-ignore"?: boolean | undefined;
                security?: Record<string, string[]>[] | undefined;
                tags?: string[] | undefined;
                deprecated?: boolean | undefined;
                operationId?: string | undefined;
                parameters?: {
                    name: string;
                    required: boolean;
                    in: "cookie" | "path" | "query" | "header";
                    deprecated: boolean;
                    description?: string | undefined;
                    example?: unknown;
                    schema?: unknown;
                    content?: unknown;
                    style?: "matrix" | "simple" | "form" | "label" | "spaceDelimited" | "pipeDelimited" | "deepObject" | undefined;
                    examples?: unknown[] | Record<string, {
                        value?: unknown;
                        summary?: string | undefined;
                    }> | undefined;
                }[] | undefined;
                requestBody?: any;
                responses?: Record<string, any> | undefined;
                "x-codeSamples"?: {
                    source: string;
                    label?: string | undefined;
                    lang?: string | undefined;
                }[] | undefined;
                "x-code-samples"?: {
                    source: string;
                    label?: string | undefined;
                    lang?: string | undefined;
                }[] | undefined;
                "x-custom-examples"?: {
                    source: string;
                    label?: string | undefined;
                    lang?: string | undefined;
                }[] | undefined;
                "x-scalar-stability"?: import("@scalar/types").XScalarStability | undefined;
            };
            delete: (request: import("@scalar/oas-utils/entities/spec").Request, collectionUid: import("@scalar/oas-utils/entities/spec").Collection["uid"]) => void;
            set: (item: {
                uid: string & import("zod").BRAND<"operation">;
                path: string;
                type: "request";
                selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
                selectedServerUid: (string & import("zod").BRAND<"server">) | null;
                servers: (string & import("zod").BRAND<"server">)[];
                examples: (string & import("zod").BRAND<"example">)[];
                method: "options" | "connect" | "delete" | "get" | "head" | "patch" | "post" | "put" | "trace";
                description?: string | undefined;
                summary?: string | undefined;
                externalDocs?: {
                    url: string;
                    description?: string | undefined;
                } | undefined;
                "x-internal"?: boolean | undefined;
                "x-scalar-ignore"?: boolean | undefined;
                security?: Record<string, string[]>[] | undefined;
                tags?: string[] | undefined;
                deprecated?: boolean | undefined;
                operationId?: string | undefined;
                parameters?: {
                    name: string;
                    required: boolean;
                    in: "cookie" | "path" | "query" | "header";
                    deprecated: boolean;
                    description?: string | undefined;
                    example?: unknown;
                    schema?: unknown;
                    content?: unknown;
                    style?: "matrix" | "simple" | "form" | "label" | "spaceDelimited" | "pipeDelimited" | "deepObject" | undefined;
                    examples?: unknown[] | Record<string, {
                        value?: unknown;
                        summary?: string | undefined;
                    }> | undefined;
                }[] | undefined;
                requestBody?: any;
                responses?: Record<string, any> | undefined;
                "x-codeSamples"?: {
                    source: string;
                    label?: string | undefined;
                    lang?: string | undefined;
                }[] | undefined;
                "x-code-samples"?: {
                    source: string;
                    label?: string | undefined;
                    lang?: string | undefined;
                }[] | undefined;
                "x-custom-examples"?: {
                    source: string;
                    label?: string | undefined;
                    lang?: string | undefined;
                }[] | undefined;
                "x-scalar-stability"?: import("@scalar/types").XScalarStability | undefined;
            }) => void;
            edit: <P extends "servers" | "tags" | "summary" | "description" | "operationId" | "security" | "requestBody" | "parameters" | "externalDocs" | "deprecated" | "responses" | "x-internal" | "x-scalar-ignore" | "x-codeSamples" | "x-code-samples" | "x-custom-examples" | "x-scalar-stability" | "path" | "method" | "type" | "uid" | "selectedSecuritySchemeUids" | "selectedServerUid" | `servers.${number}` | `tags.${number}` | `security.${number}` | `security.${number}.${string}` | "externalDocs.url" | "externalDocs.description" | `selectedSecuritySchemeUids.${number}` | `selectedSecuritySchemeUids.${number}.${number}` | "examples" | `requestBody.${string}` | `examples.${number}` | `parameters.${number}` | `parameters.${number}.content` | `parameters.${number}.description` | `parameters.${number}.deprecated` | `parameters.${number}.example` | `parameters.${number}.name` | `parameters.${number}.in` | `parameters.${number}.style` | `parameters.${number}.examples` | `parameters.${number}.required` | `parameters.${number}.schema` | `parameters.${number}.examples.${number}` | `parameters.${number}.examples.${string}` | `responses.${string}` | `x-codeSamples.${number}` | `x-codeSamples.${number}.label` | `x-codeSamples.${number}.source` | `x-codeSamples.${number}.lang` | `x-code-samples.${number}` | `x-code-samples.${number}.label` | `x-code-samples.${number}.source` | `x-code-samples.${number}.lang` | `x-custom-examples.${number}` | `x-custom-examples.${number}.label` | `x-custom-examples.${number}.source` | `x-custom-examples.${number}.lang`>(uid: (string & import("zod").BRAND<"operation">) | null | undefined, path: P, value: P extends "servers" | "tags" | "summary" | "description" | "operationId" | "security" | "requestBody" | "parameters" | "externalDocs" | "deprecated" | "responses" | "x-internal" | "x-scalar-ignore" | "x-codeSamples" | "x-code-samples" | "x-custom-examples" | "x-scalar-stability" | "path" | "method" | "type" | "uid" | "selectedSecuritySchemeUids" | "selectedServerUid" | "examples" ? {
                uid: string & import("zod").BRAND<"operation">;
                path: string;
                type: "request";
                selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
                selectedServerUid: (string & import("zod").BRAND<"server">) | null;
                servers: (string & import("zod").BRAND<"server">)[];
                examples: (string & import("zod").BRAND<"example">)[];
                method: "options" | "connect" | "delete" | "get" | "head" | "patch" | "post" | "put" | "trace";
                description?: string | undefined;
                summary?: string | undefined;
                externalDocs?: {
                    url: string;
                    description?: string | undefined;
                } | undefined;
                "x-internal"?: boolean | undefined;
                "x-scalar-ignore"?: boolean | undefined;
                security?: Record<string, string[]>[] | undefined;
                tags?: string[] | undefined;
                deprecated?: boolean | undefined;
                operationId?: string | undefined;
                parameters?: {
                    name: string;
                    required: boolean;
                    in: "cookie" | "path" | "query" | "header";
                    deprecated: boolean;
                    description?: string | undefined;
                    example?: unknown;
                    schema?: unknown;
                    content?: unknown;
                    style?: "matrix" | "simple" | "form" | "label" | "spaceDelimited" | "pipeDelimited" | "deepObject" | undefined;
                    examples?: unknown[] | Record<string, {
                        value?: unknown;
                        summary?: string | undefined;
                    }> | undefined;
                }[] | undefined;
                requestBody?: any;
                responses?: Record<string, any> | undefined;
                "x-codeSamples"?: {
                    source: string;
                    label?: string | undefined;
                    lang?: string | undefined;
                }[] | undefined;
                "x-code-samples"?: {
                    source: string;
                    label?: string | undefined;
                    lang?: string | undefined;
                }[] | undefined;
                "x-custom-examples"?: {
                    source: string;
                    label?: string | undefined;
                    lang?: string | undefined;
                }[] | undefined;
                "x-scalar-stability"?: import("@scalar/types").XScalarStability | undefined;
            }[P] : P extends `${infer K}.${infer R}` ? K extends "servers" | "tags" | "summary" | "description" | "operationId" | "security" | "requestBody" | "parameters" | "externalDocs" | "deprecated" | "responses" | "x-internal" | "x-scalar-ignore" | "x-codeSamples" | "x-code-samples" | "x-custom-examples" | "x-scalar-stability" | "path" | "method" | "type" | "uid" | "selectedSecuritySchemeUids" | "selectedServerUid" | "examples" ? R extends import("@scalar/object-utils/nested").Path<{
                uid: string & import("zod").BRAND<"operation">;
                path: string;
                type: "request";
                selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
                selectedServerUid: (string & import("zod").BRAND<"server">) | null;
                servers: (string & import("zod").BRAND<"server">)[];
                examples: (string & import("zod").BRAND<"example">)[];
                method: "options" | "connect" | "delete" | "get" | "head" | "patch" | "post" | "put" | "trace";
                description?: string | undefined;
                summary?: string | undefined;
                externalDocs?: {
                    url: string;
                    description?: string | undefined;
                } | undefined;
                "x-internal"?: boolean | undefined;
                "x-scalar-ignore"?: boolean | undefined;
                security?: Record<string, string[]>[] | undefined;
                tags?: string[] | undefined;
                deprecated?: boolean | undefined;
                operationId?: string | undefined;
                parameters?: {
                    name: string;
                    required: boolean;
                    in: "cookie" | "path" | "query" | "header";
                    deprecated: boolean;
                    description?: string | undefined;
                    example?: unknown;
                    schema?: unknown;
                    content?: unknown;
                    style?: "matrix" | "simple" | "form" | "label" | "spaceDelimited" | "pipeDelimited" | "deepObject" | undefined;
                    examples?: unknown[] | Record<string, {
                        value?: unknown;
                        summary?: string | undefined;
                    }> | undefined;
                }[] | undefined;
                requestBody?: any;
                responses?: Record<string, any> | undefined;
                "x-codeSamples"?: {
                    source: string;
                    label?: string | undefined;
                    lang?: string | undefined;
                }[] | undefined;
                "x-code-samples"?: {
                    source: string;
                    label?: string | undefined;
                    lang?: string | undefined;
                }[] | undefined;
                "x-custom-examples"?: {
                    source: string;
                    label?: string | undefined;
                    lang?: string | undefined;
                }[] | undefined;
                "x-scalar-stability"?: import("@scalar/types").XScalarStability | undefined;
            }[K]> ? import("@scalar/object-utils/nested").PathValue<{
                uid: string & import("zod").BRAND<"operation">;
                path: string;
                type: "request";
                selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
                selectedServerUid: (string & import("zod").BRAND<"server">) | null;
                servers: (string & import("zod").BRAND<"server">)[];
                examples: (string & import("zod").BRAND<"example">)[];
                method: "options" | "connect" | "delete" | "get" | "head" | "patch" | "post" | "put" | "trace";
                description?: string | undefined;
                summary?: string | undefined;
                externalDocs?: {
                    url: string;
                    description?: string | undefined;
                } | undefined;
                "x-internal"?: boolean | undefined;
                "x-scalar-ignore"?: boolean | undefined;
                security?: Record<string, string[]>[] | undefined;
                tags?: string[] | undefined;
                deprecated?: boolean | undefined;
                operationId?: string | undefined;
                parameters?: {
                    name: string;
                    required: boolean;
                    in: "cookie" | "path" | "query" | "header";
                    deprecated: boolean;
                    description?: string | undefined;
                    example?: unknown;
                    schema?: unknown;
                    content?: unknown;
                    style?: "matrix" | "simple" | "form" | "label" | "spaceDelimited" | "pipeDelimited" | "deepObject" | undefined;
                    examples?: unknown[] | Record<string, {
                        value?: unknown;
                        summary?: string | undefined;
                    }> | undefined;
                }[] | undefined;
                requestBody?: any;
                responses?: Record<string, any> | undefined;
                "x-codeSamples"?: {
                    source: string;
                    label?: string | undefined;
                    lang?: string | undefined;
                }[] | undefined;
                "x-code-samples"?: {
                    source: string;
                    label?: string | undefined;
                    lang?: string | undefined;
                }[] | undefined;
                "x-custom-examples"?: {
                    source: string;
                    label?: string | undefined;
                    lang?: string | undefined;
                }[] | undefined;
                "x-scalar-stability"?: import("@scalar/types").XScalarStability | undefined;
            }[K], R> : never : K extends `${number}` ? never : never : P extends `${number}` ? never : never) => void;
            untrackedEdit: <P extends "servers" | "tags" | "summary" | "description" | "operationId" | "security" | "requestBody" | "parameters" | "externalDocs" | "deprecated" | "responses" | "x-internal" | "x-scalar-ignore" | "x-codeSamples" | "x-code-samples" | "x-custom-examples" | "x-scalar-stability" | "path" | "method" | "type" | "uid" | "selectedSecuritySchemeUids" | "selectedServerUid" | `servers.${number}` | `tags.${number}` | `security.${number}` | `security.${number}.${string}` | "externalDocs.url" | "externalDocs.description" | `selectedSecuritySchemeUids.${number}` | `selectedSecuritySchemeUids.${number}.${number}` | "examples" | `requestBody.${string}` | `examples.${number}` | `parameters.${number}` | `parameters.${number}.content` | `parameters.${number}.description` | `parameters.${number}.deprecated` | `parameters.${number}.example` | `parameters.${number}.name` | `parameters.${number}.in` | `parameters.${number}.style` | `parameters.${number}.examples` | `parameters.${number}.required` | `parameters.${number}.schema` | `parameters.${number}.examples.${number}` | `parameters.${number}.examples.${string}` | `responses.${string}` | `x-codeSamples.${number}` | `x-codeSamples.${number}.label` | `x-codeSamples.${number}.source` | `x-codeSamples.${number}.lang` | `x-code-samples.${number}` | `x-code-samples.${number}.label` | `x-code-samples.${number}.source` | `x-code-samples.${number}.lang` | `x-custom-examples.${number}` | `x-custom-examples.${number}.label` | `x-custom-examples.${number}.source` | `x-custom-examples.${number}.lang`>(uid: string & import("zod").BRAND<"operation">, path: P, value: P extends "servers" | "tags" | "summary" | "description" | "operationId" | "security" | "requestBody" | "parameters" | "externalDocs" | "deprecated" | "responses" | "x-internal" | "x-scalar-ignore" | "x-codeSamples" | "x-code-samples" | "x-custom-examples" | "x-scalar-stability" | "path" | "method" | "type" | "uid" | "selectedSecuritySchemeUids" | "selectedServerUid" | "examples" ? {
                uid: string & import("zod").BRAND<"operation">;
                path: string;
                type: "request";
                selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
                selectedServerUid: (string & import("zod").BRAND<"server">) | null;
                servers: (string & import("zod").BRAND<"server">)[];
                examples: (string & import("zod").BRAND<"example">)[];
                method: "options" | "connect" | "delete" | "get" | "head" | "patch" | "post" | "put" | "trace";
                description?: string | undefined;
                summary?: string | undefined;
                externalDocs?: {
                    url: string;
                    description?: string | undefined;
                } | undefined;
                "x-internal"?: boolean | undefined;
                "x-scalar-ignore"?: boolean | undefined;
                security?: Record<string, string[]>[] | undefined;
                tags?: string[] | undefined;
                deprecated?: boolean | undefined;
                operationId?: string | undefined;
                parameters?: {
                    name: string;
                    required: boolean;
                    in: "cookie" | "path" | "query" | "header";
                    deprecated: boolean;
                    description?: string | undefined;
                    example?: unknown;
                    schema?: unknown;
                    content?: unknown;
                    style?: "matrix" | "simple" | "form" | "label" | "spaceDelimited" | "pipeDelimited" | "deepObject" | undefined;
                    examples?: unknown[] | Record<string, {
                        value?: unknown;
                        summary?: string | undefined;
                    }> | undefined;
                }[] | undefined;
                requestBody?: any;
                responses?: Record<string, any> | undefined;
                "x-codeSamples"?: {
                    source: string;
                    label?: string | undefined;
                    lang?: string | undefined;
                }[] | undefined;
                "x-code-samples"?: {
                    source: string;
                    label?: string | undefined;
                    lang?: string | undefined;
                }[] | undefined;
                "x-custom-examples"?: {
                    source: string;
                    label?: string | undefined;
                    lang?: string | undefined;
                }[] | undefined;
                "x-scalar-stability"?: import("@scalar/types").XScalarStability | undefined;
            }[P] : P extends `${infer K}.${infer R}` ? K extends "servers" | "tags" | "summary" | "description" | "operationId" | "security" | "requestBody" | "parameters" | "externalDocs" | "deprecated" | "responses" | "x-internal" | "x-scalar-ignore" | "x-codeSamples" | "x-code-samples" | "x-custom-examples" | "x-scalar-stability" | "path" | "method" | "type" | "uid" | "selectedSecuritySchemeUids" | "selectedServerUid" | "examples" ? R extends import("@scalar/object-utils/nested").Path<{
                uid: string & import("zod").BRAND<"operation">;
                path: string;
                type: "request";
                selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
                selectedServerUid: (string & import("zod").BRAND<"server">) | null;
                servers: (string & import("zod").BRAND<"server">)[];
                examples: (string & import("zod").BRAND<"example">)[];
                method: "options" | "connect" | "delete" | "get" | "head" | "patch" | "post" | "put" | "trace";
                description?: string | undefined;
                summary?: string | undefined;
                externalDocs?: {
                    url: string;
                    description?: string | undefined;
                } | undefined;
                "x-internal"?: boolean | undefined;
                "x-scalar-ignore"?: boolean | undefined;
                security?: Record<string, string[]>[] | undefined;
                tags?: string[] | undefined;
                deprecated?: boolean | undefined;
                operationId?: string | undefined;
                parameters?: {
                    name: string;
                    required: boolean;
                    in: "cookie" | "path" | "query" | "header";
                    deprecated: boolean;
                    description?: string | undefined;
                    example?: unknown;
                    schema?: unknown;
                    content?: unknown;
                    style?: "matrix" | "simple" | "form" | "label" | "spaceDelimited" | "pipeDelimited" | "deepObject" | undefined;
                    examples?: unknown[] | Record<string, {
                        value?: unknown;
                        summary?: string | undefined;
                    }> | undefined;
                }[] | undefined;
                requestBody?: any;
                responses?: Record<string, any> | undefined;
                "x-codeSamples"?: {
                    source: string;
                    label?: string | undefined;
                    lang?: string | undefined;
                }[] | undefined;
                "x-code-samples"?: {
                    source: string;
                    label?: string | undefined;
                    lang?: string | undefined;
                }[] | undefined;
                "x-custom-examples"?: {
                    source: string;
                    label?: string | undefined;
                    lang?: string | undefined;
                }[] | undefined;
                "x-scalar-stability"?: import("@scalar/types").XScalarStability | undefined;
            }[K]> ? import("@scalar/object-utils/nested").PathValue<{
                uid: string & import("zod").BRAND<"operation">;
                path: string;
                type: "request";
                selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
                selectedServerUid: (string & import("zod").BRAND<"server">) | null;
                servers: (string & import("zod").BRAND<"server">)[];
                examples: (string & import("zod").BRAND<"example">)[];
                method: "options" | "connect" | "delete" | "get" | "head" | "patch" | "post" | "put" | "trace";
                description?: string | undefined;
                summary?: string | undefined;
                externalDocs?: {
                    url: string;
                    description?: string | undefined;
                } | undefined;
                "x-internal"?: boolean | undefined;
                "x-scalar-ignore"?: boolean | undefined;
                security?: Record<string, string[]>[] | undefined;
                tags?: string[] | undefined;
                deprecated?: boolean | undefined;
                operationId?: string | undefined;
                parameters?: {
                    name: string;
                    required: boolean;
                    in: "cookie" | "path" | "query" | "header";
                    deprecated: boolean;
                    description?: string | undefined;
                    example?: unknown;
                    schema?: unknown;
                    content?: unknown;
                    style?: "matrix" | "simple" | "form" | "label" | "spaceDelimited" | "pipeDelimited" | "deepObject" | undefined;
                    examples?: unknown[] | Record<string, {
                        value?: unknown;
                        summary?: string | undefined;
                    }> | undefined;
                }[] | undefined;
                requestBody?: any;
                responses?: Record<string, any> | undefined;
                "x-codeSamples"?: {
                    source: string;
                    label?: string | undefined;
                    lang?: string | undefined;
                }[] | undefined;
                "x-code-samples"?: {
                    source: string;
                    label?: string | undefined;
                    lang?: string | undefined;
                }[] | undefined;
                "x-custom-examples"?: {
                    source: string;
                    label?: string | undefined;
                    lang?: string | undefined;
                }[] | undefined;
                "x-scalar-stability"?: import("@scalar/types").XScalarStability | undefined;
            }[K], R> : never : K extends `${number}` ? never : never : P extends `${number}` ? never : never) => void;
            undo: (uid: string & import("zod").BRAND<"operation">) => void;
            redo: (uid: string & import("zod").BRAND<"operation">) => void;
            reset: () => void;
        };
        findRequestParents: (r: import("@scalar/oas-utils/entities/spec").Request) => string[];
        securitySchemeMutators: {
            rawAdd: (item: {
                name: string;
                type: "apiKey";
                value: string;
                uid: string & import("zod").BRAND<"securityScheme">;
                nameKey: string;
                in: "cookie" | "query" | "header";
                description?: string | undefined;
            } | {
                type: "http";
                uid: string & import("zod").BRAND<"securityScheme">;
                nameKey: string;
                scheme: "basic" | "bearer";
                bearerFormat: string;
                username: string;
                password: string;
                token: string;
                description?: string | undefined;
            } | {
                type: "openIdConnect";
                uid: string & import("zod").BRAND<"securityScheme">;
                nameKey: string;
                openIdConnectUrl: string;
                description?: string | undefined;
            } | {
                type: "oauth2";
                uid: string & import("zod").BRAND<"securityScheme">;
                nameKey: string;
                flows: {
                    password?: {
                        type: "password";
                        username: string;
                        password: string;
                        token: string;
                        refreshUrl: string;
                        scopes: Record<string, string>;
                        selectedScopes: string[];
                        "x-scalar-client-id": string;
                        tokenUrl: string;
                        clientSecret: string;
                    } | undefined;
                    implicit?: {
                        type: "implicit";
                        token: string;
                        refreshUrl: string;
                        scopes: Record<string, string>;
                        selectedScopes: string[];
                        "x-scalar-client-id": string;
                        authorizationUrl: string;
                        "x-scalar-redirect-uri": string;
                    } | undefined;
                    clientCredentials?: {
                        type: "clientCredentials";
                        token: string;
                        refreshUrl: string;
                        scopes: Record<string, string>;
                        selectedScopes: string[];
                        "x-scalar-client-id": string;
                        tokenUrl: string;
                        clientSecret: string;
                    } | undefined;
                    authorizationCode?: {
                        type: "authorizationCode";
                        token: string;
                        refreshUrl: string;
                        scopes: Record<string, string>;
                        selectedScopes: string[];
                        "x-scalar-client-id": string;
                        authorizationUrl: string;
                        "x-scalar-redirect-uri": string;
                        tokenUrl: string;
                        clientSecret: string;
                        "x-usePkce": "SHA-256" | "plain" | "no";
                    } | undefined;
                };
                description?: string | undefined;
                "x-default-scopes"?: string | string[] | undefined;
            }) => void;
            add: (payload: import("@scalar/types/entities").SecuritySchemePayload, collectionUid: import("@scalar/oas-utils/entities/spec").Collection["uid"]) => {
                name: string;
                type: "apiKey";
                value: string;
                uid: string & import("zod").BRAND<"securityScheme">;
                nameKey: string;
                in: "cookie" | "query" | "header";
                description?: string | undefined;
            } | {
                type: "http";
                uid: string & import("zod").BRAND<"securityScheme">;
                nameKey: string;
                scheme: "basic" | "bearer";
                bearerFormat: string;
                username: string;
                password: string;
                token: string;
                description?: string | undefined;
            } | {
                type: "openIdConnect";
                uid: string & import("zod").BRAND<"securityScheme">;
                nameKey: string;
                openIdConnectUrl: string;
                description?: string | undefined;
            } | {
                type: "oauth2";
                uid: string & import("zod").BRAND<"securityScheme">;
                nameKey: string;
                flows: {
                    password?: {
                        type: "password";
                        username: string;
                        password: string;
                        token: string;
                        refreshUrl: string;
                        scopes: Record<string, string>;
                        selectedScopes: string[];
                        "x-scalar-client-id": string;
                        tokenUrl: string;
                        clientSecret: string;
                    } | undefined;
                    implicit?: {
                        type: "implicit";
                        token: string;
                        refreshUrl: string;
                        scopes: Record<string, string>;
                        selectedScopes: string[];
                        "x-scalar-client-id": string;
                        authorizationUrl: string;
                        "x-scalar-redirect-uri": string;
                    } | undefined;
                    clientCredentials?: {
                        type: "clientCredentials";
                        token: string;
                        refreshUrl: string;
                        scopes: Record<string, string>;
                        selectedScopes: string[];
                        "x-scalar-client-id": string;
                        tokenUrl: string;
                        clientSecret: string;
                    } | undefined;
                    authorizationCode?: {
                        type: "authorizationCode";
                        token: string;
                        refreshUrl: string;
                        scopes: Record<string, string>;
                        selectedScopes: string[];
                        "x-scalar-client-id": string;
                        authorizationUrl: string;
                        "x-scalar-redirect-uri": string;
                        tokenUrl: string;
                        clientSecret: string;
                        "x-usePkce": "SHA-256" | "plain" | "no";
                    } | undefined;
                };
                description?: string | undefined;
                "x-default-scopes"?: string | string[] | undefined;
            };
            delete: (schemeUid: import("@scalar/types/entities").SecurityScheme["uid"]) => void;
            set: (item: {
                name: string;
                type: "apiKey";
                value: string;
                uid: string & import("zod").BRAND<"securityScheme">;
                nameKey: string;
                in: "cookie" | "query" | "header";
                description?: string | undefined;
            } | {
                type: "http";
                uid: string & import("zod").BRAND<"securityScheme">;
                nameKey: string;
                scheme: "basic" | "bearer";
                bearerFormat: string;
                username: string;
                password: string;
                token: string;
                description?: string | undefined;
            } | {
                type: "openIdConnect";
                uid: string & import("zod").BRAND<"securityScheme">;
                nameKey: string;
                openIdConnectUrl: string;
                description?: string | undefined;
            } | {
                type: "oauth2";
                uid: string & import("zod").BRAND<"securityScheme">;
                nameKey: string;
                flows: {
                    password?: {
                        type: "password";
                        username: string;
                        password: string;
                        token: string;
                        refreshUrl: string;
                        scopes: Record<string, string>;
                        selectedScopes: string[];
                        "x-scalar-client-id": string;
                        tokenUrl: string;
                        clientSecret: string;
                    } | undefined;
                    implicit?: {
                        type: "implicit";
                        token: string;
                        refreshUrl: string;
                        scopes: Record<string, string>;
                        selectedScopes: string[];
                        "x-scalar-client-id": string;
                        authorizationUrl: string;
                        "x-scalar-redirect-uri": string;
                    } | undefined;
                    clientCredentials?: {
                        type: "clientCredentials";
                        token: string;
                        refreshUrl: string;
                        scopes: Record<string, string>;
                        selectedScopes: string[];
                        "x-scalar-client-id": string;
                        tokenUrl: string;
                        clientSecret: string;
                    } | undefined;
                    authorizationCode?: {
                        type: "authorizationCode";
                        token: string;
                        refreshUrl: string;
                        scopes: Record<string, string>;
                        selectedScopes: string[];
                        "x-scalar-client-id": string;
                        authorizationUrl: string;
                        "x-scalar-redirect-uri": string;
                        tokenUrl: string;
                        clientSecret: string;
                        "x-usePkce": "SHA-256" | "plain" | "no";
                    } | undefined;
                };
                description?: string | undefined;
                "x-default-scopes"?: string | string[] | undefined;
            }) => void;
            edit: <P extends "value" | "description" | "type" | "name" | "in" | "uid" | "nameKey" | "scheme" | "bearerFormat" | "openIdConnectUrl" | "x-default-scopes" | "flows" | "password" | "username" | "token" | `x-default-scopes.${number}` | "flows.password" | "flows.implicit" | "flows.clientCredentials" | "flows.authorizationCode" | "flows.password.type" | "flows.password.password" | "flows.password.username" | "flows.password.token" | "flows.password.refreshUrl" | "flows.password.scopes" | "flows.password.selectedScopes" | "flows.password.x-scalar-client-id" | "flows.password.tokenUrl" | "flows.password.clientSecret" | `flows.password.scopes.${string}` | `flows.password.selectedScopes.${number}` | "flows.implicit.type" | "flows.implicit.token" | "flows.implicit.refreshUrl" | "flows.implicit.scopes" | "flows.implicit.selectedScopes" | "flows.implicit.x-scalar-client-id" | `flows.implicit.scopes.${string}` | `flows.implicit.selectedScopes.${number}` | "flows.implicit.authorizationUrl" | "flows.implicit.x-scalar-redirect-uri" | "flows.clientCredentials.type" | "flows.clientCredentials.token" | "flows.clientCredentials.refreshUrl" | "flows.clientCredentials.scopes" | "flows.clientCredentials.selectedScopes" | "flows.clientCredentials.x-scalar-client-id" | "flows.clientCredentials.tokenUrl" | "flows.clientCredentials.clientSecret" | `flows.clientCredentials.scopes.${string}` | `flows.clientCredentials.selectedScopes.${number}` | "flows.authorizationCode.type" | "flows.authorizationCode.token" | "flows.authorizationCode.refreshUrl" | "flows.authorizationCode.scopes" | "flows.authorizationCode.selectedScopes" | "flows.authorizationCode.x-scalar-client-id" | "flows.authorizationCode.tokenUrl" | "flows.authorizationCode.clientSecret" | `flows.authorizationCode.scopes.${string}` | `flows.authorizationCode.selectedScopes.${number}` | "flows.authorizationCode.authorizationUrl" | "flows.authorizationCode.x-scalar-redirect-uri" | "flows.authorizationCode.x-usePkce">(uid: (string & import("zod").BRAND<"securityScheme">) | null | undefined, path: P, value: (P extends "value" | "description" | "type" | "name" | "in" | "uid" | "nameKey" ? {
                name: string;
                type: "apiKey";
                value: string;
                uid: string & import("zod").BRAND<"securityScheme">;
                nameKey: string;
                in: "cookie" | "query" | "header";
                description?: string | undefined;
            }[P] : P extends `${infer K}.${infer R}` ? K extends "value" | "description" | "type" | "name" | "in" | "uid" | "nameKey" ? R extends import("@scalar/object-utils/nested").Path<{
                name: string;
                type: "apiKey";
                value: string;
                uid: string & import("zod").BRAND<"securityScheme">;
                nameKey: string;
                in: "cookie" | "query" | "header";
                description?: string | undefined;
            }[K]> ? import("@scalar/object-utils/nested").PathValue<{
                name: string;
                type: "apiKey";
                value: string;
                uid: string & import("zod").BRAND<"securityScheme">;
                nameKey: string;
                in: "cookie" | "query" | "header";
                description?: string | undefined;
            }[K], R> : never : K extends `${number}` ? never : never : P extends `${number}` ? never : never) | (P extends "description" | "type" | "uid" | "nameKey" | "scheme" | "bearerFormat" | "password" | "username" | "token" ? {
                type: "http";
                uid: string & import("zod").BRAND<"securityScheme">;
                nameKey: string;
                scheme: "basic" | "bearer";
                bearerFormat: string;
                username: string;
                password: string;
                token: string;
                description?: string | undefined;
            }[P] : P extends `${infer K}.${infer R_1}` ? K extends "description" | "type" | "uid" | "nameKey" | "scheme" | "bearerFormat" | "password" | "username" | "token" ? R_1 extends import("@scalar/object-utils/nested").Path<{
                type: "http";
                uid: string & import("zod").BRAND<"securityScheme">;
                nameKey: string;
                scheme: "basic" | "bearer";
                bearerFormat: string;
                username: string;
                password: string;
                token: string;
                description?: string | undefined;
            }[K]> ? import("@scalar/object-utils/nested").PathValue<{
                type: "http";
                uid: string & import("zod").BRAND<"securityScheme">;
                nameKey: string;
                scheme: "basic" | "bearer";
                bearerFormat: string;
                username: string;
                password: string;
                token: string;
                description?: string | undefined;
            }[K], R_1> : never : K extends `${number}` ? never : never : P extends `${number}` ? never : never) | (P extends "description" | "type" | "uid" | "nameKey" | "openIdConnectUrl" ? {
                type: "openIdConnect";
                uid: string & import("zod").BRAND<"securityScheme">;
                nameKey: string;
                openIdConnectUrl: string;
                description?: string | undefined;
            }[P] : P extends `${infer K}.${infer R_2}` ? K extends "description" | "type" | "uid" | "nameKey" | "openIdConnectUrl" ? R_2 extends import("@scalar/object-utils/nested").Path<{
                type: "openIdConnect";
                uid: string & import("zod").BRAND<"securityScheme">;
                nameKey: string;
                openIdConnectUrl: string;
                description?: string | undefined;
            }[K]> ? import("@scalar/object-utils/nested").PathValue<{
                type: "openIdConnect";
                uid: string & import("zod").BRAND<"securityScheme">;
                nameKey: string;
                openIdConnectUrl: string;
                description?: string | undefined;
            }[K], R_2> : never : K extends `${number}` ? never : never : P extends `${number}` ? never : never) | (P extends "description" | "type" | "uid" | "nameKey" | "x-default-scopes" | "flows" ? {
                type: "oauth2";
                uid: string & import("zod").BRAND<"securityScheme">;
                nameKey: string;
                flows: {
                    password?: {
                        type: "password";
                        username: string;
                        password: string;
                        token: string;
                        refreshUrl: string;
                        scopes: Record<string, string>;
                        selectedScopes: string[];
                        "x-scalar-client-id": string;
                        tokenUrl: string;
                        clientSecret: string;
                    } | undefined;
                    implicit?: {
                        type: "implicit";
                        token: string;
                        refreshUrl: string;
                        scopes: Record<string, string>;
                        selectedScopes: string[];
                        "x-scalar-client-id": string;
                        authorizationUrl: string;
                        "x-scalar-redirect-uri": string;
                    } | undefined;
                    clientCredentials?: {
                        type: "clientCredentials";
                        token: string;
                        refreshUrl: string;
                        scopes: Record<string, string>;
                        selectedScopes: string[];
                        "x-scalar-client-id": string;
                        tokenUrl: string;
                        clientSecret: string;
                    } | undefined;
                    authorizationCode?: {
                        type: "authorizationCode";
                        token: string;
                        refreshUrl: string;
                        scopes: Record<string, string>;
                        selectedScopes: string[];
                        "x-scalar-client-id": string;
                        authorizationUrl: string;
                        "x-scalar-redirect-uri": string;
                        tokenUrl: string;
                        clientSecret: string;
                        "x-usePkce": "SHA-256" | "plain" | "no";
                    } | undefined;
                };
                description?: string | undefined;
                "x-default-scopes"?: string | string[] | undefined;
            }[P] : P extends `${infer K}.${infer R_3}` ? K extends "description" | "type" | "uid" | "nameKey" | "x-default-scopes" | "flows" ? R_3 extends import("@scalar/object-utils/nested").Path<{
                type: "oauth2";
                uid: string & import("zod").BRAND<"securityScheme">;
                nameKey: string;
                flows: {
                    password?: {
                        type: "password";
                        username: string;
                        password: string;
                        token: string;
                        refreshUrl: string;
                        scopes: Record<string, string>;
                        selectedScopes: string[];
                        "x-scalar-client-id": string;
                        tokenUrl: string;
                        clientSecret: string;
                    } | undefined;
                    implicit?: {
                        type: "implicit";
                        token: string;
                        refreshUrl: string;
                        scopes: Record<string, string>;
                        selectedScopes: string[];
                        "x-scalar-client-id": string;
                        authorizationUrl: string;
                        "x-scalar-redirect-uri": string;
                    } | undefined;
                    clientCredentials?: {
                        type: "clientCredentials";
                        token: string;
                        refreshUrl: string;
                        scopes: Record<string, string>;
                        selectedScopes: string[];
                        "x-scalar-client-id": string;
                        tokenUrl: string;
                        clientSecret: string;
                    } | undefined;
                    authorizationCode?: {
                        type: "authorizationCode";
                        token: string;
                        refreshUrl: string;
                        scopes: Record<string, string>;
                        selectedScopes: string[];
                        "x-scalar-client-id": string;
                        authorizationUrl: string;
                        "x-scalar-redirect-uri": string;
                        tokenUrl: string;
                        clientSecret: string;
                        "x-usePkce": "SHA-256" | "plain" | "no";
                    } | undefined;
                };
                description?: string | undefined;
                "x-default-scopes"?: string | string[] | undefined;
            }[K]> ? import("@scalar/object-utils/nested").PathValue<{
                type: "oauth2";
                uid: string & import("zod").BRAND<"securityScheme">;
                nameKey: string;
                flows: {
                    password?: {
                        type: "password";
                        username: string;
                        password: string;
                        token: string;
                        refreshUrl: string;
                        scopes: Record<string, string>;
                        selectedScopes: string[];
                        "x-scalar-client-id": string;
                        tokenUrl: string;
                        clientSecret: string;
                    } | undefined;
                    implicit?: {
                        type: "implicit";
                        token: string;
                        refreshUrl: string;
                        scopes: Record<string, string>;
                        selectedScopes: string[];
                        "x-scalar-client-id": string;
                        authorizationUrl: string;
                        "x-scalar-redirect-uri": string;
                    } | undefined;
                    clientCredentials?: {
                        type: "clientCredentials";
                        token: string;
                        refreshUrl: string;
                        scopes: Record<string, string>;
                        selectedScopes: string[];
                        "x-scalar-client-id": string;
                        tokenUrl: string;
                        clientSecret: string;
                    } | undefined;
                    authorizationCode?: {
                        type: "authorizationCode";
                        token: string;
                        refreshUrl: string;
                        scopes: Record<string, string>;
                        selectedScopes: string[];
                        "x-scalar-client-id": string;
                        authorizationUrl: string;
                        "x-scalar-redirect-uri": string;
                        tokenUrl: string;
                        clientSecret: string;
                        "x-usePkce": "SHA-256" | "plain" | "no";
                    } | undefined;
                };
                description?: string | undefined;
                "x-default-scopes"?: string | string[] | undefined;
            }[K], R_3> : never : K extends `${number}` ? never : never : P extends `${number}` ? never : never)) => void;
            untrackedEdit: <P extends "value" | "description" | "type" | "name" | "in" | "uid" | "nameKey" | "scheme" | "bearerFormat" | "openIdConnectUrl" | "x-default-scopes" | "flows" | "password" | "username" | "token" | `x-default-scopes.${number}` | "flows.password" | "flows.implicit" | "flows.clientCredentials" | "flows.authorizationCode" | "flows.password.type" | "flows.password.password" | "flows.password.username" | "flows.password.token" | "flows.password.refreshUrl" | "flows.password.scopes" | "flows.password.selectedScopes" | "flows.password.x-scalar-client-id" | "flows.password.tokenUrl" | "flows.password.clientSecret" | `flows.password.scopes.${string}` | `flows.password.selectedScopes.${number}` | "flows.implicit.type" | "flows.implicit.token" | "flows.implicit.refreshUrl" | "flows.implicit.scopes" | "flows.implicit.selectedScopes" | "flows.implicit.x-scalar-client-id" | `flows.implicit.scopes.${string}` | `flows.implicit.selectedScopes.${number}` | "flows.implicit.authorizationUrl" | "flows.implicit.x-scalar-redirect-uri" | "flows.clientCredentials.type" | "flows.clientCredentials.token" | "flows.clientCredentials.refreshUrl" | "flows.clientCredentials.scopes" | "flows.clientCredentials.selectedScopes" | "flows.clientCredentials.x-scalar-client-id" | "flows.clientCredentials.tokenUrl" | "flows.clientCredentials.clientSecret" | `flows.clientCredentials.scopes.${string}` | `flows.clientCredentials.selectedScopes.${number}` | "flows.authorizationCode.type" | "flows.authorizationCode.token" | "flows.authorizationCode.refreshUrl" | "flows.authorizationCode.scopes" | "flows.authorizationCode.selectedScopes" | "flows.authorizationCode.x-scalar-client-id" | "flows.authorizationCode.tokenUrl" | "flows.authorizationCode.clientSecret" | `flows.authorizationCode.scopes.${string}` | `flows.authorizationCode.selectedScopes.${number}` | "flows.authorizationCode.authorizationUrl" | "flows.authorizationCode.x-scalar-redirect-uri" | "flows.authorizationCode.x-usePkce">(uid: string & import("zod").BRAND<"securityScheme">, path: P, value: (P extends "value" | "description" | "type" | "name" | "in" | "uid" | "nameKey" ? {
                name: string;
                type: "apiKey";
                value: string;
                uid: string & import("zod").BRAND<"securityScheme">;
                nameKey: string;
                in: "cookie" | "query" | "header";
                description?: string | undefined;
            }[P] : P extends `${infer K}.${infer R}` ? K extends "value" | "description" | "type" | "name" | "in" | "uid" | "nameKey" ? R extends import("@scalar/object-utils/nested").Path<{
                name: string;
                type: "apiKey";
                value: string;
                uid: string & import("zod").BRAND<"securityScheme">;
                nameKey: string;
                in: "cookie" | "query" | "header";
                description?: string | undefined;
            }[K]> ? import("@scalar/object-utils/nested").PathValue<{
                name: string;
                type: "apiKey";
                value: string;
                uid: string & import("zod").BRAND<"securityScheme">;
                nameKey: string;
                in: "cookie" | "query" | "header";
                description?: string | undefined;
            }[K], R> : never : K extends `${number}` ? never : never : P extends `${number}` ? never : never) | (P extends "description" | "type" | "uid" | "nameKey" | "scheme" | "bearerFormat" | "password" | "username" | "token" ? {
                type: "http";
                uid: string & import("zod").BRAND<"securityScheme">;
                nameKey: string;
                scheme: "basic" | "bearer";
                bearerFormat: string;
                username: string;
                password: string;
                token: string;
                description?: string | undefined;
            }[P] : P extends `${infer K}.${infer R_1}` ? K extends "description" | "type" | "uid" | "nameKey" | "scheme" | "bearerFormat" | "password" | "username" | "token" ? R_1 extends import("@scalar/object-utils/nested").Path<{
                type: "http";
                uid: string & import("zod").BRAND<"securityScheme">;
                nameKey: string;
                scheme: "basic" | "bearer";
                bearerFormat: string;
                username: string;
                password: string;
                token: string;
                description?: string | undefined;
            }[K]> ? import("@scalar/object-utils/nested").PathValue<{
                type: "http";
                uid: string & import("zod").BRAND<"securityScheme">;
                nameKey: string;
                scheme: "basic" | "bearer";
                bearerFormat: string;
                username: string;
                password: string;
                token: string;
                description?: string | undefined;
            }[K], R_1> : never : K extends `${number}` ? never : never : P extends `${number}` ? never : never) | (P extends "description" | "type" | "uid" | "nameKey" | "openIdConnectUrl" ? {
                type: "openIdConnect";
                uid: string & import("zod").BRAND<"securityScheme">;
                nameKey: string;
                openIdConnectUrl: string;
                description?: string | undefined;
            }[P] : P extends `${infer K}.${infer R_2}` ? K extends "description" | "type" | "uid" | "nameKey" | "openIdConnectUrl" ? R_2 extends import("@scalar/object-utils/nested").Path<{
                type: "openIdConnect";
                uid: string & import("zod").BRAND<"securityScheme">;
                nameKey: string;
                openIdConnectUrl: string;
                description?: string | undefined;
            }[K]> ? import("@scalar/object-utils/nested").PathValue<{
                type: "openIdConnect";
                uid: string & import("zod").BRAND<"securityScheme">;
                nameKey: string;
                openIdConnectUrl: string;
                description?: string | undefined;
            }[K], R_2> : never : K extends `${number}` ? never : never : P extends `${number}` ? never : never) | (P extends "description" | "type" | "uid" | "nameKey" | "x-default-scopes" | "flows" ? {
                type: "oauth2";
                uid: string & import("zod").BRAND<"securityScheme">;
                nameKey: string;
                flows: {
                    password?: {
                        type: "password";
                        username: string;
                        password: string;
                        token: string;
                        refreshUrl: string;
                        scopes: Record<string, string>;
                        selectedScopes: string[];
                        "x-scalar-client-id": string;
                        tokenUrl: string;
                        clientSecret: string;
                    } | undefined;
                    implicit?: {
                        type: "implicit";
                        token: string;
                        refreshUrl: string;
                        scopes: Record<string, string>;
                        selectedScopes: string[];
                        "x-scalar-client-id": string;
                        authorizationUrl: string;
                        "x-scalar-redirect-uri": string;
                    } | undefined;
                    clientCredentials?: {
                        type: "clientCredentials";
                        token: string;
                        refreshUrl: string;
                        scopes: Record<string, string>;
                        selectedScopes: string[];
                        "x-scalar-client-id": string;
                        tokenUrl: string;
                        clientSecret: string;
                    } | undefined;
                    authorizationCode?: {
                        type: "authorizationCode";
                        token: string;
                        refreshUrl: string;
                        scopes: Record<string, string>;
                        selectedScopes: string[];
                        "x-scalar-client-id": string;
                        authorizationUrl: string;
                        "x-scalar-redirect-uri": string;
                        tokenUrl: string;
                        clientSecret: string;
                        "x-usePkce": "SHA-256" | "plain" | "no";
                    } | undefined;
                };
                description?: string | undefined;
                "x-default-scopes"?: string | string[] | undefined;
            }[P] : P extends `${infer K}.${infer R_3}` ? K extends "description" | "type" | "uid" | "nameKey" | "x-default-scopes" | "flows" ? R_3 extends import("@scalar/object-utils/nested").Path<{
                type: "oauth2";
                uid: string & import("zod").BRAND<"securityScheme">;
                nameKey: string;
                flows: {
                    password?: {
                        type: "password";
                        username: string;
                        password: string;
                        token: string;
                        refreshUrl: string;
                        scopes: Record<string, string>;
                        selectedScopes: string[];
                        "x-scalar-client-id": string;
                        tokenUrl: string;
                        clientSecret: string;
                    } | undefined;
                    implicit?: {
                        type: "implicit";
                        token: string;
                        refreshUrl: string;
                        scopes: Record<string, string>;
                        selectedScopes: string[];
                        "x-scalar-client-id": string;
                        authorizationUrl: string;
                        "x-scalar-redirect-uri": string;
                    } | undefined;
                    clientCredentials?: {
                        type: "clientCredentials";
                        token: string;
                        refreshUrl: string;
                        scopes: Record<string, string>;
                        selectedScopes: string[];
                        "x-scalar-client-id": string;
                        tokenUrl: string;
                        clientSecret: string;
                    } | undefined;
                    authorizationCode?: {
                        type: "authorizationCode";
                        token: string;
                        refreshUrl: string;
                        scopes: Record<string, string>;
                        selectedScopes: string[];
                        "x-scalar-client-id": string;
                        authorizationUrl: string;
                        "x-scalar-redirect-uri": string;
                        tokenUrl: string;
                        clientSecret: string;
                        "x-usePkce": "SHA-256" | "plain" | "no";
                    } | undefined;
                };
                description?: string | undefined;
                "x-default-scopes"?: string | string[] | undefined;
            }[K]> ? import("@scalar/object-utils/nested").PathValue<{
                type: "oauth2";
                uid: string & import("zod").BRAND<"securityScheme">;
                nameKey: string;
                flows: {
                    password?: {
                        type: "password";
                        username: string;
                        password: string;
                        token: string;
                        refreshUrl: string;
                        scopes: Record<string, string>;
                        selectedScopes: string[];
                        "x-scalar-client-id": string;
                        tokenUrl: string;
                        clientSecret: string;
                    } | undefined;
                    implicit?: {
                        type: "implicit";
                        token: string;
                        refreshUrl: string;
                        scopes: Record<string, string>;
                        selectedScopes: string[];
                        "x-scalar-client-id": string;
                        authorizationUrl: string;
                        "x-scalar-redirect-uri": string;
                    } | undefined;
                    clientCredentials?: {
                        type: "clientCredentials";
                        token: string;
                        refreshUrl: string;
                        scopes: Record<string, string>;
                        selectedScopes: string[];
                        "x-scalar-client-id": string;
                        tokenUrl: string;
                        clientSecret: string;
                    } | undefined;
                    authorizationCode?: {
                        type: "authorizationCode";
                        token: string;
                        refreshUrl: string;
                        scopes: Record<string, string>;
                        selectedScopes: string[];
                        "x-scalar-client-id": string;
                        authorizationUrl: string;
                        "x-scalar-redirect-uri": string;
                        tokenUrl: string;
                        clientSecret: string;
                        "x-usePkce": "SHA-256" | "plain" | "no";
                    } | undefined;
                };
                description?: string | undefined;
                "x-default-scopes"?: string | string[] | undefined;
            }[K], R_3> : never : K extends `${number}` ? never : never : P extends `${number}` ? never : never)) => void;
            undo: (uid: string & import("zod").BRAND<"securityScheme">) => void;
            redo: (uid: string & import("zod").BRAND<"securityScheme">) => void;
            reset: () => void;
        };
        tagMutators: {
            rawAdd: (item: {
                uid: string & import("zod").BRAND<"tag">;
                name: string;
                type: "tag";
                children: ((string & import("zod").BRAND<"tag">) | (string & import("zod").BRAND<"operation">))[];
                description?: string | undefined;
                externalDocs?: {
                    url: string;
                    description?: string | undefined;
                } | undefined;
                "x-scalar-children"?: {
                    tagName: string;
                }[] | undefined;
                "x-internal"?: boolean | undefined;
                "x-scalar-ignore"?: boolean | undefined;
            }) => void;
            add: (payload: import("@scalar/oas-utils/entities/spec").TagPayload, collectionUid: import("@scalar/oas-utils/entities/spec").Collection["uid"]) => void | {
                uid: string & import("zod").BRAND<"tag">;
                name: string;
                type: "tag";
                children: ((string & import("zod").BRAND<"tag">) | (string & import("zod").BRAND<"operation">))[];
                description?: string | undefined;
                externalDocs?: {
                    url: string;
                    description?: string | undefined;
                } | undefined;
                "x-scalar-children"?: {
                    tagName: string;
                }[] | undefined;
                "x-internal"?: boolean | undefined;
                "x-scalar-ignore"?: boolean | undefined;
            };
            delete: (tag: import("@scalar/oas-utils/entities/spec").Tag, collectionUid: import("@scalar/oas-utils/entities/spec").Collection["uid"]) => void;
            set: (item: {
                uid: string & import("zod").BRAND<"tag">;
                name: string;
                type: "tag";
                children: ((string & import("zod").BRAND<"tag">) | (string & import("zod").BRAND<"operation">))[];
                description?: string | undefined;
                externalDocs?: {
                    url: string;
                    description?: string | undefined;
                } | undefined;
                "x-scalar-children"?: {
                    tagName: string;
                }[] | undefined;
                "x-internal"?: boolean | undefined;
                "x-scalar-ignore"?: boolean | undefined;
            }) => void;
            edit: <P extends "description" | "externalDocs" | "x-internal" | "x-scalar-ignore" | "type" | "name" | "uid" | "children" | "externalDocs.url" | "externalDocs.description" | `children.${number}` | "x-scalar-children" | `x-scalar-children.${number}` | `x-scalar-children.${number}.tagName`>(uid: (string & import("zod").BRAND<"tag">) | null | undefined, path: P, value: P extends "description" | "externalDocs" | "x-internal" | "x-scalar-ignore" | "type" | "name" | "uid" | "children" | "x-scalar-children" ? {
                uid: string & import("zod").BRAND<"tag">;
                name: string;
                type: "tag";
                children: ((string & import("zod").BRAND<"tag">) | (string & import("zod").BRAND<"operation">))[];
                description?: string | undefined;
                externalDocs?: {
                    url: string;
                    description?: string | undefined;
                } | undefined;
                "x-scalar-children"?: {
                    tagName: string;
                }[] | undefined;
                "x-internal"?: boolean | undefined;
                "x-scalar-ignore"?: boolean | undefined;
            }[P] : P extends `${infer K}.${infer R}` ? K extends "description" | "externalDocs" | "x-internal" | "x-scalar-ignore" | "type" | "name" | "uid" | "children" | "x-scalar-children" ? R extends import("@scalar/object-utils/nested").Path<{
                uid: string & import("zod").BRAND<"tag">;
                name: string;
                type: "tag";
                children: ((string & import("zod").BRAND<"tag">) | (string & import("zod").BRAND<"operation">))[];
                description?: string | undefined;
                externalDocs?: {
                    url: string;
                    description?: string | undefined;
                } | undefined;
                "x-scalar-children"?: {
                    tagName: string;
                }[] | undefined;
                "x-internal"?: boolean | undefined;
                "x-scalar-ignore"?: boolean | undefined;
            }[K]> ? import("@scalar/object-utils/nested").PathValue<{
                uid: string & import("zod").BRAND<"tag">;
                name: string;
                type: "tag";
                children: ((string & import("zod").BRAND<"tag">) | (string & import("zod").BRAND<"operation">))[];
                description?: string | undefined;
                externalDocs?: {
                    url: string;
                    description?: string | undefined;
                } | undefined;
                "x-scalar-children"?: {
                    tagName: string;
                }[] | undefined;
                "x-internal"?: boolean | undefined;
                "x-scalar-ignore"?: boolean | undefined;
            }[K], R> : never : K extends `${number}` ? never : never : P extends `${number}` ? never : never) => void;
            untrackedEdit: <P extends "description" | "externalDocs" | "x-internal" | "x-scalar-ignore" | "type" | "name" | "uid" | "children" | "externalDocs.url" | "externalDocs.description" | `children.${number}` | "x-scalar-children" | `x-scalar-children.${number}` | `x-scalar-children.${number}.tagName`>(uid: string & import("zod").BRAND<"tag">, path: P, value: P extends "description" | "externalDocs" | "x-internal" | "x-scalar-ignore" | "type" | "name" | "uid" | "children" | "x-scalar-children" ? {
                uid: string & import("zod").BRAND<"tag">;
                name: string;
                type: "tag";
                children: ((string & import("zod").BRAND<"tag">) | (string & import("zod").BRAND<"operation">))[];
                description?: string | undefined;
                externalDocs?: {
                    url: string;
                    description?: string | undefined;
                } | undefined;
                "x-scalar-children"?: {
                    tagName: string;
                }[] | undefined;
                "x-internal"?: boolean | undefined;
                "x-scalar-ignore"?: boolean | undefined;
            }[P] : P extends `${infer K}.${infer R}` ? K extends "description" | "externalDocs" | "x-internal" | "x-scalar-ignore" | "type" | "name" | "uid" | "children" | "x-scalar-children" ? R extends import("@scalar/object-utils/nested").Path<{
                uid: string & import("zod").BRAND<"tag">;
                name: string;
                type: "tag";
                children: ((string & import("zod").BRAND<"tag">) | (string & import("zod").BRAND<"operation">))[];
                description?: string | undefined;
                externalDocs?: {
                    url: string;
                    description?: string | undefined;
                } | undefined;
                "x-scalar-children"?: {
                    tagName: string;
                }[] | undefined;
                "x-internal"?: boolean | undefined;
                "x-scalar-ignore"?: boolean | undefined;
            }[K]> ? import("@scalar/object-utils/nested").PathValue<{
                uid: string & import("zod").BRAND<"tag">;
                name: string;
                type: "tag";
                children: ((string & import("zod").BRAND<"tag">) | (string & import("zod").BRAND<"operation">))[];
                description?: string | undefined;
                externalDocs?: {
                    url: string;
                    description?: string | undefined;
                } | undefined;
                "x-scalar-children"?: {
                    tagName: string;
                }[] | undefined;
                "x-internal"?: boolean | undefined;
                "x-scalar-ignore"?: boolean | undefined;
            }[K], R> : never : K extends `${number}` ? never : never : P extends `${number}` ? never : never) => void;
            undo: (uid: string & import("zod").BRAND<"tag">) => void;
            redo: (uid: string & import("zod").BRAND<"tag">) => void;
            reset: () => void;
        };
        workspaceMutators: {
            rawAdd: (item: {
                uid: string & import("zod").BRAND<"workspace">;
                name: string;
                description: string;
                cookies: (string & import("zod").BRAND<"cookie">)[];
                collections: (string & import("zod").BRAND<"collection">)[];
                environments: Record<string, string>;
                activeEnvironmentId: string;
                themeId: "default" | "alternate" | "moon" | "purple" | "solarized" | "bluePlanet" | "deepSpace" | "saturn" | "kepler" | "elysiajs" | "fastify" | "mars" | "laserwave" | "none";
                selectedHttpClient: {
                    targetKey: string;
                    clientKey: string;
                };
                hotKeyConfig?: {
                    modifiers: ("default" | "Meta" | "Control" | "Shift" | "Alt")[];
                    hotKeys?: Partial<Record<"" | "0" | "Space" | "Backspace" | "Tab" | "Enter" | "Escape" | "ArrowDown" | "ArrowLeft" | "ArrowRight" | "ArrowUp" | "End" | "Home" | "PageDown" | "PageUp" | "Delete" | "1" | "2" | "3" | "4" | "5" | "6" | "7" | "8" | "9" | "a" | "b" | "c" | "d" | "e" | "f" | "g" | "h" | "i" | "j" | "k" | "l" | "m" | "n" | "o" | "p" | "q" | "r" | "s" | "t" | "u" | "v" | "w" | "x" | "y" | "z" | "*" | "+" | "-" | "." | "/" | "F1" | "F2" | "F3" | "F4" | "F5" | "F6" | "F7" | "F8" | "F9" | "F10" | "F11" | "F12" | ";" | "=" | "," | "`" | "[" | "\\" | "]", {
                        event: "addTopNav" | "closeModal" | "closeTopNav" | "createNew" | "executeRequest" | "focusAddressBar" | "focusRequestSearch" | "jumpToLastTab" | "jumpToTab" | "navigateSearchResultsDown" | "navigateSearchResultsUp" | "navigateTopNavLeft" | "navigateTopNavRight" | "openCommandPalette" | "selectSearchResult" | "toggleSidebar";
                        modifiers?: ("default" | "Meta" | "Control" | "Shift" | "Alt")[] | undefined;
                    }>> | undefined;
                } | undefined;
                proxyUrl?: string | undefined;
            }) => void;
            add: (payload?: Partial<import("@scalar/oas-utils/entities/workspace").Workspace>) => {
                uid: string & import("zod").BRAND<"workspace">;
                name: string;
                description: string;
                cookies: (string & import("zod").BRAND<"cookie">)[];
                collections: (string & import("zod").BRAND<"collection">)[];
                environments: Record<string, string>;
                activeEnvironmentId: string;
                themeId: "default" | "alternate" | "moon" | "purple" | "solarized" | "bluePlanet" | "deepSpace" | "saturn" | "kepler" | "elysiajs" | "fastify" | "mars" | "laserwave" | "none";
                selectedHttpClient: {
                    targetKey: string;
                    clientKey: string;
                };
                hotKeyConfig?: {
                    modifiers: ("default" | "Meta" | "Control" | "Shift" | "Alt")[];
                    hotKeys?: Partial<Record<"" | "0" | "Space" | "Backspace" | "Tab" | "Enter" | "Escape" | "ArrowDown" | "ArrowLeft" | "ArrowRight" | "ArrowUp" | "End" | "Home" | "PageDown" | "PageUp" | "Delete" | "1" | "2" | "3" | "4" | "5" | "6" | "7" | "8" | "9" | "a" | "b" | "c" | "d" | "e" | "f" | "g" | "h" | "i" | "j" | "k" | "l" | "m" | "n" | "o" | "p" | "q" | "r" | "s" | "t" | "u" | "v" | "w" | "x" | "y" | "z" | "*" | "+" | "-" | "." | "/" | "F1" | "F2" | "F3" | "F4" | "F5" | "F6" | "F7" | "F8" | "F9" | "F10" | "F11" | "F12" | ";" | "=" | "," | "`" | "[" | "\\" | "]", {
                        event: "addTopNav" | "closeModal" | "closeTopNav" | "createNew" | "executeRequest" | "focusAddressBar" | "focusRequestSearch" | "jumpToLastTab" | "jumpToTab" | "navigateSearchResultsDown" | "navigateSearchResultsUp" | "navigateTopNavLeft" | "navigateTopNavRight" | "openCommandPalette" | "selectSearchResult" | "toggleSidebar";
                        modifiers?: ("default" | "Meta" | "Control" | "Shift" | "Alt")[] | undefined;
                    }>> | undefined;
                } | undefined;
                proxyUrl?: string | undefined;
            };
            delete: (uid: import("@scalar/oas-utils/entities/workspace").Workspace["uid"]) => void;
            set: (item: {
                uid: string & import("zod").BRAND<"workspace">;
                name: string;
                description: string;
                cookies: (string & import("zod").BRAND<"cookie">)[];
                collections: (string & import("zod").BRAND<"collection">)[];
                environments: Record<string, string>;
                activeEnvironmentId: string;
                themeId: "default" | "alternate" | "moon" | "purple" | "solarized" | "bluePlanet" | "deepSpace" | "saturn" | "kepler" | "elysiajs" | "fastify" | "mars" | "laserwave" | "none";
                selectedHttpClient: {
                    targetKey: string;
                    clientKey: string;
                };
                hotKeyConfig?: {
                    modifiers: ("default" | "Meta" | "Control" | "Shift" | "Alt")[];
                    hotKeys?: Partial<Record<"" | "0" | "Space" | "Backspace" | "Tab" | "Enter" | "Escape" | "ArrowDown" | "ArrowLeft" | "ArrowRight" | "ArrowUp" | "End" | "Home" | "PageDown" | "PageUp" | "Delete" | "1" | "2" | "3" | "4" | "5" | "6" | "7" | "8" | "9" | "a" | "b" | "c" | "d" | "e" | "f" | "g" | "h" | "i" | "j" | "k" | "l" | "m" | "n" | "o" | "p" | "q" | "r" | "s" | "t" | "u" | "v" | "w" | "x" | "y" | "z" | "*" | "+" | "-" | "." | "/" | "F1" | "F2" | "F3" | "F4" | "F5" | "F6" | "F7" | "F8" | "F9" | "F10" | "F11" | "F12" | ";" | "=" | "," | "`" | "[" | "\\" | "]", {
                        event: "addTopNav" | "closeModal" | "closeTopNav" | "createNew" | "executeRequest" | "focusAddressBar" | "focusRequestSearch" | "jumpToLastTab" | "jumpToTab" | "navigateSearchResultsDown" | "navigateSearchResultsUp" | "navigateTopNavLeft" | "navigateTopNavRight" | "openCommandPalette" | "selectSearchResult" | "toggleSidebar";
                        modifiers?: ("default" | "Meta" | "Control" | "Shift" | "Alt")[] | undefined;
                    }>> | undefined;
                } | undefined;
                proxyUrl?: string | undefined;
            }) => void;
            edit: <P extends "proxyUrl" | "description" | "name" | "uid" | "collections" | "cookies" | "environments" | "activeEnvironmentId" | "themeId" | "selectedHttpClient" | "hotKeyConfig" | `collections.${number}` | `cookies.${number}` | `environments.${string}` | "selectedHttpClient.targetKey" | "selectedHttpClient.clientKey" | "hotKeyConfig.modifiers" | "hotKeyConfig.hotKeys" | `hotKeyConfig.modifiers.${number}` | "hotKeyConfig.hotKeys." | "hotKeyConfig.hotKeys.c" | "hotKeyConfig.hotKeys.r" | "hotKeyConfig.hotKeys.o" | "hotKeyConfig.hotKeys.n" | "hotKeyConfig.hotKeys.a" | "hotKeyConfig.hotKeys.b" | "hotKeyConfig.hotKeys.d" | "hotKeyConfig.hotKeys.e" | "hotKeyConfig.hotKeys.f" | "hotKeyConfig.hotKeys.g" | "hotKeyConfig.hotKeys.h" | "hotKeyConfig.hotKeys.i" | "hotKeyConfig.hotKeys.j" | "hotKeyConfig.hotKeys.k" | "hotKeyConfig.hotKeys.l" | "hotKeyConfig.hotKeys.m" | "hotKeyConfig.hotKeys.p" | "hotKeyConfig.hotKeys.q" | "hotKeyConfig.hotKeys.s" | "hotKeyConfig.hotKeys.t" | "hotKeyConfig.hotKeys.u" | "hotKeyConfig.hotKeys.v" | "hotKeyConfig.hotKeys.w" | "hotKeyConfig.hotKeys.x" | "hotKeyConfig.hotKeys.y" | "hotKeyConfig.hotKeys.z" | "hotKeyConfig.hotKeys.0" | "hotKeyConfig.hotKeys.Space" | "hotKeyConfig.hotKeys.Backspace" | "hotKeyConfig.hotKeys.Tab" | "hotKeyConfig.hotKeys.Enter" | "hotKeyConfig.hotKeys.Escape" | "hotKeyConfig.hotKeys.ArrowDown" | "hotKeyConfig.hotKeys.ArrowLeft" | "hotKeyConfig.hotKeys.ArrowRight" | "hotKeyConfig.hotKeys.ArrowUp" | "hotKeyConfig.hotKeys.End" | "hotKeyConfig.hotKeys.Home" | "hotKeyConfig.hotKeys.PageDown" | "hotKeyConfig.hotKeys.PageUp" | "hotKeyConfig.hotKeys.Delete" | "hotKeyConfig.hotKeys.1" | "hotKeyConfig.hotKeys.2" | "hotKeyConfig.hotKeys.3" | "hotKeyConfig.hotKeys.4" | "hotKeyConfig.hotKeys.5" | "hotKeyConfig.hotKeys.6" | "hotKeyConfig.hotKeys.7" | "hotKeyConfig.hotKeys.8" | "hotKeyConfig.hotKeys.9" | "hotKeyConfig.hotKeys.*" | "hotKeyConfig.hotKeys.+" | "hotKeyConfig.hotKeys.-" | "hotKeyConfig.hotKeys.." | "hotKeyConfig.hotKeys./" | "hotKeyConfig.hotKeys.F1" | "hotKeyConfig.hotKeys.F2" | "hotKeyConfig.hotKeys.F3" | "hotKeyConfig.hotKeys.F4" | "hotKeyConfig.hotKeys.F5" | "hotKeyConfig.hotKeys.F6" | "hotKeyConfig.hotKeys.F7" | "hotKeyConfig.hotKeys.F8" | "hotKeyConfig.hotKeys.F9" | "hotKeyConfig.hotKeys.F10" | "hotKeyConfig.hotKeys.F11" | "hotKeyConfig.hotKeys.F12" | "hotKeyConfig.hotKeys.;" | "hotKeyConfig.hotKeys.=" | "hotKeyConfig.hotKeys.," | "hotKeyConfig.hotKeys.`" | "hotKeyConfig.hotKeys.[" | "hotKeyConfig.hotKeys.\\" | "hotKeyConfig.hotKeys.]" | "hotKeyConfig.hotKeys..modifiers" | `hotKeyConfig.hotKeys..modifiers.${number}` | "hotKeyConfig.hotKeys..event" | "hotKeyConfig.hotKeys.c.modifiers" | `hotKeyConfig.hotKeys.c.modifiers.${number}` | "hotKeyConfig.hotKeys.c.event" | "hotKeyConfig.hotKeys.r.modifiers" | `hotKeyConfig.hotKeys.r.modifiers.${number}` | "hotKeyConfig.hotKeys.r.event" | "hotKeyConfig.hotKeys.o.modifiers" | `hotKeyConfig.hotKeys.o.modifiers.${number}` | "hotKeyConfig.hotKeys.o.event" | "hotKeyConfig.hotKeys.n.modifiers" | `hotKeyConfig.hotKeys.n.modifiers.${number}` | "hotKeyConfig.hotKeys.n.event" | "hotKeyConfig.hotKeys.a.modifiers" | `hotKeyConfig.hotKeys.a.modifiers.${number}` | "hotKeyConfig.hotKeys.a.event" | "hotKeyConfig.hotKeys.b.modifiers" | `hotKeyConfig.hotKeys.b.modifiers.${number}` | "hotKeyConfig.hotKeys.b.event" | "hotKeyConfig.hotKeys.d.modifiers" | `hotKeyConfig.hotKeys.d.modifiers.${number}` | "hotKeyConfig.hotKeys.d.event" | "hotKeyConfig.hotKeys.e.modifiers" | `hotKeyConfig.hotKeys.e.modifiers.${number}` | "hotKeyConfig.hotKeys.e.event" | "hotKeyConfig.hotKeys.f.modifiers" | `hotKeyConfig.hotKeys.f.modifiers.${number}` | "hotKeyConfig.hotKeys.f.event" | "hotKeyConfig.hotKeys.g.modifiers" | `hotKeyConfig.hotKeys.g.modifiers.${number}` | "hotKeyConfig.hotKeys.g.event" | "hotKeyConfig.hotKeys.h.modifiers" | `hotKeyConfig.hotKeys.h.modifiers.${number}` | "hotKeyConfig.hotKeys.h.event" | "hotKeyConfig.hotKeys.i.modifiers" | `hotKeyConfig.hotKeys.i.modifiers.${number}` | "hotKeyConfig.hotKeys.i.event" | "hotKeyConfig.hotKeys.j.modifiers" | `hotKeyConfig.hotKeys.j.modifiers.${number}` | "hotKeyConfig.hotKeys.j.event" | "hotKeyConfig.hotKeys.k.modifiers" | `hotKeyConfig.hotKeys.k.modifiers.${number}` | "hotKeyConfig.hotKeys.k.event" | "hotKeyConfig.hotKeys.l.modifiers" | `hotKeyConfig.hotKeys.l.modifiers.${number}` | "hotKeyConfig.hotKeys.l.event" | "hotKeyConfig.hotKeys.m.modifiers" | `hotKeyConfig.hotKeys.m.modifiers.${number}` | "hotKeyConfig.hotKeys.m.event" | "hotKeyConfig.hotKeys.p.modifiers" | `hotKeyConfig.hotKeys.p.modifiers.${number}` | "hotKeyConfig.hotKeys.p.event" | "hotKeyConfig.hotKeys.q.modifiers" | `hotKeyConfig.hotKeys.q.modifiers.${number}` | "hotKeyConfig.hotKeys.q.event" | "hotKeyConfig.hotKeys.s.modifiers" | `hotKeyConfig.hotKeys.s.modifiers.${number}` | "hotKeyConfig.hotKeys.s.event" | "hotKeyConfig.hotKeys.t.modifiers" | `hotKeyConfig.hotKeys.t.modifiers.${number}` | "hotKeyConfig.hotKeys.t.event" | "hotKeyConfig.hotKeys.u.modifiers" | `hotKeyConfig.hotKeys.u.modifiers.${number}` | "hotKeyConfig.hotKeys.u.event" | "hotKeyConfig.hotKeys.v.modifiers" | `hotKeyConfig.hotKeys.v.modifiers.${number}` | "hotKeyConfig.hotKeys.v.event" | "hotKeyConfig.hotKeys.w.modifiers" | `hotKeyConfig.hotKeys.w.modifiers.${number}` | "hotKeyConfig.hotKeys.w.event" | "hotKeyConfig.hotKeys.x.modifiers" | `hotKeyConfig.hotKeys.x.modifiers.${number}` | "hotKeyConfig.hotKeys.x.event" | "hotKeyConfig.hotKeys.y.modifiers" | `hotKeyConfig.hotKeys.y.modifiers.${number}` | "hotKeyConfig.hotKeys.y.event" | "hotKeyConfig.hotKeys.z.modifiers" | `hotKeyConfig.hotKeys.z.modifiers.${number}` | "hotKeyConfig.hotKeys.z.event" | "hotKeyConfig.hotKeys.0.modifiers" | `hotKeyConfig.hotKeys.0.modifiers.${number}` | "hotKeyConfig.hotKeys.0.event" | "hotKeyConfig.hotKeys.Space.modifiers" | `hotKeyConfig.hotKeys.Space.modifiers.${number}` | "hotKeyConfig.hotKeys.Space.event" | "hotKeyConfig.hotKeys.Backspace.modifiers" | `hotKeyConfig.hotKeys.Backspace.modifiers.${number}` | "hotKeyConfig.hotKeys.Backspace.event" | "hotKeyConfig.hotKeys.Tab.modifiers" | `hotKeyConfig.hotKeys.Tab.modifiers.${number}` | "hotKeyConfig.hotKeys.Tab.event" | "hotKeyConfig.hotKeys.Enter.modifiers" | `hotKeyConfig.hotKeys.Enter.modifiers.${number}` | "hotKeyConfig.hotKeys.Enter.event" | "hotKeyConfig.hotKeys.Escape.modifiers" | `hotKeyConfig.hotKeys.Escape.modifiers.${number}` | "hotKeyConfig.hotKeys.Escape.event" | "hotKeyConfig.hotKeys.ArrowDown.modifiers" | `hotKeyConfig.hotKeys.ArrowDown.modifiers.${number}` | "hotKeyConfig.hotKeys.ArrowDown.event" | "hotKeyConfig.hotKeys.ArrowLeft.modifiers" | `hotKeyConfig.hotKeys.ArrowLeft.modifiers.${number}` | "hotKeyConfig.hotKeys.ArrowLeft.event" | "hotKeyConfig.hotKeys.ArrowRight.modifiers" | `hotKeyConfig.hotKeys.ArrowRight.modifiers.${number}` | "hotKeyConfig.hotKeys.ArrowRight.event" | "hotKeyConfig.hotKeys.ArrowUp.modifiers" | `hotKeyConfig.hotKeys.ArrowUp.modifiers.${number}` | "hotKeyConfig.hotKeys.ArrowUp.event" | "hotKeyConfig.hotKeys.End.modifiers" | `hotKeyConfig.hotKeys.End.modifiers.${number}` | "hotKeyConfig.hotKeys.End.event" | "hotKeyConfig.hotKeys.Home.modifiers" | `hotKeyConfig.hotKeys.Home.modifiers.${number}` | "hotKeyConfig.hotKeys.Home.event" | "hotKeyConfig.hotKeys.PageDown.modifiers" | `hotKeyConfig.hotKeys.PageDown.modifiers.${number}` | "hotKeyConfig.hotKeys.PageDown.event" | "hotKeyConfig.hotKeys.PageUp.modifiers" | `hotKeyConfig.hotKeys.PageUp.modifiers.${number}` | "hotKeyConfig.hotKeys.PageUp.event" | "hotKeyConfig.hotKeys.Delete.modifiers" | `hotKeyConfig.hotKeys.Delete.modifiers.${number}` | "hotKeyConfig.hotKeys.Delete.event" | "hotKeyConfig.hotKeys.1.modifiers" | `hotKeyConfig.hotKeys.1.modifiers.${number}` | "hotKeyConfig.hotKeys.1.event" | "hotKeyConfig.hotKeys.2.modifiers" | `hotKeyConfig.hotKeys.2.modifiers.${number}` | "hotKeyConfig.hotKeys.2.event" | "hotKeyConfig.hotKeys.3.modifiers" | `hotKeyConfig.hotKeys.3.modifiers.${number}` | "hotKeyConfig.hotKeys.3.event" | "hotKeyConfig.hotKeys.4.modifiers" | `hotKeyConfig.hotKeys.4.modifiers.${number}` | "hotKeyConfig.hotKeys.4.event" | "hotKeyConfig.hotKeys.5.modifiers" | `hotKeyConfig.hotKeys.5.modifiers.${number}` | "hotKeyConfig.hotKeys.5.event" | "hotKeyConfig.hotKeys.6.modifiers" | `hotKeyConfig.hotKeys.6.modifiers.${number}` | "hotKeyConfig.hotKeys.6.event" | "hotKeyConfig.hotKeys.7.modifiers" | `hotKeyConfig.hotKeys.7.modifiers.${number}` | "hotKeyConfig.hotKeys.7.event" | "hotKeyConfig.hotKeys.8.modifiers" | `hotKeyConfig.hotKeys.8.modifiers.${number}` | "hotKeyConfig.hotKeys.8.event" | "hotKeyConfig.hotKeys.9.modifiers" | `hotKeyConfig.hotKeys.9.modifiers.${number}` | "hotKeyConfig.hotKeys.9.event" | "hotKeyConfig.hotKeys.*.modifiers" | `hotKeyConfig.hotKeys.*.modifiers.${number}` | "hotKeyConfig.hotKeys.*.event" | "hotKeyConfig.hotKeys.+.modifiers" | `hotKeyConfig.hotKeys.+.modifiers.${number}` | "hotKeyConfig.hotKeys.+.event" | "hotKeyConfig.hotKeys.-.modifiers" | `hotKeyConfig.hotKeys.-.modifiers.${number}` | "hotKeyConfig.hotKeys.-.event" | "hotKeyConfig.hotKeys...modifiers" | `hotKeyConfig.hotKeys...modifiers.${number}` | "hotKeyConfig.hotKeys...event" | "hotKeyConfig.hotKeys./.modifiers" | `hotKeyConfig.hotKeys./.modifiers.${number}` | "hotKeyConfig.hotKeys./.event" | "hotKeyConfig.hotKeys.F1.modifiers" | `hotKeyConfig.hotKeys.F1.modifiers.${number}` | "hotKeyConfig.hotKeys.F1.event" | "hotKeyConfig.hotKeys.F2.modifiers" | `hotKeyConfig.hotKeys.F2.modifiers.${number}` | "hotKeyConfig.hotKeys.F2.event" | "hotKeyConfig.hotKeys.F3.modifiers" | `hotKeyConfig.hotKeys.F3.modifiers.${number}` | "hotKeyConfig.hotKeys.F3.event" | "hotKeyConfig.hotKeys.F4.modifiers" | `hotKeyConfig.hotKeys.F4.modifiers.${number}` | "hotKeyConfig.hotKeys.F4.event" | "hotKeyConfig.hotKeys.F5.modifiers" | `hotKeyConfig.hotKeys.F5.modifiers.${number}` | "hotKeyConfig.hotKeys.F5.event" | "hotKeyConfig.hotKeys.F6.modifiers" | `hotKeyConfig.hotKeys.F6.modifiers.${number}` | "hotKeyConfig.hotKeys.F6.event" | "hotKeyConfig.hotKeys.F7.modifiers" | `hotKeyConfig.hotKeys.F7.modifiers.${number}` | "hotKeyConfig.hotKeys.F7.event" | "hotKeyConfig.hotKeys.F8.modifiers" | `hotKeyConfig.hotKeys.F8.modifiers.${number}` | "hotKeyConfig.hotKeys.F8.event" | "hotKeyConfig.hotKeys.F9.modifiers" | `hotKeyConfig.hotKeys.F9.modifiers.${number}` | "hotKeyConfig.hotKeys.F9.event" | "hotKeyConfig.hotKeys.F10.modifiers" | `hotKeyConfig.hotKeys.F10.modifiers.${number}` | "hotKeyConfig.hotKeys.F10.event" | "hotKeyConfig.hotKeys.F11.modifiers" | `hotKeyConfig.hotKeys.F11.modifiers.${number}` | "hotKeyConfig.hotKeys.F11.event" | "hotKeyConfig.hotKeys.F12.modifiers" | `hotKeyConfig.hotKeys.F12.modifiers.${number}` | "hotKeyConfig.hotKeys.F12.event" | "hotKeyConfig.hotKeys.;.modifiers" | `hotKeyConfig.hotKeys.;.modifiers.${number}` | "hotKeyConfig.hotKeys.;.event" | "hotKeyConfig.hotKeys.=.modifiers" | `hotKeyConfig.hotKeys.=.modifiers.${number}` | "hotKeyConfig.hotKeys.=.event" | "hotKeyConfig.hotKeys.,.modifiers" | `hotKeyConfig.hotKeys.,.modifiers.${number}` | "hotKeyConfig.hotKeys.,.event" | "hotKeyConfig.hotKeys.`.modifiers" | `hotKeyConfig.hotKeys.\`.modifiers.${number}` | "hotKeyConfig.hotKeys.`.event" | "hotKeyConfig.hotKeys.[.modifiers" | `hotKeyConfig.hotKeys.[.modifiers.${number}` | "hotKeyConfig.hotKeys.[.event" | "hotKeyConfig.hotKeys.\\.modifiers" | `hotKeyConfig.hotKeys.\\.modifiers.${number}` | "hotKeyConfig.hotKeys.\\.event" | "hotKeyConfig.hotKeys.].modifiers" | `hotKeyConfig.hotKeys.].modifiers.${number}` | "hotKeyConfig.hotKeys.].event">(uid: (string & import("zod").BRAND<"workspace">) | null | undefined, path: P, value: P extends "proxyUrl" | "description" | "name" | "uid" | "collections" | "cookies" | "environments" | "activeEnvironmentId" | "themeId" | "selectedHttpClient" | "hotKeyConfig" ? {
                uid: string & import("zod").BRAND<"workspace">;
                name: string;
                description: string;
                cookies: (string & import("zod").BRAND<"cookie">)[];
                collections: (string & import("zod").BRAND<"collection">)[];
                environments: Record<string, string>;
                activeEnvironmentId: string;
                themeId: "default" | "alternate" | "moon" | "purple" | "solarized" | "bluePlanet" | "deepSpace" | "saturn" | "kepler" | "elysiajs" | "fastify" | "mars" | "laserwave" | "none";
                selectedHttpClient: {
                    targetKey: string;
                    clientKey: string;
                };
                hotKeyConfig?: {
                    modifiers: ("default" | "Meta" | "Control" | "Shift" | "Alt")[];
                    hotKeys?: Partial<Record<"" | "0" | "Space" | "Backspace" | "Tab" | "Enter" | "Escape" | "ArrowDown" | "ArrowLeft" | "ArrowRight" | "ArrowUp" | "End" | "Home" | "PageDown" | "PageUp" | "Delete" | "1" | "2" | "3" | "4" | "5" | "6" | "7" | "8" | "9" | "a" | "b" | "c" | "d" | "e" | "f" | "g" | "h" | "i" | "j" | "k" | "l" | "m" | "n" | "o" | "p" | "q" | "r" | "s" | "t" | "u" | "v" | "w" | "x" | "y" | "z" | "*" | "+" | "-" | "." | "/" | "F1" | "F2" | "F3" | "F4" | "F5" | "F6" | "F7" | "F8" | "F9" | "F10" | "F11" | "F12" | ";" | "=" | "," | "`" | "[" | "\\" | "]", {
                        event: "addTopNav" | "closeModal" | "closeTopNav" | "createNew" | "executeRequest" | "focusAddressBar" | "focusRequestSearch" | "jumpToLastTab" | "jumpToTab" | "navigateSearchResultsDown" | "navigateSearchResultsUp" | "navigateTopNavLeft" | "navigateTopNavRight" | "openCommandPalette" | "selectSearchResult" | "toggleSidebar";
                        modifiers?: ("default" | "Meta" | "Control" | "Shift" | "Alt")[] | undefined;
                    }>> | undefined;
                } | undefined;
                proxyUrl?: string | undefined;
            }[P] : P extends `${infer K}.${infer R}` ? K extends "proxyUrl" | "description" | "name" | "uid" | "collections" | "cookies" | "environments" | "activeEnvironmentId" | "themeId" | "selectedHttpClient" | "hotKeyConfig" ? R extends import("@scalar/object-utils/nested").Path<{
                uid: string & import("zod").BRAND<"workspace">;
                name: string;
                description: string;
                cookies: (string & import("zod").BRAND<"cookie">)[];
                collections: (string & import("zod").BRAND<"collection">)[];
                environments: Record<string, string>;
                activeEnvironmentId: string;
                themeId: "default" | "alternate" | "moon" | "purple" | "solarized" | "bluePlanet" | "deepSpace" | "saturn" | "kepler" | "elysiajs" | "fastify" | "mars" | "laserwave" | "none";
                selectedHttpClient: {
                    targetKey: string;
                    clientKey: string;
                };
                hotKeyConfig?: {
                    modifiers: ("default" | "Meta" | "Control" | "Shift" | "Alt")[];
                    hotKeys?: Partial<Record<"" | "0" | "Space" | "Backspace" | "Tab" | "Enter" | "Escape" | "ArrowDown" | "ArrowLeft" | "ArrowRight" | "ArrowUp" | "End" | "Home" | "PageDown" | "PageUp" | "Delete" | "1" | "2" | "3" | "4" | "5" | "6" | "7" | "8" | "9" | "a" | "b" | "c" | "d" | "e" | "f" | "g" | "h" | "i" | "j" | "k" | "l" | "m" | "n" | "o" | "p" | "q" | "r" | "s" | "t" | "u" | "v" | "w" | "x" | "y" | "z" | "*" | "+" | "-" | "." | "/" | "F1" | "F2" | "F3" | "F4" | "F5" | "F6" | "F7" | "F8" | "F9" | "F10" | "F11" | "F12" | ";" | "=" | "," | "`" | "[" | "\\" | "]", {
                        event: "addTopNav" | "closeModal" | "closeTopNav" | "createNew" | "executeRequest" | "focusAddressBar" | "focusRequestSearch" | "jumpToLastTab" | "jumpToTab" | "navigateSearchResultsDown" | "navigateSearchResultsUp" | "navigateTopNavLeft" | "navigateTopNavRight" | "openCommandPalette" | "selectSearchResult" | "toggleSidebar";
                        modifiers?: ("default" | "Meta" | "Control" | "Shift" | "Alt")[] | undefined;
                    }>> | undefined;
                } | undefined;
                proxyUrl?: string | undefined;
            }[K]> ? import("@scalar/object-utils/nested").PathValue<{
                uid: string & import("zod").BRAND<"workspace">;
                name: string;
                description: string;
                cookies: (string & import("zod").BRAND<"cookie">)[];
                collections: (string & import("zod").BRAND<"collection">)[];
                environments: Record<string, string>;
                activeEnvironmentId: string;
                themeId: "default" | "alternate" | "moon" | "purple" | "solarized" | "bluePlanet" | "deepSpace" | "saturn" | "kepler" | "elysiajs" | "fastify" | "mars" | "laserwave" | "none";
                selectedHttpClient: {
                    targetKey: string;
                    clientKey: string;
                };
                hotKeyConfig?: {
                    modifiers: ("default" | "Meta" | "Control" | "Shift" | "Alt")[];
                    hotKeys?: Partial<Record<"" | "0" | "Space" | "Backspace" | "Tab" | "Enter" | "Escape" | "ArrowDown" | "ArrowLeft" | "ArrowRight" | "ArrowUp" | "End" | "Home" | "PageDown" | "PageUp" | "Delete" | "1" | "2" | "3" | "4" | "5" | "6" | "7" | "8" | "9" | "a" | "b" | "c" | "d" | "e" | "f" | "g" | "h" | "i" | "j" | "k" | "l" | "m" | "n" | "o" | "p" | "q" | "r" | "s" | "t" | "u" | "v" | "w" | "x" | "y" | "z" | "*" | "+" | "-" | "." | "/" | "F1" | "F2" | "F3" | "F4" | "F5" | "F6" | "F7" | "F8" | "F9" | "F10" | "F11" | "F12" | ";" | "=" | "," | "`" | "[" | "\\" | "]", {
                        event: "addTopNav" | "closeModal" | "closeTopNav" | "createNew" | "executeRequest" | "focusAddressBar" | "focusRequestSearch" | "jumpToLastTab" | "jumpToTab" | "navigateSearchResultsDown" | "navigateSearchResultsUp" | "navigateTopNavLeft" | "navigateTopNavRight" | "openCommandPalette" | "selectSearchResult" | "toggleSidebar";
                        modifiers?: ("default" | "Meta" | "Control" | "Shift" | "Alt")[] | undefined;
                    }>> | undefined;
                } | undefined;
                proxyUrl?: string | undefined;
            }[K], R> : never : K extends `${number}` ? never : never : P extends `${number}` ? never : never) => void;
            untrackedEdit: <P extends "proxyUrl" | "description" | "name" | "uid" | "collections" | "cookies" | "environments" | "activeEnvironmentId" | "themeId" | "selectedHttpClient" | "hotKeyConfig" | `collections.${number}` | `cookies.${number}` | `environments.${string}` | "selectedHttpClient.targetKey" | "selectedHttpClient.clientKey" | "hotKeyConfig.modifiers" | "hotKeyConfig.hotKeys" | `hotKeyConfig.modifiers.${number}` | "hotKeyConfig.hotKeys." | "hotKeyConfig.hotKeys.c" | "hotKeyConfig.hotKeys.r" | "hotKeyConfig.hotKeys.o" | "hotKeyConfig.hotKeys.n" | "hotKeyConfig.hotKeys.a" | "hotKeyConfig.hotKeys.b" | "hotKeyConfig.hotKeys.d" | "hotKeyConfig.hotKeys.e" | "hotKeyConfig.hotKeys.f" | "hotKeyConfig.hotKeys.g" | "hotKeyConfig.hotKeys.h" | "hotKeyConfig.hotKeys.i" | "hotKeyConfig.hotKeys.j" | "hotKeyConfig.hotKeys.k" | "hotKeyConfig.hotKeys.l" | "hotKeyConfig.hotKeys.m" | "hotKeyConfig.hotKeys.p" | "hotKeyConfig.hotKeys.q" | "hotKeyConfig.hotKeys.s" | "hotKeyConfig.hotKeys.t" | "hotKeyConfig.hotKeys.u" | "hotKeyConfig.hotKeys.v" | "hotKeyConfig.hotKeys.w" | "hotKeyConfig.hotKeys.x" | "hotKeyConfig.hotKeys.y" | "hotKeyConfig.hotKeys.z" | "hotKeyConfig.hotKeys.0" | "hotKeyConfig.hotKeys.Space" | "hotKeyConfig.hotKeys.Backspace" | "hotKeyConfig.hotKeys.Tab" | "hotKeyConfig.hotKeys.Enter" | "hotKeyConfig.hotKeys.Escape" | "hotKeyConfig.hotKeys.ArrowDown" | "hotKeyConfig.hotKeys.ArrowLeft" | "hotKeyConfig.hotKeys.ArrowRight" | "hotKeyConfig.hotKeys.ArrowUp" | "hotKeyConfig.hotKeys.End" | "hotKeyConfig.hotKeys.Home" | "hotKeyConfig.hotKeys.PageDown" | "hotKeyConfig.hotKeys.PageUp" | "hotKeyConfig.hotKeys.Delete" | "hotKeyConfig.hotKeys.1" | "hotKeyConfig.hotKeys.2" | "hotKeyConfig.hotKeys.3" | "hotKeyConfig.hotKeys.4" | "hotKeyConfig.hotKeys.5" | "hotKeyConfig.hotKeys.6" | "hotKeyConfig.hotKeys.7" | "hotKeyConfig.hotKeys.8" | "hotKeyConfig.hotKeys.9" | "hotKeyConfig.hotKeys.*" | "hotKeyConfig.hotKeys.+" | "hotKeyConfig.hotKeys.-" | "hotKeyConfig.hotKeys.." | "hotKeyConfig.hotKeys./" | "hotKeyConfig.hotKeys.F1" | "hotKeyConfig.hotKeys.F2" | "hotKeyConfig.hotKeys.F3" | "hotKeyConfig.hotKeys.F4" | "hotKeyConfig.hotKeys.F5" | "hotKeyConfig.hotKeys.F6" | "hotKeyConfig.hotKeys.F7" | "hotKeyConfig.hotKeys.F8" | "hotKeyConfig.hotKeys.F9" | "hotKeyConfig.hotKeys.F10" | "hotKeyConfig.hotKeys.F11" | "hotKeyConfig.hotKeys.F12" | "hotKeyConfig.hotKeys.;" | "hotKeyConfig.hotKeys.=" | "hotKeyConfig.hotKeys.," | "hotKeyConfig.hotKeys.`" | "hotKeyConfig.hotKeys.[" | "hotKeyConfig.hotKeys.\\" | "hotKeyConfig.hotKeys.]" | "hotKeyConfig.hotKeys..modifiers" | `hotKeyConfig.hotKeys..modifiers.${number}` | "hotKeyConfig.hotKeys..event" | "hotKeyConfig.hotKeys.c.modifiers" | `hotKeyConfig.hotKeys.c.modifiers.${number}` | "hotKeyConfig.hotKeys.c.event" | "hotKeyConfig.hotKeys.r.modifiers" | `hotKeyConfig.hotKeys.r.modifiers.${number}` | "hotKeyConfig.hotKeys.r.event" | "hotKeyConfig.hotKeys.o.modifiers" | `hotKeyConfig.hotKeys.o.modifiers.${number}` | "hotKeyConfig.hotKeys.o.event" | "hotKeyConfig.hotKeys.n.modifiers" | `hotKeyConfig.hotKeys.n.modifiers.${number}` | "hotKeyConfig.hotKeys.n.event" | "hotKeyConfig.hotKeys.a.modifiers" | `hotKeyConfig.hotKeys.a.modifiers.${number}` | "hotKeyConfig.hotKeys.a.event" | "hotKeyConfig.hotKeys.b.modifiers" | `hotKeyConfig.hotKeys.b.modifiers.${number}` | "hotKeyConfig.hotKeys.b.event" | "hotKeyConfig.hotKeys.d.modifiers" | `hotKeyConfig.hotKeys.d.modifiers.${number}` | "hotKeyConfig.hotKeys.d.event" | "hotKeyConfig.hotKeys.e.modifiers" | `hotKeyConfig.hotKeys.e.modifiers.${number}` | "hotKeyConfig.hotKeys.e.event" | "hotKeyConfig.hotKeys.f.modifiers" | `hotKeyConfig.hotKeys.f.modifiers.${number}` | "hotKeyConfig.hotKeys.f.event" | "hotKeyConfig.hotKeys.g.modifiers" | `hotKeyConfig.hotKeys.g.modifiers.${number}` | "hotKeyConfig.hotKeys.g.event" | "hotKeyConfig.hotKeys.h.modifiers" | `hotKeyConfig.hotKeys.h.modifiers.${number}` | "hotKeyConfig.hotKeys.h.event" | "hotKeyConfig.hotKeys.i.modifiers" | `hotKeyConfig.hotKeys.i.modifiers.${number}` | "hotKeyConfig.hotKeys.i.event" | "hotKeyConfig.hotKeys.j.modifiers" | `hotKeyConfig.hotKeys.j.modifiers.${number}` | "hotKeyConfig.hotKeys.j.event" | "hotKeyConfig.hotKeys.k.modifiers" | `hotKeyConfig.hotKeys.k.modifiers.${number}` | "hotKeyConfig.hotKeys.k.event" | "hotKeyConfig.hotKeys.l.modifiers" | `hotKeyConfig.hotKeys.l.modifiers.${number}` | "hotKeyConfig.hotKeys.l.event" | "hotKeyConfig.hotKeys.m.modifiers" | `hotKeyConfig.hotKeys.m.modifiers.${number}` | "hotKeyConfig.hotKeys.m.event" | "hotKeyConfig.hotKeys.p.modifiers" | `hotKeyConfig.hotKeys.p.modifiers.${number}` | "hotKeyConfig.hotKeys.p.event" | "hotKeyConfig.hotKeys.q.modifiers" | `hotKeyConfig.hotKeys.q.modifiers.${number}` | "hotKeyConfig.hotKeys.q.event" | "hotKeyConfig.hotKeys.s.modifiers" | `hotKeyConfig.hotKeys.s.modifiers.${number}` | "hotKeyConfig.hotKeys.s.event" | "hotKeyConfig.hotKeys.t.modifiers" | `hotKeyConfig.hotKeys.t.modifiers.${number}` | "hotKeyConfig.hotKeys.t.event" | "hotKeyConfig.hotKeys.u.modifiers" | `hotKeyConfig.hotKeys.u.modifiers.${number}` | "hotKeyConfig.hotKeys.u.event" | "hotKeyConfig.hotKeys.v.modifiers" | `hotKeyConfig.hotKeys.v.modifiers.${number}` | "hotKeyConfig.hotKeys.v.event" | "hotKeyConfig.hotKeys.w.modifiers" | `hotKeyConfig.hotKeys.w.modifiers.${number}` | "hotKeyConfig.hotKeys.w.event" | "hotKeyConfig.hotKeys.x.modifiers" | `hotKeyConfig.hotKeys.x.modifiers.${number}` | "hotKeyConfig.hotKeys.x.event" | "hotKeyConfig.hotKeys.y.modifiers" | `hotKeyConfig.hotKeys.y.modifiers.${number}` | "hotKeyConfig.hotKeys.y.event" | "hotKeyConfig.hotKeys.z.modifiers" | `hotKeyConfig.hotKeys.z.modifiers.${number}` | "hotKeyConfig.hotKeys.z.event" | "hotKeyConfig.hotKeys.0.modifiers" | `hotKeyConfig.hotKeys.0.modifiers.${number}` | "hotKeyConfig.hotKeys.0.event" | "hotKeyConfig.hotKeys.Space.modifiers" | `hotKeyConfig.hotKeys.Space.modifiers.${number}` | "hotKeyConfig.hotKeys.Space.event" | "hotKeyConfig.hotKeys.Backspace.modifiers" | `hotKeyConfig.hotKeys.Backspace.modifiers.${number}` | "hotKeyConfig.hotKeys.Backspace.event" | "hotKeyConfig.hotKeys.Tab.modifiers" | `hotKeyConfig.hotKeys.Tab.modifiers.${number}` | "hotKeyConfig.hotKeys.Tab.event" | "hotKeyConfig.hotKeys.Enter.modifiers" | `hotKeyConfig.hotKeys.Enter.modifiers.${number}` | "hotKeyConfig.hotKeys.Enter.event" | "hotKeyConfig.hotKeys.Escape.modifiers" | `hotKeyConfig.hotKeys.Escape.modifiers.${number}` | "hotKeyConfig.hotKeys.Escape.event" | "hotKeyConfig.hotKeys.ArrowDown.modifiers" | `hotKeyConfig.hotKeys.ArrowDown.modifiers.${number}` | "hotKeyConfig.hotKeys.ArrowDown.event" | "hotKeyConfig.hotKeys.ArrowLeft.modifiers" | `hotKeyConfig.hotKeys.ArrowLeft.modifiers.${number}` | "hotKeyConfig.hotKeys.ArrowLeft.event" | "hotKeyConfig.hotKeys.ArrowRight.modifiers" | `hotKeyConfig.hotKeys.ArrowRight.modifiers.${number}` | "hotKeyConfig.hotKeys.ArrowRight.event" | "hotKeyConfig.hotKeys.ArrowUp.modifiers" | `hotKeyConfig.hotKeys.ArrowUp.modifiers.${number}` | "hotKeyConfig.hotKeys.ArrowUp.event" | "hotKeyConfig.hotKeys.End.modifiers" | `hotKeyConfig.hotKeys.End.modifiers.${number}` | "hotKeyConfig.hotKeys.End.event" | "hotKeyConfig.hotKeys.Home.modifiers" | `hotKeyConfig.hotKeys.Home.modifiers.${number}` | "hotKeyConfig.hotKeys.Home.event" | "hotKeyConfig.hotKeys.PageDown.modifiers" | `hotKeyConfig.hotKeys.PageDown.modifiers.${number}` | "hotKeyConfig.hotKeys.PageDown.event" | "hotKeyConfig.hotKeys.PageUp.modifiers" | `hotKeyConfig.hotKeys.PageUp.modifiers.${number}` | "hotKeyConfig.hotKeys.PageUp.event" | "hotKeyConfig.hotKeys.Delete.modifiers" | `hotKeyConfig.hotKeys.Delete.modifiers.${number}` | "hotKeyConfig.hotKeys.Delete.event" | "hotKeyConfig.hotKeys.1.modifiers" | `hotKeyConfig.hotKeys.1.modifiers.${number}` | "hotKeyConfig.hotKeys.1.event" | "hotKeyConfig.hotKeys.2.modifiers" | `hotKeyConfig.hotKeys.2.modifiers.${number}` | "hotKeyConfig.hotKeys.2.event" | "hotKeyConfig.hotKeys.3.modifiers" | `hotKeyConfig.hotKeys.3.modifiers.${number}` | "hotKeyConfig.hotKeys.3.event" | "hotKeyConfig.hotKeys.4.modifiers" | `hotKeyConfig.hotKeys.4.modifiers.${number}` | "hotKeyConfig.hotKeys.4.event" | "hotKeyConfig.hotKeys.5.modifiers" | `hotKeyConfig.hotKeys.5.modifiers.${number}` | "hotKeyConfig.hotKeys.5.event" | "hotKeyConfig.hotKeys.6.modifiers" | `hotKeyConfig.hotKeys.6.modifiers.${number}` | "hotKeyConfig.hotKeys.6.event" | "hotKeyConfig.hotKeys.7.modifiers" | `hotKeyConfig.hotKeys.7.modifiers.${number}` | "hotKeyConfig.hotKeys.7.event" | "hotKeyConfig.hotKeys.8.modifiers" | `hotKeyConfig.hotKeys.8.modifiers.${number}` | "hotKeyConfig.hotKeys.8.event" | "hotKeyConfig.hotKeys.9.modifiers" | `hotKeyConfig.hotKeys.9.modifiers.${number}` | "hotKeyConfig.hotKeys.9.event" | "hotKeyConfig.hotKeys.*.modifiers" | `hotKeyConfig.hotKeys.*.modifiers.${number}` | "hotKeyConfig.hotKeys.*.event" | "hotKeyConfig.hotKeys.+.modifiers" | `hotKeyConfig.hotKeys.+.modifiers.${number}` | "hotKeyConfig.hotKeys.+.event" | "hotKeyConfig.hotKeys.-.modifiers" | `hotKeyConfig.hotKeys.-.modifiers.${number}` | "hotKeyConfig.hotKeys.-.event" | "hotKeyConfig.hotKeys...modifiers" | `hotKeyConfig.hotKeys...modifiers.${number}` | "hotKeyConfig.hotKeys...event" | "hotKeyConfig.hotKeys./.modifiers" | `hotKeyConfig.hotKeys./.modifiers.${number}` | "hotKeyConfig.hotKeys./.event" | "hotKeyConfig.hotKeys.F1.modifiers" | `hotKeyConfig.hotKeys.F1.modifiers.${number}` | "hotKeyConfig.hotKeys.F1.event" | "hotKeyConfig.hotKeys.F2.modifiers" | `hotKeyConfig.hotKeys.F2.modifiers.${number}` | "hotKeyConfig.hotKeys.F2.event" | "hotKeyConfig.hotKeys.F3.modifiers" | `hotKeyConfig.hotKeys.F3.modifiers.${number}` | "hotKeyConfig.hotKeys.F3.event" | "hotKeyConfig.hotKeys.F4.modifiers" | `hotKeyConfig.hotKeys.F4.modifiers.${number}` | "hotKeyConfig.hotKeys.F4.event" | "hotKeyConfig.hotKeys.F5.modifiers" | `hotKeyConfig.hotKeys.F5.modifiers.${number}` | "hotKeyConfig.hotKeys.F5.event" | "hotKeyConfig.hotKeys.F6.modifiers" | `hotKeyConfig.hotKeys.F6.modifiers.${number}` | "hotKeyConfig.hotKeys.F6.event" | "hotKeyConfig.hotKeys.F7.modifiers" | `hotKeyConfig.hotKeys.F7.modifiers.${number}` | "hotKeyConfig.hotKeys.F7.event" | "hotKeyConfig.hotKeys.F8.modifiers" | `hotKeyConfig.hotKeys.F8.modifiers.${number}` | "hotKeyConfig.hotKeys.F8.event" | "hotKeyConfig.hotKeys.F9.modifiers" | `hotKeyConfig.hotKeys.F9.modifiers.${number}` | "hotKeyConfig.hotKeys.F9.event" | "hotKeyConfig.hotKeys.F10.modifiers" | `hotKeyConfig.hotKeys.F10.modifiers.${number}` | "hotKeyConfig.hotKeys.F10.event" | "hotKeyConfig.hotKeys.F11.modifiers" | `hotKeyConfig.hotKeys.F11.modifiers.${number}` | "hotKeyConfig.hotKeys.F11.event" | "hotKeyConfig.hotKeys.F12.modifiers" | `hotKeyConfig.hotKeys.F12.modifiers.${number}` | "hotKeyConfig.hotKeys.F12.event" | "hotKeyConfig.hotKeys.;.modifiers" | `hotKeyConfig.hotKeys.;.modifiers.${number}` | "hotKeyConfig.hotKeys.;.event" | "hotKeyConfig.hotKeys.=.modifiers" | `hotKeyConfig.hotKeys.=.modifiers.${number}` | "hotKeyConfig.hotKeys.=.event" | "hotKeyConfig.hotKeys.,.modifiers" | `hotKeyConfig.hotKeys.,.modifiers.${number}` | "hotKeyConfig.hotKeys.,.event" | "hotKeyConfig.hotKeys.`.modifiers" | `hotKeyConfig.hotKeys.\`.modifiers.${number}` | "hotKeyConfig.hotKeys.`.event" | "hotKeyConfig.hotKeys.[.modifiers" | `hotKeyConfig.hotKeys.[.modifiers.${number}` | "hotKeyConfig.hotKeys.[.event" | "hotKeyConfig.hotKeys.\\.modifiers" | `hotKeyConfig.hotKeys.\\.modifiers.${number}` | "hotKeyConfig.hotKeys.\\.event" | "hotKeyConfig.hotKeys.].modifiers" | `hotKeyConfig.hotKeys.].modifiers.${number}` | "hotKeyConfig.hotKeys.].event">(uid: string & import("zod").BRAND<"workspace">, path: P, value: P extends "proxyUrl" | "description" | "name" | "uid" | "collections" | "cookies" | "environments" | "activeEnvironmentId" | "themeId" | "selectedHttpClient" | "hotKeyConfig" ? {
                uid: string & import("zod").BRAND<"workspace">;
                name: string;
                description: string;
                cookies: (string & import("zod").BRAND<"cookie">)[];
                collections: (string & import("zod").BRAND<"collection">)[];
                environments: Record<string, string>;
                activeEnvironmentId: string;
                themeId: "default" | "alternate" | "moon" | "purple" | "solarized" | "bluePlanet" | "deepSpace" | "saturn" | "kepler" | "elysiajs" | "fastify" | "mars" | "laserwave" | "none";
                selectedHttpClient: {
                    targetKey: string;
                    clientKey: string;
                };
                hotKeyConfig?: {
                    modifiers: ("default" | "Meta" | "Control" | "Shift" | "Alt")[];
                    hotKeys?: Partial<Record<"" | "0" | "Space" | "Backspace" | "Tab" | "Enter" | "Escape" | "ArrowDown" | "ArrowLeft" | "ArrowRight" | "ArrowUp" | "End" | "Home" | "PageDown" | "PageUp" | "Delete" | "1" | "2" | "3" | "4" | "5" | "6" | "7" | "8" | "9" | "a" | "b" | "c" | "d" | "e" | "f" | "g" | "h" | "i" | "j" | "k" | "l" | "m" | "n" | "o" | "p" | "q" | "r" | "s" | "t" | "u" | "v" | "w" | "x" | "y" | "z" | "*" | "+" | "-" | "." | "/" | "F1" | "F2" | "F3" | "F4" | "F5" | "F6" | "F7" | "F8" | "F9" | "F10" | "F11" | "F12" | ";" | "=" | "," | "`" | "[" | "\\" | "]", {
                        event: "addTopNav" | "closeModal" | "closeTopNav" | "createNew" | "executeRequest" | "focusAddressBar" | "focusRequestSearch" | "jumpToLastTab" | "jumpToTab" | "navigateSearchResultsDown" | "navigateSearchResultsUp" | "navigateTopNavLeft" | "navigateTopNavRight" | "openCommandPalette" | "selectSearchResult" | "toggleSidebar";
                        modifiers?: ("default" | "Meta" | "Control" | "Shift" | "Alt")[] | undefined;
                    }>> | undefined;
                } | undefined;
                proxyUrl?: string | undefined;
            }[P] : P extends `${infer K}.${infer R}` ? K extends "proxyUrl" | "description" | "name" | "uid" | "collections" | "cookies" | "environments" | "activeEnvironmentId" | "themeId" | "selectedHttpClient" | "hotKeyConfig" ? R extends import("@scalar/object-utils/nested").Path<{
                uid: string & import("zod").BRAND<"workspace">;
                name: string;
                description: string;
                cookies: (string & import("zod").BRAND<"cookie">)[];
                collections: (string & import("zod").BRAND<"collection">)[];
                environments: Record<string, string>;
                activeEnvironmentId: string;
                themeId: "default" | "alternate" | "moon" | "purple" | "solarized" | "bluePlanet" | "deepSpace" | "saturn" | "kepler" | "elysiajs" | "fastify" | "mars" | "laserwave" | "none";
                selectedHttpClient: {
                    targetKey: string;
                    clientKey: string;
                };
                hotKeyConfig?: {
                    modifiers: ("default" | "Meta" | "Control" | "Shift" | "Alt")[];
                    hotKeys?: Partial<Record<"" | "0" | "Space" | "Backspace" | "Tab" | "Enter" | "Escape" | "ArrowDown" | "ArrowLeft" | "ArrowRight" | "ArrowUp" | "End" | "Home" | "PageDown" | "PageUp" | "Delete" | "1" | "2" | "3" | "4" | "5" | "6" | "7" | "8" | "9" | "a" | "b" | "c" | "d" | "e" | "f" | "g" | "h" | "i" | "j" | "k" | "l" | "m" | "n" | "o" | "p" | "q" | "r" | "s" | "t" | "u" | "v" | "w" | "x" | "y" | "z" | "*" | "+" | "-" | "." | "/" | "F1" | "F2" | "F3" | "F4" | "F5" | "F6" | "F7" | "F8" | "F9" | "F10" | "F11" | "F12" | ";" | "=" | "," | "`" | "[" | "\\" | "]", {
                        event: "addTopNav" | "closeModal" | "closeTopNav" | "createNew" | "executeRequest" | "focusAddressBar" | "focusRequestSearch" | "jumpToLastTab" | "jumpToTab" | "navigateSearchResultsDown" | "navigateSearchResultsUp" | "navigateTopNavLeft" | "navigateTopNavRight" | "openCommandPalette" | "selectSearchResult" | "toggleSidebar";
                        modifiers?: ("default" | "Meta" | "Control" | "Shift" | "Alt")[] | undefined;
                    }>> | undefined;
                } | undefined;
                proxyUrl?: string | undefined;
            }[K]> ? import("@scalar/object-utils/nested").PathValue<{
                uid: string & import("zod").BRAND<"workspace">;
                name: string;
                description: string;
                cookies: (string & import("zod").BRAND<"cookie">)[];
                collections: (string & import("zod").BRAND<"collection">)[];
                environments: Record<string, string>;
                activeEnvironmentId: string;
                themeId: "default" | "alternate" | "moon" | "purple" | "solarized" | "bluePlanet" | "deepSpace" | "saturn" | "kepler" | "elysiajs" | "fastify" | "mars" | "laserwave" | "none";
                selectedHttpClient: {
                    targetKey: string;
                    clientKey: string;
                };
                hotKeyConfig?: {
                    modifiers: ("default" | "Meta" | "Control" | "Shift" | "Alt")[];
                    hotKeys?: Partial<Record<"" | "0" | "Space" | "Backspace" | "Tab" | "Enter" | "Escape" | "ArrowDown" | "ArrowLeft" | "ArrowRight" | "ArrowUp" | "End" | "Home" | "PageDown" | "PageUp" | "Delete" | "1" | "2" | "3" | "4" | "5" | "6" | "7" | "8" | "9" | "a" | "b" | "c" | "d" | "e" | "f" | "g" | "h" | "i" | "j" | "k" | "l" | "m" | "n" | "o" | "p" | "q" | "r" | "s" | "t" | "u" | "v" | "w" | "x" | "y" | "z" | "*" | "+" | "-" | "." | "/" | "F1" | "F2" | "F3" | "F4" | "F5" | "F6" | "F7" | "F8" | "F9" | "F10" | "F11" | "F12" | ";" | "=" | "," | "`" | "[" | "\\" | "]", {
                        event: "addTopNav" | "closeModal" | "closeTopNav" | "createNew" | "executeRequest" | "focusAddressBar" | "focusRequestSearch" | "jumpToLastTab" | "jumpToTab" | "navigateSearchResultsDown" | "navigateSearchResultsUp" | "navigateTopNavLeft" | "navigateTopNavRight" | "openCommandPalette" | "selectSearchResult" | "toggleSidebar";
                        modifiers?: ("default" | "Meta" | "Control" | "Shift" | "Alt")[] | undefined;
                    }>> | undefined;
                } | undefined;
                proxyUrl?: string | undefined;
            }[K], R> : never : K extends `${number}` ? never : never : P extends `${number}` ? never : never) => void;
            undo: (uid: string & import("zod").BRAND<"workspace">) => void;
            redo: (uid: string & import("zod").BRAND<"workspace">) => void;
            reset: () => void;
        };
        addCollectionEnvironment: (environmentName: string, environment: import("@scalar/oas-utils/entities/spec").XScalarEnvironment, collectionUid: import("@scalar/oas-utils/entities/spec").Collection["uid"]) => void;
        removeCollectionEnvironment: (environmentName: string, collectionUid: import("@scalar/oas-utils/entities/spec").Collection["uid"]) => void;
    };
} | null>;
/**
 * Hook to control and access the API Client
 */
export declare const useApiClient: () => {
    client: typeof client;
    init: (args: Props) => Promise<ApiClient>;
};
export {};
//# sourceMappingURL=useApiClient.d.ts.map