import type { OpenAPI } from '@scalar/openapi-types';
import type { RequestBodyMimeTypes, TransformedOperation } from '@scalar/types/legacy';
/**
 * Generates the responses for the request from the parameters in the OpenAPI document
 */
export declare function useResponses(operation: TransformedOperation): {
    responses: import("vue").ComputedRef<{
        name: string;
        description: string;
        content: RequestBodyMimeTypes;
        headers?: {
            [key: string]: OpenAPI.HeaderObject;
        };
    }[]>;
};
//# sourceMappingURL=useResponses.d.ts.map