import type { NavState } from '../hooks/useNavState.js';
import { type AnyApiReferenceConfiguration, type SpecConfiguration } from '@scalar/types/api-reference';
import { type Ref } from 'vue';
type UseMultipleDocumentsProps = {
    /**
     * Configuration for the API reference.
     * Can be a single configuration or an array of configurations for multiple documents.
     */
    configuration: Ref<AnyApiReferenceConfiguration | undefined>;
    /** The initial index to pre-select a document, if there is no query parameter available */
    initialIndex?: number;
} & NavState;
/**
 * Take any configuration and return a flat array of configurations.
 */
export declare const normalizeConfigurations: (configuration: AnyApiReferenceConfiguration | undefined) => SpecConfiguration[];
export declare const useMultipleDocuments: ({ configuration, initialIndex, isIntersectionEnabled, hash, hashPrefix, }: UseMultipleDocumentsProps) => {
    selectedConfiguration: import("vue").ComputedRef<{
        url?: string | undefined;
        content?: string | Record<string, any> | ((...args: unknown[]) => Record<string, any>) | null | undefined;
        title?: string | undefined;
        slug?: string | undefined;
        default?: boolean;
        hideClientButton?: boolean | undefined;
        showSidebar?: boolean | undefined;
        theme?: "default" | "alternate" | "moon" | "purple" | "solarized" | "bluePlanet" | "deepSpace" | "saturn" | "kepler" | "elysiajs" | "fastify" | "mars" | "laserwave" | "none" | undefined;
        layout?: "modern" | "classic" | undefined;
        isEditable?: boolean | undefined;
        isLoading?: boolean | undefined;
        hideModels?: boolean | undefined;
        hideDownloadButton?: boolean | undefined;
        hideTestRequestButton?: boolean | undefined;
        hideSearch?: boolean | undefined;
        hideDarkModeToggle?: boolean | undefined;
        withDefaultFonts?: boolean | undefined;
        authentication?: any;
        baseServerURL?: string | undefined;
        proxyUrl?: string | undefined;
        searchHotKey?: "c" | "r" | "o" | "n" | "a" | "b" | "d" | "e" | "f" | "g" | "h" | "i" | "j" | "k" | "l" | "m" | "p" | "q" | "s" | "t" | "u" | "v" | "w" | "x" | "y" | "z" | undefined;
        servers?: any[] | undefined;
        _integration?: "go" | "elysiajs" | "fastify" | "adonisjs" | "docusaurus" | "dotnet" | "express" | "fastapi" | "hono" | "html" | "laravel" | "litestar" | "nestjs" | "nextjs" | "nitro" | "nuxt" | "platformatic" | "react" | "rust" | "vue" | null | undefined;
        onRequestSent?: ((args_0: string, ...args: unknown[]) => void) | undefined;
        plugins?: ((...args: unknown[]) => {
            name: string;
            extensions: {
                name: string;
                component?: unknown;
            }[];
        })[] | undefined;
        darkMode?: boolean | undefined;
        forceDarkModeState?: "dark" | "light" | undefined;
        metaData?: any;
        favicon?: string | undefined;
        hiddenClients?: true | string[] | Record<string, boolean | string[]> | undefined;
        defaultHttpClient?: {
            targetKey: "c" | "clojure" | "csharp" | "go" | "http" | "java" | "js" | "kotlin" | "node" | "objc" | "ocaml" | "php" | "powershell" | "python" | "r" | "ruby" | "shell" | "swift" | "dart";
            clientKey: string;
        } | undefined;
        customCss?: string | undefined;
        onSpecUpdate?: ((args_0: string, ...args: unknown[]) => void) | undefined;
        onServerChange?: ((args_0: string, ...args: unknown[]) => void) | undefined;
        onDocumentSelect?: ((...args: unknown[]) => void | Promise<void>) | undefined;
        onLoaded?: ((...args: unknown[]) => void | Promise<void>) | undefined;
        onShowMore?: ((args_0: string, ...args: unknown[]) => void | Promise<void>) | undefined;
        onSidebarClick?: ((args_0: string, ...args: unknown[]) => void | Promise<void>) | undefined;
        pathRouting?: {
            basePath: string;
        } | undefined;
        generateHeadingSlug?: ((args_0: {
            slug?: string | undefined;
        }, ...args: unknown[]) => string) | undefined;
        generateModelSlug?: ((args_0: {
            name?: string | undefined;
        }, ...args: unknown[]) => string) | undefined;
        generateTagSlug?: ((args_0: {
            name?: string | undefined;
        }, ...args: unknown[]) => string) | undefined;
        generateOperationSlug?: ((args_0: {
            path: string;
            method: string;
            operationId?: string | undefined;
            summary?: string | undefined;
        }, ...args: unknown[]) => string) | undefined;
        generateWebhookSlug?: ((args_0: {
            name: string;
            method?: string | undefined;
        }, ...args: unknown[]) => string) | undefined;
        redirect?: ((args_0: string, ...args: unknown[]) => string | null | undefined) | undefined;
        defaultOpenAllTags?: boolean | undefined;
        tagsSorter?: "alpha" | ((args_0: any, args_1: any, ...args: unknown[]) => number) | undefined;
        operationsSorter?: "method" | "alpha" | ((args_0: any, args_1: any, ...args: unknown[]) => number) | undefined;
        sources?: ({
            url?: string | undefined;
            content?: string | Record<string, any> | ((...args: unknown[]) => Record<string, any>) | null | undefined;
            title?: string | undefined;
            slug?: string | undefined;
        } & {
            default?: boolean;
        })[] | undefined;
    }>;
    availableDocuments: import("vue").ComputedRef<{
        url?: string | undefined;
        content?: string | Record<string, any> | ((...args: unknown[]) => Record<string, any>) | null | undefined;
        title?: string | undefined;
        slug?: string | undefined;
    }[]>;
    selectedDocumentIndex: Ref<number, number>;
    isIntersectionEnabled: Ref<boolean, boolean>;
    hash: Ref<string, string>;
    hashPrefix: Ref<string, string>;
};
export {};
//# sourceMappingURL=useMultipleDocuments.d.ts.map