import type { ApiReferenceConfiguration } from '@scalar/types/api-reference';
import type { Heading, Tag, TransformedOperation } from '@scalar/types/legacy';
import { type InjectionKey, type Ref } from 'vue';
export type NavState = {
    /** The URL hash without the #, also the "hash" pulled from pathRouting */
    hash: Ref<string>;
    /** The prefix for the hash, used in ORG */
    hashPrefix: Ref<string>;
    /** Whether the intersection observer is enabled and updating the hash as we scroll */
    isIntersectionEnabled: Ref<boolean>;
};
export declare const NAV_STATE_SYMBOL: InjectionKey<NavState>;
/**
 * Hook which provides reactive hash state from the URL
 * Also hash is only readable by the client so keep that in mind for SSR
 *
 * isIntersectionEnabled is a hack to prevent intersection observer from triggering
 * when clicking on sidebar links or going backwards
 *
 * @param _config this is used to pass in the config if we have not provided it yet to the useConfig hook such as in ApiReferenceLayout
 */
export declare const useNavState: (_config?: Ref<ApiReferenceConfiguration>) => {
    hash: Ref<string, string>;
    /** Sets the prefix for the hash */
    setHashPrefix: (prefix: string) => void;
    /**
     * Gets the full hash with the prefix
     * @param hashTarget The hash to target with the return
     * @returns The full hash
     */
    getFullHash: (hashTarget?: string) => string;
    /**
     * Gets the hashed url with the prefix
     * @param replacementHash The hash to replace the current hash with
     * @param url The url to get the hashed url from
     * @returns The hashed url
     */
    getHashedUrl: (replacementHash: string, url?: string, search?: string) => string;
    /**
     * Replaces the URL state with the new url and hash
     * Replacement is used so that hash changes don't trigger the url hash watcher and cause a scroll
     */
    replaceUrlState: (replacementHash: string, url?: string) => void;
    getReferenceId: () => string;
    getWebhookId: (webhook?: {
        name: string;
        method?: string;
    }) => string;
    getModelId: (model?: {
        name: string;
    }) => string;
    getHeadingId: (heading: Heading) => string;
    getOperationId: (operation: TransformedOperation, parentTag: Tag) => string;
    getPathRoutingId: (pathName: string) => string;
    getSectionId: (hashStr?: string) => string;
    getTagId: (tag: Tag) => string;
    isIntersectionEnabled: Ref<boolean, boolean>;
    updateHash: () => string;
};
//# sourceMappingURL=useNavState.d.ts.map