import { useConfig as b } from "./useConfig.js";
import { combineUrlAndPath as R } from "@scalar/oas-utils/helpers";
import { slug as i } from "github-slugger";
import { ref as l, inject as y } from "vue";
const U = Symbol(), P = l(!1), k = l(""), x = l(""), T = (d) => {
  const { isIntersectionEnabled: f, hash: o, hashPrefix: r } = y(U, {
    isIntersectionEnabled: P,
    hash: k,
    hashPrefix: x
  }), t = d ?? b(), c = (e) => {
    var n;
    if (!t.value.pathRouting)
      return "";
    const a = new RegExp("^" + ((n = t.value.pathRouting) == null ? void 0 : n.basePath) + "/?");
    return decodeURIComponent(e.replace(a, ""));
  }, p = (e = o.value) => {
    var h;
    const a = (h = e.match(/(tag\/[^/]+)/)) == null ? void 0 : h[0], n = e.startsWith("model") ? "models" : "", u = e.startsWith("webhook") ? "webhooks" : "";
    return a || n || u;
  }, g = () => t.value.pathRouting ? c(window.location.pathname) : (
    // Must remove the prefix from the hash as the internal hash value should be pure
    decodeURIComponent(window.location.hash.replace(/^#/, "")).slice(r.value.length)
  ), m = () => o.value = g(), v = (e, a = window.location.href) => {
    const n = new URL(a);
    t.value.pathRouting ? n.pathname = R(t.value.pathRouting.basePath, e) : n.hash = r.value + e, o.value = e, window.history.replaceState({}, "", n);
  }, I = (e, a = window.location.href, n = window.location.search) => {
    const u = new URL(a);
    return u.hash = r.value + e, u.search = n, u.toString();
  }, w = (e = o.value) => `${r.value}${e}`, S = (e) => typeof t.value.generateHeadingSlug == "function" ? `${t.value.generateHeadingSlug(e)}` : e.slug ? `description/${e.slug}` : "", $ = (e) => e != null && e.name ? typeof t.value.generateModelSlug == "function" ? `model/${t.value.generateModelSlug(e)}` : `model/${i(e.name)}` : "models", s = (e) => typeof t.value.generateTagSlug == "function" ? `tag/${t.value.generateTagSlug(e)}` : `tag/${i(e.name)}`;
  return {
    hash: o,
    /** Sets the prefix for the hash */
    setHashPrefix: (e) => {
      r.value = e;
    },
    /**
     * Gets the full hash with the prefix
     * @param hashTarget The hash to target with the return
     * @returns The full hash
     */
    getFullHash: w,
    /**
     * Gets the hashed url with the prefix
     * @param replacementHash The hash to replace the current hash with
     * @param url The url to get the hashed url from
     * @returns The hashed url
     */
    getHashedUrl: I,
    /**
     * Replaces the URL state with the new url and hash
     * Replacement is used so that hash changes don't trigger the url hash watcher and cause a scroll
     */
    replaceUrlState: v,
    getReferenceId: g,
    getWebhookId: (e) => e != null && e.name ? typeof t.value.generateWebhookSlug == "function" ? `webhook/${t.value.generateWebhookSlug(e)}` : `webhook/${e.method}/${i(e.name)}` : "webhooks",
    getModelId: $,
    getHeadingId: S,
    getOperationId: (e, a) => {
      var n;
      return typeof t.value.generateOperationSlug == "function" ? `${s(a)}/${t.value.generateOperationSlug({
        path: e.path,
        operationId: e.operationId,
        method: e.httpVerb,
        summary: (n = e.information) == null ? void 0 : n.summary
      })}` : `${s(a)}/${e.httpVerb}${e.path}`;
    },
    getPathRoutingId: c,
    getSectionId: p,
    getTagId: s,
    isIntersectionEnabled: f,
    updateHash: m
  };
};
export {
  U as NAV_STATE_SYMBOL,
  T as useNavState
};
