import type { SpecConfiguration } from '@scalar/types/api-reference';
import { type MaybeRefOrGetter } from 'vue';
/**
 * Keep the raw spec content in a ref and update it when the configuration changes.
 */
export declare function useReactiveSpec({ specConfig, proxyUrl, }: {
    specConfig?: MaybeRefOrGetter<SpecConfiguration>;
    proxyUrl?: MaybeRefOrGetter<string>;
}): {
    rawSpec: import("vue").Ref<string, string>;
    parsedSpec: import("vue").Ref<{
        tags?: {
            name: string;
            description: string;
            operations: {
                httpVerb: "GET" | "HEAD" | "PATCH" | "POST" | "PUT" | "TRACE" | "CONNECT" | "DELETE" | "OPTIONS";
                path: string;
                operationId?: string | undefined;
                name?: string | undefined;
                description?: string | undefined;
                information?: {
                    description?: string | undefined;
                    operationId?: (string | number) | undefined;
                    parameters?: {
                        name: string;
                        in?: string | undefined;
                        description?: string | undefined;
                        required?: boolean | undefined;
                        deprecated?: boolean | undefined;
                        allowEmptyValue?: boolean | undefined;
                        style?: ("form" | "simple") | undefined;
                        explode?: boolean | undefined;
                        allowReserved?: boolean | undefined;
                        schema?: {
                            type: string;
                            name?: string | undefined;
                            example?: any;
                            default?: any;
                            format?: string | undefined;
                            description?: string | undefined;
                            properties?: Record<string, import("@scalar/types").Schema> | undefined;
                        } | undefined;
                        example?: any;
                        examples?: (Map<string, any> & Omit<Map<string, any>, keyof Map<any, any>>) | undefined;
                        content?: import("@scalar/types").RequestBodyMimeTypes | undefined;
                        headers?: {
                            [key: string]: import("@scalar/openapi-types").OpenAPI.HeaderObject;
                        } | undefined;
                    }[] | undefined;
                    responses?: Record<string, import("@scalar/openapi-types").OpenAPI.ResponseObject> | undefined;
                    security?: import("@scalar/openapi-types").OpenAPIV3.SecurityRequirementObject[] | undefined;
                    requestBody?: {
                        description?: string | undefined;
                        required?: boolean | undefined;
                        content?: import("@scalar/types").RequestBodyMimeTypes | undefined;
                    } | undefined;
                    summary?: string | undefined;
                    tags?: string[] | undefined;
                    deprecated?: boolean | undefined;
                    servers?: {
                        url?: string | undefined;
                        description?: string | undefined;
                        variables?: Record<string, import("@scalar/openapi-types").OpenAPIV3_1.ServerVariableObject> | undefined;
                    }[] | undefined;
                    'x-custom-examples'?: {
                        lang: string;
                        label: string;
                        source: string;
                    }[] | undefined;
                    'x-scalar-stability'?: import("@scalar/types").XScalarStability | undefined;
                    'x-codeSamples'?: {
                        lang: string;
                        label: string;
                        source: string;
                    }[] | undefined;
                    'x-code-samples'?: {
                        lang: string;
                        label: string;
                        source: string;
                    }[] | undefined;
                } | undefined;
                servers?: {
                    url?: string | undefined;
                    description?: string | undefined;
                    variables?: Record<string, import("@scalar/openapi-types").OpenAPIV3_1.ServerVariableObject> | undefined;
                }[] | undefined;
                pathParameters?: {
                    name: string;
                    in?: string | undefined;
                    description?: string | undefined;
                    required?: boolean | undefined;
                    deprecated?: boolean | undefined;
                    allowEmptyValue?: boolean | undefined;
                    style?: ("form" | "simple") | undefined;
                    explode?: boolean | undefined;
                    allowReserved?: boolean | undefined;
                    schema?: {
                        type: string;
                        name?: string | undefined;
                        example?: any;
                        default?: any;
                        format?: string | undefined;
                        description?: string | undefined;
                        properties?: Record<string, import("@scalar/types").Schema> | undefined;
                    } | undefined;
                    example?: any;
                    examples?: (Map<string, any> & Omit<Map<string, any>, keyof Map<any, any>>) | undefined;
                    content?: import("@scalar/types").RequestBodyMimeTypes | undefined;
                    headers?: {
                        [key: string]: import("@scalar/openapi-types").OpenAPI.HeaderObject;
                    } | undefined;
                }[] | undefined;
            }[];
            'x-displayName'?: string | undefined;
        }[] | undefined;
        info: {
            title?: string | undefined;
            description?: string | undefined;
            termsOfService?: string | undefined;
            contact?: {
                name?: string | undefined;
                url?: string | undefined;
                email?: string | undefined;
            } | undefined;
            license?: {
                name?: string | undefined;
                url?: string | undefined;
            } | undefined;
            version?: string | undefined;
        } | {
            title?: string | undefined;
            description?: string | undefined;
            termsOfService?: string | undefined;
            contact?: {
                name?: string | undefined;
                url?: string | undefined;
                email?: string | undefined;
            } | undefined;
            license?: {
                name?: string | undefined;
                url?: string | undefined;
            } | undefined;
            version?: string | undefined;
        } | {
            title?: string | undefined;
            description?: string | undefined;
            termsOfService?: string | undefined;
            contact?: {
                name?: string | undefined;
                url?: string | undefined;
                email?: string | undefined;
            } | undefined;
            version?: string | undefined;
            summary?: string | undefined;
            license?: {
                name?: string | undefined;
                url?: string | undefined;
                identifier?: string | undefined;
            } | undefined;
        } | undefined;
        host?: import("@scalar/openapi-types").OpenAPIV2.Document["host"];
        basePath?: import("@scalar/openapi-types").OpenAPIV2.Document["basePath"];
        schemes?: import("@scalar/openapi-types").OpenAPIV2.Document["schemes"];
        externalDocs?: {
            url: string;
            description?: string | undefined;
        } | undefined;
        servers?: {
            url?: string | undefined;
            description?: string | undefined;
            variables?: Record<string, import("@scalar/openapi-types").OpenAPIV3_1.ServerVariableObject> | undefined;
        }[] | {
            url?: string | undefined;
            description?: string | undefined;
            variables?: {
                [variable: string]: import("@scalar/openapi-types").OpenAPIV3.ServerVariableObject;
            } | undefined;
        }[] | undefined;
        components?: {
            schemas?: {
                [key: string]: import("@scalar/openapi-types").OpenAPIV3.ReferenceObject | import("@scalar/openapi-types").OpenAPIV3.SchemaObject;
            } | undefined;
            responses?: {
                [key: string]: import("@scalar/openapi-types").OpenAPIV3.ReferenceObject | import("@scalar/openapi-types").OpenAPIV3.ResponseObject;
            } | undefined;
            parameters?: {
                [key: string]: import("@scalar/openapi-types").OpenAPIV3.ReferenceObject | import("@scalar/openapi-types").OpenAPIV3.ParameterObject;
            } | undefined;
            examples?: {
                [key: string]: import("@scalar/openapi-types").OpenAPIV3.ReferenceObject | import("@scalar/openapi-types").OpenAPIV3.ExampleObject;
            } | undefined;
            requestBodies?: {
                [key: string]: import("@scalar/openapi-types").OpenAPIV3.ReferenceObject | import("@scalar/openapi-types").OpenAPIV3.RequestBodyObject;
            } | undefined;
            headers?: {
                [key: string]: import("@scalar/openapi-types").OpenAPIV3.ReferenceObject | import("@scalar/openapi-types").OpenAPIV3.HeaderObject;
            } | undefined;
            securitySchemes?: {
                [key: string]: import("@scalar/openapi-types").OpenAPIV3.ReferenceObject | import("@scalar/openapi-types").OpenAPIV3.SecuritySchemeObject;
            } | undefined;
            links?: {
                [key: string]: import("@scalar/openapi-types").OpenAPIV3.ReferenceObject | import("@scalar/openapi-types").OpenAPIV3.LinkObject;
            } | undefined;
            callbacks?: {
                [key: string]: import("@scalar/openapi-types").OpenAPIV3.ReferenceObject | import("@scalar/openapi-types").OpenAPIV3.CallbackObject;
            } | undefined;
        } | {
            schemas?: Record<string, import("@scalar/openapi-types").OpenAPIV3_1.SchemaObject> | undefined;
            responses?: Record<string, import("@scalar/openapi-types").OpenAPIV3_1.ReferenceObject | import("@scalar/openapi-types").OpenAPIV3_1.ResponseObject> | undefined;
            parameters?: Record<string, import("@scalar/openapi-types").OpenAPIV3_1.ReferenceObject | import("@scalar/openapi-types").OpenAPIV3_1.ParameterObject> | undefined;
            examples?: Record<string, import("@scalar/openapi-types").OpenAPIV3_1.ReferenceObject | import("@scalar/openapi-types").OpenAPIV3_1.ExampleObject> | undefined;
            requestBodies?: Record<string, import("@scalar/openapi-types").OpenAPIV3_1.ReferenceObject | import("@scalar/openapi-types").OpenAPIV3_1.RequestBodyObject> | undefined;
            headers?: Record<string, import("@scalar/openapi-types").OpenAPIV3_1.ReferenceObject | import("@scalar/openapi-types").OpenAPIV3_1.HeaderObject> | undefined;
            securitySchemes?: Record<string, import("@scalar/openapi-types").OpenAPIV3_1.ReferenceObject | import("@scalar/openapi-types").OpenAPIV3_1.SecuritySchemeObject> | undefined;
            links?: Record<string, import("@scalar/openapi-types").OpenAPIV3_1.ReferenceObject | import("@scalar/openapi-types").OpenAPIV3_1.LinkObject> | undefined;
            callbacks?: Record<string, import("@scalar/openapi-types").OpenAPIV3_1.ReferenceObject | import("@scalar/openapi-types").OpenAPIV3_1.CallbackObject> | undefined;
            pathItems?: Record<string, import("@scalar/openapi-types").OpenAPIV3_1.ReferenceObject | import("@scalar/openapi-types").OpenAPIV3_1.PathItemObject> | undefined;
        } | undefined;
        webhooks?: import("@scalar/types").Webhooks | undefined;
        definitions?: import("@scalar/types").Definitions | undefined;
        swagger?: import("@scalar/openapi-types").OpenAPIV2.Document["swagger"];
        openapi?: import("@scalar/openapi-types").OpenAPIV3.Document["openapi"] | import("@scalar/openapi-types").OpenAPIV3_1.Document["openapi"];
        'x-tagGroups'?: {
            name: string;
            tags: string[];
        }[] | undefined;
        security?: import("@scalar/openapi-types").OpenAPIV3.SecurityRequirementObject[] | undefined;
    }, import("@scalar/types").Spec | {
        tags?: {
            name: string;
            description: string;
            operations: {
                httpVerb: "GET" | "HEAD" | "PATCH" | "POST" | "PUT" | "TRACE" | "CONNECT" | "DELETE" | "OPTIONS";
                path: string;
                operationId?: string | undefined;
                name?: string | undefined;
                description?: string | undefined;
                information?: {
                    description?: string | undefined;
                    operationId?: (string | number) | undefined;
                    parameters?: {
                        name: string;
                        in?: string | undefined;
                        description?: string | undefined;
                        required?: boolean | undefined;
                        deprecated?: boolean | undefined;
                        allowEmptyValue?: boolean | undefined;
                        style?: ("form" | "simple") | undefined;
                        explode?: boolean | undefined;
                        allowReserved?: boolean | undefined;
                        schema?: {
                            type: string;
                            name?: string | undefined;
                            example?: any;
                            default?: any;
                            format?: string | undefined;
                            description?: string | undefined;
                            properties?: Record<string, import("@scalar/types").Schema> | undefined;
                        } | undefined;
                        example?: any;
                        examples?: (Map<string, any> & Omit<Map<string, any>, keyof Map<any, any>>) | undefined;
                        content?: import("@scalar/types").RequestBodyMimeTypes | undefined;
                        headers?: {
                            [key: string]: import("@scalar/openapi-types").OpenAPI.HeaderObject;
                        } | undefined;
                    }[] | undefined;
                    responses?: Record<string, import("@scalar/openapi-types").OpenAPI.ResponseObject> | undefined;
                    security?: import("@scalar/openapi-types").OpenAPIV3.SecurityRequirementObject[] | undefined;
                    requestBody?: {
                        description?: string | undefined;
                        required?: boolean | undefined;
                        content?: import("@scalar/types").RequestBodyMimeTypes | undefined;
                    } | undefined;
                    summary?: string | undefined;
                    tags?: string[] | undefined;
                    deprecated?: boolean | undefined;
                    servers?: {
                        url?: string | undefined;
                        description?: string | undefined;
                        variables?: Record<string, import("@scalar/openapi-types").OpenAPIV3_1.ServerVariableObject> | undefined;
                    }[] | undefined;
                    'x-custom-examples'?: {
                        lang: string;
                        label: string;
                        source: string;
                    }[] | undefined;
                    'x-scalar-stability'?: import("@scalar/types").XScalarStability | undefined;
                    'x-codeSamples'?: {
                        lang: string;
                        label: string;
                        source: string;
                    }[] | undefined;
                    'x-code-samples'?: {
                        lang: string;
                        label: string;
                        source: string;
                    }[] | undefined;
                } | undefined;
                servers?: {
                    url?: string | undefined;
                    description?: string | undefined;
                    variables?: Record<string, import("@scalar/openapi-types").OpenAPIV3_1.ServerVariableObject> | undefined;
                }[] | undefined;
                pathParameters?: {
                    name: string;
                    in?: string | undefined;
                    description?: string | undefined;
                    required?: boolean | undefined;
                    deprecated?: boolean | undefined;
                    allowEmptyValue?: boolean | undefined;
                    style?: ("form" | "simple") | undefined;
                    explode?: boolean | undefined;
                    allowReserved?: boolean | undefined;
                    schema?: {
                        type: string;
                        name?: string | undefined;
                        example?: any;
                        default?: any;
                        format?: string | undefined;
                        description?: string | undefined;
                        properties?: Record<string, import("@scalar/types").Schema> | undefined;
                    } | undefined;
                    example?: any;
                    examples?: (Map<string, any> & Omit<Map<string, any>, keyof Map<any, any>>) | undefined;
                    content?: import("@scalar/types").RequestBodyMimeTypes | undefined;
                    headers?: {
                        [key: string]: import("@scalar/openapi-types").OpenAPI.HeaderObject;
                    } | undefined;
                }[] | undefined;
            }[];
            'x-displayName'?: string | undefined;
        }[] | undefined;
        info: {
            title?: string | undefined;
            description?: string | undefined;
            termsOfService?: string | undefined;
            contact?: {
                name?: string | undefined;
                url?: string | undefined;
                email?: string | undefined;
            } | undefined;
            license?: {
                name?: string | undefined;
                url?: string | undefined;
            } | undefined;
            version?: string | undefined;
        } | {
            title?: string | undefined;
            description?: string | undefined;
            termsOfService?: string | undefined;
            contact?: {
                name?: string | undefined;
                url?: string | undefined;
                email?: string | undefined;
            } | undefined;
            license?: {
                name?: string | undefined;
                url?: string | undefined;
            } | undefined;
            version?: string | undefined;
        } | {
            title?: string | undefined;
            description?: string | undefined;
            termsOfService?: string | undefined;
            contact?: {
                name?: string | undefined;
                url?: string | undefined;
                email?: string | undefined;
            } | undefined;
            version?: string | undefined;
            summary?: string | undefined;
            license?: {
                name?: string | undefined;
                url?: string | undefined;
                identifier?: string | undefined;
            } | undefined;
        } | undefined;
        host?: import("@scalar/openapi-types").OpenAPIV2.Document["host"];
        basePath?: import("@scalar/openapi-types").OpenAPIV2.Document["basePath"];
        schemes?: import("@scalar/openapi-types").OpenAPIV2.Document["schemes"];
        externalDocs?: {
            url: string;
            description?: string | undefined;
        } | undefined;
        servers?: {
            url?: string | undefined;
            description?: string | undefined;
            variables?: Record<string, import("@scalar/openapi-types").OpenAPIV3_1.ServerVariableObject> | undefined;
        }[] | {
            url?: string | undefined;
            description?: string | undefined;
            variables?: {
                [variable: string]: import("@scalar/openapi-types").OpenAPIV3.ServerVariableObject;
            } | undefined;
        }[] | undefined;
        components?: {
            schemas?: {
                [key: string]: import("@scalar/openapi-types").OpenAPIV3.ReferenceObject | import("@scalar/openapi-types").OpenAPIV3.SchemaObject;
            } | undefined;
            responses?: {
                [key: string]: import("@scalar/openapi-types").OpenAPIV3.ReferenceObject | import("@scalar/openapi-types").OpenAPIV3.ResponseObject;
            } | undefined;
            parameters?: {
                [key: string]: import("@scalar/openapi-types").OpenAPIV3.ReferenceObject | import("@scalar/openapi-types").OpenAPIV3.ParameterObject;
            } | undefined;
            examples?: {
                [key: string]: import("@scalar/openapi-types").OpenAPIV3.ReferenceObject | import("@scalar/openapi-types").OpenAPIV3.ExampleObject;
            } | undefined;
            requestBodies?: {
                [key: string]: import("@scalar/openapi-types").OpenAPIV3.ReferenceObject | import("@scalar/openapi-types").OpenAPIV3.RequestBodyObject;
            } | undefined;
            headers?: {
                [key: string]: import("@scalar/openapi-types").OpenAPIV3.ReferenceObject | import("@scalar/openapi-types").OpenAPIV3.HeaderObject;
            } | undefined;
            securitySchemes?: {
                [key: string]: import("@scalar/openapi-types").OpenAPIV3.ReferenceObject | import("@scalar/openapi-types").OpenAPIV3.SecuritySchemeObject;
            } | undefined;
            links?: {
                [key: string]: import("@scalar/openapi-types").OpenAPIV3.ReferenceObject | import("@scalar/openapi-types").OpenAPIV3.LinkObject;
            } | undefined;
            callbacks?: {
                [key: string]: import("@scalar/openapi-types").OpenAPIV3.ReferenceObject | import("@scalar/openapi-types").OpenAPIV3.CallbackObject;
            } | undefined;
        } | {
            schemas?: Record<string, import("@scalar/openapi-types").OpenAPIV3_1.SchemaObject> | undefined;
            responses?: Record<string, import("@scalar/openapi-types").OpenAPIV3_1.ReferenceObject | import("@scalar/openapi-types").OpenAPIV3_1.ResponseObject> | undefined;
            parameters?: Record<string, import("@scalar/openapi-types").OpenAPIV3_1.ReferenceObject | import("@scalar/openapi-types").OpenAPIV3_1.ParameterObject> | undefined;
            examples?: Record<string, import("@scalar/openapi-types").OpenAPIV3_1.ReferenceObject | import("@scalar/openapi-types").OpenAPIV3_1.ExampleObject> | undefined;
            requestBodies?: Record<string, import("@scalar/openapi-types").OpenAPIV3_1.ReferenceObject | import("@scalar/openapi-types").OpenAPIV3_1.RequestBodyObject> | undefined;
            headers?: Record<string, import("@scalar/openapi-types").OpenAPIV3_1.ReferenceObject | import("@scalar/openapi-types").OpenAPIV3_1.HeaderObject> | undefined;
            securitySchemes?: Record<string, import("@scalar/openapi-types").OpenAPIV3_1.ReferenceObject | import("@scalar/openapi-types").OpenAPIV3_1.SecuritySchemeObject> | undefined;
            links?: Record<string, import("@scalar/openapi-types").OpenAPIV3_1.ReferenceObject | import("@scalar/openapi-types").OpenAPIV3_1.LinkObject> | undefined;
            callbacks?: Record<string, import("@scalar/openapi-types").OpenAPIV3_1.ReferenceObject | import("@scalar/openapi-types").OpenAPIV3_1.CallbackObject> | undefined;
            pathItems?: Record<string, import("@scalar/openapi-types").OpenAPIV3_1.ReferenceObject | import("@scalar/openapi-types").OpenAPIV3_1.PathItemObject> | undefined;
        } | undefined;
        webhooks?: import("@scalar/types").Webhooks | undefined;
        definitions?: import("@scalar/types").Definitions | undefined;
        swagger?: import("@scalar/openapi-types").OpenAPIV2.Document["swagger"];
        openapi?: import("@scalar/openapi-types").OpenAPIV3.Document["openapi"] | import("@scalar/openapi-types").OpenAPIV3_1.Document["openapi"];
        'x-tagGroups'?: {
            name: string;
            tags: string[];
        }[] | undefined;
        security?: import("@scalar/openapi-types").OpenAPIV3.SecurityRequirementObject[] | undefined;
    }>;
    specErrors: import("vue").Ref<string | null, string | null>;
};
//# sourceMappingURL=useReactiveSpec.d.ts.map