import type { Spec, Tag, TransformedOperation } from '@scalar/types/legacy';
export type SidebarEntry = {
    id: string;
    title: string;
    displayTitle?: string;
    children?: SidebarEntry[];
    select?: () => void;
    httpVerb?: string;
    show: boolean;
    deprecated?: boolean;
    isGroup?: boolean;
};
export declare const DEFAULT_INTRODUCTION_SLUG = "introduction";
/** Helper to overwrite the current OpenAPI document */
declare function setParsedSpec(spec: Spec): Spec;
type CollapsedSidebarItems = Record<string, boolean>;
declare function toggleCollapsedSidebarItem(key: string): void;
declare function setCollapsedSidebarItem(key: string, value: boolean): void;
export type ParsedSpecOption = {
    parsedSpec: Spec;
};
export type SorterOption = {
    tagsSorter?: 'alpha' | ((a: Tag, b: Tag) => number);
    operationsSorter?: 'alpha' | 'method' | ((a: TransformedOperation, b: TransformedOperation) => number);
};
/**
 * Scroll to operation
 *
 * Similar to scrollToId BUT in the case of a section not being open,
 * it uses the lazyBus to ensure the section is open before scrolling to it
 *
 */
export declare const scrollToOperation: (operationId: string, focus?: boolean) => void;
/**
 * Provides the sidebar state and methods to control it.
 */
export declare function useSidebar(options?: ParsedSpecOption & SorterOption): {
    breadcrumb: import("vue").ComputedRef<string>;
    items: import("vue").ComputedRef<{
        entries: SidebarEntry[];
        titles: Record<string, string>;
    }>;
    isSidebarOpen: import("vue").Ref<boolean, boolean>;
    collapsedSidebarItems: CollapsedSidebarItems;
    toggleCollapsedSidebarItem: typeof toggleCollapsedSidebarItem;
    setCollapsedSidebarItem: typeof setCollapsedSidebarItem;
    hideModels: import("vue").Ref<boolean, boolean>;
    setParsedSpec: typeof setParsedSpec;
    defaultOpenAllTags: import("vue").Ref<boolean, boolean>;
    scrollToOperation: (operationId: string, focus?: boolean) => void;
};
export {};
//# sourceMappingURL=useSidebar.d.ts.map