import { isOperationDeprecated as F } from "../libs/operation.js";
import { ssrState as Y } from "@scalar/oas-utils/helpers";
import { ref as w, reactive as z, computed as P, watch as U } from "vue";
import { lazyBus as Z } from "../components/Content/Lazy/lazyBus.js";
import { useNavState as $ } from "./useNavState.js";
import { getLowestHeadingLevel as q } from "../helpers/getLowestHeadingLevel.js";
import { hasModels as ee } from "../helpers/hasModels.js";
import { getModels as _ } from "../helpers/getModels.js";
import { hasWebhooks as te } from "../helpers/hasWebhooks.js";
import { getHeadingsFromMarkdown as se } from "../helpers/getHeadingsFromMarkdown.js";
import { scrollToId as N } from "../helpers/scrollToId.js";
const re = "introduction", O = w(null), c = w(void 0), g = z({});
function R(t) {
  var p, s, l;
  g.tagsSorter === "alpha" ? t.tags = (p = t.tags) == null ? void 0 : p.sort((r, n) => r.name.localeCompare(n.name)) : typeof g.tagsSorter == "function" && (t.tags = (s = t.tags) == null ? void 0 : s.sort(g.tagsSorter));
  const a = (r, n) => {
    const T = r.name ?? r.path, m = n.name ?? n.path;
    return T.localeCompare(m);
  }, i = (r, n) => r.httpVerb.localeCompare(n.httpVerb);
  let d;
  return g.operationsSorter === "alpha" ? d = a : g.operationsSorter === "method" ? d = i : typeof g.operationsSorter == "function" && (d = g.operationsSorter), d && ((l = t.tags) == null || l.forEach((r) => {
    var n;
    r.operations = (n = r.operations) == null ? void 0 : n.sort(d);
  })), c.value = t;
}
const J = w(!1), K = w(!1), y = z(Y["useSidebarContent-collapsedSidebarItems"] ?? {});
function oe(t) {
  y[t] = !y[t];
}
function I(t, a) {
  y[t] = a;
}
const x = w([]);
function ae(t) {
  const a = se(t), i = q(a);
  return a.filter((d) => (
    // highest level, eg. # Introduction
    d.depth === i || // second highest level, eg. ## Authentication
    d.depth === i + 1
  ));
}
const Q = P(() => {
  var M, C, E, B, D, L, j, G, V, W;
  if (!O.value)
    return { entries: [], titles: {} };
  const { getHeadingId: t, getModelId: a, getOperationId: i, getTagId: d, getWebhookId: p } = O.value, s = {}, l = [];
  let r = null;
  x.value.forEach((e) => {
    var o;
    e.depth === q(x.value) ? (r = {
      id: t(e),
      title: e.value,
      show: !0,
      children: []
    }, l.push(r)) : r && ((o = r.children) == null || o.push({
      id: t(e),
      title: e.value,
      show: !0
    }));
  });
  const n = (C = (M = c.value) == null ? void 0 : M.tags) == null ? void 0 : C[0], m = n && ((e) => (e == null ? void 0 : e.length) !== 1 || e[0].name !== "default" || e[0].description !== "")((E = c.value) == null ? void 0 : E.tags) ? (D = (B = c.value) == null ? void 0 : B.tags) == null ? void 0 : D.filter((e) => {
    var o;
    return ((o = e.operations) == null ? void 0 : o.length) > 0;
  }).map((e) => {
    var o;
    return {
      id: d(e),
      title: e.name,
      displayTitle: e["x-displayName"] ?? e.name,
      show: !0,
      children: (o = e.operations) == null ? void 0 : o.map((u) => {
        var v, b;
        const h = i(u, e), f = u.name ?? u.path;
        return s[h] = f, {
          id: h,
          title: f,
          httpVerb: u.httpVerb,
          // TODO: Workaround until we’re using the store directly
          deprecated: u.information ? F({
            deprecated: (v = u.information) == null ? void 0 : v.deprecated,
            "x-scalar-stability": (b = u.information) == null ? void 0 : b["x-scalar-stability"]
          }) : !1,
          show: !0,
          select: () => {
          }
        };
      })
    };
  }) : (L = n == null ? void 0 : n.operations) == null ? void 0 : L.map((e) => {
    var h, f;
    const o = i(e, n), u = e.name ?? e.path;
    return s[o] = u, {
      id: o,
      title: u,
      httpVerb: e.httpVerb,
      // TODO: Workaround until we’re using the store directly
      deprecated: e.information ? F({
        deprecated: (h = e.information) == null ? void 0 : h.deprecated,
        "x-scalar-stability": (f = e.information) == null ? void 0 : f["x-scalar-stability"]
      }) : !1,
      show: !0,
      select: () => {
      }
    };
  });
  let S = ee(c.value) && !J.value ? [
    {
      id: a(),
      title: "Models",
      show: !0,
      children: Object.keys(_(c.value) ?? {}).map((e) => {
        var u;
        const o = a({ name: e });
        return s[o] = e, {
          id: o,
          title: ((u = _(c.value)) == null ? void 0 : u[e]).title ?? e,
          show: !0
        };
      })
    }
  ] : [], k = te(c.value) ? [
    {
      id: p(),
      title: "Webhooks",
      show: !0,
      children: Object.keys(((j = c.value) == null ? void 0 : j.webhooks) ?? {}).flatMap((e) => {
        var u, h;
        const o = p({ name: e });
        return s[o] = e, Object.keys(((h = (u = c.value) == null ? void 0 : u.webhooks) == null ? void 0 : h[e]) ?? {}).map(
          (f) => {
            var v, b, A;
            return {
              id: p({ name: e, method: f }),
              title: (A = (b = (v = c.value) == null ? void 0 : v.webhooks) == null ? void 0 : b[e][f]) == null ? void 0 : A.name,
              httpVerb: f,
              show: !0
            };
          }
        );
      })
    }
  ] : [];
  const X = (G = c.value) != null && G["x-tagGroups"] ? (W = (V = c.value) == null ? void 0 : V["x-tagGroups"]) == null ? void 0 : W.map((e) => {
    var h;
    const o = [];
    return (h = e.tags) == null || h.map((f) => {
      if (f === "models" && S.length > 0)
        o.push(S[0]), S = [];
      else if (f === "webhooks" && k.length > 0)
        o.push(k[0]), k = [];
      else {
        const v = m == null ? void 0 : m.find((b) => b.title === f);
        v && o.push(v);
      }
    }), {
      id: e.name,
      title: e.name,
      children: o,
      show: !0,
      isGroup: !0
    };
  }) : void 0, H = [
    ...l,
    ...X ?? m ?? [],
    ...k,
    ...S
  ];
  return K.value && H.forEach((e) => {
    I(e.id, !0), e.show = !0;
  }), {
    entries: H,
    titles: s
  };
}), ie = w(!1), le = P(() => {
  var t, a, i;
  return ((i = (t = Q.value) == null ? void 0 : t.titles) == null ? void 0 : i[((a = O.value) == null ? void 0 : a.hash) ?? ""]) ?? "";
}), ne = (t, a) => {
  var d;
  const i = (d = O.value) == null ? void 0 : d.getSectionId(t);
  if (i && i !== t)
    if (y[i])
      N(t, a);
    else {
      const p = Z.on((s) => {
        s.id === t && (N(t, a), p());
      });
      I(i, !0);
    }
};
function we(t) {
  Object.assign(g, t);
  const a = $();
  O.value = a;
  const { hash: i, getSectionId: d, getTagId: p } = a;
  return t != null && t.parsedSpec && (R(t.parsedSpec), U(
    () => {
      var s, l;
      return (l = (s = c.value) == null ? void 0 : s.tags) == null ? void 0 : l.length;
    },
    () => {
      var s, l;
      if (i.value) {
        const r = d(i.value);
        r && I(r, !0);
      } else {
        const r = (l = (s = c.value) == null ? void 0 : s.tags) == null ? void 0 : l[0];
        r && I(p(r), !0);
      }
    }
  ), U(
    () => {
      var s, l;
      return (l = (s = c.value) == null ? void 0 : s.info) == null ? void 0 : l.description;
    },
    () => {
      var r, n, T, m;
      const s = (T = (n = (r = c.value) == null ? void 0 : r.info) == null ? void 0 : n.description) == null ? void 0 : T.trim();
      if (!s)
        return x.value = [];
      const l = ae(s);
      if (s && !s.startsWith("#")) {
        const S = {
          depth: ((m = l[0]) == null ? void 0 : m.depth) ?? 1,
          value: "Introduction",
          slug: re
        };
        l.unshift(S);
      }
      return x.value = l;
    },
    {
      immediate: !0
    }
  )), {
    breadcrumb: le,
    items: Q,
    isSidebarOpen: ie,
    collapsedSidebarItems: y,
    toggleCollapsedSidebarItem: oe,
    setCollapsedSidebarItem: I,
    hideModels: J,
    setParsedSpec: R,
    defaultOpenAllTags: K,
    scrollToOperation: ne
  };
}
export {
  re as DEFAULT_INTRODUCTION_SLUG,
  ne as scrollToOperation,
  we as useSidebar
};
