import { default as t } from "./components/ApiReference.vue.js";
import { default as o } from "./components/ApiReferenceLayout.vue.js";
import { default as p } from "./components/Layouts/ModernLayout.vue.js";
import { default as m } from "./components/GettingStarted.vue.js";
import { useReactiveSpec as x } from "./hooks/useReactiveSpec.js";
import { createApiReference as l } from "./standalone/lib/html-api.js";
import { parse as i } from "./helpers/parse.js";
import { createEmptySpecification as S } from "./helpers/createEmptySpecification.js";
import { useNavState as R } from "./hooks/useNavState.js";
import { useSidebar as y } from "./hooks/useSidebar.js";
import { useHttpClientStore as H } from "./stores/useHttpClientStore.js";
import { createScalarReferences as h } from "./esm.js";
import { default as M } from "./features/Search/SearchButton.vue.js";
import { default as g } from "./features/Search/SearchModal.vue.js";
import { default as E } from "./components/Sidebar/Sidebar.vue.js";
import { default as G } from "./components/Card/Card.vue.js";
import { default as j } from "./components/Card/CardHeader.vue.js";
import { default as q } from "./components/Card/CardContent.vue.js";
import { default as z } from "./components/Card/CardFooter.vue.js";
import { default as I } from "./components/Card/CardTabHeader.vue.js";
import { default as K } from "./components/Card/CardTab.vue.js";
import { default as P } from "./components/Layouts/Layouts.vue.js";
export {
  t as ApiReference,
  o as ApiReferenceLayout,
  G as Card,
  q as CardContent,
  z as CardFooter,
  j as CardHeader,
  K as CardTab,
  I as CardTabHeader,
  m as GettingStarted,
  P as Layouts,
  p as ModernLayout,
  M as SearchButton,
  g as SearchModal,
  E as Sidebar,
  l as createApiReference,
  S as createEmptySpecification,
  h as createScalarReferences,
  i as parse,
  H as useHttpClientStore,
  R as useNavState,
  x as useReactiveSpec,
  y as useSidebar
};

        (function() {
          try {
            if (typeof document === 'undefined' || document.getElementById('scalar-style-api-reference'))
              return

            setTimeout(() => {
              if (getComputedStyle(document.body).getPropertyValue('--scalar-loaded-api-reference') === 'true')
                return

              const elementStyle = document.createElement('style')
              elementStyle.setAttribute('id', 'scalar-style-api-reference')
              elementStyle.appendChild(document.createTextNode(".start[data-v-0f473adb]{padding:24px;display:flex;flex-flow:wrap;justify-content:space-between;position:relative;z-index:0}.swagger-editor .start[data-v-0f473adb]{padding-top:24px}.start-h1[data-v-0f473adb]{font-size:var(--scalar-heading-2);margin-top:0;line-height:1.45;margin-bottom:0;font-weight:var(--scalar-bold);color:var(--scalar-color-1);width:100%;position:relative}.start-h3[data-v-0f473adb]{font-size:var(--scalar-paragraph);margin-top:0;margin-bottom:6px;display:block;line-height:1.45;font-weight:var(--scalar-bold);color:var(--scalar-color-1);width:100%}.start-h1[data-v-0f473adb]:not(:first-of-type){margin-top:24px}.start-p[data-v-0f473adb]{font-size:var(--scalar-paragraph);color:var(--scalar-color-2);line-height:1.5;width:100%;margin-top:12px}.start-ul[data-v-0f473adb]{margin-top:12px;font-size:var(--scalar-paragraph);line-height:1.5;padding-left:0;list-style:initial;display:flex;flex-flow:wrap;gap:24px}.start-ul li[data-v-0f473adb]{margin:0;padding:0;list-style:none;width:calc(50% - 24px);color:var(--scalar-color-2)}.start-ul li[data-v-0f473adb]:first-of-type{margin-top:0}.start-section[data-v-0f473adb]{width:100%;margin-bottom:12px;display:flex;flex-flow:wrap}.start-section[data-v-0f473adb]:last-of-type{margin-bottom:48px}.start-h2[data-v-0f473adb]{background:var(--scalar-background-2);border-top-left-radius:var(--scalar-radius-lg);border-top-right-radius:var(--scalar-radius-lg);border:1px solid var(--scalar-border-color);color:var(--scalar-color-3);font-size:var(--scalar-mini);font-weight:var(--scalar-semibold);padding:9px;width:100%}.start-item[data-v-0f473adb]{align-items:center;background:var(--scalar-background-2);border-right:1px solid var(--scalar-border-color);border-bottom:1px solid var(--scalar-border-color);color:var(--scalar-color-1);cursor:pointer;display:flex;flex:1;font-size:var(--scalar-mini);font-weight:var(--scalar-semibold);padding:9px;text-transform:capitalize;-webkit-user-select:none;-moz-user-select:none;user-select:none}.start-section-integrations .start-item[data-v-0f473adb]:first-of-type{border-bottom-left-radius:var(--scalar-radius-lg);border-left:1px solid var(--scalar-border-color)}.start-section-integrations .start-item[data-v-0f473adb]:last-of-type{border-bottom-right-radius:var(--scalar-radius-lg)}.start-section-colors .start-item[data-v-0f473adb]{min-width:33.33%}.start-section-colors .start-item[data-v-0f473adb]:nth-child(3n+2){border-left:1px solid var(--scalar-border-color)}.start-section-colors .start-item[data-v-0f473adb]:last-of-type,.start-section-colors .start-item-active[data-v-0f473adb]:last-of-type:before{border-radius:0 0 var(--scalar-radius-lg) var(--scalar-radius-lg)}.start-item[data-v-0f473adb]:empty{pointer-events:none}.start-item svg[data-v-0f473adb]{width:14px;height:14px;margin-right:6px}.start-item[data-v-0f473adb]:hover{background:var(--scalar-background-3)}.start-item-active[data-v-0f473adb]{z-index:10;position:relative;color:var(--scalar-color-1)}.start-item-active[data-v-0f473adb]:before{border:1px solid var(--scalar-color-1);content:\"\";top:-1px;right:-1px;bottom:-1px;left:-1px;pointer-events:none;position:absolute}.start-section-color .start-item[data-v-0f473adb]{text-transform:capitalize}.start-cta[data-v-0f473adb]{display:flex;gap:12px;width:100%;margin-top:24px;margin-bottom:0}.start-row[data-v-0f473adb]{width:100%;margin-top:12px;overflow:hidden}.start-hero-copy[data-v-0f473adb]{background:var(--scalar-background-2);padding:12px;border-radius:var(--scalar-radius-lg)}.start-p-small[data-v-0f473adb]{font-weight:var(--scalar-semibold);font-size:var(--scalar-mini);color:var(--scalar-color-2);margin-bottom:12px;line-height:1.4}.start-cta[data-v-0f473adb]{margin-bottom:12px;width:-moz-fit-content;width:fit-content;white-space:nowrap}.start-copy[data-v-0f473adb]{padding:76px 48px 48px;display:flex;justify-content:center;align-items:center;flex-direction:column;text-align:center}.start-logo[data-v-0f473adb]{color:var(--scalar-color-1);margin-bottom:24px;width:72px;aspect-ratio:1;position:relative;box-shadow:var(--scalar-shadow-2);border-radius:50%}.start-logo[data-v-0f473adb]:before{content:\"\";width:300%;aspect-ratio:1;left:-100%;top:-100%;position:absolute;z-index:-1;border-radius:50%;background-size:24px 24px;box-shadow:inset 0 0 50px var(--scalar-background-1),inset 0 0 50px var(--scalar-background-1);background-image:linear-gradient(to right,var(--scalar-border-color) 1px,transparent 1px),linear-gradient(to bottom,var(--scalar-border-color) 1px,transparent 1px)}.start-logo svg[data-v-0f473adb]{width:100%;height:auto;background:var(--scalar-background-1);padding:3px;border-radius:50%;position:relative}@media screen and (max-width: 600px){.start-section-colors .start-item[data-v-0f473adb],.start-item[data-v-0f473adb]{width:100%;border-radius:0;border-right:none;border-top:1px solid var(--scalar-border-color)}.start-item[data-v-0f473adb]:empty{display:none}.start-h2[data-v-0f473adb]{border-bottom:none}.start li[data-v-0f473adb]{width:100%}.start-copy[data-v-0f473adb]{padding:48px 0 24px}}@media screen and (max-width: 1000px){.start[data-v-0f473adb]{padding:0;overflow:auto}}.sidebar-heading-type[data-v-f51e2805]{display:block;min-width:3.9em;overflow:hidden;line-height:14px;flex-shrink:0;color:#fff;color:color-mix(in srgb,var(--method-color, var(--scalar-color-1)),transparent 0%);text-transform:uppercase;font-size:10px;font-weight:var(--scalar-bold);text-align:right;position:relative;font-family:var(--scalar-font-code);white-space:nowrap;margin-left:3px}.sidebar-heading[data-v-efbd2692]{display:flex;gap:6px;color:var(--scalar-sidebar-color-2, var(--scalar-color-2));font-size:var(--scalar-mini);font-weight:var(--scalar-semibold);word-break:break-word;line-height:1.385;max-width:100%;position:relative;cursor:pointer;border-radius:var(--scalar-radius);flex:1;padding-right:9px;-webkit-user-select:none;-moz-user-select:none;user-select:none}.sidebar-heading-link-method[data-v-efbd2692]{margin:0}.sidebar-heading.deprecated .sidebar-heading-link-title[data-v-efbd2692]{text-decoration:line-through}.sidebar-heading-link-title[data-v-efbd2692]{margin:0}.sidebar-heading[data-v-efbd2692]:hover{background:var( --scalar-sidebar-item-hover-background, var(--scalar-background-2) )}.sidebar-heading:hover .sidebar-heading-link-title[data-v-efbd2692]{color:var(--scalar-sidebar-item-hover-color)}.sidebar-heading-link[data-v-efbd2692]:focus-visible{outline:none}.sidebar-heading[data-v-efbd2692]:has(>.sidebar-heading-link:focus-visible){z-index:1;outline:1px solid var(--scalar-color-accent)}.active_page.sidebar-heading[data-v-efbd2692]:hover,.active_page.sidebar-heading[data-v-efbd2692]{color:var(--scalar-sidebar-color-active, var(--scalar-color-accent));background:var( --scalar-sidebar-item-active-background, var(--scalar-background-accent) )}.active_page.sidebar-heading p[data-v-efbd2692]{font-weight:var(--scalar-sidebar-font-weight-active, var(--scalar-semibold))}.active_page.sidebar-heading:hover .sidebar-heading-link-title[data-v-efbd2692]{color:var(--scalar-sidebar-color-active, var(--scalar-color-accent))}.sidebar-indent-nested .sidebar-indent-nested .sidebar-heading[data-v-efbd2692]:before{content:\"\";position:absolute;top:0;left:calc((var(--scalar-sidebar-level) * 12px));width:var(--scalar-border-width);height:100%;background:var(--scalar-sidebar-indent-border)}.sidebar-indent-nested .sidebar-indent-nested .sidebar-heading[data-v-efbd2692]:hover:before{background:var(--scalar-sidebar-indent-border-hover)}.sidebar-indent-nested .sidebar-indent-nested .active_page.sidebar-heading[data-v-efbd2692]:before{background:var(--scalar-sidebar-indent-border-active)}.sidebar-heading-link[data-v-efbd2692]{text-decoration:none;color:inherit;padding:6px 0;display:flex;flex:1;justify-content:space-between;gap:2px}.sidebar-heading p[data-v-efbd2692]{height:-moz-fit-content;height:fit-content;display:flex;align-items:center;font-weight:var(--scalar-sidebar-font-weight, var(--scalar-semibold))}.sidebar-heading p[data-v-efbd2692]:empty{display:none}.link-icon[data-v-efbd2692]{position:relative;left:4px}.sidebar-icon[data-v-efbd2692]{display:flex;align-items:center;justify-content:center;margin-right:6px;width:13px;height:13px}.sidebar-icon>svg[data-v-efbd2692]{width:13px;height:13px}.sidebar-group-item[data-v-efbd2692]{position:relative}.sidebar-heading-chevron[data-v-efbd2692]{margin:5px -5.5px 5px -9px}.sidebar-heading-chevron .toggle-nested-icon[data-v-efbd2692]:focus-visible{outline:none}.sidebar-heading[data-v-efbd2692]:has(.sidebar-heading-chevron .toggle-nested-icon:focus-visible){outline:none;box-shadow:inset 0 0 0 1px var(--scalar-color-accent)}.toggle-nested-icon[data-v-efbd2692]{color:var(--scalar-color-3);width:20px;height:20px;display:flex;align-items:center;justify-content:center}.active_page .toggle-nested-icon[data-v-efbd2692]{color:var(--scalar-sidebar-color-active, var(--scalar-color-accent))}.toggle-nested-icon[data-v-efbd2692]:hover,.toggle-nested-icon[data-v-efbd2692]:focus-visible{color:currentColor}.action-menu[data-v-efbd2692]{position:absolute;top:5px;right:5px;display:flex;gap:6px}.action-menu[data-v-efbd2692] .button-wrapper button{opacity:0;width:20px;height:20px;padding:4px}.action-menu[data-v-efbd2692]:hover .button-wrapper button,.action-menu[data-v-efbd2692] .button-wrapper button:hover,.sidebar-heading:hover~.action-menu[data-v-efbd2692] .button-wrapper button,.action-menu[data-v-efbd2692] .button-wrapper button[aria-expanded=true]{opacity:1}.sidebar-heading[data-v-efbd2692]:has(~.action-menu:hover){color:var(--scalar-sidebar-color-1, var(--scalar-color-1));background:var( --scalar-sidebar-item-hover-background, var(--scalar-background-2) )}.sidebar-group-item__folder[data-v-efbd2692]{color:var(--scalar-sidebar-color-1, var(--scalar-color-1));text-transform:var(--scalar-tag-text-transform, initial)}.sidebar-group[data-v-39c84840]{list-style:none;width:100%;margin:0;padding:0}.sidebar-indent-nested[data-v-39c84840] .sidebar-heading{padding-left:calc((var(--scalar-sidebar-level) * var(--scalar-sidebar-indent-base)) + 12px)!important}.sidebar-indent-nested[data-v-39c84840] .sidebar-heading .toggle-nested-icon{left:calc((var(--scalar-sidebar-level) * var(--scalar-sidebar-indent-base)) + 2px)!important}:where(.sidebar-indent-nested[data-v-39c84840]) .sidebar-heading{color:var(--scalar-sidebar-color-1, var(--scalar-color-1))}:where(.sidebar-indent-nested[data-v-39c84840]) :where(.sidebar-indent-nested) .sidebar-heading{color:var(--scalar-sidebar-color-2, var(--scalar-color-2))}.sidebar[data-v-093edd11]{--scalar-sidebar-indent-base: 12px;--scalar-sidebar-font-weight-active: var(--scalar-semibold);--scalar-sidebar-font-weight: var(--scalar-semibold);flex:1;height:100%;display:flex;flex-direction:column;border-right:var(--scalar-border-width) solid var(--scalar-sidebar-border-color, var(--scalar-border-color));background:var(--scalar-sidebar-background-1, var(--scalar-background-1));--scalar-sidebar-level: 0}.sidebar-pages[data-v-093edd11]{flex:1;padding:9px 12px}@media (max-width: 1000px){.sidebar[data-v-093edd11]{min-height:0;border-right:none}.sidebar-pages[data-v-093edd11]{padding-top:12px}}.sidebar-group-title[data-v-093edd11]{color:var(--scalar-sidebar-color-1);font-size:var(--scalar-mini);padding:12px 6px 6px;font-weight:var(--scalar-semibold);text-transform:uppercase;word-break:break-word;line-height:1.385}.sidebar-group-item+.sidebar-group-title[data-v-093edd11]{border-top:var(--scalar-border-width) solid var(--scalar-sidebar-border-color);margin-top:9px}.show-more[data-v-d3b738d8]{-webkit-appearance:none;-moz-appearance:none;appearance:none;border:none;border:var(--scalar-border-width) solid var(--scalar-border-color);margin:auto;padding:8px 12px 8px 16px;border-radius:30px;color:var(--scalar-color-1);font-weight:var(--scalar-semibold);font-size:var(--scalar-small);display:flex;align-items:center;justify-content:center;position:relative;top:-48px}.show-more[data-v-d3b738d8]:hover{background:var(--scalar-background-2);cursor:pointer}.show-more-icon[data-v-d3b738d8]{width:16px!important;height:16px!important;margin-left:3px}.show-more[data-v-d3b738d8]:active{box-shadow:0 0 0 1px var(--scalar-border-color)}@container narrow-references-container (max-width: 900px){.show-more[data-v-d3b738d8]{top:-24px}}.screenreader-only[data-v-df2e1026]{position:absolute;width:1px;height:1px;padding:0;margin:-1px;overflow:hidden;clip:rect(0,0,0,0);border:0}.section-header-label[data-v-6f7ac329]{display:inline;-webkit-user-select:none;-moz-user-select:none;user-select:none}.endpoint[data-v-03fcdc42]{display:flex;white-space:nowrap;cursor:pointer;text-decoration:none}.endpoint:hover .endpoint-path[data-v-03fcdc42],.endpoint:focus-visible .endpoint-path[data-v-03fcdc42]{text-decoration:underline}.endpoint span[data-v-03fcdc42]:first-of-type{text-transform:uppercase}.endpoint .post[data-v-03fcdc42],.endpoint .get[data-v-03fcdc42],.endpoint .delete[data-v-03fcdc42],.endpoint .put[data-v-03fcdc42]{white-space:nowrap}.endpoint-method[data-v-03fcdc42],.endpoint-path[data-v-03fcdc42]{color:var(--scalar-color-1);min-width:62px;display:inline-block;line-height:1.55;font-family:var(--scalar-font-code);font-size:var(--scalar-small);cursor:pointer}.endpoint-method[data-v-03fcdc42]{text-align:right}.endpoint-path[data-v-03fcdc42]{margin-left:12px;text-transform:initial}.deprecated[data-v-03fcdc42]{text-decoration:line-through}.scalar-card[data-v-b5be456e]{all:unset;font-family:var(--scalar-font);font-size:var(--scalar-font-size-3);border-radius:var(--scalar-radius-lg);overflow:hidden;border:var(--scalar-border-width) solid var(--scalar-border-color);background:var(--scalar-background-2);display:flex;flex-direction:column;max-height:calc(((var(--full-height) - var(--refs-header-height)) - 60px) / 2);position:relative}@media (max-width: 600px){.scalar-card[data-v-b5be456e]{max-height:unset}}.scalar-card-sticky[data-v-b5be456e]{position:sticky;top:calc(var(--refs-header-height) + 24px)}.scalar-card-content[data-v-dd83e46e]{overflow:auto;border-bottom:var(--scalar-border-width) solid var(--scalar-border-color);display:grid}.scalar-card-content[data-v-dd83e46e] .simple-table .simple-header{display:none}.scalar-card-content[data-v-dd83e46e]:last-of-type,.scalar-card-content.scalar-card--borderless[data-v-dd83e46e]{border-bottom:none}.scalar-card--muted[data-v-dd83e46e]{background:var(--scalar-background-2)}.scalar-card--contrast[data-v-dd83e46e]{background:var(--scalar-background-3)}.scalar-card--frameless[data-v-dd83e46e]{padding:0}.scalar-card--transparent[data-v-dd83e46e]{background:var(--scalar-background-1)}.scalar-card-header[data-v-838dc259]{font-weight:var(--scalar-semibold);font-size:var(--scalar-mini);color:var(--scalar-color-3);padding:9px 3px 9px 12px;flex-shrink:0}.scalar-card-header.scalar-card--borderless[data-v-838dc259]+.scalar-card-content{margin-top:-9px}.scalar-card-header-slots[data-v-838dc259]{display:flex;justify-content:space-between;line-height:1.35}.scalar-card-header-title[data-v-838dc259]{text-transform:uppercase;flex:1;min-width:0;text-overflow:ellipsis;overflow:hidden}.scalar-card-header-actions[data-v-838dc259]{display:flex}.endpoints[data-v-324fe114]{overflow:auto;background:var(--scalar-background-2);padding:10px 12px}.section[data-v-f9910af4]{position:relative;display:flex;flex-direction:column;max-width:var(--refs-content-max-width);margin:auto;padding:90px 0;scroll-margin-top:var(--refs-header-height)}.section[data-v-f9910af4]:has(~div.contents){border-bottom:var(--scalar-border-width) solid var(--scalar-border-color)}.references-classic .section[data-v-f9910af4]{padding:48px 0;gap:24px}@container narrow-references-container (max-width: 900px){.references-classic .section[data-v-f9910af4],.section[data-v-f9910af4]{padding:48px 24px}}.section[data-v-f9910af4]:not(:last-of-type){border-bottom:var(--scalar-border-width) solid var(--scalar-border-color)}.loading[data-v-c90b2c46]{background:var(--scalar-background-3);animation:loading-skeleton-c90b2c46 1.5s infinite alternate;border-radius:var(--scalar-radius-lg);min-height:1.6em;margin:.6em 0;max-width:100%}.loading[data-v-c90b2c46]:first-of-type{min-height:3em;margin-bottom:24px;margin-top:0}.loading[data-v-c90b2c46]:last-of-type{width:60%}.loading.single-line[data-v-c90b2c46]{min-height:3em;margin:.6em 0;max-width:80%}@keyframes loading-skeleton-c90b2c46{0%{opacity:1}to{opacity:.33}}.section-header-wrapper[data-v-2f429af7]{display:grid;grid-template-columns:1fr}@media (min-width: 1200px){.section-header-wrapper[data-v-2f429af7]{grid-template-columns:repeat(2,1fr)}}.section-header[data-v-2f429af7]{font-size:var(--font-size, var(--scalar-heading-2));font-weight:var(--font-weight, var(--scalar-bold));color:var(--scalar-color-1);word-wrap:break-word;line-height:1.45;margin-top:0;margin-bottom:12px}.section-header.tight[data-v-2f429af7]{margin-bottom:6px}.section-header.loading[data-v-2f429af7]{width:80%}.label[data-v-498e73bd]{position:relative;display:inline-block;word-break:break-all}.anchor[data-v-498e73bd]{position:relative;display:inline-block;opacity:0}.anchor-copy[data-v-498e73bd]{position:absolute;left:0;top:50%;transform:translateY(-50%);cursor:pointer;padding:0 6px;color:var(--scalar-color-3);font-weight:var(--scalar-semibold);font-size:.8em}.anchor-copy[data-v-498e73bd]:hover,.anchor-copy[data-v-498e73bd]:focus-visible{color:var(--scalar-color-2)}.label:hover .anchor[data-v-498e73bd],.label:has(:focus-visible) .anchor[data-v-498e73bd]{opacity:1}@container narrow-references-container (max-width: 900px){.section-content--with-columns[data-v-9735459e]{flex-direction:column;gap:24px}}.section-columns[data-v-8b9602bf]{display:flex;gap:48px}@container narrow-references-container (max-width: 900px){.section-columns[data-v-8b9602bf]{flex-direction:column;gap:24px}}.section-column[data-v-699c28e3]{flex:1;min-width:0}@container narrow-references-container (max-width: 900px){.section-column[data-v-699c28e3]:nth-of-type(2){padding-top:0}}.section-container[data-v-3afcb4e7]{position:relative;padding:0 60px;width:100%;border-top:var(--scalar-border-width) solid var(--scalar-border-color)}.section-container[data-v-3afcb4e7]:has(.introduction-section){border-top:none}@container narrow-references-container (max-width: 900px){.section-container[data-v-3afcb4e7]{padding:0}}.section-container[data-v-e5f682e5]{border-top:var(--scalar-border-width) solid var(--scalar-border-color)}.section-container[data-v-e5f682e5]:has(.show-more){background-color:color-mix(in srgb,var(--scalar-background-2),transparent)}.operation-path[data-v-ec6c8861]{overflow:hidden;word-wrap:break-word;font-weight:var(--scalar-semibold);line-break:anywhere}.deprecated[data-v-ec6c8861]{text-decoration:line-through}.schema-type-icon[data-v-e45fe752]{color:var(--scalar-color-1);display:none}.schema-type[data-v-e45fe752]{font-family:var(--scalar-font-code);color:var(--scalar-color-1)}.error[data-v-8c9c6e0d]{background-color:var(--scalar-color-red)}.schema-card[data-v-8c9c6e0d]{z-index:0;font-size:var(--scalar-font-size-4);color:var(--scalar-color-1)}.schema-card-title[data-v-8c9c6e0d]{height:var(--schema-title-height);padding:6px 8px;display:flex;align-items:center;gap:4px;color:var(--scalar-color-2);font-weight:var(--scalar-semibold);font-size:var(--scalar-micro);border-bottom:var(--scalar-border-width) solid transparent}button.schema-card-title[data-v-8c9c6e0d]{cursor:pointer}button.schema-card-title[data-v-8c9c6e0d]:hover{color:var(--scalar-color-1)}.schema-card-title-icon--open[data-v-8c9c6e0d]{transform:rotate(45deg)}.schema-properties-open>.schema-card-title[data-v-8c9c6e0d]{border-bottom-left-radius:0;border-bottom-right-radius:0;border-bottom:var(--scalar-border-width) solid var(--scalar-border-color)}.schema-properties-open>.schema-properties[data-v-8c9c6e0d]{width:-moz-fit-content;width:fit-content}.schema-card-description+.schema-properties[data-v-8c9c6e0d]{width:-moz-fit-content;width:fit-content;margin-top:8px}.schema-properties-open.schema-properties[data-v-8c9c6e0d],.schema-properties-open>.schema-card--open[data-v-8c9c6e0d]{width:100%}.schema-properties[data-v-8c9c6e0d]{display:flex;flex-direction:column;border:var(--scalar-border-width) solid var(--scalar-border-color);border-radius:var(--scalar-radius-xl);width:-moz-fit-content;width:fit-content}.schema-properties-name[data-v-8c9c6e0d]{width:100%}.schema-properties .schema-properties[data-v-8c9c6e0d]{border-radius:13.5px}.schema-properties .schema-properties.schema-properties-open[data-v-8c9c6e0d]{border-radius:var(--scalar-radius-lg)}.schema-properties-open[data-v-8c9c6e0d]{width:100%}.schema-card--compact[data-v-8c9c6e0d]{align-self:flex-start}.schema-card--compact.schema-card--open[data-v-8c9c6e0d]{align-self:initial}.schema-card-title--compact[data-v-8c9c6e0d]{color:var(--scalar-color-2);padding:6px 8px;height:auto;border-bottom:none}.schema-card--compact>.schema-properties[data-v-8c9c6e0d],.schema-card-title--compact[data-v-8c9c6e0d]{border-radius:13.5px}.schema-card-title--compact>.schema-card-title-icon[data-v-8c9c6e0d]{margin:0}.schema-card-title--compact>.schema-card-title-icon--open[data-v-8c9c6e0d]{transform:rotate(45deg)}.schema-properties-open>.schema-card-title--compact[data-v-8c9c6e0d]{position:static}.schema-card--compact.schema-card--level-0>.schema-properties[data-v-8c9c6e0d]{border:none}[data-v-8c9c6e0d] .schema-card-description p{font-size:var(--scalar-mini, var(--scalar-paragraph));color:var(--scalar-color-2);line-height:1.5;display:block;margin-bottom:6px}.children .schema-card-description[data-v-8c9c6e0d]:first-of-type{padding-top:0}.discriminator-panel[data-v-0e658f97]:has(.property--compact){border:var(--scalar-border-width) solid var(--scalar-border-color);border-bottom-left-radius:var(--scalar-radius-lg);border-bottom-right-radius:var(--scalar-radius-lg)}.discriminator-panel[data-v-0e658f97] .schema-properties .schema-properties-open{border-top-left-radius:0;border-top-right-radius:0}.discriminator-panel[data-v-0e658f97] .property--level-0,.discriminator-panel[data-v-0e658f97] .property--compact.property--level-1{padding:8px}.discriminator-panel[data-v-0e658f97] .property--compact.property--level-0{padding:0}.schema-tab[data-v-0e658f97]{background:none;border:none;font-size:var(--scalar-mini);font-family:var(--scalar-font);color:var(--scalar-color-2);font-weight:var(--scalar-semibold);line-height:calc(var(--scalar-mini) + 2px);white-space:nowrap;cursor:pointer;padding:0;line-height:1.35;position:relative}.schema-tab[data-v-0e658f97]:before{content:\"\";position:absolute;z-index:0;left:-4px;top:-4px;width:calc(100% + 8px);height:calc(100% + 8px);border-radius:var(--scalar-radius);background:var(--scalar-background-2);opacity:0}.schema-tab[data-v-0e658f97]:hover:before{opacity:1}.schema-tab-selected[data-v-0e658f97]{color:var(--scalar-color-1);text-decoration:underline;text-underline-offset:8px}.property-example[data-v-d7f5eefa]{display:flex;flex-direction:column;font-size:var(--scalar-micro);position:relative}.property-example[data-v-d7f5eefa]:hover:before{content:\"\";position:absolute;top:0;left:0;width:100%;height:20px;border-radius:var(--scalar-radius)}.property-example:hover .property-example-label span[data-v-d7f5eefa]{color:var(--scalar-color-1)}.property-example-label span[data-v-d7f5eefa]{color:var(--scalar-color-3);position:relative;border-bottom:var(--scalar-border-width) dotted currentColor}.property-example-value[data-v-d7f5eefa]{font-family:var(--scalar-font-code);display:flex;align-items:center;width:100%;padding:6px}.property-example-value span[data-v-d7f5eefa]{display:block;overflow:hidden;text-overflow:ellipsis;white-space:nowrap}.property-example-value[data-v-d7f5eefa] svg{color:var(--scalar-color-3)}.property-example-value[data-v-d7f5eefa]:hover svg{color:var(--scalar-color-1)}.property-example-value[data-v-d7f5eefa]{background:var(--scalar-background-2);border:var(--scalar-border-width) solid var(--scalar-border-color);border-radius:var(--scalar-radius)}.property-example-value-list[data-v-d7f5eefa]{position:absolute;top:18px;left:50%;transform:translate3d(-50%,0,0);overflow:auto;background-color:var(--scalar-background-1);box-shadow:var(--scalar-shadow-1);border-radius:var(--scalar-radius-lg);border:var(--scalar-border-width) solid var(--scalar-border-color);padding:9px;min-width:200px;max-width:300px;flex-direction:column;gap:3px;display:none;z-index:10}.property-example:hover .property-example-value-list[data-v-d7f5eefa],.property-example:focus-within .property-example-value-list[data-v-d7f5eefa]{display:flex}.property-detail[data-v-3ae98a1b]{display:inline-flex}.property-detail+.property-detail[data-v-3ae98a1b]:before{display:block;content:\"·\";margin:0 .5ch}.property-detail-truncate[data-v-3ae98a1b]{overflow:hidden}.property-detail-truncate>.property-detail-value[data-v-3ae98a1b]{overflow:hidden;text-overflow:ellipsis}.property-detail-prefix[data-v-3ae98a1b]{color:var(--scalar-color-2)}code.property-detail-value[data-v-3ae98a1b]{font-family:var(--scalar-font-code);font-size:var(--scalar-font-size-3);color:var(--scalar-color-2);background:var(--scalar-background-3);padding:0 4px;border:.5px solid var(--scalar-border-color);border-radius:var(--scalar-radius)}.badge[data-v-190574ac]{color:var(--scalar-color-2);font-size:var(--scalar-micro);background:var(--scalar-background-2);padding:2px 6px;border-radius:12px;font-weight:var(--scalar-semibold);display:inline-block;text-transform:uppercase}.property-heading[data-v-eb77468c]{display:flex;flex-wrap:wrap;align-items:baseline;row-gap:9px;white-space:nowrap}.property-heading[data-v-eb77468c]:has(+.children),.property-heading[data-v-eb77468c]:has(+.property-rule){margin-bottom:9px}.property-heading[data-v-eb77468c]>*{margin-right:9px}.property-heading[data-v-eb77468c]:last-child{margin-right:0}.property-heading>.property-detail[data-v-eb77468c]:not(:last-of-type){margin-right:0}.property-name[data-v-eb77468c]{font-family:var(--scalar-font-code);font-weight:var(--scalar-semibold);font-size:var(--scalar-font-size-3);display:flex}.property-additional[data-v-eb77468c]{font-family:var(--scalar-font-code)}.property-required[data-v-eb77468c],.property-optional[data-v-eb77468c]{color:var(--scalar-color-2)}.property-required[data-v-eb77468c]{font-size:var(--scalar-micro);color:var(--scalar-color-orange)}.property-read-only[data-v-eb77468c]{font-size:var(--scalar-micro);color:var(--scalar-color-blue)}.property-write-only[data-v-eb77468c]{font-size:var(--scalar-micro);color:var(--scalar-color-green)}.property-detail[data-v-eb77468c]{font-size:var(--scalar-micro);color:var(--scalar-color-2);display:flex;align-items:center;min-width:0}.property-const[data-v-eb77468c]{color:var(--scalar-color-1)}.deprecated[data-v-eb77468c]{text-decoration:line-through}.property[data-v-aa19e2e1]{color:var(--scalar-color-1);display:flex;flex-direction:column;padding:12px 8px;font-size:var(--scalar-mini);position:relative}.property[data-v-aa19e2e1]:hover{z-index:1}.property--compact.property--level-0[data-v-aa19e2e1],.property--compact.property--level-1[data-v-aa19e2e1]{padding:12px 0}.property[data-v-aa19e2e1]:has(>.property-rule:nth-of-type(1)){padding-top:0}.property[data-v-aa19e2e1]:has(>.property-rule:nth-of-type(1) .discriminator-tab-list),.property[data-v-aa19e2e1]:has(>.property-rule:nth-of-type(1) .discriminator-panel){padding:8px}.property--deprecated[data-v-aa19e2e1]{background:repeating-linear-gradient(-45deg,var(--scalar-background-2) 0,var(--scalar-background-2) 2px,transparent 2px,transparent 5px);background-size:100%}.property--deprecated[data-v-aa19e2e1]>*{opacity:.75}.property-description[data-v-aa19e2e1]{margin-top:6px;line-height:1.4;font-size:var(--scalar-small)}.property-heading:empty+.property-description[data-v-aa19e2e1]:last-of-type,.property-description[data-v-aa19e2e1]:first-of-type:last-of-type{margin-top:0}.property-description[data-v-aa19e2e1]:has(+.property-rule){margin-bottom:9px}[data-v-aa19e2e1] .property-description *{color:var(--scalar-color-2)!important}.property[data-v-aa19e2e1]:not(:last-of-type){border-bottom:var(--scalar-border-width) solid var(--scalar-border-color)}.property-description+.children[data-v-aa19e2e1]{margin-top:9px}.children[data-v-aa19e2e1]{display:flex;flex-direction:column}.children .property--compact.property--level-1[data-v-aa19e2e1]{padding:12px}.property-example-value[data-v-aa19e2e1]{all:unset;font-family:var(--scalar-font-code);padding:6px;border-top:var(--scalar-border-width) solid var(--scalar-border-color)}.property-rule[data-v-aa19e2e1],.property-rule[data-v-aa19e2e1]:has(>.discriminator-tab-list) .property-rule .schema-properties.schema-properties-open{border-radius:var(--scalar-radius-lg);display:flex;flex-direction:column}.property-rule[data-v-aa19e2e1]:has(.discriminator-tab-list) .schema-card .schema-properties.schema-properties-open{border-top-left-radius:0;border-top-right-radius:0}.property-rule[data-v-aa19e2e1]:has(.discriminator-tab-list) .children .schema-card .schema-properties.schema-properties-open{border-top-left-radius:var(--scalar-radius-lg);border-top-right-radius:var(--scalar-radius-lg)}.property-enum-value[data-v-aa19e2e1]{color:var(--scalar-color-3);line-height:1.5;word-break:break-word;display:flex;align-items:stretch;position:relative}.property-enum-value-label[data-v-aa19e2e1]{display:flex;padding:3px 0;font-family:var(--scalar-font-code)}.property-enum-value:last-of-type .property-enum-value-label[data-v-aa19e2e1]{padding-bottom:0}.property-enum-value[data-v-aa19e2e1]:before{content:\"\";margin-right:12px;width:var(--scalar-border-width);display:block;background:currentColor;color:var(--scalar-color-3)}.property-enum-value[data-v-aa19e2e1]:after{content:\"\";position:absolute;top:50%;left:0;width:8px;height:var(--scalar-border-width);background:currentColor}.property-enum-value[data-v-aa19e2e1]:last-of-type:after{bottom:0;height:50%;background:var(--scalar-background-1);border-top:var(--scalar-border-width) solid currentColor}.property-enum-values[data-v-aa19e2e1]{margin-top:8px;list-style:none}.property-example[data-v-aa19e2e1]{background:transparent;border:none;display:flex;flex-direction:row;gap:8px}.property-example-label[data-v-aa19e2e1],.property-example-value[data-v-aa19e2e1]{padding:3px 0 0}.property-example-value[data-v-aa19e2e1]{background:var(--scalar-background-2);border-top:0;border-radius:var(--scalar-radius);padding:3px 4px}.property-list[data-v-aa19e2e1]{border:var(--scalar-border-width) solid var(--scalar-border-color);border-radius:var(--scalar-radius);margin-top:10px}.property-list .property[data-v-aa19e2e1]:last-of-type{padding-bottom:10px}.property-name[data-v-aa19e2e1]{font-family:var(--scalar-font-code);font-weight:var(--scalar-semibold)}.enum-toggle-button[data-v-aa19e2e1]{align-items:center;border:var(--scalar-border-width) solid var(--scalar-border-color);border-radius:13.5px;cursor:pointer;color:var(--scalar-color-2);display:flex;font-weight:var(--scalar-semibold);gap:4px;margin-top:8px;padding:6px 10px;-webkit-user-select:none;-moz-user-select:none;user-select:none;white-space:nowrap}.enum-toggle-button[data-v-aa19e2e1]:hover{color:var(--scalar-color-1)}.enum-toggle-button-icon--open[data-v-aa19e2e1]{transform:rotate(45deg)}.headers-card[data-v-4e43270c]{z-index:0;margin-top:12px;margin-bottom:6px;position:relative;font-size:var(--scalar-font-size-4);color:var(--scalar-color-1);align-self:flex-start}.headers-card.headers-card--open[data-v-4e43270c]{align-self:initial}.headers-card-title[data-v-4e43270c]{padding:6px 10px;display:flex;align-items:center;gap:4px;color:var(--scalar-color-3);font-weight:var(--scalar-semibold);font-size:var(--scalar-micro);border-radius:13.5px}button.headers-card-title[data-v-4e43270c]{cursor:pointer}button.headers-card-title[data-v-4e43270c]:hover{color:var(--scalar-color-1)}.headers-card-title-icon--open[data-v-4e43270c]{transform:rotate(45deg)}.headers-properties-open>.headers-card-title[data-v-4e43270c]{border-bottom-left-radius:0;border-bottom-right-radius:0;border-bottom:var(--scalar-border-width) solid var(--scalar-border-color)}.headers-properties-open[data-v-4e43270c]{width:100%}.headers-properties[data-v-4e43270c]{display:flex;flex-direction:column;border:var(--scalar-border-width) solid var(--scalar-border-color);border-radius:13.5px;width:-moz-fit-content;width:fit-content}.headers-card .property[data-v-4e43270c]:last-of-type{padding-bottom:10px}.headers-card-title>.headers-card-title-icon[data-v-4e43270c]{width:10px;height:10px;margin:0}.headers-card-title>.headers-card-title-icon--open[data-v-4e43270c]{transform:rotate(45deg)}.parameter-item[data-v-7ad4f6c6]{display:flex;flex-direction:column;border-top:var(--scalar-border-width) solid var(--scalar-border-color)}.parameter-item:last-of-type .parameter-schema[data-v-7ad4f6c6]{padding-bottom:0}.parameter-item-container[data-v-7ad4f6c6]{padding:0}.parameter-item-headers[data-v-7ad4f6c6]{border:var(--scalar-border-width) solid var(--scalar-border-color)}.parameter-item-name[data-v-7ad4f6c6]{margin-right:6px;font-weight:var(--scalar-semibold);font-size:var(--scalar-font-size-3);font-family:var(--scalar-font-code);color:var(--scalar-color-1)}.parameter-item-type[data-v-7ad4f6c6]{font-size:var(--scalar-micro);color:var(--scalar-color-2);margin-right:6px;line-height:1.4;white-space:nowrap;text-overflow:ellipsis;width:100%;overflow:hidden}.parameter-item-trigger-open .parameter-item-type[data-v-7ad4f6c6]{white-space:normal}.parameter-item-trigger+.parameter-item-container[data-v-7ad4f6c6] .property--level-0>.property-heading .property-detail-value{font-size:var(--scalar-font-size-3)}.parameter-item-required-optional[data-v-7ad4f6c6]{color:var(--scalar-color-2);font-weight:var(--scalar-semibold);margin-right:6px;position:relative}.parameter-item--required[data-v-7ad4f6c6]{text-transform:uppercase;font-size:var(--scalar-micro);font-weight:var(--scalar-semibold);color:var(--scalar-color-orange)}.parameter-item-description[data-v-7ad4f6c6]{margin-top:3px!important;font-size:var(--scalar-small);color:var(--scalar-color-2);line-height:1.4}.parameter-item-description[data-v-7ad4f6c6] p{margin-top:4px;font-size:var(--scalar-small);color:var(--scalar-color-2);line-height:1.4}.parameter-schema[data-v-7ad4f6c6]{padding-bottom:9px;margin-top:3px}.parameter-item-trigger[data-v-7ad4f6c6]{padding:12px 0;cursor:pointer;outline:none;text-align:left;position:relative;align-items:baseline}.parameter-item-trigger-open[data-v-7ad4f6c6]{padding-bottom:0}.parameter-item-trigger[data-v-7ad4f6c6]:after{content:\"\";position:absolute;height:10px;width:100%;bottom:0}.parameter-item-icon[data-v-7ad4f6c6]{color:var(--scalar-color-3);height:18px;left:-19px;position:absolute;top:11px;width:18px}.parameter-item-trigger:hover .parameter-item-icon[data-v-7ad4f6c6],.parameter-item-trigger:focus-visible .parameter-item-icon[data-v-7ad4f6c6]{color:var(--scalar-color-1)}.parameter-item-trigger:focus-visible .parameter-item-icon[data-v-7ad4f6c6]{outline:1px solid var(--scalar-color-accent);outline-offset:2px;border-radius:var(--scalar-radius)}.parameter-list[data-v-2463df20]{margin-top:24px}.parameter-list-title[data-v-2463df20]{font-size:var(--scalar-font-size-2);font-weight:var(--scalar-semibold);color:var(--scalar-color-1);line-height:1.45;margin-top:12px;margin-bottom:12px}.parameter-list-items[data-v-2463df20]{list-style:none;padding:0;margin:0 0 12px;font-size:var(--scalar-small)}.request-body-title[data-v-1aa0f610]{display:flex;align-items:center;justify-content:space-between;font-size:var(--scalar-font-size-2);font-weight:var(--scalar-semibold);color:var(--scalar-color-1);margin-top:24px;padding-bottom:12px;border-bottom:var(--scalar-border-width) solid var(--scalar-border-color);flex-flow:wrap}.request-body-title-select[data-v-1aa0f610]{position:relative;height:-moz-fit-content;height:fit-content;margin-left:auto;font-weight:var(--scalar-regular);display:flex;align-items:center;color:var(--scalar-color-3);font-size:var(--scalar-micro);background:var(--scalar-background-2);padding:2px 6px;border-radius:12px;border:var(--scalar-border-width) solid var(--scalar-border-color)}.request-body-title-no-select.request-body-title-select[data-v-1aa0f610]{pointer-events:none}.request-body-title-no-select[data-v-1aa0f610]{border:none}.request-body-title-no-select.request-body-title-select[data-v-1aa0f610]:after{display:none}.request-body-title-select span[data-v-1aa0f610]{display:flex;align-items:center}.request-body-title-select[data-v-1aa0f610]:after{content:\"\";width:6px;height:6px;transform:rotate(45deg) translate3d(0,-3px,0);display:block;margin-left:6px;box-shadow:1px 1px 0 currentColor;margin-right:5px}.request-body-title-select select[data-v-1aa0f610]{border:none;outline:none;cursor:pointer;background:var(--scalar-background-3);position:absolute;top:0;left:0;width:100%;height:100%;opacity:0;-webkit-appearance:none;-moz-appearance:none;appearance:none}.request-body-title-select[data-v-1aa0f610]:hover{color:var(--scalar-color-1)}.request-body-title-select[data-v-1aa0f610]:has(select:focus-visible){outline:1px solid var(--scalar-color-accent)}.request-body-description[data-v-1aa0f610]{margin-top:6px;font-size:var(--scalar-small);width:100%}.request-body-description[data-v-1aa0f610] .markdown *{color:var(--scalar-color-2)!important}@media (max-width: 460px){.request-body-title-select[data-v-1aa0f610]{margin-left:auto;padding-right:3px}}.section-wrapper[data-v-07cabcb0]{color:var(--scalar-color-1);padding-top:12px;margin-top:-12px}.section-accordion[data-v-07cabcb0]{display:flex;flex-direction:column;border-radius:var(--scalar-radius-lg);background:var(--scalar-background-2)}.section-accordion-transparent[data-v-07cabcb0]{background:transparent;border:1px solid var(--scalar-border-color)}.section-accordion-button[data-v-07cabcb0]{padding:6px;display:flex;align-items:center;gap:6px;cursor:pointer}.section-accordion-button-content[data-v-07cabcb0]{flex:1;min-width:0}.section-accordion-button-actions[data-v-07cabcb0]{display:flex;align-items:center;gap:6px;color:var(--scalar-color-3)}.section-accordion-chevron[data-v-07cabcb0]{margin-right:4px;width:20px;cursor:pointer;opacity:1;color:var(--scalar-color-3)}.section-accordion-button:hover .section-accordion-chevron[data-v-07cabcb0]{color:var(--scalar-color-1)}.section-accordion-content[data-v-07cabcb0]{border-top:1px solid var(--scalar-border-color);display:flex;flex-direction:column}.section-accordion-description[data-v-07cabcb0]{font-weight:var(--scalar-semibold);font-size:var(--scalar-mini);color:var(--scalar-color--1);padding:10px 12px 0}.section-accordion-content-card[data-v-07cabcb0] .property:last-of-type{padding-bottom:9px}.show-api-client-button[data-v-4263a1c2]{-webkit-appearance:none;-moz-appearance:none;appearance:none;border:none;padding:4px 6px;white-space:nowrap;border-radius:var(--scalar-radius);display:flex;justify-content:center;align-items:center;font-weight:var(--scalar-semibold);font-size:var(--scalar-mini);color:var(--scalar-background-2);font-family:var(--scalar-font);background:var(--scalar-button-1);position:relative;cursor:pointer;box-sizing:border-box;box-shadow:inset 0 0 0 1px #0000001a;outline-offset:2px}.show-api-client-button span[data-v-4263a1c2],.show-api-client-button svg[data-v-4263a1c2]{fill:currentColor;color:var(--scalar-button-1-color);z-index:1}.show-api-client-button[data-v-4263a1c2]:hover{background:var(--scalar-button-1-hover)}.show-api-client-button svg[data-v-4263a1c2]{margin-right:4px}.empty-state[data-v-8261a319]{margin:10px 0 10px 12px;text-align:center;font-size:var(--scalar-micro);min-height:56px;display:flex;align-items:center;justify-content:center;border-radius:var(--scalar-radius-lg);color:var(--scalar-color-2)}.rule-title[data-v-8261a319]{font-family:var(--scalar-font-code);color:var(--scalar-color-1);display:inline-block;margin:12px 0 6px;border-radius:var(--scalar-radius)}.rule[data-v-8261a319]{margin:0 12px;border-radius:var(--scalar-radius-lg)}.rule-items[data-v-8261a319]{counter-reset:list-number;display:flex;flex-direction:column;gap:12px;border-left:1px solid var(--scalar-border-color);padding:12px 0}.rule-item[data-v-8261a319]{counter-increment:list-number;border:1px solid var(--scalar-border-color);border-radius:var(--scalar-radius-lg);overflow:hidden;margin-left:24px}.rule-item[data-v-8261a319]:before{border:1px solid var(--scalar-border-color);border-top:0;border-right:0;content:\" \";display:block;width:24px;height:6px;border-radius:0 0 0 var(--scalar-radius-lg);margin-top:6px;color:var(--scalar-color-2);transform:translate(-25px);color:var(--scalar-color-1);position:absolute}.tab-list[data-v-03fdb072]{display:flex;gap:6px;position:relative;flex:1;padding:9px 12px;overflow:auto}.scalar-card-header.scalar-card-header-tabs[data-v-03fdb072]{padding:0}.tab[data-v-d0e07e65]{background:none;border:none;font-size:var(--scalar-mini);font-family:var(--scalar-font);color:var(--scalar-color-2);font-weight:var(--scalar-semibold);line-height:calc(var(--scalar-mini) + 2px);white-space:nowrap;cursor:pointer;padding:0;margin-right:3px;text-transform:uppercase;position:relative;line-height:1.35}.tab[data-v-d0e07e65]:before{content:\"\";position:absolute;z-index:0;left:-6px;top:-6px;width:calc(100% + 12px);height:calc(100% + 12px);border-radius:var(--scalar-radius);background:var(--scalar-background-3);opacity:0}.tab[data-v-d0e07e65]:hover:before,.tab[data-v-d0e07e65]:focus-visible:before{opacity:1}.tab[data-v-d0e07e65]:focus-visible:before{outline:1px solid var(--scalar-color-accent)}.tab span[data-v-d0e07e65]{z-index:1;position:relative}.tab-selected[data-v-d0e07e65]{color:var(--scalar-color-1);text-decoration:underline;text-underline-offset:var(--scalar-micro)}.scalar-card-footer[data-v-7621d1be]{flex-shrink:0}.text-select{position:relative;height:-moz-fit-content;height:fit-content}.text-select:has(:focus-visible) .text-select-label{outline:1px solid var(--scalar-color-accent);outline-offset:4px;border-radius:calc(var(--scalar-radius) / 2)}.text-select--single-option{pointer-events:none}.text-select select{border:none;outline:none;cursor:pointer;background:var(--scalar-background-3);box-shadow:-2px 0 0 0 var(--scalar-background-3);position:absolute;top:0;left:0;width:100%;height:100%;opacity:0;-moz-appearance:none;-webkit-appearance:none;appearance:none}.text-select span{font-size:var(--scalar-mini);color:var(--scalar-color-2);font-weight:var(--scalar-semibold);white-space:nowrap;display:flex;align-items:center;justify-content:center}.text-select:hover span{color:var(--scalar-color-1)}.text-select:not(.text-select--single-option) span:after{content:\"\";width:7px;height:7px;transform:rotate(45deg) translate3d(-2px,-2px,0);display:block;margin-left:6px;box-shadow:1px 1px 0 currentColor}.text-select span:hover{background:var(--scalar-background-2)}.example-selector[data-v-a7e22e14]{padding:4px}.markdown[data-v-027e0301] *{margin:0}.code-copy[data-v-027e0301]{display:flex;align-items:center;justify-content:center;-moz-appearance:none;appearance:none;-webkit-appearance:none;outline:none;background:transparent;cursor:pointer;color:var(--scalar-color-3);border:none;padding:0;margin-right:12px}.code-copy[data-v-027e0301]:hover{color:var(--scalar-color-1)}.code-copy svg[data-v-027e0301]{width:13px;height:13px}.response-card-footer[data-v-027e0301]{display:flex;flex-direction:column;flex-shrink:0;padding:10px 12px;gap:8px;border-top:var(--scalar-border-width) solid var(--scalar-border-color)}.response-example-selector[data-v-027e0301]{align-self:flex-start;margin:-4px}.response-description[data-v-027e0301]{font-weight:var(--scalar-semibold);font-size:var(--scalar-micro);color:var(--scalar-color--1);display:flex;align-items:center;box-sizing:border-box}.schema-type[data-v-027e0301]{font-size:var(--scalar-micro);color:var(--scalar-color-2);font-weight:var(--scalar-semibold);background:var(--scalar-background-3);padding:2px 4px;border-radius:4px;margin-right:4px}.schema-example[data-v-027e0301]{font-size:var(--scalar-micro);color:var(--scalar-color-2);font-weight:var(--scalar-semibold)}.example-response-tab[data-v-027e0301]{display:block;margin:6px}.scalar-card-container[data-v-027e0301]{flex:1;background:var(--scalar-background-2);display:grid}.scalar-card-container[data-v-027e0301] .cm-scroller{overflow-y:hidden}.scalar-card-checkbox[data-v-027e0301]{display:flex;align-items:center;justify-content:center;position:relative;min-height:17px;cursor:pointer;-webkit-user-select:none;-moz-user-select:none;user-select:none;font-weight:var(--scalar-semibold);font-size:var(--scalar-mini);color:var(--scalar-color-2);width:-moz-fit-content;width:fit-content;white-space:nowrap;margin-right:9px;gap:6px}.scalar-card-checkbox:has(.scalar-card-checkbox-input:focus-visible) .scalar-card-checkbox-checkmark[data-v-027e0301]{outline:1px solid var(--scalar-color-accent)}.scalar-card-checkbox[data-v-027e0301]:hover{color:var(--scalar-color--1)}.scalar-card-checkbox .scalar-card-checkbox-input[data-v-027e0301]{position:absolute;opacity:0;cursor:pointer;height:0;width:0}.scalar-card-checkbox-checkmark[data-v-027e0301]{height:17px;width:17px;border-radius:var(--scalar-radius);background-color:transparent;background-color:var(--scalar-background-3);box-shadow:inset 0 0 0 1px var(--scalar-border-color)}.scalar-card-checkbox[data-v-027e0301]:has(.scalar-card-checkbox-input:checked){color:var(--scalar-color-1)}.scalar-card-checkbox .scalar-card-checkbox-input:checked~.scalar-card-checkbox-checkmark[data-v-027e0301]{background-color:var(--scalar-button-1);box-shadow:none}.scalar-card-checkbox-checkmark[data-v-027e0301]:after{content:\"\";position:absolute;display:none}.scalar-card-checkbox .scalar-card-checkbox-input:checked~.scalar-card-checkbox-checkmark[data-v-027e0301]:after{display:block}.scalar-card-checkbox .scalar-card-checkbox-checkmark[data-v-027e0301]:after{right:6px;top:36.5%;width:5px;height:9px;border:solid 1px var(--scalar-button-1-color);border-width:0 1.5px 1.5px 0;transform:rotate(45deg)}.request[data-v-6d5ec039]{display:flex;flex-wrap:nowrap}.request-header[data-v-6d5ec039]{display:flex;gap:6px;text-transform:initial}.request-method[data-v-6d5ec039]{font-family:var(--scalar-font-code);text-transform:uppercase}.request-client-picker[data-v-6d5ec039]{padding-left:12px;padding-right:9px}.request-card-footer[data-v-6d5ec039]{display:flex;justify-content:flex-end;padding:6px;flex-shrink:0}.request-card-footer-addon[data-v-6d5ec039]{display:flex;align-items:center;flex:1;min-width:0}.request-editor-section[data-v-6d5ec039]{display:flex;flex:1}.request-card-simple[data-v-6d5ec039]{display:flex;align-items:center;justify-content:space-between;padding:8px 8px 8px 12px;font-size:var(--scalar-small)}.code-snippet[data-v-6d5ec039]{display:flex;flex-direction:column;width:100%}.operation-title[data-v-7af92164]{display:flex;justify-content:space-between}.operation-details[data-v-7af92164]{display:flex;align-items:center;margin-top:0;gap:9px;min-width:0;flex-shrink:1}.endpoint-type[data-v-7af92164]{display:flex;align-items:center;justify-content:center;gap:6px;position:relative;z-index:0;width:60px;padding:6px;flex-shrink:0;font-size:var(--scalar-small);text-transform:uppercase;font-weight:var(--scalar-bold);font-family:var(--scalar-font)}.endpoint-type[data-v-7af92164]:after{content:\"\";position:absolute;top:0;right:0;bottom:0;left:0;z-index:-1;background:currentColor;opacity:.15;border-radius:var(--scalar-radius-lg)}.endpoint-anchor[data-v-7af92164]{display:flex;align-items:center;min-width:0;flex-shrink:1;font-size:20px}.endpoint-anchor.label[data-v-7af92164]{display:flex}.endpoint-label[data-v-7af92164]{display:flex;align-items:baseline;gap:9px;min-width:0;flex-shrink:1;color:var(--scalar-color-1)}.endpoint-label-path[data-v-7af92164]{font-family:var(--scalar-font-code);font-size:var(--scalar-mini);text-overflow:ellipsis;white-space:nowrap;overflow:hidden}.endpoint-label-path[data-v-7af92164] em{color:var(--scalar-color-2)}.endpoint-label-name[data-v-7af92164]{color:var(--scalar-color-2);font-size:var(--scalar-small);flex-shrink:1000000000;text-overflow:ellipsis;white-space:nowrap;overflow:hidden}.endpoint-try-hint[data-v-7af92164]{padding:2px;height:24px;width:24px;flex-shrink:0}.endpoint-copy[data-v-7af92164]{color:currentColor;padding:2px}.endpoint-copy[data-v-7af92164] svg{stroke-width:2px}.endpoint-content[data-v-7af92164]{display:grid;grid-auto-columns:1fr;grid-auto-flow:row;gap:9px;padding:9px}@media (min-width: 1000px){.endpoint-content[data-v-7af92164]{grid-auto-flow:column}}@container (max-width: 900px){.endpoint-content[data-v-7af92164]{grid-template-columns:1fr}}.endpoint-content[data-v-7af92164]>*{max-height:unset}.operation-details-card[data-v-7af92164]{display:flex;flex-direction:column;gap:12px}.operation-details-card-item[data-v-7af92164] .parameter-list{border:1px solid var(--scalar-border-color);border-radius:var(--scalar-radius-lg);margin-top:0}.operation-details-card-item[data-v-7af92164]{display:flex;flex-direction:column;gap:12px}.operation-details-card-item[data-v-7af92164] .parameter-list-items{margin-bottom:0}.operation-details-card[data-v-7af92164] .parameter-item:last-of-type .parameter-schema{padding-bottom:12px}.operation-details-card[data-v-7af92164] .parameter-list .parameter-list{margin-bottom:12px}.operation-details-card[data-v-7af92164] .parameter-item{margin:0;padding:0 9px}.operation-details-card[data-v-7af92164] .property{padding:9px;margin:0}.operation-details-card[data-v-7af92164] .parameter-list-title,.operation-details-card[data-v-7af92164] .request-body-title{text-transform:uppercase;font-weight:var(--scalar-bold);font-size:var(--scalar-mini);color:var(--scalar-color-2);line-height:1.33;padding:9px;margin:0}.operation-details-card[data-v-7af92164] .request-body-title-select{text-transform:initial;font-weight:initial;margin-left:auto}.examples[data-v-795f44b1]{position:sticky;top:calc(var(--refs-header-height) + 24px)}.deprecated[data-v-795f44b1] *{text-decoration:line-through}.example-path[data-v-795f44b1]{color:var(--scalar-color-2);font-family:var(--scalar-font-code)}.example-path[data-v-795f44b1] em{color:var(--scalar-color-1);font-style:normal}.references-loading{position:absolute;top:0;left:0;right:0;z-index:1;grid-area:rendered;background:var(--scalar-background-1)}.references-loading-top-spacer{top:-1px}.references-loading-hidden-tag .section-container>.section:first-child{display:none}.download[data-v-227fe8c2]{margin-bottom:24px}.download-button[data-v-227fe8c2]{color:var(--scalar-link-color, var(--scalar-color-accent));font-weight:var(--scalar-link-font-weight, inherit);-webkit-text-decoration:var(--scalar-text-decoration)!important;text-decoration:var(--scalar-text-decoration)!important;text-decoration-color:var(--scalar-text-decoration-color);font-size:var(--scalar-paragraph);cursor:pointer}.download-button[data-v-227fe8c2]:hover{color:var(--scalar-link-color-hover, var(--scalar-color-accent));-webkit-text-decoration:var(--scalar-text-decoration-hover)!important;text-decoration:var(--scalar-text-decoration-hover)!important;text-decoration-color:var(--scalar-text-decoration-color-hover)}.introduction-description-heading[data-v-62dad0f5]{scroll-margin-top:64px;margin-top:1em;margin-bottom:.5em}.markdown+.markdown[data-v-62dad0f5]{margin-top:1em}.introduction-description[data-v-62dad0f5]{display:flex;flex-direction:column}.references-classic .introduction-description[data-v-62dad0f5] img{max-width:720px}.sticky-cards[data-v-1f5477ab]{display:flex;flex-direction:column;position:sticky;top:calc(var(--refs-header-height) + 24px)}.client-libraries-content[data-v-217691d9]{container:client-libraries-content / inline-size;display:flex;justify-content:center;overflow:hidden;padding:0 12px;background-color:var(--scalar-background-1);border-top:var(--scalar-border-width) solid var(--scalar-border-color)}.client-libraries[data-v-217691d9]{display:flex;align-items:center;justify-content:center;width:100%;position:relative;cursor:pointer;white-space:nowrap;padding:8px 2px;gap:6px;color:var(--scalar-color-3);border-bottom:1px solid transparent;-webkit-user-select:none;-moz-user-select:none;user-select:none}.client-libraries[data-v-217691d9]:first-child{border-radius:var(--scalar-radius) 0 0 0}.client-libraries[data-v-217691d9]:not(.client-libraries__active):hover:before{content:\"\";position:absolute;width:calc(100% - 4px);height:calc(100% - 4px);background:var(--scalar-background-2);left:2px;top:2px;z-index:0;border-radius:var(--scalar-radius)}.client-libraries[data-v-217691d9]:active{color:var(--scalar-color-1)}.client-libraries[data-v-217691d9]:focus-visible{outline:none;box-shadow:inset 0 0 0 1px var(--scalar-color-accent)}@media screen and (max-width: 450px){.client-libraries[data-v-217691d9]:nth-of-type(4),.client-libraries[data-v-217691d9]:nth-of-type(5){display:none}}.client-libraries-icon[data-v-217691d9]{max-width:14px;max-height:14px;min-width:14px;width:100%;aspect-ratio:1;display:flex;align-items:center;justify-content:center;position:relative;box-sizing:border-box;color:currentColor}.client-libraries-icon__more svg[data-v-217691d9]{height:initial}@container client-libraries-content (width < 400px){.client-libraries__select[data-v-217691d9]{width:-moz-fit-content;width:fit-content}.client-libraries__select .client-libraries-icon__more+span[data-v-217691d9]{display:none}}@container client-libraries-content (width < 380px){.client-libraries[data-v-217691d9]{width:100%}.client-libraries span[data-v-217691d9]{display:none}}.client-libraries__active[data-v-217691d9]{color:var(--scalar-color-1);border-bottom:1px solid var(--scalar-color-1)}@keyframes codeloader-217691d9{0%{transform:rotate(0)}to{transform:rotate(1turn)}}.client-libraries .client-libraries-text[data-v-217691d9]{font-size:var(--scalar-mini);font-weight:var(--scalar-semibold);position:relative;display:flex;align-items:center}.client-libraries__active .client-libraries-text[data-v-217691d9]{color:var(--scalar-color-1)}.client-libraries__select select[data-v-217691d9]{background:var(--scalar-background-3);color:var(--scalar-color-2);opacity:0;height:100%;width:100%;aspect-ratio:1;position:absolute;top:0;left:0;cursor:pointer;z-index:1;-webkit-appearance:none;-moz-appearance:none;appearance:none;border:none}.client-libraries__select[data-v-217691d9]:has(select:focus-visible){border-radius:var(--scalar-radius);box-shadow:inset 0 0 0 1px var(--scalar-color-accent)}@media screen and (max-width: 600px){.references-classic .client-libraries[data-v-217691d9]{flex-direction:column}}.selected-client[data-v-a8ebef7d]{color:var(--scalar-color-1);font-size:var(--scalar-mini);font-family:var(--scalar-font-code);padding:9px 12px;border-top:none;white-space:nowrap;overflow:hidden;text-overflow:ellipsis;background:var(--scalar-background-1);border-top:var(--scalar-border-width) solid var(--scalar-border-color);min-height:-moz-fit-content;min-height:fit-content}.client-libraries-heading[data-v-a8ebef7d]{font-weight:var(--scalar-semibold);font-size:var(--scalar-mini);color:var(--scalar-color-1);padding:9px 12px;background-color:var(--scalar-background-2);display:flex;align-items:center;max-height:32px}.section-accordion-wrapper[data-v-1a30b4ff]{padding:0 60px}.section-accordion[data-v-1a30b4ff]{position:relative;width:100%;max-width:var(--refs-content-max-width);margin:auto}.section-accordion-content[data-v-1a30b4ff]{display:flex;flex-direction:column;gap:12px;padding-top:12px}.section-accordion-button[data-v-1a30b4ff]{width:100%;display:flex;cursor:pointer;padding:6px 0;margin:-6px 0;border-radius:var(--scalar-radius)}.section-accordion-chevron[data-v-1a30b4ff]{width:24px;position:absolute;left:-24px;height:auto;top:10px;color:var(--scalar-color-3)}.section-accordion-button:hover .section-accordion-chevron[data-v-1a30b4ff]{color:var(--scalar-color-1)}.section-accordion-title[data-v-1a30b4ff]{display:flex;flex-direction:column;align-items:flex-start;flex:1;padding:0 6px}.section-accordion-title[data-v-1a30b4ff] .section-header-wrapper{grid-template-columns:1fr}.section-accordion-title[data-v-1a30b4ff] .section-header{margin-bottom:0}@container narrow-references-container (max-width: 900px){.section-accordion-chevron[data-v-1a30b4ff]{width:16px;left:-16px;top:14px}.section-accordion-wrapper[data-v-1a30b4ff]{padding:calc(var(--refs-header-height)) 24px 0 24px}}.tag-section[data-v-448f4a19]{margin-bottom:48px}.tag-name[data-v-448f4a19]{text-transform:capitalize}.tag-description[data-v-448f4a19]{padding-bottom:4px;text-align:left}.webhook-request-body[data-v-cbaa1001]{margin-top:-18px}.collapsible-section[data-v-e7d0b809]{border-top:var(--scalar-border-width) solid var(--scalar-border-color);position:relative}.collapsible-section-header[data-v-e7d0b809]{color:var(--scalar-color-1)}.collapsible-section .collapsible-section-trigger[data-v-e7d0b809]{display:flex;align-items:center;cursor:pointer;padding:10px 0;font-size:var(--scalar-font-size-3);z-index:1;position:relative}.collapsible-section-trigger svg[data-v-e7d0b809]{color:var(--scalar-color-3);position:absolute;left:-19px}.collapsible-section:hover .collapsible-section-trigger svg[data-v-e7d0b809]{color:var(--scalar-color-1)}.collapsible-section .collapsible-section-trigger[data-v-e7d0b809] .anchor-copy{line-height:18.5px}.collapsible-section-content[data-v-e7d0b809]{padding:0;margin:0;scroll-margin-top:140px}.collapsible-section:not(:last-child) .collapsible-section-content[data-v-e7d0b809]{margin-bottom:10px}.webhooks-list[data-v-8691c69d]{display:contents}.webhooks-list-truncated .webhooks-list-item[data-v-8691c69d]:last-child{border-bottom:var(--scalar-border-width) solid var(--scalar-border-color)}.webhooks-list-item[aria-expanded=true][data-v-8691c69d]{padding-bottom:48px}.webhook-section-description.webhook-section-description[data-v-8691c69d]{color:var(--scalar-color-2);font-size:var(--scalar-font-size-3);padding-bottom:12px}.show-more-webhooks[data-v-8691c69d]{margin-top:32px;top:0}.reference-models[data-v-92646d2b]{margin-bottom:48px}.reference-models-anchor[data-v-92646d2b]{display:flex;align-items:center;font-size:20px;padding-left:6px;color:var(--scalar-color-1)}.reference-models-label[data-v-92646d2b]{font-size:var(--scalar-mini)}.reference-models-label[data-v-92646d2b] em{font-weight:var(--scalar-bold)}.models-list[data-v-2c898e03]{display:contents}.models-list-truncated .models-list-item[data-v-2c898e03]:last-child{border-bottom:var(--scalar-border-width) solid var(--scalar-border-color)}.show-more-models[data-v-2c898e03]{margin-top:32px;top:0}.models-list-item[data-v-2c898e03]:hover{z-index:10}.narrow-references-container{container-name:narrow-references-container;container-type:inline-size}.render-loading[data-v-c1080683]{height:calc(var(--full-height) - var(--refs-header-height));display:flex;align-items:center;justify-content:center}.introduction-card[data-v-c1080683]{display:flex;flex-direction:column;background:var(--scalar-background-1)}.introduction-card-item[data-v-c1080683]{display:flex;overflow:hidden;border:var(--scalar-border-width) solid var(--scalar-border-color);border-radius:var(--scalar-radius-lg);margin-bottom:12px;flex-direction:column;justify-content:start}@container narrow-references-container (max-width: 900px){.introduction-card-item[data-v-c1080683]{border-bottom:var(--scalar-border-width) solid var(--scalar-border-color)}}.introduction-card-item[data-v-c1080683]:has(.description) .server-form-container{border-bottom-left-radius:0;border-bottom-right-radius:0}.introduction-card-item[data-v-c1080683] .request-item{border-bottom:0}.introduction-card-title[data-v-c1080683]{font-weight:var(--scalar-semibold);font-size:var(--scalar-mini);color:var(--scalar-color-3)}.introduction-card-row[data-v-c1080683]{gap:24px}@media (min-width: 600px){.introduction-card-row[data-v-c1080683]{flex-flow:row wrap}}.introduction-card-row[data-v-c1080683]>*{flex:1}@media (min-width: 600px){.introduction-card-row[data-v-c1080683]>*{min-width:-moz-min-content;min-width:min-content}}@media (max-width: 600px){.introduction-card-row[data-v-c1080683]>*{max-width:100%}}@container (max-width: 900px){.introduction-card-row[data-v-c1080683]{flex-direction:column;align-items:stretch;gap:0px}}.introduction-card[data-v-c1080683] .security-scheme-label{text-transform:uppercase;font-weight:var(--scalar-semibold)}.references-classic .introduction-card-row[data-v-c1080683] .scalar-card:nth-of-type(2) .scalar-card-header{display:none}.references-classic .introduction-card-row[data-v-c1080683] .scalar-card:nth-of-type(2) .scalar-card-header.scalar-card--borderless+.scalar-card-content{margin-top:0}.section-flare[data-v-c1080683]{top:0;right:0;pointer-events:none}@layer scalar-base,scalar-theme;@layer scalar-base{body{margin:0;line-height:inherit}}@layer scalar-base{:root{--scalar-border-width: .5px;--scalar-radius: 3px;--scalar-radius-lg: 6px;--scalar-radius-xl: 8px;--scalar-font: \"Inter\", -apple-system, BlinkMacSystemFont, \"Segoe UI\", Roboto, Oxygen, Ubuntu, Cantarell, \"Open Sans\", \"Helvetica Neue\", sans-serif;--scalar-font-code: \"JetBrains Mono\", ui-monospace, Menlo, Monaco, \"Cascadia Mono\", \"Segoe UI Mono\", \"Roboto Mono\", \"Oxygen Mono\", \"Ubuntu Monospace\", \"Source Code Pro\", \"Fira Mono\", \"Droid Sans Mono\", \"Courier New\", monospace;--scalar-heading-1: 40px;--scalar-page-description: 24px;--scalar-heading-2: 24px;--scalar-heading-3: 20px;--scalar-heading-4: 16px;--scalar-heading-5: 16px;--scalar-heading-6: 16px;--scalar-paragraph: 16px;--scalar-small: 14px;--scalar-mini: 13px;--scalar-micro: 12px;--scalar-bold: 600;--scalar-semibold: 500;--scalar-regular: 400;--scalar-font-size-1: 21px;--scalar-font-size-2: 16px;--scalar-font-size-3: 14px;--scalar-font-size-4: 13px;--scalar-font-size-5: 12px;--scalar-font-size-6: 12px;--scalar-font-size-7: 10px;--scalar-line-height-1: 32px;--scalar-line-height-2: 24px;--scalar-line-height-3: 20px;--scalar-line-height-4: 18px;--scalar-line-height-5: 16px;--scalar-font-medium: 500;--scalar-font-bold: 700;--scalar-text-decoration: none;--scalar-text-decoration-hover: underline;--scalar-link-font-weight: inherit;--scalar-sidebar-indent: 18px}.dark-mode{color-scheme:dark;--scalar-scrollbar-color: rgba(255, 255, 255, .18);--scalar-scrollbar-color-active: rgba(255, 255, 255, .36);--scalar-button-1: rgba(255, 255, 255, 1);--scalar-button-1-hover: rgba(255, 255, 255, .9);--scalar-button-1-color: black;--scalar-shadow-1: 0 1px 3px 0 rgb(0, 0, 0, .1);--scalar-shadow-2: 0 0 0 .5px var(--scalar-border-color), rgba(15, 15, 15, .2) 0px 3px 6px, rgba(15, 15, 15, .4) 0px 9px 24px;--scalar-lifted-brightness: 1.45;--scalar-backdrop-brightness: .5;--scalar-link-color: var(--scalar-color-accent);--scalar-link-color-hover: var(--scalar-color-accent);--scalar-text-decoration-color: currentColor;--scalar-text-decoration-color-hover: currentColor}.light-mode{color-scheme:light;--scalar-scrollbar-color-active: rgba(0, 0, 0, .36);--scalar-scrollbar-color: rgba(0, 0, 0, .18);--scalar-button-1: rgba(0, 0, 0, 1);--scalar-button-1-hover: rgba(0, 0, 0, .8);--scalar-button-1-color: rgba(255, 255, 255, .9);--scalar-shadow-1: 0 1px 3px 0 rgba(0, 0, 0, .11);--scalar-shadow-2: rgba(0, 0, 0, .08) 0px 13px 20px 0px, rgba(0, 0, 0, .08) 0px 3px 8px 0px, #eeeeed 0px 0 0 .5px;--scalar-lifted-brightness: 1;--scalar-backdrop-brightness: 1;--scalar-link-color: var(--scalar-color-accent);--scalar-link-color-hover: var(--scalar-color-accent);--scalar-text-decoration-color: currentColor;--scalar-text-decoration-color-hover: currentColor}.light-mode .dark-mode{color-scheme:dark!important}@media (max-width: 460px){:root{--scalar-font-size-1: 22px;--scalar-font-size-2: 14px;--scalar-font-size-3: 12px}}@media (max-width: 720px){:root{--scalar-heading-1: 24px;--scalar-page-description: 20px}}.light-mode{--scalar-background-1: #fff;--scalar-background-2: #f6f6f6;--scalar-background-3: #e7e7e7;--scalar-background-accent: #8ab4f81f;--scalar-color-1: #2a2f45;--scalar-color-2: #757575;--scalar-color-3: #8e8e8e;--scalar-color-accent: #0099ff;--scalar-border-color: #dfdfdf}.dark-mode{--scalar-background-1: #0f0f0f;--scalar-background-2: #1a1a1a;--scalar-background-3: #272727;--scalar-color-1: #e7e7e7;--scalar-color-2: #a4a4a4;--scalar-color-3: #797979;--scalar-color-accent: #3ea6ff;--scalar-background-accent: #3ea6ff1f;--scalar-border-color: #2d2d2d}.light-mode .t-doc__sidebar,.dark-mode .t-doc__sidebar{--scalar-sidebar-background-1: var(--scalar-background-1);--scalar-sidebar-color-1: var(--scalar-color-1);--scalar-sidebar-color-2: var(--scalar-color-2);--scalar-sidebar-border-color: var(--scalar-border-color);--scalar-sidebar-item-hover-background: var(--scalar-background-2);--scalar-sidebar-item-hover-color: currentColor;--scalar-sidebar-item-active-background: var(--scalar-background-2);--scalar-sidebar-color-active: var(--scalar-color-1);--scalar-sidebar-indent-border: var(--scalar-sidebar-border-color);--scalar-sidebar-indent-border-hover: var(--scalar-sidebar-border-color);--scalar-sidebar-indent-border-active: var(--scalar-sidebar-border-color);--scalar-sidebar-search-background: transparent;--scalar-sidebar-search-color: var(--scalar-color-3);--scalar-sidebar-search-border-color: var(--scalar-border-color)}.light-mode{--scalar-color-green: #069061;--scalar-color-red: #ef0006;--scalar-color-yellow: #edbe20;--scalar-color-blue: #0082d0;--scalar-color-orange: #fb892c;--scalar-color-purple: #5203d1;--scalar-button-1: rgba(0, 0, 0, 1);--scalar-button-1-hover: rgba(0, 0, 0, .8);--scalar-button-1-color: rgba(255, 255, 255, .9);--scalar-color-danger: color-mix(in srgb, var(--scalar-color-red), var(--scalar-color-1) 20%);--scalar-background-alert: color-mix(in srgb, var(--scalar-color-orange), var(--scalar-background-1) 95%);--scalar-background-danger: color-mix(in srgb, var(--scalar-color-red), var(--scalar-background-1) 95%)}.dark-mode{--scalar-color-green: #00b648;--scalar-color-red: #dc1b19;--scalar-color-yellow: #ffc90d;--scalar-color-blue: #4eb3ec;--scalar-color-orange: #ff8d4d;--scalar-color-purple: #b191f9;--scalar-button-1: rgba(255, 255, 255, 1);--scalar-button-1-hover: rgba(255, 255, 255, .9);--scalar-button-1-color: black;--scalar-color-danger: color-mix(in srgb, var(--scalar-color-red), var(--scalar-background-1) 20%);--scalar-background-alert: color-mix(in srgb, var(--scalar-color-orange), var(--scalar-background-1) 95%);--scalar-background-danger: color-mix(in srgb, var(--scalar-color-red), var(--scalar-background-1) 95%)}@supports (color: color(display-p3 1 1 1)){.light-mode{--scalar-color-accent: color(display-p3 0 .6 1 / 1);--scalar-color-green: color(display-p3 .023529 .564706 .380392 / 1);--scalar-color-red: color(display-p3 .937255 0 .023529 / 1);--scalar-color-yellow: color(display-p3 .929412 .745098 .12549 / 1);--scalar-color-blue: color(display-p3 0 .509804 .815686 / 1);--scalar-color-orange: color(display-p3 .984314 .537255 .172549 / 1);--scalar-color-purple: color(display-p3 .321569 .011765 .819608 / 1)}.dark-mode{--scalar-color-accent: color(display-p3 .243137 .65098 1 / 1);--scalar-color-green: color(display-p3 0 .713725 .282353 / 1);--scalar-color-red: color(display-p3 .862745 .105882 .098039 / 1);--scalar-color-yellow: color(display-p3 1 .788235 .05098 / 1);--scalar-color-blue: color(display-p3 .305882 .701961 .92549 / 1);--scalar-color-orange: color(display-p3 1 .552941 .301961 / 1);--scalar-color-purple: color(display-p3 .694118 .568627 .976471 / 1)}}*,:before,:after{--tw-border-spacing-x: 0;--tw-border-spacing-y: 0;--tw-translate-x: 0;--tw-translate-y: 0;--tw-rotate: 0;--tw-skew-x: 0;--tw-skew-y: 0;--tw-scale-x: 1;--tw-scale-y: 1;--tw-pan-x: ;--tw-pan-y: ;--tw-pinch-zoom: ;--tw-scroll-snap-strictness: proximity;--tw-gradient-from-position: ;--tw-gradient-via-position: ;--tw-gradient-to-position: ;--tw-ordinal: ;--tw-slashed-zero: ;--tw-numeric-figure: ;--tw-numeric-spacing: ;--tw-numeric-fraction: ;--tw-ring-inset: ;--tw-ring-offset-width: 0px;--tw-ring-offset-color: #fff;--tw-ring-color: rgb(59 130 246 / .5);--tw-ring-offset-shadow: 0 0 #0000;--tw-ring-shadow: 0 0 #0000;--tw-shadow: 0 0 #0000;--tw-shadow-colored: 0 0 #0000;--tw-blur: ;--tw-brightness: ;--tw-contrast: ;--tw-grayscale: ;--tw-hue-rotate: ;--tw-invert: ;--tw-saturate: ;--tw-sepia: ;--tw-drop-shadow: ;--tw-backdrop-blur: ;--tw-backdrop-brightness: ;--tw-backdrop-contrast: ;--tw-backdrop-grayscale: ;--tw-backdrop-hue-rotate: ;--tw-backdrop-invert: ;--tw-backdrop-opacity: ;--tw-backdrop-saturate: ;--tw-backdrop-sepia: ;--tw-contain-size: ;--tw-contain-layout: ;--tw-contain-paint: ;--tw-contain-style: }::backdrop{--tw-border-spacing-x: 0;--tw-border-spacing-y: 0;--tw-translate-x: 0;--tw-translate-y: 0;--tw-rotate: 0;--tw-skew-x: 0;--tw-skew-y: 0;--tw-scale-x: 1;--tw-scale-y: 1;--tw-pan-x: ;--tw-pan-y: ;--tw-pinch-zoom: ;--tw-scroll-snap-strictness: proximity;--tw-gradient-from-position: ;--tw-gradient-via-position: ;--tw-gradient-to-position: ;--tw-ordinal: ;--tw-slashed-zero: ;--tw-numeric-figure: ;--tw-numeric-spacing: ;--tw-numeric-fraction: ;--tw-ring-inset: ;--tw-ring-offset-width: 0px;--tw-ring-offset-color: #fff;--tw-ring-color: rgb(59 130 246 / .5);--tw-ring-offset-shadow: 0 0 #0000;--tw-ring-shadow: 0 0 #0000;--tw-shadow: 0 0 #0000;--tw-shadow-colored: 0 0 #0000;--tw-blur: ;--tw-brightness: ;--tw-contrast: ;--tw-grayscale: ;--tw-hue-rotate: ;--tw-invert: ;--tw-saturate: ;--tw-sepia: ;--tw-drop-shadow: ;--tw-backdrop-blur: ;--tw-backdrop-brightness: ;--tw-backdrop-contrast: ;--tw-backdrop-grayscale: ;--tw-backdrop-hue-rotate: ;--tw-backdrop-invert: ;--tw-backdrop-opacity: ;--tw-backdrop-saturate: ;--tw-backdrop-sepia: ;--tw-contain-size: ;--tw-contain-layout: ;--tw-contain-paint: ;--tw-contain-style: }}.scalar-app .markdown summary:after{display:block;content:\"\";position:absolute;top:-1px;left:-1px;width:20px;height:20px;background-color:var(--scalar-color-3);-webkit-mask-image:url('data:image/svg+xml,<svg viewBox=\"0 0 24 24\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"m9 18 6-6-6-6\" stroke=\"currentColor\" stroke-width=\"1.5\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/></svg>');mask-image:url('data:image/svg+xml,<svg viewBox=\"0 0 24 24\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"m9 18 6-6-6-6\" stroke=\"currentColor\" stroke-width=\"1.5\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/></svg>')}.scalar-app .markdown .markdown-alert.markdown-alert-note:before,.scalar-app .markdown .markdown-alert.markdown-alert-tip:before{-webkit-mask-image:url('data:image/svg+xml,<svg viewBox=\"0 0 24 24\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M12 17v-6a.5.5 0 0 0-.5-.5l-.5.001h-1M12 17h-2m2 0h2m-2 5c5.523 0 10-4.477 10-10S17.523 2 12 2 2 6.477 2 12s4.477 10 10 10Z\" stroke=\"currentColor\" stroke-width=\"1.5\" stroke-miterlimit=\"10\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M10.75 7.5a1 1 0 1 1 2 0 1 1 0 0 1-2 0Z\" fill=\"currentColor\"/></svg>');mask-image:url('data:image/svg+xml,<svg viewBox=\"0 0 24 24\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M12 17v-6a.5.5 0 0 0-.5-.5l-.5.001h-1M12 17h-2m2 0h2m-2 5c5.523 0 10-4.477 10-10S17.523 2 12 2 2 6.477 2 12s4.477 10 10 10Z\" stroke=\"currentColor\" stroke-width=\"1.5\" stroke-miterlimit=\"10\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M10.75 7.5a1 1 0 1 1 2 0 1 1 0 0 1-2 0Z\" fill=\"currentColor\"/></svg>')}.scalar-app .markdown .markdown-alert.markdown-alert-important:before,.scalar-app .markdown .markdown-alert.markdown-alert-warning:before{-webkit-mask-image:url('data:image/svg+xml,<svg viewBox=\"0 0 24 24\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M12 8v4m10 0c0 5.523-4.477 10-10 10S2 17.523 2 12 6.477 2 12 2s10 4.477 10 10Z\" stroke=\"currentColor\" stroke-width=\"1.5\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M11 16a1 1 0 1 1 2 0 1 1 0 0 1-2 0Z\" fill=\"currentColor\"/></svg>');mask-image:url('data:image/svg+xml,<svg viewBox=\"0 0 24 24\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M12 8v4m10 0c0 5.523-4.477 10-10 10S2 17.523 2 12 6.477 2 12 2s10 4.477 10 10Z\" stroke=\"currentColor\" stroke-width=\"1.5\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M11 16a1 1 0 1 1 2 0 1 1 0 0 1-2 0Z\" fill=\"currentColor\"/></svg>')}.scalar-app .markdown .markdown-alert.markdown-alert-caution:before{-webkit-mask-image:url('data:image/svg+xml,<svg viewBox=\"0 0 24 24\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M12 8v4m3.312-10a2 2 0 0 1 1.414.586l4.688 4.688A2 2 0 0 1 22 8.688v6.624a2 2 0 0 1-.586 1.414l-4.688 4.688a2 2 0 0 1-1.414.586H8.688a2 2 0 0 1-1.414-.586l-4.688-4.688A2 2 0 0 1 2 15.312V8.688a2 2 0 0 1 .586-1.414l4.688-4.688A2 2 0 0 1 8.688 2h6.624Z\" stroke=\"currentColor\" stroke-width=\"1.5\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M11 16a1 1 0 1 1 2 0 1 1 0 0 1-2 0Z\" fill=\"currentColor\"/></svg>');mask-image:url('data:image/svg+xml,<svg viewBox=\"0 0 24 24\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M12 8v4m3.312-10a2 2 0 0 1 1.414.586l4.688 4.688A2 2 0 0 1 22 8.688v6.624a2 2 0 0 1-.586 1.414l-4.688 4.688a2 2 0 0 1-1.414.586H8.688a2 2 0 0 1-1.414-.586l-4.688-4.688A2 2 0 0 1 2 15.312V8.688a2 2 0 0 1 .586-1.414l4.688-4.688A2 2 0 0 1 8.688 2h6.624Z\" stroke=\"currentColor\" stroke-width=\"1.5\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M11 16a1 1 0 1 1 2 0 1 1 0 0 1-2 0Z\" fill=\"currentColor\"/></svg>');color:var(--scalar-color-red)}.scalar-app .markdown .markdown-alert.markdown-alert-success:before{-webkit-mask-image:url('data:image/svg+xml,<svg viewBox=\"0 0 24 24\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M16 9.5 10.5 15 8 12.5m14-.5c0 5.523-4.477 10-10 10S2 17.523 2 12 6.477 2 12 2s10 4.477 10 10Z\" stroke=\"currentColor\" stroke-width=\"1.5\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/></svg>');mask-image:url('data:image/svg+xml,<svg viewBox=\"0 0 24 24\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M16 9.5 10.5 15 8 12.5m14-.5c0 5.523-4.477 10-10 10S2 17.523 2 12 6.477 2 12 2s10 4.477 10 10Z\" stroke=\"currentColor\" stroke-width=\"1.5\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/></svg>');color:var(--scalar-color-green)}@layer scalar-base,scalar-theme;@layer scalar-base{body{margin:0;line-height:inherit}}@layer scalar-base{:root{--scalar-border-width: .5px;--scalar-radius: 3px;--scalar-radius-lg: 6px;--scalar-radius-xl: 8px;--scalar-font: \"Inter\", -apple-system, BlinkMacSystemFont, \"Segoe UI\", Roboto, Oxygen, Ubuntu, Cantarell, \"Open Sans\", \"Helvetica Neue\", sans-serif;--scalar-font-code: \"JetBrains Mono\", ui-monospace, Menlo, Monaco, \"Cascadia Mono\", \"Segoe UI Mono\", \"Roboto Mono\", \"Oxygen Mono\", \"Ubuntu Monospace\", \"Source Code Pro\", \"Fira Mono\", \"Droid Sans Mono\", \"Courier New\", monospace;--scalar-heading-1: 40px;--scalar-page-description: 24px;--scalar-heading-2: 24px;--scalar-heading-3: 20px;--scalar-heading-4: 16px;--scalar-heading-5: 16px;--scalar-heading-6: 16px;--scalar-paragraph: 16px;--scalar-small: 14px;--scalar-mini: 13px;--scalar-micro: 12px;--scalar-bold: 600;--scalar-semibold: 500;--scalar-regular: 400;--scalar-font-size-1: 21px;--scalar-font-size-2: 16px;--scalar-font-size-3: 14px;--scalar-font-size-4: 13px;--scalar-font-size-5: 12px;--scalar-font-size-6: 12px;--scalar-font-size-7: 10px;--scalar-line-height-1: 32px;--scalar-line-height-2: 24px;--scalar-line-height-3: 20px;--scalar-line-height-4: 18px;--scalar-line-height-5: 16px;--scalar-font-medium: 500;--scalar-font-bold: 700;--scalar-text-decoration: none;--scalar-text-decoration-hover: underline;--scalar-link-font-weight: inherit;--scalar-sidebar-indent: 18px}.dark-mode{color-scheme:dark;--scalar-scrollbar-color: rgba(255, 255, 255, .18);--scalar-scrollbar-color-active: rgba(255, 255, 255, .36);--scalar-button-1: rgba(255, 255, 255, 1);--scalar-button-1-hover: rgba(255, 255, 255, .9);--scalar-button-1-color: black;--scalar-shadow-1: 0 1px 3px 0 rgb(0, 0, 0, .1);--scalar-shadow-2: 0 0 0 .5px var(--scalar-border-color), rgba(15, 15, 15, .2) 0px 3px 6px, rgba(15, 15, 15, .4) 0px 9px 24px;--scalar-lifted-brightness: 1.45;--scalar-backdrop-brightness: .5;--scalar-link-color: var(--scalar-color-accent);--scalar-link-color-hover: var(--scalar-color-accent);--scalar-text-decoration-color: currentColor;--scalar-text-decoration-color-hover: currentColor}.light-mode{color-scheme:light;--scalar-scrollbar-color-active: rgba(0, 0, 0, .36);--scalar-scrollbar-color: rgba(0, 0, 0, .18);--scalar-button-1: rgba(0, 0, 0, 1);--scalar-button-1-hover: rgba(0, 0, 0, .8);--scalar-button-1-color: rgba(255, 255, 255, .9);--scalar-shadow-1: 0 1px 3px 0 rgba(0, 0, 0, .11);--scalar-shadow-2: rgba(0, 0, 0, .08) 0px 13px 20px 0px, rgba(0, 0, 0, .08) 0px 3px 8px 0px, #eeeeed 0px 0 0 .5px;--scalar-lifted-brightness: 1;--scalar-backdrop-brightness: 1;--scalar-link-color: var(--scalar-color-accent);--scalar-link-color-hover: var(--scalar-color-accent);--scalar-text-decoration-color: currentColor;--scalar-text-decoration-color-hover: currentColor}.light-mode .dark-mode{color-scheme:dark!important}@media (max-width: 460px){:root{--scalar-font-size-1: 22px;--scalar-font-size-2: 14px;--scalar-font-size-3: 12px}}@media (max-width: 720px){:root{--scalar-heading-1: 24px;--scalar-page-description: 20px}}.light-mode{--scalar-background-1: #fff;--scalar-background-2: #f6f6f6;--scalar-background-3: #e7e7e7;--scalar-background-accent: #8ab4f81f;--scalar-color-1: #2a2f45;--scalar-color-2: #757575;--scalar-color-3: #8e8e8e;--scalar-color-accent: #0099ff;--scalar-border-color: #dfdfdf}.dark-mode{--scalar-background-1: #0f0f0f;--scalar-background-2: #1a1a1a;--scalar-background-3: #272727;--scalar-color-1: #e7e7e7;--scalar-color-2: #a4a4a4;--scalar-color-3: #797979;--scalar-color-accent: #3ea6ff;--scalar-background-accent: #3ea6ff1f;--scalar-border-color: #2d2d2d}.light-mode .t-doc__sidebar,.dark-mode .t-doc__sidebar{--scalar-sidebar-background-1: var(--scalar-background-1);--scalar-sidebar-color-1: var(--scalar-color-1);--scalar-sidebar-color-2: var(--scalar-color-2);--scalar-sidebar-border-color: var(--scalar-border-color);--scalar-sidebar-item-hover-background: var(--scalar-background-2);--scalar-sidebar-item-hover-color: currentColor;--scalar-sidebar-item-active-background: var(--scalar-background-2);--scalar-sidebar-color-active: var(--scalar-color-1);--scalar-sidebar-indent-border: var(--scalar-sidebar-border-color);--scalar-sidebar-indent-border-hover: var(--scalar-sidebar-border-color);--scalar-sidebar-indent-border-active: var(--scalar-sidebar-border-color);--scalar-sidebar-search-background: transparent;--scalar-sidebar-search-color: var(--scalar-color-3);--scalar-sidebar-search-border-color: var(--scalar-border-color)}.light-mode{--scalar-color-green: #069061;--scalar-color-red: #ef0006;--scalar-color-yellow: #edbe20;--scalar-color-blue: #0082d0;--scalar-color-orange: #fb892c;--scalar-color-purple: #5203d1;--scalar-button-1: rgba(0, 0, 0, 1);--scalar-button-1-hover: rgba(0, 0, 0, .8);--scalar-button-1-color: rgba(255, 255, 255, .9);--scalar-color-danger: color-mix(in srgb, var(--scalar-color-red), var(--scalar-color-1) 20%);--scalar-background-alert: color-mix(in srgb, var(--scalar-color-orange), var(--scalar-background-1) 95%);--scalar-background-danger: color-mix(in srgb, var(--scalar-color-red), var(--scalar-background-1) 95%)}.dark-mode{--scalar-color-green: #00b648;--scalar-color-red: #dc1b19;--scalar-color-yellow: #ffc90d;--scalar-color-blue: #4eb3ec;--scalar-color-orange: #ff8d4d;--scalar-color-purple: #b191f9;--scalar-button-1: rgba(255, 255, 255, 1);--scalar-button-1-hover: rgba(255, 255, 255, .9);--scalar-button-1-color: black;--scalar-color-danger: color-mix(in srgb, var(--scalar-color-red), var(--scalar-background-1) 20%);--scalar-background-alert: color-mix(in srgb, var(--scalar-color-orange), var(--scalar-background-1) 95%);--scalar-background-danger: color-mix(in srgb, var(--scalar-color-red), var(--scalar-background-1) 95%)}@supports (color: color(display-p3 1 1 1)){.light-mode{--scalar-color-accent: color(display-p3 0 .6 1 / 1);--scalar-color-green: color(display-p3 .023529 .564706 .380392 / 1);--scalar-color-red: color(display-p3 .937255 0 .023529 / 1);--scalar-color-yellow: color(display-p3 .929412 .745098 .12549 / 1);--scalar-color-blue: color(display-p3 0 .509804 .815686 / 1);--scalar-color-orange: color(display-p3 .984314 .537255 .172549 / 1);--scalar-color-purple: color(display-p3 .321569 .011765 .819608 / 1)}.dark-mode{--scalar-color-accent: color(display-p3 .243137 .65098 1 / 1);--scalar-color-green: color(display-p3 0 .713725 .282353 / 1);--scalar-color-red: color(display-p3 .862745 .105882 .098039 / 1);--scalar-color-yellow: color(display-p3 1 .788235 .05098 / 1);--scalar-color-blue: color(display-p3 .305882 .701961 .92549 / 1);--scalar-color-orange: color(display-p3 1 .552941 .301961 / 1);--scalar-color-purple: color(display-p3 .694118 .568627 .976471 / 1)}}*,:before,:after{--tw-border-spacing-x:0;--tw-border-spacing-y:0;--tw-translate-x:0;--tw-translate-y:0;--tw-rotate:0;--tw-skew-x:0;--tw-skew-y:0;--tw-scale-x:1;--tw-scale-y:1;--tw-pan-x: ;--tw-pan-y: ;--tw-pinch-zoom: ;--tw-scroll-snap-strictness:proximity;--tw-gradient-from-position: ;--tw-gradient-via-position: ;--tw-gradient-to-position: ;--tw-ordinal: ;--tw-slashed-zero: ;--tw-numeric-figure: ;--tw-numeric-spacing: ;--tw-numeric-fraction: ;--tw-ring-inset: ;--tw-ring-offset-width:0px;--tw-ring-offset-color:#fff;--tw-ring-color:rgb(59 130 246 / .5);--tw-ring-offset-shadow:0 0 #0000;--tw-ring-shadow:0 0 #0000;--tw-shadow:0 0 #0000;--tw-shadow-colored:0 0 #0000;--tw-blur: ;--tw-brightness: ;--tw-contrast: ;--tw-grayscale: ;--tw-hue-rotate: ;--tw-invert: ;--tw-saturate: ;--tw-sepia: ;--tw-drop-shadow: ;--tw-backdrop-blur: ;--tw-backdrop-brightness: ;--tw-backdrop-contrast: ;--tw-backdrop-grayscale: ;--tw-backdrop-hue-rotate: ;--tw-backdrop-invert: ;--tw-backdrop-opacity: ;--tw-backdrop-saturate: ;--tw-backdrop-sepia: ;--tw-contain-size: ;--tw-contain-layout: ;--tw-contain-paint: ;--tw-contain-style: }::backdrop{--tw-border-spacing-x:0;--tw-border-spacing-y:0;--tw-translate-x:0;--tw-translate-y:0;--tw-rotate:0;--tw-skew-x:0;--tw-skew-y:0;--tw-scale-x:1;--tw-scale-y:1;--tw-pan-x: ;--tw-pan-y: ;--tw-pinch-zoom: ;--tw-scroll-snap-strictness:proximity;--tw-gradient-from-position: ;--tw-gradient-via-position: ;--tw-gradient-to-position: ;--tw-ordinal: ;--tw-slashed-zero: ;--tw-numeric-figure: ;--tw-numeric-spacing: ;--tw-numeric-fraction: ;--tw-ring-inset: ;--tw-ring-offset-width:0px;--tw-ring-offset-color:#fff;--tw-ring-color:rgb(59 130 246 / .5);--tw-ring-offset-shadow:0 0 #0000;--tw-ring-shadow:0 0 #0000;--tw-shadow:0 0 #0000;--tw-shadow-colored:0 0 #0000;--tw-blur: ;--tw-brightness: ;--tw-contrast: ;--tw-grayscale: ;--tw-hue-rotate: ;--tw-invert: ;--tw-saturate: ;--tw-sepia: ;--tw-drop-shadow: ;--tw-backdrop-blur: ;--tw-backdrop-brightness: ;--tw-backdrop-contrast: ;--tw-backdrop-grayscale: ;--tw-backdrop-hue-rotate: ;--tw-backdrop-invert: ;--tw-backdrop-opacity: ;--tw-backdrop-saturate: ;--tw-backdrop-sepia: ;--tw-contain-size: ;--tw-contain-layout: ;--tw-contain-paint: ;--tw-contain-style: }}.scalar-api-reference{color:var(--scalar-color-1)}.scalar-api-reference .container{width:100%}@media (min-width: 400px){.scalar-api-reference .container{max-width:400px}}@media (min-width: 600px){.scalar-api-reference .container{max-width:600px}}@media (min-width: 800px){.scalar-api-reference .container{max-width:800px}}@media (min-width: 1000px){.scalar-api-reference .container{max-width:1000px}}@media (min-width: 1200px){.scalar-api-reference .container{max-width:1200px}}.scalar-api-reference .row{display:flex;flex-direction:row}.scalar-api-reference .sr-only{position:absolute;width:1px;height:1px;padding:0;margin:-1px;overflow:hidden;clip:rect(0,0,0,0);white-space:nowrap;border-width:0}.scalar-api-reference .visible{visibility:visible}.scalar-api-reference .collapse{visibility:collapse}.scalar-api-reference .static{position:static}.scalar-api-reference .fixed{position:fixed}.scalar-api-reference .absolute{position:absolute}.scalar-api-reference .relative{position:relative}.scalar-api-reference .sticky{position:sticky}.scalar-api-reference .right-0{right:0}.scalar-api-reference .top-2{top:8px}.scalar-api-reference .top-2\\.5{top:10px}.scalar-api-reference .z-1{z-index:1}.scalar-api-reference .-mb-1{margin-bottom:-4px}.scalar-api-reference .ml-auto{margin-left:auto}.scalar-api-reference .mr-1{margin-right:4px}.scalar-api-reference .mr-1\\.25{margin-right:5px}.scalar-api-reference .mr-2{margin-right:8px}.scalar-api-reference .block{display:block}.scalar-api-reference .inline{display:inline}.scalar-api-reference .flex{display:flex}.scalar-api-reference .grid{display:grid}.scalar-api-reference .contents{display:contents}.scalar-api-reference .hidden{display:none}.scalar-api-reference .h-8{height:32px}.scalar-api-reference .h-fit{height:-moz-fit-content;height:fit-content}.scalar-api-reference .min-h-3{min-height:12px}.scalar-api-reference .w-64{width:256px}.scalar-api-reference .w-full{width:100%}.scalar-api-reference .min-w-3{min-width:12px}.scalar-api-reference .min-w-4{min-width:16px}.scalar-api-reference .flex-shrink,.scalar-api-reference .shrink{flex-shrink:1}.scalar-api-reference .transform{transform:translate(var(--tw-translate-x),var(--tw-translate-y)) rotate(var(--tw-rotate)) skew(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y))}.scalar-api-reference .cursor-pointer{cursor:pointer}.scalar-api-reference .resize{resize:both}.scalar-api-reference .flex-col{flex-direction:column}.scalar-api-reference .flex-wrap{flex-wrap:wrap}.scalar-api-reference .content-start{align-content:flex-start}.scalar-api-reference .content-end{align-content:flex-end}.scalar-api-reference .items-center{align-items:center}.scalar-api-reference .gap-1{gap:4px}.scalar-api-reference .gap-1\\.5{gap:6px}.scalar-api-reference .gap-12{gap:48px}.scalar-api-reference .divide-y>:not([hidden])~:not([hidden]){--tw-divide-y-reverse:0;border-top-width:calc(var(--scalar-border-width) * calc(1 - var(--tw-divide-y-reverse)));border-bottom-width:calc(var(--scalar-border-width) * var(--tw-divide-y-reverse))}.scalar-api-reference .overflow-hidden{overflow:hidden}.scalar-api-reference .\\!overflow-y-hidden{overflow-y:hidden!important}.scalar-api-reference .truncate{overflow:hidden;text-overflow:ellipsis;white-space:nowrap}.scalar-api-reference .text-ellipsis{text-overflow:ellipsis}.scalar-api-reference .rounded{border-radius:var(--scalar-radius)}.scalar-api-reference .rounded-full{border-radius:9999px}.scalar-api-reference .rounded-t-lg{border-top-left-radius:var(--scalar-radius-lg);border-top-right-radius:var(--scalar-radius-lg)}.scalar-api-reference .border{border-width:var(--scalar-border-width)}.scalar-api-reference .border-b-0{border-bottom-width:0}.scalar-api-reference .border-t-1\\/2{border-top-width:calc(var(--scalar-border-width) / 2)}.scalar-api-reference .bg-b-2{background-color:var(--scalar-background-2)}.scalar-api-reference .p-3{padding:12px}.scalar-api-reference .px-2{padding-left:8px;padding-right:8px}.scalar-api-reference .px-3{padding-left:12px;padding-right:12px}.scalar-api-reference .py-0{padding-top:0;padding-bottom:0}.scalar-api-reference .py-0\\.75{padding-top:3px;padding-bottom:3px}.scalar-api-reference .py-1{padding-top:4px;padding-bottom:4px}.scalar-api-reference .py-1\\.25{padding-top:5px;padding-bottom:5px}.scalar-api-reference .py-1\\.5{padding-top:6px;padding-bottom:6px}.scalar-api-reference .py-1\\.75{padding-top:7px;padding-bottom:7px}.scalar-api-reference .py-2{padding-top:8px;padding-bottom:8px}.scalar-api-reference .py-2\\.5{padding-top:10px;padding-bottom:10px}.scalar-api-reference .pb-0{padding-bottom:0}.scalar-api-reference .pl-1{padding-left:4px}.scalar-api-reference .pl-1\\.75{padding-left:7px}.scalar-api-reference .pl-2{padding-left:8px}.scalar-api-reference .pr-1{padding-right:4px}.scalar-api-reference .pr-1\\.5{padding-right:6px}.scalar-api-reference .pr-3{padding-right:12px}.scalar-api-reference .font{font-family:var(--scalar-font)}.scalar-api-reference .text-base{font-size:var(--scalar-font-size-3)}.scalar-api-reference .text-sm{font-size:var(--scalar-font-size-4)}.scalar-api-reference .text-xs{font-size:var(--scalar-font-size-5)}.scalar-api-reference .font{font-weight:var(--scalar-regular)}.scalar-api-reference .font-medium{font-weight:var(--scalar-semibold)}.scalar-api-reference .font-normal{font-weight:var(--scalar-regular)}.scalar-api-reference .uppercase{text-transform:uppercase}.scalar-api-reference .lowercase{text-transform:lowercase}.scalar-api-reference .capitalize{text-transform:capitalize}.scalar-api-reference .leading{line-height:1.5}.scalar-api-reference .text-c-1{color:var(--scalar-color-1)}.scalar-api-reference .text-c-2{color:var(--scalar-color-2)}.scalar-api-reference .text-c-3{color:var(--scalar-color-3)}.scalar-api-reference .text-green{color:var(--scalar-color-green)}.scalar-api-reference .text-orange{color:var(--scalar-color-orange)}.scalar-api-reference .text-red{color:var(--scalar-color-red)}.scalar-api-reference .underline{text-decoration-line:underline}.scalar-api-reference .opacity-0{opacity:0}.scalar-api-reference .outline{outline-style:solid}.scalar-api-reference .-outline-offset-2{outline-offset:-2px}.scalar-api-reference .filter{filter:var(--tw-blur) var(--tw-brightness) var(--tw-contrast) var(--tw-grayscale) var(--tw-hue-rotate) var(--tw-invert) var(--tw-saturate) var(--tw-sepia) var(--tw-drop-shadow)}.scalar-api-reference .\\[--scalar-address-bar-height\\:0px\\]{--scalar-address-bar-height:0px}.scalar-api-reference .hover\\:bg-b-2:hover{background-color:var(--scalar-background-2)}.scalar-api-reference .hover\\:text-c-1:hover{color:var(--scalar-color-1)}.scalar-api-reference .group\\/parameter-item:focus-within .group-focus-within\\/parameter-item\\:opacity-100{opacity:1}.scalar-api-reference .group\\/dropdown-label:hover .group-hover\\/dropdown-label\\:text-c-1,.scalar-api-reference .group:hover .group-hover\\:text-c-1{color:var(--scalar-color-1)}.scalar-api-reference .group\\/parameter-item:hover .group-hover\\/parameter-item\\:opacity-100{opacity:1}.nav-item[data-v-ada738af]{padding:0 1rem;cursor:pointer;flex:1;justify-content:center;align-items:center;display:flex;border-radius:var(--scalar-radius-lg);background:var(--scalar-background-3);border:var(--scalar-border-width) solid var(--scalar-background-2);color:var(--scalar-color-3);padding:4.5px;min-width:0;overflow:hidden;position:relative}.dark-mode .nav-item[data-v-ada738af]{background:color-mix(in srgb,var(--scalar-background-2),transparent)}.nav-item-icon-copy[data-v-ada738af]{max-width:100%;white-space:nowrap;overflow:hidden;-webkit-mask-image:linear-gradient(to left,transparent 0,var(--scalar-background-2) 20px);mask-image:linear-gradient(to left,transparent 0,var(--scalar-background-2) 20px)}.nav-item:hover .nav-item-icon-copy[data-v-ada738af]{-webkit-mask-image:linear-gradient(to left,transparent 20px,var(--scalar-background-2) 40px);mask-image:linear-gradient(to left,transparent 20px,var(--scalar-background-2) 40px)}.nav-item-copy[data-v-ada738af]{max-width:calc(100% - 20px)}.nav-item[data-v-ada738af]:hover{color:var(--scalar-color-1)}.nav-item__active[data-v-ada738af]{background-color:var(--scalar-background-1);color:var(--scalar-color-1);border-color:var(--scalar-border-color)}.dark-mode .nav-item__active[data-v-ada738af]{background-color:var(--scalar-background-2)}.nav-item-close[data-v-ada738af]{position:absolute;right:3px;padding:2px;border-radius:var(--scalar-radius);background:transparent;max-width:20px;stroke-width:1.5px;color:var(--scalar-color-3);margin-left:-20px;opacity:0}.nav-item:hover .nav-item-close[data-v-ada738af]{opacity:1}.nav-item-close[data-v-ada738af]:hover{background-color:var(--scalar-background-4)}.nav-item__active .nav-item-close[data-v-ada738af]:hover{background-color:var(--scalar-background-2)}.download-app-button[data-v-cb45fa05]{box-shadow:0 0 0 .5px var(--scalar-border-color);background:linear-gradient(#ffffffbf,#00000009)}.dark-mode .download-app-button[data-v-cb45fa05]{background:linear-gradient(#ffffff1a,#00000026)}.download-app-button[data-v-cb45fa05]:hover{background:linear-gradient(#00000009,#ffffffbf)}.dark-mode .download-app-button[data-v-cb45fa05]:hover{background:linear-gradient(#00000026,#ffffff1a)}.http-bg-gradient[data-v-73e8dbd2]{background:linear-gradient(#ffffffbf,#00000009)}.http-bg-gradient[data-v-73e8dbd2]:hover{background:linear-gradient(#00000009,#ffffffbf)}.dark-mode .http-bg-gradient[data-v-73e8dbd2]{background:linear-gradient(#ffffff09,#00000026)}.dark-mode .http-bg-gradient[data-v-73e8dbd2]:hover{background:linear-gradient(#00000026,#ffffff09)}.scroll-timeline-x[data-v-19cf46d6]{overflow:auto;scroll-timeline:--scroll-timeline x;scroll-timeline:--scroll-timeline horizontal;-ms-overflow-style:none;scrollbar-width:none}.commandmenu[data-v-85f3b768]{box-shadow:var(--scalar-shadow-2);border-radius:var(--scalar-radius-lg);background-color:var(--scalar-background-1);max-height:60dvh;width:100%;max-width:580px;margin:12px;position:fixed;left:50%;top:150px;opacity:0;transform:translate3d(-50%,10px,0);animation:fadeincommandmenu-85f3b768 ease-in-out .3s forwards;animation-delay:.1s}.commandmenu-overlay[data-v-85f3b768]{position:fixed;top:0;right:0;bottom:0;left:0;background:#0003;animation:fadeincommand-85f3b768 ease-in-out .3s forwards;cursor:pointer}@keyframes fadeincommand-85f3b768{0%{opacity:0}to{opacity:1}}@keyframes fadeincommandmenu-85f3b768{0%{opacity:0;transform:translate3d(-50%,10px,0)}to{opacity:1;transform:translate3d(-50%,0,0)}}@layer scalar-base,scalar-theme;@layer scalar-base{body{margin:0;line-height:inherit}:root{--scalar-border-width: .5px;--scalar-radius: 3px;--scalar-radius-lg: 6px;--scalar-radius-xl: 8px;--scalar-font: \"Inter\", -apple-system, BlinkMacSystemFont, \"Segoe UI\", Roboto, Oxygen, Ubuntu, Cantarell, \"Open Sans\", \"Helvetica Neue\", sans-serif;--scalar-font-code: \"JetBrains Mono\", ui-monospace, Menlo, Monaco, \"Cascadia Mono\", \"Segoe UI Mono\", \"Roboto Mono\", \"Oxygen Mono\", \"Ubuntu Monospace\", \"Source Code Pro\", \"Fira Mono\", \"Droid Sans Mono\", \"Courier New\", monospace;--scalar-heading-1: 40px;--scalar-page-description: 24px;--scalar-heading-2: 24px;--scalar-heading-3: 20px;--scalar-heading-4: 16px;--scalar-heading-5: 16px;--scalar-heading-6: 16px;--scalar-paragraph: 16px;--scalar-small: 14px;--scalar-mini: 13px;--scalar-micro: 12px;--scalar-bold: 600;--scalar-semibold: 500;--scalar-regular: 400;--scalar-font-size-1: 21px;--scalar-font-size-2: 16px;--scalar-font-size-3: 14px;--scalar-font-size-4: 13px;--scalar-font-size-5: 12px;--scalar-font-size-6: 12px;--scalar-font-size-7: 10px;--scalar-line-height-1: 32px;--scalar-line-height-2: 24px;--scalar-line-height-3: 20px;--scalar-line-height-4: 18px;--scalar-line-height-5: 16px;--scalar-font-medium: 500;--scalar-font-bold: 700;--scalar-text-decoration: none;--scalar-text-decoration-hover: underline;--scalar-link-font-weight: inherit;--scalar-sidebar-indent: 18px}.dark-mode{color-scheme:dark;--scalar-scrollbar-color: rgba(255, 255, 255, .18);--scalar-scrollbar-color-active: rgba(255, 255, 255, .36);--scalar-button-1: rgba(255, 255, 255, 1);--scalar-button-1-hover: rgba(255, 255, 255, .9);--scalar-button-1-color: black;--scalar-shadow-1: 0 1px 3px 0 rgb(0, 0, 0, .1);--scalar-shadow-2: 0 0 0 .5px var(--scalar-border-color), rgba(15, 15, 15, .2) 0px 3px 6px, rgba(15, 15, 15, .4) 0px 9px 24px;--scalar-lifted-brightness: 1.45;--scalar-backdrop-brightness: .5;--scalar-link-color: var(--scalar-color-accent);--scalar-link-color-hover: var(--scalar-color-accent);--scalar-text-decoration-color: currentColor;--scalar-text-decoration-color-hover: currentColor}.light-mode{color-scheme:light;--scalar-scrollbar-color-active: rgba(0, 0, 0, .36);--scalar-scrollbar-color: rgba(0, 0, 0, .18);--scalar-button-1: rgba(0, 0, 0, 1);--scalar-button-1-hover: rgba(0, 0, 0, .8);--scalar-button-1-color: rgba(255, 255, 255, .9);--scalar-shadow-1: 0 1px 3px 0 rgba(0, 0, 0, .11);--scalar-shadow-2: rgba(0, 0, 0, .08) 0px 13px 20px 0px, rgba(0, 0, 0, .08) 0px 3px 8px 0px, #eeeeed 0px 0 0 .5px;--scalar-lifted-brightness: 1;--scalar-backdrop-brightness: 1;--scalar-link-color: var(--scalar-color-accent);--scalar-link-color-hover: var(--scalar-color-accent);--scalar-text-decoration-color: currentColor;--scalar-text-decoration-color-hover: currentColor}.light-mode .dark-mode{color-scheme:dark!important}@media (max-width: 460px){:root{--scalar-font-size-1: 22px;--scalar-font-size-2: 14px;--scalar-font-size-3: 12px}}@media (max-width: 720px){:root{--scalar-heading-1: 24px;--scalar-page-description: 20px}}.light-mode{--scalar-background-1: #fff;--scalar-background-2: #f6f6f6;--scalar-background-3: #e7e7e7;--scalar-background-accent: #8ab4f81f;--scalar-color-1: #2a2f45;--scalar-color-2: #757575;--scalar-color-3: #8e8e8e;--scalar-color-accent: #0099ff;--scalar-border-color: #dfdfdf}.dark-mode{--scalar-background-1: #0f0f0f;--scalar-background-2: #1a1a1a;--scalar-background-3: #272727;--scalar-color-1: #e7e7e7;--scalar-color-2: #a4a4a4;--scalar-color-3: #797979;--scalar-color-accent: #3ea6ff;--scalar-background-accent: #3ea6ff1f;--scalar-border-color: #2d2d2d}.light-mode .t-doc__sidebar,.dark-mode .t-doc__sidebar{--scalar-sidebar-background-1: var(--scalar-background-1);--scalar-sidebar-color-1: var(--scalar-color-1);--scalar-sidebar-color-2: var(--scalar-color-2);--scalar-sidebar-border-color: var(--scalar-border-color);--scalar-sidebar-item-hover-background: var(--scalar-background-2);--scalar-sidebar-item-hover-color: currentColor;--scalar-sidebar-item-active-background: var(--scalar-background-2);--scalar-sidebar-color-active: var(--scalar-color-1);--scalar-sidebar-indent-border: var(--scalar-sidebar-border-color);--scalar-sidebar-indent-border-hover: var(--scalar-sidebar-border-color);--scalar-sidebar-indent-border-active: var(--scalar-sidebar-border-color);--scalar-sidebar-search-background: transparent;--scalar-sidebar-search-color: var(--scalar-color-3);--scalar-sidebar-search-border-color: var(--scalar-border-color)}.light-mode{--scalar-color-green: #069061;--scalar-color-red: #ef0006;--scalar-color-yellow: #edbe20;--scalar-color-blue: #0082d0;--scalar-color-orange: #fb892c;--scalar-color-purple: #5203d1;--scalar-button-1: rgba(0, 0, 0, 1);--scalar-button-1-hover: rgba(0, 0, 0, .8);--scalar-button-1-color: rgba(255, 255, 255, .9);--scalar-color-danger: color-mix(in srgb, var(--scalar-color-red), var(--scalar-color-1) 20%);--scalar-background-alert: color-mix(in srgb, var(--scalar-color-orange), var(--scalar-background-1) 95%);--scalar-background-danger: color-mix(in srgb, var(--scalar-color-red), var(--scalar-background-1) 95%)}.dark-mode{--scalar-color-green: #00b648;--scalar-color-red: #dc1b19;--scalar-color-yellow: #ffc90d;--scalar-color-blue: #4eb3ec;--scalar-color-orange: #ff8d4d;--scalar-color-purple: #b191f9;--scalar-button-1: rgba(255, 255, 255, 1);--scalar-button-1-hover: rgba(255, 255, 255, .9);--scalar-button-1-color: black;--scalar-color-danger: color-mix(in srgb, var(--scalar-color-red), var(--scalar-background-1) 20%);--scalar-background-alert: color-mix(in srgb, var(--scalar-color-orange), var(--scalar-background-1) 95%);--scalar-background-danger: color-mix(in srgb, var(--scalar-color-red), var(--scalar-background-1) 95%)}@supports (color: color(display-p3 1 1 1)){.light-mode{--scalar-color-accent: color(display-p3 0 .6 1 / 1);--scalar-color-green: color(display-p3 .023529 .564706 .380392 / 1);--scalar-color-red: color(display-p3 .937255 0 .023529 / 1);--scalar-color-yellow: color(display-p3 .929412 .745098 .12549 / 1);--scalar-color-blue: color(display-p3 0 .509804 .815686 / 1);--scalar-color-orange: color(display-p3 .984314 .537255 .172549 / 1);--scalar-color-purple: color(display-p3 .321569 .011765 .819608 / 1)}.dark-mode{--scalar-color-accent: color(display-p3 .243137 .65098 1 / 1);--scalar-color-green: color(display-p3 0 .713725 .282353 / 1);--scalar-color-red: color(display-p3 .862745 .105882 .098039 / 1);--scalar-color-yellow: color(display-p3 1 .788235 .05098 / 1);--scalar-color-blue: color(display-p3 .305882 .701961 .92549 / 1);--scalar-color-orange: color(display-p3 1 .552941 .301961 / 1);--scalar-color-purple: color(display-p3 .694118 .568627 .976471 / 1)}}*,:before,:after{--tw-border-spacing-x: 0;--tw-border-spacing-y: 0;--tw-translate-x: 0;--tw-translate-y: 0;--tw-rotate: 0;--tw-skew-x: 0;--tw-skew-y: 0;--tw-scale-x: 1;--tw-scale-y: 1;--tw-pan-x: ;--tw-pan-y: ;--tw-pinch-zoom: ;--tw-scroll-snap-strictness: proximity;--tw-gradient-from-position: ;--tw-gradient-via-position: ;--tw-gradient-to-position: ;--tw-ordinal: ;--tw-slashed-zero: ;--tw-numeric-figure: ;--tw-numeric-spacing: ;--tw-numeric-fraction: ;--tw-ring-inset: ;--tw-ring-offset-width: 0px;--tw-ring-offset-color: #fff;--tw-ring-color: rgb(59 130 246 / .5);--tw-ring-offset-shadow: 0 0 #0000;--tw-ring-shadow: 0 0 #0000;--tw-shadow: 0 0 #0000;--tw-shadow-colored: 0 0 #0000;--tw-blur: ;--tw-brightness: ;--tw-contrast: ;--tw-grayscale: ;--tw-hue-rotate: ;--tw-invert: ;--tw-saturate: ;--tw-sepia: ;--tw-drop-shadow: ;--tw-backdrop-blur: ;--tw-backdrop-brightness: ;--tw-backdrop-contrast: ;--tw-backdrop-grayscale: ;--tw-backdrop-hue-rotate: ;--tw-backdrop-invert: ;--tw-backdrop-opacity: ;--tw-backdrop-saturate: ;--tw-backdrop-sepia: ;--tw-contain-size: ;--tw-contain-layout: ;--tw-contain-paint: ;--tw-contain-style: }::backdrop{--tw-border-spacing-x: 0;--tw-border-spacing-y: 0;--tw-translate-x: 0;--tw-translate-y: 0;--tw-rotate: 0;--tw-skew-x: 0;--tw-skew-y: 0;--tw-scale-x: 1;--tw-scale-y: 1;--tw-pan-x: ;--tw-pan-y: ;--tw-pinch-zoom: ;--tw-scroll-snap-strictness: proximity;--tw-gradient-from-position: ;--tw-gradient-via-position: ;--tw-gradient-to-position: ;--tw-ordinal: ;--tw-slashed-zero: ;--tw-numeric-figure: ;--tw-numeric-spacing: ;--tw-numeric-fraction: ;--tw-ring-inset: ;--tw-ring-offset-width: 0px;--tw-ring-offset-color: #fff;--tw-ring-color: rgb(59 130 246 / .5);--tw-ring-offset-shadow: 0 0 #0000;--tw-ring-shadow: 0 0 #0000;--tw-shadow: 0 0 #0000;--tw-shadow-colored: 0 0 #0000;--tw-blur: ;--tw-brightness: ;--tw-contrast: ;--tw-grayscale: ;--tw-hue-rotate: ;--tw-invert: ;--tw-saturate: ;--tw-sepia: ;--tw-drop-shadow: ;--tw-backdrop-blur: ;--tw-backdrop-brightness: ;--tw-backdrop-contrast: ;--tw-backdrop-grayscale: ;--tw-backdrop-hue-rotate: ;--tw-backdrop-invert: ;--tw-backdrop-opacity: ;--tw-backdrop-saturate: ;--tw-backdrop-sepia: ;--tw-contain-size: ;--tw-contain-layout: ;--tw-contain-paint: ;--tw-contain-style: }}.scalar-app .markdown summary:after{display:block;content:\"\";position:absolute;top:-1px;left:-1px;width:20px;height:20px;background-color:var(--scalar-color-3);-webkit-mask-image:url('data:image/svg+xml,<svg viewBox=\"0 0 24 24\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"m9 18 6-6-6-6\" stroke=\"currentColor\" stroke-width=\"1.5\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/></svg>');mask-image:url('data:image/svg+xml,<svg viewBox=\"0 0 24 24\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"m9 18 6-6-6-6\" stroke=\"currentColor\" stroke-width=\"1.5\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/></svg>')}.scalar-app .markdown .markdown-alert.markdown-alert-note:before,.scalar-app .markdown .markdown-alert.markdown-alert-tip:before{-webkit-mask-image:url('data:image/svg+xml,<svg viewBox=\"0 0 24 24\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M12 17v-6a.5.5 0 0 0-.5-.5l-.5.001h-1M12 17h-2m2 0h2m-2 5c5.523 0 10-4.477 10-10S17.523 2 12 2 2 6.477 2 12s4.477 10 10 10Z\" stroke=\"currentColor\" stroke-width=\"1.5\" stroke-miterlimit=\"10\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M10.75 7.5a1 1 0 1 1 2 0 1 1 0 0 1-2 0Z\" fill=\"currentColor\"/></svg>');mask-image:url('data:image/svg+xml,<svg viewBox=\"0 0 24 24\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M12 17v-6a.5.5 0 0 0-.5-.5l-.5.001h-1M12 17h-2m2 0h2m-2 5c5.523 0 10-4.477 10-10S17.523 2 12 2 2 6.477 2 12s4.477 10 10 10Z\" stroke=\"currentColor\" stroke-width=\"1.5\" stroke-miterlimit=\"10\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M10.75 7.5a1 1 0 1 1 2 0 1 1 0 0 1-2 0Z\" fill=\"currentColor\"/></svg>')}.scalar-app .markdown .markdown-alert.markdown-alert-important:before,.scalar-app .markdown .markdown-alert.markdown-alert-warning:before{-webkit-mask-image:url('data:image/svg+xml,<svg viewBox=\"0 0 24 24\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M12 8v4m10 0c0 5.523-4.477 10-10 10S2 17.523 2 12 6.477 2 12 2s10 4.477 10 10Z\" stroke=\"currentColor\" stroke-width=\"1.5\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M11 16a1 1 0 1 1 2 0 1 1 0 0 1-2 0Z\" fill=\"currentColor\"/></svg>');mask-image:url('data:image/svg+xml,<svg viewBox=\"0 0 24 24\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M12 8v4m10 0c0 5.523-4.477 10-10 10S2 17.523 2 12 6.477 2 12 2s10 4.477 10 10Z\" stroke=\"currentColor\" stroke-width=\"1.5\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M11 16a1 1 0 1 1 2 0 1 1 0 0 1-2 0Z\" fill=\"currentColor\"/></svg>')}.scalar-app .markdown .markdown-alert.markdown-alert-caution:before{-webkit-mask-image:url('data:image/svg+xml,<svg viewBox=\"0 0 24 24\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M12 8v4m3.312-10a2 2 0 0 1 1.414.586l4.688 4.688A2 2 0 0 1 22 8.688v6.624a2 2 0 0 1-.586 1.414l-4.688 4.688a2 2 0 0 1-1.414.586H8.688a2 2 0 0 1-1.414-.586l-4.688-4.688A2 2 0 0 1 2 15.312V8.688a2 2 0 0 1 .586-1.414l4.688-4.688A2 2 0 0 1 8.688 2h6.624Z\" stroke=\"currentColor\" stroke-width=\"1.5\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M11 16a1 1 0 1 1 2 0 1 1 0 0 1-2 0Z\" fill=\"currentColor\"/></svg>');mask-image:url('data:image/svg+xml,<svg viewBox=\"0 0 24 24\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M12 8v4m3.312-10a2 2 0 0 1 1.414.586l4.688 4.688A2 2 0 0 1 22 8.688v6.624a2 2 0 0 1-.586 1.414l-4.688 4.688a2 2 0 0 1-1.414.586H8.688a2 2 0 0 1-1.414-.586l-4.688-4.688A2 2 0 0 1 2 15.312V8.688a2 2 0 0 1 .586-1.414l4.688-4.688A2 2 0 0 1 8.688 2h6.624Z\" stroke=\"currentColor\" stroke-width=\"1.5\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M11 16a1 1 0 1 1 2 0 1 1 0 0 1-2 0Z\" fill=\"currentColor\"/></svg>');color:var(--scalar-color-red)}.scalar-app .markdown .markdown-alert.markdown-alert-success:before{-webkit-mask-image:url('data:image/svg+xml,<svg viewBox=\"0 0 24 24\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M16 9.5 10.5 15 8 12.5m14-.5c0 5.523-4.477 10-10 10S2 17.523 2 12 6.477 2 12 2s10 4.477 10 10Z\" stroke=\"currentColor\" stroke-width=\"1.5\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/></svg>');mask-image:url('data:image/svg+xml,<svg viewBox=\"0 0 24 24\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M16 9.5 10.5 15 8 12.5m14-.5c0 5.523-4.477 10-10 10S2 17.523 2 12 6.477 2 12 2s10 4.477 10 10Z\" stroke=\"currentColor\" stroke-width=\"1.5\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/></svg>');color:var(--scalar-color-green)}@layer scalar-base,scalar-theme;@layer scalar-base{body{margin:0;line-height:inherit}:root{--scalar-border-width: .5px;--scalar-radius: 3px;--scalar-radius-lg: 6px;--scalar-radius-xl: 8px;--scalar-font: \"Inter\", -apple-system, BlinkMacSystemFont, \"Segoe UI\", Roboto, Oxygen, Ubuntu, Cantarell, \"Open Sans\", \"Helvetica Neue\", sans-serif;--scalar-font-code: \"JetBrains Mono\", ui-monospace, Menlo, Monaco, \"Cascadia Mono\", \"Segoe UI Mono\", \"Roboto Mono\", \"Oxygen Mono\", \"Ubuntu Monospace\", \"Source Code Pro\", \"Fira Mono\", \"Droid Sans Mono\", \"Courier New\", monospace;--scalar-heading-1: 40px;--scalar-page-description: 24px;--scalar-heading-2: 24px;--scalar-heading-3: 20px;--scalar-heading-4: 16px;--scalar-heading-5: 16px;--scalar-heading-6: 16px;--scalar-paragraph: 16px;--scalar-small: 14px;--scalar-mini: 13px;--scalar-micro: 12px;--scalar-bold: 600;--scalar-semibold: 500;--scalar-regular: 400;--scalar-font-size-1: 21px;--scalar-font-size-2: 16px;--scalar-font-size-3: 14px;--scalar-font-size-4: 13px;--scalar-font-size-5: 12px;--scalar-font-size-6: 12px;--scalar-font-size-7: 10px;--scalar-line-height-1: 32px;--scalar-line-height-2: 24px;--scalar-line-height-3: 20px;--scalar-line-height-4: 18px;--scalar-line-height-5: 16px;--scalar-font-medium: 500;--scalar-font-bold: 700;--scalar-text-decoration: none;--scalar-text-decoration-hover: underline;--scalar-link-font-weight: inherit;--scalar-sidebar-indent: 18px}.dark-mode{color-scheme:dark;--scalar-scrollbar-color: rgba(255, 255, 255, .18);--scalar-scrollbar-color-active: rgba(255, 255, 255, .36);--scalar-button-1: rgba(255, 255, 255, 1);--scalar-button-1-hover: rgba(255, 255, 255, .9);--scalar-button-1-color: black;--scalar-shadow-1: 0 1px 3px 0 rgb(0, 0, 0, .1);--scalar-shadow-2: 0 0 0 .5px var(--scalar-border-color), rgba(15, 15, 15, .2) 0px 3px 6px, rgba(15, 15, 15, .4) 0px 9px 24px;--scalar-lifted-brightness: 1.45;--scalar-backdrop-brightness: .5;--scalar-link-color: var(--scalar-color-accent);--scalar-link-color-hover: var(--scalar-color-accent);--scalar-text-decoration-color: currentColor;--scalar-text-decoration-color-hover: currentColor}.light-mode{color-scheme:light;--scalar-scrollbar-color-active: rgba(0, 0, 0, .36);--scalar-scrollbar-color: rgba(0, 0, 0, .18);--scalar-button-1: rgba(0, 0, 0, 1);--scalar-button-1-hover: rgba(0, 0, 0, .8);--scalar-button-1-color: rgba(255, 255, 255, .9);--scalar-shadow-1: 0 1px 3px 0 rgba(0, 0, 0, .11);--scalar-shadow-2: rgba(0, 0, 0, .08) 0px 13px 20px 0px, rgba(0, 0, 0, .08) 0px 3px 8px 0px, #eeeeed 0px 0 0 .5px;--scalar-lifted-brightness: 1;--scalar-backdrop-brightness: 1;--scalar-link-color: var(--scalar-color-accent);--scalar-link-color-hover: var(--scalar-color-accent);--scalar-text-decoration-color: currentColor;--scalar-text-decoration-color-hover: currentColor}.light-mode .dark-mode{color-scheme:dark!important}@media (max-width: 460px){:root{--scalar-font-size-1: 22px;--scalar-font-size-2: 14px;--scalar-font-size-3: 12px}}@media (max-width: 720px){:root{--scalar-heading-1: 24px;--scalar-page-description: 20px}}.light-mode{--scalar-background-1: #fff;--scalar-background-2: #f6f6f6;--scalar-background-3: #e7e7e7;--scalar-background-accent: #8ab4f81f;--scalar-color-1: #2a2f45;--scalar-color-2: #757575;--scalar-color-3: #8e8e8e;--scalar-color-accent: #0099ff;--scalar-border-color: #dfdfdf}.dark-mode{--scalar-background-1: #0f0f0f;--scalar-background-2: #1a1a1a;--scalar-background-3: #272727;--scalar-color-1: #e7e7e7;--scalar-color-2: #a4a4a4;--scalar-color-3: #797979;--scalar-color-accent: #3ea6ff;--scalar-background-accent: #3ea6ff1f;--scalar-border-color: #2d2d2d}.light-mode .t-doc__sidebar,.dark-mode .t-doc__sidebar{--scalar-sidebar-background-1: var(--scalar-background-1);--scalar-sidebar-color-1: var(--scalar-color-1);--scalar-sidebar-color-2: var(--scalar-color-2);--scalar-sidebar-border-color: var(--scalar-border-color);--scalar-sidebar-item-hover-background: var(--scalar-background-2);--scalar-sidebar-item-hover-color: currentColor;--scalar-sidebar-item-active-background: var(--scalar-background-2);--scalar-sidebar-color-active: var(--scalar-color-1);--scalar-sidebar-indent-border: var(--scalar-sidebar-border-color);--scalar-sidebar-indent-border-hover: var(--scalar-sidebar-border-color);--scalar-sidebar-indent-border-active: var(--scalar-sidebar-border-color);--scalar-sidebar-search-background: transparent;--scalar-sidebar-search-color: var(--scalar-color-3);--scalar-sidebar-search-border-color: var(--scalar-border-color)}.light-mode{--scalar-color-green: #069061;--scalar-color-red: #ef0006;--scalar-color-yellow: #edbe20;--scalar-color-blue: #0082d0;--scalar-color-orange: #fb892c;--scalar-color-purple: #5203d1;--scalar-button-1: rgba(0, 0, 0, 1);--scalar-button-1-hover: rgba(0, 0, 0, .8);--scalar-button-1-color: rgba(255, 255, 255, .9);--scalar-color-danger: color-mix(in srgb, var(--scalar-color-red), var(--scalar-color-1) 20%);--scalar-background-alert: color-mix(in srgb, var(--scalar-color-orange), var(--scalar-background-1) 95%);--scalar-background-danger: color-mix(in srgb, var(--scalar-color-red), var(--scalar-background-1) 95%)}.dark-mode{--scalar-color-green: #00b648;--scalar-color-red: #dc1b19;--scalar-color-yellow: #ffc90d;--scalar-color-blue: #4eb3ec;--scalar-color-orange: #ff8d4d;--scalar-color-purple: #b191f9;--scalar-button-1: rgba(255, 255, 255, 1);--scalar-button-1-hover: rgba(255, 255, 255, .9);--scalar-button-1-color: black;--scalar-color-danger: color-mix(in srgb, var(--scalar-color-red), var(--scalar-background-1) 20%);--scalar-background-alert: color-mix(in srgb, var(--scalar-color-orange), var(--scalar-background-1) 95%);--scalar-background-danger: color-mix(in srgb, var(--scalar-color-red), var(--scalar-background-1) 95%)}@supports (color: color(display-p3 1 1 1)){.light-mode{--scalar-color-accent: color(display-p3 0 .6 1 / 1);--scalar-color-green: color(display-p3 .023529 .564706 .380392 / 1);--scalar-color-red: color(display-p3 .937255 0 .023529 / 1);--scalar-color-yellow: color(display-p3 .929412 .745098 .12549 / 1);--scalar-color-blue: color(display-p3 0 .509804 .815686 / 1);--scalar-color-orange: color(display-p3 .984314 .537255 .172549 / 1);--scalar-color-purple: color(display-p3 .321569 .011765 .819608 / 1)}.dark-mode{--scalar-color-accent: color(display-p3 .243137 .65098 1 / 1);--scalar-color-green: color(display-p3 0 .713725 .282353 / 1);--scalar-color-red: color(display-p3 .862745 .105882 .098039 / 1);--scalar-color-yellow: color(display-p3 1 .788235 .05098 / 1);--scalar-color-blue: color(display-p3 .305882 .701961 .92549 / 1);--scalar-color-orange: color(display-p3 1 .552941 .301961 / 1);--scalar-color-purple: color(display-p3 .694118 .568627 .976471 / 1)}}*,:before,:after{--tw-border-spacing-x:0;--tw-border-spacing-y:0;--tw-translate-x:0;--tw-translate-y:0;--tw-rotate:0;--tw-skew-x:0;--tw-skew-y:0;--tw-scale-x:1;--tw-scale-y:1;--tw-pan-x: ;--tw-pan-y: ;--tw-pinch-zoom: ;--tw-scroll-snap-strictness:proximity;--tw-gradient-from-position: ;--tw-gradient-via-position: ;--tw-gradient-to-position: ;--tw-ordinal: ;--tw-slashed-zero: ;--tw-numeric-figure: ;--tw-numeric-spacing: ;--tw-numeric-fraction: ;--tw-ring-inset: ;--tw-ring-offset-width:0px;--tw-ring-offset-color:#fff;--tw-ring-color:rgb(59 130 246 / .5);--tw-ring-offset-shadow:0 0 #0000;--tw-ring-shadow:0 0 #0000;--tw-shadow:0 0 #0000;--tw-shadow-colored:0 0 #0000;--tw-blur: ;--tw-brightness: ;--tw-contrast: ;--tw-grayscale: ;--tw-hue-rotate: ;--tw-invert: ;--tw-saturate: ;--tw-sepia: ;--tw-drop-shadow: ;--tw-backdrop-blur: ;--tw-backdrop-brightness: ;--tw-backdrop-contrast: ;--tw-backdrop-grayscale: ;--tw-backdrop-hue-rotate: ;--tw-backdrop-invert: ;--tw-backdrop-opacity: ;--tw-backdrop-saturate: ;--tw-backdrop-sepia: ;--tw-contain-size: ;--tw-contain-layout: ;--tw-contain-paint: ;--tw-contain-style: }::backdrop{--tw-border-spacing-x:0;--tw-border-spacing-y:0;--tw-translate-x:0;--tw-translate-y:0;--tw-rotate:0;--tw-skew-x:0;--tw-skew-y:0;--tw-scale-x:1;--tw-scale-y:1;--tw-pan-x: ;--tw-pan-y: ;--tw-pinch-zoom: ;--tw-scroll-snap-strictness:proximity;--tw-gradient-from-position: ;--tw-gradient-via-position: ;--tw-gradient-to-position: ;--tw-ordinal: ;--tw-slashed-zero: ;--tw-numeric-figure: ;--tw-numeric-spacing: ;--tw-numeric-fraction: ;--tw-ring-inset: ;--tw-ring-offset-width:0px;--tw-ring-offset-color:#fff;--tw-ring-color:rgb(59 130 246 / .5);--tw-ring-offset-shadow:0 0 #0000;--tw-ring-shadow:0 0 #0000;--tw-shadow:0 0 #0000;--tw-shadow-colored:0 0 #0000;--tw-blur: ;--tw-brightness: ;--tw-contrast: ;--tw-grayscale: ;--tw-hue-rotate: ;--tw-invert: ;--tw-saturate: ;--tw-sepia: ;--tw-drop-shadow: ;--tw-backdrop-blur: ;--tw-backdrop-brightness: ;--tw-backdrop-contrast: ;--tw-backdrop-grayscale: ;--tw-backdrop-hue-rotate: ;--tw-backdrop-invert: ;--tw-backdrop-opacity: ;--tw-backdrop-saturate: ;--tw-backdrop-sepia: ;--tw-contain-size: ;--tw-contain-layout: ;--tw-contain-paint: ;--tw-contain-style: }}@layer scalar-base,scalar-theme;@layer scalar-base{body{margin:0;line-height:inherit}:root{--scalar-border-width: .5px;--scalar-radius: 3px;--scalar-radius-lg: 6px;--scalar-radius-xl: 8px;--scalar-font: \"Inter\", -apple-system, BlinkMacSystemFont, \"Segoe UI\", Roboto, Oxygen, Ubuntu, Cantarell, \"Open Sans\", \"Helvetica Neue\", sans-serif;--scalar-font-code: \"JetBrains Mono\", ui-monospace, Menlo, Monaco, \"Cascadia Mono\", \"Segoe UI Mono\", \"Roboto Mono\", \"Oxygen Mono\", \"Ubuntu Monospace\", \"Source Code Pro\", \"Fira Mono\", \"Droid Sans Mono\", \"Courier New\", monospace;--scalar-heading-1: 40px;--scalar-page-description: 24px;--scalar-heading-2: 24px;--scalar-heading-3: 20px;--scalar-heading-4: 16px;--scalar-heading-5: 16px;--scalar-heading-6: 16px;--scalar-paragraph: 16px;--scalar-small: 14px;--scalar-mini: 13px;--scalar-micro: 12px;--scalar-bold: 600;--scalar-semibold: 500;--scalar-regular: 400;--scalar-font-size-1: 21px;--scalar-font-size-2: 16px;--scalar-font-size-3: 14px;--scalar-font-size-4: 13px;--scalar-font-size-5: 12px;--scalar-font-size-6: 12px;--scalar-font-size-7: 10px;--scalar-line-height-1: 32px;--scalar-line-height-2: 24px;--scalar-line-height-3: 20px;--scalar-line-height-4: 18px;--scalar-line-height-5: 16px;--scalar-font-medium: 500;--scalar-font-bold: 700;--scalar-text-decoration: none;--scalar-text-decoration-hover: underline;--scalar-link-font-weight: inherit;--scalar-sidebar-indent: 18px}.dark-mode{color-scheme:dark;--scalar-scrollbar-color: rgba(255, 255, 255, .18);--scalar-scrollbar-color-active: rgba(255, 255, 255, .36);--scalar-button-1: rgba(255, 255, 255, 1);--scalar-button-1-hover: rgba(255, 255, 255, .9);--scalar-button-1-color: black;--scalar-shadow-1: 0 1px 3px 0 rgb(0, 0, 0, .1);--scalar-shadow-2: 0 0 0 .5px var(--scalar-border-color), rgba(15, 15, 15, .2) 0px 3px 6px, rgba(15, 15, 15, .4) 0px 9px 24px;--scalar-lifted-brightness: 1.45;--scalar-backdrop-brightness: .5;--scalar-link-color: var(--scalar-color-accent);--scalar-link-color-hover: var(--scalar-color-accent);--scalar-text-decoration-color: currentColor;--scalar-text-decoration-color-hover: currentColor}.light-mode{color-scheme:light;--scalar-scrollbar-color-active: rgba(0, 0, 0, .36);--scalar-scrollbar-color: rgba(0, 0, 0, .18);--scalar-button-1: rgba(0, 0, 0, 1);--scalar-button-1-hover: rgba(0, 0, 0, .8);--scalar-button-1-color: rgba(255, 255, 255, .9);--scalar-shadow-1: 0 1px 3px 0 rgba(0, 0, 0, .11);--scalar-shadow-2: rgba(0, 0, 0, .08) 0px 13px 20px 0px, rgba(0, 0, 0, .08) 0px 3px 8px 0px, #eeeeed 0px 0 0 .5px;--scalar-lifted-brightness: 1;--scalar-backdrop-brightness: 1;--scalar-link-color: var(--scalar-color-accent);--scalar-link-color-hover: var(--scalar-color-accent);--scalar-text-decoration-color: currentColor;--scalar-text-decoration-color-hover: currentColor}.light-mode .dark-mode{color-scheme:dark!important}@media (max-width: 460px){:root{--scalar-font-size-1: 22px;--scalar-font-size-2: 14px;--scalar-font-size-3: 12px}}@media (max-width: 720px){:root{--scalar-heading-1: 24px;--scalar-page-description: 20px}}.light-mode{--scalar-background-1: #fff;--scalar-background-2: #f6f6f6;--scalar-background-3: #e7e7e7;--scalar-background-accent: #8ab4f81f;--scalar-color-1: #2a2f45;--scalar-color-2: #757575;--scalar-color-3: #8e8e8e;--scalar-color-accent: #0099ff;--scalar-border-color: #dfdfdf}.dark-mode{--scalar-background-1: #0f0f0f;--scalar-background-2: #1a1a1a;--scalar-background-3: #272727;--scalar-color-1: #e7e7e7;--scalar-color-2: #a4a4a4;--scalar-color-3: #797979;--scalar-color-accent: #3ea6ff;--scalar-background-accent: #3ea6ff1f;--scalar-border-color: #2d2d2d}.light-mode .t-doc__sidebar,.dark-mode .t-doc__sidebar{--scalar-sidebar-background-1: var(--scalar-background-1);--scalar-sidebar-color-1: var(--scalar-color-1);--scalar-sidebar-color-2: var(--scalar-color-2);--scalar-sidebar-border-color: var(--scalar-border-color);--scalar-sidebar-item-hover-background: var(--scalar-background-2);--scalar-sidebar-item-hover-color: currentColor;--scalar-sidebar-item-active-background: var(--scalar-background-2);--scalar-sidebar-color-active: var(--scalar-color-1);--scalar-sidebar-indent-border: var(--scalar-sidebar-border-color);--scalar-sidebar-indent-border-hover: var(--scalar-sidebar-border-color);--scalar-sidebar-indent-border-active: var(--scalar-sidebar-border-color);--scalar-sidebar-search-background: transparent;--scalar-sidebar-search-color: var(--scalar-color-3);--scalar-sidebar-search-border-color: var(--scalar-border-color)}.light-mode{--scalar-color-green: #069061;--scalar-color-red: #ef0006;--scalar-color-yellow: #edbe20;--scalar-color-blue: #0082d0;--scalar-color-orange: #fb892c;--scalar-color-purple: #5203d1;--scalar-button-1: rgba(0, 0, 0, 1);--scalar-button-1-hover: rgba(0, 0, 0, .8);--scalar-button-1-color: rgba(255, 255, 255, .9);--scalar-color-danger: color-mix(in srgb, var(--scalar-color-red), var(--scalar-color-1) 20%);--scalar-background-alert: color-mix(in srgb, var(--scalar-color-orange), var(--scalar-background-1) 95%);--scalar-background-danger: color-mix(in srgb, var(--scalar-color-red), var(--scalar-background-1) 95%)}.dark-mode{--scalar-color-green: #00b648;--scalar-color-red: #dc1b19;--scalar-color-yellow: #ffc90d;--scalar-color-blue: #4eb3ec;--scalar-color-orange: #ff8d4d;--scalar-color-purple: #b191f9;--scalar-button-1: rgba(255, 255, 255, 1);--scalar-button-1-hover: rgba(255, 255, 255, .9);--scalar-button-1-color: black;--scalar-color-danger: color-mix(in srgb, var(--scalar-color-red), var(--scalar-background-1) 20%);--scalar-background-alert: color-mix(in srgb, var(--scalar-color-orange), var(--scalar-background-1) 95%);--scalar-background-danger: color-mix(in srgb, var(--scalar-color-red), var(--scalar-background-1) 95%)}@supports (color: color(display-p3 1 1 1)){.light-mode{--scalar-color-accent: color(display-p3 0 .6 1 / 1);--scalar-color-green: color(display-p3 .023529 .564706 .380392 / 1);--scalar-color-red: color(display-p3 .937255 0 .023529 / 1);--scalar-color-yellow: color(display-p3 .929412 .745098 .12549 / 1);--scalar-color-blue: color(display-p3 0 .509804 .815686 / 1);--scalar-color-orange: color(display-p3 .984314 .537255 .172549 / 1);--scalar-color-purple: color(display-p3 .321569 .011765 .819608 / 1)}.dark-mode{--scalar-color-accent: color(display-p3 .243137 .65098 1 / 1);--scalar-color-green: color(display-p3 0 .713725 .282353 / 1);--scalar-color-red: color(display-p3 .862745 .105882 .098039 / 1);--scalar-color-yellow: color(display-p3 1 .788235 .05098 / 1);--scalar-color-blue: color(display-p3 .305882 .701961 .92549 / 1);--scalar-color-orange: color(display-p3 1 .552941 .301961 / 1);--scalar-color-purple: color(display-p3 .694118 .568627 .976471 / 1)}}*,:before,:after{--tw-border-spacing-x: 0;--tw-border-spacing-y: 0;--tw-translate-x: 0;--tw-translate-y: 0;--tw-rotate: 0;--tw-skew-x: 0;--tw-skew-y: 0;--tw-scale-x: 1;--tw-scale-y: 1;--tw-pan-x: ;--tw-pan-y: ;--tw-pinch-zoom: ;--tw-scroll-snap-strictness: proximity;--tw-gradient-from-position: ;--tw-gradient-via-position: ;--tw-gradient-to-position: ;--tw-ordinal: ;--tw-slashed-zero: ;--tw-numeric-figure: ;--tw-numeric-spacing: ;--tw-numeric-fraction: ;--tw-ring-inset: ;--tw-ring-offset-width: 0px;--tw-ring-offset-color: #fff;--tw-ring-color: rgb(59 130 246 / .5);--tw-ring-offset-shadow: 0 0 #0000;--tw-ring-shadow: 0 0 #0000;--tw-shadow: 0 0 #0000;--tw-shadow-colored: 0 0 #0000;--tw-blur: ;--tw-brightness: ;--tw-contrast: ;--tw-grayscale: ;--tw-hue-rotate: ;--tw-invert: ;--tw-saturate: ;--tw-sepia: ;--tw-drop-shadow: ;--tw-backdrop-blur: ;--tw-backdrop-brightness: ;--tw-backdrop-contrast: ;--tw-backdrop-grayscale: ;--tw-backdrop-hue-rotate: ;--tw-backdrop-invert: ;--tw-backdrop-opacity: ;--tw-backdrop-saturate: ;--tw-backdrop-sepia: ;--tw-contain-size: ;--tw-contain-layout: ;--tw-contain-paint: ;--tw-contain-style: }::backdrop{--tw-border-spacing-x: 0;--tw-border-spacing-y: 0;--tw-translate-x: 0;--tw-translate-y: 0;--tw-rotate: 0;--tw-skew-x: 0;--tw-skew-y: 0;--tw-scale-x: 1;--tw-scale-y: 1;--tw-pan-x: ;--tw-pan-y: ;--tw-pinch-zoom: ;--tw-scroll-snap-strictness: proximity;--tw-gradient-from-position: ;--tw-gradient-via-position: ;--tw-gradient-to-position: ;--tw-ordinal: ;--tw-slashed-zero: ;--tw-numeric-figure: ;--tw-numeric-spacing: ;--tw-numeric-fraction: ;--tw-ring-inset: ;--tw-ring-offset-width: 0px;--tw-ring-offset-color: #fff;--tw-ring-color: rgb(59 130 246 / .5);--tw-ring-offset-shadow: 0 0 #0000;--tw-ring-shadow: 0 0 #0000;--tw-shadow: 0 0 #0000;--tw-shadow-colored: 0 0 #0000;--tw-blur: ;--tw-brightness: ;--tw-contrast: ;--tw-grayscale: ;--tw-hue-rotate: ;--tw-invert: ;--tw-saturate: ;--tw-sepia: ;--tw-drop-shadow: ;--tw-backdrop-blur: ;--tw-backdrop-brightness: ;--tw-backdrop-contrast: ;--tw-backdrop-grayscale: ;--tw-backdrop-hue-rotate: ;--tw-backdrop-invert: ;--tw-backdrop-opacity: ;--tw-backdrop-saturate: ;--tw-backdrop-sepia: ;--tw-contain-size: ;--tw-contain-layout: ;--tw-contain-paint: ;--tw-contain-style: }}.scalar-app .markdown summary:after{display:block;content:\"\";position:absolute;top:-1px;left:-1px;width:20px;height:20px;background-color:var(--scalar-color-3);-webkit-mask-image:url('data:image/svg+xml,<svg viewBox=\"0 0 24 24\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"m9 18 6-6-6-6\" stroke=\"currentColor\" stroke-width=\"1.5\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/></svg>');mask-image:url('data:image/svg+xml,<svg viewBox=\"0 0 24 24\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"m9 18 6-6-6-6\" stroke=\"currentColor\" stroke-width=\"1.5\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/></svg>')}.scalar-app .markdown .markdown-alert.markdown-alert-note:before,.scalar-app .markdown .markdown-alert.markdown-alert-tip:before{-webkit-mask-image:url('data:image/svg+xml,<svg viewBox=\"0 0 24 24\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M12 17v-6a.5.5 0 0 0-.5-.5l-.5.001h-1M12 17h-2m2 0h2m-2 5c5.523 0 10-4.477 10-10S17.523 2 12 2 2 6.477 2 12s4.477 10 10 10Z\" stroke=\"currentColor\" stroke-width=\"1.5\" stroke-miterlimit=\"10\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M10.75 7.5a1 1 0 1 1 2 0 1 1 0 0 1-2 0Z\" fill=\"currentColor\"/></svg>');mask-image:url('data:image/svg+xml,<svg viewBox=\"0 0 24 24\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M12 17v-6a.5.5 0 0 0-.5-.5l-.5.001h-1M12 17h-2m2 0h2m-2 5c5.523 0 10-4.477 10-10S17.523 2 12 2 2 6.477 2 12s4.477 10 10 10Z\" stroke=\"currentColor\" stroke-width=\"1.5\" stroke-miterlimit=\"10\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M10.75 7.5a1 1 0 1 1 2 0 1 1 0 0 1-2 0Z\" fill=\"currentColor\"/></svg>')}.scalar-app .markdown .markdown-alert.markdown-alert-important:before,.scalar-app .markdown .markdown-alert.markdown-alert-warning:before{-webkit-mask-image:url('data:image/svg+xml,<svg viewBox=\"0 0 24 24\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M12 8v4m10 0c0 5.523-4.477 10-10 10S2 17.523 2 12 6.477 2 12 2s10 4.477 10 10Z\" stroke=\"currentColor\" stroke-width=\"1.5\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M11 16a1 1 0 1 1 2 0 1 1 0 0 1-2 0Z\" fill=\"currentColor\"/></svg>');mask-image:url('data:image/svg+xml,<svg viewBox=\"0 0 24 24\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M12 8v4m10 0c0 5.523-4.477 10-10 10S2 17.523 2 12 6.477 2 12 2s10 4.477 10 10Z\" stroke=\"currentColor\" stroke-width=\"1.5\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M11 16a1 1 0 1 1 2 0 1 1 0 0 1-2 0Z\" fill=\"currentColor\"/></svg>')}.scalar-app .markdown .markdown-alert.markdown-alert-caution:before{-webkit-mask-image:url('data:image/svg+xml,<svg viewBox=\"0 0 24 24\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M12 8v4m3.312-10a2 2 0 0 1 1.414.586l4.688 4.688A2 2 0 0 1 22 8.688v6.624a2 2 0 0 1-.586 1.414l-4.688 4.688a2 2 0 0 1-1.414.586H8.688a2 2 0 0 1-1.414-.586l-4.688-4.688A2 2 0 0 1 2 15.312V8.688a2 2 0 0 1 .586-1.414l4.688-4.688A2 2 0 0 1 8.688 2h6.624Z\" stroke=\"currentColor\" stroke-width=\"1.5\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M11 16a1 1 0 1 1 2 0 1 1 0 0 1-2 0Z\" fill=\"currentColor\"/></svg>');mask-image:url('data:image/svg+xml,<svg viewBox=\"0 0 24 24\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M12 8v4m3.312-10a2 2 0 0 1 1.414.586l4.688 4.688A2 2 0 0 1 22 8.688v6.624a2 2 0 0 1-.586 1.414l-4.688 4.688a2 2 0 0 1-1.414.586H8.688a2 2 0 0 1-1.414-.586l-4.688-4.688A2 2 0 0 1 2 15.312V8.688a2 2 0 0 1 .586-1.414l4.688-4.688A2 2 0 0 1 8.688 2h6.624Z\" stroke=\"currentColor\" stroke-width=\"1.5\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M11 16a1 1 0 1 1 2 0 1 1 0 0 1-2 0Z\" fill=\"currentColor\"/></svg>');color:var(--scalar-color-red)}.scalar-app .markdown .markdown-alert.markdown-alert-success:before{-webkit-mask-image:url('data:image/svg+xml,<svg viewBox=\"0 0 24 24\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M16 9.5 10.5 15 8 12.5m14-.5c0 5.523-4.477 10-10 10S2 17.523 2 12 6.477 2 12 2s10 4.477 10 10Z\" stroke=\"currentColor\" stroke-width=\"1.5\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/></svg>');mask-image:url('data:image/svg+xml,<svg viewBox=\"0 0 24 24\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M16 9.5 10.5 15 8 12.5m14-.5c0 5.523-4.477 10-10 10S2 17.523 2 12 6.477 2 12 2s10 4.477 10 10Z\" stroke=\"currentColor\" stroke-width=\"1.5\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/></svg>');color:var(--scalar-color-green)}@layer scalar-base{*,:before,:after{--tw-border-spacing-x:0;--tw-border-spacing-y:0;--tw-translate-x:0;--tw-translate-y:0;--tw-rotate:0;--tw-skew-x:0;--tw-skew-y:0;--tw-scale-x:1;--tw-scale-y:1;--tw-pan-x: ;--tw-pan-y: ;--tw-pinch-zoom: ;--tw-scroll-snap-strictness:proximity;--tw-gradient-from-position: ;--tw-gradient-via-position: ;--tw-gradient-to-position: ;--tw-ordinal: ;--tw-slashed-zero: ;--tw-numeric-figure: ;--tw-numeric-spacing: ;--tw-numeric-fraction: ;--tw-ring-inset: ;--tw-ring-offset-width:0px;--tw-ring-offset-color:#fff;--tw-ring-color:rgb(59 130 246 / .5);--tw-ring-offset-shadow:0 0 #0000;--tw-ring-shadow:0 0 #0000;--tw-shadow:0 0 #0000;--tw-shadow-colored:0 0 #0000;--tw-blur: ;--tw-brightness: ;--tw-contrast: ;--tw-grayscale: ;--tw-hue-rotate: ;--tw-invert: ;--tw-saturate: ;--tw-sepia: ;--tw-drop-shadow: ;--tw-backdrop-blur: ;--tw-backdrop-brightness: ;--tw-backdrop-contrast: ;--tw-backdrop-grayscale: ;--tw-backdrop-hue-rotate: ;--tw-backdrop-invert: ;--tw-backdrop-opacity: ;--tw-backdrop-saturate: ;--tw-backdrop-sepia: ;--tw-contain-size: ;--tw-contain-layout: ;--tw-contain-paint: ;--tw-contain-style: }::backdrop{--tw-border-spacing-x:0;--tw-border-spacing-y:0;--tw-translate-x:0;--tw-translate-y:0;--tw-rotate:0;--tw-skew-x:0;--tw-skew-y:0;--tw-scale-x:1;--tw-scale-y:1;--tw-pan-x: ;--tw-pan-y: ;--tw-pinch-zoom: ;--tw-scroll-snap-strictness:proximity;--tw-gradient-from-position: ;--tw-gradient-via-position: ;--tw-gradient-to-position: ;--tw-ordinal: ;--tw-slashed-zero: ;--tw-numeric-figure: ;--tw-numeric-spacing: ;--tw-numeric-fraction: ;--tw-ring-inset: ;--tw-ring-offset-width:0px;--tw-ring-offset-color:#fff;--tw-ring-color:rgb(59 130 246 / .5);--tw-ring-offset-shadow:0 0 #0000;--tw-ring-shadow:0 0 #0000;--tw-shadow:0 0 #0000;--tw-shadow-colored:0 0 #0000;--tw-blur: ;--tw-brightness: ;--tw-contrast: ;--tw-grayscale: ;--tw-hue-rotate: ;--tw-invert: ;--tw-saturate: ;--tw-sepia: ;--tw-drop-shadow: ;--tw-backdrop-blur: ;--tw-backdrop-brightness: ;--tw-backdrop-contrast: ;--tw-backdrop-grayscale: ;--tw-backdrop-hue-rotate: ;--tw-backdrop-invert: ;--tw-backdrop-opacity: ;--tw-backdrop-saturate: ;--tw-backdrop-sepia: ;--tw-contain-size: ;--tw-contain-layout: ;--tw-contain-paint: ;--tw-contain-style: }}.scalar .scalar-app-layout[data-v-2835f298]{background:var(--scalar-background-1);height:calc(100% - 120px);max-width:1390px;width:100%;margin:auto;opacity:0;animation:scalarapiclientfadein-2835f298 .35s forwards;position:relative;overflow:hidden;border-radius:8px;border:var(--scalar-border-width) solid var(--scalar-border-color)}@media (max-width: 720px) and (max-height: 480px){.scalar .scalar-app-layout[data-v-2835f298]{height:100%;max-height:90svh}}@keyframes scalarapiclientfadein-2835f298{0%{opacity:0}to{opacity:1}}.scalar .scalar-app-exit[data-v-2835f298]{position:fixed;top:0;left:0;width:100vw;height:100vh;background:#00000038;transition:all .3s ease-in-out;cursor:pointer;animation:scalardrawerexitfadein-2835f298 .35s forwards}.dark-mode .scalar .scalar-app-exit[data-v-2835f298]{background:#00000073}.scalar .scalar-app-exit[data-v-2835f298]:before{font-family:sans-serif;position:absolute;top:0;font-size:30px;font-weight:100;line-height:50px;right:12px;text-align:center;color:#fff;opacity:.6}.scalar .scalar-app-exit[data-v-2835f298]:hover:before{opacity:1}@keyframes scalardrawerexitfadein-2835f298{0%{opacity:0}to{opacity:1}}.scalar-container[data-v-2835f298]{overflow:hidden;visibility:visible;position:fixed;bottom:0;top:0;left:0;width:100%;height:100%;display:flex;align-items:center;justify-content:center;z-index:10000}.scalar .url-form-input[data-v-2835f298]{min-height:auto!important}.scalar .scalar-container[data-v-2835f298]{line-height:normal}.scalar .scalar-app-header span[data-v-2835f298]{color:var(--scalar-color-3)}.scalar .scalar-app-header a[data-v-2835f298]{color:var(--scalar-color-1)}.scalar .scalar-app-header a[data-v-2835f298]:hover{text-decoration:underline}.scalar-activate[data-v-2835f298]{width:-moz-fit-content;width:fit-content;margin:0px .75rem .75rem auto;line-height:24px;cursor:pointer;font-size:.875rem;font-weight:600;display:flex;align-items:center;gap:6px}.scalar-activate-button[data-v-2835f298]{display:flex;gap:6px;align-items:center;color:var(--scalar-color-blue);-webkit-appearance:none;-moz-appearance:none;appearance:none;outline:none;border:none;background:transparent;padding:0 .5rem}.scalar-activate:hover .scalar-activate-button[data-v-2835f298]{background:var(--scalar-background-3);border-radius:3px}.scalar-modal-layout .scalar-button-danger[data-v-c6b17e96]{background:color-mix(in srgb,var(--scalar-color-red),transparent 95%);color:var(--scalar-color-red)}.scalar-modal-layout .scalar-button-danger[data-v-c6b17e96]:hover,.scalar-modal-layout .scalar-button-danger[data-v-c6b17e96]:focus{background:color-mix(in srgb,var(--scalar-color-red),transparent 90%)}.fade-request-section-content[data-v-a82399a9]{background:linear-gradient(to left,var(--scalar-background-1) 64%,transparent)}.filter-hover[data-v-a82399a9]{height:100%;padding-right:39px;padding-left:24px;position:absolute;right:0;transition:width 0s ease-in-out .2s;overflow:hidden}.filter-hover[data-v-a82399a9]:hover,.filter-hover[data-v-a82399a9]:has(:focus-visible){width:100%;z-index:10}.filter-hover[data-v-a82399a9]:before{content:\"\";position:absolute;top:0;left:0;width:100%;height:100%;background-color:var(--scalar-background-1);opacity:0;transition:all .3s ease-in-out;pointer-events:none}.filter-hover-item[data-v-a82399a9]{opacity:0}.filter-hover-item[data-v-a82399a9]:not(:last-of-type){transform:translate3d(0,3px,0)}.filter-hover:hover .filter-hover-item[data-v-a82399a9]{transition:opacity .2s ease-in-out,transform .2s ease-in-out}.filter-hover:hover .filter-hover-item[data-v-a82399a9]:nth-last-of-type(1){transition-delay:.05s}.filter-hover:hover .filter-hover-item[data-v-a82399a9]:nth-last-of-type(2){transition-delay:.1s}.filter-hover:hover .filter-hover-item[data-v-a82399a9]:nth-last-of-type(3){transition-delay:.15s}.filter-hover:hover .filter-hover-item[data-v-a82399a9]:nth-last-of-type(4){transition-delay:.2s}.filter-hover:hover .filter-hover-item[data-v-a82399a9]:nth-last-of-type(5){transition-delay:.25s}.filter-hover:hover .filter-hover-item[data-v-a82399a9]:nth-last-of-type(6){transition-delay:.3s}.filter-hover:hover .filter-hover-item[data-v-a82399a9]:nth-last-of-type(7){transition-delay:.35s}.filter-hover:hover .filter-hover-item[data-v-a82399a9],.filter-hover:has(:focus-visible) .filter-hover-item[data-v-a82399a9]{opacity:1;transform:translateZ(0)}.filter-hover[data-v-a82399a9]:hover:before,.filter-hover[data-v-a82399a9]:has(:focus-visible):before{opacity:.9;-webkit-backdrop-filter:blur(10px);backdrop-filter:blur(10px)}.context-bar-group:hover .context-bar-group-hover\\:text-c-1[data-v-a82399a9],.context-bar-group:has(:focus-visible) .context-bar-group-hover\\:text-c-1[data-v-a82399a9]{--tw-text-opacity: 1;color:rgb(var(--scalar-color-1) / var(--tw-text-opacity))}.context-bar-group:hover .context-bar-group-hover\\:hidden[data-v-a82399a9],.context-bar-group:has(:focus-visible) .context-bar-group-hover\\:hidden[data-v-a82399a9]{display:none}.light-mode .bg-preview[data-v-0956ad2d]{background-image:url(\"data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='16' height='16' fill='%23000' fill-opacity='10%25'%3E%3Crect width='8' height='8' /%3E%3Crect x='8' y='8' width='8' height='8' /%3E%3C/svg%3E\")}.dark-mode .bg-preview[data-v-0956ad2d]{background-image:url(\"data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='16' height='16' fill='%23FFF' fill-opacity='10%25'%3E%3Crect width='8' height='8' /%3E%3Crect x='8' y='8' width='8' height='8' /%3E%3C/svg%3E\")}[data-v-96fbecd5] .cm-editor{background-color:transparent;font-size:var(--scalar-mini);outline:none}[data-v-96fbecd5] .cm-gutters{background-color:var(--scalar-background-1);border-radius:var(--scalar-radius) 0 0 var(--scalar-radius)}.body-raw[data-v-96fbecd5] .cm-scroller{overflow:visible;width:-moz-fit-content;width:fit-content}.scalar-code-copy[data-v-96fbecd5]{align-items:flex-start;display:flex;position:absolute;top:6px;right:6px;z-index:10;pointer-events:none;position:sticky;transform:translate(-6px)}.copy-button[data-v-96fbecd5]{align-items:center;display:flex;background-color:var(--scalar-background-1);border:1px solid var(--scalar-border-color);border-radius:3px;color:var(--scalar-color-3);cursor:pointer;height:30px;opacity:0;padding:6px;pointer-events:auto;transition:opacity .15s ease-in-out,color .15s ease-in-out}.body-raw:hover .copy-button[data-v-96fbecd5],.copy-button[data-v-96fbecd5]:focus-visible{opacity:1}.copy-button[data-v-96fbecd5]:hover{color:var(--scalar-color-1)}.scalar-code-block[data-v-1e73a183] .hljs *{font-size:var(--scalar-mini)}.response-body-virtual[data-headlessui-state=open],.response-body-virtual[data-headlessui-state=open] .diclosure-panel{display:flex;flex-direction:column;flex-grow:1}.ascii-art-animate .ascii-art-line[data-v-69ebd973]{border-right:1ch solid transparent;animation:typewriter-69ebd973 4s steps(1) 1s 1 normal both,blinkTextCursor-69ebd973 .5s steps(1) infinite normal}@keyframes typewriter-69ebd973{0%{width:0}to{width:100%}}@keyframes blinkTextCursor-69ebd973{0%{border-right-color:currentColor}50%{border-right-color:transparent}}.keycap-n[data-v-6e1f579f]{background:-webkit-linear-gradient(5deg,transparent 30%,var(--scalar-color-3) 50%);-webkit-background-clip:text;-webkit-text-fill-color:transparent}.keycap-hotkey[data-v-6e1f579f]{position:absolute;top:32px;line-height:26px}.scalar-version-number[data-v-464c4989]{transform:skew(0,13deg);width:76px;height:76px;position:absolute;margin-left:-36px;font-size:8px;font-family:var(--scalar-font-code);line-height:11px;margin-top:-113px;border-radius:9px 9px 16px 12px;box-shadow:inset 2px 0 0 2px var(--scalar-background-2);text-align:center;display:flex;flex-direction:column;align-items:center;justify-content:center;text-transform:initial;text-decoration-color:var(--scalar-color-3)}.scalar-version-number a[data-v-464c4989]{font-weight:700;background:var(--scalar-background-2);padding:2px 4px;border-radius:3px;text-decoration:none;border:.5px solid var(--scalar-border-color)}.gitbook-show[data-v-464c4989]{display:none}.v-enter-active[data-v-50928a7c]{transition:opacity .5s ease}.v-enter-from[data-v-50928a7c]{opacity:0}.animate-response-heading .response-heading[data-v-559f2ac3]{animation:push-response-559f2ac3 .2s ease-in-out forwards;opacity:1}@keyframes push-response-559f2ac3{0%{opacity:1;transform:translateY(0)}to{opacity:0;transform:translateY(-4px)}}.animate-response-heading .animate-response-children[data-v-559f2ac3]{animation:response-spans-559f2ac3 .2s ease-in-out forwards .05s;opacity:0}@keyframes response-spans-559f2ac3{0%{opacity:0;transform:translateY(4px)}to{opacity:1;transform:translateY(0)}}[data-v-90dc92a1] .cm-editor{height:100%;outline:none;padding:0;background:transparent}[data-v-90dc92a1] .cm-placeholder{color:var(--scalar-color-3)}[data-v-90dc92a1] .cm-content{font-family:var(--scalar-font-code);font-size:var(--scalar-small);max-height:20px;padding:8px 0}[data-v-90dc92a1] .cm-tooltip{background:transparent!important;filter:brightness(var(--scalar-lifted-brightness));border-radius:var(--scalar-radius);box-shadow:var(--scalar-shadow-2);border:none!important;outline:none!important;overflow:hidden!important}[data-v-90dc92a1] .cm-tooltip-autocomplete ul li{padding:3px 6px!important}[data-v-90dc92a1] .cm-completionIcon-type:after{color:var(--scalar-color-3)!important}[data-v-90dc92a1] .cm-tooltip-autocomplete ul li[aria-selected]{background:var(--scalar-background-2)!important;color:var(--scalar-color-1)!important}[data-v-90dc92a1] .cm-tooltip-autocomplete ul{padding:6px!important;position:relative}[data-v-90dc92a1] .cm-tooltip-autocomplete ul li:hover{border-radius:3px;color:var(--scalar-color-1)!important;background:var(--scalar-background-3)!important}[data-v-90dc92a1] .cm-activeLine,[data-v-90dc92a1] .cm-activeLineGutter{background-color:transparent}[data-v-90dc92a1] .cm-selectionMatch,[data-v-90dc92a1] .cm-matchingBracket{border-radius:var(--scalar-radius);background:var(--scalar-background-4)!important}[data-v-90dc92a1] .cm-css-color-picker-wrapper{display:inline-flex;outline:1px solid var(--scalar-background-3);border-radius:3px;overflow:hidden}[data-v-90dc92a1] .cm-gutters{background-color:transparent;border-right:none;color:var(--scalar-color-3);font-size:var(--scalar-mini);line-height:1.44;border-radius:0 0 0 3px}[data-v-90dc92a1] .cm-gutters:before{content:\"\";position:absolute;top:2px;left:2px;width:calc(100% - 2px);height:calc(100% - 4px);border-radius:var(--scalar-radius) 0 0 var(--scalar-radius);background-color:var(--scalar-background-1)}[data-v-90dc92a1] .cm-gutterElement{font-family:var(--scalar-font-code)!important;padding:0 6px 0 8px!important;display:flex;align-items:center;justify-content:flex-end;position:relative}[data-v-90dc92a1] .cm-gutter+.cm-gutter :not(.cm-foldGutter) .cm-gutterElement{padding-left:0!important}[data-v-90dc92a1] .cm-scroller{overflow:auto}.peer:hover .copy-button[data-v-90dc92a1],.copy-button[data-v-90dc92a1]:focus-visible{opacity:100}.scalar-code-copy[data-v-90dc92a1]{align-items:flex-start;display:flex;top:0;right:0;bottom:0;left:0;justify-content:flex-end;position:sticky}.copy-button[data-v-90dc92a1]{align-items:center;display:flex;position:relative;background-color:var(--scalar-background-2);border:1px solid var(--scalar-border-color);border-radius:3px;color:var(--scalar-color-3);cursor:pointer;height:30px;margin-bottom:-30px;opacity:0;padding:6px;transition:opacity .15s ease-in-out,color .15s ease-in-out;top:0;right:0}.scalar-code-copy[data-v-90dc92a1],.copy-button[data-v-90dc92a1]{background:inherit}.copy-button[data-v-90dc92a1]:hover{color:var(--scalar-color-1)}.copy-button svg[data-v-90dc92a1]{stroke-width:1.5}.cm-pill{--tw-bg-base: var(--scalar-color-1);color:var(--tw-bg-base);padding:0 9px;display:inline-block;border-radius:30px;font-size:var(--scalar-mini);background:color-mix(in srgb,var(--tw-bg-base),transparent 94%)!important}.cm-pill.bg-grey{background:var(--scalar-background-3)!important}.dark-mode .cm-pill{background:color-mix(in srgb,var(--tw-bg-base),transparent 80%)!important}.cm-pill:first-of-type{margin-left:0}.cm-editor .cm-widgetBuffer{display:none}.cm-foldPlaceholder:hover{color:var(--scalar-color-1)}.cm-foldGutter .cm-gutterElement{font-size:var(--scalar-heading-4);padding:2px!important}.cm-foldGutter .cm-gutterElement:first-of-type{display:none}.cm-foldGutter .cm-gutterElement .cm-foldMarker{padding:2px}.cm-foldGutter .cm-gutterElement:hover .cm-foldMarker{background:var(--scalar-background-2);border-radius:var(--scalar-radius);color:var(--scalar-color-1)}.schema>span[data-v-ffeb58c7]:not(:first-child):before{content:\"·\";display:block;margin:0 .5ch}.schema>span[data-v-ffeb58c7]{display:flex;white-space:nowrap}[data-v-682f7941] .cm-editor{padding:0}[data-v-682f7941] .cm-content{align-items:center;background-color:transparent;display:flex;font-family:var(--scalar-font);font-size:var(--scalar-mini);padding:6px 8px}[data-v-682f7941] .cm-content:has(.cm-pill){padding:4px 3px}[data-v-682f7941] .cm-content .cm-pill:not(:last-of-type){margin-right:.5px}[data-v-682f7941] .cm-content .cm-pill:not(:first-of-type){margin-left:.5px}[data-v-682f7941] .cm-line{padding:0}.filemask[data-v-682f7941]{-webkit-mask-image:linear-gradient(to right,transparent 0,var(--scalar-background-2) 20px);mask-image:linear-gradient(to right,transparent 0,var(--scalar-background-2) 20px)}[data-v-20d48d32] .cm-content{font-size:var(--scalar-mini)}[data-v-18261e72] .cm-editor{padding:0}[data-v-18261e72] .cm-content{align-items:center;background-color:transparent;display:flex;font-family:var(--scalar-font);font-size:var(--scalar-mini);padding:6px 8px}[data-v-18261e72] .cm-content:has(.cm-pill){padding:4px 3px}[data-v-18261e72] .cm-content .cm-pill:not(:last-of-type){margin-right:.5px}[data-v-18261e72] .cm-content .cm-pill:not(:first-of-type){margin-left:.5px}[data-v-18261e72] .cm-line{padding:0}.required[data-v-18261e72]:after{content:\"Required\"}input[data-v-18261e72]::-moz-placeholder{color:var(--scalar-color-3)}input[data-v-18261e72]::placeholder{color:var(--scalar-color-3)}.auth-blend-required[data-v-10acaca1] .scalar-input-required,.auth-blend-required[data-v-10acaca1] .required{background:var(--scalar-background-2);--tw-bg-base: var(--scalar-background-2);--tw-shadow: -8px 0 4px var(--scalar-background-2)}.request-example-references-header[data-v-10acaca1]+tr>td{border-top:0;border-top-left-radius:0;border-top-right-radius:0}.auth-combobox-position[data-v-9f1d3e60]{margin-left:120px}.scroll-timeline-x[data-v-9f1d3e60]{overflow:auto;scroll-timeline:--scroll-timeline x;scroll-timeline:--scroll-timeline horizontal;scrollbar-width:none;-ms-overflow-style:none}.fade-left[data-v-9f1d3e60],.fade-right[data-v-9f1d3e60]{position:sticky;content:\"\";height:100%;animation-name:fadein-9f1d3e60;animation-duration:1ms;animation-direction:reverse;animation-timeline:--scroll-timeline;min-height:24px;pointer-events:none}.fade-left[data-v-9f1d3e60]{background:linear-gradient(-90deg,color-mix(in srgb,var(--scalar-background-1),transparent 100%) 0%,color-mix(in srgb,var(--scalar-background-1),transparent 20%) 60%,var(--scalar-background-1) 100%);min-width:3px;left:-1px;animation-direction:normal}.fade-right[data-v-9f1d3e60]{background:linear-gradient(90deg,color-mix(in srgb,var(--scalar-background-1),transparent 100%) 0%,color-mix(in srgb,var(--scalar-background-1),transparent 20%) 60%,var(--scalar-background-1) 100%);margin-left:-20px;min-width:24px;right:-1px;top:0}@keyframes fadein-9f1d3e60{0%{opacity:0}15%{opacity:1}}.auth-combobox-position[data-v-1f349e0c]{margin-left:120px}.scroll-timeline-x[data-v-1f349e0c]{overflow:auto;scroll-timeline:--scroll-timeline x;scroll-timeline:--scroll-timeline horizontal;scrollbar-width:none;-ms-overflow-style:none}.fade-left[data-v-1f349e0c],.fade-right[data-v-1f349e0c]{position:sticky;content:\"\";height:100%;animation-name:fadein-1f349e0c;animation-duration:1ms;animation-direction:reverse;animation-timeline:--scroll-timeline;min-height:24px;pointer-events:none}.fade-left[data-v-1f349e0c]{background:linear-gradient(-90deg,color-mix(in srgb,var(--scalar-background-1),transparent 100%) 0%,color-mix(in srgb,var(--scalar-background-1),transparent 20%) 60%,var(--scalar-background-1) 100%);min-width:3px;left:-1px;animation-direction:normal}.fade-right[data-v-1f349e0c]{background:linear-gradient(90deg,color-mix(in srgb,var(--scalar-background-1),transparent 100%) 0%,color-mix(in srgb,var(--scalar-background-1),transparent 20%) 60%,var(--scalar-background-1) 100%);margin-left:-20px;min-width:24px;right:-1px;top:0}@keyframes fadein-1f349e0c{0%{opacity:0}15%{opacity:1}}[data-v-ec5dd19c] code.hljs *{font-size:var(--scalar-mini)}.request-section-content[data-v-d51a3a93]{--scalar-border-width: .5px}.request-section-content-filter[data-v-d51a3a93]{box-shadow:0 -10px 0 10px var(--scalar-background-1)}.request-item:focus-within .request-meta-buttons[data-v-d51a3a93]{opacity:1}.group-hover-input[data-v-d51a3a93]{border-width:var(--scalar-border-width);border-color:transparent}.group:hover .group-hover-input[data-v-d51a3a93]{background:color-mix(in srgb,var(--scalar-background-1),var(--scalar-background-2));border-color:var(--scalar-border-color)}.group-hover-input[data-v-d51a3a93]:focus{background:transparent!important;border-color:var(--scalar-border-color)!important}@media (min-width: 800px){.has-no-import-url,.has-import-url{max-width:100dvw;overflow-x:hidden;contain:paint}.has-no-import-url{opacity:1;background:var(--scalar-background-1);animation:transform-restore-layout ease-in-out .3s forwards}.has-import-url .scalar-client>main{opacity:0;transform:scale(.85) translate3d(calc(50dvw + 80px),0,0);animation:transform-fade-layout ease-in-out .3s forwards;border:var(--scalar-border-width) solid var(--scalar-border-color);border-radius:12px;overflow:hidden;z-index:10000}.has-import-url .scalar-client .sidenav{display:none}.has-no-import-url .scalar-app,.has-import-url .scalar-app{background:var(--scalar-background-1)!important}}@keyframes transform-fade-layout{0%{opacity:0;transform:scale(.85) translate3d(calc(50dvw + 80px),10px,0)}to{opacity:1;transform:scale(.85) translate3d(calc(50dvw + 80px),0,0)}}@keyframes transform-restore-layout{0%{opacity:1;transform:scale(.85) translate3d(calc(50dvw + 80px),0,0)}to{opacity:1;transform:scale(1) translateZ(0)}}.openapi-color{color:var(--scalar-color-green)}.section-flare{position:fixed;top:0;right:-50dvw}@layer scalar-base,scalar-theme;@layer scalar-base{body{margin:0;line-height:inherit}:root{--scalar-border-width: .5px;--scalar-radius: 3px;--scalar-radius-lg: 6px;--scalar-radius-xl: 8px;--scalar-font: \"Inter\", -apple-system, BlinkMacSystemFont, \"Segoe UI\", Roboto, Oxygen, Ubuntu, Cantarell, \"Open Sans\", \"Helvetica Neue\", sans-serif;--scalar-font-code: \"JetBrains Mono\", ui-monospace, Menlo, Monaco, \"Cascadia Mono\", \"Segoe UI Mono\", \"Roboto Mono\", \"Oxygen Mono\", \"Ubuntu Monospace\", \"Source Code Pro\", \"Fira Mono\", \"Droid Sans Mono\", \"Courier New\", monospace;--scalar-heading-1: 40px;--scalar-page-description: 24px;--scalar-heading-2: 24px;--scalar-heading-3: 20px;--scalar-heading-4: 16px;--scalar-heading-5: 16px;--scalar-heading-6: 16px;--scalar-paragraph: 16px;--scalar-small: 14px;--scalar-mini: 13px;--scalar-micro: 12px;--scalar-bold: 600;--scalar-semibold: 500;--scalar-regular: 400;--scalar-font-size-1: 21px;--scalar-font-size-2: 16px;--scalar-font-size-3: 14px;--scalar-font-size-4: 13px;--scalar-font-size-5: 12px;--scalar-font-size-6: 12px;--scalar-font-size-7: 10px;--scalar-line-height-1: 32px;--scalar-line-height-2: 24px;--scalar-line-height-3: 20px;--scalar-line-height-4: 18px;--scalar-line-height-5: 16px;--scalar-font-medium: 500;--scalar-font-bold: 700;--scalar-text-decoration: none;--scalar-text-decoration-hover: underline;--scalar-link-font-weight: inherit;--scalar-sidebar-indent: 18px}.dark-mode{color-scheme:dark;--scalar-scrollbar-color: rgba(255, 255, 255, .18);--scalar-scrollbar-color-active: rgba(255, 255, 255, .36);--scalar-button-1: rgba(255, 255, 255, 1);--scalar-button-1-hover: rgba(255, 255, 255, .9);--scalar-button-1-color: black;--scalar-shadow-1: 0 1px 3px 0 rgb(0, 0, 0, .1);--scalar-shadow-2: 0 0 0 .5px var(--scalar-border-color), rgba(15, 15, 15, .2) 0px 3px 6px, rgba(15, 15, 15, .4) 0px 9px 24px;--scalar-lifted-brightness: 1.45;--scalar-backdrop-brightness: .5;--scalar-link-color: var(--scalar-color-accent);--scalar-link-color-hover: var(--scalar-color-accent);--scalar-text-decoration-color: currentColor;--scalar-text-decoration-color-hover: currentColor}.light-mode{color-scheme:light;--scalar-scrollbar-color-active: rgba(0, 0, 0, .36);--scalar-scrollbar-color: rgba(0, 0, 0, .18);--scalar-button-1: rgba(0, 0, 0, 1);--scalar-button-1-hover: rgba(0, 0, 0, .8);--scalar-button-1-color: rgba(255, 255, 255, .9);--scalar-shadow-1: 0 1px 3px 0 rgba(0, 0, 0, .11);--scalar-shadow-2: rgba(0, 0, 0, .08) 0px 13px 20px 0px, rgba(0, 0, 0, .08) 0px 3px 8px 0px, #eeeeed 0px 0 0 .5px;--scalar-lifted-brightness: 1;--scalar-backdrop-brightness: 1;--scalar-link-color: var(--scalar-color-accent);--scalar-link-color-hover: var(--scalar-color-accent);--scalar-text-decoration-color: currentColor;--scalar-text-decoration-color-hover: currentColor}.light-mode .dark-mode{color-scheme:dark!important}@media (max-width: 460px){:root{--scalar-font-size-1: 22px;--scalar-font-size-2: 14px;--scalar-font-size-3: 12px}}@media (max-width: 720px){:root{--scalar-heading-1: 24px;--scalar-page-description: 20px}}.light-mode{--scalar-background-1: #fff;--scalar-background-2: #f6f6f6;--scalar-background-3: #e7e7e7;--scalar-background-accent: #8ab4f81f;--scalar-color-1: #2a2f45;--scalar-color-2: #757575;--scalar-color-3: #8e8e8e;--scalar-color-accent: #0099ff;--scalar-border-color: #dfdfdf}.dark-mode{--scalar-background-1: #0f0f0f;--scalar-background-2: #1a1a1a;--scalar-background-3: #272727;--scalar-color-1: #e7e7e7;--scalar-color-2: #a4a4a4;--scalar-color-3: #797979;--scalar-color-accent: #3ea6ff;--scalar-background-accent: #3ea6ff1f;--scalar-border-color: #2d2d2d}.light-mode .t-doc__sidebar,.dark-mode .t-doc__sidebar{--scalar-sidebar-background-1: var(--scalar-background-1);--scalar-sidebar-color-1: var(--scalar-color-1);--scalar-sidebar-color-2: var(--scalar-color-2);--scalar-sidebar-border-color: var(--scalar-border-color);--scalar-sidebar-item-hover-background: var(--scalar-background-2);--scalar-sidebar-item-hover-color: currentColor;--scalar-sidebar-item-active-background: var(--scalar-background-2);--scalar-sidebar-color-active: var(--scalar-color-1);--scalar-sidebar-indent-border: var(--scalar-sidebar-border-color);--scalar-sidebar-indent-border-hover: var(--scalar-sidebar-border-color);--scalar-sidebar-indent-border-active: var(--scalar-sidebar-border-color);--scalar-sidebar-search-background: transparent;--scalar-sidebar-search-color: var(--scalar-color-3);--scalar-sidebar-search-border-color: var(--scalar-border-color)}.light-mode{--scalar-color-green: #069061;--scalar-color-red: #ef0006;--scalar-color-yellow: #edbe20;--scalar-color-blue: #0082d0;--scalar-color-orange: #fb892c;--scalar-color-purple: #5203d1;--scalar-button-1: rgba(0, 0, 0, 1);--scalar-button-1-hover: rgba(0, 0, 0, .8);--scalar-button-1-color: rgba(255, 255, 255, .9);--scalar-color-danger: color-mix(in srgb, var(--scalar-color-red), var(--scalar-color-1) 20%);--scalar-background-alert: color-mix(in srgb, var(--scalar-color-orange), var(--scalar-background-1) 95%);--scalar-background-danger: color-mix(in srgb, var(--scalar-color-red), var(--scalar-background-1) 95%)}.dark-mode{--scalar-color-green: #00b648;--scalar-color-red: #dc1b19;--scalar-color-yellow: #ffc90d;--scalar-color-blue: #4eb3ec;--scalar-color-orange: #ff8d4d;--scalar-color-purple: #b191f9;--scalar-button-1: rgba(255, 255, 255, 1);--scalar-button-1-hover: rgba(255, 255, 255, .9);--scalar-button-1-color: black;--scalar-color-danger: color-mix(in srgb, var(--scalar-color-red), var(--scalar-background-1) 20%);--scalar-background-alert: color-mix(in srgb, var(--scalar-color-orange), var(--scalar-background-1) 95%);--scalar-background-danger: color-mix(in srgb, var(--scalar-color-red), var(--scalar-background-1) 95%)}@supports (color: color(display-p3 1 1 1)){.light-mode{--scalar-color-accent: color(display-p3 0 .6 1 / 1);--scalar-color-green: color(display-p3 .023529 .564706 .380392 / 1);--scalar-color-red: color(display-p3 .937255 0 .023529 / 1);--scalar-color-yellow: color(display-p3 .929412 .745098 .12549 / 1);--scalar-color-blue: color(display-p3 0 .509804 .815686 / 1);--scalar-color-orange: color(display-p3 .984314 .537255 .172549 / 1);--scalar-color-purple: color(display-p3 .321569 .011765 .819608 / 1)}.dark-mode{--scalar-color-accent: color(display-p3 .243137 .65098 1 / 1);--scalar-color-green: color(display-p3 0 .713725 .282353 / 1);--scalar-color-red: color(display-p3 .862745 .105882 .098039 / 1);--scalar-color-yellow: color(display-p3 1 .788235 .05098 / 1);--scalar-color-blue: color(display-p3 .305882 .701961 .92549 / 1);--scalar-color-orange: color(display-p3 1 .552941 .301961 / 1);--scalar-color-purple: color(display-p3 .694118 .568627 .976471 / 1)}}*,:before,:after{--tw-border-spacing-x: 0;--tw-border-spacing-y: 0;--tw-translate-x: 0;--tw-translate-y: 0;--tw-rotate: 0;--tw-skew-x: 0;--tw-skew-y: 0;--tw-scale-x: 1;--tw-scale-y: 1;--tw-pan-x: ;--tw-pan-y: ;--tw-pinch-zoom: ;--tw-scroll-snap-strictness: proximity;--tw-gradient-from-position: ;--tw-gradient-via-position: ;--tw-gradient-to-position: ;--tw-ordinal: ;--tw-slashed-zero: ;--tw-numeric-figure: ;--tw-numeric-spacing: ;--tw-numeric-fraction: ;--tw-ring-inset: ;--tw-ring-offset-width: 0px;--tw-ring-offset-color: #fff;--tw-ring-color: rgb(59 130 246 / .5);--tw-ring-offset-shadow: 0 0 #0000;--tw-ring-shadow: 0 0 #0000;--tw-shadow: 0 0 #0000;--tw-shadow-colored: 0 0 #0000;--tw-blur: ;--tw-brightness: ;--tw-contrast: ;--tw-grayscale: ;--tw-hue-rotate: ;--tw-invert: ;--tw-saturate: ;--tw-sepia: ;--tw-drop-shadow: ;--tw-backdrop-blur: ;--tw-backdrop-brightness: ;--tw-backdrop-contrast: ;--tw-backdrop-grayscale: ;--tw-backdrop-hue-rotate: ;--tw-backdrop-invert: ;--tw-backdrop-opacity: ;--tw-backdrop-saturate: ;--tw-backdrop-sepia: ;--tw-contain-size: ;--tw-contain-layout: ;--tw-contain-paint: ;--tw-contain-style: }::backdrop{--tw-border-spacing-x: 0;--tw-border-spacing-y: 0;--tw-translate-x: 0;--tw-translate-y: 0;--tw-rotate: 0;--tw-skew-x: 0;--tw-skew-y: 0;--tw-scale-x: 1;--tw-scale-y: 1;--tw-pan-x: ;--tw-pan-y: ;--tw-pinch-zoom: ;--tw-scroll-snap-strictness: proximity;--tw-gradient-from-position: ;--tw-gradient-via-position: ;--tw-gradient-to-position: ;--tw-ordinal: ;--tw-slashed-zero: ;--tw-numeric-figure: ;--tw-numeric-spacing: ;--tw-numeric-fraction: ;--tw-ring-inset: ;--tw-ring-offset-width: 0px;--tw-ring-offset-color: #fff;--tw-ring-color: rgb(59 130 246 / .5);--tw-ring-offset-shadow: 0 0 #0000;--tw-ring-shadow: 0 0 #0000;--tw-shadow: 0 0 #0000;--tw-shadow-colored: 0 0 #0000;--tw-blur: ;--tw-brightness: ;--tw-contrast: ;--tw-grayscale: ;--tw-hue-rotate: ;--tw-invert: ;--tw-saturate: ;--tw-sepia: ;--tw-drop-shadow: ;--tw-backdrop-blur: ;--tw-backdrop-brightness: ;--tw-backdrop-contrast: ;--tw-backdrop-grayscale: ;--tw-backdrop-hue-rotate: ;--tw-backdrop-invert: ;--tw-backdrop-opacity: ;--tw-backdrop-saturate: ;--tw-backdrop-sepia: ;--tw-contain-size: ;--tw-contain-layout: ;--tw-contain-paint: ;--tw-contain-style: }}:where(.scalar-app) .container{width:100%}@media (min-width: 400px){:where(.scalar-app) .container{max-width:400px}}@media (min-width: 600px){:where(.scalar-app) .container{max-width:600px}}@media (min-width: 800px){:where(.scalar-app) .container{max-width:800px}}@media (min-width: 1000px){:where(.scalar-app) .container{max-width:1000px}}@media (min-width: 1200px){:where(.scalar-app) .container{max-width:1200px}}:where(.scalar-app) .sr-only{position:absolute;width:1px;height:1px;padding:0;margin:-1px;overflow:hidden;clip:rect(0,0,0,0);white-space:nowrap;border-width:0}:where(.scalar-app) .pointer-events-none{pointer-events:none}:where(.scalar-app) .visible{visibility:visible}:where(.scalar-app) .invisible{visibility:hidden}:where(.scalar-app) .fixed{position:fixed}:where(.scalar-app) .absolute{position:absolute}:where(.scalar-app) .relative{position:relative}:where(.scalar-app) .sticky{position:sticky}:where(.scalar-app) .inset-0{top:0;right:0;bottom:0;left:0}:where(.scalar-app) .inset-y-0{top:0;bottom:0}:where(.scalar-app) .left-0{left:0}:where(.scalar-app) .left-1{left:4px}:where(.scalar-app) .left-1\\.75{left:7px}:where(.scalar-app) .left-2{left:8px}:where(.scalar-app) .left-2\\.5{left:10px}:where(.scalar-app) .left-4{left:16px}:where(.scalar-app) .left-border{left:var(--scalar-border-width)}:where(.scalar-app) .left-px{left:1px}:where(.scalar-app) .right-2{right:8px}:where(.scalar-app) .top-0{top:0}:where(.scalar-app) .top-1\\/2{top:50%}:where(.scalar-app) .top-12{top:48px}:where(.scalar-app) .top-2{top:8px}:where(.scalar-app) .top-22{top:88px}:where(.scalar-app) .top-\\[0\\.5px\\]{top:.5px}:where(.scalar-app) .top-px{top:1px}:where(.scalar-app) .-z-1{z-index:-1}:where(.scalar-app) .z-1{z-index:1}:where(.scalar-app) .z-\\[1001\\]{z-index:1001}:where(.scalar-app) .z-context{z-index:1000}:where(.scalar-app) .z-context-plus{z-index:1001}:where(.scalar-app) .\\!m-0{margin:0!important}:where(.scalar-app) .-m-1{margin:-4px}:where(.scalar-app) .-m-1\\.5{margin:-6px}:where(.scalar-app) .-m-px{margin:-1px}:where(.scalar-app) .m-0{margin:0}:where(.scalar-app) .m-auto{margin:auto}:where(.scalar-app) .-mx-0{margin-left:-0px;margin-right:-0px}:where(.scalar-app) .-mx-0\\.75{margin-left:-3px;margin-right:-3px}:where(.scalar-app) .-mx-px{margin-left:-1px;margin-right:-1px}:where(.scalar-app) .-my-1{margin-top:-4px;margin-bottom:-4px}:where(.scalar-app) .-my-1\\.5{margin-top:-6px;margin-bottom:-6px}:where(.scalar-app) .mx-px{margin-left:1px;margin-right:1px}:where(.scalar-app) .my-0{margin-top:0;margin-bottom:0}:where(.scalar-app) .my-0\\.75{margin-top:3px;margin-bottom:3px}:where(.scalar-app) .-mb-1{margin-bottom:-4px}:where(.scalar-app) .-ml-0{margin-left:-0px}:where(.scalar-app) .-ml-0\\.75{margin-left:-3px}:where(.scalar-app) .-mr-0{margin-right:-0px}:where(.scalar-app) .-mr-0\\.25{margin-right:-1px}:where(.scalar-app) .-mt-1{margin-top:-4px}:where(.scalar-app) .-mt-1\\.5{margin-top:-6px}:where(.scalar-app) .mb-0{margin-bottom:0}:where(.scalar-app) .ml-1{margin-left:4px}:where(.scalar-app) .ml-auto{margin-left:auto}:where(.scalar-app) .mr-0{margin-right:0}:where(.scalar-app) .mr-2{margin-right:8px}:where(.scalar-app) .mr-3{margin-right:12px}:where(.scalar-app) .mr-\\[calc\\(18px-var\\(--scalar-sidebar-indent\\)\\)\\]{margin-right:calc(18px - var(--scalar-sidebar-indent))}:where(.scalar-app) .mt-0{margin-top:0}:where(.scalar-app) .mt-2{margin-top:8px}:where(.scalar-app) .mt-3{margin-top:12px}:where(.scalar-app) .mt-\\[15svh\\]{margin-top:15svh}:where(.scalar-app) .mt-\\[20svh\\]{margin-top:20svh}:where(.scalar-app) .line-clamp-4{overflow:hidden;display:-webkit-box;-webkit-box-orient:vertical;-webkit-line-clamp:4}:where(.scalar-app) .block{display:block}:where(.scalar-app) .inline-block{display:inline-block}:where(.scalar-app) .flex{display:flex}:where(.scalar-app) .table{display:table}:where(.scalar-app) .grid{display:grid}:where(.scalar-app) .contents{display:contents}:where(.scalar-app) .\\!hidden{display:none!important}:where(.scalar-app) .hidden{display:none}:where(.scalar-app) .aspect-square{aspect-ratio:1 / 1}:where(.scalar-app) .size-10{width:40px;height:40px}:where(.scalar-app) .size-2{width:8px;height:8px}:where(.scalar-app) .size-3{width:12px;height:12px}:where(.scalar-app) .size-3\\.5{width:14px;height:14px}:where(.scalar-app) .size-4{width:16px;height:16px}:where(.scalar-app) .size-5{width:20px;height:20px}:where(.scalar-app) .size-6{width:24px;height:24px}:where(.scalar-app) .size-8{width:32px;height:32px}:where(.scalar-app) .size-\\[23px\\]{width:23px;height:23px}:where(.scalar-app) .size-full{width:100%;height:100%}:where(.scalar-app) .h-10{height:40px}:where(.scalar-app) .h-24{height:96px}:where(.scalar-app) .h-3{height:12px}:where(.scalar-app) .h-3\\.5{height:14px}:where(.scalar-app) .h-32{height:128px}:where(.scalar-app) .h-4{height:16px}:where(.scalar-app) .h-5{height:20px}:where(.scalar-app) .h-6{height:24px}:where(.scalar-app) .h-8{height:32px}:where(.scalar-app) .h-\\[100dvh\\]{height:100dvh}:where(.scalar-app) .h-border{height:var(--scalar-border-width)}:where(.scalar-app) .h-dvh{height:100dvh}:where(.scalar-app) .h-fit{height:-moz-fit-content;height:fit-content}:where(.scalar-app) .h-full{height:100%}:where(.scalar-app) .h-screen{height:100vh}:where(.scalar-app) .max-h-20{max-height:80px}:where(.scalar-app) .max-h-\\[60svh\\]{max-height:60svh}:where(.scalar-app) .max-h-\\[80svh\\]{max-height:80svh}:where(.scalar-app) .max-h-\\[90svh\\]{max-height:90svh}:where(.scalar-app) .max-h-\\[inherit\\]{max-height:inherit}:where(.scalar-app) .max-h-dvh{max-height:100dvh}:where(.scalar-app) .max-h-radix-popper{max-height:calc(var(--radix-popper-available-height) - 8px)}:where(.scalar-app) .min-h-0{min-height:0px}:where(.scalar-app) .min-h-12{min-height:48px}:where(.scalar-app) .min-h-5{min-height:20px}:where(.scalar-app) .min-h-6{min-height:24px}:where(.scalar-app) .min-h-8{min-height:32px}:where(.scalar-app) .min-h-96{min-height:384px}:where(.scalar-app) .min-h-header{min-height:48px}:where(.scalar-app) .w-12{width:48px}:where(.scalar-app) .w-16{width:64px}:where(.scalar-app) .w-20{width:80px}:where(.scalar-app) .w-24{width:96px}:where(.scalar-app) .w-3{width:12px}:where(.scalar-app) .w-32{width:128px}:where(.scalar-app) .w-4{width:16px}:where(.scalar-app) .w-40{width:160px}:where(.scalar-app) .w-48{width:192px}:where(.scalar-app) .w-5{width:20px}:where(.scalar-app) .w-56{width:224px}:where(.scalar-app) .w-6{width:24px}:where(.scalar-app) .w-64{width:256px}:where(.scalar-app) .w-72{width:288px}:where(.scalar-app) .w-8{width:32px}:where(.scalar-app) .w-\\[100dvw\\]{width:100dvw}:where(.scalar-app) .w-\\[38px\\]{width:38px}:where(.scalar-app) .w-\\[calc\\(100vw-12px\\)\\]{width:calc(100vw - 12px)}:where(.scalar-app) .w-\\[var\\(--scalar-sidebar-indent\\)\\]{width:var(--scalar-sidebar-indent)}:where(.scalar-app) .w-auto{width:auto}:where(.scalar-app) .w-border{width:var(--scalar-border-width)}:where(.scalar-app) .w-full{width:100%}:where(.scalar-app) .w-min{width:-moz-min-content;width:min-content}:where(.scalar-app) .min-w-0{min-width:0px}:where(.scalar-app) .min-w-5{min-width:20px}:where(.scalar-app) .min-w-6{min-width:24px}:where(.scalar-app) .min-w-8{min-width:32px}:where(.scalar-app) .min-w-max{min-width:-moz-max-content;min-width:max-content}:where(.scalar-app) .min-w-min{min-width:-moz-min-content;min-width:min-content}:where(.scalar-app) .max-w-\\[540px\\]{max-width:540px}:where(.scalar-app) .max-w-screen-lg{max-width:800px}:where(.scalar-app) .max-w-screen-md{max-width:640px}:where(.scalar-app) .max-w-screen-sm{max-width:540px}:where(.scalar-app) .max-w-screen-xl{max-width:1000px}:where(.scalar-app) .max-w-screen-xs{max-width:480px}:where(.scalar-app) .max-w-screen-xxs{max-width:360px}:where(.scalar-app) .max-w-xs{max-width:320px}:where(.scalar-app) .flex-1{flex:1 1 0%}:where(.scalar-app) .shrink{flex-shrink:1}:where(.scalar-app) .shrink-0{flex-shrink:0}:where(.scalar-app) .-translate-y-1\\/2{--tw-translate-y: -50%;transform:translate(var(--tw-translate-x),var(--tw-translate-y)) rotate(var(--tw-rotate)) skew(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y))}:where(.scalar-app) .translate-x-2{--tw-translate-x: 8px;transform:translate(var(--tw-translate-x),var(--tw-translate-y)) rotate(var(--tw-rotate)) skew(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y))}:where(.scalar-app) .translate-x-2\\.5{--tw-translate-x: 10px;transform:translate(var(--tw-translate-x),var(--tw-translate-y)) rotate(var(--tw-rotate)) skew(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y))}:where(.scalar-app) .translate-x-\\[14px\\]{--tw-translate-x: 14px;transform:translate(var(--tw-translate-x),var(--tw-translate-y)) rotate(var(--tw-rotate)) skew(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y))}:where(.scalar-app) .rotate-90{--tw-rotate: 90deg;transform:translate(var(--tw-translate-x),var(--tw-translate-y)) rotate(var(--tw-rotate)) skew(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y))}:where(.scalar-app) .transform{transform:translate(var(--tw-translate-x),var(--tw-translate-y)) rotate(var(--tw-rotate)) skew(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y))}:where(.scalar-app) .cursor-auto{cursor:auto}:where(.scalar-app) .cursor-default{cursor:default}:where(.scalar-app) .cursor-not-allowed{cursor:not-allowed}:where(.scalar-app) .cursor-pointer{cursor:pointer}:where(.scalar-app) .cursor-text{cursor:text}:where(.scalar-app) .select-none{-webkit-user-select:none;-moz-user-select:none;user-select:none}:where(.scalar-app) .resize-none{resize:none}:where(.scalar-app) .resize{resize:both}:where(.scalar-app) .appearance-none{-webkit-appearance:none;-moz-appearance:none;appearance:none}:where(.scalar-app) .grid-cols-\\[auto_1fr\\]{grid-template-columns:auto 1fr}:where(.scalar-app) .flex-col{flex-direction:column}:where(.scalar-app) .flex-wrap{flex-wrap:wrap}:where(.scalar-app) .items-start{align-items:flex-start}:where(.scalar-app) .items-center{align-items:center}:where(.scalar-app) .justify-start{justify-content:flex-start}:where(.scalar-app) .justify-end{justify-content:flex-end}:where(.scalar-app) .justify-center{justify-content:center}:where(.scalar-app) .justify-between{justify-content:space-between}:where(.scalar-app) .gap-0{gap:0px}:where(.scalar-app) .gap-0\\.5{gap:2px}:where(.scalar-app) .gap-0\\.75{gap:3px}:where(.scalar-app) .gap-1{gap:4px}:where(.scalar-app) .gap-1\\.5{gap:6px}:where(.scalar-app) .gap-16{gap:64px}:where(.scalar-app) .gap-2{gap:8px}:where(.scalar-app) .gap-2\\.5{gap:10px}:where(.scalar-app) .gap-3{gap:12px}:where(.scalar-app) .gap-4{gap:16px}:where(.scalar-app) .gap-px{gap:1px}:where(.scalar-app) .gap-x-4{-moz-column-gap:16px;column-gap:16px}:where(.scalar-app) .gap-y-8{row-gap:32px}:where(.scalar-app) .divide-y>:not([hidden])~:not([hidden]){--tw-divide-y-reverse: 0;border-top-width:calc(var(--scalar-border-width) * calc(1 - var(--tw-divide-y-reverse)));border-bottom-width:calc(var(--scalar-border-width) * var(--tw-divide-y-reverse))}:where(.scalar-app) .self-center{align-self:center}:where(.scalar-app) .overflow-auto{overflow:auto}:where(.scalar-app) .overflow-hidden{overflow:hidden}:where(.scalar-app) .overflow-visible{overflow:visible}:where(.scalar-app) .overflow-y-scroll{overflow-y:scroll}:where(.scalar-app) .overscroll-contain{overscroll-behavior:contain}:where(.scalar-app) .truncate{overflow:hidden;text-overflow:ellipsis;white-space:nowrap}:where(.scalar-app) .text-ellipsis{text-overflow:ellipsis}:where(.scalar-app) .whitespace-nowrap{white-space:nowrap}:where(.scalar-app) .text-wrap{text-wrap:wrap}:where(.scalar-app) .text-nowrap{text-wrap:nowrap}:where(.scalar-app) .break-words{overflow-wrap:break-word}:where(.scalar-app) .rounded{border-radius:var(--scalar-radius)}:where(.scalar-app) .rounded-full{border-radius:9999px}:where(.scalar-app) .rounded-lg{border-radius:var(--scalar-radius-lg)}:where(.scalar-app) .rounded-md{border-radius:var(--scalar-radius)}:where(.scalar-app) .rounded-none{border-radius:0}:where(.scalar-app) .rounded-xl{border-radius:var(--scalar-radius-xl)}:where(.scalar-app) .border{border-width:var(--scalar-border-width)}:where(.scalar-app) .border-0{border-width:0}:where(.scalar-app) .border-2{border-width:calc(var(--scalar-border-width) * 2)}:where(.scalar-app) .border-\\[1px\\]{border-width:1px}:where(.scalar-app) .border-b{border-bottom-width:var(--scalar-border-width)}:where(.scalar-app) .border-r{border-right-width:var(--scalar-border-width)}:where(.scalar-app) .border-t{border-top-width:var(--scalar-border-width)}:where(.scalar-app) .border-solid{border-style:solid}:where(.scalar-app) .border-dashed{border-style:dashed}:where(.scalar-app) .border-none{border-style:none}:where(.scalar-app) .border-border{border-color:var(--scalar-border-color)}:where(.scalar-app) .border-c-1{border-color:var(--scalar-color-1)}:where(.scalar-app) .border-red{border-color:var(--scalar-color-red)}:where(.scalar-app) .border-sidebar-border{border-color:var(--scalar-sidebar-border-color, var(--scalar-border-color))}:where(.scalar-app) .bg-b-1{background-color:var(--scalar-background-1)}:where(.scalar-app) .bg-b-1\\.5{background-color:color-mix(in srgb,var(--scalar-background-1),var(--scalar-background-2))}:where(.scalar-app) .bg-b-2{background-color:var(--scalar-background-2)}:where(.scalar-app) .bg-b-3{background-color:var(--scalar-background-3)}:where(.scalar-app) .bg-b-btn{background-color:var(--scalar-button-1)}:where(.scalar-app) .bg-backdrop{background-color:#00000038}:where(.scalar-app) .bg-border{background-color:var(--scalar-border-color)}:where(.scalar-app) .bg-c-accent{background-color:var(--scalar-color-accent)}:where(.scalar-app) .bg-c-danger{background-color:var(--scalar-color-danger)}:where(.scalar-app) .bg-red{background-color:var(--scalar-color-red)}:where(.scalar-app) .bg-sidebar-b-1{background-color:var(--scalar-sidebar-background-1, var(--scalar-background-1))}:where(.scalar-app) .bg-sidebar-indent-active{background-color:var(--scalar-sidebar-indent-border-active, var(--scalar-color-accent))}:where(.scalar-app) .bg-sidebar-indent-border{background-color:var(--scalar-sidebar-indent-border, var(--scalar-border-color))}:where(.scalar-app) .bg-transparent{background-color:transparent}:where(.scalar-app) .bg-white{--tw-bg-opacity: 1;background-color:rgb(255 255 255 / var(--tw-bg-opacity))}:where(.scalar-app) .p-0{padding:0}:where(.scalar-app) .p-0\\.5{padding:2px}:where(.scalar-app) .p-0\\.75{padding:3px}:where(.scalar-app) .p-1{padding:4px}:where(.scalar-app) .p-2{padding:8px}:where(.scalar-app) .p-3{padding:12px}:where(.scalar-app) .p-4{padding:16px}:where(.scalar-app) .p-6{padding:24px}:where(.scalar-app) .px-1{padding-left:4px;padding-right:4px}:where(.scalar-app) .px-1\\.5{padding-left:6px;padding-right:6px}:where(.scalar-app) .px-2{padding-left:8px;padding-right:8px}:where(.scalar-app) .px-2\\.5{padding-left:10px;padding-right:10px}:where(.scalar-app) .px-3{padding-left:12px;padding-right:12px}:where(.scalar-app) .px-4{padding-left:16px;padding-right:16px}:where(.scalar-app) .px-6{padding-left:24px;padding-right:24px}:where(.scalar-app) .px-9{padding-left:36px;padding-right:36px}:where(.scalar-app) .py-1{padding-top:4px;padding-bottom:4px}:where(.scalar-app) .py-1\\.5{padding-top:6px;padding-bottom:6px}:where(.scalar-app) .py-2{padding-top:8px;padding-bottom:8px}:where(.scalar-app) .py-2\\.5{padding-top:10px;padding-bottom:10px}:where(.scalar-app) .py-3{padding-top:12px;padding-bottom:12px}:where(.scalar-app) .py-4{padding-top:16px;padding-bottom:16px}:where(.scalar-app) .pb-0{padding-bottom:0}:where(.scalar-app) .pl-8{padding-left:32px}:where(.scalar-app) .pr-3{padding-right:12px}:where(.scalar-app) .pt-3{padding-top:12px}:where(.scalar-app) .text-left{text-align:left}:where(.scalar-app) .font-code{font-family:var(--scalar-font-code)}:where(.scalar-app) .text-3xs{font-size:var(--scalar-font-size-7)}:where(.scalar-app) .text-lg{font-size:var(--scalar-font-size-2)}:where(.scalar-app) .text-sm{font-size:var(--scalar-font-size-4)}:where(.scalar-app) .text-xs{font-size:var(--scalar-font-size-5)}:where(.scalar-app) .font-bold{font-weight:var(--scalar-bold)}:where(.scalar-app) .font-medium{font-weight:var(--scalar-semibold)}:where(.scalar-app) .font-normal{font-weight:var(--scalar-regular)}:where(.scalar-app) .leading-3{line-height:var(--scalar-line-height-3)}:where(.scalar-app) .leading-5{line-height:var(--scalar-line-height-5)}:where(.scalar-app) .leading-none{line-height:1}:where(.scalar-app) .leading-snug{line-height:1.375}:where(.scalar-app) .text-b-1{color:var(--scalar-background-1)}:where(.scalar-app) .text-c-1{color:var(--scalar-color-1)}:where(.scalar-app) .text-c-2{color:var(--scalar-color-2)}:where(.scalar-app) .text-c-3{color:var(--scalar-color-3)}:where(.scalar-app) .text-c-accent{color:var(--scalar-color-accent)}:where(.scalar-app) .text-c-btn{color:var(--scalar-button-1-color)}:where(.scalar-app) .text-c-danger{color:var(--scalar-color-danger)}:where(.scalar-app) .text-red{color:var(--scalar-color-red)}:where(.scalar-app) .text-sidebar-c-2{color:var(--scalar-sidebar-color-2, var(--scalar-color-2))}:where(.scalar-app) .text-transparent{color:transparent}:where(.scalar-app) .text-white{--tw-text-opacity: 1;color:rgb(255 255 255 / var(--tw-text-opacity))}:where(.scalar-app) .no-underline{text-decoration-line:none}:where(.scalar-app) .opacity-0{opacity:0}:where(.scalar-app) .opacity-40{opacity:.4}:where(.scalar-app) .opacity-50{opacity:.5}:where(.scalar-app) .shadow{--tw-shadow: var(--scalar-shadow-1);--tw-shadow-colored: var(--scalar-shadow-1);box-shadow:var(--tw-ring-offset-shadow, 0 0 #0000),var(--tw-ring-shadow, 0 0 #0000),var(--tw-shadow)}:where(.scalar-app) .shadow-border{--tw-shadow: inset 0 0 0 1px var(--scalar-border-color);--tw-shadow-colored: inset 0 0 0 1px var(--tw-shadow-color);box-shadow:var(--tw-ring-offset-shadow, 0 0 #0000),var(--tw-ring-shadow, 0 0 #0000),var(--tw-shadow)}:where(.scalar-app) .shadow-lg{--tw-shadow: var(--scalar-shadow-2);--tw-shadow-colored: var(--scalar-shadow-2);box-shadow:var(--tw-ring-offset-shadow, 0 0 #0000),var(--tw-ring-shadow, 0 0 #0000),var(--tw-shadow)}:where(.scalar-app) .shadow-none{--tw-shadow: 0 0 #0000;--tw-shadow-colored: 0 0 var(--tw-shadow-color);box-shadow:var(--tw-ring-offset-shadow, 0 0 #0000),var(--tw-ring-shadow, 0 0 #0000),var(--tw-shadow)}:where(.scalar-app) .shadow-sm{--tw-shadow: rgba(0, 0, 0, .09) 0px 1px 4px;--tw-shadow-colored: 0px 1px 4px var(--tw-shadow-color);box-shadow:var(--tw-ring-offset-shadow, 0 0 #0000),var(--tw-ring-shadow, 0 0 #0000),var(--tw-shadow)}:where(.scalar-app) .shadow-border{--tw-shadow-color: var(--scalar-border-color);--tw-shadow: var(--tw-shadow-colored)}:where(.scalar-app) .outline-none{outline:2px solid transparent;outline-offset:2px}:where(.scalar-app) .-outline-offset-1{outline-offset:-1px}:where(.scalar-app) .outline-offset-1{outline-offset:1px}:where(.scalar-app) .outline-offset-\\[-1px\\]{outline-offset:-1px}:where(.scalar-app) .blur{--tw-blur: blur(8px);filter:var(--tw-blur) var(--tw-brightness) var(--tw-contrast) var(--tw-grayscale) var(--tw-hue-rotate) var(--tw-invert) var(--tw-saturate) var(--tw-sepia) var(--tw-drop-shadow)}:where(.scalar-app) .brightness-lifted{--tw-brightness: brightness(var(--scalar-lifted-brightness));filter:var(--tw-blur) var(--tw-brightness) var(--tw-contrast) var(--tw-grayscale) var(--tw-hue-rotate) var(--tw-invert) var(--tw-saturate) var(--tw-sepia) var(--tw-drop-shadow)}:where(.scalar-app) .filter{filter:var(--tw-blur) var(--tw-brightness) var(--tw-contrast) var(--tw-grayscale) var(--tw-hue-rotate) var(--tw-invert) var(--tw-saturate) var(--tw-sepia) var(--tw-drop-shadow)}:where(.scalar-app) .backdrop-blur{--tw-backdrop-blur: blur(8px);-webkit-backdrop-filter:var(--tw-backdrop-blur) var(--tw-backdrop-brightness) var(--tw-backdrop-contrast) var(--tw-backdrop-grayscale) var(--tw-backdrop-hue-rotate) var(--tw-backdrop-invert) var(--tw-backdrop-opacity) var(--tw-backdrop-saturate) var(--tw-backdrop-sepia);backdrop-filter:var(--tw-backdrop-blur) var(--tw-backdrop-brightness) var(--tw-backdrop-contrast) var(--tw-backdrop-grayscale) var(--tw-backdrop-hue-rotate) var(--tw-backdrop-invert) var(--tw-backdrop-opacity) var(--tw-backdrop-saturate) var(--tw-backdrop-sepia)}:where(.scalar-app) .transition{transition-property:color,background-color,border-color,text-decoration-color,fill,stroke,opacity,box-shadow,transform,filter,-webkit-backdrop-filter;transition-property:color,background-color,border-color,text-decoration-color,fill,stroke,opacity,box-shadow,transform,filter,backdrop-filter;transition-property:color,background-color,border-color,text-decoration-color,fill,stroke,opacity,box-shadow,transform,filter,backdrop-filter,-webkit-backdrop-filter;transition-timing-function:cubic-bezier(.4,0,.2,1);transition-duration:.15s}:where(.scalar-app) .transition-colors{transition-property:color,background-color,border-color,text-decoration-color,fill,stroke;transition-timing-function:cubic-bezier(.4,0,.2,1);transition-duration:.15s}:where(.scalar-app) .transition-transform{transition-property:transform;transition-timing-function:cubic-bezier(.4,0,.2,1);transition-duration:.15s}:where(.scalar-app) .duration-100{transition-duration:.1s}:where(.scalar-app) .duration-300{transition-duration:.3s}:where(.scalar-app) .ease-in-out{transition-timing-function:cubic-bezier(.4,0,.2,1)}:where(.scalar-app) .bg-mix-transparent{background-color:color-mix(var(--tw-bg-mix-method, in srgb),transparent calc(var(--tw-bg-mix-amount, 0) * 1%),var(--tw-bg-base))}:where(.scalar-app) .bg-mix-amount-25{--tw-bg-mix-amount: 25}:where(.scalar-app) .bg-b-1{--tw-bg-base: var(--scalar-background-1)}:where(.scalar-app) .bg-b-1\\.5{--tw-bg-base: color-mix(in srgb, var(--scalar-background-1), var(--scalar-background-2))}:where(.scalar-app) .bg-b-2{--tw-bg-base: var(--scalar-background-2)}:where(.scalar-app) .bg-b-3{--tw-bg-base: var(--scalar-background-3)}:where(.scalar-app) .bg-b-btn{--tw-bg-base: var(--scalar-button-1)}:where(.scalar-app) .bg-backdrop{--tw-bg-base: rgba(0, 0, 0, .22)}:where(.scalar-app) .bg-border{--tw-bg-base: var(--scalar-border-color)}:where(.scalar-app) .bg-c-accent{--tw-bg-base: var(--scalar-color-accent)}:where(.scalar-app) .bg-c-danger{--tw-bg-base: var(--scalar-color-danger)}:where(.scalar-app) .bg-red{--tw-bg-base: var(--scalar-color-red)}:where(.scalar-app) .bg-sidebar-b-1{--tw-bg-base: var(--scalar-sidebar-background-1, var(--scalar-background-1))}:where(.scalar-app) .bg-sidebar-indent-active{--tw-bg-base: var(--scalar-sidebar-indent-border-active, var(--scalar-color-accent))}:where(.scalar-app) .bg-sidebar-indent-border{--tw-bg-base: var(--scalar-sidebar-indent-border, var(--scalar-border-color))}:where(.scalar-app) .bg-transparent{--tw-bg-base: transparent}:where(.scalar-app) .bg-white{--tw-bg-opacity: 1;--tw-bg-base: rgb(255 255 255 / var(--tw-bg-opacity))}:where(.scalar-app) .row,:where(.scalar-app) .scalar-row{display:flex;flex-direction:row}:where(.scalar-app) .col{display:flex;flex-direction:column}:where(.scalar-app) .centered-x{left:50%;--tw-translate-x: -50%;transform:translate(var(--tw-translate-x),var(--tw-translate-y)) rotate(var(--tw-rotate)) skew(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y))}:where(.scalar-app) .centered{left:50%;--tw-translate-x: -50%;top:50%;--tw-translate-y: -50%;transform:translate(var(--tw-translate-x),var(--tw-translate-y)) rotate(var(--tw-rotate)) skew(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y))}:where(.scalar-app) .\\*\\:flex>*{display:flex}:where(.scalar-app) .\\*\\:flex-1>*{flex:1 1 0%}:where(.scalar-app) .\\*\\:items-center>*{align-items:center}:where(.scalar-app) .\\*\\:gap-px>*{gap:1px}:where(.scalar-app) .placeholder\\:font-\\[inherit\\]::-moz-placeholder{font-family:inherit}:where(.scalar-app) .placeholder\\:font-\\[inherit\\]::placeholder{font-family:inherit}:where(.scalar-app) .focus-within\\:bg-b-1:focus-within{background-color:var(--scalar-background-1)}:where(.scalar-app) .focus-within\\:outline-none:focus-within{outline:2px solid transparent;outline-offset:2px}:where(.scalar-app) .focus-within\\:bg-b-1:focus-within{--tw-bg-base: var(--scalar-background-1)}:where(.scalar-app) .hover\\:bg-b-2:hover{background-color:var(--scalar-background-2)}:where(.scalar-app) .hover\\:bg-b-3:hover{background-color:var(--scalar-background-3)}:where(.scalar-app) .hover\\:bg-h-btn:hover{background-color:var(--scalar-button-1-hover)}:where(.scalar-app) .hover\\:text-c-1:hover{color:var(--scalar-color-1)}:where(.scalar-app) .hover\\:underline:hover{text-decoration-line:underline}:where(.scalar-app) .hover\\:bg-b-2:hover{--tw-bg-base: var(--scalar-background-2)}:where(.scalar-app) .hover\\:bg-b-3:hover{--tw-bg-base: var(--scalar-background-3)}:where(.scalar-app) .hover\\:bg-h-btn:hover{--tw-bg-base: var(--scalar-button-1-hover)}:where(.scalar-app) .focus\\:outline-none:focus{outline:2px solid transparent;outline-offset:2px}:where(.scalar-app) .focus-visible\\:border-c-btn:focus-visible{border-color:var(--scalar-button-1-color)}:where(.scalar-app) .focus-visible\\:outline:focus-visible{outline-style:solid}:where(.scalar-app) .focus-visible\\:ring-1:focus-visible{--tw-ring-offset-shadow: var(--tw-ring-inset) 0 0 0 var(--tw-ring-offset-width) var(--tw-ring-offset-color);--tw-ring-shadow: var(--tw-ring-inset) 0 0 0 calc(1px + var(--tw-ring-offset-width)) var(--tw-ring-color);box-shadow:var(--tw-ring-offset-shadow),var(--tw-ring-shadow),var(--tw-shadow, 0 0 #0000)}:where(.scalar-app) .focus-visible\\:ring-c-accent:focus-visible{--tw-ring-color: var(--scalar-color-accent)}:where(.scalar-app) .active\\:bg-b-btn:active{background-color:var(--scalar-button-1)}:where(.scalar-app) .active\\:text-c-1:active{color:var(--scalar-color-1)}:where(.scalar-app) .active\\:shadow-none:active{--tw-shadow: 0 0 #0000;--tw-shadow-colored: 0 0 var(--tw-shadow-color);box-shadow:var(--tw-ring-offset-shadow, 0 0 #0000),var(--tw-ring-shadow, 0 0 #0000),var(--tw-shadow)}:where(.scalar-app) .active\\:brightness-90:active{--tw-brightness: brightness(.9);filter:var(--tw-blur) var(--tw-brightness) var(--tw-contrast) var(--tw-grayscale) var(--tw-hue-rotate) var(--tw-invert) var(--tw-saturate) var(--tw-sepia) var(--tw-drop-shadow)}:where(.scalar-app) .active\\:bg-b-btn:active{--tw-bg-base: var(--scalar-button-1)}:where(.scalar-app) .group\\/button:hover .group-hover\\/button\\:bg-sidebar-indent-hover{background-color:var(--scalar-sidebar-indent-border-hover, var(--scalar-border-color))}:where(.scalar-app) .group\\/button:hover .group-hover\\/button\\:text-c-1,:where(.scalar-app) .group:hover .group-hover\\:text-c-1{color:var(--scalar-color-1)}:where(.scalar-app) .group\\/item:hover .group-hover\\/item\\:opacity-100{opacity:1}:where(.scalar-app) .group\\/button:hover .group-hover\\/button\\:bg-sidebar-indent-hover{--tw-bg-base: var(--scalar-sidebar-indent-border-hover, var(--scalar-border-color))}:where(.scalar-app) .group\\/toggle:focus-visible .group-focus-visible\\/toggle\\:outline{outline-style:solid}:where(.scalar-app) .peer:checked~.peer-checked\\:text-c-2{color:var(--scalar-color-2)}:where(.scalar-app) .peer:checked~.peer-checked\\:opacity-100{opacity:1}:where(.scalar-app) .has-\\[\\:focus-visible\\]\\:bg-b-1:has(:focus-visible){background-color:var(--scalar-background-1)}:where(.scalar-app) .has-\\[\\:focus-visible\\]\\:outline:has(:focus-visible){outline-style:solid}:where(.scalar-app) .has-\\[input\\:focus-visible\\]\\:outline:has(input:focus-visible){outline-style:solid}:where(.scalar-app) .has-\\[\\:focus-visible\\]\\:bg-b-1:has(:focus-visible){--tw-bg-base: var(--scalar-background-1)}:where(.scalar-app) .ui-open\\:rotate-180[data-headlessui-state~=open]{--tw-rotate: 180deg;transform:translate(var(--tw-translate-x),var(--tw-translate-y)) rotate(var(--tw-rotate)) skew(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y))}:where(.scalar-app) :where([data-headlessui-state~=open]) .ui-open\\:rotate-180{--tw-rotate: 180deg;transform:translate(var(--tw-translate-x),var(--tw-translate-y)) rotate(var(--tw-rotate)) skew(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y))}:where(.scalar-app) .hocus\\:text-c-1:hover{color:var(--scalar-color-1)}:where(.scalar-app) .hocus\\:brightness-90:hover{--tw-brightness: brightness(.9);filter:var(--tw-blur) var(--tw-brightness) var(--tw-contrast) var(--tw-grayscale) var(--tw-hue-rotate) var(--tw-invert) var(--tw-saturate) var(--tw-sepia) var(--tw-drop-shadow)}:where(.scalar-app) .hocus\\:text-c-1:focus-visible{color:var(--scalar-color-1)}:where(.scalar-app) .hocus\\:brightness-90:focus-visible{--tw-brightness: brightness(.9);filter:var(--tw-blur) var(--tw-brightness) var(--tw-contrast) var(--tw-grayscale) var(--tw-hue-rotate) var(--tw-invert) var(--tw-saturate) var(--tw-sepia) var(--tw-drop-shadow)}@media (min-width: 800px){:where(.scalar-app) .md\\:w-\\[calc\\(100vw-16px\\)\\]{width:calc(100vw - 16px)}}@media (min-width: 1000px){:where(.scalar-app) .lg\\:w-\\[calc\\(100vw-32px\\)\\]{width:calc(100vw - 32px)}:where(.scalar-app) .lg\\:w-full{width:100%}}@media (max-width: 720px) and (max-height: 480px){:where(.scalar-app) .zoomed\\:\\!whitespace-normal{white-space:normal!important}}:where(.scalar-app) .dark\\:bg-b-3:where(.dark-mode,.dark-mode *){background-color:var(--scalar-background-3)}:where(.scalar-app) .dark\\:bg-backdropdark:where(.dark-mode,.dark-mode *){background-color:#00000073}:where(.scalar-app) .dark\\:bg-b-3:where(.dark-mode,.dark-mode *){--tw-bg-base: var(--scalar-background-3)}:where(.scalar-app) .dark\\:bg-backdropdark:where(.dark-mode,.dark-mode *){--tw-bg-base: rgba(0, 0, 0, .45)}:where(.scalar-app) .dark\\:hover\\:bg-b-3:hover:where(.dark-mode,.dark-mode *){background-color:var(--scalar-background-3);--tw-bg-base: var(--scalar-background-3)}.loader-wrapper[data-v-338fc8d9]{position:relative;display:flex;align-items:center;justify-content:center;--loader-size: 50%}.svg-loader[data-v-338fc8d9]{width:var(--loader-size);height:var(--loader-size);top:1rem;right:.9rem;overflow:visible;fill:none;background-color:transparent;stroke:currentColor}.svg-path[data-v-338fc8d9]{stroke-width:14;fill:none;transition:.3s}.svg-x-mark[data-v-338fc8d9]{stroke-dasharray:57;stroke-dashoffset:57;transition-delay:0s}.svg-check-mark[data-v-338fc8d9]{stroke-dasharray:149;stroke-dashoffset:149;transition-delay:0s}.icon-is-invalid .svg-x-mark[data-v-338fc8d9],.icon-is-valid .svg-check-mark[data-v-338fc8d9]{stroke-dashoffset:0;transition-delay:.3s}.circular-loader[data-v-338fc8d9]{animation:rotate-338fc8d9 .7s linear infinite,fade-in-338fc8d9 .4s;transform-origin:center center;transform:scale(5);background:transparent}.loader-path[data-v-338fc8d9]{stroke-dasharray:50,200;stroke-dashoffset:-100;stroke-linecap:round}.loader-path-off[data-v-338fc8d9]{stroke-dasharray:50,200;stroke-dashoffset:-100;transition:opacity .3s;opacity:0}@keyframes fade-in-338fc8d9{0%{opacity:0}70%{opacity:0}to{opacity:1}}@keyframes rotate-338fc8d9{0%{transform:scale(5) rotate(0)}to{transform:scale(5) rotate(360deg)}}.scalar-icon[data-v-5c682fd5],.scalar-icon[data-v-5c682fd5] *{stroke-width:var(--29d737c3)}.scalar-code-block{background:inherit;position:relative;overflow:auto;padding:.75rem}.scalar-code-block:hover .copy-button,.copy-button:focus-visible{opacity:100}.scalar-codeblock-pre{all:unset;margin:0;background:transparent;text-wrap:nowrap;white-space-collapse:preserve;border-radius:0;width:-moz-fit-content;width:fit-content}.scalar-code-copy{display:flex;align-items:flex-start;justify-content:flex-end;position:sticky;top:0;right:0;bottom:0;left:0}.copy-button{position:relative;top:0;right:0;display:flex;align-items:center;background-color:var(--scalar-background-2);border:1px solid var(--scalar-border-color);border-radius:3px;color:var(--scalar-color-3);cursor:pointer;height:30px;margin-bottom:-30px;opacity:0;padding:6px;transition:opacity .15s ease-in-out,color .15s ease-in-out}.scalar-code-copy,.copy-button{background:inherit}.copy-button:hover{color:var(--scalar-color-1)}.copy-button svg{stroke-width:1.5}.toggle-icon-ellipse[data-v-60be8692]{width:7px;height:7px;border-radius:50%;box-shadow:inset 0 0 0 1px currentColor;overflow:hidden;position:relative;background:var(--scalar-background-1);display:inline-block;transition:width .3s ease-in-out,height .3s ease-in-out}.toggle-icon-moon-mask[data-v-60be8692]{width:100%;height:100%;border:1px solid currentColor;display:block;left:2.5px;bottom:2.5px;position:absolute;border-radius:50%;background:var(--scalar-background-1);transition:transform .3s ease-in-out;transform:translate3d(4px,-4px,0)}.toggle-icon-sun-ray[data-v-60be8692]{width:12px;height:1px;border-radius:8px;background:currentColor;position:absolute;transition:transform .3s ease-in-out}.toggle-icon-sun-ray[data-v-60be8692]:nth-of-type(2){transform:rotate(90deg)}.toggle-icon-sun-ray[data-v-60be8692]:nth-of-type(3){transform:rotate(45deg)}.toggle-icon-sun-ray[data-v-60be8692]:nth-of-type(4){transform:rotate(-45deg)}.toggle-icon-dark .toggle-icon-ellipse[data-v-60be8692]{width:10px;height:10px;-webkit-mask-image:radial-gradient(circle at bottom left,pink 10px,transparent 12px);mask-image:radial-gradient(circle at bottom left,pink 10px,transparent 12px)}.toggle-icon-dark .toggle-icon-sun-ray[data-v-60be8692]{transform:scale(0)}.toggle-icon-dark .toggle-icon-moon-mask[data-v-60be8692]{transform:translateZ(0)}.scalar-app :where(code.hljs) *{font-size:inherit;font-family:var(--scalar-font-code);text-align:left;white-space:pre;word-spacing:normal;word-break:normal;word-wrap:normal;line-height:1.4;-moz-tab-size:4;-o-tab-size:4;tab-size:4}.scalar-app code.hljs{all:unset;font-size:inherit;color:var(--scalar-color-2);font-family:var(--scalar-font-code);display:inline-block;counter-reset:linenumber}.scalar-app .hljs{background:transparent;color:var(--scalar-color-2)}.scalar-app .hljs .line:before{color:var(--scalar-color-3);display:inline-block;counter-increment:linenumber;content:counter(linenumber);margin-right:.7em;min-width:calc(var(--line-digits) * 1ch);text-align:right}.scalar-app .hljs-comment,.scalar-app .hljs-quote{color:var(--scalar-color-3);font-style:italic}.scalar-app .hljs-number{color:var(--scalar-color-orange)}.scalar-app .hljs-regexp,.scalar-app .hljs-string,.scalar-app .hljs-built_in{color:var(--scalar-color-blue)}.scalar-app .hljs-title.class_{color:var(--scalar-color-1)}.scalar-app .hljs-keyword{color:var(--scalar-color-purple)}.scalar-app .hljs-title.function_{color:var(--scalar-color-orange)}.scalar-app .hljs-subst,.scalar-app .hljs-name{color:var(--scalar-color-blue)}.scalar-app .hljs-attr,.scalar-app .hljs-attribute{color:var(--scalar-color-1)}.scalar-app .hljs-addition,.scalar-app .hljs-literal,.scalar-app .hljs-selector-tag,.scalar-app .hljs-type{color:var(--scalar-color-green)}.scalar-app .hljs-selector-attr,.scalar-app .hljs-selector-pseudo{color:var(--scalar-color-orange)}.scalar-app .hljs-doctag,.scalar-app .hljs-section,.scalar-app .hljs-title{color:var(--scalar-color-blue)}.scalar-app .hljs-selector-id,.scalar-app .hljs-template-variable,.scalar-app .hljs-variable{color:var(--scalar-color-1)}.scalar-app .hljs-name,.scalar-app .hljs-section,.scalar-app .hljs-strong{font-weight:var(--scalar-semibold)}.scalar-app .hljs-bullet,.scalar-app .hljs-link,.scalar-app .hljs-meta,.scalar-app .hljs-symbol{color:var(--scalar-color-blue)}.scalar-app .hljs-deletion{color:var(--scalar-color-red)}.scalar-app .hljs-formula{background:var(--scalar-color-1)}.scalar-app .hljs-emphasis{font-style:italic}.scalar-app .credential .credential-value{font-size:0;color:transparent}.scalar-app .credential:after{content:\"·····\";color:var(--scalar-color-3);-webkit-user-select:none;-moz-user-select:none;user-select:none}.hljs.language-html{color:var(--scalar-color-1)}.hljs.language-html .hljs-attr{color:var(--scalar-color-2)}.hljs.language-curl .hljs-keyword{color:var(--scalar-color-orange)}.hljs.language-curl .hljs-string{color:var(--scalar-color-1)}.hljs.language-curl .hljs-literal,.hljs.language-php .hljs-variable{color:var(--scalar-color-blue)}.hljs.language-objectivec .hljs-meta{color:var(--scalar-color-1)}.hljs.language-objectivec .hljs-built_in,.hljs-built_in{color:var(--scalar-color-orange)}.scalar-app .markdown{font-family:var(--scalar-font);color:var(--scalar-color-1);word-break:break-word}.scalar-app .markdown h1,.scalar-app .markdown h2,.scalar-app .markdown h3,.scalar-app .markdown h4,.scalar-app .markdown h5,.scalar-app .markdown h6,.scalar-app .markdown p,.scalar-app .markdown div,.scalar-app .markdown img,.scalar-app .markdown details,.scalar-app .markdown summary,.scalar-app .markdown ul,.scalar-app .markdown ol,.scalar-app .markdown table,.scalar-app .markdown blockquote,.scalar-app .markdown code{margin:12px 0}.scalar-app .markdown details{margin:12px 0;color:var(--scalar-color-1)}.scalar-app .markdown summary{display:block;margin:1em 0;padding-left:20px;position:relative;font-weight:var(--scalar-semibold);cursor:pointer;-webkit-user-select:none;-moz-user-select:none;user-select:none}.scalar-app .markdown summary:after{display:block;content:\"\";position:absolute;top:-1px;left:-1px;width:20px;height:20px;background-color:var(--scalar-color-3);-webkit-mask-image:url('data:image/svg+xml,<svg viewBox=\"0 0 24 24\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"m9 18 6-6-6-6\" stroke=\"currentColor\" stroke-width=\"1.5\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/></svg>');mask-image:url('data:image/svg+xml,<svg viewBox=\"0 0 24 24\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"m9 18 6-6-6-6\" stroke=\"currentColor\" stroke-width=\"1.5\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/></svg>')}.scalar-app .markdown summary:hover:after{background-color:var(--scalar-color-1)}.scalar-app .markdown details[open] summary:after{transform:rotate(90deg)}.scalar-app .markdown img{overflow:hidden;border-radius:var(--scalar-radius);max-width:100%}.scalar-app .markdown>:first-child{margin-top:0;margin-bottom:0}.scalar-app .markdown h1{--font-size: 1.4em}.scalar-app .markdown h2{--font-size: 1.25em}.scalar-app .markdown h3{--font-size: 1.1em}.scalar-app .markdown h4,.scalar-app .markdown h6{--font-size: 1em}.scalar-app .markdown h1,.scalar-app .markdown h2,.scalar-app .markdown h3,.scalar-app .markdown h4,.scalar-app .markdown h5,.scalar-app .markdown h6{font-size:var(--font-size);margin:18px 0 6px;font-weight:var(--scalar-bold);display:block;line-height:1.45}.scalar-app .markdown b,.scalar-app .markdown strong{font-weight:var(--scalar-bold)}.scalar-app .markdown p{color:inherit;font-weight:var(--font-weight, var(--scalar-regular));line-height:1.5;margin-bottom:0;display:block}.scalar-app .markdown ul,.scalar-app .markdown ol{padding-left:24px;line-height:1.5;margin:12px 0;display:block}.scalar-app .markdown ul{list-style:disc}.scalar-app .markdown ol{list-style:decimal}.scalar-app .markdown ul.contains-task-list{list-style:none;padding-left:0}.scalar-app .markdown li{margin:6px 0;display:list-item}.scalar-app .markdown ul:first-of-type li:first-of-type{margin-top:0}.scalar-app .markdown a{color:var(--scalar-link-color, var(--scalar-color-accent));font-weight:var(--scalar-link-font-weight, inherit);-webkit-text-decoration:var(--scalar-text-decoration);text-decoration:var(--scalar-text-decoration);cursor:pointer}.scalar-app .markdown a:hover{color:var(--scalar-link-color-hover, var(--scalar-color-accent));-webkit-text-decoration:var(--scalar-text-decoration-hover);text-decoration:var(--scalar-text-decoration-hover)}.scalar-app .markdown em{font-style:italic}.scalar-app .markdown sup{font-size:var(--scalar-micro);vertical-align:super;font-weight:450}.scalar-app .markdown sub{font-size:var(--scalar-micro);vertical-align:sub;font-weight:450}.scalar-app .markdown del{text-decoration:line-through}.scalar-app .markdown code{font-family:var(--scalar-font-code);background-color:var(--scalar-background-2);box-shadow:0 0 0 var(--scalar-border-width) var(--scalar-border-color);font-size:var(--scalar-micro);border-radius:2px;padding:0 3px}.scalar-app .markdown .hljs{font-size:var(--scalar-small)}.scalar-app .markdown pre code{display:block;white-space:pre;padding:12px;line-height:1.5;margin:12px 0;-webkit-overflow-scrolling:touch;overflow-x:auto;max-width:100%;min-width:100px}.scalar-app .markdown hr{border:none;border-bottom:var(--scalar-border-width) solid var(--scalar-border-color)}.scalar-app .markdown blockquote{border-left:3px solid var(--scalar-border-color);padding-left:12px;margin:0;display:block}.scalar-app .markdown table{display:block;overflow-x:auto;position:relative;border-collapse:collapse;width:-moz-max-content;width:max-content;max-width:100%;margin:1em 0;box-shadow:0 0 0 var(--scalar-border-width) var(--scalar-border-color);border-radius:var(--scalar-radius-lg)}.scalar-app .markdown tbody{display:table-row-group;vertical-align:middle}.scalar-app .markdown thead{display:table-header-group;vertical-align:middle}.scalar-app .markdown tr{display:table-row;border-color:inherit;vertical-align:inherit}.scalar-app .markdown td,.scalar-app .markdown th{display:table-cell;vertical-align:inherit;min-width:1em;padding:6px 9px;vertical-align:top;line-height:1.5;position:relative;word-break:initial;font-size:var(--scalar-small);color:var(--scalar-color-1);font-weight:var(--font-weight, var(--scalar-regular));border-right:var(--scalar-border-width) solid var(--scalar-border-color);border-bottom:var(--scalar-border-width) solid var(--scalar-border-color)}.scalar-app .markdown td>*,.scalar-app .markdown th>*{margin-bottom:0}.scalar-app .markdown th:empty{display:none}.scalar-app .markdown td:first-of-type,.scalar-app .markdown th:first-of-type{border-left:none}.scalar-app .markdown td:last-of-type,.scalar-app .markdown th:last-of-type{border-right:none}.scalar-app .markdown tr:last-of-type td{border-bottom:none}.scalar-app .markdown th{font-weight:var(--scalar-semibold)!important;text-align:left;border-left-color:transparent;background:var(--scalar-background-2)}.scalar-app .markdown tr>[align=left]{text-align:left}.scalar-app .markdown tr>[align=right]{text-align:right}.scalar-app .markdown tr>[align=center]{text-align:center}.scalar-app .markdown .markdown-alert{align-items:stretch;border-radius:var(--scalar-radius-lg);background-color:color-mix(in srgb,var(--scalar-background-2),transparent);border:var(--scalar-border-width) solid var(--scalar-border-color);display:flex;font-size:var(--scalar-small);gap:12px;padding:12px 12px 12px 42px;position:relative}.scalar-app .markdown .markdown-alert:before{content:\"\";position:absolute;left:12px;top:12px;width:20px;height:20px;background-color:currentColor;-webkit-mask-repeat:no-repeat;mask-repeat:no-repeat;-webkit-mask-size:contain;mask-size:contain;-webkit-mask-position:center;mask-position:center}.scalar-app .markdown .markdown-alert.markdown-alert-note:before,.scalar-app .markdown .markdown-alert.markdown-alert-tip:before{-webkit-mask-image:url('data:image/svg+xml,<svg viewBox=\"0 0 24 24\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M12 17v-6a.5.5 0 0 0-.5-.5l-.5.001h-1M12 17h-2m2 0h2m-2 5c5.523 0 10-4.477 10-10S17.523 2 12 2 2 6.477 2 12s4.477 10 10 10Z\" stroke=\"currentColor\" stroke-width=\"1.5\" stroke-miterlimit=\"10\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M10.75 7.5a1 1 0 1 1 2 0 1 1 0 0 1-2 0Z\" fill=\"currentColor\"/></svg>');mask-image:url('data:image/svg+xml,<svg viewBox=\"0 0 24 24\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M12 17v-6a.5.5 0 0 0-.5-.5l-.5.001h-1M12 17h-2m2 0h2m-2 5c5.523 0 10-4.477 10-10S17.523 2 12 2 2 6.477 2 12s4.477 10 10 10Z\" stroke=\"currentColor\" stroke-width=\"1.5\" stroke-miterlimit=\"10\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M10.75 7.5a1 1 0 1 1 2 0 1 1 0 0 1-2 0Z\" fill=\"currentColor\"/></svg>')}.scalar-app .markdown .markdown-alert.markdown-alert-important:before,.scalar-app .markdown .markdown-alert.markdown-alert-warning:before{-webkit-mask-image:url('data:image/svg+xml,<svg viewBox=\"0 0 24 24\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M12 8v4m10 0c0 5.523-4.477 10-10 10S2 17.523 2 12 6.477 2 12 2s10 4.477 10 10Z\" stroke=\"currentColor\" stroke-width=\"1.5\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M11 16a1 1 0 1 1 2 0 1 1 0 0 1-2 0Z\" fill=\"currentColor\"/></svg>');mask-image:url('data:image/svg+xml,<svg viewBox=\"0 0 24 24\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M12 8v4m10 0c0 5.523-4.477 10-10 10S2 17.523 2 12 6.477 2 12 2s10 4.477 10 10Z\" stroke=\"currentColor\" stroke-width=\"1.5\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M11 16a1 1 0 1 1 2 0 1 1 0 0 1-2 0Z\" fill=\"currentColor\"/></svg>')}.scalar-app .markdown .markdown-alert.markdown-alert-caution:before{-webkit-mask-image:url('data:image/svg+xml,<svg viewBox=\"0 0 24 24\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M12 8v4m3.312-10a2 2 0 0 1 1.414.586l4.688 4.688A2 2 0 0 1 22 8.688v6.624a2 2 0 0 1-.586 1.414l-4.688 4.688a2 2 0 0 1-1.414.586H8.688a2 2 0 0 1-1.414-.586l-4.688-4.688A2 2 0 0 1 2 15.312V8.688a2 2 0 0 1 .586-1.414l4.688-4.688A2 2 0 0 1 8.688 2h6.624Z\" stroke=\"currentColor\" stroke-width=\"1.5\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M11 16a1 1 0 1 1 2 0 1 1 0 0 1-2 0Z\" fill=\"currentColor\"/></svg>');mask-image:url('data:image/svg+xml,<svg viewBox=\"0 0 24 24\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M12 8v4m3.312-10a2 2 0 0 1 1.414.586l4.688 4.688A2 2 0 0 1 22 8.688v6.624a2 2 0 0 1-.586 1.414l-4.688 4.688a2 2 0 0 1-1.414.586H8.688a2 2 0 0 1-1.414-.586l-4.688-4.688A2 2 0 0 1 2 15.312V8.688a2 2 0 0 1 .586-1.414l4.688-4.688A2 2 0 0 1 8.688 2h6.624Z\" stroke=\"currentColor\" stroke-width=\"1.5\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M11 16a1 1 0 1 1 2 0 1 1 0 0 1-2 0Z\" fill=\"currentColor\"/></svg>');color:var(--scalar-color-red)}.scalar-app .markdown .markdown-alert.markdown-alert-success:before{-webkit-mask-image:url('data:image/svg+xml,<svg viewBox=\"0 0 24 24\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M16 9.5 10.5 15 8 12.5m14-.5c0 5.523-4.477 10-10 10S2 17.523 2 12 6.477 2 12 2s10 4.477 10 10Z\" stroke=\"currentColor\" stroke-width=\"1.5\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/></svg>');mask-image:url('data:image/svg+xml,<svg viewBox=\"0 0 24 24\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M16 9.5 10.5 15 8 12.5m14-.5c0 5.523-4.477 10-10 10S2 17.523 2 12 6.477 2 12 2s10 4.477 10 10Z\" stroke=\"currentColor\" stroke-width=\"1.5\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/></svg>');color:var(--scalar-color-green)}.scalar-app .markdown .markdown-alert.markdown-alert-note:before{color:var(--scalar-color-blue)}.scalar-app .markdown .markdown-alert.markdown-alert-tip:before{color:var(--scalar-color-2)}.scalar-app .markdown .markdown-alert.markdown-alert-important:before{color:var(--scalar-color-purple)}.scalar-app .markdown .markdown-alert.markdown-alert-warning:before{color:var(--scalar-color-orange)}.scalar-app .markdown .markdown-alert .markdown-alert-content{margin:0;line-height:1.5}.dark-mode .scalar-dropdown-item[data-v-cc5bd05e]:hover{filter:brightness(1.1)}.group\\/item>.group\\/button>.scalar-sidebar-indent .scalar-sidebar-indent-border[data-v-11a7f565]{top:-1px;bottom:-1px}.group\\/item:first-child>.group\\/button>.scalar-sidebar-indent .scalar-sidebar-indent-border[data-v-11a7f565]{top:0}.group\\/item:last-child>.group\\/button>.scalar-sidebar-indent .scalar-sidebar-indent-border[data-v-11a7f565]{bottom:0}.dark-mode .scalar-dropdown-item[data-v-457c1cd3]:hover{filter:brightness(1.1)}.scalar-modal-layout[data-v-a99680e7]{animation:fadein-layout-a99680e7 ease-in-out .3s forwards}.scalar-modal[data-v-a99680e7]{animation:fadein-modal-a99680e7 ease-in-out .3s forwards;animation-delay:.1s;box-shadow:var(--scalar-shadow-2);transform:translate3d(0,10px,0)}.scalar-modal-layout-full[data-v-a99680e7]{opacity:1!important;background:transparent!important}.modal-content-search .modal-body[data-v-a99680e7]{padding:0;overflow:hidden;display:flex;flex-direction:column;max-height:440px}@media (max-width: 720px) and (max-height: 480px){.scalar-modal-layout .scalar-modal[data-v-a99680e7]{margin-top:5svh;max-height:90svh}}@keyframes fadein-layout-a99680e7{0%{opacity:0}to{opacity:1}}@keyframes fadein-modal-a99680e7{0%{opacity:0;transform:translate3d(0,10px,0)}to{opacity:1;transform:translateZ(0)}}.full-size-styles[data-v-a99680e7]{transform:translateZ(0);animation:fadein-layout-a99680e7 ease-in-out .3s forwards;max-height:100%!important;top:0!important;left:0;position:absolute!important;margin:initial;border-radius:0!important;background-color:var(--scalar-background-1)!important;box-shadow:none!important;border-right:var(--scalar-border-width) solid var(--scalar-border-color)}@media (min-width: 800px){.full-size-styles[data-v-a99680e7]{width:50dvw!important}}.full-size-styles[data-v-a99680e7]:after{content:\"\";width:50dvw;height:100dvh;position:absolute;right:-50dvw;top:0}.search-background[data-v-466c736b]{background:color-mix(in srgb,var(--scalar-background-1),var(--scalar-background-2))}.search-background[data-v-466c736b]:focus-within{background:transparent}@layer scalar-base,scalar-theme;@layer scalar-base{body{margin:0;line-height:inherit}}:where(.scalar-app){font-family:var(--scalar-font);line-height:1.15;-webkit-text-size-adjust:100%;-moz-tab-size:4;-o-tab-size:4;tab-size:4}:where(.scalar-app) *,:where(.scalar-app) *:before,:where(.scalar-app) *:after{box-sizing:border-box;border-width:0;border-style:solid;border-color:var(--scalar-border-color);outline-width:1px;outline-style:none;outline-color:var(--scalar-color-accent);font-family:inherit;font-feature-settings:inherit;font-variation-settings:inherit;font-size:inherit;font-weight:inherit;line-height:inherit;color:inherit;margin:unset;padding:unset;text-rendering:optimizeLegibility;-webkit-font-smoothing:antialiased;-moz-osx-font-smoothing:grayscale}:where(.scalar-app) :before,:where(.scalar-app) :after{--tw-content: \"\"}:where(.scalar-app) button,:where(.scalar-app) input,:where(.scalar-app) optgroup,:where(.scalar-app) select,:where(.scalar-app) textarea,:where(.scalar-app) ::file-selector-button{background:transparent}:where(.scalar-app) ol,:where(.scalar-app) ul,:where(.scalar-app) menu{list-style:none}:where(.scalar-app) input:where(:not([type=button],[type=reset],[type=submit])),:where(.scalar-app) select,:where(.scalar-app) textarea{border-radius:var(--scalar-radius);border-width:1px}:where(.scalar-app) input::-moz-placeholder{color:var(--scalar-color-3);font-family:var(--scalar-font)}:where(.scalar-app) input::placeholder{color:var(--scalar-color-3);font-family:var(--scalar-font)}:where(.scalar-app) input[type=search]::-webkit-search-cancel-button,:where(.scalar-app) input[type=search]::-webkit-search-decoration{-webkit-appearance:none;-moz-appearance:none;appearance:none}:where(.scalar-app) summary::-webkit-details-marker{display:none}:where(.scalar-app) input:-webkit-autofill{-webkit-background-clip:text!important;background-clip:text!important}:where(.scalar-app) :focus-visible{outline-style:solid;border-radius:var(--scalar-radius)}:where(.scalar-app) button:focus-visible,:where(.scalar-app) [role=button]:focus-visible{outline-offset:-1px}:where(.scalar-app) button,:where(.scalar-app) [role=button]{cursor:pointer}:where(.scalar-app) :disabled{cursor:default}:where(.scalar-app) img,:where(.scalar-app) svg,:where(.scalar-app) video,:where(.scalar-app) canvas,:where(.scalar-app) audio,:where(.scalar-app) iframe,:where(.scalar-app) embed,:where(.scalar-app) object{display:block;vertical-align:middle}:where(.scalar-app) [hidden]{display:none}.scalar-app .cm-scroller,.scalar-app .custom-scroll{overflow-y:auto;scrollbar-color:transparent transparent;scrollbar-width:thin;-webkit-overflow-scrolling:touch}.scalar-app .custom-scroll-self-contain-overflow{overscroll-behavior:contain}.scalar-app .cm-scroller:hover,.scalar-app .custom-scroll:hover,.scalar-app.scalar-scrollbars-obtrusive .cm-scroller,.scalar-app.scalar-scrollbars-obtrusive .custom-scroll{scrollbar-color:var(--scalar-scrollbar-color, transparent) transparent}.scalar-app .cm-scroller:hover::-webkit-scrollbar-thumb,.scalar-app .custom-scroll:hover::-webkit-scrollbar-thumb{background:var(--scalar-scrollbar-color);background-clip:content-box;border:3px solid transparent}.scalar-app .cm-scroller::-webkit-scrollbar-thumb:active,.scalar-app .custom-scroll::-webkit-scrollbar-thumb:active{background:var(--scalar-scrollbar-color-active);background-clip:content-box;border:3px solid transparent}.scalar-app .cm-scroller::-webkit-scrollbar-corner,.scalar-app .custom-scroll::-webkit-scrollbar-corner{background:transparent}.scalar-app .cm-scroller::-webkit-scrollbar,.scalar-app .custom-scroll::-webkit-scrollbar{height:12px;width:12px}.scalar-app .cm-scroller::-webkit-scrollbar-track,.scalar-app .custom-scroll::-webkit-scrollbar-track{background:transparent}.scalar-app .cm-scroller::-webkit-scrollbar-thumb,.scalar-app .custom-scroll::-webkit-scrollbar-thumb{border-radius:20px;background:transparent;background-clip:content-box;border:3px solid transparent}@media (pointer: coarse){.scalar-app .cm-scroller,.scalar-app .custom-scroll{padding-right:12px}}@layer scalar-base{:root{--scalar-border-width: .5px;--scalar-radius: 3px;--scalar-radius-lg: 6px;--scalar-radius-xl: 8px;--scalar-font: \"Inter\", -apple-system, BlinkMacSystemFont, \"Segoe UI\", Roboto, Oxygen, Ubuntu, Cantarell, \"Open Sans\", \"Helvetica Neue\", sans-serif;--scalar-font-code: \"JetBrains Mono\", ui-monospace, Menlo, Monaco, \"Cascadia Mono\", \"Segoe UI Mono\", \"Roboto Mono\", \"Oxygen Mono\", \"Ubuntu Monospace\", \"Source Code Pro\", \"Fira Mono\", \"Droid Sans Mono\", \"Courier New\", monospace;--scalar-heading-1: 40px;--scalar-page-description: 24px;--scalar-heading-2: 24px;--scalar-heading-3: 20px;--scalar-heading-4: 16px;--scalar-heading-5: 16px;--scalar-heading-6: 16px;--scalar-paragraph: 16px;--scalar-small: 14px;--scalar-mini: 13px;--scalar-micro: 12px;--scalar-bold: 600;--scalar-semibold: 500;--scalar-regular: 400;--scalar-font-size-1: 21px;--scalar-font-size-2: 16px;--scalar-font-size-3: 14px;--scalar-font-size-4: 13px;--scalar-font-size-5: 12px;--scalar-font-size-6: 12px;--scalar-font-size-7: 10px;--scalar-line-height-1: 32px;--scalar-line-height-2: 24px;--scalar-line-height-3: 20px;--scalar-line-height-4: 18px;--scalar-line-height-5: 16px;--scalar-font-medium: 500;--scalar-font-bold: 700;--scalar-text-decoration: none;--scalar-text-decoration-hover: underline;--scalar-link-font-weight: inherit;--scalar-sidebar-indent: 18px}.dark-mode{color-scheme:dark;--scalar-scrollbar-color: rgba(255, 255, 255, .18);--scalar-scrollbar-color-active: rgba(255, 255, 255, .36);--scalar-button-1: rgba(255, 255, 255, 1);--scalar-button-1-hover: rgba(255, 255, 255, .9);--scalar-button-1-color: black;--scalar-shadow-1: 0 1px 3px 0 rgb(0, 0, 0, .1);--scalar-shadow-2: 0 0 0 .5px var(--scalar-border-color), rgba(15, 15, 15, .2) 0px 3px 6px, rgba(15, 15, 15, .4) 0px 9px 24px;--scalar-lifted-brightness: 1.45;--scalar-backdrop-brightness: .5;--scalar-link-color: var(--scalar-color-accent);--scalar-link-color-hover: var(--scalar-color-accent);--scalar-text-decoration-color: currentColor;--scalar-text-decoration-color-hover: currentColor}.light-mode{color-scheme:light;--scalar-scrollbar-color-active: rgba(0, 0, 0, .36);--scalar-scrollbar-color: rgba(0, 0, 0, .18);--scalar-button-1: rgba(0, 0, 0, 1);--scalar-button-1-hover: rgba(0, 0, 0, .8);--scalar-button-1-color: rgba(255, 255, 255, .9);--scalar-shadow-1: 0 1px 3px 0 rgba(0, 0, 0, .11);--scalar-shadow-2: rgba(0, 0, 0, .08) 0px 13px 20px 0px, rgba(0, 0, 0, .08) 0px 3px 8px 0px, #eeeeed 0px 0 0 .5px;--scalar-lifted-brightness: 1;--scalar-backdrop-brightness: 1;--scalar-link-color: var(--scalar-color-accent);--scalar-link-color-hover: var(--scalar-color-accent);--scalar-text-decoration-color: currentColor;--scalar-text-decoration-color-hover: currentColor}.light-mode .dark-mode{color-scheme:dark!important}@media (max-width: 460px){:root{--scalar-font-size-1: 22px;--scalar-font-size-2: 14px;--scalar-font-size-3: 12px}}@media (max-width: 720px){:root{--scalar-heading-1: 24px;--scalar-page-description: 20px}}.light-mode{--scalar-background-1: #fff;--scalar-background-2: #f6f6f6;--scalar-background-3: #e7e7e7;--scalar-background-accent: #8ab4f81f;--scalar-color-1: #2a2f45;--scalar-color-2: #757575;--scalar-color-3: #8e8e8e;--scalar-color-accent: #0099ff;--scalar-border-color: #dfdfdf}.dark-mode{--scalar-background-1: #0f0f0f;--scalar-background-2: #1a1a1a;--scalar-background-3: #272727;--scalar-color-1: #e7e7e7;--scalar-color-2: #a4a4a4;--scalar-color-3: #797979;--scalar-color-accent: #3ea6ff;--scalar-background-accent: #3ea6ff1f;--scalar-border-color: #2d2d2d}.light-mode .t-doc__sidebar,.dark-mode .t-doc__sidebar{--scalar-sidebar-background-1: var(--scalar-background-1);--scalar-sidebar-color-1: var(--scalar-color-1);--scalar-sidebar-color-2: var(--scalar-color-2);--scalar-sidebar-border-color: var(--scalar-border-color);--scalar-sidebar-item-hover-background: var(--scalar-background-2);--scalar-sidebar-item-hover-color: currentColor;--scalar-sidebar-item-active-background: var(--scalar-background-2);--scalar-sidebar-color-active: var(--scalar-color-1);--scalar-sidebar-indent-border: var(--scalar-sidebar-border-color);--scalar-sidebar-indent-border-hover: var(--scalar-sidebar-border-color);--scalar-sidebar-indent-border-active: var(--scalar-sidebar-border-color);--scalar-sidebar-search-background: transparent;--scalar-sidebar-search-color: var(--scalar-color-3);--scalar-sidebar-search-border-color: var(--scalar-border-color)}.light-mode{--scalar-color-green: #069061;--scalar-color-red: #ef0006;--scalar-color-yellow: #edbe20;--scalar-color-blue: #0082d0;--scalar-color-orange: #fb892c;--scalar-color-purple: #5203d1;--scalar-button-1: rgba(0, 0, 0, 1);--scalar-button-1-hover: rgba(0, 0, 0, .8);--scalar-button-1-color: rgba(255, 255, 255, .9);--scalar-color-danger: color-mix(in srgb, var(--scalar-color-red), var(--scalar-color-1) 20%);--scalar-background-alert: color-mix(in srgb, var(--scalar-color-orange), var(--scalar-background-1) 95%);--scalar-background-danger: color-mix(in srgb, var(--scalar-color-red), var(--scalar-background-1) 95%)}.dark-mode{--scalar-color-green: #00b648;--scalar-color-red: #dc1b19;--scalar-color-yellow: #ffc90d;--scalar-color-blue: #4eb3ec;--scalar-color-orange: #ff8d4d;--scalar-color-purple: #b191f9;--scalar-button-1: rgba(255, 255, 255, 1);--scalar-button-1-hover: rgba(255, 255, 255, .9);--scalar-button-1-color: black;--scalar-color-danger: color-mix(in srgb, var(--scalar-color-red), var(--scalar-background-1) 20%);--scalar-background-alert: color-mix(in srgb, var(--scalar-color-orange), var(--scalar-background-1) 95%);--scalar-background-danger: color-mix(in srgb, var(--scalar-color-red), var(--scalar-background-1) 95%)}@supports (color: color(display-p3 1 1 1)){.light-mode{--scalar-color-accent: color(display-p3 0 .6 1 / 1);--scalar-color-green: color(display-p3 .023529 .564706 .380392 / 1);--scalar-color-red: color(display-p3 .937255 0 .023529 / 1);--scalar-color-yellow: color(display-p3 .929412 .745098 .12549 / 1);--scalar-color-blue: color(display-p3 0 .509804 .815686 / 1);--scalar-color-orange: color(display-p3 .984314 .537255 .172549 / 1);--scalar-color-purple: color(display-p3 .321569 .011765 .819608 / 1)}.dark-mode{--scalar-color-accent: color(display-p3 .243137 .65098 1 / 1);--scalar-color-green: color(display-p3 0 .713725 .282353 / 1);--scalar-color-red: color(display-p3 .862745 .105882 .098039 / 1);--scalar-color-yellow: color(display-p3 1 .788235 .05098 / 1);--scalar-color-blue: color(display-p3 .305882 .701961 .92549 / 1);--scalar-color-orange: color(display-p3 1 .552941 .301961 / 1);--scalar-color-purple: color(display-p3 .694118 .568627 .976471 / 1)}}*,:before,:after{--tw-border-spacing-x:0;--tw-border-spacing-y:0;--tw-translate-x:0;--tw-translate-y:0;--tw-rotate:0;--tw-skew-x:0;--tw-skew-y:0;--tw-scale-x:1;--tw-scale-y:1;--tw-pan-x: ;--tw-pan-y: ;--tw-pinch-zoom: ;--tw-scroll-snap-strictness:proximity;--tw-gradient-from-position: ;--tw-gradient-via-position: ;--tw-gradient-to-position: ;--tw-ordinal: ;--tw-slashed-zero: ;--tw-numeric-figure: ;--tw-numeric-spacing: ;--tw-numeric-fraction: ;--tw-ring-inset: ;--tw-ring-offset-width:0px;--tw-ring-offset-color:#fff;--tw-ring-color:rgb(59 130 246 / .5);--tw-ring-offset-shadow:0 0 #0000;--tw-ring-shadow:0 0 #0000;--tw-shadow:0 0 #0000;--tw-shadow-colored:0 0 #0000;--tw-blur: ;--tw-brightness: ;--tw-contrast: ;--tw-grayscale: ;--tw-hue-rotate: ;--tw-invert: ;--tw-saturate: ;--tw-sepia: ;--tw-drop-shadow: ;--tw-backdrop-blur: ;--tw-backdrop-brightness: ;--tw-backdrop-contrast: ;--tw-backdrop-grayscale: ;--tw-backdrop-hue-rotate: ;--tw-backdrop-invert: ;--tw-backdrop-opacity: ;--tw-backdrop-saturate: ;--tw-backdrop-sepia: ;--tw-contain-size: ;--tw-contain-layout: ;--tw-contain-paint: ;--tw-contain-style: }::backdrop{--tw-border-spacing-x:0;--tw-border-spacing-y:0;--tw-translate-x:0;--tw-translate-y:0;--tw-rotate:0;--tw-skew-x:0;--tw-skew-y:0;--tw-scale-x:1;--tw-scale-y:1;--tw-pan-x: ;--tw-pan-y: ;--tw-pinch-zoom: ;--tw-scroll-snap-strictness:proximity;--tw-gradient-from-position: ;--tw-gradient-via-position: ;--tw-gradient-to-position: ;--tw-ordinal: ;--tw-slashed-zero: ;--tw-numeric-figure: ;--tw-numeric-spacing: ;--tw-numeric-fraction: ;--tw-ring-inset: ;--tw-ring-offset-width:0px;--tw-ring-offset-color:#fff;--tw-ring-color:rgb(59 130 246 / .5);--tw-ring-offset-shadow:0 0 #0000;--tw-ring-shadow:0 0 #0000;--tw-shadow:0 0 #0000;--tw-shadow-colored:0 0 #0000;--tw-blur: ;--tw-brightness: ;--tw-contrast: ;--tw-grayscale: ;--tw-hue-rotate: ;--tw-invert: ;--tw-saturate: ;--tw-sepia: ;--tw-drop-shadow: ;--tw-backdrop-blur: ;--tw-backdrop-brightness: ;--tw-backdrop-contrast: ;--tw-backdrop-grayscale: ;--tw-backdrop-hue-rotate: ;--tw-backdrop-invert: ;--tw-backdrop-opacity: ;--tw-backdrop-saturate: ;--tw-backdrop-sepia: ;--tw-contain-size: ;--tw-contain-layout: ;--tw-contain-paint: ;--tw-contain-style: }}.scalar-client{line-height:1.5;color:var(--scalar-color-1)}.scalar-client .\\!container{width:100%!important}.scalar-client .container{width:100%}@media (min-width: 400px){.scalar-client .\\!container{max-width:400px!important}.scalar-client .container{max-width:400px}}@media (min-width: 600px){.scalar-client .\\!container{max-width:600px!important}.scalar-client .container{max-width:600px}}@media (min-width: 800px){.scalar-client .\\!container{max-width:800px!important}.scalar-client .container{max-width:800px}}@media (min-width: 1000px){.scalar-client .\\!container{max-width:1000px!important}.scalar-client .container{max-width:1000px}}@media (min-width: 1200px){.scalar-client .\\!container{max-width:1200px!important}.scalar-client .container{max-width:1200px}}.scalar-client .row{display:flex;flex-direction:row}.scalar-client .row-1{display:flex;flex-direction:row;flex:1 1 0%}.scalar-client .col{display:flex;flex-direction:column}.scalar-client .col-1{display:flex;flex-direction:column;flex:1 1 0%}.scalar-client .flex-center{display:flex;justify-content:center;align-items:center}.scalar-client .centered-x{left:50%;--tw-translate-x: -50%;transform:translate(var(--tw-translate-x),var(--tw-translate-y)) rotate(var(--tw-rotate)) skew(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y))}.scalar-client .centered-y{top:50%;--tw-translate-y: -50%;transform:translate(var(--tw-translate-x),var(--tw-translate-y)) rotate(var(--tw-rotate)) skew(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y))}.scalar-client .centered{left:50%;--tw-translate-x: -50%;top:50%;--tw-translate-y: -50%;transform:translate(var(--tw-translate-x),var(--tw-translate-y)) rotate(var(--tw-rotate)) skew(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y))}.scalar-client .floating-bg:before{background-color:var(--scalar-background-2);border-radius:var(--scalar-radius);content:\"\";height:calc(100% - 4px);left:-4px;opacity:0;position:absolute;top:2.5px;transition:opacity .2s ease-in-out;width:calc(100% + 8px);z-index:1}.scalar-client .floating-bg:hover:before{opacity:1}.scalar-client .sr-only{position:absolute;width:1px;height:1px;padding:0;margin:-1px;overflow:hidden;clip:rect(0,0,0,0);white-space:nowrap;border-width:0}.scalar-client .not-sr-only{position:static;width:auto;height:auto;padding:0;margin:0;overflow:visible;clip:auto;white-space:normal}.scalar-client .pointer-events-none{pointer-events:none}.scalar-client .pointer-events-auto{pointer-events:auto}.scalar-client .visible{visibility:visible}.scalar-client .static{position:static}.scalar-client .fixed{position:fixed}.scalar-client .absolute{position:absolute}.scalar-client .relative{position:relative}.scalar-client .sticky{position:sticky}.scalar-client .inset-0{top:0;right:0;bottom:0;left:0}.scalar-client .inset-x-1{left:4px;right:4px}.scalar-client .-right-\\[30px\\]{right:-30px}.scalar-client .-top-\\[--scalar-address-bar-height\\]{top:calc(var(--scalar-address-bar-height) * -1)}.scalar-client .-top-\\[104px\\]{top:-104px}.scalar-client .bottom-0{bottom:0}.scalar-client .bottom-1{bottom:4px}.scalar-client .bottom-1\\/2{bottom:50%}.scalar-client .bottom-\\[var\\(--scalar-border-width\\)\\]{bottom:var(--scalar-border-width)}.scalar-client .left-0{left:0}.scalar-client .left-1\\/2{left:50%}.scalar-client .left-3{left:12px}.scalar-client .right-0{right:0}.scalar-client .right-1{right:4px}.scalar-client .right-1\\.5{right:6px}.scalar-client .right-1\\/2{right:50%}.scalar-client .right-14{right:56px}.scalar-client .right-16{right:64px}.scalar-client .right-2{right:8px}.scalar-client .right-4{right:16px}.scalar-client .right-7{right:28px}.scalar-client .top-0{top:0}.scalar-client .top-1\\/2{top:50%}.scalar-client .top-12{top:48px}.scalar-client .top-2{top:8px}.scalar-client .-z-1{z-index:-1}.scalar-client .z-0{z-index:0}.scalar-client .z-1{z-index:1}.scalar-client .z-10{z-index:10}.scalar-client .z-20{z-index:20}.scalar-client .z-50{z-index:50}.scalar-client .z-\\[10001\\]{z-index:10001}.scalar-client .z-\\[1002\\]{z-index:1002}.scalar-client .z-\\[1\\]{z-index:1}.scalar-client .z-context{z-index:1000}.scalar-client .z-context-plus{z-index:1001}.scalar-client .z-overlay{z-index:10000}.scalar-client .order-last{order:9999}.scalar-client .col-span-full{grid-column:1 / -1}.scalar-client .\\!m-0{margin:0!important}.scalar-client .m-0{margin:0}.scalar-client .m-4{margin:16px}.scalar-client .m-auto{margin:auto}.scalar-client .-mx-0{margin-left:-0px;margin-right:-0px}.scalar-client .-mx-0\\.25{margin-left:-1px;margin-right:-1px}.scalar-client .-mx-1{margin-left:-4px;margin-right:-4px}.scalar-client .-my-0{margin-top:-0px;margin-bottom:-0px}.scalar-client .-my-0\\.25{margin-top:-1px;margin-bottom:-1px}.scalar-client .-my-1{margin-top:-4px;margin-bottom:-4px}.scalar-client .mx-auto{margin-left:auto;margin-right:auto}.scalar-client .my-1{margin-top:4px;margin-bottom:4px}.scalar-client .my-1\\.25{margin-top:5px;margin-bottom:5px}.scalar-client .my-12{margin-top:48px;margin-bottom:48px}.scalar-client .\\!mb-0{margin-bottom:0!important}.scalar-client .\\!mr-0{margin-right:0!important}.scalar-client .-mb-\\[var\\(--scalar-border-width\\)\\]{margin-bottom:calc(var(--scalar-border-width) * -1)}.scalar-client .-ml-0{margin-left:-0px}.scalar-client .-ml-0\\.5{margin-left:-2px}.scalar-client .-ml-12{margin-left:-48px}.scalar-client .-ml-2{margin-left:-8px}.scalar-client .-mr-1{margin-right:-4px}.scalar-client .-mr-1\\.5{margin-right:-6px}.scalar-client .-mr-3{margin-right:-12px}.scalar-client .-mt-\\[\\.5px\\]{margin-top:-.5px}.scalar-client .mb-0{margin-bottom:0}.scalar-client .mb-1{margin-bottom:4px}.scalar-client .mb-1\\.5{margin-bottom:6px}.scalar-client .mb-2{margin-bottom:8px}.scalar-client .mb-4{margin-bottom:16px}.scalar-client .mb-\\[\\.5px\\]{margin-bottom:.5px}.scalar-client .ml-0{margin-left:0}.scalar-client .ml-0\\.5{margin-left:2px}.scalar-client .ml-0\\.75{margin-left:3px}.scalar-client .ml-1{margin-left:4px}.scalar-client .ml-1\\.25{margin-left:5px}.scalar-client .ml-3{margin-left:12px}.scalar-client .ml-auto{margin-left:auto}.scalar-client .mr-0{margin-right:0}.scalar-client .mr-0\\.5{margin-right:2px}.scalar-client .mr-0\\.75{margin-right:3px}.scalar-client .mr-1{margin-right:4px}.scalar-client .mr-1\\.25{margin-right:5px}.scalar-client .mr-1\\.5{margin-right:6px}.scalar-client .mr-2{margin-right:8px}.scalar-client .mr-2\\.5{margin-right:10px}.scalar-client .mr-3{margin-right:12px}.scalar-client .mr-\\[6\\.25px\\]{margin-right:6.25px}.scalar-client .mr-auto{margin-right:auto}.scalar-client .mt-1{margin-top:4px}.scalar-client .mt-1\\.5{margin-top:6px}.scalar-client .mt-10{margin-top:40px}.scalar-client .mt-2{margin-top:8px}.scalar-client .mt-3{margin-top:12px}.scalar-client .mt-5{margin-top:20px}.scalar-client .mt-auto{margin-top:auto}.scalar-client .box-border{box-sizing:border-box}.scalar-client .box-content{box-sizing:content-box}.scalar-client .line-clamp-1{overflow:hidden;display:-webkit-box;-webkit-box-orient:vertical;-webkit-line-clamp:1}.scalar-client .\\!block{display:block!important}.scalar-client .block{display:block}.scalar-client .inline-block{display:inline-block}.scalar-client .\\!flex{display:flex!important}.scalar-client .flex{display:flex}.scalar-client .inline-flex{display:inline-flex}.scalar-client .table{display:table}.scalar-client .grid{display:grid}.scalar-client .contents{display:contents}.scalar-client .hidden{display:none}.scalar-client .aspect-\\[4\\/3\\]{aspect-ratio:4/3}.scalar-client .aspect-square{aspect-ratio:1 / 1}.scalar-client .size-10{width:40px;height:40px}.scalar-client .size-2{width:8px;height:8px}.scalar-client .size-2\\.5{width:10px;height:10px}.scalar-client .size-3{width:12px;height:12px}.scalar-client .size-3\\.5{width:14px;height:14px}.scalar-client .size-3\\/4{width:75%;height:75%}.scalar-client .size-4{width:16px;height:16px}.scalar-client .size-5{width:20px;height:20px}.scalar-client .size-7{width:28px;height:28px}.scalar-client .size-8{width:32px;height:32px}.scalar-client .h-1{height:4px}.scalar-client .h-1\\.5{height:6px}.scalar-client .h-10{height:40px}.scalar-client .h-12{height:48px}.scalar-client .h-2{height:8px}.scalar-client .h-2\\.5{height:10px}.scalar-client .h-3{height:12px}.scalar-client .h-3\\.5{height:14px}.scalar-client .h-4{height:16px}.scalar-client .h-5{height:20px}.scalar-client .h-6{height:24px}.scalar-client .h-64{height:256px}.scalar-client .h-7{height:28px}.scalar-client .h-8{height:32px}.scalar-client .h-9{height:36px}.scalar-client .h-\\[--scalar-address-bar-height\\]{height:var(--scalar-address-bar-height)}.scalar-client .h-\\[68px\\]{height:68px}.scalar-client .h-\\[calc\\(100\\%-273\\.5px\\)\\]{height:calc(100% - 273.5px)}.scalar-client .h-\\[calc\\(100\\%_-_50px\\)\\]{height:calc(100% - 50px)}.scalar-client .h-auto{height:auto}.scalar-client .h-fit{height:-moz-fit-content;height:fit-content}.scalar-client .h-full{height:100%}.scalar-client .h-header{height:48px}.scalar-client .h-px{height:1px}.scalar-client .h-screen{height:100vh}.scalar-client .\\!max-h-\\[initial\\]{max-height:initial!important}.scalar-client .max-h-40{max-height:160px}.scalar-client .max-h-8{max-height:32px}.scalar-client .max-h-\\[40dvh\\]{max-height:40dvh}.scalar-client .max-h-\\[50dvh\\]{max-height:50dvh}.scalar-client .max-h-\\[60svh\\]{max-height:60svh}.scalar-client .max-h-\\[calc\\(100\\%-32px\\)\\]{max-height:calc(100% - 32px)}.scalar-client .max-h-\\[inherit\\]{max-height:inherit}.scalar-client .max-h-fit{max-height:-moz-fit-content;max-height:fit-content}.scalar-client .max-h-screen{max-height:100vh}.scalar-client .min-h-0{min-height:0px}.scalar-client .min-h-10{min-height:40px}.scalar-client .min-h-11{min-height:44px}.scalar-client .min-h-12{min-height:48px}.scalar-client .min-h-16{min-height:64px}.scalar-client .min-h-20{min-height:80px}.scalar-client .min-h-8{min-height:32px}.scalar-client .min-h-\\[65px\\]{min-height:65px}.scalar-client .min-h-\\[calc\\(1rem\\*4\\)\\]{min-height:4rem}.scalar-client .min-h-\\[calc\\(4rem\\+1px\\)\\]{min-height:calc(4rem + 1px)}.scalar-client .min-h-fit{min-height:-moz-fit-content;min-height:fit-content}.scalar-client .\\!w-fit{width:-moz-fit-content!important;width:fit-content!important}.scalar-client .w-0{width:0px}.scalar-client .w-0\\.5{width:2px}.scalar-client .w-1{width:4px}.scalar-client .w-1\\.5{width:6px}.scalar-client .w-1\\/2{width:50%}.scalar-client .w-10{width:40px}.scalar-client .w-2{width:8px}.scalar-client .w-2\\.5{width:10px}.scalar-client .w-20{width:80px}.scalar-client .w-3{width:12px}.scalar-client .w-3\\.5{width:14px}.scalar-client .w-4{width:16px}.scalar-client .w-5{width:20px}.scalar-client .w-56{width:224px}.scalar-client .w-6{width:24px}.scalar-client .w-64{width:256px}.scalar-client .w-7{width:28px}.scalar-client .w-72{width:288px}.scalar-client .w-8{width:32px}.scalar-client .w-\\[60px\\]{width:60px}.scalar-client .w-\\[calc\\(100\\%-10px\\)\\]{width:calc(100% - 10px)}.scalar-client .w-\\[calc\\(100\\%_-_8px\\)\\]{width:calc(100% - 8px)}.scalar-client .w-\\[inherit\\]{width:inherit}.scalar-client .w-auto{width:auto}.scalar-client .w-dvw{width:100dvw}.scalar-client .w-fit{width:-moz-fit-content;width:fit-content}.scalar-client .w-full{width:100%}.scalar-client .w-max{width:-moz-max-content;width:max-content}.scalar-client .min-w-0{min-width:0px}.scalar-client .min-w-2{min-width:8px}.scalar-client .min-w-2\\.5{min-width:10px}.scalar-client .min-w-3{min-width:12px}.scalar-client .min-w-3\\.5{min-width:14px}.scalar-client .min-w-48{min-width:192px}.scalar-client .min-w-8{min-width:32px}.scalar-client .min-w-\\[296px\\]{min-width:296px}.scalar-client .min-w-\\[37px\\]{min-width:37px}.scalar-client .min-w-fit{min-width:-moz-fit-content;min-width:fit-content}.scalar-client .min-w-full{min-width:100%}.scalar-client .max-w-\\[100\\%\\]{max-width:100%}.scalar-client .max-w-\\[14px\\]{max-width:14px}.scalar-client .max-w-\\[150px\\]{max-width:150px}.scalar-client .max-w-\\[320px\\]{max-width:320px}.scalar-client .max-w-\\[37px\\]{max-width:37px}.scalar-client .max-w-\\[380px\\]{max-width:380px}.scalar-client .max-w-\\[420px\\]{max-width:420px}.scalar-client .max-w-\\[720px\\]{max-width:720px}.scalar-client .max-w-\\[calc\\(100dvw-24px\\)\\]{max-width:calc(100dvw - 24px)}.scalar-client .max-w-full{max-width:100%}.scalar-client .flex-1{flex:1 1 0%}.scalar-client .shrink-0{flex-shrink:0}.scalar-client .flex-grow{flex-grow:1}.scalar-client .-translate-x-1\\/2{--tw-translate-x:-50%;transform:translate(var(--tw-translate-x),var(--tw-translate-y)) rotate(var(--tw-rotate)) skew(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y))}.scalar-client .-translate-y-1\\/2{--tw-translate-y:-50%;transform:translate(var(--tw-translate-x),var(--tw-translate-y)) rotate(var(--tw-rotate)) skew(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y))}.scalar-client .translate-x-0{--tw-translate-x:0px;transform:translate(var(--tw-translate-x),var(--tw-translate-y)) rotate(var(--tw-rotate)) skew(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y))}.scalar-client .translate-x-1\\/2{--tw-translate-x:50%;transform:translate(var(--tw-translate-x),var(--tw-translate-y)) rotate(var(--tw-rotate)) skew(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y))}.scalar-client .translate-y-1\\/2{--tw-translate-y:50%;transform:translate(var(--tw-translate-x),var(--tw-translate-y)) rotate(var(--tw-rotate)) skew(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y))}.scalar-client .rotate-90{--tw-rotate:90deg;transform:translate(var(--tw-translate-x),var(--tw-translate-y)) rotate(var(--tw-rotate)) skew(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y))}.scalar-client .scale-75{--tw-scale-x:.75;--tw-scale-y:.75;transform:translate(var(--tw-translate-x),var(--tw-translate-y)) rotate(var(--tw-rotate)) skew(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y))}.scalar-client .transform{transform:translate(var(--tw-translate-x),var(--tw-translate-y)) rotate(var(--tw-rotate)) skew(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y))}.scalar-client .cursor-auto{cursor:auto}.scalar-client .cursor-default{cursor:default}.scalar-client .cursor-help{cursor:help}.scalar-client .cursor-pointer{cursor:pointer}.scalar-client .cursor-text{cursor:text}.scalar-client .select-none{-webkit-user-select:none;-moz-user-select:none;user-select:none}.scalar-client .resize-none{resize:none}.scalar-client .resize{resize:both}.scalar-client .auto-rows-\\[32px\\]{grid-auto-rows:32px}.scalar-client .auto-rows-auto{grid-auto-rows:auto}.scalar-client .grid-cols-2{grid-template-columns:repeat(2,minmax(0,1fr))}.scalar-client .grid-cols-\\[44px\\,1fr\\,repeat\\(3\\,auto\\)\\]{grid-template-columns:44px 1fr repeat(3,auto)}.scalar-client .grid-cols-\\[auto\\,1fr\\]{grid-template-columns:auto 1fr}.scalar-client .grid-cols-\\[repeat\\(auto-fill\\,minmax\\(32px\\,1fr\\)\\)\\]{grid-template-columns:repeat(auto-fill,minmax(32px,1fr))}.scalar-client .flex-row{flex-direction:row}.scalar-client .flex-col{flex-direction:column}.scalar-client .flex-wrap{flex-wrap:wrap}.scalar-client .content-start{align-content:flex-start}.scalar-client .content-between{align-content:space-between}.scalar-client .items-start{align-items:flex-start}.scalar-client .items-end{align-items:flex-end}.scalar-client .items-center{align-items:center}.scalar-client .items-stretch{align-items:stretch}.scalar-client .justify-start{justify-content:flex-start}.scalar-client .justify-end{justify-content:flex-end}.scalar-client .justify-center{justify-content:center}.scalar-client .justify-between{justify-content:space-between}.scalar-client .justify-stretch{justify-content:stretch}.scalar-client .\\!gap-2{gap:8px!important}.scalar-client .gap-0{gap:0px}.scalar-client .gap-0\\.5{gap:2px}.scalar-client .gap-0\\.75{gap:3px}.scalar-client .gap-1{gap:4px}.scalar-client .gap-1\\.5{gap:6px}.scalar-client .gap-1\\/2{gap:.5px}.scalar-client .gap-10{gap:40px}.scalar-client .gap-12{gap:48px}.scalar-client .gap-2{gap:8px}.scalar-client .gap-2\\.5{gap:10px}.scalar-client .gap-3{gap:12px}.scalar-client .gap-4{gap:16px}.scalar-client .gap-6{gap:24px}.scalar-client .gap-8{gap:32px}.scalar-client .gap-\\[1\\.5px\\]{gap:1.5px}.scalar-client .gap-px{gap:1px}.scalar-client .gap-x-2{-moz-column-gap:8px;column-gap:8px}.scalar-client .gap-x-2\\.5{-moz-column-gap:10px;column-gap:10px}.scalar-client .space-x-1>:not([hidden])~:not([hidden]){--tw-space-x-reverse:0;margin-right:calc(4px * var(--tw-space-x-reverse));margin-left:calc(4px * calc(1 - var(--tw-space-x-reverse)))}.scalar-client .divide-y>:not([hidden])~:not([hidden]){--tw-divide-y-reverse:0;border-top-width:calc(var(--scalar-border-width) * calc(1 - var(--tw-divide-y-reverse)));border-bottom-width:calc(var(--scalar-border-width) * var(--tw-divide-y-reverse))}.scalar-client .self-center{align-self:center}.scalar-client .justify-self-end{justify-self:end}.scalar-client .overflow-auto{overflow:auto}.scalar-client .overflow-hidden{overflow:hidden}.scalar-client .overflow-visible{overflow:visible}.scalar-client .overflow-x-auto{overflow-x:auto}.scalar-client .overflow-y-auto{overflow-y:auto}.scalar-client .overflow-y-hidden{overflow-y:hidden}.scalar-client .overscroll-contain{overscroll-behavior:contain}.scalar-client .truncate{overflow:hidden;text-overflow:ellipsis;white-space:nowrap}.scalar-client .text-ellipsis{text-overflow:ellipsis}.scalar-client .whitespace-nowrap{white-space:nowrap}.scalar-client .whitespace-pre{white-space:pre}.scalar-client .whitespace-pre-wrap{white-space:pre-wrap}.scalar-client .text-balance{text-wrap:balance}.scalar-client .text-pretty{text-wrap:pretty}.scalar-client .break-words{overflow-wrap:break-word}.scalar-client .break-all{word-break:break-all}.scalar-client .\\!rounded-none{border-radius:0!important}.scalar-client .rounded{border-radius:var(--scalar-radius)}.scalar-client .rounded-\\[10px\\]{border-radius:10px}.scalar-client .rounded-full{border-radius:9999px}.scalar-client .rounded-lg{border-radius:var(--scalar-radius-lg)}.scalar-client .rounded-md{border-radius:var(--scalar-radius)}.scalar-client .rounded-px{border-radius:1px}.scalar-client .rounded-xl{border-radius:var(--scalar-radius-xl)}.scalar-client .rounded-b{border-bottom-right-radius:var(--scalar-radius);border-bottom-left-radius:var(--scalar-radius)}.scalar-client .rounded-b-lg{border-bottom-right-radius:var(--scalar-radius-lg);border-bottom-left-radius:var(--scalar-radius-lg)}.scalar-client .rounded-t{border-top-left-radius:var(--scalar-radius);border-top-right-radius:var(--scalar-radius)}.scalar-client .rounded-t-lg{border-top-left-radius:var(--scalar-radius-lg);border-top-right-radius:var(--scalar-radius-lg)}.scalar-client .rounded-t-none{border-top-left-radius:0;border-top-right-radius:0}.scalar-client .\\!border-0{border-width:0!important}.scalar-client .border{border-width:var(--scalar-border-width)}.scalar-client .border-0{border-width:0}.scalar-client .border-1\\/2{border-width:calc(var(--scalar-border-width) / 2)}.scalar-client .border-\\[1\\.5px\\]{border-width:1.5px}.scalar-client .border-\\[1px\\]{border-width:1px}.scalar-client .border-y{border-top-width:var(--scalar-border-width);border-bottom-width:var(--scalar-border-width)}.scalar-client .\\!border-r-1\\/2{border-right-width:calc(var(--scalar-border-width) / 2)!important}.scalar-client .border-b{border-bottom-width:var(--scalar-border-width)}.scalar-client .border-b-0{border-bottom-width:0}.scalar-client .border-b-1\\/2{border-bottom-width:calc(var(--scalar-border-width) / 2)}.scalar-client .border-b-\\[1px\\]{border-bottom-width:1px}.scalar-client .border-l{border-left-width:var(--scalar-border-width)}.scalar-client .border-l-0{border-left-width:0}.scalar-client .border-r{border-right-width:var(--scalar-border-width)}.scalar-client .border-r-0{border-right-width:0}.scalar-client .border-r-1\\/2{border-right-width:calc(var(--scalar-border-width) / 2)}.scalar-client .border-t{border-top-width:var(--scalar-border-width)}.scalar-client .border-t-0{border-top-width:0}.scalar-client .border-t-1\\/2{border-top-width:calc(var(--scalar-border-width) / 2)}.scalar-client .border-solid{border-style:solid}.scalar-client .border-dashed{border-style:dashed}.scalar-client .border-none{border-style:none}.scalar-client .\\!border-current{border-color:currentColor!important}.scalar-client .border-b-3{border-color:var(--scalar-background-3)}.scalar-client .border-c-1{border-color:var(--scalar-color-1)}.scalar-client .border-c-3{border-color:var(--scalar-color-3)}.scalar-client .border-transparent{border-color:transparent}.scalar-client .border-r-transparent{border-right-color:transparent}.scalar-client .bg-b-1{background-color:var(--scalar-background-1)}.scalar-client .bg-b-2{background-color:var(--scalar-background-2)}.scalar-client .bg-b-3{background-color:var(--scalar-background-3)}.scalar-client .bg-b-danger{background-color:var(--scalar-background-danger)}.scalar-client .bg-blue{background-color:var(--scalar-color-blue)}.scalar-client .bg-c-2{background-color:var(--scalar-color-2)}.scalar-client .bg-c-3{background-color:var(--scalar-color-3)}.scalar-client .bg-c-accent{background-color:var(--scalar-color-accent)}.scalar-client .bg-current{background-color:currentColor}.scalar-client .bg-green{background-color:var(--scalar-color-green)}.scalar-client .bg-grey{background-color:var(--scalar-color-3)}.scalar-client .bg-orange{background-color:var(--scalar-color-orange)}.scalar-client .bg-purple{background-color:var(--scalar-color-purple)}.scalar-client .bg-red{background-color:var(--scalar-color-red)}.scalar-client .bg-sidebar-active-b{background-color:var(--scalar-sidebar-item-active-background, var(--scalar-background-2))}.scalar-client .bg-yellow{background-color:var(--scalar-color-yellow)}.scalar-client .bg-none{background-image:none}.scalar-client .fill-current{fill:currentColor}.scalar-client .stroke-2{stroke-width:2}.scalar-client .stroke-\\[1\\.5\\]{stroke-width:1.5}.scalar-client .stroke-\\[1\\.75\\]{stroke-width:1.75}.scalar-client .stroke-\\[2\\.25\\]{stroke-width:2.25}.scalar-client .object-contain{-o-object-fit:contain;object-fit:contain}.scalar-client .\\!p-0{padding:0!important}.scalar-client .p-0{padding:0}.scalar-client .p-0\\.5{padding:2px}.scalar-client .p-0\\.75{padding:3px}.scalar-client .p-1{padding:4px}.scalar-client .p-1\\.25{padding:5px}.scalar-client .p-1\\.5{padding:6px}.scalar-client .p-1\\.75{padding:7px}.scalar-client .p-2{padding:8px}.scalar-client .p-3{padding:12px}.scalar-client .p-4{padding:16px}.scalar-client .p-\\[3px\\]{padding:3px}.scalar-client .p-\\[5px\\]{padding:5px}.scalar-client .p-px{padding:1px}.scalar-client .\\!px-3{padding-left:12px!important;padding-right:12px!important}.scalar-client .\\!py-1{padding-top:4px!important;padding-bottom:4px!important}.scalar-client .\\!py-1\\.5{padding-top:6px!important;padding-bottom:6px!important}.scalar-client .px-0{padding-left:0;padding-right:0}.scalar-client .px-0\\.5{padding-left:2px;padding-right:2px}.scalar-client .px-1{padding-left:4px;padding-right:4px}.scalar-client .px-1\\.5{padding-left:6px;padding-right:6px}.scalar-client .px-2{padding-left:8px;padding-right:8px}.scalar-client .px-2\\.5{padding-left:10px;padding-right:10px}.scalar-client .px-3{padding-left:12px;padding-right:12px}.scalar-client .px-4{padding-left:16px;padding-right:16px}.scalar-client .px-5{padding-left:20px;padding-right:20px}.scalar-client .px-6{padding-left:24px;padding-right:24px}.scalar-client .px-8{padding-left:32px;padding-right:32px}.scalar-client .py-0{padding-top:0;padding-bottom:0}.scalar-client .py-0\\.25{padding-top:1px;padding-bottom:1px}.scalar-client .py-0\\.5{padding-top:2px;padding-bottom:2px}.scalar-client .py-0\\.75{padding-top:3px;padding-bottom:3px}.scalar-client .py-1{padding-top:4px;padding-bottom:4px}.scalar-client .py-1\\.25{padding-top:5px;padding-bottom:5px}.scalar-client .py-1\\.5{padding-top:6px;padding-bottom:6px}.scalar-client .py-2{padding-top:8px;padding-bottom:8px}.scalar-client .py-2\\.5{padding-top:10px;padding-bottom:10px}.scalar-client .py-3{padding-top:12px;padding-bottom:12px}.scalar-client .py-5{padding-top:20px;padding-bottom:20px}.scalar-client .py-8{padding-top:32px;padding-bottom:32px}.scalar-client .py-px{padding-top:1px;padding-bottom:1px}.scalar-client .\\!pl-3{padding-left:12px!important}.scalar-client .\\!pt-0{padding-top:0!important}.scalar-client .pb-0{padding-bottom:0}.scalar-client .pb-14{padding-bottom:56px}.scalar-client .pb-2{padding-bottom:8px}.scalar-client .pb-3{padding-bottom:12px}.scalar-client .pb-5{padding-bottom:20px}.scalar-client .pb-6{padding-bottom:24px}.scalar-client .pb-8{padding-bottom:32px}.scalar-client .pb-\\[75px\\]{padding-bottom:75px}.scalar-client .pl-1{padding-left:4px}.scalar-client .pl-1\\.25{padding-left:5px}.scalar-client .pl-1\\.5{padding-left:6px}.scalar-client .pl-2{padding-left:8px}.scalar-client .pl-3{padding-left:12px}.scalar-client .pl-6{padding-left:24px}.scalar-client .pl-8{padding-left:32px}.scalar-client .pl-9{padding-left:36px}.scalar-client .pl-px{padding-left:1px}.scalar-client .pr-0{padding-right:0}.scalar-client .pr-0\\.75{padding-right:3px}.scalar-client .pr-1{padding-right:4px}.scalar-client .pr-1\\.5{padding-right:6px}.scalar-client .pr-12{padding-right:48px}.scalar-client .pr-2{padding-right:8px}.scalar-client .pr-2\\.25{padding-right:9px}.scalar-client .pr-2\\.5{padding-right:10px}.scalar-client .pr-3{padding-right:12px}.scalar-client .pr-4{padding-right:16px}.scalar-client .pr-6{padding-right:24px}.scalar-client .pr-8{padding-right:32px}.scalar-client .pr-\\[26px\\]{padding-right:26px}.scalar-client .pr-px{padding-right:1px}.scalar-client .pt-0{padding-top:0}.scalar-client .pt-2{padding-top:8px}.scalar-client .pt-3{padding-top:12px}.scalar-client .pt-4{padding-top:16px}.scalar-client .pt-6{padding-top:24px}.scalar-client .pt-8{padding-top:32px}.scalar-client .pt-px{padding-top:1px}.scalar-client .text-left{text-align:left}.scalar-client .text-center{text-align:center}.scalar-client .text-right{text-align:right}.scalar-client .font-code{font-family:var(--scalar-font-code)}.scalar-client .font-sans{font-family:var(--scalar-font)}.scalar-client .text-3xs{font-size:var(--scalar-font-size-7)}.scalar-client .text-\\[11px\\]{font-size:11px}.scalar-client .text-\\[21px\\]{font-size:21px}.scalar-client .text-\\[6px\\]{font-size:6px}.scalar-client .text-base{font-size:var(--scalar-font-size-3)}.scalar-client .text-sm{font-size:var(--scalar-font-size-4)}.scalar-client .text-xl{font-size:var(--scalar-font-size-1)}.scalar-client .text-xs{font-size:var(--scalar-font-size-5)}.scalar-client .text-xxs{font-size:var(--scalar-font-size-6)}.scalar-client .font-bold{font-weight:var(--scalar-bold)}.scalar-client .font-medium{font-weight:var(--scalar-semibold)}.scalar-client .font-normal{font-weight:var(--scalar-regular)}.scalar-client .uppercase{text-transform:uppercase}.scalar-client .lowercase{text-transform:lowercase}.scalar-client .capitalize{text-transform:capitalize}.scalar-client .\\!leading-\\[6px\\]{line-height:6px!important}.scalar-client .leading{line-height:1.5}.scalar-client .leading-2{line-height:var(--scalar-line-height-2)}.scalar-client .leading-3{line-height:var(--scalar-line-height-3)}.scalar-client .leading-5{line-height:var(--scalar-line-height-5)}.scalar-client .leading-\\[1\\.44\\]{line-height:1.44}.scalar-client .leading-\\[21px\\]{line-height:21px}.scalar-client .leading-\\[7px\\]{line-height:7px}.scalar-client .leading-\\[normal\\]{line-height:normal}.scalar-client .leading-none{line-height:1}.scalar-client .leading-normal{line-height:1.5}.scalar-client .leading-snug{line-height:1.375}.scalar-client .\\!text-c-1{color:var(--scalar-color-1)!important}.scalar-client .text-b-1{color:var(--scalar-background-1)}.scalar-client .text-blue{color:var(--scalar-color-blue)}.scalar-client .text-border{color:var(--scalar-border-color)}.scalar-client .text-c-1{color:var(--scalar-color-1)}.scalar-client .text-c-2{color:var(--scalar-color-2)}.scalar-client .text-c-3{color:var(--scalar-color-3)}.scalar-client .text-c-btn{color:var(--scalar-button-1-color)}.scalar-client .text-green{color:var(--scalar-color-green)}.scalar-client .text-grey{color:var(--scalar-color-3)}.scalar-client .text-orange{color:var(--scalar-color-orange)}.scalar-client .text-purple{color:var(--scalar-color-purple)}.scalar-client .text-red{color:var(--scalar-color-red)}.scalar-client .text-sidebar-active-c{color:var(--scalar-sidebar-color-active, currentColor)}.scalar-client .text-sidebar-c-2{color:var(--scalar-sidebar-color-2, var(--scalar-color-2))}.scalar-client .text-transparent{color:transparent}.scalar-client .text-yellow{color:var(--scalar-color-yellow)}.scalar-client .underline{text-decoration-line:underline}.scalar-client .no-underline{text-decoration-line:none}.scalar-client .decoration-c-3{text-decoration-color:var(--scalar-color-3)}.scalar-client .underline-offset-2{text-underline-offset:2px}.scalar-client .opacity-0{opacity:0}.scalar-client .opacity-100{opacity:1}.scalar-client .opacity-25{opacity:.25}.scalar-client .opacity-50{opacity:.5}.scalar-client .bg-blend-normal{background-blend-mode:normal}.scalar-client .mix-blend-luminosity{mix-blend-mode:luminosity}.scalar-client .shadow{--tw-shadow:var(--scalar-shadow-1);--tw-shadow-colored:var(--scalar-shadow-1);box-shadow:var(--tw-ring-offset-shadow, 0 0 #0000),var(--tw-ring-shadow, 0 0 #0000),var(--tw-shadow)}.scalar-client .shadow-\\[-8px_0_4px_var\\(--scalar-background-1\\)\\]{--tw-shadow:-8px 0 4px var(--scalar-background-1);--tw-shadow-colored:-8px 0 4px var(--tw-shadow-color);box-shadow:var(--tw-ring-offset-shadow, 0 0 #0000),var(--tw-ring-shadow, 0 0 #0000),var(--tw-shadow)}.scalar-client .shadow-\\[0_-8px_0_8px_var\\(--scalar-background-1\\)\\,0_0_8px_8px_var\\(--scalar-background-1\\)\\]{--tw-shadow:0 -8px 0 8px var(--scalar-background-1),0 0 8px 8px var(--scalar-background-1);--tw-shadow-colored:0 -8px 0 8px var(--tw-shadow-color), 0 0 8px 8px var(--tw-shadow-color);box-shadow:var(--tw-ring-offset-shadow, 0 0 #0000),var(--tw-ring-shadow, 0 0 #0000),var(--tw-shadow)}.scalar-client .shadow-border{--tw-shadow:inset 0 0 0 1px var(--scalar-border-color);--tw-shadow-colored:inset 0 0 0 1px var(--tw-shadow-color);box-shadow:var(--tw-ring-offset-shadow, 0 0 #0000),var(--tw-ring-shadow, 0 0 #0000),var(--tw-shadow)}.scalar-client .shadow-lg{--tw-shadow:var(--scalar-shadow-2);--tw-shadow-colored:var(--scalar-shadow-2);box-shadow:var(--tw-ring-offset-shadow, 0 0 #0000),var(--tw-ring-shadow, 0 0 #0000),var(--tw-shadow)}.scalar-client .shadow-none{--tw-shadow:0 0 #0000;--tw-shadow-colored:0 0 var(--tw-shadow-color);box-shadow:var(--tw-ring-offset-shadow, 0 0 #0000),var(--tw-ring-shadow, 0 0 #0000),var(--tw-shadow)}.scalar-client .shadow-border{--tw-shadow-color:var(--scalar-border-color);--tw-shadow:var(--tw-shadow-colored)}.scalar-client .outline-none{outline:2px solid transparent;outline-offset:2px}.scalar-client .outline{outline-style:solid}.scalar-client .-outline-offset-1{outline-offset:-1px}.scalar-client .outline-offset-2{outline-offset:2px}.scalar-client .blur{--tw-blur:blur(8px);filter:var(--tw-blur) var(--tw-brightness) var(--tw-contrast) var(--tw-grayscale) var(--tw-hue-rotate) var(--tw-invert) var(--tw-saturate) var(--tw-sepia) var(--tw-drop-shadow)}.scalar-client .brightness-\\[\\.9\\]{--tw-brightness:brightness(.9);filter:var(--tw-blur) var(--tw-brightness) var(--tw-contrast) var(--tw-grayscale) var(--tw-hue-rotate) var(--tw-invert) var(--tw-saturate) var(--tw-sepia) var(--tw-drop-shadow)}.scalar-client .brightness-lifted{--tw-brightness:brightness(var(--scalar-lifted-brightness));filter:var(--tw-blur) var(--tw-brightness) var(--tw-contrast) var(--tw-grayscale) var(--tw-hue-rotate) var(--tw-invert) var(--tw-saturate) var(--tw-sepia) var(--tw-drop-shadow)}.scalar-client .filter{filter:var(--tw-blur) var(--tw-brightness) var(--tw-contrast) var(--tw-grayscale) var(--tw-hue-rotate) var(--tw-invert) var(--tw-saturate) var(--tw-sepia) var(--tw-drop-shadow)}.scalar-client .backdrop-filter{-webkit-backdrop-filter:var(--tw-backdrop-blur) var(--tw-backdrop-brightness) var(--tw-backdrop-contrast) var(--tw-backdrop-grayscale) var(--tw-backdrop-hue-rotate) var(--tw-backdrop-invert) var(--tw-backdrop-opacity) var(--tw-backdrop-saturate) var(--tw-backdrop-sepia);backdrop-filter:var(--tw-backdrop-blur) var(--tw-backdrop-brightness) var(--tw-backdrop-contrast) var(--tw-backdrop-grayscale) var(--tw-backdrop-hue-rotate) var(--tw-backdrop-invert) var(--tw-backdrop-opacity) var(--tw-backdrop-saturate) var(--tw-backdrop-sepia)}.scalar-client .transition{transition-property:color,background-color,border-color,text-decoration-color,fill,stroke,opacity,box-shadow,transform,filter,-webkit-backdrop-filter;transition-property:color,background-color,border-color,text-decoration-color,fill,stroke,opacity,box-shadow,transform,filter,backdrop-filter;transition-property:color,background-color,border-color,text-decoration-color,fill,stroke,opacity,box-shadow,transform,filter,backdrop-filter,-webkit-backdrop-filter;transition-timing-function:cubic-bezier(.4,0,.2,1);transition-duration:.15s}.scalar-client .transition-colors{transition-property:color,background-color,border-color,text-decoration-color,fill,stroke;transition-timing-function:cubic-bezier(.4,0,.2,1);transition-duration:.15s}.scalar-client .transition-none{transition-property:none}.scalar-client .transition-opacity{transition-property:opacity;transition-timing-function:cubic-bezier(.4,0,.2,1);transition-duration:.15s}.scalar-client .transition-transform{transition-property:transform;transition-timing-function:cubic-bezier(.4,0,.2,1);transition-duration:.15s}.scalar-client .duration-150{transition-duration:.15s}.scalar-client .duration-200{transition-duration:.2s}.scalar-client .duration-300{transition-duration:.3s}.scalar-client .ease-in-out{transition-timing-function:cubic-bezier(.4,0,.2,1)}.scalar-client .bg-mix-transparent{background-color:color-mix(var(--tw-bg-mix-method, in srgb),transparent calc(var(--tw-bg-mix-amount, 0) * 1%),var(--tw-bg-base))}.scalar-client .bg-mix-amount-90{--tw-bg-mix-amount:90}.scalar-client .bg-mix-amount-95{--tw-bg-mix-amount:95}.scalar-client .bg-b-1{--tw-bg-base:var(--scalar-background-1)}.scalar-client .bg-b-2{--tw-bg-base:var(--scalar-background-2)}.scalar-client .bg-b-3{--tw-bg-base:var(--scalar-background-3)}.scalar-client .bg-b-danger{--tw-bg-base:var(--scalar-background-danger)}.scalar-client .bg-blue{--tw-bg-base:var(--scalar-color-blue)}.scalar-client .bg-c-2{--tw-bg-base:var(--scalar-color-2)}.scalar-client .bg-c-3{--tw-bg-base:var(--scalar-color-3)}.scalar-client .bg-c-accent{--tw-bg-base:var(--scalar-color-accent)}.scalar-client .bg-current{--tw-bg-base:currentColor}.scalar-client .bg-green{--tw-bg-base:var(--scalar-color-green)}.scalar-client .bg-grey{--tw-bg-base:var(--scalar-color-3)}.scalar-client .bg-orange{--tw-bg-base:var(--scalar-color-orange)}.scalar-client .bg-purple{--tw-bg-base:var(--scalar-color-purple)}.scalar-client .bg-red{--tw-bg-base:var(--scalar-color-red)}.scalar-client .bg-sidebar-active-b{--tw-bg-base:var(--scalar-sidebar-item-active-background, var(--scalar-background-2))}.scalar-client .bg-yellow{--tw-bg-base:var(--scalar-color-yellow)}.scalar-client .app-drag-region{-webkit-app-region:drag}.scalar-client .app-no-drag-region{-webkit-app-region:no-drag}.scalar-client .\\[--scalar-address-bar-height\\:32px\\]{--scalar-address-bar-height:32px}.scalar-client .\\[--scalar-small\\:--scalar-font-size-4\\]{--scalar-small:var(--scalar-font-size-4)}.scalar-client .\\*\\:flex>*{display:flex}.scalar-client .\\*\\:h-8>*{height:32px}.scalar-client .\\*\\:cursor-pointer>*{cursor:pointer}.scalar-client .\\*\\:items-center>*{align-items:center}.scalar-client .\\*\\:rounded-none>*{border-radius:0}.scalar-client .\\*\\:border-b-0>*{border-bottom-width:0}.scalar-client .\\*\\:border-t-1\\/2>*{border-top-width:calc(var(--scalar-border-width) / 2)}.scalar-client .\\*\\:px-1>*{padding-left:4px;padding-right:4px}.scalar-client .\\*\\:px-1\\.5>*{padding-left:6px;padding-right:6px}.scalar-client .\\*\\:pl-4>*{padding-left:16px}.scalar-client .before\\:pointer-events-none:before{content:var(--tw-content);pointer-events:none}.scalar-client .before\\:absolute:before{content:var(--tw-content);position:absolute}.scalar-client .before\\:left-3:before{content:var(--tw-content);left:12px}.scalar-client .before\\:left-\\[calc\\(\\.75rem_\\+_\\.5px\\)\\]:before{content:var(--tw-content);left:calc(.75rem + .5px)}.scalar-client .before\\:right-\\[23px\\]:before{content:var(--tw-content);right:23px}.scalar-client .before\\:top-0:before{content:var(--tw-content);top:0}.scalar-client .before\\:top-0\\.5:before{content:var(--tw-content);top:2px}.scalar-client .before\\:z-1:before{content:var(--tw-content);z-index:1}.scalar-client .before\\:h-\\[calc\\(100\\%_\\+_\\.5px\\)\\]:before{content:var(--tw-content);height:calc(100% + .5px)}.scalar-client .before\\:min-h-\\[calc\\(100\\%-4px\\)\\]:before{content:var(--tw-content);min-height:calc(100% - 4px)}.scalar-client .before\\:w-3:before{content:var(--tw-content);width:12px}.scalar-client .before\\:w-\\[\\.5px\\]:before{content:var(--tw-content);width:.5px}.scalar-client .before\\:bg-border:before{content:var(--tw-content);background-color:var(--scalar-border-color)}.scalar-client .before\\:bg-gradient-to-r:before{content:var(--tw-content);background-image:linear-gradient(to right,var(--tw-gradient-stops))}.scalar-client .before\\:from-transparent:before{content:var(--tw-content);--tw-gradient-from:transparent var(--tw-gradient-from-position);--tw-gradient-to:rgb(0 0 0 / 0) var(--tw-gradient-to-position);--tw-gradient-stops:var(--tw-gradient-from), var(--tw-gradient-to)}.scalar-client .before\\:to-b-1:before{content:var(--tw-content);--tw-gradient-to:var(--scalar-background-1) var(--tw-gradient-to-position)}.scalar-client .before\\:content-\\[\\'\\'\\]:before{--tw-content:\"\";content:var(--tw-content)}.scalar-client .before\\:bg-border:before{content:var(--tw-content);--tw-bg-base:var(--scalar-border-color)}.scalar-client .after\\:content-\\[\\'\\:\\'\\]:after{--tw-content:\":\";content:var(--tw-content)}.scalar-client .first\\:\\*\\:rounded-l>*:first-child{border-top-left-radius:var(--scalar-radius);border-bottom-left-radius:var(--scalar-radius)}.scalar-client .first\\:\\*\\:border-t-0>*:first-child{border-top-width:0}.scalar-client .last\\:mb-0:last-child{margin-bottom:0}.scalar-client .last\\:border-r-0:last-child{border-right-width:0}.scalar-client .last\\:\\*\\:rounded-r>*:last-child{border-top-right-radius:var(--scalar-radius);border-bottom-right-radius:var(--scalar-radius)}.scalar-client .last\\:before\\:h-full:last-child:before{content:var(--tw-content);height:100%}.scalar-client .first-of-type\\:last-of-type\\:border-b-0:last-of-type:first-of-type{border-bottom-width:0}.scalar-client .focus-within\\:z-20:focus-within{z-index:20}.scalar-client .focus-within\\:border-b-3:focus-within{border-color:var(--scalar-background-3)}.scalar-client .focus-within\\:bg-b-1:focus-within{background-color:var(--scalar-background-1)}.scalar-client .focus-within\\:text-c-1:focus-within{color:var(--scalar-color-1)}.scalar-client .focus-within\\:bg-b-1:focus-within{--tw-bg-base:var(--scalar-background-1)}.scalar-client .hover\\:cursor-default:hover{cursor:default}.scalar-client .hover\\:border-b-3:hover{border-color:var(--scalar-background-3)}.scalar-client .hover\\:border-inherit:hover{border-color:inherit}.scalar-client .hover\\:bg-b-2:hover{background-color:var(--scalar-background-2)}.scalar-client .hover\\:bg-b-3:hover{background-color:var(--scalar-background-3)}.scalar-client .hover\\:bg-inherit:hover{background-color:inherit}.scalar-client .hover\\:bg-sidebar-active-b:hover{background-color:var(--scalar-sidebar-item-active-background, var(--scalar-background-2))}.scalar-client .hover\\:text-c-1:hover{color:var(--scalar-color-1)}.scalar-client .hover\\:text-c-2:hover{color:var(--scalar-color-2)}.scalar-client .hover\\:underline:hover{text-decoration-line:underline}.scalar-client .hover\\:bg-b-2:hover{--tw-bg-base:var(--scalar-background-2)}.scalar-client .hover\\:bg-b-3:hover{--tw-bg-base:var(--scalar-background-3)}.scalar-client .hover\\:bg-inherit:hover{--tw-bg-base:inherit}.scalar-client .hover\\:bg-sidebar-active-b:hover{--tw-bg-base:var(--scalar-sidebar-item-active-background, var(--scalar-background-2))}.scalar-client .focus\\:text-c-1:focus{color:var(--scalar-color-1)}.scalar-client .focus\\:outline-none:focus{outline:2px solid transparent;outline-offset:2px}.scalar-client .focus-visible\\:z-10:focus-visible{z-index:10}.scalar-client .active\\:text-c-1:active{color:var(--scalar-color-1)}.scalar-client .disabled\\:cursor-default:disabled{cursor:default}.scalar-client .disabled\\:text-c-2:disabled{color:var(--scalar-color-2)}.scalar-client .group\\/row:first-child .group-first\\/row\\:border-t-0{border-top-width:0}.scalar-client .group\\/label:last-child .group-last\\/label\\:rounded-br-lg{border-bottom-right-radius:var(--scalar-radius-lg)}.scalar-client .group:last-child .group-last\\:border-b-transparent{border-bottom-color:transparent}.scalar-client .group\\/upload:hover .group-hover\\/upload\\:block,.scalar-client .group:hover .group-hover\\:block{display:block}.scalar-client .group:hover .group-hover\\:inline{display:inline}.scalar-client .group\\/item:hover .group-hover\\/item\\:flex,.scalar-client .group:hover .group-hover\\:flex{display:flex}.scalar-client .group:hover .group-hover\\:hidden{display:none}.scalar-client .group:hover .group-hover\\:pr-5{padding-right:20px}.scalar-client .group\\/info:hover .group-hover\\/info\\:text-c-1{color:var(--scalar-color-1)}.scalar-client .group\\/scopes-accordion:hover .group-hover\\/scopes-accordion\\:text-c-2{color:var(--scalar-color-2)}.scalar-client .group:hover .group-hover\\:text-c-1{color:var(--scalar-color-1)}.scalar-client .group\\/cell:hover .group-hover\\/cell\\:opacity-100,.scalar-client .group\\/params:hover .group-hover\\/params\\:opacity-100,.scalar-client .group:hover .group-hover\\:opacity-100{opacity:1}.scalar-client .group:hover .group-hover\\:opacity-80{opacity:.8}.scalar-client .group:focus-visible .group-focus-visible\\:opacity-100{opacity:1}.scalar-client .group:focus-visible .group-focus-visible\\:outline{outline-style:solid}.scalar-client .group.alert .group-\\[\\.alert\\]\\:bg-b-alert{background-color:var(--scalar-background-alert)}.scalar-client .group.alert .group-\\[\\.alert\\]\\:bg-transparent{background-color:transparent}.scalar-client .group.error .group-\\[\\.error\\]\\:bg-b-danger{background-color:var(--scalar-background-danger)}.scalar-client .group.error .group-\\[\\.error\\]\\:bg-transparent{background-color:transparent}.scalar-client .group.error .group-\\[\\.error\\]\\:text-red{color:var(--scalar-color-red)}.scalar-client .group.alert .group-\\[\\.alert\\]\\:shadow-none,.scalar-client .group.error .group-\\[\\.error\\]\\:shadow-none{--tw-shadow:0 0 #0000;--tw-shadow-colored:0 0 var(--tw-shadow-color);box-shadow:var(--tw-ring-offset-shadow, 0 0 #0000),var(--tw-ring-shadow, 0 0 #0000),var(--tw-shadow)}.scalar-client .group.alert .group-\\[\\.alert\\]\\:outline-orange{outline-color:var(--scalar-color-orange)}.scalar-client .group.error .group-\\[\\.error\\]\\:outline-red{outline-color:var(--scalar-color-red)}.scalar-client .group.alert .group-\\[\\.alert\\]\\:bg-b-alert{--tw-bg-base:var(--scalar-background-alert)}.scalar-client .group.alert .group-\\[\\.alert\\]\\:bg-transparent{--tw-bg-base:transparent}.scalar-client .group.error .group-\\[\\.error\\]\\:bg-b-danger{--tw-bg-base:var(--scalar-background-danger)}.scalar-client .group.error .group-\\[\\.error\\]\\:bg-transparent{--tw-bg-base:transparent}.scalar-client .group.alert .group-\\[\\.alert\\]\\:before\\:to-b-alert:before{content:var(--tw-content);--tw-gradient-to:var(--scalar-background-alert) var(--tw-gradient-to-position)}.scalar-client .group.error .group-\\[\\.error\\]\\:before\\:to-b-danger:before{content:var(--tw-content);--tw-gradient-to:var(--scalar-background-danger) var(--tw-gradient-to-position)}.scalar-client .peer:checked~.peer-checked\\:text-c-1{color:var(--scalar-color-1)}.scalar-client .has-\\[\\:focus-visible\\]\\:rounded-\\[4px\\]:has(:focus-visible){border-radius:4px}.scalar-client .has-\\[\\.empty-sidebar-item\\]\\:border-t-1\\/2:has(.empty-sidebar-item){border-top-width:calc(var(--scalar-border-width) / 2)}.scalar-client .has-\\[\\:focus-visible\\]\\:bg-b-1:has(:focus-visible){background-color:var(--scalar-background-1)}.scalar-client .has-\\[\\:focus-visible\\]\\:opacity-100:has(:focus-visible){opacity:1}.scalar-client .has-\\[\\:focus-visible\\]\\:outline:has(:focus-visible){outline-style:solid}.scalar-client .has-\\[\\:focus-visible\\]\\:bg-b-1:has(:focus-visible){--tw-bg-base:var(--scalar-background-1)}.scalar-client .group\\/label:has(input) .group-has-\\[input\\]\\/label\\:mr-0{margin-right:0}.scalar-client .group\\/input:has(:focus-visible) .group-has-\\[\\:focus-visible\\]\\/input\\:block{display:block}.scalar-client .group:has(:focus-visible) .group-has-\\[\\:focus-visible\\]\\:hidden{display:none}.scalar-client .group\\/cell:has(:focus-visible) .group-has-\\[\\:focus-visible\\]\\/cell\\:border-c-accent{border-color:var(--scalar-color-accent)}.scalar-client .group\\/cell:has(:focus-visible) .group-has-\\[\\:focus-visible\\]\\/cell\\:opacity-100{opacity:1}.scalar-client .group:has(:focus-visible) .group-has-\\[\\:focus-visible\\]\\:opacity-100{opacity:1}.scalar-client .peer:has(.color-selector)~.peer-has-\\[\\.color-selector\\]\\:hidden{display:none}.scalar-client .peer:has(.cm-focused)~.peer-has-\\[\\.cm-focused\\]\\:opacity-0{opacity:0}.scalar-client .ui-open\\:rotate-90[data-headlessui-state~=open]{--tw-rotate:90deg;transform:translate(var(--tw-translate-x),var(--tw-translate-y)) rotate(var(--tw-rotate)) skew(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y))}.scalar-client :where([data-headlessui-state~=open]) .ui-open\\:rotate-90{--tw-rotate:90deg;transform:translate(var(--tw-translate-x),var(--tw-translate-y)) rotate(var(--tw-rotate)) skew(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y))}.scalar-client .ui-not-open\\:invisible[data-headlessui-state]:not([data-headlessui-state~=open]){visibility:hidden}.scalar-client .ui-not-open\\:rotate-0[data-headlessui-state]:not([data-headlessui-state~=open]){--tw-rotate:0deg;transform:translate(var(--tw-translate-x),var(--tw-translate-y)) rotate(var(--tw-rotate)) skew(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y))}.scalar-client :where([data-headlessui-state]:not([data-headlessui-state~=open])) .ui-not-open\\:invisible:not([data-headlessui-state]){visibility:hidden}.scalar-client :where([data-headlessui-state]:not([data-headlessui-state~=open])) .ui-not-open\\:rotate-0:not([data-headlessui-state]){--tw-rotate:0deg;transform:translate(var(--tw-translate-x),var(--tw-translate-y)) rotate(var(--tw-rotate)) skew(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y))}.scalar-client .ui-checked\\:bg-b-3[data-headlessui-state~=checked]{background-color:var(--scalar-background-3);--tw-bg-base:var(--scalar-background-3)}.scalar-client :where([data-headlessui-state~=checked]) .ui-checked\\:bg-b-3{background-color:var(--scalar-background-3);--tw-bg-base:var(--scalar-background-3)}.scalar-client .ui-active\\:bg-b-2[data-headlessui-state~=active]{background-color:var(--scalar-background-2);--tw-bg-base:var(--scalar-background-2)}.scalar-client .\\*\\:ui-active\\:bg-b-2[data-headlessui-state~=active]>*{background-color:var(--scalar-background-2);--tw-bg-base:var(--scalar-background-2)}.scalar-client :where([data-headlessui-state~=active]) .ui-active\\:bg-b-2{background-color:var(--scalar-background-2);--tw-bg-base:var(--scalar-background-2)}.scalar-client :where([data-headlessui-state~=active]) .\\*\\:ui-active\\:bg-b-2>*{background-color:var(--scalar-background-2);--tw-bg-base:var(--scalar-background-2)}.scalar-client .app-platform-desktop .desktop\\:rounded-lg{border-radius:var(--scalar-radius-lg)}.scalar-client .app-platform-mac .mac\\:hidden{display:none}.scalar-client .app-platform-mac .mac\\:pl-\\[72px\\]{padding-left:72px}@media (min-width: 600px){.scalar-client .sm\\:not-sr-only{position:static;width:auto;height:auto;padding:0;margin:0;overflow:visible;clip:auto;white-space:normal}.scalar-client .sm\\:order-none{order:0}.scalar-client .sm\\:mb-1{margin-bottom:4px}.scalar-client .sm\\:mb-1\\.5{margin-bottom:6px}.scalar-client .sm\\:ml-1{margin-left:4px}.scalar-client .sm\\:ml-1\\.5{margin-left:6px}.scalar-client .sm\\:mr-1{margin-right:4px}.scalar-client .sm\\:mr-1\\.5{margin-right:6px}.scalar-client .sm\\:flex{display:flex}.scalar-client .sm\\:hidden{display:none}.scalar-client .sm\\:min-w-max{min-width:-moz-max-content;min-width:max-content}.scalar-client .sm\\:max-w-max{max-width:-moz-max-content;max-width:max-content}.scalar-client .sm\\:flex-row{flex-direction:row}.scalar-client .sm\\:flex-col{flex-direction:column}.scalar-client .sm\\:justify-between{justify-content:space-between}.scalar-client .sm\\:gap-px{gap:1px}.scalar-client .sm\\:rounded{border-radius:var(--scalar-radius)}.scalar-client .sm\\:rounded-lg{border-radius:var(--scalar-radius-lg)}.scalar-client .sm\\:px-2{padding-left:8px;padding-right:8px}.scalar-client .sm\\:px-3{padding-left:12px;padding-right:12px}.scalar-client .sm\\:py-1{padding-top:4px;padding-bottom:4px}.scalar-client .sm\\:py-1\\.5{padding-top:6px;padding-bottom:6px}.scalar-client .sm\\:\\*\\:rounded-lg>*{border-radius:var(--scalar-radius-lg)}}@media (min-width: 800px){.scalar-client .md\\:bottom-10{bottom:40px}.scalar-client .md\\:right-10{right:40px}.scalar-client .md\\:mx-auto{margin-left:auto;margin-right:auto}.scalar-client .md\\:-ml-1{margin-left:-4px}.scalar-client .md\\:-ml-1\\.25{margin-left:-5px}.scalar-client .md\\:ml-1{margin-left:4px}.scalar-client .md\\:ml-1\\.5{margin-left:6px}.scalar-client .md\\:block{display:block}.scalar-client .md\\:grid{display:grid}.scalar-client .md\\:w-full{width:100%}.scalar-client .md\\:min-w-fit{min-width:-moz-fit-content;min-width:fit-content}.scalar-client .md\\:max-w-\\[720px\\]{max-width:720px}.scalar-client .md\\:flex-none{flex:none}.scalar-client .md\\:translate-x-0{--tw-translate-x:0px;transform:translate(var(--tw-translate-x),var(--tw-translate-y)) rotate(var(--tw-rotate)) skew(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y))}.scalar-client .md\\:translate-y-0{--tw-translate-y:0px;transform:translate(var(--tw-translate-x),var(--tw-translate-y)) rotate(var(--tw-rotate)) skew(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y))}.scalar-client .md\\:grid-cols-\\[1fr_720px_1fr\\]{grid-template-columns:1fr 720px 1fr}.scalar-client .md\\:flex-row{flex-direction:row}.scalar-client .md\\:border-b-0{border-bottom-width:0}.scalar-client .md\\:border-r-1\\/2{border-right-width:calc(var(--scalar-border-width) / 2)}.scalar-client .md\\:p-1{padding:4px}.scalar-client .md\\:p-1\\.5{padding:6px}.scalar-client .md\\:px-0{padding-left:0;padding-right:0}.scalar-client .md\\:px-1{padding-left:4px;padding-right:4px}.scalar-client .md\\:px-1\\.5{padding-left:6px;padding-right:6px}.scalar-client .md\\:px-2{padding-left:8px;padding-right:8px}.scalar-client .md\\:px-2\\.5{padding-left:10px;padding-right:10px}.scalar-client .md\\:px-4{padding-left:16px;padding-right:16px}.scalar-client .md\\:px-\\[18px\\]{padding-left:18px;padding-right:18px}.scalar-client .md\\:py-2{padding-top:8px;padding-bottom:8px}.scalar-client .md\\:py-2\\.5{padding-top:10px;padding-bottom:10px}.scalar-client .md\\:pb-2{padding-bottom:8px}.scalar-client .md\\:pb-2\\.5{padding-bottom:10px}.scalar-client .md\\:pb-\\[37px\\]{padding-bottom:37px}.scalar-client .md\\:pl-0{padding-left:0}.scalar-client .md\\:\\*\\:border-t-0>*{border-top-width:0}}@media (min-width: 1000px){.scalar-client .lg\\:order-none{order:0}.scalar-client .lg\\:-mr-1{margin-right:-4px}.scalar-client .lg\\:mb-0{margin-bottom:0}.scalar-client .lg\\:flex{display:flex}.scalar-client .lg\\:min-h-client-header{min-height:48px}.scalar-client .lg\\:w-auto{width:auto}.scalar-client .lg\\:min-w-\\[580px\\]{min-width:580px}.scalar-client .lg\\:max-w-\\[580px\\]{max-width:580px}.scalar-client .lg\\:flex-1{flex:1 1 0%}.scalar-client .lg\\:p-1{padding:4px}.scalar-client .lg\\:px-1{padding-left:4px;padding-right:4px}.scalar-client .lg\\:px-2{padding-left:8px;padding-right:8px}.scalar-client .lg\\:px-2\\.5{padding-left:10px;padding-right:10px}.scalar-client .lg\\:pr-24{padding-right:96px}.scalar-client .lg\\:pt-1{padding-top:4px}.scalar-client .lg\\:text-sm{font-size:var(--scalar-font-size-4)}}@media (min-width: 1200px){.scalar-client .xl\\:\\!flex{display:flex!important}.scalar-client .xl\\:flex{display:flex}.scalar-client .xl\\:hidden{display:none}.scalar-client .xl\\:h-fit{height:-moz-fit-content;height:fit-content}.scalar-client .xl\\:h-full{height:100%}.scalar-client .xl\\:min-h-client-header{min-height:48px}.scalar-client .xl\\:min-w-0{min-width:0px}.scalar-client .xl\\:min-w-\\[720px\\]{min-width:720px}.scalar-client .xl\\:max-w-\\[720px\\]{max-width:720px}.scalar-client .xl\\:flex-row{flex-direction:row}.scalar-client .xl\\:overflow-auto{overflow:auto}.scalar-client .xl\\:overflow-hidden{overflow:hidden}.scalar-client .xl\\:rounded-none{border-radius:0}.scalar-client .xl\\:pl-2{padding-left:8px}.scalar-client .xl\\:pr-0{padding-right:0}.scalar-client .xl\\:pr-0\\.5{padding-right:2px}.scalar-client .xl\\:\\*\\:border-l-1\\/2>*{border-left-width:calc(var(--scalar-border-width) / 2)}.scalar-client .xl\\:\\*\\:border-t-0>*{border-top-width:0}.scalar-client .xl\\:first\\:\\*\\:border-l-0>*:first-child{border-left-width:0}}@media (max-width: 720px) and (max-height: 480px){.scalar-client .zoomed\\:static{position:static}.scalar-client .zoomed\\:p-1{padding:4px}}.scalar-client .dark\\:bg-b-2:where(.dark-mode,.dark-mode *){background-color:var(--scalar-background-2);--tw-bg-base:var(--scalar-background-2)}.scalar-client .dark\\:hover\\:bg-b-2:hover:where(.dark-mode,.dark-mode *){background-color:var(--scalar-background-2);--tw-bg-base:var(--scalar-background-2)}.scalar-client .\\[\\&\\>a\\]\\:pl-5>a{padding-left:20px}html,body{background-color:var(--scalar-background-1);overscroll-behavior:none}#scalar-client{display:flex;flex-direction:column;height:100dvh;width:100dvw;position:relative;background-color:var(--scalar-background-2)}.dark-mode #scalar-client{background-color:color-mix(in srgb,var(--scalar-background-1) 65%,black)}.open-api-client-button[data-v-e913a538]{cursor:pointer;width:100%;padding:9px 12px;height:31px;display:block;text-align:center;display:flex;align-items:center;justify-content:center;white-space:nowrap;font-size:var(--scalar-mini);font-weight:var(--scalar-semibold);line-height:1.385;text-decoration:none;border-radius:var(--scalar-radius);box-shadow:0 0 0 .5px var(--scalar-border-color);gap:6px;color:var(--scalar-sidebar-color-1)}.open-api-client-button[data-v-e913a538]:hover{background:var( --scalar-sidebar-item-hover-background, var(--scalar-background-2) )}.address-bar-history-button[data-v-4e70a4a7]:hover{background:var(--scalar-background-3)}.address-bar-history-button[data-v-4e70a4a7]:focus-within{background:var(--scalar-background-2)}.description[data-v-e86ebacd] .markdown{font-weight:var(--scalar-semibold);color:var(--scalar-color--1);padding:0;display:block}.description[data-v-e86ebacd] .markdown>*:first-child{margin-top:0}[data-v-37854d17] .cm-editor{height:100%;outline:none;width:100%}[data-v-37854d17] .cm-line{padding:0}[data-v-37854d17] .cm-content{padding:0;display:flex;align-items:center;font-size:var(--scalar-mini)}.scroll-timeline-x[data-v-37854d17]{scroll-timeline:--scroll-timeline x;scroll-timeline:--scroll-timeline horizontal;-ms-overflow-style:none}.scroll-timeline-x-hidden[data-v-37854d17]{overflow-x:auto}.scroll-timeline-x-hidden[data-v-37854d17] .cm-scroller{scrollbar-width:none;-ms-overflow-style:none;padding-right:20px;overflow:auto}.scroll-timeline-x-hidden[data-v-37854d17]::-webkit-scrollbar{width:0;height:0;display:none}.scroll-timeline-x-hidden[data-v-37854d17] .cm-scroller::-webkit-scrollbar{width:0;height:0;display:none}.scroll-timeline-x-address[data-v-37854d17]{line-height:27px;scrollbar-width:none}.scroll-timeline-x-address[data-v-37854d17]:after{content:\"\";position:absolute;height:100%;width:24px;right:0;cursor:text}.scroll-timeline-x-address[data-v-37854d17]:empty:before{content:\"Enter URL or cURL request\";color:var(--scalar-color-3);pointer-events:none}.fade-left[data-v-37854d17],.fade-right[data-v-37854d17]{content:\"\";position:sticky;height:100%;animation-name:fadein-37854d17;animation-duration:1ms;animation-direction:reverse;animation-timeline:--scroll-timeline;pointer-events:none;z-index:1}.fade-left[data-v-37854d17]{background:linear-gradient(-90deg,color-mix(in srgb,var(--scalar-address-bar-bg),transparent 100%) 0%,color-mix(in srgb,var(--scalar-address-bar-bg),transparent 20%) 30%,var(--scalar-address-bar-bg) 100%);left:-1px;min-width:6px;animation-direction:normal}.fade-right[data-v-37854d17]{background:linear-gradient(90deg,color-mix(in srgb,var(--scalar-address-bar-bg),transparent 100%) 0%,color-mix(in srgb,var(--scalar-address-bar-bg),transparent 20%) 30%,var(--scalar-address-bar-bg) 100%);right:-1px;min-width:24px}@keyframes fadein-37854d17{0%{opacity:0}1%{opacity:1}}.address-bar-bg-states[data-v-37854d17]{--scalar-address-bar-bg: color-mix( in srgb, var(--scalar-background-1), var(--scalar-background-2) );background:var(--scalar-address-bar-bg)}.address-bar-bg-states[data-v-37854d17]:has(.cm-focused){--scalar-address-bar-bg: var(--scalar-background-1);border-color:var(--scalar-border-color);outline:1px solid var(--scalar-color-accent)}.address-bar-bg-states:has(.cm-focused) .fade-left[data-v-37854d17],.address-bar-bg-states:has(.cm-focused) .fade-right[data-v-37854d17]{--scalar-address-bar-bg: var(--scalar-background-1)}.sidebar-height[data-v-d9639e58]{min-height:100%}@media (min-width: 800px){.sidebar-mask[data-v-d9639e58]{-webkit-mask-image:linear-gradient(0,transparent 0,transparent 0,var(--scalar-background-2) 30px);mask-image:linear-gradient(0,transparent 0,transparent 0,var(--scalar-background-2) 30px)}}.resizer[data-v-d9639e58]{width:5px;cursor:col-resize;position:absolute;top:0;right:0;bottom:0;border-right:2px solid transparent;transition:border-right-color .3s}.resizer[data-v-d9639e58]:hover,.dragging .resizer[data-v-d9639e58]{border-right-color:var(--scalar-background-3)}.dragging[data-v-d9639e58]{cursor:col-resize}.dragging[data-v-d9639e58]:before{content:\"\";display:block;position:absolute;width:100%;height:100%}.ellipsis-position[data-v-709241c2]{transform:translate3d(calc(-100% - 4.5px),0,0)}.dragover-asChild[data-v-a89d6a6e],.dragover-above[data-v-a89d6a6e],.dragover-below[data-v-a89d6a6e]{position:relative}.dragover-above[data-v-a89d6a6e]:after,.dragover-below[data-v-a89d6a6e]:after{content:\"\";position:absolute;top:-1.5px;height:3px;width:100%;display:block;background:color-mix(in srgb,var(--scalar-color-blue),transparent 85%);pointer-events:none;border-radius:var(--scalar-radius)}.dragover-below[data-v-a89d6a6e]:after{top:initial;bottom:-1.5px}.dragover-asChild[data-v-a89d6a6e]:after{content:\"\";position:absolute;top:0;left:0;width:100%;height:100%;display:block;background:color-mix(in srgb,var(--scalar-color-blue),transparent 85%);pointer-events:none;border-radius:var(--scalar-radius)}.indent-border-line-offset[data-v-5ceed67f]:before{left:var(--57af6a02)}.indent-padding-left[data-v-5ceed67f]{padding-left:calc(var(--6f52565f) + 6px)}.sidebar-folderitem[data-v-5ceed67f] .ellipsis-position{right:6px;transform:none}.search-button-fade[data-v-5a734bd1]{background:linear-gradient(var(--scalar-background-1) 32px,color-mix(in srgb,var(--scalar-background-1),transparent) 38px,transparent)}.empty-sidebar-item-content[data-v-5a734bd1]{display:none}.empty-sidebar-item .empty-sidebar-item-content[data-v-5a734bd1]{display:block}.rabbitjump[data-v-5a734bd1]{opacity:0}.empty-sidebar-item:hover .rabbitjump[data-v-5a734bd1]{opacity:1;animation:rabbitAnimation-5a734bd1 .5s steps(1) infinite}.empty-sidebar-item:hover .rabbitsit[data-v-5a734bd1]{opacity:0;animation:rabbitAnimation2-5a734bd1 .5s steps(1) infinite}.empty-sidebar-item:hover .rabbit-ascii[data-v-5a734bd1]{animation:rabbitRun-5a734bd1 8s infinite linear}@keyframes rabbitRun-5a734bd1{0%{transform:translateZ(0)}25%{transform:translate3d(250px,0,0)}25.01%{transform:translate3d(-250px,0,0)}75%{transform:translate3d(250px,0,0)}75.01%{transform:translate3d(-250px,0,0)}to{transform:translateZ(0)}}@keyframes rabbitAnimation-5a734bd1{0%,to{opacity:1}50%{opacity:0}}@keyframes rabbitAnimation2-5a734bd1{0%,to{opacity:0}50%{opacity:1;transform:translate3d(0,-8px,0)}}.request-text-color-text[data-v-985ee6ae]{color:var(--scalar-color-1);background:linear-gradient(var(--scalar-background-1),var(--scalar-background-3));box-shadow:0 0 0 1px var(--scalar-border-color)}@media screen and (max-width: 800px){.sidebar-active-hide-layout[data-v-985ee6ae]{display:none}.sidebar-active-width[data-v-985ee6ae]{width:100%}}.gitbook-show[data-v-ad3dcf8d]{display:none}.app-exit-button[data-v-ad3dcf8d]{color:#fff;background:#0000001a}.app-exit-button[data-v-ad3dcf8d]:hover{background:#ffffff1a}.request-text-color-text[data-v-d620d52d]{color:var(--scalar-color-1);background:linear-gradient(var(--scalar-background-1),var(--scalar-background-3));box-shadow:0 0 0 1px var(--scalar-border-color)}@media screen and (max-width: 800px){.sidebar-active-hide-layout[data-v-d620d52d]{display:none}.sidebar-active-width[data-v-d620d52d]{width:100%}}.group-hover-input[data-v-fced736a]{border-width:var(--scalar-border-width);border-color:transparent}.group:hover .group-hover-input[data-v-fced736a]{background:color-mix(in srgb,var(--scalar-background-1),var(--scalar-background-2));border-color:var(--scalar-border-color)}.group-hover-input[data-v-fced736a]:focus{background:transparent!important;border-color:var(--scalar-border-color)!important}[data-v-46f80d5f] .markdown h2{font-size:var(--scalar-font-size-2)}[data-v-27b2f04b] .cm-content{min-height:-moz-fit-content;min-height:fit-content}[data-v-27b2f04b] .cm-scroller{max-width:100%;overflow-x:auto;overflow-y:hidden}.scalar-collection-auth[data-v-e76fc233]{border:var(--scalar-border-width) solid var(--scalar-border-color);border-radius:var(--scalar-radius-lg);overflow:hidden}.scalar-button-danger[data-v-e94b489c]{background:color-mix(in srgb,var(--scalar-color-red),transparent 95%);color:var(--scalar-color-red)}.scalar-button-danger[data-v-e94b489c]:hover,.scalar-button-danger[data-v-e94b489c]:focus{background:color-mix(in srgb,var(--scalar-color-red),transparent 90%)}.empty-variable-name[data-v-245380f1]:empty:before{content:\"Untitled\";color:var(--scalar-color-3)}.form-group[data-v-694018d6]{margin-bottom:1rem}.modal-actions[data-v-694018d6]{display:flex;justify-content:flex-end;gap:1rem}:root{--scalar-loaded-api-reference: true}@layer scalar-config{.scalar-api-reference[data-v-e9aedb7d]{--refs-sidebar-width: var(--scalar-sidebar-width, 0px);--refs-header-height: calc( var(--scalar-y-offset) + var(--scalar-header-height, 0px) );--refs-content-max-width: var(--scalar-content-max-width, 1540px)}.scalar-api-reference.references-classic[data-v-e9aedb7d]{--refs-content-max-width: var(--scalar-content-max-width, 1420px);min-height:100dvh;--refs-sidebar-width: 0}}.references-layout[data-v-e9aedb7d]{min-height:100dvh;min-width:100%;max-width:100%;flex:1;--full-height: 100dvh;display:grid;grid-template-rows:var(--scalar-header-height, 0px) repeat(2,auto);grid-template-columns:var(--refs-sidebar-width) 1fr;grid-template-areas:\"header header\" \"navigation rendered\" \"footer footer\";background:var(--scalar-background-1)}.references-header[data-v-e9aedb7d]{grid-area:header;position:sticky;top:var(--scalar-custom-header-height, 0px);z-index:10;height:var(--scalar-header-height, 0px)}.references-editor[data-v-e9aedb7d]{grid-area:editor;display:flex;min-width:0;background:var(--scalar-background-1)}.references-navigation[data-v-e9aedb7d]{grid-area:navigation}.references-rendered[data-v-e9aedb7d]{position:relative;grid-area:rendered;min-width:0;background:var(--scalar-background-1)}.scalar-api-reference.references-classic[data-v-e9aedb7d],.references-classic .references-rendered[data-v-e9aedb7d]{--full-height: fit-content !important;height:initial!important;max-height:initial!important}.references-navigation-list[data-v-e9aedb7d]{position:sticky;top:var(--refs-header-height);height:calc(100dvh - var(--refs-header-height));background:var(--scalar-sidebar-background-1, var(--scalar-background-1));overflow-y:auto;display:flex;flex-direction:column}.references-editor-textarea[data-v-e9aedb7d]{position:sticky;top:var(--refs-header-height);height:calc(var(--full-height) - var(--refs-header-height));display:flex;min-width:0;flex:1}.references-editable[data-v-e9aedb7d]{grid-template-columns:var(--refs-sidebar-width) 1fr 1fr;grid-template-areas:\"header header header\" \"navigation editor rendered\" \"footer footer footer\"}@layer scalar-config{.references-sidebar[data-v-e9aedb7d]{--refs-sidebar-width: var(--scalar-sidebar-width, 280px)}}.references-footer[data-v-e9aedb7d]{grid-area:footer}@media (max-width: 1150px){.references-layout[data-v-e9aedb7d]{grid-template-columns:var(--refs-sidebar-width) 1fr 0px}}@media (max-width: 1000px){.references-layout[data-v-e9aedb7d]{grid-template-columns:auto;grid-template-rows:var(--scalar-header-height, 0px) 0px auto auto;grid-template-areas:\"header\" \"navigation\" \"rendered\" \"footer\"}.references-editable[data-v-e9aedb7d]{grid-template-areas:\"header\" \"navigation\" \"editor\"}.references-navigation[data-v-e9aedb7d],.references-rendered[data-v-e9aedb7d]{max-height:unset}.references-rendered[data-v-e9aedb7d]{position:static}.references-navigation[data-v-e9aedb7d]{display:none;z-index:10}.references-sidebar-mobile-open .references-navigation[data-v-e9aedb7d]{display:block;top:var(--refs-header-height);height:calc(100dvh - var(--refs-header-height));width:100%;position:sticky}.references-navigation-list[data-v-e9aedb7d]{position:absolute;top:-1px;height:calc(var(--full-height) - var(--refs-header-height) + 1px);width:100%;border-top:1px solid var(--scalar-border-color);display:flex;flex-direction:column}}.references-classic-header[data-v-a860f78f]{display:flex;align-items:center;justify-content:space-between;gap:12px;max-width:var(--refs-content-max-width);margin:auto;padding:12px 0}.references-classic-header-container[data-v-a860f78f]{padding:0 60px}@container narrow-references-container (max-width: 900px){.references-classic-header[data-v-a860f78f]{padding:12px 24px}.references-classic-header-container[data-v-a860f78f]{padding:0}}.references-classic-header-icon[data-v-a860f78f]{height:24px;color:var(--scalar-color-1)}a[data-v-05a312ab]{text-decoration:none}.ref-search-container[data-v-05a312ab]{display:flex;flex-direction:column;padding:12px 12px 0}.ref-search-results[data-v-05a312ab]{padding:12px}.ref-search-meta[data-v-05a312ab]{background:var(--scalar-background-3);border-bottom-left-radius:var(--scalar-radius-lg);border-bottom-right-radius:var(--scalar-radius-lg);padding:6px 12px;font-size:var(--scalar-font-size-4);color:var(--scalar-color-3);font-weight:var(--scalar-semibold);display:flex;gap:12px}.deprecated[data-v-05a312ab]{text-decoration:line-through}.sidebar-search[data-v-4c6e9e93]{display:flex;align-items:center;position:relative;padding:0 3px 0 9px;min-width:254px;max-width:100%;font-family:var(--scalar-font);background:var( --scalar-sidebar-search-background, var(--scalar-background-1) );color:var(--scalar-sidebar-color-2, var(--scalar-color-2));border-radius:var(--scalar-radius);border-width:var(--scalar-border-width);border-color:var( --scalar-sidebar-search-border-color, var(--scalar-border-color) );cursor:pointer;-webkit-appearance:none;-moz-appearance:none;appearance:none}.sidebar-search-input[data-v-4c6e9e93]{font-size:var(--scalar-mini);font-weight:var(--scalar-semibold);height:31px;-webkit-user-select:none;-moz-user-select:none;user-select:none;z-index:10;position:relative;display:flex;width:100%;justify-content:space-between;align-items:center}.sidebar-search-key[data-v-4c6e9e93]{text-transform:uppercase;background-color:var(--scalar-background-2);padding:3px 5px;margin:2px;border-radius:var(--scalar-radius);color:var(--scalar-sidebar-color-2, var(--scalar-color-2))}.scalar-search-icon[data-v-4c6e9e93]{padding:0;margin-right:6px;flex-shrink:0;width:12px;height:12px}.references-mobile-header[data-v-b5fb4b8b]{display:none;align-items:center;height:100%;width:100%;padding:0 8px;background:var(--scalar-background-1);border-bottom:1px solid var(--scalar-border-color)}.references-mobile-breadcrumbs[data-v-b5fb4b8b]{flex:1;min-width:0;font-size:var(--scalar-small);font-weight:var(--scalar-semibold);color:var(--scalar-color-1);overflow:hidden;white-space:nowrap;text-overflow:ellipsis}.references-mobile-header-actions[data-v-b5fb4b8b]{display:flex;flex-direction:row;gap:4px;height:24px;align-items:center;padding-left:4px}@media (max-width: 1000px){.references-mobile-header[data-v-b5fb4b8b]{display:flex}}@media (max-width: 1000px){.scalar-api-references-standalone-mobile{--scalar-header-height: 50px}}.scalar-api-references-standalone-search[data-v-b89dd3cb]{display:flex;flex-direction:column;padding:12px 12px 6px}.darklight-reference[data-v-b89dd3cb]{width:100%;margin-top:auto}@layer scalar-base{body{margin:0;background-color:var(--scalar-background-1)}}\n"))
              document.head.appendChild(elementStyle)

              console.warn('Auto-loading the references css through js has been deprecated. Please import the css directly. Visit https://github.com/scalar/scalar for more info.')
            }, 0)

          } catch (error) {
            console.error(error, 'unable to concat style inside the bundled file')
          }
        })()