import type { Operation } from '@scalar/oas-utils/entities/spec';
import { XScalarStability } from '@scalar/types/legacy';
/**
 * Returns if an operation is considered deprecated.
 */
export declare function isOperationDeprecated(operation: Pick<Operation, 'deprecated' | 'x-scalar-stability'>): boolean;
/**
 * Get operation stability.
 */
export declare function getOperationStability(operation: Pick<Operation, 'deprecated' | 'x-scalar-stability'>): XScalarStability | undefined;
/**
 * Get Operation stability color
 */
export declare function getOperationStabilityColor(operation: Pick<Operation, 'deprecated' | 'x-scalar-stability'>): string;
//# sourceMappingURL=operation.d.ts.map