import type { ApiReferencePlugin as OriginalApiReferencePlugin, SpecificationExtension } from '@scalar/types/api-reference';
export type ApiReferencePlugin = OriginalApiReferencePlugin;
type CreatePluginManagerParams = {
    plugins?: ApiReferencePlugin[];
};
/**
 * Create the plugin manager store
 *
 * This store manages all plugins registered with the API client
 */
export declare const createPluginManager: ({ plugins }: CreatePluginManagerParams) => {
    /**
     * Get all extensions with the given name from registered plugins
     */
    getSpecificationExtensions: (name: `x-${string}`) => SpecificationExtension[];
};
export type PluginManager = ReturnType<typeof createPluginManager>;
export {};
//# sourceMappingURL=plugin-manager.d.ts.map