import { type AnyApiReferenceConfiguration, type ApiReferenceConfiguration } from '@scalar/types/api-reference';
import { type App } from 'vue';
/**
 * Reading the configuration from the data-attributes.
 */
export declare function getConfigurationFromDataAttributes(doc: Document): ApiReferenceConfiguration;
/**
 * Mount the Scalar API Reference on a given document.
 * Read the HTML data-attributes for configuration.
 */
export declare function findDataAttributes(doc: Document, configuration: ApiReferenceConfiguration): void;
export declare const createContainer: (doc: Document, element?: Element | null) => Element | null;
export type ApiReferenceInstance = {
    /** The vue app instance */
    app: App<Element>;
    /** Destroy the current API Reference instance */
    destroy: () => void;
    /** Get the current configuration[s] */
    getConfiguration: () => AnyApiReferenceConfiguration;
    /** Update all configuration[s] */
    updateConfiguration: (newConfig: AnyApiReferenceConfiguration) => void;
};
/** Function overload for createApiReference to allow multiple different signatures */
export type CreateApiReference = {
    /** Pass in the configuration only */
    (configuration: AnyApiReferenceConfiguration): ApiReferenceInstance;
    /** Pass in the element or selector and configuration */
    (elementOrSelector: Element | string, configuration: AnyApiReferenceConfiguration): ApiReferenceInstance;
};
/**
 * Create (and mount) a new Scalar API Reference
 *
 * @example createApiReference({ url: '/scalar.json' }).mount('#app')
 * @example createApiReference('#app', { url: '/scalar.json' })
 * @example createApiReference(document.getElementById('app'), { url: '/scalar.json' })
 *
 */
export declare const createApiReference: CreateApiReference;
//# sourceMappingURL=html-api.d.ts.map